<?php

/**
 * Created by PhpStorm.
 * User: sam
 * Date: 1/11/2017
 * Time: 12:40 PM
 */
class Common_model extends CI_Model
{
    /*
     * Construct
     */
	public function __construct()
    {
        parent::__construct();
    }

	public function getPreviousJobDetail($rec_id){
		$this->db->select('post_job.*, COUNT(applied_job_emp.job_id) as number_of_response');
		$this->db->from('post_job');
		$this->db->join('applied_job_emp', 'post_job.id = applied_job_emp.job_id', 'left');
		$this->db->where('post_job.created_by', $rec_id);
		$this->db->group_by('post_job.id');
		$this->db->order_by('post_job.id', 'DESC');
		return $this->db->get()->result_array();
	}
	
	public function getShortlistedEmployees($rec_id){
		$data=$this->db->select('employee.id, employee.c_name')
						 ->from('shortlisted_emp')
						 ->join('employee', 'shortlisted_emp.emp_id = employee.id', 'left')
						 ->where('shortlisted_emp.rec_id', $rec_id)
						 ->get()
						 ->result();
		return $data;
	}
	
	public function getEmployees($filters, $limit, $offset){
		$qry = "SELECT C.*, D.p_job_roles, D.t_exp_yr, D.t_exp_month, D.eng, D.p_e_type, D.eTYpe, 
				D.Objective, D.skills, D.p_sal_L, D.p_sal_T, E.highestQual, E.gender
				FROM employee C
				LEFT JOIN career_preferences D ON C.id = D.created_by
				LEFT JOIN post_job pj ON pj.created_by = D.created_by
				LEFT JOIN basic_detail E ON C.id = E.created_by
				WHERE C.status = 0 {$filters['edu']} {$filters['eng']} {$filters['exp']} 
				{$filters['jType']} {$filters['eTYpe']} {$filters['age']} {$filters['skills']} 
				{$filters['search_jobTitle']} {$filters['search_jobPost']} {$filters['j_profile11']}
				LIMIT $limit OFFSET $offset";

		return $this->db->query($qry)->result_array();
	}
	
	public function getTotalEmployees($filters)
	{
		$qry = "SELECT COUNT(*) as total FROM employee C
				LEFT JOIN career_preferences D ON C.id = D.created_by
				LEFT JOIN post_job pj ON pj.created_by = D.created_by
				LEFT JOIN basic_detail E ON C.id = E.created_by
				WHERE C.status = 0 {$filters['edu']} {$filters['eng']} {$filters['exp']} 
				{$filters['jType']} {$filters['eTYpe']} {$filters['age']} 
				{$filters['skills']} {$filters['search_jobTitle']} 
				{$filters['search_jobPost']} {$filters['j_profile11']}";

		return $this->db->query($qry)->row_array()['total'];
	}

	public function getEmployeesListing($conditions, $limit, $offset){
		$date = date("Y-m-d");
		$qry = "SELECT 
					TIMESTAMPDIFF(YEAR, E.c_dob, '$date') AS age,
					C.*, 
					D.p_job_roles, 
					D.t_exp_yr, 
					D.t_exp_month, 
					D.eng, 
					D.p_e_type, 
					D.eTYpe, 
					E.highestQual, 
					E.gender, 
					D.skills, 
					D.p_sal_L, 
					D.p_sal_T, 
					D.Objective 
				  FROM employee C
				  LEFT JOIN career_preferences D ON C.id = D.created_by
				  LEFT JOIN basic_detail E ON C.id = E.created_by
				  WHERE C.status = 0 $conditions
				  ORDER BY C.id DESC
				  LIMIT $offset, $limit";

		return $this->db->query($qry)->result_array();
	}
	
	public function getTotalEmployeesLisitng($conditions)
	{
		$qry = "SELECT COUNT(*) AS total_records
						FROM employee C
						LEFT JOIN career_preferences D ON C.id = D.created_by
						LEFT JOIN basic_detail E ON C.id = E.created_by
						WHERE C.status = 0 $conditions";

		return $this->db->query($qry)->row()->total_records;
	}


}
