<?php if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}


function convert_jpg_to_webp_old($source, $destination) {
      
        try {
            $image = new Imagick($source);
            $image->setImageFormat('webp');

            // Adjust the quality if necessary (0 to 100)
            $image->setImageCompressionQuality(80);

            // Write the image to the destination path
            $image->writeImage($destination);

            // Clear resources
            $image->clear();
            $image->destroy();

            return true;
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            return false;
    }
}

function convert_image_to_webp($source, $destination)
{
    try {
        $image = new Imagick($source);

        // Check image type compatibility
        if (!$image->valid()) {
            log_message('error', 'Invalid image type.');
            return false;
        }

        // Convert to WebP
        $image->setImageFormat('webp');
        $image->setImageCompressionQuality(80);  // Adjust quality if needed
        $image->writeImage($destination);

        // Clean up
        $image->clear();
        $image->destroy();

        return true;
    } catch (ImagickException $e) {
        log_message('error', 'Imagick error: ' . $e->getMessage());
        return false;
    } catch (Exception $e) {
        log_message('error', 'General error: ' . $e->getMessage());
        return false;
    }
}

function convert_to_webp($source, $destination)
{
    try {
        $image = new Imagick($source);

        // Check image type compatibility
        if (!$image->valid()) {
            log_message('error', 'Invalid image type.');
            return false;
        }

        // Convert to WebP
        $image->setImageFormat('webp');
        $image->setImageCompressionQuality(80);  // Adjust quality if needed
        $image->writeImage($destination);

        // Clean up
        $image->clear();
        $image->destroy();

        return true;
    } catch (ImagickException $e) {
        log_message('error', 'Imagick error: ' . $e->getMessage());
        return false;
    } catch (Exception $e) {
        log_message('error', 'General error: ' . $e->getMessage());
        return false;
    }
}



function get_state($id) {
	$CI = &get_instance();
	$CI->db->select('state_title');
	$CI->db->from('state');
	$CI->db->where('state_id', $id);
	$return = $CI->db->get()->row();
	if (!empty($return->state_title)) {
		return $return->state_title;
	} else {
		return "NA";
	}
}

function timeAgo($datetime) {
    $now = new DateTime;
    $ago = new DateTime($datetime);
    $diff = $now->diff($ago);

    if ($diff->y > 0) {
        return $diff->y . " year" . ($diff->y > 1 ? "s" : "") . " ago";
    } elseif ($diff->m > 0) {
        return $diff->m . " month" . ($diff->m > 1 ? "s" : "") . " ago";
    } elseif ($diff->d > 0) {
        return $diff->d . " day" . ($diff->d > 1 ? "s" : "") . " ago";
    } elseif ($diff->h > 0) {
        return $diff->h . " hour" . ($diff->h > 1 ? "s" : "") . " ago";
    } elseif ($diff->i > 0) {
        return $diff->i . " minute" . ($diff->i > 1 ? "s" : "") . " ago";
    } else {
        return "Just now";
    }
}
function get_district($id) {
	$CI = &get_instance();
	$CI->db->select('district_title');
	$CI->db->from('district');
	$CI->db->where('districtid', $id);
	$return = $CI->db->get()->row();
	if (!empty($return->district_title)) {
		return $return->district_title;
	} else {
		return "NA";
		
	}
}


function get_company($id) {
	$CI = &get_instance();
	$CI->db->select('about_com.*');
	$CI->db->from('employer');
	$CI->db->join('about_com', 'about_com.created_by = employer.id', 'left');
	$CI->db->where('employer.id', $id);
	$return = $CI->db->get()->row();
	if (!empty($return)) {
		return $return;
	} else {
		return "NA";
		
	}
}


function getEmp_info($id) {
	$CI = &get_instance();
	$CI->db->select('career_preferences.*,basic_detail.*,career_preferences.eng as eng_m');
	$CI->db->from('career_preferences');
	$CI->db->join('basic_detail', 'career_preferences.created_by = basic_detail.created_by', 'left');
	
	$CI->db->where('career_preferences.created_by', $id);
	$return = $CI->db->get()->row();
	if (!empty($return)) {
		return $return;
	} else {
		return "NA";
		
	}
}





function getEmp_dob($id) {
	$CI = &get_instance();
	$CI->db->select('c_dob');
	$CI->db->from('basic_detail');
	
	$CI->db->where('created_by', $id);
	$return = $CI->db->get()->row();
	if (!empty($return->c_dob)) {
		return $return->c_dob;
	} else {
		return "";
		
	}
}


function first_msg_frm_user($id , $rec_id) {
	$CI = &get_instance();
	$CI->db->select('msg,created_at');
	$CI->db->from('chatbox_msg');
	$CI->db->where('created_by_em', $id);
	$CI->db->where('rec_id', $rec_id);
	$CI->db->order_by("id", "asc");
	$CI->db->limit(1);
	// prx($rec_id) ;
	$return = $CI->db->get()->row();
	if (!empty($return->msg)) {
		return $return;
	} else {
		return "NA";
		
	}
}



function user_logo($id) {
	$CI = &get_instance();
	$CI->db->select('uploadPic');
	$CI->db->from('basic_detail');
	
	$CI->db->where('created_by', $id);
	$return = $CI->db->get()->row();
	if (!empty($return->uploadPic)) {
		return $return->uploadPic;
	} else {
		return "NA";
		
	}
}





function all_msgs($id , $rec_id) {
	$CI = &get_instance();
	$CI->db->select('*');
	$CI->db->from('chatbox_msg');
	$CI->db->where('ee_id', $id);
	$CI->db->where('rec_id', $rec_id);
	$CI->db->order_by("id", "desc");
	$CI->db->limit(50);
	$query = $CI->db->get();
	$return = $query->result();
	if (!empty($return)) {
		return $return;
	} else {
		return "NA";
		
	}
}





function appendNewMsg($id , $rec_id , $last_msg) {
	$CI = &get_instance();
	$CI->db->select('*');
	$CI->db->from('chatbox_msg');
	$CI->db->where('ee_id', $id);
	$CI->db->where('rec_id', $rec_id);

	$CI->db->where('id >', $last_msg);

	$CI->db->order_by("id", "desc");
	$CI->db->limit(50);
	$query = $CI->db->get();
	$return = $query->result();
	if (!empty($return)) {
		return $return;
	} else {
		return "";
		
	}
}

function prx($pri) {
	$CI = &get_instance();
echo '<pre>';
        print_r($pri);
        echo '</pre>';
        die;
}


function sendNotification_neww($token,$body,$title,$click_action,$icon){
   // $url="https://fcm.googleapis.com/v1/projects/bitsmultiservice/messages:send";
   $url="https://asatvindia.in:5001/api/notification";

    $fields=array(
            "message"=>array("token"=>$token,
            "notification"=>array(
                "body"=>$body,
                "title"=>$title,
             ),
             "webpush"=>array("fcm_options"=>array('link'=>$click_action),
             "notification"=>array('icon'=>$icon),
             ),
            )
        );
       
    
    $headers=array(
        'Content-Type:application/json'
    );

    $ch=curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($fields));
    $result=curl_exec($ch);
    //print_r($result);
    curl_close($ch);
}


////////////

function sendNotification($token,$body,$title,$click_action,$icon){
   // $url="https://fcm.googleapis.com/v1/projects/bitsmultiservice/messages:send";
   $url="https://asatvindia.in:5001/api/notification";

    $fields=array(
            "message"=>array("token"=>$token,
            "notification"=>array(
                "body"=>$body,
                "title"=>$title,
             ),
             "webpush"=>array("fcm_options"=>array('link'=>$click_action),
             "notification"=>array('icon'=>$icon),
             ),
            )
        );
       
    
    $headers=array(
        'Content-Type:application/json'
    );

    $ch=curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($fields));
    $result=curl_exec($ch);
    //print_r($result);
    curl_close($ch);
}


function sendNotificationapp($token,$body,$title,$notificaton_id,$app_url,$channel_id,$common){
    //$url="https://fcm.googleapis.com/v1/projects/bitsmultiservice/messages:send";
    $url="https://asatvindia.in:5001/api/notification";
    
    $fields=array(
            "message"=>array("token"=>$token,
              "data"=>array(
                       "notificaton_id"=>(string)$notificaton_id,
                       "title"=>$title,
                       "body"=>$body,
                       "channel_id"=>$channel_id,
                       "url"=>$app_url,
                       "user_type"=> "employee",
                       "common"=>$common,
                       )
            )
        );
    
    
    $headers=array(
        'Content-Type:application/json'
    );

    $ch=curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($fields));
    $result=curl_exec($ch);
    // print_r($result);
    // exit;
    curl_close($ch);
}




function emp_url() {
	$CI = &get_instance();
	$return = 'https://jobkaro.in/';
	// print_r($xxxxx);
	// echo'</pre>';
	return $return;
}