<?php
defined('BASEPATH') OR exit('No direct script access allowed');

	if (!function_exists('convert_to_webp')) {
		function convert_to_webp($source, $destination, $quality = 80) {
			$image_info = getimagesize($source);
			$mime = $image_info['mime'];

			switch ($mime) {
				case 'image/jpeg':
					$image = imagecreatefromjpeg($source);
					break;
				case 'image/png':
					$image = imagecreatefrompng($source);
					imagepalettetotruecolor($image); // For better compression
					imagealphablending($image, true);
					imagesavealpha($image, true);
					break;
				case 'image/gif':
					$image = imagecreatefromgif($source);
					break;
				default:
					return false; // Unsupported image type
			}

			$result = imagewebp($image, $destination, $quality);
			imagedestroy($image); // Free memory

			return $result;
		}
    }
	if (!function_exists('inputJson')) {
		function inputJson(){
			$inputJSON = file_get_contents('php://input');
			$inputJSON = preg_replace('/,(\s*[\}\]])/', '$1', $inputJSON);
			$input = json_decode($inputJSON, true);

			if (json_last_error() !== JSON_ERROR_NONE || !is_array($input)) {
				outputJSON(400, 'error', 'Invalid JSON input.');
				return;
			}
			return array_map('trim', $input); 
		}
	}
	
	if (!function_exists('checkValidation')) {
		 function checkValidation($input,$rules){
			$CI = &get_instance();
			if (!isset($CI->form_validation)) {
				$CI->load->library('form_validation');
			}
			$CI->form_validation->set_data($input);
			$CI->form_validation->set_rules($rules);

			if (!$CI->form_validation->run()) {
				outputJSON(400, 'error', 'Validation failed.', $CI->form_validation->error_array());
				return;
			}
		}
	}
	 
	 if (!function_exists('outputJSON')) {
		function outputJSON($statusCode, $status, $message, $data = null)
		{
			$CI = &get_instance();
			$response = array(
				'status' => $status,
				'status_code' => $statusCode,
				'message' => $message,
			);
			if (!empty($data)) {
				$response['data'] = $data;
			}else{
				$response['data'] = null;
			}
			$CI->output
				->set_content_type('application/json')
				->set_status_header($statusCode)
				->set_output(json_encode($response))
				->_display();
			exit;
		}
	}

