<?php
defined('BASEPATH') or exit('No direct script access allowed');


class JobController extends CI_Controller {
    public function __construct()
	{
	    parent::__construct();
	    $this->load->model('lib_model');  
	    $this->load->helper('new');  
	    $this->load->helper('common');  
	    $this->load->helper('date');  
		
		$this->output
             ->set_content_type('application/json', 'utf-8')
             ->set_header('Access-Control-Allow-Origin: *')
             ->set_header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE')
             ->set_header('Access-Control-Allow-Headers: Content-Type, Authorization');
		
		$sql =  "SELECT * FROM hiring_api_auth";
		$api_auth= $this->lib_model->Execute($sql, array())->row_array();
		if(isset($_SERVER['PHP_AUTH_USER']) and isset($_SERVER['PHP_AUTH_PW'])){
			if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
			{
				outputJSON(400, 'error', 'Authentication failed');
				return;
			}
	    }else{
			outputJSON(400, 'error', 'Authentication Username and password not set');
			return;
		}

	}
	
	////   Job Post Api ////
	public function submit_job()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson(); 

		$rules = [
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|trim'],
			['field' => 'title', 'label' => 'Job Title', 'rules' => 'required|trim|min_length[3]'],
			['field' => 'no_opening', 'label' => 'Number of opening', 'rules' => 'required|trim|numeric'],
			['field' => 'c_eng', 'label' => 'communication skill', 'rules' => 'required|trim'],
			['field' => 'emp_type', 'label' => 'Employee type', 'rules' => 'required|trim'],
			['field' => 'job_type', 'label' => 'Job type', 'rules' => 'required|trim'],
			['field' => 'shift', 'label' => 'Shift', 'rules' => 'required|trim'],
			['field' => 'experience', 'label' => 'Experience', 'rules' => 'required|trim'],
			['field' => 'qualification', 'label' => 'Qualification', 'rules' => 'required|trim'],
			['field' => 'min_salary', 'label' => 'Min salary', 'rules' => 'required|trim|numeric'],
			['field' => 'max_salary', 'label' => 'Max salary', 'rules' => 'required|trim|numeric'],
			['field' => 'job_description', 'label' => 'Job Description', 'rules' => 'required|trim'],
			['field' => 'skills', 'label' => 'Skills', 'rules' => 'required|trim'],
			['field' => 'day_from', 'label' => 'day from', 'rules' => 'required|trim'],
			['field' => 'day_to', 'label' => 'day to', 'rules' => 'required|trim'],
		];
		

		checkValidation($input,$rules);
	 
		$check = $this->db->get_where('about_com', ['created_by' => $input['rec_id']])->num_rows();

		if ($check==0) {
			outputJSON(404, 'error', 'Please fill company profile details first.');
			return;
		}
		// if (!empty($_FILES['image']['name'])) {
			// $this->load->library('upload');
			// $config['upload_path'] = './jobimage/';
			// $config['allowed_types'] = 'jpg|jpeg|png|gif'; 
			// $config['max_size'] = 2048; 
			// $config['file_name'] = uniqid() . '_' . $_FILES['image']['name'];

			// $this->upload->initialize($config);

			// if (!$this->upload->do_upload('image')) {
				// outputJSON(400, 'error', 'Image upload failed: ' . $this->upload->display_errors('', ''));
				// return;
			// }

			// $uploadData = $this->upload->data();
			// $imagePath = $uploadData['file_name'];
		// } else {
			// $imagePath = null;
		// }
		$about = $this->lib_model->Select('about_com', '*', array('created_by' => $input['rec_id'] ));

		$state = $about[0]->state  ;
		$district = $about[0]->District ;
		$city = $about[0]->city ;
		$zip = $about[0]->zip ;
		$address = $about[0]->adress ;
		$data=[
			'jTitle' => $input['title'],
			'nOpen'=>$input['no_opening'],
			'state'=> $state ,
			'District'=> $district,
			'city' => $city,
			'zip'=> $zip,
			'adress'=> $address,
			'c_eng'=>$input['c_eng'],
			'emp_type'=>$input['emp_type'],
			'jobtype'=>$input['job_type'],
			'shift'=>$input['shift'],
			'experience'=>$input['experience'],
			'quali'=>$input['qualification'],
			'sMin' => $input['min_salary'],
			'sMax'=>$input['max_salary'],
			'jobDescription'=>$input['job_description'],
			'skills'=>$input['skills'],
			'dayFrom'=>$input['day_from'],
			'dayTo'=>$input['day_to'],
			'created_by'=>$input['rec_id'],
			// 'job_image'=>$imagePath,
		];
		
		if(empty($input['edit_id'])){
			$res = $this->lib_model->Insert('post_job', $data);
			if($res){
				outputJSON(201, 'success', 'Job created successfully');
			} else {
				outputJSON(500, 'error', 'Failed to create job. Please try again.');
			}
		}else{
			$res=$this->lib_model->Update('post_job', $data, array('id'=>$input['edit_id']));
			if($res){
				outputJSON(200, 'success', 'Job edited successfully');
			} else {
				outputJSON(500, 'error', 'Failed to edit job. Please try again.');
			}
		}
		
	}
	
	


   
}