<?php
defined('BASEPATH') or exit('No direct script access allowed');


class CommonController extends CI_Controller {
    public function __construct()
	{
	    parent::__construct();
	    $this->load->model('lib_model');  
	    $this->load->model('common_model');  
	    $this->load->helper('new');  
	    $this->load->helper('common');  
	    $this->load->helper('date');   
		
		$this->output
             ->set_content_type('application/json', 'utf-8')
             ->set_header('Access-Control-Allow-Origin: *')
             ->set_header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE')
             ->set_header('Access-Control-Allow-Headers: Content-Type, Authorization');
		
		$sql =  "SELECT * FROM hiring_api_auth";
		$api_auth= $this->lib_model->Execute($sql, array())->row_array();
		if(isset($_SERVER['PHP_AUTH_USER']) and isset($_SERVER['PHP_AUTH_PW'])){
			if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
			{
				outputJSON(400, 'error', 'Authentication failed');
				return;
			}
	    }else{
			outputJSON(400, 'error', 'Authentication Username and password not set');
			return;
		}

	}

	public function submit_about_company()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		// $input = inputJson(); 
		$input = $this->input->post();

		$rules = [
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|trim'],
			['field' => 'name', 'label' => 'Company name', 'rules' => 'required|trim|min_length[3]'],
			['field' => 'c_type', 'label' => 'company type', 'rules' => 'required|trim'],
			['field' => 'number', 'label' => 'Company number', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'email', 'label' => 'company email', 'rules' => 'required|trim|valid_email'],
			['field' => 'r_name', 'label' => 'r name', 'rules' => 'required|trim'],
			['field' => 'r_mobile', 'label' => 'r mobile', 'rules' => 'required|trim'],
			['field' => 'r_desig', 'label' => 'r desig', 'rules' => 'required|trim'],
			['field' => 'c_desc', 'label' => 'company description', 'rules' => 'required|trim'],
			['field' => 'c_gst', 'label' => 'cgst', 'rules' => 'required|trim'],
			['field' => 'n_emp', 'label' => 'no. of employees', 'rules' => 'required|trim|numeric'],
			['field' => 'address', 'label' => 'address', 'rules' => 'required|trim'],
			['field' => 'link', 'label' => 'website link', 'rules' => 'required|trim'],
			['field' => 'city', 'label' => 'city', 'rules' => 'required|trim'],
			['field' => 'state', 'label' => 'state', 'rules' => 'required|trim'],
			['field' => 'district', 'label' => 'district', 'rules' => 'required|trim'],
			['field' => 'zip', 'label' => 'pincode', 'rules' => 'required|trim|numeric'],
			['field' => 'doc_type', 'label' => 'document type', 'rules' => 'required|trim'],
		];
		

		checkValidation($input,$rules);
	 
		
		if (!empty($_FILES["c_logo"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["c_logo"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'documents/';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('c_logo')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$logo = $upload_data['raw_name'] . '.webp'; 
					} else {
						$logo = $file_name_c_logo;
					}
				} else {
					$logo = $file_name_c_logo;
				}
			} else {
				$error = $this->upload->display_errors('', '');
				outputJSON(413, 'error', $error);
				return;
			}
		} else {
			$logo = '';
		}
		if (!empty($_FILES["documents"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["documents"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'documents/';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 5120;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('documents')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path'];

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp'; 
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$doc = $upload_data['raw_name'] . '.webp'; 
					} else {
						$doc = $file_name_c_logo; 
					}
				} else {
					$doc = $file_name_c_logo; 
				}
			} else {
				$error = $this->upload->display_errors('', ''); 
				outputJSON(413, 'error', $error);
				return;
			}
		} else {
			$doc = '';
		}
		
		$check = $this->db->get_where('about_com', ['created_by' => $input['rec_id']])->num_rows();
		
		
		$data=[
			'name' => $_POST['name'],
			'com_type' => $_POST['c_type'],
			'number'=>$_POST['number'],
			'email'=>$_POST['email'],
			'r_name'=>$_POST['r_name'],
			'r_mobile' => $_POST['r_mobile'],
			'r_desig'=>$_POST['r_desig'],
			'c_desc'=>$_POST['c_desc'],
			'c_gst'=>$_POST['c_gst'],
			'n_emp'=>$_POST['n_emp'],
			'adress' => $_POST['address'],
			'link' => $_POST['link'],
			'city'=>$_POST['city'],
			'state'=>$_POST['state'],
			'zip'=>$_POST['zip'],
			'District'=>$_POST['district'],
			'doc_type'=>$_POST['doc_type'],
			'created_by'=>$_POST['rec_id'],
		];
		
		if ($check) {
			if (!empty($_FILES["documents"]['name'])) {
				$data['documents'] = $doc;
			}
			if (!empty($_FILES["c_logo"]['name'])) {
				$data['c_logo'] = $logo;
			}
			$res=$this->lib_model->Update('about_com', $data, array('created_by'=>$input['rec_id']));
			if($res){
				outputJSON(200, 'success', 'About company edited successfully');
			} else {
				outputJSON(500, 'error', 'Failed to edit job. Please try again.');
			}
		}else{
			$data['documents'] = $doc;
			$data['c_logo'] = $logo;
			$res = $this->lib_model->Insert('about_com', $data);
			if($res){
				outputJSON(201, 'success', 'About company created successfully');
			} else {
				outputJSON(500, 'error', 'Failed to create job. Please try again.');
			}
		}
		
	}
	
	public function get_about_company()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.'); 
			return;
		}
		$input = inputJson();
		$rec_id = $input['rec_id'] ?? null;

		if (empty($rec_id)) {
			outputJSON(400, 'error', 'Recruiter ID (rec_id) is required.');
			return;
		}
		$company_data = $this->db->get_where('about_com', ['created_by' => $rec_id])->row_array();

		if (empty($company_data)) {
			outputJSON(404, 'error', 'No company data found for the provided Recruiter ID.');
			return;
		}
		outputJSON(200, 'success', 'Company data fetched successfully.', $company_data);
	}
	
	public function get_applied_candidate()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.'); 
			return;
		}
		$input = inputJson();
		$job_id = $input['job_id']?? null;

		if (empty($job_id)) {
			outputJSON(400, 'error', 'Job ID (job_id) is required.');
			return;
		}

		$this->db->select('employee.*, applied_job_emp.id AS app_id');
		$this->db->from('applied_job_emp');
		$this->db->join('employee', 'applied_job_emp.emp_id = employee.id');
		$this->db->where('applied_job_emp.job_id', $job_id);
		$this->db->order_by('applied_job_emp.id', 'DESC');
		
		$data = $this->db->get()->result();
		if (!empty($data)) {
			outputJSON(200, 'success', 'Data found',$data); 
		} else {
			outputJSON(200, 'success', 'No candidates found for this job',[]); 
		}
	}

	public function get_previous_job_detail()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$rec_id = $input['rec_id'] ?? null;

		if (empty($rec_id)) {
			outputJSON(400, 'error', 'Recruiter ID (rec_id) is required.');
			return;
		}
		$data=$this->common_model->getPreviousJobDetail($rec_id);

		if (!empty($data)) {
			outputJSON(200, 'success', 'Previous job details fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No data available for the provided Recruiter ID.');
		}
	}
	
	public function get_shortlisted_employees()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$rec_id = $input['rec_id'] ?? null;
		if (empty($rec_id)) {
			outputJSON(400, 'error', 'Recruiter ID (rec_id) is required.');
			return;
		}
		$data=$this->common_model->getShortlistedEmployees($rec_id);
		if (!empty($data)) {
			outputJSON(200, 'success', 'Shortlisted employees fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No shortlisted employees found for the provided Recruiter ID.');
		}
	} 

	public function recruiter_employee_details_search()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
 
		$input = inputJson();
		$rec_id = $input['rec_id'] ?? null;

		if (empty($rec_id)) {
			outputJSON(400, 'error', 'Recruiter ID (rec_id) is required.');
			return;
		}

		$page = $input['page'] ?? 1;
		$limit = $input['limit'] ?? 10;
		$offset = ($page - 1) * $limit;

		$date = date("Y-m-d");
		$filters = $this->buildFilters($input, $date);

		$result = $this->common_model->getEmployees($filters, $limit, $offset);
		$total_records = $this->common_model->getTotalEmployees($filters);
		$total_pages = ceil($total_records / $limit); 

		if (!empty($result)) {
			$employees = [];
			foreach ($result as $row) {
				$employees[] = [
					'id' => $row['id'],
					'c_name' => $row['c_name'],
					'c_email' => $row['c_email'],
					'c_contact' => $row['c_contact'],
					'c_pas' => $row['c_pas'],
					'designation' => $row['designation'],
					'resume' => $row['resume'],
					'english' => $row['english'],
					'experience' => $row['experience'],
					'skills_old' => $row['skills_old'],
					'gender' => $row['gender'],
					'age' => $row['age'],
					'status' => $row['status'],
					'p_job_roles' => $row['p_job_roles'],
					't_exp_yr' => $row['t_exp_yr'],
					't_exp_month' => $row['t_exp_month'],
					'eng' => $row['eng'],
					'p_e_type' => $row['p_e_type'],
					'eTYpe' => $row['eTYpe'],
					'skills' => $row['skills'],
					'p_sal_L' => $row['p_sal_L'],
					'p_sal_T' => $row['p_sal_T'],
					'highestQual' => $row['highestQual'],
					'Objective' => $row['Objective'],
					'log_in_time' => date('d M, Y   H:i A', strtotime($row['log_in_time'])),
					'created_at' => date('d M, Y   H:i A', strtotime($row['created_at'])),
				];
			}

			$response = [
				'current_page' => $page,
				'total_pages' => $total_pages,
				'total_records' => $total_records,
				'employees' => $employees,
			];

			outputJSON(200, 'success', 'Employee details fetched successfully.', $response);
		} else {
			outputJSON(200, 'success', 'No employees found for the provided criteria.', [
				'current_page' => $page,
				'total_pages' => $total_pages,
				'total_records' => $total_records,
				'employees' => [],
			]);
		}
	}


	private function buildFilters($input, $date)
	{
		$filters = [
			'edu' => '',
			'eng' => '',
			'exp' => '',
			'jType' => '',
			'eTYpe' => '',
			'age' => '',
			'skills' => '',
			'search_jobTitle' => '',
			'search_jobPost' => '',
			'j_profile11' => ''
		];

		if (!empty($input['education'])) {
			$filters['edu'] = "AND E.highestQual = '{$input['education']}'";
		}

		if (!empty($input['english'])) {
			$filters['eng'] = "AND D.eng = '{$input['english']}'";
		}

		if (!empty($input['exp'])) {
			$filters['exp'] = $this->getExperienceFilter($input['exp']);
		}

		if (!empty($input['jType'])) {
			$filters['jType'] = "AND D.p_e_type = '{$input['jType']}'";
		}

		if (!empty($input['eTYpe'])) {
			$filters['eTYpe'] = "AND D.eTYpe = '{$input['eTYpe']}'";
		}

		if (!empty($input['age'])) {
			$filters['age'] = $this->getAgeFilter($input['age'], $date);
		}

		if (!empty($input['skills'])) {
			$filters['skills'] = "AND D.skills LIKE '%{$input['skills']}%'";
		}

		if (!empty($input['search_jobTitle'])) {
			$filters['search_jobTitle'] = "AND D.p_job_roles LIKE '%{$input['search_jobTitle']}%'";
		}

		if (!empty($input['post_job'])) {
			$filters['search_jobPost'] = "AND pj.jTitle LIKE '%{$input['post_job']}%'";
		}

		if (!empty($input['j_profile'])) {
			$filters['j_profile11'] = "AND D.p_job_roles LIKE '%{$input['j_profile']}%'";
		}

		return $filters;
	}

	private function getExperienceFilter($exp)
	{
		switch ($exp) {
			case 'fresher':
				return "AND D.t_exp_yr < 1";
			case '1to3':
				return "AND D.t_exp_yr BETWEEN 1 AND 3";
			case '3to5':
				return "AND D.t_exp_yr BETWEEN 3 AND 5";
			case 'moreThan5':
				return "AND D.t_exp_yr > 5";
			default:
				return '';
		}
	}

	private function getAgeFilter($age, $date)
	{
		switch ($age) {
			case '18to25':
				return "AND (TIMESTAMPDIFF(YEAR, E.c_dob, '$date') BETWEEN 18 AND 25)";
			case '25to40':
				return "AND (TIMESTAMPDIFF(YEAR, E.c_dob, '$date') BETWEEN 25 AND 40)";
			case '40to50':
				return "AND (TIMESTAMPDIFF(YEAR, E.c_dob, '$date') BETWEEN 40 AND 50)";
			default:
				return '';
		}
	}
	
	
	public function get_employee_details()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$emp_id = $input['emp_id'] ?? null;
		$rec_id = $input['rec_id'] ?? null;
		$job_id = $input['job_id'] ?? null;
		$page = $input['page'] ?? 1; // Default to page 1 if not provided
		$limit = $input['limit'] ?? 10; // Default to 10 records per page if not provided
		$offset = ($page - 1) * $limit;

		// Initialize filter conditions
		$conditions = '';
		if (!empty($emp_id)) {
			$conditions .= " AND C.id = $emp_id";
		} elseif (!empty($job_id)) {
			$skills = $this->lib_model->Select('post_job', 'skills', ['id' => $job_id]);
			if (!empty($skills)) {
				$skill_array = explode(',', $skills[0]->skills);
				$skill_conditions = implode(" OR ", array_map(function ($skill) {
					return "D.skills LIKE '%$skill%'";
				}, $skill_array));
				$conditions .= " AND ($skill_conditions)";
			}
		}

		$data=$this->common_model->getEmployeesListing($conditions,$limit,$offset);
		$total_records = $this->common_model->getTotalEmployeesLisitng($conditions);

		if (!empty($data)) {
		
			$response = [
				'current_page' => $page,
				'total_pages' => ceil($total_records / $limit),
				'total_records' => $total_records,
				'employees' => $data,
			];
			
			outputJSON(200, 'success', 'Employee details fetched successfully.',$response);
		} else {
			outputJSON(200, 'success', 'No employee data available.', [
				'current_page' => $page,
				'total_pages' => $total_pages,
				'total_records' => $total_records,
				'employees' => [],
			]);
		}
	}
	
	public function get_rec_highlight()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$rec_id = $input['rec_id'] ?? null;

		if (empty($rec_id)) {
			outputJSON(400, 'error', 'Recruiter ID (rec_id) is required.');
			return;
		}

		$sql_shortlisted = "
			SELECT COUNT(employee.id) AS total_count 
			FROM shortlisted_emp  
			LEFT JOIN employee ON shortlisted_emp.emp_id = employee.id
			WHERE shortlisted_emp.rec_id = ?";
		$shortlisted_data = $this->lib_model->Execute($sql_shortlisted, [$rec_id])->row_array();

		$sql_posted = "
			SELECT COUNT(post_job.id) AS total_posted 
			FROM post_job
			WHERE post_job.created_by = ?";
		$posted_data = $this->lib_model->Execute($sql_posted, [$rec_id])->row_array();

		$data = [
			'total_save_job' => $shortlisted_data['total_count'] ?? 0,
			'total_posted' => $posted_data['total_posted'] ?? 0,
		];

		if (!empty($data)) {
			outputJSON(200, 'success', 'Data found.', $data);
		} else {
			outputJSON(200, 'success', 'No data available for the provided Recruiter ID.', $data);
		}
	} 
	
	public function rec_viewed_by_detail()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$rec_id = $input['rec_id'] ?? null;

		if (empty($rec_id)) {
			outputJSON(400, 'error', 'Recruiter ID (rec_id) is required.');
			return;
		}

		$job_applied = $this->lib_model->all_emp_job_applied($rec_id);
		$job_viewed = $this->lib_model->all_emp_job_viewed($rec_id);

		if (!empty($job_viewed)) {
			foreach ($job_viewed as $job) {
				$update_data = ['view_by_rec' => 1];
				$this->lib_model->Update('emp_view_job', $update_data, ['id' => $job->row_id]);
			}
		}

		if (!empty($job_applied)) {
			foreach ($job_applied as $job) {
				$update_data = ['read_by_rec' => 1];
				$this->lib_model->Update('applied_job_emp', $update_data, ['id' => $job->row_id]);
			}
		}

		if (!empty($job_applied) || !empty($job_viewed)) {
			$response_data = [
				'job_applied' => $job_applied,
				'job_viewed' => $job_viewed
			];
			outputJSON(200, 'success', 'Job details updated and fetched successfully.', $response_data);
		} else {
			outputJSON(200, 'success', 'No data available for the provided Recruiter ID.');
		}
	}
	 
	public function get_rec_data()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$rec_id = $input['rec_id'] ?? null;
		$req_type = $input['req_type'] ?? null;

		if (empty($rec_id) || empty($req_type)) {
			outputJSON(400, 'error', 'Recruiter ID (rec_id) and Request Type (req_type) are required.');
			return;
		}

		$data = [];
		if ($req_type === 'get_number') {
			$data = $this->lib_model->Select('employer', 'c_contact', ['id' => $rec_id]);
		}

		if (!empty($data)) {
			outputJSON(200, 'success', 'Data fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No data available for the provided criteria.');
		}
	}





   
}