<?php
defined('BASEPATH') or exit('No direct script access allowed');


class AuthController extends CI_Controller {
    public function __construct()
	{
	    parent::__construct();
	    $this->load->model('lib_model');  
	    $this->load->helper('new');  
	    $this->load->helper('email');  
	    $this->load->helper('common');  
	    $this->load->helper('date');  
		
		$this->output
             ->set_content_type('application/json', 'utf-8')
             ->set_header('Access-Control-Allow-Origin: *')
             ->set_header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE')
             ->set_header('Access-Control-Allow-Headers: Content-Type, Authorization');
		
		$sql =  "SELECT * FROM hiring_api_auth";
		$api_auth= $this->lib_model->Execute($sql, array())->row_array();
		if(isset($_SERVER['PHP_AUTH_USER']) and isset($_SERVER['PHP_AUTH_PW'])){
			if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
			{
				outputJSON(400, 'error', 'Authentication failed');
				return;
			}
	    }else{
			outputJSON(400, 'error', 'Authentication Username and password not set');
			return;
		}

	}
	
	////   Register Api ////
	public function employer_register()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson(); 

		$rules = [
			['field' => 'name', 'label' => 'Name', 'rules' => 'required|trim|min_length[3]'],
			['field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'],
			['field' => 'mobile', 'label' => 'Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'password', 'label' => 'Password', 'rules' => 'required|trim|min_length[6]']
		];
		checkValidation($input,$rules);
	 
		$checkEmail = $this->db->get_where('employer', ['status' => 0, 'c_email' => $input['email']])->num_rows();

		if ($checkEmail) {
			outputJSON(409, 'error', 'Email already registered.');
			return;
		}
		$checkMobile = $this->db->get_where('employer', ['status' => 0, 'c_contact' => $input['mobile']])->num_rows();

		if ($checkMobile) {
			outputJSON(409, 'error', 'Mobile number already registered.');
			return;
		}

		$userData = [
			'c_name'   => $input['name'],
			'c_email'  => $input['email'],
			'c_contact' => $input['mobile'],
			'c_pas'    => $input['password']
		];
		$id = $this->lib_model->Insert('employer', $userData);

		if ($id) {
			outputJSON(201, 'success', 'Registered Successfully', [
				'id' => $id,
				'name' => $input['name'],
				'email' => $input['email'],
				'mobile' => $input['mobile']
			]);
		} else {
			outputJSON(500, 'error', 'Failed to register. Please try again.');
		}
	}
	
	/// Login Api ///
	
	public function employer_login()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson(); 

		$rules = [
			['field' => 'username', 'label' => 'Email or Mobile Number', 'rules' => 'required|trim|min_length[3]'],
			['field' => 'password', 'label' => 'Password', 'rules' => 'required|trim|min_length[6]']
		];
		checkValidation($input,$rules);
	 
		$valid = $this->db->select('id,c_name,c_email,c_contact,created_at,log_in_time,c_pas')->where('status', 0)->group_start()->where('c_email', $input['username'])->or_where('c_contact', $input['username'])->group_end()->get('employer');
		if ($valid->num_rows()) {
			$data=$valid->row();
			if($data->c_pas==$input['password']){
				$this->lib_model->Update('employer',['log_in_time'=>date('Y-m-d H:i:s')],array('id'=>$data->id));
				outputJSON(200, 'success', 'Login Successfully', $data);
			}else{
				outputJSON(401, 'error', 'The provided password is incorrect.');
			}
		}else{
			outputJSON(404, 'error', 'No user found with the provided email or mobile.');
		}
	}
	
	public function change_password()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$rules = [
			['field' => 'rec_id', 'label' => 'recruiter id', 'rules' => 'required|trim|numeric'],
			['field' => 'old_password', 'label' => 'Old Password', 'rules' => 'required|trim'],
			['field' => 'new_password', 'label' => 'New Password', 'rules' => 'required|trim|min_length[6]']
		];
		checkValidation($input,$rules);
		$rec_id=$input['rec_id'];
		$new_password=$input['new_password'];
		$old_password=$input['old_password'];
		$check = $this->db->select('c_pas')->from('employer')->where('id', $rec_id)->get();
		if($check->num_rows()){
			$data=$check->row();
			if ($data->c_pas === $old_password) {
				$update_data = ['c_pas' => $new_password];
				$this->db->where('id', $rec_id)->update('employer', $update_data);
				if ($this->db->affected_rows() > 0) {
					outputJSON(200, 'success', 'Password successfully changed.');
				} else {
					outputJSON(400, 'error', 'No changes were made to the password.');
				}
			} else {
				outputJSON(400, 'error', 'Old password does not match.');
			}
		}else{
			outputJSON(404, 'error', 'No recruiter found with the provided recruiter ID.');
		}
	}

	public function get_profile_image()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$rec_id = $input['rec_id'] ?? null;

		if (empty($rec_id)) {
			outputJSON(400, 'error', 'Recruiter ID (rec_id) is required.');
			return;
		}

		$query = "SELECT name, c_logo, documents, c_desc FROM about_com WHERE created_by = ?";
		$company_data = $this->db->query($query, [$rec_id])->row_array();

		if (empty($company_data)) {
			outputJSON(200, 'success', 'No company data found for the provided Recruiter ID.');
			return;
		}

		$company_data['c_logo'] = !empty($company_data['c_logo']) 
			? base_url("documents/" . $company_data['c_logo']) 
			: null;

		$company_data['documents'] = !empty($company_data['documents']) 
			? base_url("documents/" . $company_data['documents']) 
			: null;

		outputJSON(200, 'success', 'Company data fetched successfully.', $company_data);
	}


	
	public function send_otp()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
	
		$rules = [
			['field' => 'mobile', 'label' => 'Mobile Number', 'rules' => 'required|trim|numeric|min_length[10]|max_length[10]']
		];
		checkValidation($input, $rules);
		$username=$input['name'] ?? NULL;
		$template = $this->db->where(['status' => '0', 'type' => 'send_otp'])->get('sms_template')->row();
		if (!$template) {
			outputJSON(404, 'error', 'SMS template not found.');
			return;
		}

		$otp = rand(10000, 99999);
		$valid = $this->db->select('id,c_name,c_contact')->where('status', 0)->where('c_contact', $input['mobile'])->get('employer');
		if ($valid->num_rows()) {
			$data=$valid->row();
			$name = str_replace(' ', '', $data->c_name);
		}else{
			$name = str_replace(' ', '', $username) ?: 'User';
		}
		$msg = str_replace(
			['mobile_number', 'user_name', 'otp_now'],
			[$input['mobile'], $name, $otp],
			$template->body
		);

		$db_data = [
			'phone' => $input['mobile'],
			'otp' => $otp,
			'user_id' => $name,
			'added_by_web' => $_SERVER['HTTP_HOST']
		];
		$this->lib_model->Insert('all_otp', $db_data);
		$result = send_text_msg_new(trim($msg));
		if (!$result) {
			outputJSON(200, 'error', 'Failed to send SMS.');
			return;
		}

		outputJSON(200, 'success', 'Otp sent successfully.', ['mobile' => $input['mobile'],'otp' => $otp]);
	}


	public function verify_otp()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'otp', 'label' => 'OTP', 'rules' => 'required|trim|numeric|min_length[5]|max_length[5]'],
			['field' => 'mobile', 'label' => 'Mobile Number', 'rules' => 'required|trim|numeric|min_length[10]|max_length[10]']
		];
		checkValidation($input, $rules);

		$otpDetails = $this->db->where('phone', $input['mobile'])->order_by('id','desc')->get('all_otp')->row();

		if (!$otpDetails) {
			outputJSON(400, 'error', 'Please resend OTP.');
			return;
		}
		if ($otpDetails->otp!=$input['otp']) {
			outputJSON(400, 'error', 'Invalid OTP.');
			return;
		}

		// $timeDifference = round((strtotime(date('Y-m-d H:i:s')) - strtotime($otpDetails->updated_at)) / 3600); // difference in hours
		$timeDifference = round((strtotime(date('Y-m-d H:i:s')) - strtotime($otpDetails->updated_at)) / 60); // difference in minutes
		if ($timeDifference >= 10) {
			outputJSON(400, 'error', 'OTP has expired.');
			return;
		}
		$valid = $this->db->select('id,c_name,c_email,c_contact,created_at,log_in_time,c_pas')->where('status', 0)->where('c_contact', $input['mobile'])->get('employer');
		if ($valid->num_rows()) {
			outputJSON(200, 'success', 'OTP verified.', $valid->row());
		}else{
			outputJSON(200, 'success', 'OTP verified.', ['mobile' => $input['mobile']]);
		}
	}
   
}