<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'welcome';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;


$route['api/employer/register']='API/AuthController/employer_register';
$route['api/employer/login']='API/AuthController/employer_login';
$route['api/employer/change_password']='API/AuthController/change_password';
$route['api/employer/profile_image']='API/AuthController/get_profile_image';
$route['api/employer/send_otp']='API/AuthController/send_otp';
$route['api/employer/verify_otp']='API/AuthController/verify_otp';
$route['api/employer/job_post']='API/JobController/submit_job';
$route['api/employer/company_details']='API/CommonController/submit_about_company';
$route['api/employer/get_company_details']='API/CommonController/get_about_company';
$route['api/employer/applied_candidate']='API/CommonController/get_applied_candidate';
$route['api/employer/previous_job_detail']='API/CommonController/get_previous_job_detail';
$route['api/employer/shortlisted_employees']='API/CommonController/get_shortlisted_employees';
$route['api/employer/employee_details_search']='API/CommonController/recruiter_employee_details_search';
$route['api/employer/employee_listing']='API/CommonController/get_employee_details';
$route['api/employer/rec_highlight']='API/CommonController/get_rec_highlight';
$route['api/employer/rec_viewed_by_detail']='API/CommonController/rec_viewed_by_detail';
$route['api/employer/get_rec_data']='API/CommonController/get_rec_data';