<?php if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}


function get_state($id) {
	$CI = &get_instance();
	$CI->db->select('state_title');
	$CI->db->from('state');
	$CI->db->where('state_id', $id);
	$return = $CI->db->get()->row();
	if (!empty($return->state_title)) {
		return $return->state_title;
	} else {
		return "NA";
	}
}


function get_district($id) {
	$CI = &get_instance();
	$CI->db->select('district_title');
	$CI->db->from('district');
	$CI->db->where('districtid', $id);
	$return = $CI->db->get()->row();
	if (!empty($return->district_title)) {
		return $return->district_title;
	} else {
		return "NA";
		
	}
}


function get_company($id) {
	$CI = &get_instance();
	$CI->db->select('about_com.*');
	$CI->db->from('employer');
	$CI->db->join('about_com', 'about_com.created_by = employer.id', 'left');
	$CI->db->where('employer.id', $id);
	$return = $CI->db->get()->row();
	if (!empty($return)) {
		return $return;
	} else {
		return "NA";
		
	}
}




function com_logo($id) {
	$CI = &get_instance();
	$CI->db->select('c_logo');
	$CI->db->from('about_com');
	$CI->db->where('created_by', $id);
	$return = $CI->db->get()->row();
	if (!empty($return->c_logo)) {
		return $return->c_logo;
	} else {
		return "NA";
		
	}
}


function first_msg_frm_company($id , $emp_id) {
	$CI = &get_instance();
	$CI->db->select('msg,created_at');
	$CI->db->from('chatbox_msg');
	$CI->db->where('created_by_rec', $id);
	$CI->db->where('ee_id', $emp_id);
	$CI->db->order_by("id", "asc");
	$CI->db->limit(1);
	
	$return = $CI->db->get()->row();
	if (!empty($return->msg)) {
		return $return;
	} else {
		return "NA";
		
	}
}




function all_msgs($id , $rec_id) {
	$CI = &get_instance();
	$CI->db->select('*');
	$CI->db->from('chatbox_msg');
	$CI->db->where('ee_id', $id);
	$CI->db->where('rec_id', $rec_id);
	$CI->db->order_by("id", "desc");
	$CI->db->limit(50);
	$query = $CI->db->get();
	$return = $query->result();
	if (!empty($return)) {
		return $return;
	} else {
		return "NA";
		
	}
}


function appendNewMsg($id , $rec_id , $last_msg) {
	$CI = &get_instance();
	$CI->db->select('*');
	$CI->db->from('chatbox_msg');
	$CI->db->where('ee_id', $id);
	$CI->db->where('rec_id', $rec_id);

	$CI->db->where('id >', $last_msg);

	$CI->db->order_by("id", "desc");
	$CI->db->limit(50);
	$query = $CI->db->get();
	$return = $query->result();
	if (!empty($return)) {
		return $return;
	} else {
		return "";
		
	}
}



function sendNotification($token,$body,$title,$click_action,$icon){
   // $url="https://fcm.googleapis.com/v1/projects/bitsmultiservice/messages:send";
   $url="https://asatvindia.in:5001/api/notification";

    $fields=array(
            "message"=>array("token"=>$token,
            "notification"=>array(
                "body"=>$body,
                "title"=>$title,
             ),
             "webpush"=>array("fcm_options"=>array('link'=>$click_action),
             "notification"=>array('icon'=>$icon),
             ),
            )
        );
       
    
    $headers=array(
        'Content-Type:application/json'
    );

    $ch=curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($fields));
    $result=curl_exec($ch);
    //print_r($result);
    curl_close($ch);
}


function sendNotificationapp($token,$body,$title,$notificaton_id,$app_url,$channel_id,$user_type,$common){
    //$url="https://fcm.googleapis.com/v1/projects/bitsmultiservice/messages:send";
    $url="https://asatvindia.in:5001/api/notification";
    

    $fields=array(
            "message"=>array("token"=>$token,
              "data"=>array(
                          "notificaton_id"=>"$notificaton_id",
                           "title"=>$title,
                           "body"=>$body,
                           "channel_id"=>$channel_id,
                          "url"=>$app_url,
                          "user_type"=> "$user_type",
                          "common"=>$common,
                           )
            )
        );
        
        
    
    $headers=array(
        'Content-Type:application/json'
    );

    $ch=curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($fields));
    $result=curl_exec($ch);
    // print_r($result);
    // exit;
    curl_close($ch);
}



function prx($xxxxx) {
	$CI = &get_instance();
	echo'<pre>';
	print_r($xxxxx);
	echo'</pre>';
	exit;
}


function rec_url() {
	$CI = &get_instance();
	$return = 'https://jobkaro.in/jd/jdrec/';
	// print_r($xxxxx);
	// echo'</pre>';
	return $return;
}