<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        'App\Events\NewMessage' => [
            'App\Listeners\SendNewMessageNotification',
        ],
        'App\Events\IncomingCall' => [
            'App\Listeners\IncomingCallNotification',
        ],
        'App\Events\IncomingCallStatus' => [
            'App\Listeners\IncomingCallStatusNotification',
        ],
        'App\Events\UserOnlineStatusUpdate' => [
            'App\Listeners\UserOnlineStatusUpdateNotification',
        ]

    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
