<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Terms & Conditions — Jobkaro.in</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;normal;700&display=swap');

    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #f1f5f9, #e2e8f0);
      color: #374151;
      padding: 3rem 1rem;
    }

    .terms-container {
      max-width: 950px;
      margin: auto;
      background: #ffffff;
      padding: 3rem 3.5rem;
      border-radius: 16px;
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .terms-container:hover {
      transform: translateY(-4px);
      box-shadow: 0 12px 35px rgba(0, 0, 0, 0.1);
    }

    h1 {
      color: #0f172a;
      font-weight: normal;
    }

    h2 {
      color: #1e293b;
      font-size: 1.35rem;
      margin-top: 2rem;
      border-left: 5px solid #3b82f6;
      padding-left: 0.75rem;
      font-weight: normal;
    }

    h5 {
      color: #334155;
      font-weight: normal;
      margin-top: 1rem;
    }

    p, li {
      font-size: 0.95rem;
      line-height: 1.7;
    }

    ul {
      margin-left: 1.2rem;
    }

    hr {
      border-top: 1px solid #e2e8f0;
      margin: 1.5rem 0;
    }

    a {
      color: #2563eb;
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    .badge-date {
      background-color: #dbeafe;
      color: #1e40af;
      border-radius: 8px;
      padding: 0.35rem 0.6rem;
      font-size: 0.85rem;
      margin-left: 0.4rem;
    }

    footer {
      text-align: center;
      margin-top: 2rem;
      color: #6b7280;
      font-size: 0.9rem;
      border-top: 1px solid #e5e7eb;
      padding-top: 1.2rem;
    }

    @media (max-width: 768px) {
      .terms-container {
        padding: 2rem 1.5rem;
      }
    }
  </style>
</head>
<body>
  <div class="terms-container">
    <h1 class="text-center mb-2">Terms & Conditions</h1>
    <p class="text-center fs-5 fw-semibold text-primary">Jobkaro.in</p>
    <p class="text-center text-muted mb-3">
      Effective Date: <span class="badge-date">16/10/2025</span>
    </p>
    <hr>

    <p>Welcome to <strong>Jobkaro.in</strong> (“we”, “our”, “us”). These Terms and Conditions (“Terms”) govern your access to and use of our website <strong>www.jobkaro.in</strong> and mobile application (collectively, the “Platform”).</p>

    <p>By accessing or using our Platform, you agree to comply with these Terms. If you do not agree, please do not use Jobkaro.in.</p>

    <h2>1. Definitions</h2>
    <ul>
      <li><strong>User:</strong> Any person who accesses or uses the Jobkaro.in Platform, including job seekers and employers.</li>
      <li><strong>Job Seeker:</strong> An individual who registers and applies for job opportunities.</li>
      <li><strong>Employer/Recruiter:</strong> A company or individual who posts job openings or searches for candidates.</li>
      <li><strong>Content:</strong> All materials, including text, images, resumes, job listings, and other data uploaded or shared on Jobkaro.in.</li>
    </ul>

    <h2>2. Use of the Platform</h2>
    <ul>
      <li>You must be at least 16 years old to use Jobkaro.in.</li>
      <li>You agree to use the Platform only for lawful purposes and in compliance with applicable laws.</li>
      <li>You agree not to:
        <ul>
          <li>Post false, misleading, or fraudulent information.</li>
          <li>Upload harmful or malicious files (e.g., viruses, malware).</li>
          <li>Impersonate another person or organization.</li>
          <li>Use automated systems (bots/scrapers) to extract data from the site.</li>
        </ul>
      </li>
    </ul>

    <h2>3. Account Registration</h2>
    <ul>
      <li>To access certain features, you must register for an account.</li>
      <li>You agree to provide accurate, complete, and updated information.</li>
      <li>You are responsible for maintaining the confidentiality of your login credentials.</li>
      <li>Any activity performed through your account will be your responsibility.</li>
    </ul>

    <h2>4. Services for Job Seekers</h2>
    <ul>
      <li>Jobkaro.in allows users to create profiles, upload resumes, and apply for jobs.</li>
      <li>Your profile may be visible to employers if you choose to make it public.</li>
      <li>Jobkaro.in does not guarantee job placement, interview calls, or employment offers.</li>
      <li>We recommend users verify the authenticity of employers before sharing personal or financial details.</li>
    </ul>

    <h2>5. Services for Employers</h2>
    <ul>
      <li>Employers can post job openings and access candidate profiles.</li>
      <li>You agree to provide genuine job listings and not use the Platform for fraudulent hiring or marketing activities.</li>
      <li>Jobkaro.in reserves the right to remove any job post that violates these Terms or our policies.</li>
    </ul>

    <h2>6. User Content</h2>
    <ul>
      <li>You retain ownership of any content you post but grant Jobkaro.in a non-exclusive, worldwide, royalty-free license to display, distribute, and use it for providing our services.</li>
      <li>You are solely responsible for the content you submit.</li>
      <li>Jobkaro.in reserves the right to review, edit, or remove any content that violates our policies.</li>
    </ul>

    <h2>7. Payment and Refunds (if applicable)</h2>
    <ul>
      <li>Some services on Jobkaro.in may be paid.</li>
      <li>Payments made for premium listings or promotional services are non-refundable, except in cases of technical error or duplicate payment.</li>
      <li>Jobkaro.in is not liable for any third-party transaction failures.</li>
    </ul>

    <h2>8. Privacy</h2>
    <p>Your use of Jobkaro.in is also governed by our <a href="#">Privacy Policy</a>, which describes how we collect, use, and protect your personal data.</p>

    <h2>9. Limitation of Liability</h2>
    <ul>
      <li>Jobkaro.in acts only as a digital platform connecting job seekers and employers.</li>
      <li>We do not guarantee the authenticity, quality, or accuracy of job postings or candidate details.</li>
      <li>We are not responsible for any direct, indirect, or consequential damages arising from your use of our Platform.</li>
    </ul>

    <h2>10. Intellectual Property Rights</h2>
    <ul>
      <li>All trademarks, logos, software, and content displayed on Jobkaro.in are owned by or licensed to us.</li>
      <li>You may not copy, reproduce, modify, distribute, or use our intellectual property without written permission.</li>
    </ul>

    <h2>11. Suspension or Termination</h2>
    <p>We may suspend or terminate your account if you:</p>
    <ul>
      <li>Violate these Terms,</li>
      <li>Misuse the Platform, or</li>
      <li>Engage in fraudulent or illegal activity.</li>
    </ul>
    <p>Jobkaro.in reserves the right to remove your data after account termination in accordance with our data retention policy.</p>

    <h2>12. Third-Party Links</h2>
    <p>Our Platform may contain links to third-party websites. We are not responsible for their content, privacy practices, or policies.</p>

    <h2>13. Indemnification</h2>
    <p>You agree to indemnify and hold harmless Jobkaro.in, its owners, employees, and affiliates from any claims, damages, or expenses arising from your use of the Platform or violation of these Terms.</p>

    <h2>14. Changes to These Terms</h2>
    <p>We may modify these Terms at any time. Updated versions will be posted on this page with a new effective date. Continued use of Jobkaro.in after updates means you accept the revised Terms.</p>

    <h2>15. Governing Law and Jurisdiction</h2>
    <p>These Terms are governed by the laws of India, and any disputes will be subject to the jurisdiction of the courts of Gurgaon, Haryana.</p>

    <h2>16. Contact Us</h2>
    <address>
      <strong>Jobkaro.in</strong><br>
      Email: <a href="mailto:support@jobkaro.in">support@jobkaro.in</a><br>
      Address: Gurgaon, Haryana, India
    </address>

    <footer>
      &copy; <span id="year"></span> Jobkaro.in — All rights reserved.
    </footer>
  </div>

  <script>
    document.getElementById('year').textContent = new Date().getFullYear();
  </script>
</body>
</html>





