<!doctype html>
<html lang="en">
  <?php require'css.php'; ?>
  <body>
    <style>
       .bootstrap-tagsinput {
		display: block !important;
		white-space: normal !important;
		max-width: 100%;
		min-height: 40px; /* Adjust height as needed */
		overflow-wrap: break-word;
		word-wrap: break-word;
		padding: 5px;
	}
	.bootstrap-tagsinput .tag {
		background: #0d6efd;
		display: inline-block;
		margin: 2px;
		white-space: normal;
		word-break: break-word;
		padding: 5px 8px;
		border-radius: 20px;
	}
    </style>
    <div class="modal" id="myModal">
        <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content bg-transparent border-0">
    
            <!-- Modal body -->
            <div class="modal-body edit-profile">
                <div class="d-flex justify-content-between mb-3">
                    <p class="edit-title mb-0">Edit Your Profile</p>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
				<form method="post" action="<?=base_url('update-profile')?>" id="submitForm5">
                <div class="row mx-0">
                    <div class="col-md-6">
                        <label class="formLabel small">Name*</label>
                        <input type="text" name="name" value="<?=$profile->c_name;?>" placeholder="Enter Full Name" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="formLabel small">Profile Pic</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                    </div>
                    
					<div class="col-md-6">
                        <label class="formLabel small">DOB</label>
                        <input type="date" name="dob"  value="<?=$profile->dob;?>" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label class="formLabel small">Gender*</label>
                        <select class="form-control" name="gender" required>
							<option value=''>Choose</option>
							<option value='Male' <?= ($profile->gender ?? '') == 'Male' ? 'selected' : '' ?>>Male</option>
							<option value='Female' <?= ($profile->gender ?? '') == 'Female' ? 'selected' : '' ?>>Female</option>
							<option value='Other' <?= ($profile->gender ?? '') == 'Other' ? 'selected' : '' ?>>Other</option>
						</select>

                    </div>
                    <div class="col-md-6">
                        <label class="formLabel small">Headline*</label>
                        <input type="text" name="headline"  value="<?=$profile->headline;?>" placeholder="Enter headline" class="form-control" required>
                    </div>
					<div class="col-md-6">
                        <label class="formLabel small">Address*</label>
                        <input type="text" name="address"  value="<?=$profile->address;?>" placeholder="Enter full address" class="form-control" required>
                    </div>
                    <div class="col-md-12">
                        <label class="formLabel small">Bio</label>
                        <textarea name="bio" placeholder="Creative and detail-orient......" class="form-control"><?=$profile->bio;?></textarea>
                    </div>
                    <label class="formLabel small mt-2">Links</label>
                    <div class="px-3">
                        <div class="form-control">
                            <div class="d-flex gap-2">
                                <span class="buttonstyle"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M3 15C2.5875 15 2.2345 14.8533 1.941 14.5597C1.6475 14.2662 1.5005 13.913 1.5 13.5V4.5C1.5 4.0875 1.647 3.7345 1.941 3.441C2.235 3.1475 2.588 3.0005 3 3H15C15.4125 3 15.7657 3.147 16.0597 3.441C16.3538 3.735 16.5005 4.088 16.5 4.5V13.5C16.5 13.9125 16.3533 14.2657 16.0597 14.5597C15.7662 14.8538 15.413 15.0005 15 15H3ZM9 9.75L15 6V4.5L9 8.25L3 4.5V6L9 9.75Z" fill="#202020" fill-opacity="0.8"/>
                                  </svg> Email</span>
                               <input type="email" name="email" value="<?=$profile->c_email;?>" placeholder="example@gmail.com" class="my-auto w-100"  required>
                            </div>
                        </div>
                        <div class="form-control">
                            <div class="d-flex gap-2">
                                <span class="buttonstyle">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                        <path d="M4.965 8.0925C6.045 10.215 7.785 11.9475 9.9075 13.035L11.5575 11.385C11.76 11.1825 12.06 11.115 12.3225 11.205C13.1625 11.4825 14.07 11.6325 15 11.6325C15.4125 11.6325 15.75 11.97 15.75 12.3825V15C15.75 15.4125 15.4125 15.75 15 15.75C7.9575 15.75 2.25 10.0425 2.25 3C2.25 2.5875 2.5875 2.25 3 2.25H5.625C6.0375 2.25 6.375 2.5875 6.375 3C6.375 3.9375 6.525 4.8375 6.8025 5.6775C6.885 5.94 6.825 6.2325 6.615 6.4425L4.965 8.0925Z" fill="#202020" fill-opacity="0.8"/>
                                      </svg> Phone no.</span>
                                <input type="text" name="mobile" value="<?=$profile->c_contact;?>" placeholder="Enter mobile number" maxlength="10" onchange="this.value=this.value.replace(/[^\d]/ig,'')" onkeyup="this.value=this.value.replace(/[^\d]/ig,'')" class="my-auto w-50" required>
                            </div>
                        </div>
                        <div class="form-control">
                            <div class="d-flex gap-2">
                                <span class="buttonstyle">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                        <g clip-path="url(#clip0_1979_5805)">
                                          <path d="M13.5 7C13.5 8.72391 12.8152 10.3772 11.5962 11.5962C10.3772 12.8152 8.72391 13.5 7 13.5C5.27609 13.5 3.62279 12.8152 2.40381 11.5962C1.18482 10.3772 0.5 8.72391 0.5 7M13.5 7C13.5 5.27609 12.8152 3.62279 11.5962 2.40381C10.3772 1.18482 8.72391 0.5 7 0.5C5.27609 0.5 3.62279 1.18482 2.40381 2.40381C1.18482 3.62279 0.5 5.27609 0.5 7M13.5 7H0.5" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"/>
                                          <path d="M9.5 7C9.3772 9.37699 8.50168 11.6533 7 13.5C5.49832 11.6533 4.6228 9.37699 4.5 7C4.6228 4.62301 5.49832 2.34665 7 0.5C8.50168 2.34665 9.3772 4.62301 9.5 7Z" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"/>
                                        </g>
                                        <defs>
                                          <clipPath id="clip0_1979_5805">
                                            <rect width="14" height="14" fill="white"/>
                                          </clipPath>
                                        </defs>
                                      </svg> Website</span>
                                <input type="text" name="portfolio_url" value="<?=$profile->portfolio_url;?>" placeholder="Enter portfolio website link" class="my-auto w-100">
                            </div>
                        </div>
                        <div class="form-control">
                            <div class="d-flex gap-2">
                                <span class="buttonstyle">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                        <path d="M14.25 2.25C14.6478 2.25 15.0294 2.40804 15.3107 2.68934C15.592 2.97064 15.75 3.35218 15.75 3.75V14.25C15.75 14.6478 15.592 15.0294 15.3107 15.3107C15.0294 15.592 14.6478 15.75 14.25 15.75H3.75C3.35218 15.75 2.97064 15.592 2.68934 15.3107C2.40804 15.0294 2.25 14.6478 2.25 14.25V3.75C2.25 3.35218 2.40804 2.97064 2.68934 2.68934C2.97064 2.40804 3.35218 2.25 3.75 2.25H14.25ZM13.875 13.875V9.9C13.875 9.25155 13.6174 8.62965 13.1589 8.17112C12.7003 7.7126 12.0785 7.455 11.43 7.455C10.7925 7.455 10.05 7.845 9.69 8.43V7.5975H7.5975V13.875H9.69V10.1775C9.69 9.6 10.155 9.1275 10.7325 9.1275C11.011 9.1275 11.278 9.23812 11.475 9.43504C11.6719 9.63195 11.7825 9.89902 11.7825 10.1775V13.875H13.875ZM5.16 6.42C5.49417 6.42 5.81466 6.28725 6.05095 6.05095C6.28725 5.81466 6.42 5.49417 6.42 5.16C6.42 4.4625 5.8575 3.8925 5.16 3.8925C4.82384 3.8925 4.50144 4.02604 4.26374 4.26374C4.02604 4.50144 3.8925 4.82384 3.8925 5.16C3.8925 5.8575 4.4625 6.42 5.16 6.42ZM6.2025 13.875V7.5975H4.125V13.875H6.2025Z" fill="#202020" fill-opacity="0.8"/>
                                      </svg> LinkedIn</span>
                                <input type="text" name="linkedin" value="<?=$profile->linkedin;?>" placeholder="Enter LinkedIn URL" class="my-auto w-100">
                            </div>
                        </div>
                    </div>
					<div class="col-12">
						 <button type="submit" class="btn btn-primary" id="submitBtn5">Submit <i class="fa fa-spinner fa-spin" id="submitSpin5" style="display:none;"></i></button>
					</div>
                </div>
				</form>
            </div>
    
        </div>
        </div>
    </div>

    <section class="position-relative">
        <?php require'header2.php'; ?>

        <div style="background-color: #F6FBFF;">
            <div class="profile-page-sec">
                <div class="row custom-col-10 mx-auto py-4">
                    <div class="col-md-9">
                        <div class="profile-long-card">
                            <div class="profile-m-auto col-md-3">
                                <img src="<?=$profile->profile_pic?>" alt="" class="userImg">
                            </div>
							<?php if(!empty($profile->c_name)){?>
                            <div class="col-md-8" >
                                <div class="d-flex gap-3">
                                    <h5><?=$profile->c_name;?></h5>
                                    <svg data-bs-toggle="modal" data-bs-target="#myModal" class="my-auto" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                        <path d="M1.75293 19.9766H22.7529V21.4766H1.75293V19.9766ZM19.3029 7.22656C19.9029 6.62656 19.9029 5.72656 19.3029 5.12656L16.6029 2.42656C16.0029 1.82656 15.1029 1.82656 14.5029 2.42656L3.25293 13.6766V18.4766H8.05293L19.3029 7.22656ZM15.5529 3.47656L18.2529 6.17656L16.0029 8.42656L13.3029 5.72656L15.5529 3.47656ZM4.75293 16.9766V14.2766L12.2529 6.77656L14.9529 9.47656L7.45293 16.9766H4.75293Z" fill="#202020"/>
                                    </svg>
                                </div>
								<?php if(!empty($user->c_name) && !empty($user->c_email) && !empty($user->profile_pic)){?>
                                <div class="mob-hide">    
                                    <div class="d-flex gap-3">
                                        <h4><?=$profile->headline;?></h4>
                                        <h4>•</h4>
                                        <h4><?= $career->experience ?? '';?></h4>
                                    </div>
                                </div>
                                <div class="mob-show">
                                    <p class="mb-1 fw-500"><?=$profile->headline;?></p>
                                    <p class="mb-1 fw-500"><?= $career->experience ?? '';?></p>
                                </div>
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                                    <path d="M5.75208 4.6641C6.99142 3.38615 8.66001 2.67446 10.3952 2.68368C12.1305 2.6929 13.7922 3.42229 15.0192 4.71334C16.2462 6.0044 16.9394 7.75279 16.9482 9.57859C16.9569 11.4044 16.2805 13.1601 15.066 14.4641L11.5849 18.1268C11.273 18.4549 10.85 18.6392 10.409 18.6392C9.96801 18.6392 9.54504 18.4549 9.23315 18.1268L5.75208 14.4641C4.51706 13.1645 3.82324 11.4019 3.82324 9.56409C3.82324 7.72627 4.51706 5.9637 5.75208 4.6641Z" stroke="#202020" stroke-linejoin="round"/>
                                    <path d="M10.4089 12.1895C11.7867 12.1895 12.9037 11.0142 12.9037 9.56445C12.9037 8.11471 11.7867 6.93945 10.4089 6.93945C9.03102 6.93945 7.91406 8.11471 7.91406 9.56445C7.91406 11.0142 9.03102 12.1895 10.4089 12.1895Z" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"/>
                                  </svg> <?=$profile->address;?>
                                </p>
								<?php }?>
                                <p class="small mb-0">
                                    <?=$profile->bio;?><!--<span style="font-weight: 500;">More</span> -->
                                </p> 
                            </div>
							<?php }else{?>
							 <div class="col-md-8" >
                                <br>
                                <br>
								<h3 class="text-center">Introduce Yourself..  <svg data-bs-toggle="modal" data-bs-target="#myModal" class="my-auto" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                        <path d="M1.75293 19.9766H22.7529V21.4766H1.75293V19.9766ZM19.3029 7.22656C19.9029 6.62656 19.9029 5.72656 19.3029 5.12656L16.6029 2.42656C16.0029 1.82656 15.1029 1.82656 14.5029 2.42656L3.25293 13.6766V18.4766H8.05293L19.3029 7.22656ZM15.5529 3.47656L18.2529 6.17656L16.0029 8.42656L13.3029 5.72656L15.5529 3.47656ZM4.75293 16.9766V14.2766L12.2529 6.77656L14.9529 9.47656L7.45293 16.9766H4.75293Z" fill="#202020"/>
                                    </svg></h3>
								<p class="text-center">Your name and job title are the first things recruiters notice—make them count.</p>
                             </div>
							<?php }?>
                            <div class="social-icon pt-3 col-md-1">
                                <a href="mailto:<?=$profile->c_email;?>"><svg xmlns="http://www.w3.org/2000/svg"  width="18" height="19" viewBox="0 0 18 19" fill="none">
                                    <path d="M3 15.1836C2.5875 15.1836 2.2345 15.0368 1.941 14.7433C1.6475 14.4498 1.5005 14.0966 1.5 13.6836V4.68359C1.5 4.27109 1.647 3.91809 1.941 3.62459C2.235 3.33109 2.588 3.18409 3 3.18359H15C15.4125 3.18359 15.7657 3.33059 16.0597 3.62459C16.3538 3.91859 16.5005 4.27159 16.5 4.68359V13.6836C16.5 14.0961 16.3533 14.4493 16.0597 14.7433C15.7662 15.0373 15.413 15.1841 15 15.1836H3ZM9 9.93359L15 6.18359V4.68359L9 8.43359L3 4.68359V6.18359L9 9.93359Z" fill="#202020"/>
                                </svg></a>
								
                               <a href="tel:<?=$profile->c_contact;?>"> <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                    <path d="M4.965 8.27609C6.045 10.3986 7.785 12.1311 9.9075 13.2186L11.5575 11.5686C11.76 11.3661 12.06 11.2986 12.3225 11.3886C13.1625 11.6661 14.07 11.8161 15 11.8161C15.4125 11.8161 15.75 12.1536 15.75 12.5661V15.1836C15.75 15.5961 15.4125 15.9336 15 15.9336C7.9575 15.9336 2.25 10.2261 2.25 3.18359C2.25 2.77109 2.5875 2.43359 3 2.43359H5.625C6.0375 2.43359 6.375 2.77109 6.375 3.18359C6.375 4.12109 6.525 5.02109 6.8025 5.86109C6.885 6.12359 6.825 6.41609 6.615 6.62609L4.965 8.27609Z" fill="#202020"/>
                                </svg></a>
								<a href="<?=$profile->portfolio_url;?>" target="_blank">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                    <g clip-path="url(#clip0_1693_5104)">
                                      <path d="M13.5 7.18359C13.5 8.9075 12.8152 10.5608 11.5962 11.7798C10.3772 12.9988 8.72391 13.6836 7 13.6836C5.27609 13.6836 3.62279 12.9988 2.40381 11.7798C1.18482 10.5608 0.5 8.9075 0.5 7.18359M13.5 7.18359C13.5 5.45969 12.8152 3.80639 11.5962 2.5874C10.3772 1.36841 8.72391 0.683594 7 0.683594C5.27609 0.683594 3.62279 1.36841 2.40381 2.5874C1.18482 3.80639 0.5 5.45969 0.5 7.18359M13.5 7.18359H0.5" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"/>
                                      <path d="M9.5 7.18359C9.3772 9.56058 8.50168 11.8369 7 13.6836C5.49832 11.8369 4.6228 9.56058 4.5 7.18359C4.6228 4.8066 5.49832 2.53025 7 0.683594C8.50168 2.53025 9.3772 4.8066 9.5 7.18359Z" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"/>
                                    </g>
                                    <defs>
                                      <clipPath id="clip0_1693_5104">
                                        <rect width="14" height="14" fill="white" transform="translate(0 0.183594)"/>
                                      </clipPath>
                                    </defs>
                                </svg></a>
								<a href="<?=$profile->linkedin;?>" target="_blank">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                    <path d="M14.25 2.43359C14.6478 2.43359 15.0294 2.59163 15.3107 2.87293C15.592 3.15424 15.75 3.53577 15.75 3.93359V14.4336C15.75 14.8314 15.592 15.2129 15.3107 15.4943C15.0294 15.7756 14.6478 15.9336 14.25 15.9336H3.75C3.35218 15.9336 2.97064 15.7756 2.68934 15.4943C2.40804 15.2129 2.25 14.8314 2.25 14.4336V3.93359C2.25 3.53577 2.40804 3.15424 2.68934 2.87293C2.97064 2.59163 3.35218 2.43359 3.75 2.43359H14.25ZM13.875 14.0586V10.0836C13.875 9.43514 13.6174 8.81324 13.1589 8.35472C12.7003 7.89619 12.0785 7.63859 11.43 7.63859C10.7925 7.63859 10.05 8.02859 9.69 8.61359V7.78109H7.5975V14.0586H9.69V10.3611C9.69 9.78359 10.155 9.31109 10.7325 9.31109C11.011 9.31109 11.278 9.42172 11.475 9.61863C11.6719 9.81554 11.7825 10.0826 11.7825 10.3611V14.0586H13.875ZM5.16 6.60359C5.49417 6.60359 5.81466 6.47084 6.05095 6.23455C6.28725 5.99825 6.42 5.67777 6.42 5.34359C6.42 4.64609 5.8575 4.07609 5.16 4.07609C4.82384 4.07609 4.50144 4.20963 4.26374 4.44734C4.02604 4.68504 3.8925 5.00743 3.8925 5.34359C3.8925 6.04109 4.4625 6.60359 5.16 6.60359ZM6.2025 14.0586V7.78109H4.125V14.0586H6.2025Z" fill="#202020"/>
                                </svg></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="profileInsights">
                            <h5 class="mb-3">Profile Insights</h5>
                            <p class="d-flex justify-content-between">
                                <span>Your Profile Views:</span>
                                <span>
                                    <span class="spanborderbottom"><?=$profile_view;?></span> <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"/>
                                    </svg>
                                </span>
                            </p>
                            <p class="d-flex justify-content-between">
                                <span>Applications Submitted:</span>
                                <span>
                                    <span class="spanborderbottom"><?=$applied;?></span> <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"/>
                                    </svg>
                                </span>
                            </p>
                            <p class="d-flex justify-content-between">
                                <span>Saved Applicants:</span>
                                <span>
                                    <span class="spanborderbottom"><?=$saved;?></span> <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"/>
                                    </svg>
                                </span>
                            </p>
                            <p class="d-flex justify-content-between">
                                <span>Shortlisted:</span>
                                <span>
                                    <span class="spanborderbottom"><?=$shortlisted; ?></span> <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"/>
                                    </svg>
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row custom-col-10 mx-auto py-4">
                    <div class="col-md-3">
                        <div class="proQuickLinks">
                            <h5 class="mb-3">Quick Links</h5>
                           <a href="#resumeSec"> <p class="d-flex justify-content-between" >
                                <span>Resume</span>
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"></path>
                                    </svg>
                                </span>
                            </p></a>
                            <a href="#expsec"><p class="d-flex justify-content-between">
                                <span>Experience</span>
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"></path>
                                    </svg>
                                </span>
                            </p></a>
                            <a href="#skillsec"><p class="d-flex justify-content-between">
                                <span>Skills</span>
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"></path>
                                    </svg>
                                </span>
                            </p></a>
                            <a href="#edusec"><p class="d-flex justify-content-between">
                                <span>Education</span>
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"></path>
                                    </svg>
                                </span>
                            </p></a>
                           <a href="#portsec"> <p class="d-flex justify-content-between">
                                <span>Work</span>
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="8" viewBox="0 0 6 8" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.83484 3.63098C4.93149 3.72765 4.98578 3.85875 4.98578 3.99545C4.98578 4.13215 4.93149 4.26325 4.83484 4.35992L1.91855 7.27621C1.871 7.32545 1.81411 7.36472 1.75122 7.39174C1.68832 7.41876 1.62068 7.43298 1.55222 7.43357C1.48377 7.43417 1.41589 7.42113 1.35254 7.3952C1.28918 7.36928 1.23162 7.33101 1.18322 7.2826C1.13481 7.2342 1.09654 7.17664 1.07062 7.11328C1.04469 7.04993 1.03165 6.98205 1.03225 6.9136C1.03284 6.84515 1.04706 6.7775 1.07408 6.7146C1.1011 6.65171 1.14037 6.59482 1.18961 6.54727L3.74143 3.99545L1.18961 1.44363C1.0957 1.3464 1.04374 1.21618 1.04492 1.08102C1.04609 0.945849 1.10031 0.816551 1.19589 0.720969C1.29147 0.625388 1.42077 0.571171 1.55594 0.569996C1.6911 0.568822 1.82132 0.620783 1.91855 0.714689L4.83484 3.63098Z" fill="#007BFF"></path>
                                    </svg>
                                </span>
                            </p></a>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="upload-resume proDivDe mb-3" id="resumeSec">
                            <div class="d-flex justify-content-between mb-3">
                                <h6>Update Career Preferences</h6>
                                <a href="<?=base_url('career-preference');?>"><svg style="cursor: pointer;"  xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                    <path d="M2.08398 19.6426H23.084V21.1426H2.08398V19.6426ZM19.634 6.89258C20.234 6.29258 20.234 5.39258 19.634 4.79258L16.934 2.09258C16.334 1.49258 15.434 1.49258 14.834 2.09258L3.58398 13.3426V18.1426H8.38398L19.634 6.89258ZM15.884 3.14258L18.584 5.84258L16.334 8.09258L13.634 5.39258L15.884 3.14258ZM5.08398 16.6426V13.9426L12.584 6.44258L15.284 9.14258L7.78398 16.6426H5.08398Z" fill="#202020" fill-opacity="0.8"/>
                                </svg></a>
							

                            </div>
							<?php if(empty($career->resume)){ echo'Please update career preference to apply jobs';}else{?>
                            <div class="d-flex justify-content-between">
                                <div class="fs-5">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="36" viewBox="0 0 37 36" fill="none">
                                        <path d="M18.1545 17.2539C18.1299 17.2082 18.1053 17.1871 18.0771 17.1836C17.9752 17.2996 17.9998 18.291 18.1721 18.9906C18.3127 18.5125 18.3373 17.5668 18.1545 17.2539ZM18.0982 21.4902C17.8275 22.1934 17.4373 23.1531 16.9697 24.0004C17.1104 23.9441 17.2545 23.8844 17.4021 23.8246C18.0209 23.5715 18.7135 23.2867 19.4729 23.1145C18.949 22.6996 18.4744 22.1406 18.0982 21.4902Z" fill="#E9F3FF"/>
                                        <path d="M19.0264 12.375V4.78125H8.40918V31.2188H28.0967V13.8516H20.5029C20.1113 13.8516 19.7358 13.696 19.4588 13.4191C19.1819 13.1422 19.0264 12.7666 19.0264 12.375ZM20.96 22.4859C21.526 22.4191 22.0357 22.3875 22.5174 22.4051C22.9674 22.4191 23.3471 22.4754 23.6424 22.5844C23.6494 22.5879 23.6529 22.5879 23.66 22.5914C23.674 22.5984 23.6881 22.602 23.7021 22.609C23.7197 22.616 23.7408 22.623 23.7584 22.6336C23.7619 22.6371 23.7689 22.6371 23.7725 22.6406C23.9166 22.7039 24.0361 22.7812 24.1275 22.8727C24.4475 23.1926 24.5424 23.7902 24.3455 24.2648C24.233 24.5355 23.9342 24.9855 23.1748 24.9855C22.4084 24.9855 21.2799 24.6445 20.2885 24.1137C19.392 24.2648 18.4006 24.6023 17.4443 24.9258C17.2404 24.9961 17.0295 25.0664 16.8256 25.1332C15.4896 27.4254 14.4877 27.9246 13.8689 27.9246C13.7213 27.9246 13.5947 27.893 13.4893 27.8543C13.2467 27.7629 13.0393 27.573 12.9092 27.327C12.8775 27.2672 12.8529 27.2074 12.8318 27.1441C12.7756 26.9754 12.758 26.8066 12.7861 26.666L12.8072 26.5711C12.8107 26.5641 12.8107 26.557 12.8143 26.55C12.8213 26.5254 12.8283 26.5008 12.8389 26.4762C12.8389 26.4727 12.8424 26.4691 12.8424 26.4656C12.9865 26.0473 13.3205 25.643 13.8162 25.2492C14.2486 24.9047 14.7689 24.5918 15.4299 24.2508C15.9889 23.2664 16.7518 21.6105 17.2299 20.475C16.8502 19.0055 16.6428 17.8523 16.8748 17.0086C16.9064 16.8926 16.9627 16.7836 17.0365 16.6887C17.0436 16.6816 17.0471 16.6746 17.0541 16.6676C17.0576 16.6641 17.0576 16.6605 17.0611 16.6605C17.2826 16.3969 17.6553 16.2422 18.049 16.2562C18.6326 16.2809 19.0932 16.6605 19.2092 17.3145C19.2689 17.5957 19.2865 17.8945 19.276 18.218V18.2426C19.276 18.2602 19.276 18.2777 19.2725 18.2953C19.2479 18.7629 19.167 19.2305 19.0158 19.8668C19.0018 19.923 18.9877 19.9793 18.9736 20.0496L18.9385 20.1938L18.935 20.2043C18.9385 20.2113 18.9385 20.2148 18.942 20.2219L19.0053 20.3801C19.0088 20.3906 19.0158 20.4047 19.0193 20.4152C19.0439 20.4715 19.0686 20.5312 19.0932 20.584V20.5875C19.399 21.2484 19.7857 21.7617 20.285 22.173C20.4361 22.2961 20.5979 22.4086 20.7736 22.5176C20.8369 22.5 20.8967 22.493 20.96 22.4859Z" fill="#E9F3FF"/>
                                        <path d="M14.0166 26.7548C14.217 26.6001 14.5861 26.245 15.0748 25.5349C14.7127 25.8653 14.2521 26.3224 14.0166 26.7548ZM23.5404 23.8368L23.5475 23.8263H23.5545C23.5756 23.8122 23.5721 23.8017 23.5686 23.7946C23.565 23.7911 23.4104 23.4677 21.983 23.5345C23.224 24.0231 23.5123 23.8544 23.5404 23.8368Z" fill="#E9F3FF"/>
                                        <path d="M30.2975 10.1461L22.7318 2.58047C22.5209 2.36953 22.2361 2.25 21.9373 2.25H7.00293C6.38066 2.25 5.87793 2.75273 5.87793 3.375V32.625C5.87793 33.2473 6.38066 33.75 7.00293 33.75H29.5029C30.1252 33.75 30.6279 33.2473 30.6279 32.625V10.9441C30.6279 10.6453 30.5084 10.357 30.2975 10.1461ZM21.417 4.84453L28.0334 11.4609H21.417V4.84453ZM28.0967 31.2188H8.40918V4.78125H19.0264V12.375C19.0264 12.7666 19.1819 13.1422 19.4588 13.4191C19.7358 13.696 20.1113 13.8516 20.5029 13.8516H28.0967V31.2188Z" fill="#202020" fill-opacity="0.8"/>
                                        <path d="M19.0936 20.5767C19.0655 20.517 19.0409 20.4607 19.0163 20.4045C19.0128 20.3939 19.0057 20.3798 19.0022 20.3693L18.9389 20.2111C18.9354 20.2041 18.9354 20.2005 18.9319 20.1935L18.9354 20.183L18.9424 20.1443C19.0831 19.5712 19.2448 18.9033 19.2729 18.2318V18.2072C19.2835 17.9048 19.2659 17.6025 19.2026 17.3072C19.069 16.5584 18.5171 16.2666 18.046 16.2455C17.6487 16.2279 17.2796 16.3861 17.0581 16.6462C17.0546 16.6498 17.0546 16.6533 17.051 16.6533C17.044 16.6603 17.037 16.6673 17.0335 16.6744C16.9596 16.7693 16.9034 16.8783 16.8717 16.9943C16.6397 17.838 16.8471 18.9912 17.2268 20.4607C16.7487 21.5998 15.9858 23.2521 15.4268 24.2365V24.24C14.453 24.7427 13.1733 25.4986 12.8393 26.4513C12.8393 26.4548 12.8358 26.4584 12.8358 26.4619C12.8288 26.4865 12.8182 26.5111 12.8112 26.5357C12.8077 26.5427 12.8077 26.5498 12.8042 26.5568C12.7971 26.5884 12.7866 26.6201 12.7831 26.6517C12.7514 26.7923 12.769 26.9611 12.8288 27.1298C12.8499 27.1931 12.8745 27.2529 12.9061 27.3127C13.0362 27.5588 13.2436 27.7486 13.4862 27.84C13.5917 27.8787 13.7182 27.9103 13.8659 27.9103C14.4846 27.9103 15.4866 27.4111 16.8225 25.1189C17.0264 25.0521 17.2374 24.9818 17.4413 24.9115C18.3975 24.588 19.3889 24.2505 20.2854 24.0994C21.2768 24.6302 22.4053 24.9712 23.1717 24.9712C23.9311 24.9712 24.2299 24.5212 24.3424 24.2505C24.5393 23.7759 24.4444 23.1783 24.1245 22.8584C24.0331 22.767 23.9135 22.6896 23.7694 22.6263C23.7659 22.6228 23.7589 22.6228 23.7553 22.6193C23.7378 22.6123 23.7167 22.6052 23.6991 22.5947C23.685 22.5877 23.671 22.5841 23.6569 22.5771C23.6499 22.5736 23.6464 22.5736 23.6393 22.5701C23.0698 22.3662 22.1733 22.3345 20.9569 22.4716L20.7706 22.4927C20.5948 22.3873 20.4331 22.2712 20.2819 22.1482C19.7827 21.7509 19.3995 21.2412 19.0936 20.5767ZM14.0171 26.7537C14.2526 26.3212 14.7132 25.8642 15.0753 25.5337C14.5866 26.2439 14.2175 26.599 14.0171 26.7537ZM18.0776 17.1841C18.1057 17.1877 18.1303 17.2087 18.155 17.2545C18.3378 17.5673 18.3132 18.513 18.1725 18.9912C18.0003 18.2916 17.9757 17.3002 18.0776 17.1841ZM17.4026 23.8252C17.2549 23.8849 17.1108 23.9447 16.9702 24.0009C17.4378 23.1537 17.828 22.1939 18.0987 21.4908C18.4749 22.1412 18.9495 22.7002 19.4733 23.115C18.7139 23.2873 18.0214 23.572 17.4026 23.8252ZM23.569 23.7935C23.5725 23.8005 23.576 23.8111 23.5549 23.8252H23.5479L23.5409 23.8357C23.5128 23.8533 23.2245 24.022 21.9835 23.5334C23.4108 23.4666 23.5655 23.79 23.569 23.7935Z" fill="#202020" fill-opacity="0.8"/>
                                      </svg>
                                    Resume.pdf
                                </div>
								
								
                                <div>
                                    <a href="javascript:void(0)" onclick="viewResume()" class="fs-6">
                                        View 
                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                            <g clip-path="url(#clip0_1703_3501)">
                                              <path fill-rule="evenodd" clip-rule="evenodd" d="M15.9603 13.2064C16.1477 13.0188 16.2531 12.7645 16.2531 12.4994C16.2531 12.2342 16.1477 11.9799 15.9603 11.7924L10.3033 6.13537C10.211 6.03986 10.1007 5.96367 9.97868 5.91126C9.85667 5.85886 9.72545 5.83127 9.59267 5.83012C9.45989 5.82896 9.32822 5.85426 9.20532 5.90454C9.08242 5.95483 8.97077 6.02908 8.87688 6.12297C8.78298 6.21686 8.70873 6.32852 8.65845 6.45141C8.60817 6.57431 8.58287 6.70599 8.58402 6.83877C8.58518 6.97155 8.61276 7.10277 8.66517 7.22477C8.71758 7.34677 8.79376 7.45712 8.88927 7.54937L13.8393 12.4994L8.88927 17.4494C8.70711 17.638 8.60632 17.8906 8.6086 18.1528C8.61088 18.415 8.71605 18.6658 8.90145 18.8512C9.08686 19.0366 9.33767 19.1418 9.59987 19.144C9.86207 19.1463 10.1147 19.0455 10.3033 18.8634L15.9603 13.2064Z" fill="#007BFF"/>
                                            </g>
                                            <defs>
                                              <clipPath id="clip0_1703_3501">
                                                <rect width="24" height="24" fill="white" transform="matrix(0 1 1 0 0.25293 0.5)"/>
                                              </clipPath>
                                            </defs>
                                        </svg>
                                    </a>
                                </div>
                            </div>
							<?php }?>
                        </div>
						<div class="modal fade" id="showResume" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
							<div class="modal-dialog modal-dialog-centered modal-xl">
								<div class="modal-content">
									<div class="modal-header">
										<h5 class="modal-title" id="staticBackdropLabel">Resume</h5>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body">
										<iframe id="resumePdf" width="100%" height="600px;"></iframe>
									</div>
								</div>
							</div>
						</div>
						<script>
						function viewResume() {
							pdfUrl="<?=$career->resume;?>";
							document.getElementById('resumePdf').src = pdfUrl;
							$('#showResume').modal('show');

						}
						</script>
						<!-- Modal -->
						<div class="modal fade" id="addExp" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
							<div class="modal-dialog modal-dialog-centered modal-lg">
								<div class="modal-content">
									<div class="modal-header">
										<h5 class="modal-title" id="staticBackdropLabel">Add Work Experience</h5>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body edit-profile">
										<form method="post" action="<?=base_url('submit-work-experience')?>" id="submitForm">
											<input type="hidden" name="workid" id="id"> 
											<div class="row">
												<div class="col-sm-6">
													<label for="job_title" class="form-label">Job Title <span class="text-danger">*</span></label>
													<input type="text" class="form-control" placeholder="Enter job title" id="job_title" name="job_title" required>
												</div>
												<div class="col-sm-6">
													<label for="company_name" class="form-label">Company Name <span class="text-danger">*</span></label>
													<input type="text" class="form-control" placeholder="Enter company name" id="company_name" name="company_name" required>
												</div>
												<div class="col-sm-6">
													<label for="start_date" class="form-label">Start Date <span class="text-danger">*</span></label>
													<input type="date" class="form-control" name="start_date" required>
												</div>

												<div class="col-sm-6">
													<label for="end_date" class="form-label">End Date</label>
													<input type="date" class="form-control" id="end_date" name="end_date">
												</div>

												<div class="col-12">
													<div class="form-check p-0">
														<input class="" type="checkbox" id="is_current" name="is_current" onclick="handleClick(this,'is_current', 'end_date');">
														<label class="form-check-label" for="is_current">Currently Working</label>
													</div>
												</div>
											   

												<div class="col-sm-6">
													<label for="location" class="form-label">Employment Type <span class="text-danger">*</span></label>
													<select class="form-control" name="employment_type" required>
														<option value='' selected disabled>Choose</option>
														<?php foreach($employment_type as $row){?>
															<option value='<?=$row->value;?>' ><?=$row->title;?></option>
														<?php } ?>
													</select>
												</div>
												<div class="col-sm-6">
													<label for="location" class="form-label">Location Type <span class="text-danger">*</span></label>
													<select class="form-control" name="location_type" required>
														<option value='' selected disabled>Choose</option>
														<?php foreach($location_type as $row){?>
															<option value='<?=$row->value;?>' ><?=$row->title;?></option>
														<?php } ?>
													</select>
												</div>
												<div class="col-sm-12">
													<label for="technologies" class="form-label">Technologies Used <span class="text-danger">*</span></label>
													<input type="text" id="technologies" name="technologies" required class="form-control" data-role="tagsinput">
												</div>
												 <div class="col-sm-12">
													<label for="location" class="form-label">Location <span class="text-danger">*</span></label>
													<input type="text" class="form-control" placeholder="Enter job location " required id="location" name="location">
												</div>
												<div class="col-12">
													<label for="description" class="form-label">Job Description</label>
													<textarea class="form-control" id="description" name="description" rows="3"></textarea>
												</div>
												<div class="col-12">
													 <button type="submit" class="btn btn-primary" id="submitBtn">Submit <i class="fa fa-spinner fa-spin" id="submitSpin" style="display:none;"></i></button>
												</div>
												
											</div>

										  
										</form>
									</div>
								</div>
							</div>
						</div>
						
						

                        <div class="proDivDe mb-3" id="expsec">
                            <div class="d-flex justify-content-between">
                                <h6>Work Experience</h6>
                                <div class="d-flex gap-2 " data-bs-toggle="modal" data-bs-target="#addExp">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M19 13.1406H13V19.1406H11V13.1406H5V11.1406H11V5.14062H13V11.1406H19V13.1406Z" fill="#020202" fill-opacity="0.8"/>
                                    </svg>
                                </div>
                            </div>
                            <div class="work-experience mt-3">
                                <div class="timeline">
								<?php if(!empty($exp)){
									foreach($exp as $row){?>
                                  <div class="entry">
                                    <div class="dotborder">
                                        <div class="dot"></div>
                                    </div>
                                    <div class="content">
                                      <div class="d-flex gap-3">
                                        <h3><?=$row->job_title;?> <span>(<?=$row->start_date;?> - <?=$row->end_date;?>)</span></h3>
                                        <div>
                                            <svg onclick="editWork(<?=$row->id;?>)" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                                <path d="M1.5 19.6426H22.5V21.1426H1.5V19.6426ZM19.05 6.89258C19.65 6.29258 19.65 5.39258 19.05 4.79258L16.35 2.09258C15.75 1.49258 14.85 1.49258 14.25 2.09258L3 13.3426V18.1426H7.8L19.05 6.89258ZM15.3 3.14258L18 5.84258L15.75 8.09258L13.05 5.39258L15.3 3.14258ZM4.5 16.6426V13.9426L12 6.44258L14.7 9.14258L7.2 16.6426H4.5Z" fill="#202020" fill-opacity="0.8"/>
                                            </svg>
											 <i onclick="Delete(<?=$row->id;?>,'work_experience');" class="fa fa-trash text-danger fs-5"></i>
                                        </div>
                                      </div>
                                      <div class="company">
                                        <img src="<?=base_url('assets/newAssets/img/')?>company-logo.png" alt="Bits PanIndia">
                                        <div>
                                          <p><?=$row->company_name;?></p>
                                          <p class="location"><?=$row->location;?> · <?=$row->location_type;?></p>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
									<?php } }else{ echo'No record found';}?>
                                  
                                 <!-- <button class="view-all">View All 5  <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                    <g clip-path="url(#clip0_1703_3623)">
                                      <path fill-rule="evenodd" clip-rule="evenodd" d="M12.8109 16.5853C12.6233 16.7727 12.369 16.8781 12.1039 16.8781C11.8387 16.8781 11.5844 16.7727 11.3969 16.5853L5.73986 10.9283C5.64435 10.836 5.56817 10.7257 5.51576 10.6037C5.46335 10.4817 5.43576 10.3505 5.43461 10.2177C5.43345 10.0849 5.45876 9.95322 5.50904 9.83032C5.55932 9.70742 5.63357 9.59577 5.72746 9.50188C5.82136 9.40798 5.93301 9.33373 6.0559 9.28345C6.1788 9.23317 6.31048 9.20787 6.44326 9.20902C6.57604 9.21018 6.70726 9.23776 6.82926 9.29017C6.95127 9.34258 7.06161 9.41876 7.15386 9.51427L12.1039 14.4643L17.0539 9.51427C17.2425 9.33211 17.4951 9.23132 17.7573 9.2336C18.0195 9.23588 18.2703 9.34105 18.4557 9.52645C18.6411 9.71186 18.7463 9.96267 18.7485 10.2249C18.7508 10.4871 18.65 10.7397 18.4679 10.9283L12.8109 16.5853Z" fill="#007BFF"/>
                                    </g>
                                    <defs>
                                      <clipPath id="clip0_1703_3623">
                                        <rect width="24" height="24" fill="white" transform="translate(0.104492 0.878906)"/>
                                      </clipPath>
                                    </defs>
                                  </svg>
                                </button>-->
                                </div>
                            </div>
                        </div>
						<div class="modal fade" id="addSkills" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
							<div class="modal-dialog modal-dialog-centered">
								<div class="modal-content">
									<div class="modal-header">
										<h5 class="modal-title" id="staticBackdropLabel">Update Skills</h5>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body edit-profile">
										<form method="post" action="<?=base_url('update-skills')?>" id="submitForm2">
											
											<div class="row">
												
												<div class="col-sm-12">
													<label for="technologies" class="form-label">Skills <span class="text-danger">*</span></label>
													<input type="text"  name="skills" required class="form-control" data-role="tagsinput">
												</div>
												 
												<div class="col-12 mt-4">
													 <button type="submit" class="btn btn-primary" id="submitBtn2">Submit <i class="fa fa-spinner fa-spin" id="submitSpin2" style="display:none;"></i></button>
												</div>
												
											</div>
										</form>
									</div>
								</div>
							</div>
						</div>

                        <div class="proDivDe mb-3" id="skillsec">
                            <div class="d-flex justify-content-between">
                                <h6>Skill Set</h6>
                                <div class="d-flex gap-2">
								<?php if(empty($career)){?>
                                    <svg onclick="editSkill()" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M19 13.1406H13V19.1406H11V13.1406H5V11.1406H11V5.14062H13V11.1406H19V13.1406Z" fill="#020202" fill-opacity="0.8"/>
                                    </svg>
								<?php }else{ ?>
                                    <svg onclick="editSkill()" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M1.5 19.6426H22.5V21.1426H1.5V19.6426ZM19.05 6.89258C19.65 6.29258 19.65 5.39258 19.05 4.79258L16.35 2.09258C15.75 1.49258 14.85 1.49258 14.25 2.09258L3 13.3426V18.1426H7.8L19.05 6.89258ZM15.3 3.14258L18 5.84258L15.75 8.09258L13.05 5.39258L15.3 3.14258ZM4.5 16.6426V13.9426L12 6.44258L14.7 9.14258L7.2 16.6426H4.5Z" fill="#202020" fill-opacity="0.8"/>
                                    </svg>
								<?php } ?>
                                </div>
                            </div>
                            <div class="skilset justify-content-start mt-3">
								<?php $skills=explode(',',$career->skills ?? '');
									if(!empty($skills)){
										foreach($skills as $skill){
											$skill = trim($skill);

										if (!empty($skill)) {
								?>
                                <span class="profile-skillSet"><?=htmlspecialchars(ucfirst($skill));?></span>
										<?php }}}?>
                                <!--<span class="morebtn">+12 More</span>-->
                            </div>
                        </div>
						
						<div class="modal fade" id="addEducation" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
							<div class="modal-dialog modal-dialog-centered modal-lg">
								<div class="modal-content">
									<div class="modal-header">
										<h5 class="modal-title" id="staticBackdropLabel">Update Education Details</h5>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body edit-profile">
										<form method="post" action="<?=base_url('submit-education')?>" id="submitForm3">
											<input type="hidden" name="eduid" id="id"> 
											<div class="row">
												<div class="col-sm-6">
													<label for="job_title" class="form-label">Institution<span class="text-danger">*</span></label>
													<input type="text" class="form-control" placeholder="Enter Institution" id="institution" name="institution" required>
												</div>
												<div class="col-sm-6">
													<label for="location" class="form-label">Degree <span class="text-danger">*</span></label>
													<select class="form-control" name="degree" required>
														<option value='' selected disabled>Choose</option>
														<?php foreach($degree as $row){?>
															<option value='<?=$row->value;?>' ><?=$row->title;?></option>
														<?php } ?>
													</select>
												</div>
												<div class="col-sm-6">
													<label for="job_title" class="form-label">Field of study</label>
													<input type="text" class="form-control" placeholder="Field of study" id="field_of_study" name="field_of_study" >
												</div>
												 <div class="col-sm-6">
													<label for="job_title" class="form-label">Grade<span class="text-danger"></span></label>
													<input type="text" class="form-control" placeholder="Enter grade and percentage" id="grade" name="grade" >
												</div>
												<div class="col-sm-6">
													<label for="start_date" class="form-label">Start Date <span class="text-danger">*</span></label>
													<input type="date" class="form-control" name="start_date" required>
												</div>

												<div class="col-sm-6">
													<label for="end_date" class="form-label">End Date</label>
													<input type="date" class="form-control" id="end_date1" name="end_date">
												</div>

												<div class="col-12 mt-1">
													<div class="form-check p-0">
														<input class="" type="checkbox" id="is_current1" name="is_current" onclick="handleClick(this,'is_current1', 'end_date1')">
														<label class="form-check-label" for="is_current">Currently Pursuing</label>
													</div>
												</div>
											  
												<div class="col-sm-12">
													<label for="activities" class="form-label">Activities<span class="text-danger"></span></label>
													<input type="text" id="activities" name="activities"  class="form-control" data-role="tagsinput">
												</div>
												 
												<div class="col-12">
													<label for="description" class="form-label">Description</label>
													<textarea class="form-control" id="description" name="description" rows="3"></textarea>
												</div>
												<div class="col-12 mt-4">
													 <button type="submit" class="btn btn-primary" id="submitBtn3">Submit <i class="fa fa-spinner fa-spin" id="submitSpin3" style="display:none;"></i></button>
												</div>
												
											</div>

										  
										</form>
									</div>
								</div>
							</div>
						</div>
                        <div class="proDivDe work-experience mb-3" id="edusec">
                            <div class="d-flex justify-content-between">
                                <h6>Education</h6>
                                <div class="d-flex gap-2">
                                    <svg  data-bs-toggle="modal" data-bs-target="#addEducation" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M19 13.1406H13V19.1406H11V13.1406H5V11.1406H11V5.14062H13V11.1406H19V13.1406Z" fill="#020202" fill-opacity="0.8"/>
                                    </svg>
                                </div>
                            </div>
							<?php if(!empty($education)){
									foreach($education as $row){ ?>
                            <div class="company mb-3">
                                <img src="<?=base_url('assets/newAssets/img/')?>company6.png" alt="TCS">
                                  <div class="d-flex gap-3">
                                    <div>
                                        <p><?=$row->degree;?></p>
                                        <p class="location"><?=$row->institution;?>(<?=$row->start_date.' - '.$row->end_date;?>)</p>
                                    </div>
                                    <div>
                                        <svg onclick="editEducation(<?=$row->id;?>)" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                            <path d="M1.5 19.6426H22.5V21.1426H1.5V19.6426ZM19.05 6.89258C19.65 6.29258 19.65 5.39258 19.05 4.79258L16.35 2.09258C15.75 1.49258 14.85 1.49258 14.25 2.09258L3 13.3426V18.1426H7.8L19.05 6.89258ZM15.3 3.14258L18 5.84258L15.75 8.09258L13.05 5.39258L15.3 3.14258ZM4.5 16.6426V13.9426L12 6.44258L14.7 9.14258L7.2 16.6426H4.5Z" fill="#202020" fill-opacity="0.8"></path>
                                        </svg>
										<i onclick="Delete(<?=$row->id;?>,'education');" class="fa fa-trash text-danger fs-5"></i>
                                    </div>
                                  </div>
                            </div>
                            <?php }}else{ echo 'No education record found';} ?>
                            <!--<p class="small mb-0" style="padding-left: 45px;">View Full Learning Journey
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <g clip-path="url(#clip0_1893_1673)">
                                      <path fill-rule="evenodd" clip-rule="evenodd" d="M11.7803 8.46974C11.9209 8.61038 11.9999 8.80111 11.9999 8.99999C11.9999 9.19886 11.9209 9.38959 11.7803 9.53024L7.53751 13.773C7.46833 13.8446 7.38557 13.9018 7.29407 13.9411C7.20256 13.9804 7.10415 14.0011 7.00456 14.0019C6.90498 14.0028 6.80622 13.9838 6.71405 13.9461C6.62188 13.9084 6.53814 13.8527 6.46772 13.7823C6.3973 13.7119 6.34161 13.6281 6.3039 13.536C6.26619 13.4438 6.24721 13.345 6.24808 13.2454C6.24894 13.1459 6.26963 13.0474 6.30894 12.9559C6.34824 12.8644 6.40538 12.7817 6.47701 12.7125L10.1895 8.99999L6.47701 5.28749C6.34039 5.14603 6.2648 4.95658 6.26651 4.75994C6.26822 4.56329 6.34709 4.37518 6.48615 4.23612C6.6252 4.09707 6.81331 4.01819 7.00996 4.01648C7.20661 4.01477 7.39606 4.09037 7.53751 4.22699L11.7803 8.46974Z" fill="#202020" fill-opacity="0.8"/>
                                    </g>
                                    <defs>
                                      <clipPath id="clip0_1893_1673">
                                        <rect width="18" height="18" fill="white" transform="matrix(0 -1 1 0 0 18)"/>
                                      </clipPath>
                                    </defs>
                                  </svg>
                            </p>-->
                        </div>
						
						
						<div class="modal fade" id="addPortfolio" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
							<div class="modal-dialog modal-dialog-centered modal-lg">
								<div class="modal-content">
									<div class="modal-header">
										<h5 class="modal-title" id="staticBackdropLabel">Update Work Portfolio</h5>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body edit-profile">
										<form method="post" action="<?=base_url('submit-work-portfolio')?>" id="submitForm4">
											<input type="hidden" name="portid" id="id"> 
											<div class="row">
												<div class="col-sm-12">
													<label for="job_title" class="form-label">Title<span class="text-danger">*</span></label>
													<input type="text" class="form-control" placeholder="Enter Title" id="" name="title" required>
												</div>
												
												<div class="col-sm-3" id="image_div" style="display:none;">
													<label for="job_title" class="form-label">Current Image <span class="text-danger"></span></label>
													<a target="_blank" id="a_curr_img"><img id="curr_img" style="height:60px;width:60px;"></a>
												</div>
												<div class="col-sm-6" id="img_div">
													<label for="job_title" class="form-label">Image <span class="text-danger"></span></label>
													<input type="file" class="form-control" id="image" name="image" accept="image/*" >
												</div>
												 <div class="col-sm-6">
													<label for="job_title" class="form-label">Portfolio Link<span class="text-danger"></span></label>
													<input type="text" class="form-control" placeholder="Enter portfolio link"  name="url" >
												</div>
												<div class="col-sm-6">
													<label for="start_date" class="form-label">Start Date <span class="text-danger">*</span></label>
													<input type="date" class="form-control" name="start_date" required>
												</div>

												<div class="col-sm-6">
													<label for="end_date" class="form-label">End Date</label>
													<input type="date" class="form-control" id="end_date2" name="end_date">
												</div>

												<div class="col-12">
													<div class="form-check p-0">
														<input class="" type="checkbox" id="is_current2" name="is_current" onclick="handleClick(this,'is_current2', 'end_date2')">
														<label class="form-check-label" for="is_current">Currently Working</label>
													</div>
												</div>
											 												 
												<div class="col-12">
													<label for="description" class="form-label">Description</label>
													<textarea class="form-control" id="description" name="description" rows="3"></textarea>
												</div>
												<div class="col-12 mt-3">
													 <button type="submit" class="btn btn-primary" id="submitBtn4">Submit <i class="fa fa-spinner fa-spin" id="submitSpin4" style="display:none;"></i></button>
												</div>
												
											</div>

										  
										</form>
									</div>
								</div>
							</div>
						</div>
						
                        <div class="proDivDe work-experience viewLess" id="portsec">
                            <div class="d-flex justify-content-between">
                                <h6>Work</h6>
                                <div class="d-flex gap-2">
                                    <svg data-bs-toggle="modal" data-bs-target="#addPortfolio" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M19 13.1406H13V19.1406H11V13.1406H5V11.1406H11V5.14062H13V11.1406H19V13.1406Z" fill="#020202" fill-opacity="0.8"/>
                                    </svg>
                                    
                                </div>
                            </div>
                            <div class="workDiv mt-3">
								<?php if (!empty($portfolio)) { ?>
								<?php foreach (array_slice($portfolio, 0, 2) as $row) { ?>
									<div class="Div1">
									    <div class="d-flex justify-content-end gap-2">
    										<svg onclick="editPortfolio(<?=$row->id;?>)" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                                <path d="M1.5 19.6426H22.5V21.1426H1.5V19.6426ZM19.05 6.89258C19.65 6.29258 19.65 5.39258 19.05 4.79258L16.35 2.09258C15.75 1.49258 14.85 1.49258 14.25 2.09258L3 13.3426V18.1426H7.8L19.05 6.89258ZM15.3 3.14258L18 5.84258L15.75 8.09258L13.05 5.39258L15.3 3.14258ZM4.5 16.6426V13.9426L12 6.44258L14.7 9.14258L7.2 16.6426H4.5Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg>
    										<i onclick="Delete(<?=$row->id;?>,'work_portfolio');" class="fa fa-trash text-danger fs-5"></i>	
    									</div>
    										<img src="<?= $row->image ?>" alt="" class="w-100 mb-2">
										<h6><?= $row->title ?></h6>
										<p class="small mb-0"><?= $row->start_date ?> - <?= $row->end_date ?></p>
									</div>
								<?php } ?>

								<?php if (count($portfolio) > 2) { ?>
									<div class="Div3 position-relative">
									    <br>
										<div class="position-absolute div3absolute text-center">
											<button class="view-all-btn">View All
												<svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
													<g clip-path="url(#clip0_1707_3897)">
														<path fill-rule="evenodd" clip-rule="evenodd"
															d="M15.7073 11.7936C15.8948 11.9812 16.0001 12.2355 16.0001 12.5006C16.0001 12.7658 15.8948 13.0201 15.7073 13.2076L10.0503 18.8646C9.9581 18.9601 9.84775 19.0363 9.72575 19.0887C9.60374 19.1411 9.47252 19.1687 9.33974 19.1699C9.20696 19.171 9.07529 19.1457 8.95239 19.0955C8.82949 19.0452 8.71784 18.9709 8.62395 18.877C8.53006 18.7831 8.4558 18.6715 8.40552 18.5486C8.35524 18.4257 8.32994 18.294 8.33109 18.1612C8.33225 18.0285 8.35983 17.8972 8.41224 17.7752C8.46465 17.6532 8.54083 17.5429 8.63634 17.4506L13.5863 12.5006L8.63634 7.55063C8.45418 7.36203 8.35339 7.10943 8.35567 6.84723C8.35795 6.58504 8.46312 6.33422 8.64852 6.14882C8.83393 5.96341 9.08474 5.85824 9.34694 5.85596C9.60914 5.85368 9.86174 5.95447 10.0503 6.13663L15.7073 11.7936Z"
															fill="white" />
													</g>
													<defs>
														<clipPath id="clip0_1707_3897">
															<rect width="24" height="24" fill="white" transform="matrix(0 -1 1 0 0 24.5)" />
														</clipPath>
													</defs>
												</svg>
											</button>
										</div>
										<div>
											<img src="<?= $portfolio[2]->image ?>" alt="" class="w-100 mb-2">
											<h6><?= $portfolio[2]->title ?></h6>
											<p class="small mb-0"><?= $portfolio[2]->start_date ?> - <?= $portfolio[2]->end_date ?></p>
										</div>
									</div>
								<?php } ?>
							<?php } else { ?>
								<p>No record found</p>
							<?php } ?>

                            </div>
                        </div>
						
						

                        <div class="proDivDe work-experience viewMore">
                            <div class="d-flex justify-content-between">
                                <h6>Work</h6>
                                <div class="">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <path d="M19 13.1406H13V19.1406H11V13.1406H5V11.1406H11V5.14062H13V11.1406H19V13.1406Z" fill="#020202" fill-opacity="0.8"/>
                                    </svg>
                                </div>
                            </div>
                            <div class="workDivMore mt-3">
                                <?php foreach ($portfolio as $row) { ?>
									<div class="Div1">
									    <div class="d-flex justify-content-end gap-2">
    										<svg onclick="editPortfolio(<?=$row->id;?>)" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                                <path d="M1.5 19.6426H22.5V21.1426H1.5V19.6426ZM19.05 6.89258C19.65 6.29258 19.65 5.39258 19.05 4.79258L16.35 2.09258C15.75 1.49258 14.85 1.49258 14.25 2.09258L3 13.3426V18.1426H7.8L19.05 6.89258ZM15.3 3.14258L18 5.84258L15.75 8.09258L13.05 5.39258L15.3 3.14258ZM4.5 16.6426V13.9426L12 6.44258L14.7 9.14258L7.2 16.6426H4.5Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg>
    										<i onclick="Delete(<?=$row->id;?>,'work_portfolio');" class="fa fa-trash text-danger fs-5"></i>	
    									</div>
    										<img src="<?= $row->image ?>" alt="" class="w-100 mb-2">
										<h6><?= $row->title ?></h6>
										<p class="small mb-0"><?= $row->start_date ?> - <?= $row->end_date ?></p>
									</div>
								<?php } ?>
                            </div>
                            <div class="text-center mt-3">
                                    <button class="btn btn-primary view_less_btn">View Less <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                        <g clip-path="url(#clip0_2682_8013)">
                                          <path fill-rule="evenodd" clip-rule="evenodd" d="M11.2936 8.79363C11.4812 8.60616 11.7355 8.50085 12.0006 8.50085C12.2658 8.50085 12.5201 8.60616 12.7076 8.79363L18.3646 14.4506C18.4601 14.5429 18.5363 14.6532 18.5887 14.7752C18.6411 14.8972 18.6687 15.0285 18.6699 15.1612C18.671 15.294 18.6457 15.4257 18.5955 15.5486C18.5452 15.6715 18.4709 15.7831 18.377 15.877C18.2831 15.9709 18.1715 16.0452 18.0486 16.0955C17.9257 16.1457 17.794 16.171 17.6612 16.1699C17.5285 16.1687 17.3972 16.1411 17.2752 16.0887C17.1532 16.0363 17.0429 15.9601 16.9506 15.8646L12.0006 10.9146L7.05063 15.8646C6.86203 16.0468 6.60943 16.1476 6.34723 16.1453C6.08504 16.143 5.83422 16.0379 5.64882 15.8525C5.46341 15.667 5.35824 15.4162 5.35596 15.154C5.35368 14.8918 5.45447 14.6392 5.63663 14.4506L11.2936 8.79363Z" fill="white"/>
                                        </g>
                                        <defs>
                                          <clipPath id="clip0_2682_8013">
                                            <rect width="24" height="24" fill="white" transform="matrix(-1 0 0 -1 24 24.5)"/>
                                          </clipPath>
                                        </defs>
                                      </svg>
                                    </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

		<div id="loading" style="display:none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); text-align: center; z-index: 9999;">
			<div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);padding: 20px; border-radius: 8px;">
				<i class="fa fa-spin fa-spinner text-white" style="font-size:80px;"></i>
				
			</div>
		</div>
		<script>
		#loading {
			display: none;
			position: fixed;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			background: rgba(0,0,0,0.5);
			z-index: 9999;
		}

		#loading::after {
			content: "";
			width: 50px;
			height: 50px;
			border: 5px solid #fff;
			border-top: 5px solid #007bff;
			border-radius: 50%;
			position: absolute;
			top: 50%;
			left: 50%;
			transform: translate(-50%, -50%);
			animation: spin 1s linear infinite;
		}

		@keyframes spin {
			0% { transform: translate(-50%, -50%) rotate(0deg); }
			100% { transform: translate(-50%, -50%) rotate(360deg); }
		}

		</script>
        <?php require'footer.php'; ?>

    </section>
    <?php require'js.php'; ?>
	<script>
        $(document).ready(function(){
            $(".viewLess").show();
            $(".viewMore").hide();
            $(".view-all-btn").click(function(){
                $(".viewLess").hide();
                $(".viewMore").show();
            });
            $(".view_less_btn").click(function(){
                $(".viewLess").show();
                $(".viewMore").hide();
            });
        });
        </script>
<script>

$('#addExp').on('hidden.bs.modal', function () {
    let form = $(this).find('form');

    if (form.length) {
        form[0].reset(); 
    }
    form.find('[name="is_current"]').prop('checked', false); 
    form.find('[name="technologies"]').tagsinput && form.find('[name="technologies"]').tagsinput('removeAll'); 
    form.find('input[type="hidden"]').val(''); 
});
$('#addEducation').on('hidden.bs.modal', function () {
    let form = $(this).find('form');

    if (form.length) {
        form[0].reset(); 
    }
    form.find('[name="is_current"]').prop('checked', false); 
    form.find('[name="activities"]').tagsinput && form.find('[name="activities"]').tagsinput('removeAll'); 
    form.find('input[type="hidden"]').val(''); 
});
$('#addPortfolio').on('hidden.bs.modal', function () {
    let form = $(this).find('form');

    if (form.length) {
        form[0].reset(); 
    }
    form.find('[name="is_current"]').prop('checked', false); 
    form.find('input[type="hidden"]').val(''); 
});


function handleClick(checkbox, inputId, dateFieldId) {
    document.getElementById(dateFieldId).disabled = checkbox.checked ? true : false;
    $('#' + inputId).val(checkbox.checked ? 1 : 0);
}

	
function editWork(where_value) {
	var url="<?=base_url('isEdit');?>";
	var table = "work_experience";
	var where_column = 'id';
	$('#loading').show(); 
	$.ajax({
		type: 'POST',
		url: url,
		data: { 'table': table, 'where_column': where_column, 'where_value': where_value},
		success: function(response) {
			// alert(response);
			var response = JSON.parse(response);
			$('[name="workid"]').val(response.id);
			$('[name="company_name"]').val(response.company_name);
			$('[name="job_title"]').val(response.job_title);
			$('[name="start_date"]').val(response.start_date);
			$('[name="end_date"]').val(response.end_date);
			$('[name="location"]').val(response.location);
			$('[name="description"]').val(response.description);
			$('[name="location_type"]').val(response.location_type);
			$('[name="employment_type"]').val(response.employment_type);
			$('[name="technologies"]').tagsinput('removeAll'); 
			$('[name="technologies"]').tagsinput('add', response.technologies);
			if (response.is_current == 1) {
				$('[name="is_current"]').prop('checked', true);
			} else {
				$('[name="is_current"]').prop('checked', false);
			}

			$('#addExp').modal('show');

		}, 
		error: function() {
			console.log('Something Went Wrong ! Please Try Again.');
		},
		complete: function () {
            $('#loading').hide();
        }
	});
}
	
function editEducation(where_value) {
	var url="<?=base_url('isEdit');?>";
	var table = "education";
	var where_column = 'id';
	$('#loading').show(); 
	$.ajax({
		type: 'POST',
		url: url,
		data: { 'table': table, 'where_column': where_column, 'where_value': where_value},
		success: function(response) {
			// alert(response);
			var response = JSON.parse(response);
			$('[name="eduid"]').val(response.id);
			$('[name="institution"]').val(response.institution);
			$('[name="degree"]').val(response.degree);
			$('[name="field_of_study"]').val(response.field_of_study);
			$('[name="start_date"]').val(response.start_date);
			$('[name="end_date"]').val(response.end_date);
			$('[name="grade"]').val(response.grade);
			$('[name="description"]').val(response.description);
			$('[name="activities"]').tagsinput('removeAll'); 
			$('[name="activities"]').tagsinput('add', response.activities);
			if (response.is_current == 1) {
				$('[name="is_current"]').prop('checked', true);
			} else {
				$('[name="is_current"]').prop('checked', false);
			}

			$('#addEducation').modal('show');

		}, 
		error: function() {
			console.log('Something Went Wrong ! Please Try Again.');
		},
		complete: function () {
            $('#loading').hide();
        }
	});
}
	
function editPortfolio(where_value) {
	var url="<?=base_url('isEdit');?>";
	var table = "work_portfolio";
	var where_column = 'id';
	$('#loading').show(); 
	$.ajax({
		type: 'POST',
		url: url,
		data: { 'table': table, 'where_column': where_column, 'where_value': where_value},
		success: function(response) {
			// alert(response);
			var response = JSON.parse(response);
			$('[name="portid"]').val(response.id);
			$('[name="title"]').val(response.title);
			$('[name="url"]').val(response.url);
			$('[name="start_date"]').val(response.start_date);
			$('[name="end_date"]').val(response.end_date);
			$('[name="description"]').val(response.description);
			if (response.is_current == 1) {
				$('[name="is_current"]').prop('checked', true);
			} else {
				$('[name="is_current"]').prop('checked', false);
			}
			$('#img_div').attr('class', 'col-md-3');
			$('#image_div').css('display', 'block');

			img='<?=base_url('uploads/work/');?>'+response.image;
			$('#curr_img').attr('src', img);
			$('#a_curr_img').attr('href', img);


			$('#addPortfolio').modal('show');

		}, 
		error: function() {
			console.log('Something Went Wrong ! Please Try Again.');
		},
		complete: function () {
            $('#loading').hide();
        }
	});
}
$('#addPortfolio').on('hidden.bs.modal', function () {
    $('#submitForm4')[0].reset();
    $('#image_div').hide();
    $('#img_div').attr('class', 'col-md-6');
    $('#curr_img').attr('src', '');
    $('#a_curr_img').attr('href', '#');
});

	
function editSkill() {
	var where_value="<?=$this->session->userdata('employee')['id'];?>";
	var url="<?=base_url('isEdit');?>";
	var table = "career_preferences";
	var where_column = 'created_by';
	$('#loading').show(); 
	$.ajax({
		type: 'POST',
		url: url,
		data: { 'table': table, 'where_column': where_column, 'where_value': where_value},
		success: function(response) {
			var response = JSON.parse(response);
			if ( response.res == 'error') {
				window.location.href = '<?=base_url('career-preference');?>';
			}else{
				$('[name="skills"]').tagsinput('removeAll'); 
				$('[name="skills"]').tagsinput('add', response.skills);
				$('#addSkills').modal('show');
			}

		}, 
		error: function() {
			console.log('Something Went Wrong ! Please Try Again.');
		},
		complete: function () {
            $('#loading').hide();
        }
	});
}

function Delete(where_value,table){
	var url="<?=base_url('delete-parmanently');?>";
	var where_column='id';
	DeleteData(url,table,where_column,where_value);
}

	</script>
  </body>
</html>