<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Privacy Policy — Jobkaro.in</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;normal;700&display=swap');

    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #f1f5f9, #e2e8f0);
      color: #374151;
      padding: 3rem 1rem;
    }

    .policy-container {
      max-width: 1000px;
      margin: auto;
      background: #ffffff;
      padding: 3rem 3.5rem;
      border-radius: 16px;
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .policy-container:hover {
      transform: translateY(-4px);
      box-shadow: 0 12px 35px rgba(0, 0, 0, 0.1);
    }

    h1 {
      color: #0f172a;
      font-weight: normal;
    }

    h2 {
      color: #1e293b;
      font-size: 1.4rem;
      margin-top: 2rem;
      border-left: 5px solid #3b82f6;
      padding-left: 0.75rem;
      font-weight: normal;
    }

    h5 {
      color: #334155;
      font-weight: normal;
      margin-top: 1rem;
    }

    p, li {
      font-size: 0.95rem;
      line-height: 1.7;
    }

    ul {
      margin-left: 1.2rem;
    }

    address, a {
      color: #2563eb;
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    hr {
      border-top: 1px solid #e2e8f0;
      margin: 1.5rem 0;
    }

    footer {
      text-align: center;
      margin-top: 2rem;
      color: #6b7280;
      font-size: 0.9rem;
      border-top: 1px solid #e5e7eb;
      padding-top: 1.2rem;
    }

    .badge-date {
      background-color: #dbeafe;
      color: #1e40af;
      border-radius: 8px;
      padding: 0.35rem 0.6rem;
      font-size: 0.85rem;
      margin: 0 0.3rem;
    }

    @media (max-width: 768px) {
      .policy-container {
        padding: 2rem 1.5rem;
      }
    }
  </style>
</head>
<body>
  <div class="policy-container">
    <h1 class="text-center mb-2">Privacy Policy</h1>
    <p class="text-center fs-5 fw-semibold mb-1 text-primary">Jobkaro.in</p>
    <p class="text-center text-muted mb-3">
      Effective Date: <span class="badge-date">10-10-2025</span> 
      | Last Updated: <span class="badge-date">11-10-2025</span>
    </p>
    <hr>

    <p>Welcome to <strong>Jobkaro.in</strong> (“we”, “our”, “us”). Your privacy is important to us. This Privacy Policy explains how we collect, use, disclose, and protect your information when you visit or use our website <strong>www.jobkaro.in</strong> (the “Website”) and our related services, including our mobile application (collectively, the “Services”).</p>

    <p>By accessing or using our Services, you agree to the terms of this Privacy Policy. If you do not agree, please do not use our Services.</p>

    <h2>1. Information We Collect</h2>
    <p>We collect different types of information to provide and improve our Services for you:</p>

    <h5>a. Personal Information</h5>
    <ul>
      <li>Full name</li>
      <li>Email address</li>
      <li>Phone number</li>
      <li>Gender and date of birth (optional)</li>
      <li>Resume/CV, job preferences, and education/work details</li>
      <li>Location (city, state)</li>
      <li>Profile photo (if uploaded)</li>
    </ul>

    <h5>b. Non-Personal Information</h5>
    <ul>
      <li>Browser type and version</li>
      <li>Device type and operating system</li>
      <li>IP address</li>
      <li>Date and time of visits</li>
      <li>Pages viewed and time spent on our Website</li>
    </ul>

    <h5>c. Cookies and Tracking</h5>
    <p>We use cookies, web beacons, and similar technologies to enhance user experience, analyze traffic, and improve our services. You can choose to disable cookies through your browser settings.</p>

    <h2>2. How We Use Your Information</h2>
    <ul>
      <li>To create and manage your Jobkaro account</li>
      <li>To match job seekers with relevant employers</li>
      <li>To send job alerts, updates, and notifications</li>
      <li>To communicate with you regarding job applications or inquiries</li>
      <li>To personalize user experience and improve our platform</li>
      <li>To ensure compliance with legal obligations</li>
    </ul>

    <h2>3. How We Share Your Information</h2>
    <ul>
      <li><strong>Employers/Recruiters:</strong> When you apply for a job or make your profile public.</li>
      <li><strong>Service Providers:</strong> For website hosting, data analysis, payment processing, or communication services.</li>
      <li><strong>Legal Authorities:</strong> If required by law or to protect our legal rights.</li>
    </ul>
    <p>We do not sell your personal data to any third parties.</p>

    <h2>4. Data Security</h2>
    <p>We use appropriate technical and organizational measures to protect your personal data against unauthorized access, alteration, disclosure, or destruction. However, please note that no method of online transmission or storage is 100% secure.</p>

    <h2>5. Your Rights</h2>
    <ul>
      <li>Access and update your information</li>
      <li>Delete your account and personal data</li>
      <li>Opt out of marketing emails or notifications</li>
      <li>Withdraw your consent at any time</li>
    </ul>
    <p>To exercise these rights, please contact us at <a href="mailto:support@jobkaro.in">support@jobkaro.in</a>.</p>

    <h2>6. Data Retention</h2>
    <p>We retain your personal data only as long as necessary for the purposes stated in this policy or as required by law. When data is no longer needed, it is securely deleted.</p>

    <h2>7. Third-Party Links</h2>
    <p>Our Website may contain links to third-party websites. We are not responsible for the privacy practices or content of these websites. Please review their privacy policies before providing any personal data.</p>

    <h2>8. Children’s Privacy</h2>
    <p>Our Services are not intended for children under 16 years of age. We do not knowingly collect personal data from minors.</p>

    <h2>9. Updates to This Policy</h2>
    <p>We may update this Privacy Policy from time to time. The updated version will be posted on this page with the revised date.</p>

    <h2>10. Contact Us</h2>
    <p>If you have any questions or concerns regarding this Privacy Policy, please contact us at:</p>
    <address>
      <strong>Jobkaro.in</strong><br>
      Email: <a href="mailto:support@jobkaro.in">support@jobkaro.in</a><br>
      Address: Gurgaon, Haryana, India
    </address>

    <footer>
      &copy; <span id="year"></span> Jobkaro.in — All rights reserved.
    </footer>
  </div>

  <script>
    document.getElementById('year').textContent = new Date().getFullYear();
  </script>
</body>
</html>







