<style>
.colored-toast.swal2-icon-success {
  background-color: #00ac46 !important;
}

.colored-toast.swal2-icon-error {
  background-color: #d32536 !important;
}

.colored-toast.swal2-icon-warning {
  background-color: #f8bb86 !important;
}

.colored-toast.swal2-icon-info {
  background-color: #3fc3ee !important;
}

.colored-toast.swal2-icon-question {
  background-color: #87adbd !important;
}

.colored-toast .swal2-title {
  color: white;
}

.colored-toast .swal2-close {
  color: white;
}

.colored-toast .swal2-html-container {
  color: white;
}
	</style>
	
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/notify/0.4.2/notify.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
 <?php require'push_notification_website.php';?>
<script>

// function test(){
// Toast.fire({
  // icon: 'error',
  // title: 'something went wrong! Please check JS Code',
// })
// }
$( document ).ready(function() {
        $('form').parsley();
		 // test();
    });
document.addEventListener("DOMContentLoaded", function () {
	let otpInputs = document.querySelectorAll("input[name='otp[]']");
	otpInputs.forEach((input, index) => {
		input.addEventListener("input", function () {
			this.value = this.value.replace(/[^0-9]/g, '');
			if (this.value.length === 1 && index < otpInputs.length - 1) {
				otpInputs[index + 1].focus();
			}
		});
		input.addEventListener("keydown", function (event) {
			if (event.key === "Backspace" && this.value.length === 0 && index > 0) {
				otpInputs[index - 1].focus();
			}
		});
	});
});

function showLoginModal(type){
	$('.modal').modal('hide');
	$('#typeLogin').val(type);
	$('#login').modal('show');
}
let resendLink = document.getElementById("resendLink");
let timerDisplay = document.getElementById("timer");
let countdown; 

function startTimer(timeLeft) {
    if (countdown) {
        clearInterval(countdown);
    }
    resendLink.style.pointerEvents = "none";
    resendLink.style.color = "#888";
    resendLink.textContent = "Resend in ";
    countdown = setInterval(function () {
        timerDisplay.textContent = `00:${timeLeft < 10 ? "0" + timeLeft : timeLeft}`;
        timeLeft--;

        if (timeLeft < 0) {
            clearInterval(countdown);
            timerDisplay.textContent = "";
            resendLink.style.pointerEvents = "auto";
            resendLink.style.color = "#007bff";
            resendLink.textContent = "Resend";
        }
    }, 1000);
}
	
// var myCarousel = document.querySelector('#demo')
	// var carousel = new bootstrap.Carousel(myCarousel, {
	// interval: 1000,
// })

function editUsername(){
	$(".loginDiv").css("display", "block");
	$(".OTPDiv").css("display", "none");
	$(".setPassDiv").css("display", "none");
}

const Toast = Swal.mixin({  
	  toast: true,
	  position: 'top',
	  iconColor: 'white',
	  customClass: {
		popup: 'colored-toast',
	  },
	  showConfirmButton: false,
	  timer: 3000,
	  timerProgressBar: true,
	  didOpen: (toast) => {
		toast.addEventListener('mouseenter', Swal.stopTimer)
		toast.addEventListener('mouseleave', Swal.resumeTimer)
	  }
});

$("#loginForm").on('submit', function(e) {
	e.preventDefault();
	var data = new FormData(this);
	var username= $('#username').val();
	if ($(this).parsley().isValid()) {
		$.ajax({
			type: $(this).attr('method'),
			url: $(this).attr('action'),
			data: data,
			cache: false,
			contentType: false,
			processData: false,
			beforeSend: function() {
				$("#loginBtn").attr("disabled", true);
				$('#loginSpin').show();
			},
			success: function(response) {
				// console.log(response);
				// alert(response);
				$("#loginBtn").removeAttr("disabled");
				$('#loginSpin').hide();
				var response = JSON.parse(response);
				if (response.res == 'success') {
					 Toast.fire({
					  icon: 'success',
					  title: response.msg,
					})
					$(".loginDiv").css("display", "none");
					$(".OTPDiv").css("display", "block");
					$(".setPassDiv").css("display", "none");
					$('#usernameOtp').val(username);
					$('#mobileOtp').html(response.mobile);
					$('#typeOtp').val(response.type);
					startTimer(30);
					// window.setTimeout(function() {
						// window.location.href = response.redirectLink;
					// }, 2000);
				}else{
					 Toast.fire({
					  icon: 'error',
					  title: response.msg,
					})
				}
			},
			error: function(err) {
				$("#loginBtn").removeAttr("disabled");
				$('#loginSpin').hide();
				Toast.fire({
				  icon: 'error',
				  title: 'Server side error',
				})
				console.log('Error:',err);
			}
		});
		} else {
			alert('cdn missing');
		return false;
	}
	
});

$("#verifyForm").on('submit', function(e) {
	e.preventDefault();
	var data = new FormData(this);
	var username= $('#username').val();
	if ($(this).parsley().isValid()) {
		$.ajax({
			type: $(this).attr('method'),
			url: $(this).attr('action'),
			data: data,
			cache: false,
			contentType: false,
			processData: false,
			beforeSend: function() {
				$("#verifyBtn").attr("disabled", true);
				$('#verifySpin').show();
			},
			success: function(response) {
				// console.log(response);
				// alert(response);
				$("#verifyBtn").removeAttr("disabled");
				$('#verifySpin').hide();
				var response = JSON.parse(response);
				if (response.res == 'success') {
					 Toast.fire({
					  icon: 'success',
					  title: response.msg,
					})
					$('#login').modal('hide');
					if (response.isRedirect == true) {
                        if (response.wayOfRedirect == 'reload') {
                            window.setTimeout(function() {
                                window.location.reload();
                            }, 2000);
                            } else if (response.wayOfRedirect == 'redirect') {
                            window.setTimeout(function() {
                                window.location.href = response.redirectLink;
                            }, 1000);
                        }
                    }
				}else{
					 Toast.fire({
					  icon: 'error',
					  title: response.msg,
					})
				}
			},
			error: function(err) {
				$("#verifyBtn").removeAttr("disabled");
				$('#verifySpin').hide();
				Toast.fire({
				  icon: 'error',
				  title: 'Server side error',
				})
				console.log('Error:',err);
			}
		});
		} else {
			alert('cdn missing');
		return false;
	}
	
});

function handleFormSubmission(formId, submitBtnId, submitSpinId) {
    $(formId).on('submit', function (e) {
        e.preventDefault();
        var data = new FormData(this);
        
        if ($(this).parsley().isValid()) {
            $.ajax({
                type: $(this).attr('method'),
                url: $(this).attr('action'),
                data: data,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    $(submitBtnId).attr("disabled", true);
                    $(submitSpinId).show();
                },
                success: function (response) {
                    $(submitBtnId).removeAttr("disabled");
                    $(submitSpinId).hide();
                    var response = JSON.parse(response);

                    if (response.res == 'success') {
                        Toast.fire({
                            icon: 'success',
                            title: response.msg,
                        });

                        $(formId)[0].reset();

                        if (response.isRedirect) {
                            setTimeout(function () {
                                if (response.wayOfRedirect === 'reload') {
                                    window.location.reload();
                                } else if (response.wayOfRedirect === 'redirect') {
                                    window.location.href = response.redirectLink;
                                }
                            }, 700);
                        }
                    } else {
                        Toast.fire({
                            icon: 'error',
                            title: response.msg,
                        });
                    }
                },
                error: function (err) {
                    $(submitBtnId).removeAttr("disabled");
                    $(submitSpinId).hide();
                    Toast.fire({
                        icon: 'error',
                        title: 'Server-side error',
                    });
                    console.log('Error:', err);
                }
            });
        } else {
            Toast.fire({
                icon: 'warning',
                title: 'CDN missing, please refresh the page.',
            });
            return false;
        }
    });
} 

// Call the function for each form
handleFormSubmission("#submitForm", "#submitBtn", "#submitSpin");
handleFormSubmission("#submitForm2", "#submitBtn2", "#submitSpin2");
handleFormSubmission("#submitForm3", "#submitBtn3", "#submitSpin3");
handleFormSubmission("#submitForm4", "#submitBtn4", "#submitSpin4");
handleFormSubmission("#submitForm5", "#submitBtn5", "#submitSpin5");


function resendOtp(){
	username= $('#usernameOtp').val();
	type= $('#typeOtp').val();
	$.ajax({
		type: 'POST',
		url: "<?=base_url('resend-otp');?>",
		data: { 'type': type, 'username': username},
		success: function(res) {
			var response = JSON.parse(res);
			if (response.res == 'success') {
				 Toast.fire({
				  icon: 'success',
				  title: 'OTP send successfully',
				})
				startTimer(30);
			}else{
				 Toast.fire({
				  icon: 'error',
				  title: response.msg,
				})
			}
			
		}, 
		error: function() {
			Toast.fire({
			  icon: 'error',
			  title: 'Something went wrong, please refresh the page.',
			})
			return false;
		}
	});
}
function applyJob(job_id){
	submitBtnId='.applyBtn'+job_id;
	submitSpinId='.applySpin'+job_id;
	$.ajax({
		type: 'POST',
		url: "<?=base_url('apply-job');?>",
		data: { 'job_id': job_id},
		beforeSend: function () {
			$(submitBtnId).attr("disabled", true);
			$(submitSpinId).show();
		},
		success: function(res) {
			$(submitBtnId).removeAttr("disabled");
			$(submitSpinId).hide();
			var response = JSON.parse(res);
			if (response.res == 'success') {
				$(submitBtnId+' span').html('Applied');
				$(submitBtnId).html('Applied');
				$(submitBtnId).attr("disabled", true);
				 Toast.fire({
				  icon: 'success',
				  title: response.msg,
				});
				
			}else{
				 Toast.fire({
				  icon: 'error',
				  title: response.msg,
				});
			}
			
		}, 
		error: function() {
			$(submitBtnId).removeAttr("disabled");
			$(submitSpinId).hide();
			Toast.fire({
			  icon: 'error',
			  title: 'Something went wrong, please refresh the page.',
			});
			return false;
		}
	});
}


function saveJob(job_id){
	submitBtnId='.saveBtn'+job_id;
	submitSpinId='.saveSpin'+job_id;
	$.ajax({
		type: 'POST',
		url: "<?=base_url('save-unsave-job');?>",
		data: { 'job_id': job_id},
		beforeSend: function () {
			$(submitBtnId).attr("disabled", true);
			$(submitSpinId).show();
		},
		success: function(res) {
			$(submitBtnId).removeAttr("disabled");
			$(submitSpinId).hide();
			var response = JSON.parse(res);
			if (response.res == 'success') {
				$(submitBtnId+' span').html(response.text);
				$(submitBtnId).html(response.text);
				 Toast.fire({
				  icon: 'success',
				  title: response.msg,
				});
				
			}else{
				 Toast.fire({
				  icon: 'error',
				  title: response.msg,
				});
			}
			
		}, 
		error: function() {
			$(submitBtnId).removeAttr("disabled");
			$(submitSpinId).hide();
			Toast.fire({
			  icon: 'error',
			  title: 'Something went wrong, please refresh the page.',
			});
			return false;
		}
	});
}


function DeleteData(url,table,where_column,where_value){
	Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: { 'table': table, 'where_column': where_column, 'where_value': where_value},
                    success: function(response) {
                        // alert(response);
                        console.log(response);
                        var response = JSON.parse(response);
                        if (response.res == 'success') {
							Toast.fire({
							  icon: 'success',
							  title: response.msg,
							})
						}else{
							Toast.fire({
							  icon: 'error',
							  title: response.msg,
							})
						}
						
                        if (response.isRedirect == true) {
                            if (response.wayOfRedirect == 'reload') {
                                window.setTimeout(function() {
                                    window.location.reload();
                                }, 800);
                                } else if (response.wayOfRedirect == 'redirect') {
                                window.setTimeout(function() {
                                    window.location.href = response.redirectLink;
                                }, 800);
                            }
                        }
                    },
                    error: function() {
						Toast.fire({
						  icon: 'error',
						  title: 'something went wrong! Please check JS Code',
						})
                    }
                });
            }
        })
}
function getCity() {
    var state_id = $("#state_id").val();
    if(state_id) {
        $.ajax({
            url: "<?= base_url('get-cities'); ?>",
            type: "POST",
            data: {state_id: state_id},
            dataType: "json",
            success: function(response) {
                $("#city_id").html('<option value="">Choose</option>');
                $.each(response, function(index, value) {
                    $("#city_id").append('<option value="'+value.name+'">'+value.name+'</option>');
                });
            }
        });
    }
}

</script>
<?php if ($this->session->flashdata('toast_msg')): ?>
<script>
    Toast.fire({
	  icon: 'error',
	  title: '<?= $this->session->flashdata('toast_msg'); ?>',
	})
</script>
<?php endif; ?>

<?php require'webrtc.php';?> 
