<!doctype html>
<html lang="en">
  <?php require'css.php';?>
    <style>
  .loader {
			width: 50px;
			height: 50px;
			border: 5px solid #323643; /* Dark Gray */
			border-top: 5px solid #f4f500; /* Yellow */
			border-radius: 50%;
			animation: spin 1s linear infinite;
			margin: 20px auto;
		}

		@keyframes spin {
			0% { transform: rotate(0deg); }
			100% { transform: rotate(360deg); }
		}
  </style>
  <body>
    <section class="position-relative mob-hide">
        <img class="position-absolute grid-img" src="img/grid.png" alt="">
        <div class="head-section">
            <div class="custom-col-10 mx-auto">
            <?php require'header2.php';?>
            <h4 class="title mt-5">Discover Opportunities Tailored to You</h4>
            </div>
        </div>
    </section>



    <section class="container-fluid search-div mob-hide">
        <div class="custom-col-10 mx-auto">
            <div class="search-section">
                <div class="col-md-8 d-flex">
                    <svg class="my-auto me-3" xmlns="http://www.w3.org/2000/svg" width="28" height="29" viewBox="0 0 28 29" fill="none">
                        <path d="M14 22.665C18.5103 22.665 22.1667 19.0087 22.1667 14.4984C22.1667 9.98804 18.5103 6.3317 14 6.3317C9.48969 6.3317 5.83335 9.98804 5.83335 14.4984C5.83335 19.0087 9.48969 22.665 14 22.665Z" stroke="#202020" stroke-opacity="0.6" stroke-width="1.16667"/>
                        <path d="M24.5744 25.3835L21.0744 21.8835" stroke="#202020" stroke-opacity="0.6" stroke-width="1.16667" stroke-linecap="round"/>
                    </svg>
                    <input type="text" class="form-control input1" id="search-input" placeholder="Search job">
                </div>
                <div class="col-md-4 d-flex justify-content-end gap-2">
                    <button onclick="location.reload()" class="custom-btn2-outline py-2">Reset</button>

                    <button class="custom-btn py-2" onclick="search()">Search</button>
                </div>
            </div>
        </div>
    </section>

    <section class="recom-job py-3">
        
        <div class="custom-col-10 mx-auto mt-3">
            <div class="row">
                <div class="mob-show text-end mb-3">
                    <button class="btn btn-light filterButon">Filter <svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20" fill="none">
                        <path d="M16.2088 12.5208H6.78486M3.45843 12.5208H2.09766M3.45843 12.5208C3.45843 12.0798 3.63362 11.6568 3.94546 11.345C4.2573 11.0331 4.68025 10.858 5.12126 10.858C5.56227 10.858 5.98522 11.0331 6.29706 11.345C6.6089 11.6568 6.78409 12.0798 6.78409 12.5208C6.78409 12.9618 6.6089 13.3847 6.29706 13.6966C5.98522 14.0084 5.56227 14.1836 5.12126 14.1836C4.68025 14.1836 4.2573 14.0084 3.94546 13.6966C3.63362 13.3847 3.45843 12.9618 3.45843 12.5208ZM16.2088 7.48119H13.8404M10.514 7.48119H2.09766M10.514 7.48119C10.514 7.04018 10.6892 6.61723 11.0011 6.30539C11.3129 5.99355 11.7358 5.81836 12.1769 5.81836C12.3952 5.81836 12.6114 5.86137 12.8132 5.94493C13.0149 6.0285 13.1982 6.15098 13.3527 6.30539C13.5071 6.4598 13.6295 6.64311 13.7131 6.84485C13.7967 7.0466 13.8397 7.26282 13.8397 7.48119C13.8397 7.69956 13.7967 7.91578 13.7131 8.11753C13.6295 8.31927 13.5071 8.50258 13.3527 8.65699C13.1982 8.8114 13.0149 8.93388 12.8132 9.01745C12.6114 9.10101 12.3952 9.14402 12.1769 9.14402C11.7358 9.14402 11.3129 8.96883 11.0011 8.65699C10.6892 8.34515 10.514 7.9222 10.514 7.48119Z" stroke="#004B9B" stroke-width="1.14415" stroke-miterlimit="10" stroke-linecap="round"></path>
                        </svg></button>
                </div>
                <div class="col-md-4 mb-3 filterDiv">
                    <div class="Filter-Div">
                        <div class="bg-white p-4 border-12 h-100 multistep-Form">
                            <p class="fs-5" style="color: #004B9B;">All Filter <svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20" fill="none">
                            <path d="M16.2088 12.5208H6.78486M3.45843 12.5208H2.09766M3.45843 12.5208C3.45843 12.0798 3.63362 11.6568 3.94546 11.345C4.2573 11.0331 4.68025 10.858 5.12126 10.858C5.56227 10.858 5.98522 11.0331 6.29706 11.345C6.6089 11.6568 6.78409 12.0798 6.78409 12.5208C6.78409 12.9618 6.6089 13.3847 6.29706 13.6966C5.98522 14.0084 5.56227 14.1836 5.12126 14.1836C4.68025 14.1836 4.2573 14.0084 3.94546 13.6966C3.63362 13.3847 3.45843 12.9618 3.45843 12.5208ZM16.2088 7.48119H13.8404M10.514 7.48119H2.09766M10.514 7.48119C10.514 7.04018 10.6892 6.61723 11.0011 6.30539C11.3129 5.99355 11.7358 5.81836 12.1769 5.81836C12.3952 5.81836 12.6114 5.86137 12.8132 5.94493C13.0149 6.0285 13.1982 6.15098 13.3527 6.30539C13.5071 6.4598 13.6295 6.64311 13.7131 6.84485C13.7967 7.0466 13.8397 7.26282 13.8397 7.48119C13.8397 7.69956 13.7967 7.91578 13.7131 8.11753C13.6295 8.31927 13.5071 8.50258 13.3527 8.65699C13.1982 8.8114 13.0149 8.93388 12.8132 9.01745C12.6114 9.10101 12.3952 9.14402 12.1769 9.14402C11.7358 9.14402 11.3129 8.96883 11.0011 8.65699C10.6892 8.34515 10.514 7.9222 10.514 7.48119Z" stroke="#004B9B" stroke-width="1.14415" stroke-miterlimit="10" stroke-linecap="round"/>
                            </svg></p>
    						<span id="filters"></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <h3 class="recom-title mb-4">Recommended Jobs</h3>
                  
				  <span class="jobList"></span>
                </div>
            </div>
        </div>
    </section>
<?php require'js.php';?>
<script>
var currentPage = 1;
var isLoading = false;
var hasMoreData = true;
let currentSearch = null;
const selectedFilters = {};
let allFilterKeys = []; 
let searchValue = $('#search-input').val();
$(document).ready(function () {
	emp_id='<?=$empl_id;?>';
	loadHomePage();
	$(window).scroll(function () {
		if ($(window).scrollTop() + $(window).height() >= $(document).height() - 100) {
			loadHomePage(currentPage,searchValue,false,selectedFilters);
		}
	});
});
function search() {
	 searchValue = $('#search-input').val();
	if (searchValue.length > 0) {
		loadHomePage(1, searchValue, true,selectedFilters);
	} else {
		loadHomePage(1, null, true);
	}
}

document.addEventListener('click', function (e) {
    if (e.target.matches('.dropdown-item')) {
        e.preventDefault();

        const key = e.target.dataset.key;
        const value = e.target.dataset.value;

        if (!selectedFilters[key]) selectedFilters[key] = [];

        if (!selectedFilters[key].includes(value)) {
            selectedFilters[key].push(value);
        } else {
            // Toggle off if already selected
            selectedFilters[key] = selectedFilters[key].filter(v => v !== value);
        }
	
        const fullFilters = {};
        allFilterKeys.forEach(k => {
            fullFilters[k] = selectedFilters[k] || [];
        });
		currentPage = 1;
    hasMoreData = true;
    reset = true;
        loadHomePage(1, currentSearch, true, fullFilters);
    }
});


function loadHomePage(page = 1, search = null, reset = false, filters = {}) {
	const url = '<?= base_url('api/employee/recommended'); ?>';
	if (isLoading) return;
    if (!hasMoreData && !reset) return;
	if (reset) {
		currentPage = 1;
		hasMoreData = true;
		$('.jobList').html('');
	}
	const sanitizedFilters = {};
	for (const [k, v] of Object.entries(filters)) {
		sanitizedFilters[k] = v === null || v === undefined ? '' : v;
	}
	
	isLoading = true;
	$('.jobList').append('<div class="loader"></div>');
	currentSearch = search;
	
	const requestData = {
		page: page,
		url: url,
		emp_id: emp_id,
		search: search,
		...sanitizedFilters
	};
	$.ajax({
		type: 'POST',
		url: '<?= base_url('common-api'); ?>',
		data: requestData,
		success: function (response) {
			$('.loader').remove();
			const res = JSON.parse(response);
			if (res.status === 'success') {
				const jobs = res.data.data; 
				console.log(res);
				if (Object.keys(filters).length === 0) {
					const filters = res.data.filters;
					renderFilters(filters, '#filters');
				}
				if (jobs && jobs.length > 0) {
					renderJobs(jobs, reset);
					currentPage++;
					isLoading = false;
				} else {
					hasMoreData = false;
					isLoading = false;
					if (currentPage === 1) {
						$('.jobList').html('<div class="custom-col-10 mx-auto bg-white border12 p-4 pt-5 text-center mb-5"><h3>No job found</h3><img src="<?php echo base_url(); ?>assets/newAssets/img/saved.png" class="nodataImg"></div>');
					}
				}
				
			} else {
				Toast.fire({ icon: 'error', title: res.message });
				$('.jobList').html('<p>Error loading data.</p>');
			}
		},
		error: function () {
			$('.loader').remove();
			isLoading = false;
		}
	});
}


const base_url = "<?= base_url() ?>";
function renderJobs(jobs, reset = false) {
	const container = document.querySelector('.jobList');
	if (reset) {
		container.innerHTML = '';
	}

	jobs.forEach(job => {
		const skills = (job.job_skills || '')
  .split(',')
  .map(s => s.trim())
  .filter(Boolean)
  .map(skill => `<div class="job-cat-btn">${escapeHtml(skill)}</div>`)
  .join('');


		let saveClass = 'custom-btn2-outline';
		let saveText = 'Save for later';
		let applyClass = 'custom-btn2';
		let applyText = 'Apply Now';
		let type = '';
		let buttons = '';
		if (job.is_career == 0) {
			buttons = `
				<a class="custom-btn2" href="${base_url}career-preference"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M11.25 8.75L17.5 2.5M17.5 2.5H13.3333M17.5 2.5V6.66667M17.5 11.6667V15.8333C17.5 16.2754 17.3244 16.6993 17.0118 17.0118C16.6993 17.3244 16.2754 17.5 15.8333 17.5H4.16667C3.72464 17.5 3.30072 17.3244 2.98816 17.0118C2.67559 16.6993 2.5 16.2754 2.5 15.8333V4.16667C2.5 3.72464 2.67559 3.30072 2.98816 2.98816C3.30072 2.67559 3.72464 2.5 4.16667 2.5H8.33333" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg> Apply Now</a>
				<a class="custom-btn2-outline" href="${base_url}career-preference"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path d="M8 3H16C16.7956 3 17.5587 3.31607 18.1213 3.87868C18.6839 4.44129 19 5.20435 19 6V21L12 18L5 21V6C5 5.20435 5.31607 4.44129 5.87868 3.87868C6.44129 3.31607 7.20435 3 8 3ZM8 4.14574C7.46957 4.14574 7.13891 4.21071 6.76384 4.58579C6.38877 4.96086 6.17805 5.46957 6.17805 6V19.013L12 16.6616L17.8415 19.013V6C17.8415 5.46957 17.7037 4.96086 17.3286 4.58579C16.9535 4.21071 16.5304 4.14574 16 4.14574H8Z" fill="#007BFF"/>
                                    </svg> Save for later</a>
			`;
		} else { 
			if (job.is_saved == 1) {
				saveText = 'Saved';
			}
			if (job.is_applied == 1) {
				
				applyText = 'Applied';
				type = 'disabled';
			}

			buttons = `
				<button class="${applyClass} applyBtn${job.job_id}" ${type} onclick="event.stopPropagation();applyJob(${job.job_id})">${applyText}</button>
				<button class="${saveClass} saveBtn${job.job_id}" onclick="event.stopPropagation();saveJob(${job.job_id})">${saveText}</button>
			`;
		}

		container.innerHTML += `
			<div class="job-card position-relative mb-3" data-id="${job.job_id}" onclick="window.location.href='${base_url}job-details?job_id=${job.job_id}'" >
				<div class="d-flex justify-content-between w-100">
					<div class="d-flex gap-3">
						<img src="${job.company_logo}" alt="" class="companylogo">
						<div>
							<p class="mb-1 t1">${escapeHtml(job.job_title)}</p>
							<p class="mb-1 t2">${escapeHtml(job.salary_min)} - ${escapeHtml(job.salary_max)} <span>${escapeHtml(job.salary_type)}</span></p>
						</div>
					</div>
					<div>
						<div class="higherch-btn position-absolute end-0 top-0">
							<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
								<path d="M8.00002 1.33331L0.666687 14H15.3334M8.00002 3.99998L13 12.6666H3.00002M9.33335 9.33331H8.33335L9.33335 7.33331H6.66669V9.99998H7.33335V12L9.33335 9.33331Z" fill="#EB663D" fill-opacity="0.8"/>
							</svg>
							<span>${escapeHtml(job.tag)}</span>
						</div>
					</div>
				</div>

				<div class="dflex gap-3 mt-2">
					<div class="company-name-div">
						<p>${escapeHtml(job.company_name)}</p>
					</div>
					<div class="skilsDiv">
						<div class="d-flex gap-2">
							<div class="job-cat-btn">${escapeHtml(job.job_type)}</div>
							<div class="job-cat-btn">${escapeHtml(job.employment_type)}</div>
							<div class="job-cat-btn">${escapeHtml(job.job_experience)}</div>
							<div class="job-cat-btn">${escapeHtml(job.no_of_opening)} Vacancy</div>
							${skills}
						</div>
					</div>
				</div>

				<div class="locafont d-flex gap-2 mt-2">
					<svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
						<path d="M3.52366 3.01413C4.34419 2.21001 5.4489 1.7622 6.59774 1.768C7.74658 1.7738 8.84672 2.23275 9.65908 3.04512C10.4714 3.85748 10.9304 4.95762 10.9362 6.10646C10.942 7.2553 10.4942 8.36001 9.69007 9.18054L7.38537 11.4852C7.17888 11.6917 6.89885 11.8076 6.60686 11.8076C6.31488 11.8076 6.03485 11.6917 5.82835 11.4852L3.52366 9.18054C2.70599 8.3628 2.24664 7.25374 2.24664 6.09733C2.24664 4.94093 2.70599 3.83187 3.52366 3.01413Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"/>
						<path d="M6.60686 7.74881C7.51908 7.74881 8.25858 7.00931 8.25858 6.09709C8.25858 5.18487 7.51908 4.44537 6.60686 4.44537C5.69464 4.44537 4.95514 5.18487 4.95514 6.09709C4.95514 7.00931 5.69464 7.74881 6.60686 7.74881Z" fill="#202020" fill-opacity="0.6"/>
					</svg>
					<span class="my-auto">${escapeHtml(job.job_city)}</span>
					<span class="dott my-auto"></span>
					<span class="my-auto">${escapeHtml(job.employment_type)}</span>
				</div>
			 <div class="dflex justify-content-between pt-3 border-dashed mt-3">
				<div class="d-flex gap-3 justify-content-center">
					${buttons}
				</div>
				<div class="d-flex gap-2 post-text">
					<span class="my-auto">${escapeHtml(job.job_created_at)}</span>
					<span class="post-text-dot my-auto"></span>
					<span class="my-auto">${escapeHtml(job.total_applicant)} Applicants</span>
				</div>
			</div>
			</div>
		`;
	});
}


function escapeHtml(text) {
	const map = {
		'&': '&amp;',
		'<': '&lt;',
		'>': '&gt;',
		'"': '&quot;',
		"'": '&#039;',
	};
	return text?.toString().replace(/[&<>"']/g, m => map[m]) || '';
}

function renderFilters(filters, container) {
    const filterContainer = typeof container === 'string'
        ? document.querySelector(container)
        : container;

    if (!filterContainer) {
        console.error('Filter container not found:', container);
        return;
    }

    filterContainer.innerHTML = ''; // Clear previous filters

    allFilterKeys = filters.map(group => group.value); // Store all keys

    filters.forEach(filterGroup => {
        const groupTitle = document.createElement('h5');
        groupTitle.textContent = filterGroup.title;
        filterContainer.appendChild(groupTitle);

        const skillSetWrapper = document.createElement('div');
        skillSetWrapper.className = 'skilset justify-content-start my-3';

        filterGroup.data.forEach(option => {
            const span = document.createElement('span');
            span.className = 'profile-skillSet';
            span.setAttribute('data-key', filterGroup.value);
            span.setAttribute('data-value', option.value);

            const isSelected = selectedFilters[filterGroup.value]?.includes(option.value);

            span.innerHTML = isSelected
                ? `
                    <svg class="check-icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2ZM10 17L5 12L6.41 10.59L10 14.17L17.59 6.58L19 8L10 17Z" fill="#007BFF"></path>
                    </svg>
                    <span class="my-auto">${option.title}</span>
                `
                : `
                    <span class="my-auto">${option.title}</span> 
                    <svg class="plus-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                        <path d="M8.66536 3.83268V7.83268L12.6654 7.83268V9.16602H8.66536V13.166H7.33203V9.16602H3.33203V7.83268H7.33203L7.33203 3.83268H8.66536Z" fill="#202020"/>
                    </svg>
                `;

            if (isSelected) {
                span.classList.add('active');
            }

            span.addEventListener('click', function () {
                const key = span.getAttribute('data-key');
                const value = span.getAttribute('data-value');
                const label = option.title;

                if (!selectedFilters[key]) {
                    selectedFilters[key] = [];
                }

                const isActive = span.classList.contains('active');

                if (isActive) {
                    // Remove from selected
                    selectedFilters[key] = selectedFilters[key].filter(v => v !== value);
                    span.classList.remove('active');
                    span.innerHTML = `
                        <span class="my-auto">${label}</span> 
                        <svg class="plus-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                            <path d="M8.66536 3.83268V7.83268L12.6654 7.83268V9.16602H8.66536V13.166H7.33203V9.16602H3.33203V7.83268H7.33203L7.33203 3.83268H8.66536Z" fill="#202020"/>
                        </svg>
                    `;
                } else {
                    // Add to selected
                    selectedFilters[key].push(value);
                    span.classList.add('active');
                    span.innerHTML = `
                        <svg class="check-icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path d="M12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2ZM10 17L5 12L6.41 10.59L10 14.17L17.59 6.58L19 8L10 17Z" fill="#007BFF"></path>
                        </svg>
                        <span class="my-auto">${label}</span>
                    `;
                }

                // Prepare full filter set
                const fullFilters = {};
                allFilterKeys.forEach(k => {
                    fullFilters[k] = selectedFilters[k] || [];
                });

                // Trigger filter update
                loadHomePage(1, currentSearch, true, fullFilters);
            });

            skillSetWrapper.appendChild(span);
        });

        filterContainer.appendChild(skillSetWrapper);
    });
}


</script>

<script>
$(document).ready(function() {
  // Check if screen width is 768px or less
  if ($(window).width() <= 768) {
    $(".Filter-Div").hide();
    
    $(".filterButon").click(function() {
      $(".Filter-Div").toggle();
    });
  }
});
</script>


  </body>
</html>