<!doctype html>
<html lang="en">
  <?php require'css.php';?>
  <body>
  <style>
  .loader {
			width: 50px;
			height: 50px;
			border: 5px solid #323643; /* Dark Gray */
			border-top: 5px solid #f4f500; /* Yellow */
			border-radius: 50%;
			animation: spin 1s linear infinite;
			margin: 20px auto;
		}

		@keyframes spin {
			0% { transform: rotate(0deg); }
			100% { transform: rotate(360deg); }
		}
  </style>
    <section class="position-relative">
        <img class="position-absolute grid-img mob-hide" src="<?=base_url('assets/newAssets/img/')?>grid.png" alt="">
        <div class="head-section">
            <div class="custom-col-10 mx-auto">
            <?php require'header2.php';?>

            <h4 class="title mt-5 mob-hide">Discover Opportunities Tailored to You</h4>
			
            </div>
        </div>
    </section>

    <section class="container-fluid search-div mob-hide">
        <div class="custom-col-10 mx-auto">
            <div class="search-section">
                <div class="col-md-8 d-flex">
                    <svg class="my-auto me-3" xmlns="http://www.w3.org/2000/svg" width="28" height="29" viewBox="0 0 28 29" fill="none">
                        <path d="M14 22.665C18.5103 22.665 22.1667 19.0087 22.1667 14.4984C22.1667 9.98804 18.5103 6.3317 14 6.3317C9.48969 6.3317 5.83335 9.98804 5.83335 14.4984C5.83335 19.0087 9.48969 22.665 14 22.665Z" stroke="#202020" stroke-opacity="0.6" stroke-width="1.16667"/>
                        <path d="M24.5744 25.3835L21.0744 21.8835" stroke="#202020" stroke-opacity="0.6" stroke-width="1.16667" stroke-linecap="round"/>
                    </svg>
                    <input type="text" class="form-control input1" id="search-input" placeholder="Search job">
                </div>
               <!-- <svg xmlns="http://www.w3.org/2000/svg" width="2" height="47" viewBox="0 0 2 47" fill="none">
                    <path d="M1 1.67383L1 45.3242" stroke="#202020" stroke-opacity="0.2" stroke-width="2" stroke-linecap="round"/>
                </svg>
                <svg class="my-auto mx-3" xmlns="http://www.w3.org/2000/svg" width="28" height="29" viewBox="0 0 28 29" fill="none">
                    <path d="M7.46668 6.05235C9.20539 4.34842 11.5463 3.3995 13.9807 3.4118C16.4151 3.4241 18.7463 4.39661 20.4677 6.11802C22.1891 7.83942 23.1616 10.1706 23.1739 12.605C23.1862 15.0394 22.2373 17.3803 20.5333 19.119L15.6497 24.0027C15.2121 24.4401 14.6187 24.6859 14 24.6859C13.3813 24.6859 12.7879 24.4401 12.3503 24.0027L7.46668 19.119C5.73405 17.3862 4.76068 15.0361 4.76068 12.5857C4.76068 10.1352 5.73405 7.78516 7.46668 6.05235Z" stroke="#202020" stroke-opacity="0.6" stroke-width="1.75" stroke-linejoin="round"/>
                    <path d="M14 16.0857C15.933 16.0857 17.5 14.5187 17.5 12.5857C17.5 10.6527 15.933 9.08569 14 9.08569C12.067 9.08569 10.5 10.6527 10.5 12.5857C10.5 14.5187 12.067 16.0857 14 16.0857Z" stroke="#202020" stroke-opacity="0.6" stroke-width="1.75" stroke-linecap="round" stroke-linejoin="round"/>
                  </svg>
                <input type="text" class="form-control input2" placeholder="Add Location ">-->
                <div class="col-md-4 d-flex justify-content-end gap-2">
                    <button onclick="location.reload()" class="custom-btn2-outline py-2">Reset</button>

                    <button class="custom-btn py-2" onclick="search()">Search</button>
                </div>
            </div>
        </div>
    </section>

    <section class="recom-job py-3 mob-hide">
        <div style="padding: 0 5%; background: #EDF6FF;" class="sticky-top1 py-3">
            <div class="d-flex w-100">
                <div class="col-md-4">
                    <h3 class="recom-title">Recommended Jobs</h3>
                </div>
                <div class="col-md-8">
                    <div class="d-flex gap-2 job-filter-bar justify-content-end" id="filters">
                        <!--<button class="custom-btn py-2">Submit</button>-->
                    </div>
                </div>
            </div>
        </div>
        <div class="custom-col-10 mx-auto mt-3">
            <div class="row">
                <div class="col-md-6 jobList">
				
                </div>
                <div class="col-md-6" id="jobDetailsData"></div>
            </div>
        </div>
    </section>


    <section class="position-relative mob-show" style="background: #F6FBFF;">
        <div class="text-center px-0">
            <div class="mob-show p-2 mt-3">
                <div class="search-divMob">
                    <div class="d-flex justify-content-between">
                        <div class="d-flex gap-2">
                            <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M14.0775 14.0987L16.6442 16.6654M15.8334 9.58203C15.8334 11.2396 15.1749 12.8293 14.0028 14.0014C12.8307 15.1736 11.241 15.832 9.58337 15.832C7.92577 15.832 6.33606 15.1736 5.16396 14.0014C3.99185 12.8293 3.33337 11.2396 3.33337 9.58203C3.33337 7.92443 3.99185 6.33472 5.16396 5.16261C6.33606 3.99051 7.92577 3.33203 9.58337 3.33203C11.241 3.33203 12.8307 3.99051 14.0028 5.16261C15.1749 6.33472 15.8334 7.92443 15.8334 9.58203Z" stroke="#202020" stroke-opacity="0.7" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                            <input type="text" id="search-input-mobile" oninput="searchMobile()" placeholder="Search for Company, Skills....">
                        </div>
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.25 5.41797V10.418C7.25 10.7791 7.32113 11.1367 7.45933 11.4703C7.59753 11.804 7.8001 12.1072 8.05546 12.3625C8.31082 12.6179 8.61398 12.8204 8.94762 12.9586C9.28127 13.0968 9.63886 13.168 10 13.168C10.3611 13.168 10.7187 13.0968 11.0524 12.9586C11.386 12.8204 11.6892 12.6179 11.9445 12.3625C12.1999 12.1072 12.4025 11.804 12.5407 11.4703C12.6789 11.1367 12.75 10.7791 12.75 10.418V5.41797C12.75 4.68862 12.4603 3.98915 11.9445 3.47343C11.4288 2.9577 10.7293 2.66797 10 2.66797C9.27065 2.66797 8.57118 2.9577 8.05546 3.47343C7.53973 3.98915 7.25 4.68862 7.25 5.41797ZM10.5 16.648V19.168H9.5V16.648C7.93398 16.5223 6.47273 15.8114 5.4072 14.6569C4.34166 13.5025 3.74999 11.989 3.75 10.418V9.16797H4.75V10.418C4.75 11.8104 5.30312 13.1457 6.28769 14.1303C7.27226 15.1148 8.60761 15.668 10 15.668C11.3924 15.668 12.7277 15.1148 13.7123 14.1303C14.6969 13.1457 15.25 11.8104 15.25 10.418V9.16797H16.25V10.418C16.25 11.989 15.6583 13.5025 14.5928 14.6569C13.5273 15.8114 12.066 16.5223 10.5 16.648ZM6.25 5.41797C6.25 4.42341 6.64509 3.46958 7.34835 2.76632C8.05161 2.06306 9.00544 1.66797 10 1.66797C10.9946 1.66797 11.9484 2.06306 12.6516 2.76632C13.3549 3.46958 13.75 4.42341 13.75 5.41797V10.418C13.75 11.4125 13.3549 12.3664 12.6516 13.0696C11.9484 13.7729 10.9946 14.168 10 14.168C9.00544 14.168 8.05161 13.7729 7.34835 13.0696C6.64509 12.3664 6.25 11.4125 6.25 10.418V5.41797Z" fill="#007BFF"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid" style="padding-bottom: 5rem;">
            <h3 class="my-3">Recommended Jobs For You..</h3>
            <div class="d-flex gap-2 job-filter-bar mb-4" id="filterss" style="overflow: auto;">
              
                
                
                
            </div>
			<span class="jobListMobile"></span>
        </div>

       <!-- <div class="job-footer p-3">
            <div class="job-footer-div w-100">
                <a href="<?=base_url('jobs');?>" >
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                        <path opacity="0.3" d="M4.19775 8H20.1978V19H4.19775V8Z" fill="#202020" fill-opacity="0.5"></path>
                        <path d="M20.1978 6H16.1978V4C16.1978 2.89 15.3078 2 14.1978 2H10.1978C9.08775 2 8.19775 2.89 8.19775 4V6H4.19775C3.08775 6 2.20775 6.89 2.20775 8L2.19775 19C2.19775 20.11 3.08775 21 4.19775 21H20.1978C21.3078 21 22.1978 20.11 22.1978 19V8C22.1978 6.89 21.3078 6 20.1978 6ZM10.1978 4H14.1978V6H10.1978V4ZM20.1978 19H4.19775V8H20.1978V19Z" fill="#202020"></path>
                      </svg>
                </a>
                <a href="<?=base_url('saved-job');?>" class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                        <path d="M8.19775 3H16.1978C16.9934 3 17.7565 3.31607 18.3191 3.87868C18.8817 4.44129 19.1978 5.20435 19.1978 6V21L12.1978 18L5.19775 21V6C5.19775 5.20435 5.51382 4.44129 6.07643 3.87868C6.63904 3.31607 7.4021 3 8.19775 3ZM8.19775 4.14574C7.66732 4.14574 7.33667 4.21071 6.96159 4.58579C6.58652 4.96086 6.37581 5.46957 6.37581 6V19.013L12.1978 16.6616L18.0393 19.013V6C18.0393 5.46957 17.9014 4.96086 17.5263 4.58579C17.1513 4.21071 16.7282 4.14574 16.1978 4.14574H8.19775Z" fill="white"></path>
                    </svg>
                    Saved
                </a>
                <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                        <path d="M21.728 14.4697L19.6978 12.4395V9.75C19.6954 7.89138 19.004 6.09964 17.7572 4.72124C16.5104 3.34284 14.7968 2.4757 12.9478 2.2875V0.75H11.4478V2.2875C9.59868 2.4757 7.88507 3.34284 6.63828 4.72124C5.39149 6.09964 4.70008 7.89138 4.69775 9.75V12.4395L2.6675 14.4697C2.52684 14.6104 2.4478 14.8011 2.44775 15V17.25C2.44775 17.4489 2.52677 17.6397 2.66742 17.7803C2.80808 17.921 2.99884 18 3.19775 18H8.44775V18.5828C8.43111 19.5343 8.76636 20.4585 9.3892 21.1781C10.012 21.8977 10.8786 22.362 11.8228 22.482C12.3441 22.5337 12.8706 22.4757 13.3682 22.3117C13.8658 22.1478 14.3236 21.8815 14.7121 21.53C15.1007 21.1785 15.4113 20.7495 15.6241 20.2707C15.8369 19.792 15.9472 19.2739 15.9478 18.75V18H21.1978C21.3967 18 21.5874 17.921 21.7281 17.7803C21.8687 17.6397 21.9478 17.4489 21.9478 17.25V15C21.9477 14.8011 21.8687 14.6104 21.728 14.4697ZM14.4478 18.75C14.4478 19.3467 14.2107 19.919 13.7887 20.341C13.3668 20.7629 12.7945 21 12.1978 21C11.601 21 11.0287 20.7629 10.6068 20.341C10.1848 19.919 9.94775 19.3467 9.94775 18.75V18H14.4478V18.75ZM20.4478 16.5H3.94775V15.3105L5.978 13.2803C6.11867 13.1396 6.19771 12.9489 6.19775 12.75V9.75C6.19775 8.1587 6.82989 6.63258 7.95511 5.50736C9.08033 4.38214 10.6065 3.75 12.1978 3.75C13.7891 3.75 15.3152 4.38214 16.4404 5.50736C17.5656 6.63258 18.1978 8.1587 18.1978 9.75V12.75C18.1978 12.9489 18.2768 13.1396 18.4175 13.2803L20.4478 15.3105V16.5Z" fill="#202020"></path>
                    </svg>
                </span>
            </div>
        </div>-->

    </section>
   <?php require'js.php';?>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.11/clipboard.min.js"></script>

<script>
 var clipboard= new ClipboardJS('.copy-btn');
 clipboard.on('success', function(e) {
	Toast.fire({
	  icon: 'success',
	  title: 'Link copied successfully',
	})
});
var currentPage = 1;
var isLoading = false;
var hasMoreData = true;
let currentSearch = null;

$(document).ready(function () {
	emp_id='<?=$empl_id;?>';
	loadHomePage();
	$(window).scroll(function () {
		if ($(window).scrollTop() + $(window).height() >= $(document).height() - 100) {
			loadHomePage(currentPage);
		}
	});
});


function search() {
	let inputValue = $('#search-input').val();
	if (inputValue.length > 0) {
		loadHomePage(1, inputValue, true);
	} else {
		loadHomePage(1, null, true);
	}
}

function searchMobile() {
	let inputValue = $('#search-input-mobile').val();
	if (inputValue.length > 0) {
		loadHomePage(1, inputValue, true);
	} else {
		loadHomePage(1, null, true);
	}
}




function loadHomePage(page = 1, search = null, reset = false, filters = {}) {
	const url = '<?= base_url('api/employee/recommended'); ?>';

	if (reset) {
		currentPage = 1;
		hasMoreData = true;
		$('.jobList').html('');
	}

	if (isLoading || (!hasMoreData && !reset)) return;
	isLoading = true;
	$('.jobList').append('<div class="loader"></div>');
	currentSearch = search;
	const requestData = {
		page: currentPage,
		url: url,
		emp_id: emp_id,
		search: search,
		...filters
	};

	$.ajax({
		type: 'POST',
		url: '<?= base_url('common-api'); ?>',
		data: requestData,
		success: function (response) {
			$('.loader').remove();
			const res = JSON.parse(response);
			if (res.status === 'success') {
				const jobs = res.data.data;
				const filters = res.data.filters;
				// renderFilters(filters);
				renderFilters(filters, '#filters');
				renderFilters(filters, '#filterss');

				// console.log(jobs);
				if (jobs && jobs.length > 0) {
					
					renderJobs(jobs, reset);
					renderJobsWithActions(jobs, reset);
					currentPage++;
					isLoading = false;
				} else {
					hasMoreData = false;
					if (currentPage === 1) {
						$('.jobList').html('<h5 class="text-center mt-4">No jobs found.</h5>');
					}
				}
			} else {
				Toast.fire({ icon: 'error', title: res.message });
				$('.jobList').html('<p>Error loading data.</p>');
			}
		},
		error: function () {
			$('.loader').remove();
			isLoading = false;
		}
	});
}
const selectedFilters = {};
let allFilterKeys = []; 
document.addEventListener('click', function (e) {
	if (e.target.matches('.dropdown-item')) {
		e.preventDefault();

		const key = e.target.dataset.key;
		const value = e.target.dataset.value;
		selectedFilters[key] = value;

		const fullFilters = {};
		allFilterKeys.forEach(k => {
			fullFilters[k] = selectedFilters[k] || '';
		});
		loadHomePage(1, currentSearch, true, fullFilters);
	}
});

function renderJobs(jobs,reset = false) {
	const container = document.querySelector('.jobList');
	if (reset) {
		container.innerHTML = '';
	}
	let i = container.children.length + 1;

	jobs.forEach(job => {
		const skills = job.job_skills
			.split(',')
			.map(s => s.trim())
			.filter(Boolean)
			.map(skill => `<div class="job-cat-btn">${escapeHtml(skill)}</div>`)
			.join('');
		container.innerHTML += `
			<div class="job-card mb-3 ${i === 1 ? 'active' : ''}" data-id="${job.job_id}" onclick="jobDetails(${job.job_id})">
				<div class="d-flex justify-content-between w-100">
					<div class="d-flex gap-3">
						<img src="${job.company_logo}" alt="" class="companylogo">
						<div>
							<p class="mb-1 t1">${escapeHtml(job.job_title)}</p>
							<p class="mb-1 t2">${escapeHtml(job.salary_min)}${escapeHtml(job.salary_type)} - ${escapeHtml(job.salary_max)}${escapeHtml(job.salary_type)}</p>
						</div>
					</div>
					<div>
					<div class="higherch-btn"><span>${escapeHtml(job.tag)}</span></div></div>
				</div>
				<div>
				<div class="d-flex gap-3 mt-2">
					<div class="company-name-div"><p>${escapeHtml(job.company_name)}</p></div>
					<div class="skilsDiv">
					<div class="d-flex gap-2">
						<div class="job-cat-btn">${escapeHtml(job.job_type)}</div>
						<div class="job-cat-btn">${escapeHtml(job.employment_type)}</div>
						<div class="job-cat-btn">${escapeHtml(job.job_experience)}</div>
						<div class="job-cat-btn">${escapeHtml(job.no_of_opening)} Vacancy</div>
						${skills}
					</div>
					</div>
				</div>
				</div>
				<div class="d-flex justify-content-between pt-3 border-dashed mt-3">
					<div class="d-flex gap-2 post-text">
						<span class="my-auto">${escapeHtml(job.job_created_at)}</span>
						<span class="post-text-dot my-auto"></span>
						<span class="my-auto">${escapeHtml(job.total_applicant)} Applicants</span>
					</div>
					<div class="locafont d-flex gap-2">
						<svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                    <path d="M3.52366 3.01413C4.34419 2.21001 5.4489 1.7622 6.59774 1.768C7.74658 1.7738 8.84672 2.23275 9.65908 3.04512C10.4714 3.85748 10.9304 4.95762 10.9362 6.10646C10.942 7.2553 10.4942 8.36001 9.69007 9.18054L7.38537 11.4852C7.17888 11.6917 6.89885 11.8076 6.60686 11.8076C6.31488 11.8076 6.03485 11.6917 5.82835 11.4852L3.52366 9.18054C2.70599 8.3628 2.24664 7.25374 2.24664 6.09733C2.24664 4.94093 2.70599 3.83187 3.52366 3.01413Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"/>
                                    <path d="M6.60686 7.74881C7.51908 7.74881 8.25858 7.00931 8.25858 6.09709C8.25858 5.18487 7.51908 4.44537 6.60686 4.44537C5.69464 4.44537 4.95514 5.18487 4.95514 6.09709C4.95514 7.00931 5.69464 7.74881 6.60686 7.74881Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
						<span class="my-auto">${escapeHtml(job.job_city)}</span>
						<span class="dott my-auto"></span>
						<span class="my-auto">${escapeHtml(job.employment_type)}</span>
					</div>
				</div>
			</div>
		`;
		if (i === 1) {
			jobDetails(job.job_id);
		}

		i++;
	});
}
const base_url = "<?= base_url() ?>";
function renderJobsWithActions(jobs, reset = false) {
	const container = document.querySelector('.jobListMobile');
	if (reset) {
		container.innerHTML = '';
	}

	jobs.forEach(job => {
		const skills = job.job_skills
			.split(',')
			.map(s => s.trim())
			.filter(Boolean)
			.map(skill => `<div class="job-cat-btn">${escapeHtml(skill)}</div>`)
			.join('');

		// Default values for buttons
		let saveClass = 'custom-btn2-outline';
		let saveText = 'Save';
		let applyClass = 'custom-btn2';
		let applyText = 'Apply Now';
		let type = '';
		let buttons = '';

		if (job.is_career === 0) {
			buttons = `
				<a class="custom-btn2" href="${base_url}career-preference">
					<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
						<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					</svg> Apply Now
				</a>
				<a class="custom-btn2-outline" href="${base_url}career-preference">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
						<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5Z" fill="#007BFF"/>
					</svg> Save
				</a>
			`;
		} else {
			if (job.is_saved===1) {
				saveText = 'Saved';
			}
			if (job.is_applied===1) {
				applyText = 'Applied';
				type = 'disabled';
			}

			buttons = `
				<button class="${applyClass} applyBtn${job.job_id}" ${type} onclick="applyJob(${job.job_id})">
					Apply Now
				</button>
				<button class="${saveClass} saveBtn${job.job_id}" onclick="saveJob(${job.job_id})">
					${saveText}
				</button>
			`;
		}

		container.innerHTML += `
			<div class="job-card mb-3 " data-id="${job.job_id}" onclick="jobDetails(${job.job_id})">
				<div class="d-flex justify-content-between w-100">
					<div class="d-flex gap-3">
						<img src="${job.company_logo}" alt="" class="companylogo">
						<div>
							<p class="mb-1 t1">${escapeHtml(job.job_title)}</p>
							<p class="mb-1 t2">${escapeHtml(job.salary_min)}${escapeHtml(job.salary_type)} - ${escapeHtml(job.salary_max)}${escapeHtml(job.salary_type)}</p>
						</div>
					</div>
					<div>
						<div class="higherch-btn"><span>${escapeHtml(job.tag)}</span></div>
					</div>
				</div>
				<div class="d-flex gap-3 mt-2">
					<div class="company-name-div"><p>${escapeHtml(job.company_name)}</p></div>
					<div class="d-flex gap-2">
						<div class="job-cat-btn">${escapeHtml(job.job_type)}</div>
						<div class="job-cat-btn">${escapeHtml(job.employment_type)}</div>
						<div class="job-cat-btn">${escapeHtml(job.job_experience)}</div>
						<div class="job-cat-btn">${escapeHtml(job.no_of_opening)} Vacancy</div>
						${skills}
					</div>
				</div>
				<div class="d-flex justify-content-between pt-3 border-dashed mt-3">
					<div class="d-flex gap-2 post-text">
						<span class="my-auto">${escapeHtml(job.job_created_at)}</span>
						<span class="post-text-dot my-auto"></span>
						<span class="my-auto">${escapeHtml(job.total_applicant)} Applicants</span>
					</div>
					<div class="locafont d-flex gap-2">
						<svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
							<path d="..." />
						</svg>
						<span class="my-auto">${escapeHtml(job.job_city)}</span>
						<span class="dott my-auto"></span>
						<span class="my-auto">${escapeHtml(job.employment_type)}</span>
					</div>
				</div>
				<div class="d-flex justify-content-end gap-2 mt-3">
					${buttons}
				</div>
			</div>
		`;

	});
}


function escapeHtml(text) {
	const map = {
		'&': '&amp;',
		'<': '&lt;',
		'>': '&gt;',
		'"': '&quot;',
		"'": '&#039;',
	};
	return text?.toString().replace(/[&<>"']/g, m => map[m]) || '';
}
function renderFilters(filters, container) {
    // Check if a string is passed, then query it
    const filterContainer = typeof container === 'string'
        ? document.querySelector(container)
        : container;

    if (!filterContainer) {
        console.error('Filter container not found:', container);
        return;
    }

    filterContainer.innerHTML = ''; // Clear previous filters

    filters.forEach(filterGroup => {
        const dropdownWrapper = document.createElement('div');
        dropdownWrapper.className = 'job-filter-btn dropdown';

        const toggleDiv = document.createElement('div');
        toggleDiv.setAttribute('data-bs-toggle', 'dropdown');
        toggleDiv.innerHTML = `
            <span class="span2">${filterGroup.title}
                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="7" viewBox="0 0 17 7" fill="none">
                    <g clip-path="url(#clip0)">
                        <path d="M8.3 5L13 0.6L14 1.5L8.8 6.3C8.7 6.4 8.5 6.5 8.3 6.5C8.1 6.5 7.9 6.4 7.8 6.3L2.6 1.5L3.6 0.6L8.3 5Z" fill="#202020"/>
                    </g>
                    <defs><clipPath id="clip0"><rect width="7" height="16" transform="matrix(0 -1 1 0 0 7)" fill="white"/></clipPath></defs>
                </svg>
            </span>
        `;
        dropdownWrapper.appendChild(toggleDiv);

        const ul = document.createElement('ul');
        ul.className = 'dropdown-menu';

        filterGroup.data.forEach(option => {
            const optionItem = document.createElement('li');
            optionItem.innerHTML = `
                <a class="dropdown-item" href="#" data-key="${filterGroup.value}" data-value="${option.value}">
                    ${option.title}
                </a>`;
            ul.appendChild(optionItem);
        });

        dropdownWrapper.appendChild(ul);
        filterContainer.appendChild(dropdownWrapper);
    });
}



function jobDetails(id){
	document.querySelectorAll('.job-card').forEach(function(card) {
        card.classList.remove('active');
    });

    const clickedJobCard = document.querySelector(`.job-card[data-id="${id}"]`);
    clickedJobCard.classList.add('active');
   $.ajax({
		type: 'POST',
		url: "<?=base_url('getJobDetails');?>",
		data: { 'id': id},
		success: function(res) {
			$('#jobDetailsData').html(res);
		}, 
		error: function() {
			Toast.fire({
			  icon: 'error',
			  title: 'Something went wrong, please refresh the page.',
			});
			return false;
		}
	});
}
</script>
  </body>
</html>






