<!doctype html>
<html lang="en">
  <?php require'css.php';?>
  <body>
    <section class="position-relative">
        <div class="py-2 home-section saved-sec">
            <div class="custom-col-10 mx-auto">
                <?php require'header2.php';?>

            </div>

        </div>
    </section>

    <section class="recom-job py-3">
        <div class="custom-col-10 mx-auto mt-3">
            <div class="row">
                <div class="col-md-4">
                        <div class="bg-white border-12 p-4 mb-3">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h5>Company Details </h5>
                                <p class="text-muted mt-3">
                                   <?=$job->company_description;?>
                                </p>
                            </div>
                           
                        </div>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                <g clip-path="url(#clip0_1970_6628)">
                                <path d="M13.5 7.5C13.5 9.22391 12.8152 10.8772 11.5962 12.0962C10.3772 13.3152 8.72391 14 7 14C5.27609 14 3.62279 13.3152 2.40381 12.0962C1.18482 10.8772 0.5 9.22391 0.5 7.5M13.5 7.5C13.5 5.77609 12.8152 4.12279 11.5962 2.90381C10.3772 1.68482 8.72391 1 7 1C5.27609 1 3.62279 1.68482 2.40381 2.90381C1.18482 4.12279 0.5 5.77609 0.5 7.5M13.5 7.5H0.5" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M9.5 7.5C9.3772 9.87699 8.50168 12.1533 7 14C5.49832 12.1533 4.6228 9.87699 4.5 7.5C4.6228 5.12301 5.49832 2.84665 7 1C8.50168 2.84665 9.3772 5.12301 9.5 7.5Z" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"></path>
                                </g>
                                <defs>
                                <clipPath id="clip0_1970_6628">
                                    <rect width="14" height="14" fill="white" transform="translate(0 0.5)"></rect>
                                </clipPath>
                                </defs>
                            </svg> Website
                        </h6>
                        <p>
                            <a href="<?=$job->company_url;?>" target="_blank" class="fs-14 text-primary"><u><?=$job->company_url;?></u></a>
                        </p>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                <path d="M14.25 2.75C14.6478 2.75 15.0294 2.90804 15.3107 3.18934C15.592 3.47064 15.75 3.85218 15.75 4.25V14.75C15.75 15.1478 15.592 15.5294 15.3107 15.8107C15.0294 16.092 14.6478 16.25 14.25 16.25H3.75C3.35218 16.25 2.97064 16.092 2.68934 15.8107C2.40804 15.5294 2.25 15.1478 2.25 14.75V4.25C2.25 3.85218 2.40804 3.47064 2.68934 3.18934C2.97064 2.90804 3.35218 2.75 3.75 2.75H14.25ZM13.875 14.375V10.4C13.875 9.75155 13.6174 9.12965 13.1589 8.67112C12.7003 8.2126 12.0785 7.955 11.43 7.955C10.7925 7.955 10.05 8.345 9.69 8.93V8.0975H7.5975V14.375H9.69V10.6775C9.69 10.1 10.155 9.6275 10.7325 9.6275C11.011 9.6275 11.278 9.73812 11.475 9.93504C11.6719 10.132 11.7825 10.399 11.7825 10.6775V14.375H13.875ZM5.16 6.92C5.49417 6.92 5.81466 6.78725 6.05095 6.55095C6.28725 6.31466 6.42 5.99417 6.42 5.66C6.42 4.9625 5.8575 4.3925 5.16 4.3925C4.82384 4.3925 4.50144 4.52604 4.26374 4.76374C4.02604 5.00144 3.8925 5.32384 3.8925 5.66C3.8925 6.3575 4.4625 6.92 5.16 6.92ZM6.2025 14.375V8.0975H4.125V14.375H6.2025Z" fill="#202020"></path>
                            </svg> LinkedIn
                        </h6>
                        <p>
                            <a href="<?=$job->linkedin;?>" target="_blank" class="fs-14 text-primary"><u><?=$job->linkedin ?? 'NA';?></u></a>
                        </p>
                        
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                <path d="M4.71383 4.06867C5.77613 2.97328 7.20635 2.36327 8.69369 2.37117C10.181 2.37907 11.6053 3.00426 12.6571 4.11088C13.7088 5.2175 14.303 6.71612 14.3105 8.28109C14.318 9.84607 13.7382 11.3509 12.6972 12.4687L9.7134 15.6082C9.44606 15.8894 9.08352 16.0473 8.7055 16.0473C8.32749 16.0473 7.96495 15.8894 7.69761 15.6082L4.71383 12.4687C3.65525 11.3547 3.06055 9.84395 3.06055 8.26867C3.06055 6.69339 3.65525 5.18262 4.71383 4.06867Z" stroke="#202020" stroke-linejoin="round"></path>
                                <path d="M8.70578 10.5195C9.88678 10.5195 10.8442 9.51217 10.8442 8.26953C10.8442 7.02689 9.88678 6.01953 8.70578 6.01953C7.52478 6.01953 6.56738 7.02689 6.56738 8.26953C6.56738 9.51217 7.52478 10.5195 8.70578 10.5195Z" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg> Location
                        </h6>
                        <p>
                            <a href="" class="fs-14 text-primary"><u><?=$job->company_url;?> </u></a>
                        </p>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                <path d="M17.25 4.25V14.75C17.25 15.1625 17.1032 15.5157 16.8097 15.8097C16.5162 16.1038 16.163 16.2505 15.75 16.25H13.5C13.2875 16.25 13.1095 16.178 12.966 16.034C12.8225 15.89 12.7505 15.712 12.75 15.5C12.7495 15.288 12.8215 15.11 12.966 14.966C13.1105 14.822 13.2885 14.75 13.5 14.75H15.75V4.25H9V4.625C9 4.8375 8.928 5.01575 8.784 5.15975C8.64 5.30375 8.462 5.3755 8.25 5.375C8.038 5.3745 7.86 5.3025 7.716 5.159C7.572 5.0155 7.5 4.8375 7.5 4.625V4.2125C7.5 3.8125 7.64375 3.46875 7.93125 3.18125C8.21875 2.89375 8.5625 2.75 8.9625 2.75H15.75C16.1625 2.75 16.5157 2.897 16.8097 3.191C17.1037 3.485 17.2505 3.838 17.25 4.25ZM0.75 9.51875C0.75 9.26875 0.80625 9.0375 0.91875 8.825C1.03125 8.6125 1.1875 8.4375 1.3875 8.3L5.1375 5.61875C5.275 5.51875 5.41575 5.44675 5.55975 5.40275C5.70375 5.35875 5.8505 5.337 6 5.3375C6.1495 5.338 6.2965 5.36 6.441 5.4035C6.5855 5.447 6.726 5.51875 6.8625 5.61875L10.6125 8.3C10.8125 8.4375 10.9687 8.6125 11.0812 8.825C11.1937 9.0375 11.25 9.26875 11.25 9.51875V14.75C11.25 15.1625 11.1032 15.5157 10.8097 15.8097C10.5162 16.1038 10.163 16.2505 9.75 16.25H8.25C7.8375 16.25 7.4845 16.1033 7.191 15.8097C6.8975 15.5162 6.7505 15.163 6.75 14.75V12.5H5.25V14.75C5.25 15.1625 5.10325 15.5157 4.80975 15.8097C4.51625 16.1038 4.163 16.2505 3.75 16.25H2.25C1.8375 16.25 1.4845 16.1033 1.191 15.8097C0.8975 15.5162 0.7505 15.163 0.75 14.75V9.51875ZM2.25 9.5V14.75H3.75V12.5C3.75 12.0875 3.897 11.7345 4.191 11.441C4.485 11.1475 4.838 11.0005 5.25 11H6.75C7.1625 11 7.51575 11.147 7.80975 11.441C8.10375 11.735 8.2505 12.088 8.25 12.5V14.75H9.75V9.5L6 6.8375L2.25 9.5ZM13.125 7.25H13.875C13.975 7.25 14.0625 7.2125 14.1375 7.1375C14.2125 7.0625 14.25 6.975 14.25 6.875V6.125C14.25 6.025 14.2125 5.9375 14.1375 5.8625C14.0625 5.7875 13.975 5.75 13.875 5.75H13.125C13.025 5.75 12.9375 5.7875 12.8625 5.8625C12.7875 5.9375 12.75 6.025 12.75 6.125V6.875C12.75 6.975 12.7875 7.0625 12.8625 7.1375C12.9375 7.2125 13.025 7.25 13.125 7.25ZM13.125 10.25H13.875C13.975 10.25 14.0625 10.2125 14.1375 10.1375C14.2125 10.0625 14.25 9.975 14.25 9.875V9.125C14.25 9.025 14.2125 8.9375 14.1375 8.8625C14.0625 8.7875 13.975 8.75 13.875 8.75H13.125C13.025 8.75 12.9375 8.7875 12.8625 8.8625C12.7875 8.9375 12.75 9.025 12.75 9.125V9.875C12.75 9.975 12.7875 10.0625 12.8625 10.1375C12.9375 10.2125 13.025 10.25 13.125 10.25ZM13.125 13.25H13.875C13.975 13.25 14.0625 13.2125 14.1375 13.1375C14.2125 13.0625 14.25 12.975 14.25 12.875V12.125C14.25 12.025 14.2125 11.9375 14.1375 11.8625C14.0625 11.7875 13.975 11.75 13.875 11.75H13.125C13.025 11.75 12.9375 11.7875 12.8625 11.8625C12.7875 11.9375 12.75 12.025 12.75 12.125V12.875C12.75 12.975 12.7875 13.0625 12.8625 13.1375C12.9375 13.2125 13.025 13.25 13.125 13.25Z" fill="#202020"></path>
                            </svg> Company Size
                        </h6>
                        <p class="fs-14 text-muted">
                            <?=$job->company_size;?>+ Employees
                        </p>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                            <path d="M8.25 13.25H9.75V8.75H8.25V13.25ZM9 7.25C9.2125 7.25 9.39075 7.178 9.53475 7.034C9.67875 6.89 9.7505 6.712 9.75 6.5C9.7495 6.288 9.6775 6.11 9.534 5.966C9.3905 5.822 9.2125 5.75 9 5.75C8.7875 5.75 8.6095 5.822 8.466 5.966C8.3225 6.11 8.2505 6.288 8.25 6.5C8.2495 6.712 8.3215 6.89025 8.466 7.03475C8.6105 7.17925 8.7885 7.251 9 7.25ZM9 17C7.9625 17 6.9875 16.803 6.075 16.409C5.1625 16.015 4.36875 15.4808 3.69375 14.8063C3.01875 14.1318 2.4845 13.338 2.091 12.425C1.6975 11.512 1.5005 10.537 1.5 9.5C1.4995 8.463 1.6965 7.488 2.091 6.575C2.4855 5.662 3.01975 4.86825 3.69375 4.19375C4.36775 3.51925 5.1615 2.985 6.075 2.591C6.9885 2.197 7.9635 2 9 2C10.0365 2 11.0115 2.197 11.925 2.591C12.8385 2.985 13.6323 3.51925 14.3063 4.19375C14.9803 4.86825 15.5147 5.662 15.9097 6.575C16.3047 7.488 16.5015 8.463 16.5 9.5C16.4985 10.537 16.3015 11.512 15.909 12.425C15.5165 13.338 14.9823 14.1318 14.3063 14.8063C13.6303 15.4808 12.8365 16.0152 11.925 16.4097C11.0135 16.8042 10.0385 17.001 9 17ZM9 15.5C10.675 15.5 12.0937 14.9187 13.2562 13.7562C14.4187 12.5937 15 11.175 15 9.5C15 7.825 14.4187 6.40625 13.2562 5.24375C12.0937 4.08125 10.675 3.5 9 3.5C7.325 3.5 5.90625 4.08125 4.74375 5.24375C3.58125 6.40625 3 7.825 3 9.5C3 11.175 3.58125 12.5937 4.74375 13.7562C5.90625 14.9187 7.325 15.5 9 15.5Z" fill="#202020"></path>
                        </svg> Industry</h6>
                        <p class="fs-14 text-muted mb-0">
                            IT Service
                        </p>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="job-card p-4 border-12 ">
                        <div class="d-flex justify-content-between">
                            <div class="d-flex gap-2">
                                <img src="<?=$job->company_logo?>" alt="" class="job-logo" style="height:70px;">
                                <div>
                                    <h5><?=$job->company_name?> </h5>
                                    <a href="" class="text-dark">
                                        <div class="d-flex gap-1">
                                            <span><?=$job->company_url?> </span>
                                            <span class="mob-hide"><img src="img/ei_arrow-up.svg" alt=""></span>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="mob-hide">
                                <svg xmlns="http://www.w3.org/2000/svg" class="copy-btn" data-clipboard-text="<?=base_url('job-details?job_id='.$job->job_id);?>" width="40" height="40" viewBox="0 0 36 36" fill="none">
                                    <rect x="0.0461426" y="0.271484" width="35" height="35" rx="17.5" fill="#EDF6FF"/>
                                    <path d="M26.0461 9.27148L9.04614 14.7715L15.5461 17.7715L22.5461 12.7715L17.5461 19.7715L20.5461 26.2715L26.0461 9.27148Z" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                        <div class="d-flex gap-2 mt-3">
                            <h4 class="my-auto"><?=$job->job_title;?></h4>
                            <span class="fs-4 my-auto">・</span>
                            <h4 class="my-auto text-muted fs-5"><?=$job->employment_type;?></h4>
                        </div>
                        <div class="dflex gap-2 mt-2">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                    <path d="M3.9293 3.01413C4.74983 2.21001 5.85454 1.7622 7.00338 1.768C8.15222 1.7738 9.25236 2.23275 10.0647 3.04512C10.8771 3.85748 11.336 4.95762 11.3418 6.10646C11.3476 7.2553 10.8998 8.36001 10.0957 9.18054L7.79101 11.4852C7.58452 11.6917 7.30449 11.8076 7.0125 11.8076C6.72052 11.8076 6.44049 11.6917 6.23399 11.4852L3.9293 9.18054C3.11163 8.3628 2.65228 7.25374 2.65228 6.09733C2.65228 4.94093 3.11163 3.83187 3.9293 3.01413Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"/>
                                    <path d="M7.0125 7.74881C7.92472 7.74881 8.66422 7.00931 8.66422 6.09709C8.66422 5.18487 7.92472 4.44537 7.0125 4.44537C6.10028 4.44537 5.36078 5.18487 5.36078 6.09709C5.36078 7.00931 6.10028 7.74881 7.0125 7.74881Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <span class="pe-2"><?=$job->job_city;?></span>
                            </div>
                              <span class="text-muted small"><?=$job->job_created_at;?></span>
                              <span>・</span>
                              <span class="text-muted small"><?=$job->total_applicant;?> Applicants</span>
                        </div>
                        <div class="mt-3 dflex gap-3">
                            <span class="d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                                    <g clip-path="url(#clip0_371_1966)">
                                      <path fill-rule="evenodd" clip-rule="evenodd" d="M14.7278 17.5C17.8403 17.5 20.3528 16.25 20.3528 14.375V2.5C20.3528 1.25 17.8528 0 14.7278 0C11.6028 0 9.10278 1.25 9.10278 2.5V6.875C10.5653 7.4875 11.8153 8.5125 12.7028 9.8125C13.3153 9.9325 13.9903 9.99875 14.7278 9.99875C16.3653 9.99875 17.7278 9.6725 18.7028 9.14125C18.8412 9.06517 18.9759 8.98258 19.1065 8.89375V10.6187C19.1065 10.9125 18.8728 11.3687 18.104 11.7887C17.359 12.195 16.2165 12.4937 14.729 12.4937C14.4315 12.4937 14.1482 12.4825 13.879 12.46C13.979 12.8725 14.0457 13.2933 14.079 13.7225C14.2899 13.7342 14.5065 13.74 14.729 13.74C16.3665 13.74 17.729 13.4137 18.704 12.8825C18.8425 12.8064 18.9772 12.7238 19.1078 12.635V14.36C19.1078 14.655 18.9215 15.0925 18.119 15.525C17.329 15.95 16.144 16.235 14.7315 16.235C14.444 16.235 14.1657 16.2233 13.8965 16.2C13.8004 16.6155 13.6713 17.0226 13.5103 17.4175C13.9036 17.4617 14.3103 17.4838 14.7303 17.4838L14.7278 17.5ZM18.1028 8.05C18.8715 7.63 19.1053 7.17375 19.1053 6.88V5.155C18.9761 5.24333 18.8415 5.32583 18.7015 5.4025C17.729 5.93375 16.364 6.26 14.7265 6.26C13.089 6.26 11.7265 5.93375 10.7515 5.4025C10.6131 5.32642 10.4784 5.24383 10.3478 5.155V6.88C10.3478 7.17375 10.5815 7.63 11.3503 8.04875C12.0953 8.455 13.2378 8.75375 14.7253 8.75375C16.2128 8.75375 17.3503 8.455 18.1003 8.04875L18.1028 8.05ZM10.3528 3.125C10.3528 2.765 10.509 2.41875 10.8003 2.2075C10.959 2.0925 11.1315 1.9775 11.2678 1.915C11.609 1.7575 13.3178 1.24875 14.7303 1.24875C16.1428 1.24875 17.3678 1.5325 18.1928 1.915C18.3478 1.98625 18.519 2.0975 18.6703 2.2075C18.959 2.41625 19.1078 2.76 19.1078 3.11625V3.12375C19.1078 3.4175 18.874 3.87375 18.1053 4.29375C17.3603 4.7 16.2178 4.99875 14.7303 4.99875C13.2428 4.99875 12.1053 4.69875 11.3553 4.29375C10.5865 3.875 10.3528 3.4175 10.3528 3.125Z" fill="#202020" fill-opacity="0.8"/>
                                      <path fill-rule="evenodd" clip-rule="evenodd" d="M11.6028 14.375C11.6028 17.4875 9.09028 20 5.97778 20C2.86528 20 0.352783 17.4875 0.352783 14.375C0.352783 11.2625 2.86528 8.75 5.97778 8.75C9.09028 8.75 11.6028 11.2625 11.6028 14.375ZM10.3528 14.375C10.3528 16.7875 8.39028 18.75 5.97778 18.75C3.56528 18.75 1.60278 16.7875 1.60278 14.375C1.60278 11.9625 3.56528 10 5.97778 10C8.39028 10 10.3528 11.9625 10.3528 14.375Z" fill="#202020" fill-opacity="0.8"/>
                                    </g>
                                    <defs>
                                      <clipPath id="clip0_371_1966">
                                        <rect width="20" height="20" fill="white" transform="translate(0.352783)"/>
                                      </clipPath>
                                    </defs>
                                </svg>
                                <p class="my-auto t2"><?=$job->salary_min;?><?=$job->salary_type;?> - <?=$job->salary_max;?><?=$job->salary_type;?><span></span></p>
                            </span>
                            <span class="d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                                    <path d="M17.0195 5.00002C17.5028 5.00002 17.8945 5.16669 18.2028 5.49169C18.5195 5.83335 18.6861 6.20835 18.6861 6.66669V15.8334C18.6861 16.2917 18.5195 16.6667 18.2028 17.0084C17.8945 17.3334 17.5028 17.5 17.0195 17.5H3.68614C3.2028 17.5 2.81114 17.3334 2.5028 17.0084C2.18614 16.6667 2.01947 16.2917 2.01947 15.8334V6.66669C2.01947 6.20835 2.18614 5.83335 2.5028 5.49169C2.81114 5.16669 3.2028 5.00002 3.68614 5.00002H7.01947V3.33335C7.01947 2.85002 7.18614 2.45835 7.5028 2.15002C7.81114 1.83335 8.2028 1.66669 8.68614 1.66669H12.0195C12.5028 1.66669 12.8945 1.83335 13.2028 2.15002C13.5195 2.45835 13.6861 2.85002 13.6861 3.33335V5.00002H17.0195ZM3.68614 6.66669V15.8334H17.0195V6.66669H3.68614ZM12.0195 5.00002V3.33335H8.68614V5.00002H12.0195Z" fill="#202020" fill-opacity="0.8"/>
                                  </svg>
                                <p class="my-auto t2"><?=$job->job_experience;?></p>
                            </span>
                            <span class="d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                                    <path d="M19.5195 4.16667V15.8333C19.5195 16.2917 19.3564 16.6842 19.0303 17.0108C18.7042 17.3375 18.3117 17.5006 17.8528 17.5H15.3528C15.1167 17.5 14.9189 17.42 14.7595 17.26C14.6 17.1 14.52 16.9022 14.5195 16.6667C14.5189 16.4311 14.5989 16.2333 14.7595 16.0733C14.92 15.9133 15.1178 15.8333 15.3528 15.8333H17.8528V4.16667H10.3528V4.58333C10.3528 4.81944 10.2728 5.0175 10.1128 5.1775C9.95282 5.3375 9.75505 5.41722 9.51949 5.41667C9.28394 5.41611 9.08616 5.33611 8.92616 5.17667C8.76616 5.01722 8.68616 4.81944 8.68616 4.58333V4.125C8.68616 3.68056 8.84588 3.29861 9.16532 2.97917C9.48477 2.65972 9.86671 2.5 10.3112 2.5H17.8528C18.3112 2.5 18.7037 2.66333 19.0303 2.99C19.357 3.31667 19.52 3.70889 19.5195 4.16667ZM1.18616 10.0208C1.18616 9.74306 1.24866 9.48611 1.37366 9.25C1.49866 9.01389 1.67227 8.81944 1.89449 8.66667L6.06116 5.6875C6.21394 5.57639 6.37032 5.49639 6.53032 5.4475C6.69032 5.39861 6.85338 5.37444 7.01949 5.375C7.1856 5.37556 7.34894 5.4 7.50949 5.44833C7.67005 5.49667 7.82616 5.57639 7.97782 5.6875L12.1445 8.66667C12.3667 8.81944 12.5403 9.01389 12.6653 9.25C12.7903 9.48611 12.8528 9.74306 12.8528 10.0208V15.8333C12.8528 16.2917 12.6898 16.6842 12.3637 17.0108C12.0375 17.3375 11.645 17.5006 11.1862 17.5H9.51949C9.06116 17.5 8.66894 17.3369 8.34282 17.0108C8.01671 16.6847 7.85338 16.2922 7.85282 15.8333V13.3333H6.18616V15.8333C6.18616 16.2917 6.0231 16.6842 5.69699 17.0108C5.37088 17.3375 4.97838 17.5006 4.51949 17.5H2.85282C2.39449 17.5 2.00227 17.3369 1.67616 17.0108C1.35005 16.6847 1.18671 16.2922 1.18616 15.8333V10.0208ZM2.85282 10V15.8333H4.51949V13.3333C4.51949 12.875 4.68282 12.4828 5.00949 12.1567C5.33616 11.8306 5.72838 11.6672 6.18616 11.6667H7.85282C8.31116 11.6667 8.70366 11.83 9.03032 12.1567C9.35699 12.4833 9.52005 12.8756 9.51949 13.3333V15.8333H11.1862V10L7.01949 7.04167L2.85282 10ZM14.9362 7.5H15.7695C15.8806 7.5 15.9778 7.45833 16.0612 7.375C16.1445 7.29167 16.1862 7.19444 16.1862 7.08333V6.25C16.1862 6.13889 16.1445 6.04167 16.0612 5.95833C15.9778 5.875 15.8806 5.83333 15.7695 5.83333H14.9362C14.825 5.83333 14.7278 5.875 14.6445 5.95833C14.5612 6.04167 14.5195 6.13889 14.5195 6.25V7.08333C14.5195 7.19444 14.5612 7.29167 14.6445 7.375C14.7278 7.45833 14.825 7.5 14.9362 7.5ZM14.9362 10.8333H15.7695C15.8806 10.8333 15.9778 10.7917 16.0612 10.7083C16.1445 10.625 16.1862 10.5278 16.1862 10.4167V9.58333C16.1862 9.47222 16.1445 9.375 16.0612 9.29167C15.9778 9.20833 15.8806 9.16667 15.7695 9.16667H14.9362C14.825 9.16667 14.7278 9.20833 14.6445 9.29167C14.5612 9.375 14.5195 9.47222 14.5195 9.58333V10.4167C14.5195 10.5278 14.5612 10.625 14.6445 10.7083C14.7278 10.7917 14.825 10.8333 14.9362 10.8333ZM14.9362 14.1667H15.7695C15.8806 14.1667 15.9778 14.125 16.0612 14.0417C16.1445 13.9583 16.1862 13.8611 16.1862 13.75V12.9167C16.1862 12.8056 16.1445 12.7083 16.0612 12.625C15.9778 12.5417 15.8806 12.5 15.7695 12.5H14.9362C14.825 12.5 14.7278 12.5417 14.6445 12.625C14.5612 12.7083 14.5195 12.8056 14.5195 12.9167V13.75C14.5195 13.8611 14.5612 13.9583 14.6445 14.0417C14.7278 14.125 14.825 14.1667 14.9362 14.1667Z" fill="#202020" fill-opacity="0.8"/>
                                  </svg>
                                <p class="my-auto t2"><?=$job->company_size;?>+ Employers <?=$job->is_career?></p>
                            </span>
                        </div>
                        <div class="d-flex gap-3 mt-4">
						<?php if($job->is_career==0){?>
						<a class="" href="<?=base_url('career-preference');?>">
                            <button class="custom-btn2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                                    <path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                  </svg>Apply Now</button></a>
                                  <a class="" href="<?=base_url('career-preference');?>">
                                  <button class="custom-btn2-outline">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                        <path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
                                      </svg>
                                    Save</button></a>
						<?php }else{
						if($job->is_saved==1){
							$saveClass='custom-btn2-outline';
							$saveText='Saved';
						}else{
							$saveClass='custom-btn2-outline';
							$saveText='Save';
						}
						
						if($job->is_applied==1){
							$applyClass='custom-btn2';
							$applyText='Applied';
							$type='disabled';
						}else{
							$applyClass='custom-btn2';
							$applyText='Apply Now';
							$type='';
						}
						
						echo'<button class="'.$applyClass.' applyBtn'.$job->job_id.'" '.$type.' onclick="applyJob('.$job->job_id.')" >
								<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
									<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								  </svg><span>'.$applyText.'</span> <i class="fa fa-spinner fa-spin applySpin'.$job->job_id.'" style="display:none;"></i></button>
						  <button class="'.$saveClass.' saveBtn'.$job->job_id.'" onclick="saveJob('.$job->job_id.')">
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
								<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
							  </svg>
							<span>'.$saveText.'</span> <i class="fa fa-spinner fa-spin saveSpin'.$job->job_id.'" style="display:none;"></i></button>';
						
						} ?>
                        </div>
                        <div style="font-size: 14px;">
                            <div class="mt-4">
                                <h5 class="mb-2">Role Summary</h5>
                                <p class="fw-normal" style="color: rgba(32, 32, 32, 0.80);"><?=$job->job_description;?></p>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



 <?php require'js.php';?>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.11/clipboard.min.js"></script>

	<script>
 var clipboard= new ClipboardJS('.copy-btn');
 clipboard.on('success', function(e) {
	Toast.fire({
	  icon: 'success',
	  title: 'Link copied successfully',
	})
});
</script>
  </body>
</html>