<!doctype html>
<html lang="en">
  <?php require'css.php';?>
  <body>
    <section class="position-relative mob-hide">
        <img class="position-absolute grid-img" src="<?=base_url('assets/newAssets/img/')?>grid.png" alt="">
        <div class="head-section">
            <div class="custom-col-10 mx-auto">
            <?php require'header2.php';?>
            <h4 class="title mt-5">Discover Opportunities Tailored to You</h4>
            </div>
        </div>
    </section>

    <div class="mob-show" style="background: #EDF6FF;">
        <div class="p-2 d-flex justify-content-between" style="background: #F6FBFF;
box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.05);">
            <?php require'header2.php';?>
        </div>
    </div>

    <div class="mob-show" style="background: #EDF6FF;">
        <div class="p-3 mb-2" style="background: #F6FBFF;">
            <div class="d-flex justify-content-between">
                <img src="<?=$job->company_logo;?>" class="border rounded-3" style="width: 3rem;height: 3rem;" alt="">
				 <!--<h5><?=$job->company_name?></h5>-->
                <span class="fs-5 my-auto">⛉</span>
            </div>
            <h5 class="mt-3 fw-bold"><?=$job->job_title;?></h5>
            <a href="" class="text-dark">
                <div class="d-flex gap-1">
                    <span><a href="<?=$job->company_url;?>" target="_blank"><?=$job->company_url?></a></span>
                    <span><img src="<?=base_url('assets/newAssets/img/')?>ei_arrow-up.svg" alt=""></span>
                </div>
            </a>
            <div class="d-flex justify-content-between text-muted mt-2 mb-4">
                <span><?=$job->total_applicant;?> Applicants</span>
                <span>Posted <?=$job->job_created_at;?></span>
            </div>
            <div class="mb-2">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                    <g clip-path="url(#clip0_2056_6383)">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M14.7454 17.5C17.8579 17.5 20.3704 16.25 20.3704 14.375V2.5C20.3704 1.25 17.8704 0 14.7454 0C11.6204 0 9.12036 1.25 9.12036 2.5V6.875C10.5829 7.4875 11.8329 8.5125 12.7204 9.8125C13.3329 9.9325 14.0079 9.99875 14.7454 9.99875C16.3829 9.99875 17.7454 9.6725 18.7204 9.14125C18.8588 9.06517 18.9935 8.98258 19.1241 8.89375V10.6187C19.1241 10.9125 18.8904 11.3687 18.1216 11.7887C17.3766 12.195 16.2341 12.4937 14.7466 12.4937C14.4491 12.4937 14.1658 12.4825 13.8966 12.46C13.9966 12.8725 14.0633 13.2933 14.0966 13.7225C14.3074 13.7342 14.5241 13.74 14.7466 13.74C16.3841 13.74 17.7466 13.4137 18.7216 12.8825C18.86 12.8064 18.9948 12.7238 19.1254 12.635V14.36C19.1254 14.655 18.9391 15.0925 18.1366 15.525C17.3466 15.95 16.1616 16.235 14.7491 16.235C14.4616 16.235 14.1833 16.2233 13.9141 16.2C13.818 16.6155 13.6889 17.0226 13.5279 17.4175C13.9212 17.4617 14.3279 17.4838 14.7479 17.4838L14.7454 17.5ZM18.1204 8.05C18.8891 7.63 19.1229 7.17375 19.1229 6.88V5.155C18.9937 5.24333 18.8591 5.32583 18.7191 5.4025C17.7466 5.93375 16.3816 6.26 14.7441 6.26C13.1066 6.26 11.7441 5.93375 10.7691 5.4025C10.6307 5.32642 10.496 5.24383 10.3654 5.155V6.88C10.3654 7.17375 10.5991 7.63 11.3679 8.04875C12.1129 8.455 13.2554 8.75375 14.7429 8.75375C16.2304 8.75375 17.3679 8.455 18.1179 8.04875L18.1204 8.05ZM10.3704 3.125C10.3704 2.765 10.5266 2.41875 10.8179 2.2075C10.9766 2.0925 11.1491 1.9775 11.2854 1.915C11.6266 1.7575 13.3354 1.24875 14.7479 1.24875C16.1604 1.24875 17.3854 1.5325 18.2104 1.915C18.3654 1.98625 18.5366 2.0975 18.6879 2.2075C18.9766 2.41625 19.1254 2.76 19.1254 3.11625V3.12375C19.1254 3.4175 18.8916 3.87375 18.1229 4.29375C17.3779 4.7 16.2354 4.99875 14.7479 4.99875C13.2604 4.99875 12.1229 4.69875 11.3729 4.29375C10.6041 3.875 10.3704 3.4175 10.3704 3.125Z" fill="#007BFF" fill-opacity="0.8"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M11.6204 14.375C11.6204 17.4875 9.10786 20 5.99536 20C2.88286 20 0.370361 17.4875 0.370361 14.375C0.370361 11.2625 2.88286 8.75 5.99536 8.75C9.10786 8.75 11.6204 11.2625 11.6204 14.375ZM10.3704 14.375C10.3704 16.7875 8.40786 18.75 5.99536 18.75C3.58286 18.75 1.62036 16.7875 1.62036 14.375C1.62036 11.9625 3.58286 10 5.99536 10C8.40786 10 10.3704 11.9625 10.3704 14.375Z" fill="#007BFF" fill-opacity="0.8"/>
                    </g>
                    <defs>
                    <clipPath id="clip0_2056_6383">
                        <rect width="20" height="20" fill="white" transform="translate(0.370361)"/>
                    </clipPath>
                    </defs>
                </svg>
                <span style="font-weight: 500;"><?=$job->salary_min;?><?=$job->salary_type;?> - <?=$job->salary_max;?><?=$job->salary_type;?></span>
            </div>
            <div class="mb-2">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                    <path d="M17.0371 5.0013C17.5204 5.0013 17.9121 5.16797 18.2204 5.49297C18.5371 5.83464 18.7038 6.20964 18.7038 6.66797V15.8346C18.7038 16.293 18.5371 16.668 18.2204 17.0096C17.9121 17.3346 17.5204 17.5013 17.0371 17.5013H3.70378C3.22044 17.5013 2.82878 17.3346 2.52044 17.0096C2.20378 16.668 2.03711 16.293 2.03711 15.8346V6.66797C2.03711 6.20964 2.20378 5.83464 2.52044 5.49297C2.82878 5.16797 3.22044 5.0013 3.70378 5.0013H7.03711V3.33464C7.03711 2.8513 7.20378 2.45964 7.52044 2.1513C7.82878 1.83464 8.22044 1.66797 8.70378 1.66797H12.0371C12.5204 1.66797 12.9121 1.83464 13.2204 2.1513C13.5371 2.45964 13.7038 2.8513 13.7038 3.33464V5.0013H17.0371ZM3.70378 6.66797V15.8346H17.0371V6.66797H3.70378ZM12.0371 5.0013V3.33464H8.70378V5.0013H12.0371Z" fill="#007BFF" fill-opacity="0.8"/>
                </svg>
                <?=$job->job_experience;?>
            </div>
            <div class="mb-2">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                    <path d="M10.3704 2.49953C8.82327 2.49953 7.33953 3.11411 6.24557 4.20807C5.15161 5.30204 4.53703 6.78577 4.53703 8.33286C4.53703 10.7179 6.02203 13.0187 7.65203 14.8012C8.48548 15.7092 9.39489 16.5445 10.3704 17.2979C10.5159 17.1862 10.6867 17.0501 10.8829 16.8895C11.666 16.2464 12.4031 15.5491 13.0887 14.8029C14.7187 13.0187 16.2037 10.7187 16.2037 8.33286C16.2037 6.78577 15.5891 5.30204 14.4952 4.20807C13.4012 3.11411 11.9175 2.49953 10.3704 2.49953ZM10.3704 19.3445L9.89786 19.0195L9.89536 19.0179L9.89036 19.0137L9.87369 19.002L9.81119 18.9579L9.58619 18.7937C8.44608 17.9368 7.38692 16.9773 6.42203 15.927C4.71869 14.062 2.87036 11.3629 2.87036 8.33203C2.87036 6.34291 3.66054 4.43525 5.06706 3.02873C6.47358 1.62221 8.38124 0.832031 10.3704 0.832031C12.3595 0.832031 14.2671 1.62221 15.6737 3.02873C17.0802 4.43525 17.8704 6.34291 17.8704 8.33203C17.8704 11.3629 16.022 14.0629 14.3187 15.9254C13.3541 16.9756 12.2952 17.9351 11.1554 18.792C11.0604 18.863 10.9646 18.9327 10.8679 19.0012L10.8504 19.0129L10.8454 19.017L10.8437 19.0179L10.3704 19.3445ZM10.3704 6.6662C9.92833 6.6662 9.50441 6.84179 9.19185 7.15435C8.87929 7.46691 8.70369 7.89084 8.70369 8.33286C8.70369 8.77489 8.87929 9.19881 9.19185 9.51137C9.50441 9.82393 9.92833 9.99953 10.3704 9.99953C10.8124 9.99953 11.2363 9.82393 11.5489 9.51137C11.8614 9.19881 12.037 8.77489 12.037 8.33286C12.037 7.89084 11.8614 7.46691 11.5489 7.15435C11.2363 6.84179 10.8124 6.6662 10.3704 6.6662ZM7.03703 8.33286C7.03703 7.44881 7.38822 6.60096 8.01334 5.97584C8.63846 5.35072 9.48631 4.99953 10.3704 4.99953C11.2544 4.99953 12.1023 5.35072 12.7274 5.97584C13.3525 6.60096 13.7037 7.44881 13.7037 8.33286C13.7037 9.21692 13.3525 10.0648 12.7274 10.6899C12.1023 11.315 11.2544 11.6662 10.3704 11.6662C9.48631 11.6662 8.63846 11.315 8.01334 10.6899C7.38822 10.0648 7.03703 9.21692 7.03703 8.33286Z" fill="#007BFF" fill-opacity="0.8"/>
                </svg>
               <?=$job->job_city;?>
            </div>
            <div class="mb-2">
                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                    <path d="M23.3704 5V19C23.3704 19.55 23.1747 20.021 22.7834 20.413C22.392 20.805 21.921 21.0007 21.3704 21H18.3704C18.087 21 17.8497 20.904 17.6584 20.712C17.467 20.52 17.371 20.2827 17.3704 20C17.3697 19.7173 17.4657 19.48 17.6584 19.288C17.851 19.096 18.0884 19 18.3704 19H21.3704V5H12.3704V5.5C12.3704 5.78333 12.2744 6.021 12.0824 6.213C11.8904 6.405 11.653 6.50067 11.3704 6.5C11.0877 6.49933 10.8504 6.40333 10.6584 6.212C10.4664 6.02067 10.3704 5.78333 10.3704 5.5V4.95C10.3704 4.41667 10.562 3.95833 10.9454 3.575C11.3287 3.19167 11.787 3 12.3204 3H21.3704C21.9204 3 22.3914 3.196 22.7834 3.588C23.1754 3.98 23.371 4.45067 23.3704 5ZM1.37036 12.025C1.37036 11.6917 1.44536 11.3833 1.59536 11.1C1.74536 10.8167 1.95369 10.5833 2.22036 10.4L7.22036 6.825C7.4037 6.69167 7.59136 6.59567 7.78336 6.537C7.97536 6.47833 8.17103 6.44933 8.37036 6.45C8.5697 6.45067 8.7657 6.48 8.95836 6.538C9.15103 6.596 9.33836 6.69167 9.52036 6.825L14.5204 10.4C14.787 10.5833 14.9954 10.8167 15.1454 11.1C15.2954 11.3833 15.3704 11.6917 15.3704 12.025V19C15.3704 19.55 15.1747 20.021 14.7834 20.413C14.392 20.805 13.921 21.0007 13.3704 21H11.3704C10.8204 21 10.3497 20.8043 9.95836 20.413C9.56703 20.0217 9.37103 19.5507 9.37036 19V16H7.37036V19C7.37036 19.55 7.1747 20.021 6.78336 20.413C6.39203 20.805 5.92103 21.0007 5.37036 21H3.37036C2.82036 21 2.34969 20.8043 1.95836 20.413C1.56703 20.0217 1.37103 19.5507 1.37036 19V12.025ZM3.37036 12V19H5.37036V16C5.37036 15.45 5.56636 14.9793 5.95836 14.588C6.35036 14.1967 6.82103 14.0007 7.37036 14H9.37036C9.92036 14 10.3914 14.196 10.7834 14.588C11.1754 14.98 11.371 15.4507 11.3704 16V19H13.3704V12L8.37036 8.45L3.37036 12ZM17.8704 9H18.8704C19.0037 9 19.1204 8.95 19.2204 8.85C19.3204 8.75 19.3704 8.63333 19.3704 8.5V7.5C19.3704 7.36667 19.3204 7.25 19.2204 7.15C19.1204 7.05 19.0037 7 18.8704 7H17.8704C17.737 7 17.6204 7.05 17.5204 7.15C17.4204 7.25 17.3704 7.36667 17.3704 7.5V8.5C17.3704 8.63333 17.4204 8.75 17.5204 8.85C17.6204 8.95 17.737 9 17.8704 9ZM17.8704 13H18.8704C19.0037 13 19.1204 12.95 19.2204 12.85C19.3204 12.75 19.3704 12.6333 19.3704 12.5V11.5C19.3704 11.3667 19.3204 11.25 19.2204 11.15C19.1204 11.05 19.0037 11 18.8704 11H17.8704C17.737 11 17.6204 11.05 17.5204 11.15C17.4204 11.25 17.3704 11.3667 17.3704 11.5V12.5C17.3704 12.6333 17.4204 12.75 17.5204 12.85C17.6204 12.95 17.737 13 17.8704 13ZM17.8704 17H18.8704C19.0037 17 19.1204 16.95 19.2204 16.85C19.3204 16.75 19.3704 16.6333 19.3704 16.5V15.5C19.3704 15.3667 19.3204 15.25 19.2204 15.15C19.1204 15.05 19.0037 15 18.8704 15H17.8704C17.737 15 17.6204 15.05 17.5204 15.15C17.4204 15.25 17.3704 15.3667 17.3704 15.5V16.5C17.3704 16.6333 17.4204 16.75 17.5204 16.85C17.6204 16.95 17.737 17 17.8704 17Z" fill="#007BFF" fill-opacity="0.8"/>
                </svg>
                <?=$job->company_size;?>+ Employees
            </div>
            <div class="mt-4">
                <!--<p class="fw-bold">Posted By</p>
                <div class="d-flex justify-content-between p-2" style="border-radius: 8px;border: 1px solid rgba(0, 0, 0, 0.10);
                background: #FCFCFC;">
                    <div class="d-flex gap-2">
                        <img src="<?=base_url('assets/newAssets/img/')?>user.png" alt="" class="user-icon">
                        <div>
                            <p class="mb-1" style="font-weight: 500;">Chandrika</p>
                            <p class="mb-0">Hiring Manager at Bits Pan</p>
                        </div>
                    </div>
                    <div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                            <path d="M5.37036 18V21.766L6.88536 20.857L11.6474 18H16.3704C17.4734 18 18.3704 17.103 18.3704 16V8C18.3704 6.897 17.4734 6 16.3704 6H4.37036C3.26736 6 2.37036 6.897 2.37036 8V16C2.37036 17.103 3.26736 18 4.37036 18H5.37036ZM4.37036 8H16.3704V16H11.0934L7.37036 18.234V16H4.37036V8Z" fill="#202020" fill-opacity="0.8"/>
                            <path d="M20.3704 2H8.37036C7.26736 2 6.37036 2.897 6.37036 4H18.3704C19.4734 4 20.3704 4.897 20.3704 6V14C21.4734 14 22.3704 13.103 22.3704 12V4C22.3704 2.897 21.4734 2 20.3704 2Z" fill="#202020" fill-opacity="0.8"/>
                        </svg>
                    </div>
                </div>-->
                <div style="font-size: 12px;">
                    <div class="mt-4">
                        <h5 class="mb-2">Role Summary</h5>
                        <?=$job->job_description;?>
                    </div>
                   
                </div>
            </div>
        </div>
        <div class="p-3" style="background: #F6FBFF;">
            <h2 class="mb-4">Similar More Jobs</h2>
            <?php foreach($similar as $row){
				
				
		if(!empty($emp_id)){
			$career=$this->db->where(['created_by'=> $emp_id])->get('career_preferences')->num_rows();
			$save=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('emp_save_job')->num_rows();
			$apply=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp')->num_rows();
			if($save>0){
				$saveClass='';
				$saveText='Saved';
			}else{
				$saveClass='custom-btn2-outline';
				$saveText='Save';
			}
			
			if($apply>0){
				$applyClass='custom-btn2';
				$applyText='Applied';
				$type='disabled';
			}else{
				$applyClass='custom-btn2';
				$applyText='Apply Now';
				$type='';
			}
			if($career==0){
				$buttons='
				<a class="" href="'.base_url('career-preference').'">
				<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
					<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				  </svg>Apply Now</a>
				  <a class="custom-btn2-outline" href="'.base_url('career-preference').'">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
						<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
					  </svg>
					Save</a>
				';
			}else{
				$buttons='
				<button class="'.$applyClass.' applyBtn'.$row->job_id.'" '.$type.' onclick="applyJob('.$row->job_id.')" >
					<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
						<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					  </svg><span>'.$applyText.'</span> <i class="fa fa-spinner fa-spin applySpin'.$row->job_id.'" style="display:none;"></i></button>
			  <button class="'.$saveClass.' saveBtn'.$row->job_id.'" onclick="saveJob('.$row->job_id.')">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
					<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
				  </svg>
				<span>'.$saveText.'</span> <i class="fa fa-spinner fa-spin saveSpin'.$row->job_id.'" style="display:none;"></i></button>
				';
			}
		}else{
			$buttons='
			<button class="" data-bs-toggle="modal" data-bs-target="#login">
			<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
				<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
			  </svg>Apply Now</button>
			  <button class="custom-btn2-outline" data-bs-toggle="modal" data-bs-target="#login">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
					<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
				  </svg>
				Save</button>
			';
		}
				?>
            <div class="job-card-mob mb-3">
                <div class="cardcenter mb-2">
                    <div class="JobCard">
                        <div class="d-flex justify-content-between">
                           <a href="<?=base_url('job-details?job_id='.$row->job_id);?>"> <div class="d-flex gap-3">
                                <div>
                                    <img src="<?=$row->company_logo;?>" alt="" class="companylogo">
                                </div>
                                <div class="my-auto">
                                    <p class="small mb-1"><?=$row->company_name?></p>
                                    <h5 class="fw-normal mb-0"><?=$row->salary_min;?><?=$row->salary_type;?> - <?=$row->salary_max;?><?=$row->salary_type;?></h5>
                                </div>
                            </div></a>
                            <div class="my-auto">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                    <g clip-path="url(#clip0_2056_4574)">
                                      <path fill-rule="evenodd" clip-rule="evenodd" d="M16.574 13.4427C16.7615 13.2552 16.8668 13.0009 16.8668 12.7357C16.8668 12.4705 16.7615 12.2162 16.574 12.0287L10.917 6.37169C10.8248 6.27618 10.7145 6.2 10.5924 6.14759C10.4704 6.09518 10.3392 6.0676 10.2064 6.06644C10.0737 6.06529 9.94198 6.09059 9.81909 6.14087C9.69619 6.19115 9.58454 6.26541 9.49065 6.3593C9.39675 6.45319 9.3225 6.56484 9.27222 6.68774C9.22194 6.81064 9.19664 6.94232 9.19779 7.0751C9.19895 7.20788 9.22653 7.33909 9.27894 7.4611C9.33135 7.5831 9.40753 7.69345 9.50304 7.78569L14.453 12.7357L9.50304 17.6857C9.32088 17.8743 9.22009 18.1269 9.22237 18.3891C9.22465 18.6513 9.32982 18.9021 9.51522 19.0875C9.70063 19.2729 9.95144 19.3781 10.2136 19.3804C10.4758 19.3826 10.7284 19.2819 10.917 19.0997L16.574 13.4427Z" fill="#007BFF"></path>
                                    </g>
                                    <defs>
                                      <clipPath id="clip0_2056_4574">
                                        <rect width="24" height="24" fill="white" transform="matrix(0 1 1 0 0.867188 0.734375)"></rect>
                                      </clipPath>
                                    </defs>
                                  </svg>
                            </div>
                        </div>
                        <h5 class="mt-3"><?=$row->job_title;?></h5>
                        <p class="small">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                <path d="M4.02372 3.51401C4.84425 2.70989 5.94896 2.26208 7.0978 2.26788C8.24665 2.27368 9.34678 2.73263 10.1591 3.54499C10.9715 4.35736 11.4305 5.45749 11.4363 6.60633C11.4421 7.75518 10.9942 8.85989 10.1901 9.68042L7.88543 11.9851C7.67894 12.1916 7.39891 12.3075 7.10693 12.3075C6.81494 12.3075 6.53491 12.1916 6.32842 11.9851L4.02372 9.68042C3.20606 8.86267 2.7467 7.75362 2.7467 6.59721C2.7467 5.4408 3.20606 4.33175 4.02372 3.51401Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"></path>
                                <path d="M7.10692 8.24875C8.01914 8.24875 8.75864 7.50925 8.75864 6.59703C8.75864 5.68481 8.01914 4.94531 7.10692 4.94531C6.1947 4.94531 5.4552 5.68481 5.4552 6.59703C5.4552 7.50925 6.1947 8.24875 7.10692 8.24875Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                            <?=$row->job_city;?> • <?=$row->employment_type;?>
                        </p>
                        <div class="d-flex gap-2 mb-3" style="overflow: auto;">
                            <div class="job-cat-btn"><?=$row->job_type;?></div>
                            <div class="job-cat-btn"><?=$row->employment_type;?></div>
                            <div class="job-cat-btn"><?=$row->job_experience;?></div>
                            <div class="job-cat-btn"><?=$row->no_of_opening;?> Vacancy</div>
                            <?php 
									$skills = explode(',', $row->job_skills);

									foreach ($skills as $skill) {
										$skill = trim($skill); // Remove extra spaces

										if (!empty($skill)) { // Check if it's not empty
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>
                        </div>
                        <div class="d-flex gap-3 mt-4 justify-content-between">
                            <?=$buttons;?>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php } ?>
            
        </div>
        <div class="job-footer">
            <div class="job-footer-div w-100 gap-2">
                <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="51" height="50" viewBox="0 0 51 50" fill="none">
                        <rect x="1" y="0.5" width="49" height="49" rx="24.5" fill="#F6FBFF"/>
                        <rect x="1" y="0.5" width="49" height="49" rx="24.5" stroke="#007BFF"/>
                        <path d="M33.5027 16L13.4971 22.4724L21.1463 26.0028L29.3839 20.1188L23.4999 28.3564L27.0303 36.0056L33.5027 16Z" stroke="#007BFF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                </span>
                
				<?php	
				
				if(!empty($emp_id)){
					$career=$this->db->where(['created_by'=> $emp_id])->get('career_preferences')->num_rows();
					$apply=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp')->num_rows();
					
					if($apply>0){
						$applyText='Applied';
						$type='disabled';
					}else{
						$applyText='Apply Now';
						$type='';
					}
					if($career==0){
						$buttons='
							<button class="btn btn-primary w-100 py-3" data-bs-toggle="modal" data-bs-target="#career">
							Apply Now
						</button>
						';
					}else{
						$buttons='
						<button class="btn btn-primary w-100 py-3 applyBtn'.$job->job_id.'" '.$type.' onclick="applyJob('.$job->job_id.')">
							<span>'.$applyText.'</span> <i class="fa fa-spinner fa-spin applySpin'.$job->job_id.'" style="display:none;"></i>
						</button>
						';
					}
				}else{
					$buttons='
						<button class="btn btn-primary w-100 py-3" data-bs-toggle="modal" data-bs-target="#login">
							Apply Now
						</button>
					';	
				}
				echo $buttons;
				?>
            </div>
        </div>
    </div>

    <section class="container-fluid search-div mob-hide">
        <div class="custom-col-10 mx-auto">
            <div class="search-section">
                <svg class="my-auto me-3" xmlns="http://www.w3.org/2000/svg" width="28" height="29" viewBox="0 0 28 29" fill="none">
                    <path d="M14 22.665C18.5103 22.665 22.1667 19.0087 22.1667 14.4984C22.1667 9.98804 18.5103 6.3317 14 6.3317C9.48969 6.3317 5.83335 9.98804 5.83335 14.4984C5.83335 19.0087 9.48969 22.665 14 22.665Z" stroke="#202020" stroke-opacity="0.6" stroke-width="1.16667"/>
                    <path d="M24.5744 25.3835L21.0744 21.8835" stroke="#202020" stroke-opacity="0.6" stroke-width="1.16667" stroke-linecap="round"/>
                </svg>
                <input type="text" class="form-control input1" placeholder="UX Designer">
                <svg xmlns="http://www.w3.org/2000/svg" width="2" height="47" viewBox="0 0 2 47" fill="none">
                    <path d="M1 1.67383L1 45.3242" stroke="#202020" stroke-opacity="0.2" stroke-width="2" stroke-linecap="round"/>
                </svg>
                <svg class="my-auto mx-3" xmlns="http://www.w3.org/2000/svg" width="28" height="29" viewBox="0 0 28 29" fill="none">
                    <path d="M7.46668 6.05235C9.20539 4.34842 11.5463 3.3995 13.9807 3.4118C16.4151 3.4241 18.7463 4.39661 20.4677 6.11802C22.1891 7.83942 23.1616 10.1706 23.1739 12.605C23.1862 15.0394 22.2373 17.3803 20.5333 19.119L15.6497 24.0027C15.2121 24.4401 14.6187 24.6859 14 24.6859C13.3813 24.6859 12.7879 24.4401 12.3503 24.0027L7.46668 19.119C5.73405 17.3862 4.76068 15.0361 4.76068 12.5857C4.76068 10.1352 5.73405 7.78516 7.46668 6.05235Z" stroke="#202020" stroke-opacity="0.6" stroke-width="1.75" stroke-linejoin="round"/>
                    <path d="M14 16.0857C15.933 16.0857 17.5 14.5187 17.5 12.5857C17.5 10.6527 15.933 9.08569 14 9.08569C12.067 9.08569 10.5 10.6527 10.5 12.5857C10.5 14.5187 12.067 16.0857 14 16.0857Z" stroke="#202020" stroke-opacity="0.6" stroke-width="1.75" stroke-linecap="round" stroke-linejoin="round"/>
                  </svg>
                <input type="text" class="form-control input2" placeholder="Add Location ">
                <button class="custom-btn">Search</button>
            </div>
        </div>
    </section>

    <section class="recom-job py-3 mob-hide">
        <div style="padding-left: 5%; background: #EDF6FF;" class="sticky-top1 py-3">
            <div class="d-flex w-100">
                <div class="col-md-4">
                    <h3 class="recom-title">Recommended <span>UX design</span> Jobs</h3>
                </div>
                <div class="col-md-8">
                    <div class="d-flex gap-2 job-filter-bar">
                        <div class="job-filter-btn dropdown">
                            <div data-bs-toggle="dropdown">
                                <span class="span1">Sort By:</span>
                                <span class="span2">Location </span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="7" viewBox="0 0 16 7" fill="none">
                                    <g clip-path="url(#clip0_371_1587)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.99999 4.9741L12.714 0.633728L13.6567 1.50168L8.47132 6.27603C8.3463 6.3911 8.17677 6.45575 7.99999 6.45575C7.82321 6.45575 7.65367 6.3911 7.52866 6.27603L2.34332 1.50168L3.28599 0.633728L7.99999 4.9741Z" fill="#202020"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_371_1587">
                                        <rect width="7" height="16" fill="white" transform="matrix(0 -1 1 0 0 7)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">option 1</a></li>
                                <li><a class="dropdown-item" href="#">option 2</a></li>
                                <li><a class="dropdown-item" href="#">option 3</a></li>
                            </ul>
                        </div>
                        <div class="job-filter-btn dropdown">
                            <div data-bs-toggle="dropdown">
                                <span class="span2">Filter </span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none">
                                    <path d="M16.2088 12.0199H6.7848M3.45837 12.0199H2.0976M3.45837 12.0199C3.45837 11.5789 3.63356 11.1559 3.9454 10.8441C4.25724 10.5322 4.68019 10.357 5.1212 10.357C5.56221 10.357 5.98516 10.5322 6.297 10.8441C6.60884 11.1559 6.78403 11.5789 6.78403 12.0199C6.78403 12.4609 6.60884 12.8838 6.297 13.1957C5.98516 13.5075 5.56221 13.6827 5.1212 13.6827C4.68019 13.6827 4.25724 13.5075 3.9454 13.1957C3.63356 12.8838 3.45837 12.4609 3.45837 12.0199ZM16.2088 6.98027H13.8404M10.514 6.98027H2.0976M10.514 6.98027C10.514 6.53926 10.6892 6.11632 11.001 5.80448C11.3128 5.49263 11.7358 5.31744 12.1768 5.31744C12.3952 5.31744 12.6114 5.36045 12.8131 5.44402C13.0149 5.52758 13.1982 5.65007 13.3526 5.80448C13.507 5.95888 13.6295 6.14219 13.713 6.34394C13.7966 6.54568 13.8396 6.76191 13.8396 6.98027C13.8396 7.19864 13.7966 7.41487 13.713 7.61661C13.6295 7.81836 13.507 8.00167 13.3526 8.15607C13.1982 8.31048 13.0149 8.43297 12.8131 8.51653C12.6114 8.6001 12.3952 8.64311 12.1768 8.64311C11.7358 8.64311 11.3128 8.46791 11.001 8.15607C10.6892 7.84423 10.514 7.42129 10.514 6.98027Z" stroke="#202020" stroke-width="1.14415" stroke-miterlimit="10" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">option 1</a></li>
                                <li><a class="dropdown-item" href="#">option 2</a></li>
                                <li><a class="dropdown-item" href="#">option 3</a></li>
                            </ul>
                        </div>
                        <div class="job-filter-btn dropdown">
                            <div data-bs-toggle="dropdown">
                                <span class="span2">Remote</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="7" viewBox="0 0 17 7" fill="none">
                                    <g clip-path="url(#clip0_371_1596)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.30639 4.9741L13.0204 0.633728L13.9631 1.50168L8.77772 6.27603C8.6527 6.3911 8.48316 6.45575 8.30639 6.45575C8.12961 6.45575 7.96007 6.3911 7.83505 6.27603L2.64972 1.50168L3.59239 0.633728L8.30639 4.9741Z" fill="#202020"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_371_1596">
                                        <rect width="7" height="16" fill="white" transform="matrix(0 -1 1 0 0.306396 7)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                            </div>  
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">option 1</a></li>
                                <li><a class="dropdown-item" href="#">option 2</a></li>
                                <li><a class="dropdown-item" href="#">option 3</a></li>
                            </ul>
                        </div>
                        <div class="job-filter-btn dropdown">
                            <div data-bs-toggle="dropdown">
                                <span class="span2">Distance</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="7" viewBox="0 0 17 7" fill="none">
                                    <g clip-path="url(#clip0_371_1596)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.30639 4.9741L13.0204 0.633728L13.9631 1.50168L8.77772 6.27603C8.6527 6.3911 8.48316 6.45575 8.30639 6.45575C8.12961 6.45575 7.96007 6.3911 7.83505 6.27603L2.64972 1.50168L3.59239 0.633728L8.30639 4.9741Z" fill="#202020"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_371_1596">
                                        <rect width="7" height="16" fill="white" transform="matrix(0 -1 1 0 0.306396 7)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">option 1</a></li>
                                <li><a class="dropdown-item" href="#">option 2</a></li>
                                <li><a class="dropdown-item" href="#">option 3</a></li>
                            </ul>
                        </div>
                        <div class="job-filter-btn">
                            <div data-bs-toggle="dropdown">
                                <span class="span2">Experience</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="7" viewBox="0 0 17 7" fill="none">
                                    <g clip-path="url(#clip0_371_1596)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.30639 4.9741L13.0204 0.633728L13.9631 1.50168L8.77772 6.27603C8.6527 6.3911 8.48316 6.45575 8.30639 6.45575C8.12961 6.45575 7.96007 6.3911 7.83505 6.27603L2.64972 1.50168L3.59239 0.633728L8.30639 4.9741Z" fill="#202020"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_371_1596">
                                        <rect width="7" height="16" fill="white" transform="matrix(0 -1 1 0 0.306396 7)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">option 1</a></li>
                                <li><a class="dropdown-item" href="#">option 2</a></li>
                                <li><a class="dropdown-item" href="#">option 3</a></li>
                            </ul>
                        </div>
                        <div class="job-filter-btn">
                            <div data-bs-toggle="dropdown">
                                <span class="span2">Full Time</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="7" viewBox="0 0 17 7" fill="none">
                                    <g clip-path="url(#clip0_371_1596)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.30639 4.9741L13.0204 0.633728L13.9631 1.50168L8.77772 6.27603C8.6527 6.3911 8.48316 6.45575 8.30639 6.45575C8.12961 6.45575 7.96007 6.3911 7.83505 6.27603L2.64972 1.50168L3.59239 0.633728L8.30639 4.9741Z" fill="#202020"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_371_1596">
                                        <rect width="7" height="16" fill="white" transform="matrix(0 -1 1 0 0.306396 7)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">option 1</a></li>
                                <li><a class="dropdown-item" href="#">option 2</a></li>
                                <li><a class="dropdown-item" href="#">option 3</a></li>
                            </ul>
                        </div>
                        <div class="job-filter-btn">
                            <div data-bs-toggle="dropdown">
                                <span class="span2">Company Type</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="7" viewBox="0 0 17 7" fill="none">
                                    <g clip-path="url(#clip0_371_1596)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.30639 4.9741L13.0204 0.633728L13.9631 1.50168L8.77772 6.27603C8.6527 6.3911 8.48316 6.45575 8.30639 6.45575C8.12961 6.45575 7.96007 6.3911 7.83505 6.27603L2.64972 1.50168L3.59239 0.633728L8.30639 4.9741Z" fill="#202020"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_371_1596">
                                        <rect width="7" height="16" fill="white" transform="matrix(0 -1 1 0 0.306396 7)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#">option 1</a></li>
                                <li><a class="dropdown-item" href="#">option 2</a></li>
                                <li><a class="dropdown-item" href="#">option 3</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="custom-col-10 mx-auto mt-3">
            <div class="row">
                <div class="col-md-6">
                    <?php $i=1; foreach($jobs as $row){?>
                    <div class="job-card mb-3 <?php if($i==1){ echo 'active';} $i++;?>" data-id="<?=$row->job_id;?>" onclick="jobDetails(<?=$row->job_id ?>)">
                        <div class="d-flex justify-content-between w-100">
                            <div class="d-flex gap-3">
                                <img src="<?=$row->company_logo?>" alt="" class="companylogo">
                                <div>
                                    <p class="mb-1 t1"><?=$row->job_title;?></p>
                                    <p class="mb-1 t2"><?=$row->salary_min;?><?=$row->salary_type;?> - <?=$row->salary_max;?><?=$row->salary_type;?> <span></span></p>
                                </div>
                            </div>
                            <div>
                                <div class="higherch-btn">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                        <path d="M8.00002 1.33331L0.666687 14H15.3334M8.00002 3.99998L13 12.6666H3.00002M9.33335 9.33331H8.33335L9.33335 7.33331H6.66669V9.99998H7.33335V12L9.33335 9.33331Z" fill="#EB663D" fill-opacity="0.8"/>
                                    </svg>
                                    <span> Higher Chances</span>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex gap-3 mt-2">
                            <div class="company-name-div">
                                <p><?=$row->company_name?></p>
                            </div>
                            <div>
                                <div class="d-flex gap-2">
                                    <div class="job-cat-btn"><?=$row->job_type;?></div>
                                    <div class="job-cat-btn"><?=$row->employment_type;?></div>
                                    <div class="job-cat-btn"><?=$row->job_experience;?></div>
                                    <div class="job-cat-btn"><?=$row->no_of_opening;?> Vacancy</div>
									<?php 
									$skills = explode(',', $row->job_skills);

									foreach ($skills as $skill) {
										$skill = trim($skill);

										if (!empty($skill)) {
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>

                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between pt-3 border-dashed mt-3">
                            <div class="d-flex gap-2 post-text">
                                <span class="my-auto"><?=$row->job_created_at;?></span>
                                <span class="post-text-dot my-auto"></span>
                                <span class="my-auto"><?=$row->total_applicant;?> Applicants </span>
                            </div>
                            <div class="locafont d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                    <path d="M3.52366 3.01413C4.34419 2.21001 5.4489 1.7622 6.59774 1.768C7.74658 1.7738 8.84672 2.23275 9.65908 3.04512C10.4714 3.85748 10.9304 4.95762 10.9362 6.10646C10.942 7.2553 10.4942 8.36001 9.69007 9.18054L7.38537 11.4852C7.17888 11.6917 6.89885 11.8076 6.60686 11.8076C6.31488 11.8076 6.03485 11.6917 5.82835 11.4852L3.52366 9.18054C2.70599 8.3628 2.24664 7.25374 2.24664 6.09733C2.24664 4.94093 2.70599 3.83187 3.52366 3.01413Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"/>
                                    <path d="M6.60686 7.74881C7.51908 7.74881 8.25858 7.00931 8.25858 6.09709C8.25858 5.18487 7.51908 4.44537 6.60686 4.44537C5.69464 4.44537 4.95514 5.18487 4.95514 6.09709C4.95514 7.00931 5.69464 7.74881 6.60686 7.74881Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <span class="my-auto"><?=$row->job_city;?></span>
                                <span class="dott my-auto"></span>
                                <span class="my-auto"><?=$row->employment_type;?></span>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <div class="col-md-6" id="jobDetailsData" >
                    
                </div>
            </div>
        </div>
    </section>

   <?php require'js.php';?>
   <script>

function jobDetails(id){
	document.querySelectorAll('.job-card').forEach(function(card) {
        card.classList.remove('active');
    });

    const clickedJobCard = document.querySelector(`.job-card[data-id="${id}"]`);
    clickedJobCard.classList.add('active');
   $.ajax({
		type: 'POST',
		url: "<?=base_url('getJobDetails');?>",
		data: { 'id': id},
		success: function(res) {
			$('#jobDetailsData').html(res);
		}, 
		error: function() {
			Toast.fire({
			  icon: 'error',
			  title: 'Something went wrong, please refresh the page.',
			});
			return false;
		}
	});
}
</script>
  </body>
</html>