<!doctype html>
<html lang="en">
  <?php require'css.php';?>
  <body>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<style>
.swiper {
	width: 90%;
	padding: 40px 0;
}
.swiper-slide {
	background: #fff;
	padding: 20px;
	border-radius: 10px;
	box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
	text-align: left;
	transition: transform 0.4s ease, box-shadow 0.4s ease;
}
.swiper-slide-active {
	transform: scale(0.4); /* Enlarges center slide */
	box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
}
</style>
    

    <section class="position-relative" style="background: #F6FBFF;">
        <?php require'header.php';?>
		<?php if ($this->session->userdata('employee')) { ?>
			<div class="home-herosection text-center mob-hide">
            <h1 class="display-4" style="font-weight: 600;line-height: 1.3;">Search. Click. Start <br> Your <span style="color: #004B9B;">Career</span>.</h1>
            <h3 class="fw-normal">Simplifying Your Job Hunt Journey With 
                <span style="color: #004B9B;;">Job Karo </span></h3>
            <div class="d-flex gap-5 justify-content-center mt-5 mb-4">
                <a href="<?=base_url('jobs');?>" class="custom-btn2-outline">
                    <img src="<?=base_url('assets/newAssets/img/')?>work-outline.svg" alt=""> &nbsp; Browse Jobs
                </a>
                <button onclick="window.location.href='https://play.google.com/store/apps/details?id=com.wlhiring.teamhiring';" class="custom-btn2">
                    <img src="<?=base_url('assets/newAssets/img/')?>symbols_download.svg" alt=""> &nbsp; Download App
                </button>
            </div>
            <div class="col-md-10 mx-auto d-flex justify-content-between mt-5 py-3">
                <div class="col-md-2 text-center">
                    <h3><svg xmlns="http://www.w3.org/2000/svg" width="42" height="30" viewBox="0 0 42 30" fill="none">
                        <path d="M8.64574 0.59094C8.93249 0.87805 9.09356 1.26724 9.09356 1.67302C9.09356 2.07881 8.93249 2.468 8.64574 2.75511C7.0342 4.3666 5.75585 6.27973 4.88369 8.38527C4.01153 10.4908 3.56263 12.7475 3.56263 15.0265C3.56263 17.3056 4.01153 19.5623 4.88369 21.6678C5.75585 23.7734 7.0342 25.6865 8.64574 27.298C8.92454 27.5869 9.0787 27.9738 9.07502 28.3753C9.07134 28.7768 8.91012 29.1607 8.62608 29.4445C8.34204 29.7283 7.95791 29.8891 7.55641 29.8924C7.15492 29.8957 6.7682 29.7412 6.47953 29.4621C-1.49318 21.4894 -1.49318 8.56365 6.47953 0.59094C6.76664 0.304187 7.15583 0.143121 7.56162 0.143121C7.9674 0.143121 8.35863 0.304187 8.64574 0.59094ZM35.3507 0.59094C43.3234 8.56365 43.3234 21.4915 35.3507 29.4642C35.0605 29.7347 34.6765 29.8819 34.2798 29.8749C33.8831 29.8679 33.5046 29.7072 33.2241 29.4267C32.9435 29.1461 32.7828 28.7676 32.7758 28.3709C32.7688 27.9742 32.9161 27.5903 33.1866 27.3C34.7984 25.6885 36.077 23.7752 36.9494 21.6695C37.8217 19.5638 38.2707 17.3068 38.2707 15.0276C38.2707 12.7483 37.8217 10.4914 36.9494 8.38562C36.077 6.2799 34.7984 4.36663 33.1866 2.75511C33.0361 2.61492 32.9155 2.44587 32.8318 2.25804C32.7481 2.07021 32.7031 1.86744 32.6994 1.66184C32.6958 1.45624 32.7336 1.25201 32.8107 1.06134C32.8877 0.870677 33.0023 0.697475 33.1477 0.55207C33.2931 0.406665 33.4663 0.292036 33.657 0.215023C33.8476 0.138009 34.0519 0.100187 34.2575 0.103815C34.4631 0.107443 34.6658 0.152445 34.8537 0.236137C35.0415 0.319829 35.2106 0.440496 35.3507 0.59094ZM14.4196 6.36477C14.7063 6.65188 14.8674 7.04107 14.8674 7.44686C14.8674 7.85264 14.7063 8.24183 14.4196 8.52894C13.5661 9.38212 12.8891 10.3951 12.4272 11.5099C11.9653 12.6248 11.7276 13.8198 11.7276 15.0265C11.7276 16.2333 11.9653 17.4283 12.4272 18.5431C12.8891 19.658 13.5661 20.671 14.4196 21.5241C14.6901 21.8144 14.8373 22.1984 14.8303 22.5951C14.8233 22.9917 14.6626 23.3702 14.3821 23.6508C14.1015 23.9313 13.723 24.092 13.3263 24.099C12.9296 24.106 12.5457 23.9588 12.2554 23.6883C9.95826 21.391 8.66775 18.2753 8.66775 15.0265C8.66775 11.7778 9.95826 8.66207 12.2554 6.36477C12.5425 6.07802 12.9317 5.91695 13.3375 5.91695C13.7433 5.91695 14.1325 6.07802 14.4196 6.36477ZM29.5789 6.36477C31.8761 8.66207 33.1666 11.7778 33.1666 15.0265C33.1666 18.2753 31.8761 21.391 29.5789 23.6883C29.4378 23.8346 29.2689 23.9514 29.0821 24.0317C28.8953 24.112 28.6944 24.1544 28.4911 24.1562C28.2878 24.1581 28.0861 24.1194 27.8979 24.0425C27.7097 23.9656 27.5386 23.852 27.3948 23.7083C27.251 23.5646 27.1372 23.3937 27.0601 23.2056C26.983 23.0174 26.9442 22.8158 26.9458 22.6125C26.9475 22.4092 26.9897 22.2082 27.0698 22.0213C27.15 21.8345 27.2666 21.6655 27.4127 21.5241C28.2659 20.671 28.9426 19.6582 29.4044 18.5435C29.8661 17.4288 30.1037 16.2341 30.1037 15.0276C30.1037 13.821 29.8661 12.6263 29.4044 11.5116C28.9426 10.3969 28.2659 9.38412 27.4127 8.53098C27.1423 8.24071 26.995 7.85678 27.002 7.46008C27.009 7.06338 27.1697 6.68489 27.4503 6.40434C27.7308 6.12379 28.1093 5.96308 28.506 5.95608C28.9027 5.94908 29.2866 6.09633 29.5769 6.36682M20.9162 11.9651C21.7284 11.9651 22.5073 12.2877 23.0817 12.8621C23.656 13.4364 23.9787 14.2153 23.9787 15.0276C23.9787 15.8398 23.656 16.6187 23.0817 17.1931C22.5073 17.7674 21.7284 18.0901 20.9162 18.0901C20.1039 18.0901 19.325 17.7674 18.7506 17.1931C18.1763 16.6187 17.8537 15.8398 17.8537 15.0276C17.8537 14.2153 18.1763 13.4364 18.7506 12.8621C19.325 12.2877 20.1039 11.9651 20.9162 11.9651Z" fill="black"/>
                      </svg> 10k +</h3>
                      <h5>Active Jobs Listing</h5>
                      <p style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Explore a wide range of opportunities across industries and locations</p>
                </div>
                <div class="col-md-2 text-center">
                    <h3><svg xmlns="http://www.w3.org/2000/svg" width="50" height="40" viewBox="0 0 50 40" fill="none">
                        <path d="M48.4454 36.2904H45.1461V13.1953C45.5836 13.1953 46.0032 13.0215 46.3126 12.7121C46.622 12.4027 46.7958 11.9831 46.7958 11.5456C46.7958 11.1081 46.622 10.6885 46.3126 10.3791C46.0032 10.0698 45.5836 9.89597 45.1461 9.89597H35.2482V3.29735C35.6857 3.29735 36.1053 3.12355 36.4147 2.81418C36.724 2.50481 36.8979 2.08522 36.8979 1.6477C36.8979 1.21019 36.724 0.79059 36.4147 0.48122C36.1053 0.17185 35.6857 -0.00195312 35.2482 -0.00195312H5.55443C5.11691 -0.00195312 4.69732 0.17185 4.38795 0.48122C4.07858 0.79059 3.90478 1.21019 3.90478 1.6477C3.90478 2.08522 4.07858 2.50481 4.38795 2.81418C4.69732 3.12355 5.11691 3.29735 5.55443 3.29735V36.2904H2.25512C1.81761 36.2904 1.39801 36.4642 1.08864 36.7736C0.779271 37.083 0.605469 37.5026 0.605469 37.9401C0.605469 38.3776 0.779271 38.7972 1.08864 39.1066C1.39801 39.4159 1.81761 39.5897 2.25512 39.5897H48.4454C48.8829 39.5897 49.3025 39.4159 49.6119 39.1066C49.9213 38.7972 50.0951 38.3776 50.0951 37.9401C50.0951 37.5026 49.9213 37.083 49.6119 36.7736C49.3025 36.4642 48.8829 36.2904 48.4454 36.2904ZM41.8468 13.1953V36.2904H35.2482V13.1953H41.8468ZM8.85374 3.29735H31.9489V36.2904H26.9999V26.3925C26.9999 25.955 26.8261 25.5354 26.5168 25.226C26.2074 24.9167 25.7878 24.7429 25.3503 24.7429H15.4524C15.0148 24.7429 14.5952 24.9167 14.2859 25.226C13.9765 25.5354 13.8027 25.955 13.8027 26.3925V36.2904H8.85374V3.29735ZM23.7006 36.2904H17.102V28.0422H23.7006V36.2904ZM12.153 9.89597C12.153 9.45845 12.3268 9.03886 12.6362 8.72949C12.9456 8.42012 13.3652 8.24632 13.8027 8.24632H17.102C17.5395 8.24632 17.9591 8.42012 18.2685 8.72949C18.5779 9.03886 18.7517 9.45845 18.7517 9.89597C18.7517 10.3335 18.5779 10.7531 18.2685 11.0625C17.9591 11.3718 17.5395 11.5456 17.102 11.5456H13.8027C13.3652 11.5456 12.9456 11.3718 12.6362 11.0625C12.3268 10.7531 12.153 10.3335 12.153 9.89597ZM22.051 9.89597C22.051 9.45845 22.2248 9.03886 22.5341 8.72949C22.8435 8.42012 23.2631 8.24632 23.7006 8.24632H26.9999C27.4374 8.24632 27.857 8.42012 28.1664 8.72949C28.4758 9.03886 28.6496 9.45845 28.6496 9.89597C28.6496 10.3335 28.4758 10.7531 28.1664 11.0625C27.857 11.3718 27.4374 11.5456 26.9999 11.5456H23.7006C23.2631 11.5456 22.8435 11.3718 22.5341 11.0625C22.2248 10.7531 22.051 10.3335 22.051 9.89597ZM12.153 18.1442C12.153 17.7067 12.3268 17.2871 12.6362 16.9778C12.9456 16.6684 13.3652 16.4946 13.8027 16.4946H17.102C17.5395 16.4946 17.9591 16.6684 18.2685 16.9778C18.5779 17.2871 18.7517 17.7067 18.7517 18.1442C18.7517 18.5818 18.5779 19.0014 18.2685 19.3107C17.9591 19.6201 17.5395 19.7939 17.102 19.7939H13.8027C13.3652 19.7939 12.9456 19.6201 12.6362 19.3107C12.3268 19.0014 12.153 18.5818 12.153 18.1442ZM22.051 18.1442C22.051 17.7067 22.2248 17.2871 22.5341 16.9778C22.8435 16.6684 23.2631 16.4946 23.7006 16.4946H26.9999C27.4374 16.4946 27.857 16.6684 28.1664 16.9778C28.4758 17.2871 28.6496 17.7067 28.6496 18.1442C28.6496 18.5818 28.4758 19.0014 28.1664 19.3107C27.857 19.6201 27.4374 19.7939 26.9999 19.7939H23.7006C23.2631 19.7939 22.8435 19.6201 22.5341 19.3107C22.2248 19.0014 22.051 18.5818 22.051 18.1442Z" fill="black"/>
                      </svg>
                        2,500+</h3>
                      <h5>Companies Hiring</h5>
                      <p style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Top brands and start-ups trust Job Karo for their hiring needs.</p>
                </div>
                <div class="col-md-2 text-center">
                    <h3>
                        <svg xmlns="http://www.w3.org/2000/svg" width="49" height="36" viewBox="0 0 49 36" fill="none">
                            <path d="M51.7596 12.1228L46.4993 1.59595C46.3299 1.25678 46.0954 0.954292 45.8091 0.705759C45.5228 0.457226 45.1904 0.267514 44.8308 0.147456C44.4712 0.0273973 44.0915 -0.0206562 43.7133 0.00603785C43.3351 0.0327319 42.9659 0.133651 42.6267 0.303033L37.3561 2.93836L26.4003 0.0390891C26.1934 -0.0145229 25.9763 -0.0145229 25.7693 0.0390891L14.8136 2.93836L9.545 0.303033C9.20573 0.13333 8.83634 0.0321553 8.45795 0.00529371C8.07956 -0.0215679 7.69958 0.0264104 7.33974 0.146485C6.9799 0.26656 6.64725 0.456376 6.36081 0.705085C6.07437 0.953793 5.83976 1.25652 5.67038 1.59595L0.410045 12.1228C0.0678138 12.8075 0.0115468 13.6002 0.253617 14.3264C0.495688 15.0526 1.01627 15.6529 1.7009 15.9954L7.29941 18.7957L18.7666 26.9862C18.8909 27.0758 19.0307 27.1415 19.179 27.18L32.3762 30.4793C32.4767 30.5045 32.5799 30.517 32.6835 30.5164C33.0115 30.5162 33.326 30.3856 33.5578 30.1535L44.9631 18.7482L50.4688 15.9954C51.1534 15.6529 51.674 15.0526 51.9161 14.3264C52.1581 13.6002 52.1019 12.8075 51.7596 12.1228ZM40.8307 19.373L33.4485 13.459C33.2104 13.2685 32.9104 13.1726 32.6059 13.1897C32.3014 13.2068 32.014 13.3358 31.7988 13.5518C27.9531 17.4264 23.6537 16.9377 20.9132 15.185C20.8593 15.1517 20.8138 15.1066 20.7802 15.0529C20.7466 14.9993 20.7257 14.9386 20.7193 14.8757C20.712 14.8179 20.7177 14.7593 20.7359 14.704C20.7541 14.6487 20.7843 14.5982 20.8245 14.556L29.8852 5.77164H36.8674L42.7257 17.4883L40.8307 19.373ZM2.59996 13.5436C2.56586 13.4402 2.57401 13.3275 2.62264 13.2301L7.88504 2.70122C7.91962 2.63258 7.9727 2.57497 8.03829 2.53489C8.10387 2.49481 8.17935 2.47385 8.25621 2.47439C8.31991 2.47446 8.38272 2.48928 8.43973 2.51769L13.0196 4.80659L7.38602 16.082L2.80617 13.7931C2.75674 13.7675 2.713 13.7323 2.67756 13.6894C2.64212 13.6465 2.61573 13.5969 2.59996 13.5436ZM32.304 27.91L20.0141 24.8375L9.5182 17.3398L15.5353 5.30767L26.0848 2.51563L29.1367 3.32396C28.9033 3.36912 28.6882 3.48167 28.5181 3.64771L19.0944 12.793C18.7885 13.0988 18.5551 13.4694 18.4117 13.8775C18.2682 14.2856 18.2183 14.7207 18.2656 15.1507C18.3129 15.5807 18.4562 15.9945 18.685 16.3617C18.9138 16.7288 19.2221 17.0398 19.5873 17.2718C23.7568 19.936 28.815 19.4349 32.7433 16.0572L39.0759 21.134L32.304 27.91ZM49.5697 13.5436C49.5528 13.595 49.5258 13.6426 49.4904 13.6837C49.455 13.7247 49.4119 13.7584 49.3635 13.7828L44.7837 16.082L39.1501 4.80659L43.73 2.51769C43.7785 2.49334 43.8313 2.4788 43.8854 2.4749C43.9396 2.47101 43.994 2.47784 44.0454 2.49501C44.0969 2.51198 44.1445 2.53893 44.1856 2.57431C44.2266 2.60969 44.2603 2.65282 44.2846 2.70122L49.547 13.2301C49.5957 13.3275 49.6038 13.4402 49.5697 13.5436ZM26.4746 34.5272C26.3952 34.8454 26.1927 35.1191 25.9115 35.288C25.6304 35.457 25.2937 35.5075 24.9755 35.4283L16.3704 33.2775C16.222 33.2395 16.0821 33.1737 15.958 33.0837L10.5204 29.205C10.2532 29.0136 10.073 28.7239 10.0195 28.3996C9.96591 28.0753 10.0434 27.7431 10.2348 27.4759C10.4262 27.2088 10.7159 27.0286 11.0401 26.975C11.3644 26.9215 11.6966 26.9989 11.9638 27.1903L17.1994 30.9289L25.5735 33.0219C25.7315 33.0614 25.8802 33.1317 26.011 33.2288C26.1418 33.3259 26.2521 33.4479 26.3357 33.5878C26.4192 33.7276 26.4743 33.8826 26.4978 34.0438C26.5213 34.205 26.5127 34.3693 26.4725 34.5272H26.4746Z" fill="black"/>
                          </svg>
                        100k+</h3>
                      <h5>Employees Hired</h5>
                      <p style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Join thousands who’ve found their dream job through Job Karo.</p>
                </div>
            </div>
        </div>

        <div class="home-herosection p-3 mob-show" style="background-image: none; background-color: #f6fbff;">
            <h1 class="display-4" style="font-weight: 600;line-height: 1.3;">Search. Click.<br> Start  Your <br><span style="color: #004B9B;">Career</span>.</h1>
            <h3 class="fw-normal">Simplifying Your Job Hunt Journey <br> With 
                <span style="color: #004B9B;;">Job Karo </span></h3>
            
                <div class="mob-show p-0 mt-4">
                    <div class="search-divMob">
                            <div class="d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M14.0775 14.0987L16.6442 16.6654M15.8334 9.58203C15.8334 11.2396 15.1749 12.8293 14.0028 14.0014C12.8307 15.1736 11.241 15.832 9.58337 15.832C7.92577 15.832 6.33606 15.1736 5.16396 14.0014C3.99185 12.8293 3.33337 11.2396 3.33337 9.58203C3.33337 7.92443 3.99185 6.33472 5.16396 5.16261C6.33606 3.99051 7.92577 3.33203 9.58337 3.33203C11.241 3.33203 12.8307 3.99051 14.0028 5.16261C15.1749 6.33472 15.8334 7.92443 15.8334 9.58203Z" stroke="#202020" stroke-opacity="0.7" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                                <input type="text" placeholder="Search for Company, Skills....">
                            </div>
                    </div>
                    <div class="searchRelate mt-4 justify-content-between">
                        <div class="activesearch">
                            Most Common Search's
                        </div>
                        <div class="my-auto text-primary">UX Designer</div>
                        <div class="my-auto text-primary">HR Manager</div>
                    </div>
                </div>

            <div class="col-md-10 mx-auto d-flex justify-content-between mt-3 py-3">
                <div class="col-md-2 text-center">
                    <h3>
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="20" viewBox="0 0 42 30" fill="none">
                        <path d="M8.64574 0.59094C8.93249 0.87805 9.09356 1.26724 9.09356 1.67302C9.09356 2.07881 8.93249 2.468 8.64574 2.75511C7.0342 4.3666 5.75585 6.27973 4.88369 8.38527C4.01153 10.4908 3.56263 12.7475 3.56263 15.0265C3.56263 17.3056 4.01153 19.5623 4.88369 21.6678C5.75585 23.7734 7.0342 25.6865 8.64574 27.298C8.92454 27.5869 9.0787 27.9738 9.07502 28.3753C9.07134 28.7768 8.91012 29.1607 8.62608 29.4445C8.34204 29.7283 7.95791 29.8891 7.55641 29.8924C7.15492 29.8957 6.7682 29.7412 6.47953 29.4621C-1.49318 21.4894 -1.49318 8.56365 6.47953 0.59094C6.76664 0.304187 7.15583 0.143121 7.56162 0.143121C7.9674 0.143121 8.35863 0.304187 8.64574 0.59094ZM35.3507 0.59094C43.3234 8.56365 43.3234 21.4915 35.3507 29.4642C35.0605 29.7347 34.6765 29.8819 34.2798 29.8749C33.8831 29.8679 33.5046 29.7072 33.2241 29.4267C32.9435 29.1461 32.7828 28.7676 32.7758 28.3709C32.7688 27.9742 32.9161 27.5903 33.1866 27.3C34.7984 25.6885 36.077 23.7752 36.9494 21.6695C37.8217 19.5638 38.2707 17.3068 38.2707 15.0276C38.2707 12.7483 37.8217 10.4914 36.9494 8.38562C36.077 6.2799 34.7984 4.36663 33.1866 2.75511C33.0361 2.61492 32.9155 2.44587 32.8318 2.25804C32.7481 2.07021 32.7031 1.86744 32.6994 1.66184C32.6958 1.45624 32.7336 1.25201 32.8107 1.06134C32.8877 0.870677 33.0023 0.697475 33.1477 0.55207C33.2931 0.406665 33.4663 0.292036 33.657 0.215023C33.8476 0.138009 34.0519 0.100187 34.2575 0.103815C34.4631 0.107443 34.6658 0.152445 34.8537 0.236137C35.0415 0.319829 35.2106 0.440496 35.3507 0.59094ZM14.4196 6.36477C14.7063 6.65188 14.8674 7.04107 14.8674 7.44686C14.8674 7.85264 14.7063 8.24183 14.4196 8.52894C13.5661 9.38212 12.8891 10.3951 12.4272 11.5099C11.9653 12.6248 11.7276 13.8198 11.7276 15.0265C11.7276 16.2333 11.9653 17.4283 12.4272 18.5431C12.8891 19.658 13.5661 20.671 14.4196 21.5241C14.6901 21.8144 14.8373 22.1984 14.8303 22.5951C14.8233 22.9917 14.6626 23.3702 14.3821 23.6508C14.1015 23.9313 13.723 24.092 13.3263 24.099C12.9296 24.106 12.5457 23.9588 12.2554 23.6883C9.95826 21.391 8.66775 18.2753 8.66775 15.0265C8.66775 11.7778 9.95826 8.66207 12.2554 6.36477C12.5425 6.07802 12.9317 5.91695 13.3375 5.91695C13.7433 5.91695 14.1325 6.07802 14.4196 6.36477ZM29.5789 6.36477C31.8761 8.66207 33.1666 11.7778 33.1666 15.0265C33.1666 18.2753 31.8761 21.391 29.5789 23.6883C29.4378 23.8346 29.2689 23.9514 29.0821 24.0317C28.8953 24.112 28.6944 24.1544 28.4911 24.1562C28.2878 24.1581 28.0861 24.1194 27.8979 24.0425C27.7097 23.9656 27.5386 23.852 27.3948 23.7083C27.251 23.5646 27.1372 23.3937 27.0601 23.2056C26.983 23.0174 26.9442 22.8158 26.9458 22.6125C26.9475 22.4092 26.9897 22.2082 27.0698 22.0213C27.15 21.8345 27.2666 21.6655 27.4127 21.5241C28.2659 20.671 28.9426 19.6582 29.4044 18.5435C29.8661 17.4288 30.1037 16.2341 30.1037 15.0276C30.1037 13.821 29.8661 12.6263 29.4044 11.5116C28.9426 10.3969 28.2659 9.38412 27.4127 8.53098C27.1423 8.24071 26.995 7.85678 27.002 7.46008C27.009 7.06338 27.1697 6.68489 27.4503 6.40434C27.7308 6.12379 28.1093 5.96308 28.506 5.95608C28.9027 5.94908 29.2866 6.09633 29.5769 6.36682M20.9162 11.9651C21.7284 11.9651 22.5073 12.2877 23.0817 12.8621C23.656 13.4364 23.9787 14.2153 23.9787 15.0276C23.9787 15.8398 23.656 16.6187 23.0817 17.1931C22.5073 17.7674 21.7284 18.0901 20.9162 18.0901C20.1039 18.0901 19.325 17.7674 18.7506 17.1931C18.1763 16.6187 17.8537 15.8398 17.8537 15.0276C17.8537 14.2153 18.1763 13.4364 18.7506 12.8621C19.325 12.2877 20.1039 11.9651 20.9162 11.9651Z" fill="black"/>
                      </svg> 10k +</h3>
                      <h6 style="font-size: 14px;">Active Jobs</h6>
                      <p style="color: rgba(32, 32, 32, 0.80);font-size: 13px;">Explore a wide range of opportunities</p>
                </div>
                <div class="col-md-2 text-center">
                    <h3>
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="20" viewBox="0 0 50 40" fill="none">
                        <path d="M48.4454 36.2904H45.1461V13.1953C45.5836 13.1953 46.0032 13.0215 46.3126 12.7121C46.622 12.4027 46.7958 11.9831 46.7958 11.5456C46.7958 11.1081 46.622 10.6885 46.3126 10.3791C46.0032 10.0698 45.5836 9.89597 45.1461 9.89597H35.2482V3.29735C35.6857 3.29735 36.1053 3.12355 36.4147 2.81418C36.724 2.50481 36.8979 2.08522 36.8979 1.6477C36.8979 1.21019 36.724 0.79059 36.4147 0.48122C36.1053 0.17185 35.6857 -0.00195312 35.2482 -0.00195312H5.55443C5.11691 -0.00195312 4.69732 0.17185 4.38795 0.48122C4.07858 0.79059 3.90478 1.21019 3.90478 1.6477C3.90478 2.08522 4.07858 2.50481 4.38795 2.81418C4.69732 3.12355 5.11691 3.29735 5.55443 3.29735V36.2904H2.25512C1.81761 36.2904 1.39801 36.4642 1.08864 36.7736C0.779271 37.083 0.605469 37.5026 0.605469 37.9401C0.605469 38.3776 0.779271 38.7972 1.08864 39.1066C1.39801 39.4159 1.81761 39.5897 2.25512 39.5897H48.4454C48.8829 39.5897 49.3025 39.4159 49.6119 39.1066C49.9213 38.7972 50.0951 38.3776 50.0951 37.9401C50.0951 37.5026 49.9213 37.083 49.6119 36.7736C49.3025 36.4642 48.8829 36.2904 48.4454 36.2904ZM41.8468 13.1953V36.2904H35.2482V13.1953H41.8468ZM8.85374 3.29735H31.9489V36.2904H26.9999V26.3925C26.9999 25.955 26.8261 25.5354 26.5168 25.226C26.2074 24.9167 25.7878 24.7429 25.3503 24.7429H15.4524C15.0148 24.7429 14.5952 24.9167 14.2859 25.226C13.9765 25.5354 13.8027 25.955 13.8027 26.3925V36.2904H8.85374V3.29735ZM23.7006 36.2904H17.102V28.0422H23.7006V36.2904ZM12.153 9.89597C12.153 9.45845 12.3268 9.03886 12.6362 8.72949C12.9456 8.42012 13.3652 8.24632 13.8027 8.24632H17.102C17.5395 8.24632 17.9591 8.42012 18.2685 8.72949C18.5779 9.03886 18.7517 9.45845 18.7517 9.89597C18.7517 10.3335 18.5779 10.7531 18.2685 11.0625C17.9591 11.3718 17.5395 11.5456 17.102 11.5456H13.8027C13.3652 11.5456 12.9456 11.3718 12.6362 11.0625C12.3268 10.7531 12.153 10.3335 12.153 9.89597ZM22.051 9.89597C22.051 9.45845 22.2248 9.03886 22.5341 8.72949C22.8435 8.42012 23.2631 8.24632 23.7006 8.24632H26.9999C27.4374 8.24632 27.857 8.42012 28.1664 8.72949C28.4758 9.03886 28.6496 9.45845 28.6496 9.89597C28.6496 10.3335 28.4758 10.7531 28.1664 11.0625C27.857 11.3718 27.4374 11.5456 26.9999 11.5456H23.7006C23.2631 11.5456 22.8435 11.3718 22.5341 11.0625C22.2248 10.7531 22.051 10.3335 22.051 9.89597ZM12.153 18.1442C12.153 17.7067 12.3268 17.2871 12.6362 16.9778C12.9456 16.6684 13.3652 16.4946 13.8027 16.4946H17.102C17.5395 16.4946 17.9591 16.6684 18.2685 16.9778C18.5779 17.2871 18.7517 17.7067 18.7517 18.1442C18.7517 18.5818 18.5779 19.0014 18.2685 19.3107C17.9591 19.6201 17.5395 19.7939 17.102 19.7939H13.8027C13.3652 19.7939 12.9456 19.6201 12.6362 19.3107C12.3268 19.0014 12.153 18.5818 12.153 18.1442ZM22.051 18.1442C22.051 17.7067 22.2248 17.2871 22.5341 16.9778C22.8435 16.6684 23.2631 16.4946 23.7006 16.4946H26.9999C27.4374 16.4946 27.857 16.6684 28.1664 16.9778C28.4758 17.2871 28.6496 17.7067 28.6496 18.1442C28.6496 18.5818 28.4758 19.0014 28.1664 19.3107C27.857 19.6201 27.4374 19.7939 26.9999 19.7939H23.7006C23.2631 19.7939 22.8435 19.6201 22.5341 19.3107C22.2248 19.0014 22.051 18.5818 22.051 18.1442Z" fill="black"/>
                      </svg>
                        2,500+</h3>
                      <h6 style="font-size: 14px;">Companies</h6>
                      <p style="color: rgba(32, 32, 32, 0.80);font-size: 13px;">
                        Top brands  trust Job Karo for their hiring
                      </p>
                </div>
                <div class="col-md-2 text-center">
                    <h3>
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="20" viewBox="0 0 49 36" fill="none">
                            <path d="M51.7596 12.1228L46.4993 1.59595C46.3299 1.25678 46.0954 0.954292 45.8091 0.705759C45.5228 0.457226 45.1904 0.267514 44.8308 0.147456C44.4712 0.0273973 44.0915 -0.0206562 43.7133 0.00603785C43.3351 0.0327319 42.9659 0.133651 42.6267 0.303033L37.3561 2.93836L26.4003 0.0390891C26.1934 -0.0145229 25.9763 -0.0145229 25.7693 0.0390891L14.8136 2.93836L9.545 0.303033C9.20573 0.13333 8.83634 0.0321553 8.45795 0.00529371C8.07956 -0.0215679 7.69958 0.0264104 7.33974 0.146485C6.9799 0.26656 6.64725 0.456376 6.36081 0.705085C6.07437 0.953793 5.83976 1.25652 5.67038 1.59595L0.410045 12.1228C0.0678138 12.8075 0.0115468 13.6002 0.253617 14.3264C0.495688 15.0526 1.01627 15.6529 1.7009 15.9954L7.29941 18.7957L18.7666 26.9862C18.8909 27.0758 19.0307 27.1415 19.179 27.18L32.3762 30.4793C32.4767 30.5045 32.5799 30.517 32.6835 30.5164C33.0115 30.5162 33.326 30.3856 33.5578 30.1535L44.9631 18.7482L50.4688 15.9954C51.1534 15.6529 51.674 15.0526 51.9161 14.3264C52.1581 13.6002 52.1019 12.8075 51.7596 12.1228ZM40.8307 19.373L33.4485 13.459C33.2104 13.2685 32.9104 13.1726 32.6059 13.1897C32.3014 13.2068 32.014 13.3358 31.7988 13.5518C27.9531 17.4264 23.6537 16.9377 20.9132 15.185C20.8593 15.1517 20.8138 15.1066 20.7802 15.0529C20.7466 14.9993 20.7257 14.9386 20.7193 14.8757C20.712 14.8179 20.7177 14.7593 20.7359 14.704C20.7541 14.6487 20.7843 14.5982 20.8245 14.556L29.8852 5.77164H36.8674L42.7257 17.4883L40.8307 19.373ZM2.59996 13.5436C2.56586 13.4402 2.57401 13.3275 2.62264 13.2301L7.88504 2.70122C7.91962 2.63258 7.9727 2.57497 8.03829 2.53489C8.10387 2.49481 8.17935 2.47385 8.25621 2.47439C8.31991 2.47446 8.38272 2.48928 8.43973 2.51769L13.0196 4.80659L7.38602 16.082L2.80617 13.7931C2.75674 13.7675 2.713 13.7323 2.67756 13.6894C2.64212 13.6465 2.61573 13.5969 2.59996 13.5436ZM32.304 27.91L20.0141 24.8375L9.5182 17.3398L15.5353 5.30767L26.0848 2.51563L29.1367 3.32396C28.9033 3.36912 28.6882 3.48167 28.5181 3.64771L19.0944 12.793C18.7885 13.0988 18.5551 13.4694 18.4117 13.8775C18.2682 14.2856 18.2183 14.7207 18.2656 15.1507C18.3129 15.5807 18.4562 15.9945 18.685 16.3617C18.9138 16.7288 19.2221 17.0398 19.5873 17.2718C23.7568 19.936 28.815 19.4349 32.7433 16.0572L39.0759 21.134L32.304 27.91ZM49.5697 13.5436C49.5528 13.595 49.5258 13.6426 49.4904 13.6837C49.455 13.7247 49.4119 13.7584 49.3635 13.7828L44.7837 16.082L39.1501 4.80659L43.73 2.51769C43.7785 2.49334 43.8313 2.4788 43.8854 2.4749C43.9396 2.47101 43.994 2.47784 44.0454 2.49501C44.0969 2.51198 44.1445 2.53893 44.1856 2.57431C44.2266 2.60969 44.2603 2.65282 44.2846 2.70122L49.547 13.2301C49.5957 13.3275 49.6038 13.4402 49.5697 13.5436ZM26.4746 34.5272C26.3952 34.8454 26.1927 35.1191 25.9115 35.288C25.6304 35.457 25.2937 35.5075 24.9755 35.4283L16.3704 33.2775C16.222 33.2395 16.0821 33.1737 15.958 33.0837L10.5204 29.205C10.2532 29.0136 10.073 28.7239 10.0195 28.3996C9.96591 28.0753 10.0434 27.7431 10.2348 27.4759C10.4262 27.2088 10.7159 27.0286 11.0401 26.975C11.3644 26.9215 11.6966 26.9989 11.9638 27.1903L17.1994 30.9289L25.5735 33.0219C25.7315 33.0614 25.8802 33.1317 26.011 33.2288C26.1418 33.3259 26.2521 33.4479 26.3357 33.5878C26.4192 33.7276 26.4743 33.8826 26.4978 34.0438C26.5213 34.205 26.5127 34.3693 26.4725 34.5272H26.4746Z" fill="black"/>
                          </svg>
                        100k+</h3>
                      <h6 style="font-size: 14px;">Total Hired</h6>
                      <p style="color: rgba(32, 32, 32, 0.80);font-size: 12px;">
                        Join thousands who’ve found their dream job 
                      </p>
                </div>
            </div>
            <div class="d-flex gap-3 justify-content-center mt-2 mb-4">
                <a href="<?=base_url('jobs');?>" class="custom-btn2-outline">
                    <img src="<?=base_url('assets/newAssets/img/')?>work-outline.svg" alt=""> &nbsp;Browse Jobs
                </a>
                <button onclick="window.location.href='https://play.google.com/store/apps/details?id=com.wlhiring.teamhiring';" class="custom-btn2">
                    <img src="<?=base_url('assets/newAssets/img/')?>symbols_download.svg" alt="">Download App
                </button>
            </div>
        </div>
		<?php }else{ ?>
        <div class="home-herosection text-center px-0">
            <div class="mob-hide">
                <h1 class="display-4" style="font-weight: 600;line-height: 1.3;">Find Your Dream<br> Job <span style="color: #004B9B;">Effortlessly</span></h1>
                <h3 class="fw-normal">Join thousands of professionals landing their
                <span style="color: #004B9B;;">dream roles </span>every day.</h3>
            </div>
            <div class="d-flex gap-5 justify-content-center mt-5 mb-4 mob-hide">
                <button class="custom-btn2-outline" data-bs-toggle="modal" data-bs-target="#choose_login">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                        <path d="M11 7.5L9.6 8.9L12.2 11.5H2V13.5H12.2L9.6 16.1L11 17.5L16 12.5L11 7.5ZM20 19.5H12V21.5H20C21.1 21.5 22 20.6 22 19.5V5.5C22 4.4 21.1 3.5 20 3.5H12V5.5H20V19.5Z" fill="#007BFF"/>
                    </svg> &nbsp; Sign Up Now
                </button>
                <button class="custom-btn2" onclick="window.location.href='https://play.google.com/store/apps/details?id=com.wlhiring.teamhiring';">
                    <img src="<?=base_url('assets/newAssets/img/')?>symbols_download.svg" alt=""> &nbsp; Download App
                </button>
            </div>

            <div class="mob-show ps-4">
                <h1 class="display-4 text-start" style="font-weight: 600;line-height: 1.3;">Find Your<br> Dream Job,<br> <span style="color: #004B9B;">Effortlessly</span></h1>
                <h3 class="fw-normal text-start">Join thousands of professionals landing their
                <span style="color: #004B9B;;">dream roles </span>every day.</h3>
            </div>
            <div class="mob-show p-2 mt-4">
                <div class="search-divMob">
                        <div class="d-flex gap-2">
                            <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M14.0775 14.0987L16.6442 16.6654M15.8334 9.58203C15.8334 11.2396 15.1749 12.8293 14.0028 14.0014C12.8307 15.1736 11.241 15.832 9.58337 15.832C7.92577 15.832 6.33606 15.1736 5.16396 14.0014C3.99185 12.8293 3.33337 11.2396 3.33337 9.58203C3.33337 7.92443 3.99185 6.33472 5.16396 5.16261C6.33606 3.99051 7.92577 3.33203 9.58337 3.33203C11.241 3.33203 12.8307 3.99051 14.0028 5.16261C15.1749 6.33472 15.8334 7.92443 15.8334 9.58203Z" stroke="#202020" stroke-opacity="0.7" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <input type="text" placeholder="Search for Company, Skills....">
                        </div>
                </div>
                <div class="searchRelate mt-4 justify-content-between">
                    <div class="activesearch">
                        Most Common Search's
                    </div>
                    <div class="my-auto text-primary">UX Designer</div>
                    <div class="my-auto text-primary">HR Manager</div>
                </div>
            </div>

            <div class="topCompanies justify-content-between">
                <img src="<?=base_url('assets/newAssets/img/')?>partner1.png" alt="">
                <img src="<?=base_url('assets/newAssets/img/')?>partner2.png" alt="">
                <img src="<?=base_url('assets/newAssets/img/')?>partner3.png" alt="">
                <img src="<?=base_url('assets/newAssets/img/')?>partner4.png" alt="">
                <img src="<?=base_url('assets/newAssets/img/')?>partner5.png" alt="">
                <img src="<?=base_url('assets/newAssets/img/')?>partner6.png" alt="">
                <img src="<?=base_url('assets/newAssets/img/')?>partner7.png" alt="">
            </div>
        </div>
		
        <div class="custom-col-10 mx-auto row my-3 pt-5 twocardPT mob-hide">
            <div class="col-md-6">
                <div class="twocardbg position-relative">
                    <h3>Find the Right Talent, Faster.</h3>
                    <div class="d-flex mt-4">
                        <div>
                            <p>Post jobs, manage applicants, and connect with <br> top talent tailored to your requirements.</p>
                            <button data-bs-toggle="modal" data-bs-target="#choose_login" class="custom-btn2-outline py-2 bg-transparent">Start Hiring </button>
                        </div>
                        <div>
                            <img src="<?=base_url('assets/newAssets/img/')?>twosec1.png" alt="" class="position-absolute"
                             style="top: 2rem;height: 151.652px;right: 2rem;">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="twocardbg position-relative">
                    <h3>Your Next Job Awaits.</h3>
                    <div class="d-flex mt-4 justify-content-between">
                        <div>
                            <p>Personalized Job Recommendations Based on <br> Your Profile</p>
                            <button data-bs-toggle="modal" data-bs-target="#choose_login" class="custom-btn2-outline py-2 bg-transparent">Find Jobs Now</button>
                        </div>
                        <div>
                            <img src="<?=base_url('assets/newAssets/img/')?>twosec2.png" alt="" class="position-absolute" 
                            style="height: 191.652px; right: 3rem; top: 1rem;">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="custom-col-10 mx-auto row mx-0 my-3 pt-5 twocardPT mob-show">
            <div class="col-12 d-flex gap-1 justify-content-center mt-5 mb-4">
                <button class="custom-btn2-outline" data-bs-toggle="modal" data-bs-target="#choose_login">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                        <path d="M11 7.5L9.6 8.9L12.2 11.5H2V13.5H12.2L9.6 16.1L11 17.5L16 12.5L11 7.5ZM20 19.5H12V21.5H20C21.1 21.5 22 20.6 22 19.5V5.5C22 4.4 21.1 3.5 20 3.5H12V5.5H20V19.5Z" fill="#007BFF"/>
                    </svg> &nbsp; Sign Up Now
                </button>
                <button onclick="window.location.href='https://play.google.com/store/apps/details?id=com.wlhiring.teamhiring';" class="custom-btn2">
                    <img src="<?=base_url('assets/newAssets/img/')?>symbols_download.svg" alt=""> &nbsp; Download App
                </button>
            </div>
            <h3 class="text-center my-5 fw-bold">
                Choose Your Path to Success
            </h3>
            <div class="col-md-6">
                <div class="twocardbg position-relative">
                    <h3>Find the Right Talent, Faster.</h3>
                    <div class="d-flex">
                        <div>
                            <p>Post jobs, manage applicants, and connect with <br> top talent tailored to your requirements.</p>
                            <button data-bs-toggle="modal" data-bs-target="#choose_login" class="custom-btn2-outline py-2 bg-transparent px-4">Start Hiring </button>
                        </div>
                        <div>
                            <img src="<?=base_url('assets/newAssets/img/')?>twosec1.png" alt="" class="w-100">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="twocardbg position-relative">
                    <h3>Your Next Job Awaits.</h3>
                    <div class="d-flex justify-content-between">
                        <div>
                            <p>Personalized Job Recommendations Based on <br> Your Profile</p>
                            <button data-bs-toggle="modal" data-bs-target="#choose_login" class="custom-btn2-outline py-2 bg-transparent px-4">Find Jobs Now</button>
                        </div>
                        <div>
                            <img src="<?=base_url('assets/newAssets/img/')?>twosec2.png" alt="" class="w-100">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="custom-col-10 mx-auto row popular-category py-5 mob-hide">
            <h1 class="text-center featuredRoletitle mb-5">
                Popular Job Categories
            </h1>
            <div class="row mx-0">
                <div class="col-md-4">
                    <div class="cardd card1 position-relative">
                        <img src="<?=base_url('assets/newAssets/img/')?>Innergrid.png" class="position-absolute"
                         style="right: 0; bottom: 0;width: 200px; border-radius: 0 0 28px;" alt="">
                        <div class="imgdiv1 mb-4">
                            <img src="<?=base_url('assets/newAssets/img/')?>popular1.png" alt="">
                        </div>
                        <h4>Design & Development</h4>
                        <p class="fs-6 mb-5">Shape the future with innovative <br>designs and cutting-edge <br>development skills.</p>
                        <h6 class="mb-4 fs-5">5000+ Jobs available </h6>
                        <button onclick="window.location.href='jobs';" class="border-0 py-2 px-5 fs-5 text-white" style="border-radius: 14px;background: #8A83FF;">View All</button>
                    </div>
                </div>
                <div class="col-md-8 row">
                    <div class="col-md-6">
                        <div class="cardd card2 mb-4" style="background: #FFE6E0;">
                            <div class="d-flex justify-content-between mb-3">
                                <div class="imgdiv2">
                                    <img src="<?=base_url('assets/newAssets/img/')?>popular2.png" alt="">
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                                    <rect x="18.0439" y="35.6289" width="25" height="25" rx="12.5" transform="rotate(-134.502 18.0439 35.6289)" fill="white"/>
                                    <path d="M22.4487 13.7722L22.3827 21.3778L21.0161 21.28L21.1547 15.0439L14.6902 14.8445L14.8433 13.7061L22.4487 13.7722Z" fill="#FFB29F"/>
                                    <path d="M14.4003 22.5898L13.4919 21.6656L21.3483 13.9447L22.2567 14.8689L14.4003 22.5898Z" fill="#FFB29F"/>
                                </svg>
                            </div>
                            <h5>Marketing & Sales</h5>
                            <p class="small">
                                Drive growth and revenue through impactful campaigns and strategic sales
                            </p>
                            <h6>12000+ Jobs available </h6>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="cardd card3 mb-4" style="background: #FFF8E0;">
                            <div class="d-flex justify-content-between mb-3">
                                <div class="imgdiv3">
                                <img src="<?=base_url('assets/newAssets/img/')?>popular3.png" alt="">
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                                    <rect x="18.0439" y="35.6289" width="25" height="25" rx="12.5" transform="rotate(-134.502 18.0439 35.6289)" fill="white"/>
                                    <path d="M22.4487 13.7722L22.3827 21.3778L21.0161 21.28L21.1547 15.0439L14.6902 14.8445L14.8433 13.7061L22.4487 13.7722Z" fill="#FFB29F"/>
                                    <path d="M14.4003 22.5898L13.4919 21.6656L21.3483 13.9447L22.2567 14.8689L14.4003 22.5898Z" fill="#FFB29F"/>
                                </svg>
                            </div>
                            <h5>Finance & Accounting</h5>
                            <p class="small">
                                Manage the numbers that drive businesses to success.
                            </p>
                            <h6>12000+ Jobs available </h6>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="cardd card4" style="background: #E6FFF5;">
                            <div class="d-flex justify-content-between mb-3">
                                <div class="imgdiv4">
                                <img src="<?=base_url('assets/newAssets/img/')?>popular4.png" alt="">
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                                    <rect x="18.0439" y="35.6289" width="25" height="25" rx="12.5" transform="rotate(-134.502 18.0439 35.6289)" fill="white"/>
                                    <path d="M22.4487 13.7722L22.3827 21.3778L21.0161 21.28L21.1547 15.0439L14.6902 14.8445L14.8433 13.7061L22.4487 13.7722Z" fill="#FFB29F"/>
                                    <path d="M14.4003 22.5898L13.4919 21.6656L21.3483 13.9447L22.2567 14.8689L14.4003 22.5898Z" fill="#FFB29F"/>
                                </svg>
                            </div>
                            <h5>Healthcare</h5>
                            <p class="small">
                                Join the compassionate professionals who make lives healthier every day.
                            </p>
                            <h6>12000+ Jobs available </h6>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="cardd card5" style="background: #E0F7FF;">
                            <div class="d-flex justify-content-between mb-3">
                                <div class="imgdiv5">
                                <img src="<?=base_url('assets/newAssets/img/')?>popular5.png" alt="">
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                                    <rect x="18.0439" y="35.6289" width="25" height="25" rx="12.5" transform="rotate(-134.502 18.0439 35.6289)" fill="white"/>
                                    <path d="M22.4487 13.7722L22.3827 21.3778L21.0161 21.28L21.1547 15.0439L14.6902 14.8445L14.8433 13.7061L22.4487 13.7722Z" fill="#FFB29F"/>
                                    <path d="M14.4003 22.5898L13.4919 21.6656L21.3483 13.9447L22.2567 14.8689L14.4003 22.5898Z" fill="#FFB29F"/>
                                </svg>
                            </div>
                            <h5>IT & Networking</h5>
                            <p class="small">
                                Power the digital world with strong infrastructure and secure systems.
                            </p>
                            <h6>12000+ Jobs available </h6>
                        </div>
                    </div>
                </div>
                <div class="text-center mt-5 pt-4">
                    <button onclick="window.location.href='jobs';" class="custom-btn2-outline py-2 px-5 bg-transparent">Discover More
                        <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 35 35" fill="none">
                            <rect x="13.0214" y="34.5195" width="25" height="25" rx="12.5" transform="rotate(-120.325 13.0214 34.5195)" fill="#007BFF"/>
                            <path d="M22.6449 14.4088L20.7182 21.7666L19.4172 21.337L21.0789 15.3248L14.8601 13.5482L15.2874 12.482L22.6449 14.4088Z" fill="white"/>
                            <path d="M12.6821 20.9863L12.0278 19.8677L21.5359 14.3062L22.1902 15.4248L12.6821 20.9863Z" fill="white"/>
                        </svg>
                    </button>
                </div>
            </div>
        </section>

        <section class="custom-col-10 mx-auto row mx-0 popular-category py-3 mob-show">
            <h4 class="text-center featuredRoletitle mb-4">
                Popular Job Categories
            </h4>
            <div class="popularjobCrads">
                <div class="cardd card1 position-relative">
                   <div class="imgdiv1 mb-4">
                      <img src="<?=base_url('assets/newAssets/img/')?>popular1.png" alt="">
                   </div>
                   <h4>Design & Development</h4>
                   <p class="fs-6 mb-5">Shape the future with innovative designs and cutting-edge development skills.</p>
                   <h6 class="mb-4 fs-5">5000+ Jobs available </h6>
                   <button onclick="window.location.href='jobs';" class="border-0 py-2 px-5 fs-5 text-white" style="border-radius: 14px;background: #8A83FF;">View All</button>
                </div>
                <div class="cardd card2" style="background: #FFE6E0;">
                   <div class="d-flex justify-content-between mb-3">
                      <div class="imgdiv2">
                         <img src="<?=base_url('assets/newAssets/img/')?>popular2.png" alt="">
                      </div>
                      <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                         <rect x="18.0439" y="35.6289" width="25" height="25" rx="12.5" transform="rotate(-134.502 18.0439 35.6289)" fill="white"/>
                         <path d="M22.4487 13.7722L22.3827 21.3778L21.0161 21.28L21.1547 15.0439L14.6902 14.8445L14.8433 13.7061L22.4487 13.7722Z" fill="#FFB29F"/>
                         <path d="M14.4003 22.5898L13.4919 21.6656L21.3483 13.9447L22.2567 14.8689L14.4003 22.5898Z" fill="#FFB29F"/>
                      </svg>
                   </div>
                   <h5>Marketing & Sales</h5>
                   <p class="fs-6 mb-5">
                      Drive growth and revenue through impactful<br> campaigns and strategic sales
                   </p>
                   <h6 class="mb-4 fs-5">12000+ Jobs available </h6>
                   <button onclick="window.location.href='jobs';" class="border-0 py-2 px-5 fs-5 text-white" style="border-radius: 14px;background: #FF977E;">View All</button>
                </div>
                <div class="cardd card3" style="background: #FFF8E0;">
                   <div class="d-flex justify-content-between mb-3">
                      <div class="imgdiv3">
                         <img src="<?=base_url('assets/newAssets/img/')?>popular3.png" alt="">
                      </div>
                      <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                         <rect x="18.0439" y="35.6289" width="25" height="25" rx="12.5" transform="rotate(-134.502 18.0439 35.6289)" fill="white"/>
                         <path d="M22.4487 13.7722L22.3827 21.3778L21.0161 21.28L21.1547 15.0439L14.6902 14.8445L14.8433 13.7061L22.4487 13.7722Z" fill="#FFB29F"/>
                         <path d="M14.4003 22.5898L13.4919 21.6656L21.3483 13.9447L22.2567 14.8689L14.4003 22.5898Z" fill="#FFB29F"/>
                      </svg>
                   </div>
                   <h5>Finance & Accounting</h5>
                   <p class="fs-6 mb-5">
                      Manage the numbers that drive businesses to success.
                   </p>
                   <h6 class="mb-4 fs-5">12000+ Jobs available </h6>
                   <button onclick="window.location.href='jobs';" class="border-0 py-2 px-5 fs-5 text-white" style="border-radius: 14px;background: #E4C457;">View All</button>
                </div>
                <div class="cardd card4" style="background: #E6FFF5;">
                   <div class="d-flex justify-content-between mb-3">
                      <div class="imgdiv4">
                         <img src="<?=base_url('assets/newAssets/img/')?>popular4.png" alt="">
                      </div>
                      <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                         <rect x="18.0439" y="35.6289" width="25" height="25" rx="12.5" transform="rotate(-134.502 18.0439 35.6289)" fill="white"/>
                         <path d="M22.4487 13.7722L22.3827 21.3778L21.0161 21.28L21.1547 15.0439L14.6902 14.8445L14.8433 13.7061L22.4487 13.7722Z" fill="#FFB29F"/>
                         <path d="M14.4003 22.5898L13.4919 21.6656L21.3483 13.9447L22.2567 14.8689L14.4003 22.5898Z" fill="#FFB29F"/>
                      </svg>
                   </div>
                   <h5>Healthcare</h5>
                   <p class="fs-6 mb-5">
                      Join the compassionate professionals who make lives healthier every day.
                   </p>
                   <h6 class="mb-4 fs-5">12000+ Jobs available </h6>
                   <button onclick="window.location.href='jobs';" class="border-0 py-2 px-5 fs-5 text-white" style="border-radius: 14px;background: #78EDBE;">View All</button>
                </div>
                <div class="cardd card5" style="background: #E0F7FF;">
                   <div class="d-flex justify-content-between mb-3">
                      <div class="imgdiv5">
                         <img src="<?=base_url('assets/newAssets/img/')?>popular5.png" alt="">
                      </div>
                      <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                         <rect x="18.0439" y="35.6289" width="25" height="25" rx="12.5" transform="rotate(-134.502 18.0439 35.6289)" fill="white"/>
                         <path d="M22.4487 13.7722L22.3827 21.3778L21.0161 21.28L21.1547 15.0439L14.6902 14.8445L14.8433 13.7061L22.4487 13.7722Z" fill="#FFB29F"/>
                         <path d="M14.4003 22.5898L13.4919 21.6656L21.3483 13.9447L22.2567 14.8689L14.4003 22.5898Z" fill="#FFB29F"/>
                      </svg>
                   </div>
                   <h5>IT & Networking</h5>
                   <p class="fs-6 mb-5">
                      Power the digital world with strong infrastructure and secure systems.
                   </p>
                   <div>
                    <h6 class="mb-4 fs-5">12000+ Jobs available </h6>
                    <button onclick="window.location.href='jobs';" class="border-0 py-2 px-5 fs-5 text-white" style="border-radius: 14px;background: #6FCDEE;">View All</button>
                   </div>
                </div>
                
             </div>
             <div class="text-center pt-4">
                <button onclick="window.location.href='jobs';" class="custom-btn2-outline bg-transparent">
                   Discover More
                   <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 35 35" fill="none">
                      <rect x="13.0214" y="34.5195" width="25" height="25" rx="12.5" transform="rotate(-120.325 13.0214 34.5195)" fill="#007BFF"/>
                      <path d="M22.6449 14.4088L20.7182 21.7666L19.4172 21.337L21.0789 15.3248L14.8601 13.5482L15.2874 12.482L22.6449 14.4088Z" fill="white"/>
                      <path d="M12.6821 20.9863L12.0278 19.8677L21.5359 14.3062L22.1902 15.4248L12.6821 20.9863Z" fill="white"/>
                   </svg>
                </button>
             </div>
        </section>
		 <?php }?>
        <section class="featuredRole py-5 mob-hide1" style="background: #F6FBFF;">
            <h1 class="text-center featuredRoletitle">Featured Job’s</h1>
			
			<!-- Swiper Container -->
        <div class="swiper mySwiper">
            <div class="swiper-wrapper">
                <!-- Job Card 1 -->
               <?php foreach($feature as $row){?>
                        <div class="cardmd my-auto swiper-slide">
                            <div class="JobCard">
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex gap-3">
                                        <div>
                                            <img src="<?=$row->company_logo?>" alt="" class="companylogo">
                                        </div>
                                        <div class="my-auto">
                                            <p class=" mb-1"><?=$row->company_name?></p>
                                            <h6 class="fw-normal mb-0"><?=$row->salary_min;?><?=$row->salary_type;?> - <?=$row->salary_max;?><?=$row->salary_type;?></h6>
                                        </div>
                                    </div>
                                </div>
                                <h6 class="mt-2"><b><?=ucfirst($row->job_title)?></b></h6>
                                <p class="mb-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                        <path d="M4.02372 3.51401C4.84425 2.70989 5.94896 2.26208 7.0978 2.26788C8.24665 2.27368 9.34678 2.73263 10.1591 3.54499C10.9715 4.35736 11.4305 5.45749 11.4363 6.60633C11.4421 7.75518 10.9942 8.85989 10.1901 9.68042L7.88543 11.9851C7.67894 12.1916 7.39891 12.3075 7.10693 12.3075C6.81494 12.3075 6.53491 12.1916 6.32842 11.9851L4.02372 9.68042C3.20606 8.86267 2.7467 7.75362 2.7467 6.59721C2.7467 5.4408 3.20606 4.33175 4.02372 3.51401Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"></path>
                                        <path d="M7.10692 8.24875C8.01914 8.24875 8.75864 7.50925 8.75864 6.59703C8.75864 5.68481 8.01914 4.94531 7.10692 4.94531C6.1947 4.94531 5.4552 5.68481 5.4552 6.59703C5.4552 7.50925 6.1947 8.24875 7.10692 8.24875Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                      <?=$row->job_city;?> • <?=$row->employment_type;?>
                                </p>
                                <div class="d-flex gap-2 mb-3" style="overflow: hidden;">
                                    <div class="job-cat-btn"><?=$row->job_type;?></div>
                                    <div class="job-cat-btn"><?=$row->employment_type;?></div>
                                    <div class="job-cat-btn"><?=$row->job_experience;?></div>
                                    <div class="job-cat-btn"><?=$row->no_of_opening;?> Vacancy</div>
									<?php 
									$skills = explode(',', $row->job_skills);

									foreach ($skills as $skill) {
										$skill = trim($skill);

										if (!empty($skill)) {
									?>
									<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
									<?php
										}
									}
									?>
                                </div>
                                <p class="mb-2">Matching Skills</p>
                                <div class="skilset">
                                    <span class="skill"><svg xmlns="http://www.w3.org/2000/svg" width="19" height="18" viewBox="0 0 19 18" fill="none">
                                    <path d="M9.56348 1.5C5.43848 1.5 2.06348 4.875 2.06348 9C2.06348 13.125 5.43848 16.5 9.56348 16.5C13.6885 16.5 17.0635 13.125 17.0635 9C17.0635 4.875 13.6885 1.5 9.56348 1.5ZM9.56348 15C6.25598 15 3.56348 12.3075 3.56348 9C3.56348 5.6925 6.25598 3 9.56348 3C12.871 3 15.5635 5.6925 15.5635 9C15.5635 12.3075 12.871 15 9.56348 15ZM13.006 5.685L8.06348 10.6275L6.12098 8.6925L5.06348 9.75L8.06348 12.75L14.0635 6.75L13.006 5.685Z" fill="#007BFF"></path>
                                    </svg> Experience</span>
                                    <span class="skill"><svg xmlns="http://www.w3.org/2000/svg" width="19" height="18" viewBox="0 0 19 18" fill="none">
                                    <path d="M9.56348 1.5C5.43848 1.5 2.06348 4.875 2.06348 9C2.06348 13.125 5.43848 16.5 9.56348 16.5C13.6885 16.5 17.0635 13.125 17.0635 9C17.0635 4.875 13.6885 1.5 9.56348 1.5ZM9.56348 15C6.25598 15 3.56348 12.3075 3.56348 9C3.56348 5.6925 6.25598 3 9.56348 3C12.871 3 15.5635 5.6925 15.5635 9C15.5635 12.3075 12.871 15 9.56348 15ZM13.006 5.685L8.06348 10.6275L6.12098 8.6925L5.06348 9.75L8.06348 12.75L14.0635 6.75L13.006 5.685Z" fill="#007BFF"></path>
                                    </svg> Figma</span>
                                    <span class="skill"><svg xmlns="http://www.w3.org/2000/svg" width="19" height="18" viewBox="0 0 19 18" fill="none">
                                    <path d="M9.56348 1.5C5.43848 1.5 2.06348 4.875 2.06348 9C2.06348 13.125 5.43848 16.5 9.56348 16.5C13.6885 16.5 17.0635 13.125 17.0635 9C17.0635 4.875 13.6885 1.5 9.56348 1.5ZM9.56348 15C6.25598 15 3.56348 12.3075 3.56348 9C3.56348 5.6925 6.25598 3 9.56348 3C12.871 3 15.5635 5.6925 15.5635 9C15.5635 12.3075 12.871 15 9.56348 15ZM13.006 5.685L8.06348 10.6275L6.12098 8.6925L5.06348 9.75L8.06348 12.75L14.0635 6.75L13.006 5.685Z" fill="#007BFF"></path>
                                    </svg> Remote</span>
                                    <span class="skill"><svg xmlns="http://www.w3.org/2000/svg" width="19" height="18" viewBox="0 0 19 18" fill="none">
                                    <path d="M9.56348 1.5C5.43848 1.5 2.06348 4.875 2.06348 9C2.06348 13.125 5.43848 16.5 9.56348 16.5C13.6885 16.5 17.0635 13.125 17.0635 9C17.0635 4.875 13.6885 1.5 9.56348 1.5ZM9.56348 15C6.25598 15 3.56348 12.3075 3.56348 9C3.56348 5.6925 6.25598 3 9.56348 3C12.871 3 15.5635 5.6925 15.5635 9C15.5635 12.3075 12.871 15 9.56348 15ZM13.006 5.685L8.06348 10.6275L6.12098 8.6925L5.06348 9.75L8.06348 12.75L14.0635 6.75L13.006 5.685Z" fill="#007BFF"></path>
                                    </svg> Frame</span>
                                    <span class="skill"><svg xmlns="http://www.w3.org/2000/svg" width="19" height="18" viewBox="0 0 19 18" fill="none">
                                        <path d="M9.56348 1.5C5.43848 1.5 2.06348 4.875 2.06348 9C2.06348 13.125 5.43848 16.5 9.56348 16.5C13.6885 16.5 17.0635 13.125 17.0635 9C17.0635 4.875 13.6885 1.5 9.56348 1.5ZM9.56348 15C6.25598 15 3.56348 12.3075 3.56348 9C3.56348 5.6925 6.25598 3 9.56348 3C12.871 3 15.5635 5.6925 15.5635 9C15.5635 12.3075 12.871 15 9.56348 15ZM13.006 5.685L8.06348 10.6275L6.12098 8.6925L5.06348 9.75L8.06348 12.75L14.0635 6.75L13.006 5.685Z" fill="#007BFF"></path>
                                        </svg> UIdesign</span>
                                </div>
                                <div class="d-flex gap-3 mt-4 justify-content-center">
                                    
											<?php
				
				
		if(!empty($emp_id)){
			$career=$this->db->where(['created_by'=> $emp_id])->get('career_preferences')->num_rows();
			$save=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('emp_save_job')->num_rows();
			$apply=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp')->num_rows();
			if($save>0){
				$saveText='Saved';
			}else{
				$saveText='Save';
			}
			
			if($apply>0){
				$applyText='Applied';
				$type='disabled';
			}else{
				$applyText='Apply Now';
				$type='';
			}
			if($career==0){
				$buttons='
				<a class="custom-btn2 py-1 p-2" style="font-size: 0.7rem;" href="'.base_url('career-preference').'">
				<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
					<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				  </svg>Apply Now</a>
				  <a class="custom-btn2-outline py-1 p-2" style="font-size: 0.8rem;" href="'.base_url('career-preference').'">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
						<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
					  </svg>
					Save</a>
				';
			}else{
				$buttons='
				<button class="custom-btn2 py-1 p-2 applyBtn'.$row->job_id.'" '.$type.' style="font-size: 0.7rem;" onclick="applyJob('.$row->job_id.')" >
					<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
						<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					  </svg><span>'.$applyText.'</span> <i class="fa fa-spinner fa-spin applySpin'.$row->job_id.'" style="display:none;"></i></button>
			  <button class="custom-btn2-outline py-1 p-2 saveBtn'.$row->job_id.'" style="font-size: 0.8rem;" onclick="saveJob('.$row->job_id.')">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
					<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
				  </svg>
				<span>'.$saveText.'</span> <i class="fa fa-spinner fa-spin saveSpin'.$row->job_id.'" style="display:none;"></i></button>
				';
			}
		}else{
			$buttons='
			<button class="custom-btn2 py-1 p-2" style="font-size: 0.7rem;"  onclick="showLoginModal(\'employee\');">
			<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
				<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
			  </svg>Apply Now</button>
			  <button class="custom-btn2-outline py-1 p-2" style="font-size: 0.8rem;" onclick="showLoginModal(\'employee\');">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
					<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
				  </svg>
				Save</button>
			';
		}
		echo $buttons;
				?>
                                </div>
                            </div>
                        </div> 
						<?php } ?>
               
            </div>

            <!-- Navigation Buttons -->
           <!-- <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>-->

        </div>
          
            <div class="text-center pb-3">
                <button onclick="window.location.href='explore-jobs';" class="custom-btn3">Explore More</button>
            </div>
        </section>

        <div class="interview_div mob-hide">
            <div class="container py-5 mx-auto">
                <div class="row">
                    <div class="col-md-6">
                        <h3 style="font-weight: 500;" class="mb-3">Interview Smarter, Not Harder!</h3>
                        <h3>Simplified on <span class="spanborderbottom">Job Karo</span></h3>
                        <p class="mt-3 fs-6">
                            Whether you're hiring or getting hired, our voice and video call feature makes connecting effortless and professional.
                        </p>
                        <button onclick="window.location.href='jobs';" class="custom-btn3 fs-5 mt-3">Get started Now</button>
                    </div>
                    <div class="col-md-5 text-end">
                        <img src="<?=base_url('assets/newAssets/img/')?>interve1.png" alt="" style="width: 300px;">
                    </div>
                </div>
            </div>
        </div>

        <div class="interview_div mob-show">
            <div class="container py-5 mx-auto">
                <div class="row">
                    <div class="col-md-6 text-center">
                        <h3 style="font-weight: 500;" class="mb-3">Interview Smarter, Not Harder!</h3>
                        <h3>Simplified on <span class="spanborderbottom">Job Karo</span></h3>
                        <p class="mt-3 fs-6">
                            Whether you're hiring or getting hired, our voice and video call feature makes connecting effortless and professional.
                        </p>
                    </div>
                    <div class="col-md-5 text-center">
                        <img src="<?=base_url('assets/newAssets/img/')?>interviewmob.png" alt="" style="width: 90%;">
                        <button class="custom-btn3 fs-5 mt-3">Get started Now</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="home-download-sec p-3 py-4">
            <div class="custom-col-10 text-center mx-auto">
                <h1 class="down-title1 mb-3">
                    Find <span style="color: #007BFF;">Jobs</span> or <span style="color: #007BFF;">Hire</span> Talent Anytime, Anywhere</h1>
                <h2 class="down-title2 mb-2">Get the <span style="color: #007BFF;">
                    JobKaro App!</span></h2>
                <p class="mb-1">Download our app for real-time job updates and seamless applications. The<br> easiest way to search and apply on the go</p>
                <button onclick="window.location.href='https://play.google.com/store/apps/details?id=com.wlhiring.teamhiring';" class="custom-btn2 px-4 py-2 fs-6 mt-4 fw-normal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                    <path d="M12.5635 15.575C12.4301 15.575 12.3051 15.5543 12.1885 15.513C12.0718 15.4717 11.9635 15.4007 11.8635 15.3L8.26348 11.7C8.06348 11.5 7.96748 11.2667 7.97548 11C7.98348 10.7333 8.07948 10.5 8.26348 10.3C8.46348 10.1 8.70114 9.996 8.97648 9.988C9.25181 9.98 9.48914 10.0757 9.68848 10.275L11.5635 12.15V5C11.5635 4.71667 11.6595 4.47934 11.8515 4.288C12.0435 4.09667 12.2808 4.00067 12.5635 4C12.8461 3.99934 13.0838 4.09534 13.2765 4.288C13.4691 4.48067 13.5648 4.718 13.5635 5V12.15L15.4385 10.275C15.6385 10.075 15.8761 9.979 16.1515 9.987C16.4268 9.995 16.6641 10.0993 16.8635 10.3C17.0468 10.5 17.1428 10.7333 17.1515 11C17.1601 11.2667 17.0641 11.5 16.8635 11.7L13.2635 15.3C13.1635 15.4 13.0551 15.471 12.9385 15.513C12.8218 15.555 12.6968 15.5757 12.5635 15.575ZM6.56348 20C6.01348 20 5.54281 19.8043 5.15148 19.413C4.76014 19.0217 4.56414 18.5507 4.56348 18V16C4.56348 15.7167 4.65948 15.4793 4.85148 15.288C5.04348 15.0967 5.28081 15.0007 5.56348 15C5.84614 14.9993 6.08381 15.0953 6.27648 15.288C6.46914 15.4807 6.56481 15.718 6.56348 16V18H18.5635V16C18.5635 15.7167 18.6595 15.4793 18.8515 15.288C19.0435 15.0967 19.2808 15.0007 19.5635 15C19.8461 14.9993 20.0838 15.0953 20.2765 15.288C20.4691 15.4807 20.5648 15.718 20.5635 16V18C20.5635 18.55 20.3678 19.021 19.9765 19.413C19.5851 19.805 19.1141 20.0007 18.5635 20H6.56348Z" fill="white"/>
                  </svg> Download Now</button>
            </div>
        </div>

        <div class="real-story mob-hide" id="real-story">
            <div class="container-fluid px-0">
                <h1 class="text-center mb-5">Real Stories, Real Success</h1>

                <div class="slider-container">
                    <!-- First Row -->
                    <div class="slider-row mb-4">
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Ankit Verma,</h3>
                        <h3 class="name">Data Analyst <span>at ThinkDight</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Riya Kapoor,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                    </div>
                
                    <!-- Second Row -->
                    <div class="slider-row reverse">
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                    </div>
                  </div>


            </div>
        </div>

        <div class="mob-show py-3 px-2 mt-4">
            <h3 class="text-center mb-4">Real Stories, Real Success</h3>
            <div class="d-flex gap-2">
                <div>
                    <p>Encountered a minor issue, but the customer support team was quick to respond a sol.... <span class="fw-bold">More</span></p>
                    <p class="mb-1 fw-bold">Pankaj Tyagi </p>
                    <p class="mb-0 small">UX Designer </p>
                </div>
                <div>
                    <img src="<?=base_url('assets/newAssets/img/')?>realstory.png" alt="" style="width: 200px;">
                </div>
            </div>
        </div>

        <div class="custom-col-10 mx-auto mb-5">
            <div class="faq-container">
                <div class="row mx-auto">
                    <div class="text-center">
                        <h2 class="mb-5 mostaskedtitlemargin">Most Asked Questions</h2>
                    </div>
                    <div class="col-lg-4 mob-hide">
                        <div class="qa-section text-center border-bottom-0 border-start-0">
                            <img src="<?=base_url('assets/newAssets/img/')?>faq.png" class="mb-4" alt="" style="width: 200px;">
                            <h4 class="mb-3">Have Any Query?</h4>
                            <p>Feel free to reach out! Our team is here to assist you and provide the support you need. We’re just a message away and excited to help!</p>
                            <a href="<?=base_url('contact-us');?>" class="custom-btn2-outline py-2 px-4 bg-transparent">Contact Us</a>
                        </div>
                    </div>
                    <div class="col-lg-8">
                        <div class="accordion custom-accordion" id="faqAccordion">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-button p-0 collapsed shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                        How do I manage job listings?
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body p-0">
                                        You can manage your active job listings by visiting the "My Jobs" section. From there, you can edit, update, or delete job posts as needed. You can also view the number of applicants for each job.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed p-0 shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        Can I search for candidates?
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body p-0">
                                        Yes, you can search for candidates using our advanced search feature, filtering by skills, experience, and location.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-button collapsed p-0 shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                        What are the pricing plans for job postings?
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body p-0">
                                        We offer flexible pricing plans depending on the number of job postings you need. Contact our sales team for more details.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingFour">
                                    <button class="accordion-button collapsed p-0 shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                        Can I view candidate profiles before contacting them?
                                    </button>
                                </h2>
                                <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body p-0">
                                        Yes, you can preview candidate profiles, including their resume, before initiating contact.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingFive">
                                    <button class="accordion-button collapsed p-0 shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                        How do I receive job notifications?
                                    </button>
                                </h2>
                                <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body p-0">
                                        You will receive job notifications via email or directly through the app, depending on your preferences.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingSix">
                                    <button class="accordion-button collapsed p-0 shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                        Can I apply for multiple jobs at the same time?
                                    </button>
                                </h2>
                                <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body p-0">
                                        Yes, our platform allows you to apply for multiple jobs simultaneously with a single click.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php require'footer.php';?>

    </section>

    
<?php require'js.php';?>
 <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

    <script>
     var swiper = new Swiper(".mySwiper", {
    slidesPerView: 3,
    spaceBetween: 40,
    loop: true,
    centeredSlides: true, 
    // navigation: {
        // nextEl: ".swiper-button-next",
        // prevEl: ".swiper-button-prev",
    // },
	autoplay: {
        delay: 2000, 
        disableOnInteraction: false,
    },
    pagination: false, 
    breakpoints: {
        1024: { slidesPerView: 3 },
        768: { slidesPerView: 2 },
        480: { slidesPerView: 1 },
		 0: { slidesPerView: 1 }
    }, 
    on: {
        slideChangeTransitionEnd: function () {
            let slides = document.querySelectorAll(".swiper-slide");
            let currentSlidesPerView = swiper.params.slidesPerView;

            slides.forEach(slide => {
                slide.style.transform = "scale(1)";
                slide.style.zIndex = "1";
                slide.style.transition = "transform 0.4s ease-in-out, z-index 0.4s ease-in-out";
                slide.style.opacity = "0.8";
            });

            if (currentSlidesPerView === 3) {
                let activeSlide = document.querySelector(".swiper-slide-active");
                if (activeSlide) {
                    activeSlide.style.transform = "scale(1.13)";
                    activeSlide.style.zIndex = "10";
                    activeSlide.style.opacity = "1";
                }
            }
        }
    }
});


    </script>
  </body>
</html>




