<!doctype html>
<html lang="en">
  <?php require'css.php';?>
  <body>
    <section class="position-relative">
        <div class="py-2 home-section saved-sec">
            <div class="custom-col-10 mx-auto">
                <?php require'header.php';?>

            </div>
            <div class="mob-hide">
                <div class="custom-col-10 mx-auto mt-5 pt-4">
                    <div class="row justify-content-between mb-5 savedjobnav">
                        <div class="col-same">
                            <a href="<?=base_url('saved-job')?>" class="text-decoration-none">
                                <div class="appliedJob">
                                    <div class="d-flex justify-content-between">
                                        <div class="d-flex gap-4">
                                            <h2 class="my-auto"><?=$saved;?></h2>
                                            <div>
                                                <h3>Saved Jobs</h3>
                                                <p class="mb-0">Review and apply to the jobs you’ve saved. </p>
                                            </div>
                                        </div>
                                        <div class="my-auto">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="44" height="44" viewBox="0 0 44 44" fill="none">
                                            <g clip-path="url(#clip0_1635_6166)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M20.5288 15.3584C20.8648 15.0225 21.3204 14.8338 21.7955 14.8338C22.2706 14.8338 22.7262 15.0225 23.0622 15.3584L33.1977 25.4938C33.3688 25.6591 33.5053 25.8568 33.5992 26.0754C33.6931 26.294 33.7425 26.5291 33.7446 26.767C33.7466 27.0049 33.7013 27.2408 33.6112 27.461C33.5211 27.6812 33.3881 27.8812 33.2199 28.0495C33.0516 28.2177 32.8516 28.3507 32.6314 28.4408C32.4112 28.5309 32.1753 28.5762 31.9374 28.5742C31.6995 28.5721 31.4644 28.5227 31.2458 28.4288C31.0272 28.3349 30.8295 28.1984 30.6642 28.0272L21.7955 19.1585L12.9267 28.0272C12.5888 28.3536 12.1362 28.5342 11.6665 28.5301C11.1967 28.526 10.7473 28.3376 10.4151 28.0054C10.083 27.6732 9.89453 27.2239 9.89045 26.7541C9.88636 26.2843 10.067 25.8317 10.3933 25.4938L20.5288 15.3584Z" fill="#2F6DAF"/>
                                            </g>
                                            <defs>
                                            <clipPath id="clip0_1635_6166">
                                                <rect width="43" height="43" fill="white" transform="matrix(-1 0 0 -1 43.2954 43.5)"/>
                                            </clipPath>
                                            </defs>
                                        </svg>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-same">
                            <a href="<?=base_url('applied-job')?>" class="text-decoration-none">
                                <div class="savedJob">
                                    <div class="d-flex justify-content-between">
                                        <div class="d-flex gap-4">
                                            <h2 style="font-weight: 500;" class="my-auto"><?=$applied;?></h2>
                                            <div>
                                                <h3 class="fw-normal">Applied Jobs</h3>
                                                <p class="mb-0">Stay informed about your job applications</p>
                                            </div>
                                        </div>
                                        <div class="my-auto">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="44" height="44" viewBox="0 0 44 44" fill="none">
                                                <g clip-path="url(#clip0_1635_6255)">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M23.562 28.6416C23.2261 28.9775 22.7704 29.1662 22.2953 29.1662C21.8202 29.1662 21.3646 28.9775 21.0286 28.6416L10.8932 18.5062C10.722 18.3409 10.5856 18.1432 10.4917 17.9246C10.3978 17.706 10.3483 17.4709 10.3463 17.233C10.3442 16.9951 10.3895 16.7592 10.4796 16.539C10.5697 16.3188 10.7027 16.1188 10.871 15.9505C11.0392 15.7823 11.2392 15.6493 11.4594 15.5592C11.6796 15.4691 11.9155 15.4238 12.1534 15.4258C12.3913 15.4279 12.6264 15.4773 12.845 15.5712C13.0636 15.6651 13.2613 15.8016 13.4266 15.9728L22.2953 24.8415L31.1641 15.9728C31.502 15.6464 31.9546 15.4658 32.4243 15.4699C32.8941 15.474 33.3435 15.6624 33.6757 15.9946C34.0079 16.3268 34.1963 16.7761 34.2004 17.2459C34.2045 17.7157 34.0239 18.1683 33.6975 18.5062L23.562 28.6416Z" fill="#2F6DAF"/>
                                                </g>
                                                <defs>
                                                <clipPath id="clip0_1635_6255">
                                                    <rect width="43" height="43" fill="white" transform="translate(0.79541 0.5)"/>
                                                </clipPath>
                                                </defs>
                                            </svg>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-small">
                            <a href="<?=base_url('lookback')?>" class="text-decoration-none">
                                <div class="lookbackJob text-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="39" height="38" viewBox="0 0 39 38" fill="none">
                                        <path d="M19.5002 7.59928C21.7923 7.59921 24.0313 8.29011 25.9248 9.58181C27.8184 10.8735 29.2785 12.706 30.1148 14.8402C30.951 16.9743 31.1245 19.311 30.6126 21.5453C30.1007 23.7795 28.9271 25.8076 27.2451 27.3648C25.5631 28.9219 23.4508 29.9359 21.1837 30.2743C18.9167 30.6128 16.6003 30.2599 14.5368 29.2619C12.4734 28.2639 10.7587 26.667 9.61655 24.6796C8.47442 22.6923 7.9579 20.4068 8.1344 18.1215C8.14388 17.997 8.12874 17.8718 8.08986 17.7532C8.05097 17.6345 7.98909 17.5247 7.90776 17.4299C7.82642 17.3352 7.72722 17.2574 7.61582 17.201C7.50442 17.1446 7.383 17.1107 7.2585 17.1012C7.13399 17.0917 7.00883 17.1068 6.89018 17.1457C6.77152 17.1846 6.66168 17.2465 6.56694 17.3278C6.4722 17.4092 6.3944 17.5084 6.33799 17.6198C6.28159 17.7312 6.24768 17.8526 6.2382 17.9771C6.21286 18.3165 6.2002 18.6573 6.2002 18.9993C6.2002 22.0821 7.27117 25.0692 9.22995 27.4498C11.1887 29.8304 13.9137 31.4566 16.9388 32.0503C19.9639 32.644 23.1014 32.1683 25.8146 30.7047C28.5279 29.2411 30.6484 26.8803 31.8136 24.0262C32.9788 21.172 33.1163 18.0017 32.2026 15.0573C31.2889 12.113 29.3807 9.57753 26.8044 7.88446C24.2281 6.19139 21.1436 5.4459 18.0784 5.77545C15.0132 6.10501 12.1577 7.48914 10.0002 9.69118V6.64928C10.0002 6.39732 9.90011 6.15569 9.72195 5.97753C9.54379 5.79937 9.30215 5.69928 9.0502 5.69928C8.79824 5.69928 8.5566 5.79937 8.37844 5.97753C8.20028 6.15569 8.1002 6.39732 8.1002 6.64928V12.3493C8.1002 12.6012 8.20028 12.8429 8.37844 13.021C8.5566 13.1992 8.79824 13.2993 9.0502 13.2993H14.7502C15.0022 13.2993 15.2438 13.1992 15.4219 13.021C15.6001 12.8429 15.7002 12.6012 15.7002 12.3493C15.7002 12.0973 15.6001 11.8557 15.4219 11.6775C15.2438 11.4994 15.0022 11.3993 14.7502 11.3993H11.0034C12.0711 10.2019 13.3803 9.24424 14.8448 8.58928C16.3093 7.93432 17.8959 7.59692 19.5002 7.59928ZM19.5002 12.3493C19.5002 12.0973 19.4001 11.8557 19.2219 11.6775C19.0438 11.4994 18.8022 11.3993 18.5502 11.3993C18.2982 11.3993 18.0566 11.4994 17.8784 11.6775C17.7003 11.8557 17.6002 12.0973 17.6002 12.3493V19.9493C17.6002 20.2012 17.7003 20.4429 17.8784 20.621C18.0566 20.7992 18.2982 20.8993 18.5502 20.8993H24.2502C24.5022 20.8993 24.7438 20.7992 24.9219 20.621C25.1001 20.4429 25.2002 20.2012 25.2002 19.9493C25.2002 19.6973 25.1001 19.4557 24.9219 19.2775C24.7438 19.0994 24.5022 18.9993 24.2502 18.9993H19.5002V12.3493Z" fill="#004B9B" fill-opacity="0.7"/>
                                    </svg>
                                    <h6 class="fw-normal mb-0">Look<br> Back</h6>
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="d-flex justify-content-between">
                                <h4 class="my-auto">Your <span class="savedjobspn">Applied Jobs</span></h4>
                                <!--<div class="d-flex gap-2">
                                    <div class="job-filter-btn dropdown">
                                        <div data-bs-toggle="dropdown">
                                            <span class="span1">Sort By:</span>
                                            <span class="span2">Latest </span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="7" viewBox="0 0 16 7" fill="none">
                                                <g clip-path="url(#clip0_371_1587)">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.99999 4.9741L12.714 0.633728L13.6567 1.50168L8.47132 6.27603C8.3463 6.3911 8.17677 6.45575 7.99999 6.45575C7.82321 6.45575 7.65367 6.3911 7.52866 6.27603L2.34332 1.50168L3.28599 0.633728L7.99999 4.9741Z" fill="#202020"></path>
                                                </g>
                                                <defs>
                                                <clipPath id="clip0_371_1587">
                                                    <rect width="7" height="16" fill="white" transform="matrix(0 -1 1 0 0 7)"></rect>
                                                </clipPath>
                                                </defs>
                                            </svg>
                                        </div>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="#">option 1</a></li>
                                            <li><a class="dropdown-item" href="#">option 2</a></li>
                                            <li><a class="dropdown-item" href="#">option 3</a></li>
                                        </ul>
                                    </div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="39" height="42" viewBox="0 0 39 42" fill="none">
                                        <rect x="0.79541" y="0.955078" width="37" height="40" rx="6.5" stroke="#CACACA"/>
                                        <path d="M16.3286 12.3203C15.5631 12.3199 14.8163 12.5569 14.1912 12.9988C13.566 13.4406 13.0933 14.0654 12.8381 14.7871H8.92822V17.2539H12.8381C13.0929 17.9761 13.5655 18.6015 14.1906 19.0438C14.8158 19.4862 15.5628 19.7237 16.3286 19.7237C17.0944 19.7237 17.8414 19.4862 18.4666 19.0438C19.0917 18.6015 19.5643 17.9761 19.8191 17.2539H28.6626V14.7871H19.8191C19.564 14.0654 19.0912 13.4406 18.4661 12.9988C17.8409 12.5569 17.0941 12.3199 16.3286 12.3203ZM15.0952 16.0205C15.0952 15.6934 15.2252 15.3797 15.4565 15.1484C15.6878 14.9171 16.0015 14.7871 16.3286 14.7871C16.6557 14.7871 16.9694 14.9171 17.2008 15.1484C17.4321 15.3797 17.562 15.6934 17.562 16.0205C17.562 16.3476 17.4321 16.6613 17.2008 16.8927C16.9694 17.124 16.6557 17.2539 16.3286 17.2539C16.0015 17.2539 15.6878 17.124 15.4565 16.8927C15.2252 16.6613 15.0952 16.3476 15.0952 16.0205ZM21.2622 22.1875C20.4967 22.1871 19.7499 22.4241 19.1248 22.8659C18.4996 23.3077 18.0269 23.9326 17.7717 24.6543H8.92822V27.1211H17.7717C18.0265 27.8433 18.4991 28.4687 19.1242 28.911C19.7494 29.3534 20.4964 29.5909 21.2622 29.5909C22.028 29.5909 22.775 29.3534 23.4002 28.911C24.0253 28.4687 24.4979 27.8433 24.7527 27.1211H28.6626V24.6543H24.7527C24.4976 23.9326 24.0248 23.3077 23.3997 22.8659C22.7745 22.4241 22.0277 22.1871 21.2622 22.1875ZM20.0288 25.8877C20.0288 25.5606 20.1588 25.2469 20.3901 25.0156C20.6214 24.7842 20.9351 24.6543 21.2622 24.6543C21.5893 24.6543 21.903 24.7842 22.1344 25.0156C22.3657 25.2469 22.4956 25.5606 22.4956 25.8877C22.4956 26.2148 22.3657 26.5285 22.1344 26.7598C21.903 26.9911 21.5893 27.1211 21.2622 27.1211C20.9351 27.1211 20.6214 26.9911 20.3901 26.7598C20.1588 26.5285 20.0288 26.2148 20.0288 25.8877Z" fill="#202020" fill-opacity="0.8"/>
                                    </svg>
                                </div>-->
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
						<?php if(empty($data)){?>
						<div class="custom-col-10 mx-auto bg-white border12 p-4 pt-5 text-center mb-5">
                    <h3>No job applications yet</h3>
                    <p>Once you apply, your applications will be shown here for tracking and updates.</p>
                    <img src="<?php echo base_url(); ?>assets/newAssets/img/applied.png" class="nodataImg">    
                </div>
						<?php }else{ $i=1; foreach($data as $row){?>
						<?php if ($i==1): ?>
							<script>
								document.addEventListener("DOMContentLoaded", function () {
									jobDetails(<?= $row->job_id ?>);
								});
							</script>
						<?php endif; ?>
                    <div class="job-card mb-3 <?php if($i==1){ echo 'active';} $i++;?>" data-id="<?=$row->job_id;?>" onclick="jobDetails(<?=$row->job_id ?>)">
                        <div class="d-flex justify-content-between w-100">
                            <div class="d-flex gap-3">
                                <img src="<?=$row->company_logo?>" alt="" class="companylogo">
                                <div>
                                    <p class="mb-1 t1"><?=$row->job_title;?></p>
                                    <p class="mb-1 t2"><?=$row->salary_min;?><?=$row->salary_type;?> - <?=$row->salary_max;?><?=$row->salary_type;?> <span></span></p>
                                </div>
                            </div>
                            <div>
                                <div class="higherch-btn">
                                    <!--<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                        <path d="M8.00002 1.33331L0.666687 14H15.3334M8.00002 3.99998L13 12.6666H3.00002M9.33335 9.33331H8.33335L9.33335 7.33331H6.66669V9.99998H7.33335V12L9.33335 9.33331Z" fill="#EB663D" fill-opacity="0.8"/>
                                    </svg>-->
                                    <span><?=$row->tag;?></span>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex gap-3 mt-2">
                            <div class="company-name-div">
                                <p><?=$row->company_name?></p>
                            </div>
                            <div class="skilsDiv">
                                <div class="d-flex gap-2">
                                    <div class="job-cat-btn"><?=$row->job_type;?></div>
                                    <div class="job-cat-btn"><?=$row->employment_type;?></div>
                                    <div class="job-cat-btn"><?=$row->job_experience;?></div>
                                    <div class="job-cat-btn"><?=$row->no_of_opening;?> Vacancy</div>
									<?php 
									$skills = explode(',', $row->job_skills);

									foreach ($skills as $skill) {
										$skill = trim($skill);

										if (!empty($skill)) {
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>

                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between pt-3 border-dashed mt-3">
                            <div class="d-flex gap-2 post-text">
                                <span class="my-auto"><?=$row->job_created_at;?></span>
                                <span class="post-text-dot my-auto"></span>
                                <span class="my-auto"><?=$row->total_applicant;?> Applicants </span>
                            </div>
                            <div class="locafont d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                    <path d="M3.52366 3.01413C4.34419 2.21001 5.4489 1.7622 6.59774 1.768C7.74658 1.7738 8.84672 2.23275 9.65908 3.04512C10.4714 3.85748 10.9304 4.95762 10.9362 6.10646C10.942 7.2553 10.4942 8.36001 9.69007 9.18054L7.38537 11.4852C7.17888 11.6917 6.89885 11.8076 6.60686 11.8076C6.31488 11.8076 6.03485 11.6917 5.82835 11.4852L3.52366 9.18054C2.70599 8.3628 2.24664 7.25374 2.24664 6.09733C2.24664 4.94093 2.70599 3.83187 3.52366 3.01413Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"/>
                                    <path d="M6.60686 7.74881C7.51908 7.74881 8.25858 7.00931 8.25858 6.09709C8.25858 5.18487 7.51908 4.44537 6.60686 4.44537C5.69464 4.44537 4.95514 5.18487 4.95514 6.09709C4.95514 7.00931 5.69464 7.74881 6.60686 7.74881Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <span class="my-auto"><?=$row->job_city;?></span>
                                <span class="dott my-auto"></span>
                                <span class="my-auto"><?=$row->employment_type;?></span>
                            </div>
                        </div>
                    </div>
						<?php } } ?>
                        </div>
                        <div class="col-md-6" id="jobDetailsData">
                           
                        </div>
                    </div>
                </div>
                
                <!--no data div-->
                
                <!--no data div Ends here-->

               <!-- <div class="d-flex gap-5 justify-content-center py-5">
                    <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="326" height="3" viewBox="0 0 326 3" fill="none">
                        <path d="M1.5 1.20312L324.5 1.2031" stroke="url(#paint0_linear_1645_7214)" stroke-width="2" stroke-linecap="round"/>
                        <defs>
                        <linearGradient id="paint0_linear_1645_7214" x1="324.5" y1="2.20309" x2="1.5" y2="2.20312" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#007BFF"/>
                            <stop offset="1" stop-color="#F6FBFF" stop-opacity="0"/>
                        </linearGradient>
                        </defs>
                    </svg>
                    <h2 class="my-auto fw-normal" style="color: rgba(32, 32, 32, 0.70);">
                        You've reached the end of your saved jobs!</h2>
                    <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="326" height="3" viewBox="0 0 326 3" fill="none">
                        <path d="M324.5 1.20312L1.50001 1.2031" stroke="url(#paint0_linear_1645_7217)" stroke-width="2" stroke-linecap="round"/>
                        <defs>
                        <linearGradient id="paint0_linear_1645_7217" x1="1.5" y1="2.20309" x2="324.5" y2="2.20312" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#007BFF"/>
                            <stop offset="1" stop-color="#F6FBFF" stop-opacity="0"/>
                        </linearGradient>
                        </defs>
                    </svg>
                </div>

                <div class="d-flex gap-4 justify-content-center pt-2 pb-5">
                    <div class="my-auto">
                        <h4 class="spanborderbottom fw-normal">Ready to revisit your applications?</h4>
                        <p style="color: rgba(0, 123, 255, 0.80);" class="small mb-0">Head over to your applied jobs now and track your progress!</p>
                    </div>
                    <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="44" height="44" viewBox="0 0 44 44" fill="none">
                        <g clip-path="url(#clip0_1647_7225)">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M28.6416 20.3349C28.9775 20.6709 29.1662 21.1266 29.1662 21.6016C29.1662 22.0767 28.9775 22.5324 28.6416 22.8683L18.5062 33.0038C18.3409 33.1749 18.1432 33.3114 17.9246 33.4053C17.706 33.4992 17.4709 33.5486 17.233 33.5507C16.9951 33.5528 16.7592 33.5074 16.539 33.4174C16.3188 33.3273 16.1188 33.1942 15.9505 33.026C15.7823 32.8578 15.6493 32.6577 15.5592 32.4376C15.4691 32.2174 15.4238 31.9814 15.4258 31.7435C15.4279 31.5056 15.4773 31.2705 15.5712 31.052C15.6651 30.8334 15.8016 30.6357 15.9728 30.4704L24.8415 21.6016L15.9728 12.7329C15.6464 12.395 15.4658 11.9424 15.4699 11.4726C15.474 11.0029 15.6624 10.5535 15.9946 10.2213C16.3268 9.88911 16.7761 9.70068 17.2459 9.6966C17.7157 9.69252 18.1683 9.87311 18.5062 10.1995L28.6416 20.3349Z" fill="#007BFF"/>
                        </g>
                        <defs>
                        <clipPath id="clip0_1647_7225">
                            <rect width="43" height="43" fill="white" transform="matrix(0 -1 1 0 0.5 43.1016)"/>
                        </clipPath>
                        </defs>
                    </svg>
                </div>-->

                <?php require'footer.php';?>

            </div>

            

        </div>


    </section>

    <section class="position-relative mob-show" style="background: #F6FBFF;">
        
        
        <!-- Nav tabs -->
        <ul class="nav nav-tabs customNavTab mt-4 justify-content-center" role="tablist">
            <li class="nav-item">
            <a class="nav-link" href="<?=base_url('saved-job');?>">Saved jobs</a>
            </li>
            <li class="nav-item">
            <a class="nav-link active" href="<?=base_url('applied-job');?>">Applied jobs</a>
            </li>
            <li class="nav-item">
            <a class="nav-link" href="<?=base_url('lookback');?>">Look back</a>
            </li>
        </ul>
        <br>
                <div class="d-flex justify-content-between">
                    <p class="fs-5" style="font-weight: 500;">Applied jobs (<?=$applied;?>)</p>
                    <!--<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <path d="M6 1C5.37935 0.999675 4.77387 1.19186 4.26702 1.55006C3.76016 1.90826 3.37688 2.41484 3.17 3H0V5H3.17C3.3766 5.58553 3.75974 6.09257 4.2666 6.45121C4.77346 6.80985 5.37909 7.00245 6 7.00245C6.62091 7.00245 7.22654 6.80985 7.7334 6.45121C8.24026 6.09257 8.6234 5.58553 8.83 5H16V3H8.83C8.62312 2.41484 8.23984 1.90826 7.73298 1.55006C7.22613 1.19186 6.62065 0.999675 6 1ZM5 4C5 3.73478 5.10536 3.48043 5.29289 3.29289C5.48043 3.10536 5.73478 3 6 3C6.26522 3 6.51957 3.10536 6.70711 3.29289C6.89464 3.48043 7 3.73478 7 4C7 4.26522 6.89464 4.51957 6.70711 4.70711C6.51957 4.89464 6.26522 5 6 5C5.73478 5 5.48043 4.89464 5.29289 4.70711C5.10536 4.51957 5 4.26522 5 4ZM10 9C9.37935 8.99967 8.77387 9.19186 8.26702 9.55006C7.76016 9.90826 7.37688 10.4148 7.17 11H0V13H7.17C7.3766 13.5855 7.75974 14.0926 8.2666 14.4512C8.77346 14.8099 9.37909 15.0025 10 15.0025C10.6209 15.0025 11.2265 14.8099 11.7334 14.4512C12.2403 14.0926 12.6234 13.5855 12.83 13H16V11H12.83C12.6231 10.4148 12.2398 9.90826 11.733 9.55006C11.2261 9.19186 10.6207 8.99967 10 9ZM9 12C9 11.7348 9.10536 11.4804 9.29289 11.2929C9.48043 11.1054 9.73478 11 10 11C10.2652 11 10.5196 11.1054 10.7071 11.2929C10.8946 11.4804 11 11.7348 11 12C11 12.2652 10.8946 12.5196 10.7071 12.7071C10.5196 12.8946 10.2652 13 10 13C9.73478 13 9.48043 12.8946 9.29289 12.7071C9.10536 12.5196 9 12.2652 9 12Z" fill="#202020"/>
                    </svg>-->
                </div>
				<?php if(empty($data)){ ?>
				<div class="custom-col-10 mx-auto bg-white border12 p-4 pt-5 text-center mb-5">
                    <h3>No job applications yet</h3>
                    <p>Once you apply, your applications will be shown here for tracking and updates.</p>
                    <img src="<?php echo base_url(); ?>assets/newAssets/img/applied.png" class="nodataImg">    
                </div>
                <?php }else{ foreach($data as $row){
				
				
		if(!empty($emp_id)){
			$career=$this->db->where(['created_by'=> $emp_id])->get('career_preferences')->num_rows();
			$save=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('emp_save_job')->num_rows();
			$apply=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp')->num_rows();
			if($save>0){
				$saveClass='custom-btn2-outline';
				$saveText='Saved';
			}else{
				$saveClass='custom-btn2-outline';
				$saveText='Save';
			}
			
			if($apply>0){
				$applyClass='custom-btn2';
				$applyText='Applied';
				$type='disabled';
			}else{
				$applyClass='custom-btn2';
				$applyText='Apply Now';
				$type='';
			}
			if($career==0){
				$buttons='
				<a class="w-100 custom-btn2" href="'.base_url('career-preference').'">
				<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
					<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				  </svg>Apply Now</a>
				  <a class="w-100 custom-btn2-outline" href="'.base_url('career-preference').'">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
						<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
					  </svg>
					Save</a>
				';
			}else{
				$buttons='
				<button class="'.$applyClass.' w-100 applyBtn'.$row->job_id.'" '.$type.' onclick="applyJob('.$row->job_id.')" >
					<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
						<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					  </svg><span>'.$applyText.'</span> <i class="fa fa-spinner fa-spin applySpin'.$row->job_id.'" style="display:none;"></i></button>
			  <button class="w-100 '.$saveClass.' saveBtn'.$row->job_id.'" onclick="saveJob('.$row->job_id.')">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
					<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
				  </svg>
				<span>'.$saveText.'</span> <i class="fa fa-spinner fa-spin saveSpin'.$row->job_id.'" style="display:none;"></i></button>
				';
			}
		}else{
			$buttons='
			<button class="custom-btn2 w-100" data-bs-toggle="modal" data-bs-target="#login">
			<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
				<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
			  </svg>Apply Now</button>
			  <button class="custom-btn2-outline w-100" data-bs-toggle="modal" data-bs-target="#login">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
					<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
				  </svg>
				Save</button>
			';
		}
				?>
                <div class="job-card-mob mb-3 position-relative">
                    <div class="higherch-btn position-absolute end-0 top-0">
                       <!-- <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M8.00002 1.33331L0.666687 14H15.3334M8.00002 3.99998L13 12.6666H3.00002M9.33335 9.33331H8.33335L9.33335 7.33331H6.66669V9.99998H7.33335V12L9.33335 9.33331Z" fill="#EB663D" fill-opacity="0.8"></path>
                        </svg>-->
                        <span><?=$row->tag;?></span>
                    </div>
                    <div class="cardcenter mb-2">
                        <div class="JobCard">
                            <div class="d-flex justify-content-between">
                                <div class="d-flex gap-3">
                                   
									<a href="<?=base_url('job-details?job_id='.$row->job_id);?>"> <div class="d-flex gap-3">
                                <div>
                                    <img src="<?=$row->company_logo;?>" alt="" class="companylogo">
                                </div>
                                <div class="my-auto">
                                    <p class="small mb-1"><?=$row->company_name?></p>
                                    <h5 class="fw-normal mb-0"><?=$row->salary_min;?><?=$row->salary_type;?> - <?=$row->salary_max;?><?=$row->salary_type;?></h5>
                                </div>
                            </div></a>
                                </div>
                                <div class="my-auto">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                        <g clip-path="url(#clip0_2056_4574)">
                                          <path fill-rule="evenodd" clip-rule="evenodd" d="M16.574 13.4427C16.7615 13.2552 16.8668 13.0009 16.8668 12.7357C16.8668 12.4705 16.7615 12.2162 16.574 12.0287L10.917 6.37169C10.8248 6.27618 10.7145 6.2 10.5924 6.14759C10.4704 6.09518 10.3392 6.0676 10.2064 6.06644C10.0737 6.06529 9.94198 6.09059 9.81909 6.14087C9.69619 6.19115 9.58454 6.26541 9.49065 6.3593C9.39675 6.45319 9.3225 6.56484 9.27222 6.68774C9.22194 6.81064 9.19664 6.94232 9.19779 7.0751C9.19895 7.20788 9.22653 7.33909 9.27894 7.4611C9.33135 7.5831 9.40753 7.69345 9.50304 7.78569L14.453 12.7357L9.50304 17.6857C9.32088 17.8743 9.22009 18.1269 9.22237 18.3891C9.22465 18.6513 9.32982 18.9021 9.51522 19.0875C9.70063 19.2729 9.95144 19.3781 10.2136 19.3804C10.4758 19.3826 10.7284 19.2819 10.917 19.0997L16.574 13.4427Z" fill="#007BFF"></path>
                                        </g>
                                        <defs>
                                          <clipPath id="clip0_2056_4574">
                                            <rect width="24" height="24" fill="white" transform="matrix(0 1 1 0 0.867188 0.734375)"></rect>
                                          </clipPath>
                                        </defs>
                                      </svg>
                                </div>
                            </div>
                            <h5 class="mt-3"><?=$row->job_title;?></h5>
                            <p class="small">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                    <path d="M4.02372 3.51401C4.84425 2.70989 5.94896 2.26208 7.0978 2.26788C8.24665 2.27368 9.34678 2.73263 10.1591 3.54499C10.9715 4.35736 11.4305 5.45749 11.4363 6.60633C11.4421 7.75518 10.9942 8.85989 10.1901 9.68042L7.88543 11.9851C7.67894 12.1916 7.39891 12.3075 7.10693 12.3075C6.81494 12.3075 6.53491 12.1916 6.32842 11.9851L4.02372 9.68042C3.20606 8.86267 2.7467 7.75362 2.7467 6.59721C2.7467 5.4408 3.20606 4.33175 4.02372 3.51401Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"></path>
                                    <path d="M7.10692 8.24875C8.01914 8.24875 8.75864 7.50925 8.75864 6.59703C8.75864 5.68481 8.01914 4.94531 7.10692 4.94531C6.1947 4.94531 5.4552 5.68481 5.4552 6.59703C5.4552 7.50925 6.1947 8.24875 7.10692 8.24875Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                                <?=$row->job_city;?> • <?=$row->employment_type;?>
                            </p>
                            <div class="d-flex gap-2 mb-3" style="overflow: auto;">
                                <div class="job-cat-btn"><?=$row->job_type;?></div>
                            <div class="job-cat-btn"><?=$row->employment_type;?></div>
                            <div class="job-cat-btn"><?=$row->job_experience;?></div>
                            <div class="job-cat-btn"><?=$row->no_of_opening;?> Vacancy</div>
                            <?php 
									$skills = explode(',', $row->job_skills);

									foreach ($skills as $skill) {
										$skill = trim($skill); // Remove extra spaces

										if (!empty($skill)) { // Check if it's not empty
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>
                            </div>
                            <div class="d-flex gap-2 mt-4 justify-content-between">
                               <?=$buttons?>
                            </div>
                        </div>
                    </div>
                </div>
				<?php }} ?>

    </section>
	<?php require'js.php';?>
	<script>

function jobDetails(id){
	document.querySelectorAll('.job-card').forEach(function(card) {
        card.classList.remove('active');
    });

    const clickedJobCard = document.querySelector(`.job-card[data-id="${id}"]`);
    clickedJobCard.classList.add('active');
   $.ajax({
		type: 'POST',
		url: "<?=base_url('getJobDetails');?>",
		data: { 'id': id,'type':'applied'},
		success: function(res) {
			$('#jobDetailsData').html(res);
		}, 
		error: function() {
			Toast.fire({
			  icon: 'error',
			  title: 'Something went wrong, please refresh the page.',
			});
			return false;
		}
	});
}

function ApplicantStatus(where_value,value,status){
	var url="<?=base_url('status');?>";
	var table = "applied_job_emp";
	var where_column = 'id';
	Swal.fire({
		title: 'Are you sure?',
		text: "Want to "+status+" this job!",
		icon: 'warning',
		showCancelButton: true,
		confirmButtonColor: '#3085d6',
		cancelButtonColor: '#d33',
		confirmButtonText: 'Yes'
		}).then((result) => {
		if (result.isConfirmed) {
			$.ajax({
				type: 'POST',
				url: url,
				data: { 'table': table,'status':value, 'where_column': where_column, 'where_value': where_value},
				success: function(response) {
					// alert(response);
					// console.log(response);
					var response = JSON.parse(response);
					if (response.res == 'success') {
						Toast.fire({
						  icon: 'success',
						  title: response.msg,
						})
					}else{
						Toast.fire({
						  icon: 'error',
						  title: response.msg,
						})
					}
					
					if (response.isRedirect == true) {
						if (response.wayOfRedirect == 'reload') {
							window.setTimeout(function() {
								window.location.reload();
							}, 800);
							} else if (response.wayOfRedirect == 'redirect') {
							window.setTimeout(function() {
								window.location.href = response.redirectLink;
							}, 800);
						}
					}
				},
				error: function() {
					Toast.fire({
					  icon: 'error',
					  title: 'something went wrong! Please check JS Code',
					})
				}
			});
		}
	})
}

</script>
  </body>
</html>