﻿<!DOCTYPE html>

<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
  <meta name="description" content="">
	<meta name="author" content="JobKaro">

	<title>Admin Login</title>

  <!-- color-modes:js -->
  <script src="<?=base_url();?>assets/adminAssets/js/color-modes.js"></script>
  <!-- endinject -->

	<!-- core:css -->
	<link rel="stylesheet" href="<?=base_url();?>assets/adminAssets/vendors/core/core.css">
	<!-- endinject -->

	<!-- Plugin css for this page -->
	<!-- End plugin css for this page -->

	<!-- inject:css -->
	<link rel="stylesheet" href="<?=base_url();?>assets/adminAssets/fonts/feather-font/css/iconfont.css">
	<!-- endinject -->

  <!-- Layout styles -->  
	<link rel="stylesheet" href="<?=base_url();?>assets/adminAssets/css/demo1/style.css">
  <!-- End layout styles -->

  <link rel="shortcut icon" href="<?=base_url();?>assets/adminAssets/images/favicon.png">

</head>
<body>
	<div class="main-wrapper">
		<div class="page-wrapper full-page">
			<div class="page-content container-xxl d-flex align-items-center justify-content-center">

				<div class="row w-100 mx-0 auth-page">
					<div class="col-md-10 col-lg-8 col-xl-6 mx-auto">
						<div class="card">
							<div class="row">
                <div class="col-md-4 pe-md-0">
                  <div class="auth-side-wrapper">

                  </div>
                </div>
                <div class="col-md-8 ps-md-0">
                  <div class="auth-form-wrapper px-4 py-5">
                    <a href="#" class="nobleui-logo d-block mb-2">Job<span>Karo</span></a>
                    <h5 class="text-secondary fw-normal mb-4">Welcome back! Log in to your account.</h5>
                    <form class="forms-sample" action="<?=base_url('admin/submit-login');?>" method="POST" id="loginForm">
                      <div class="mb-3">
                        <label for="userEmail" class="form-label">Email address</label>
                        <input type="text" class="form-control" id="userEmail" name="username" placeholder="Email">
                      </div>
                      <div class="mb-3">
                        <label for="userPassword" class="form-label">Password</label>
                        <input type="password" class="form-control" id="userPassword" name="password" autocomplete="current-password" placeholder="Password">
                      </div>
                      <div class="form-check mb-3">
                        <input type="checkbox" class="form-check-input" id="authCheck">
                        <label class="form-check-label" for="authCheck">
                          Remember me
                        </label>
                      </div>
                      <div>
                        <button type="submit" class="btn btn-primary me-2 mb-2 mb-md-0 btn-lg text-white" id="loginBtn">Login <i class="fa fa-spinner fa-spin" id="loginSpin" style="display:none;"></i></button>
                        
                      </div>
                    </form>
                  </div>
                </div>
              </div>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>

	<!-- core:js -->
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
	<script src="<?=base_url();?>assets/adminAssets/vendors/core/core.js"></script>
	<script src="<?=base_url();?>assets/adminAssets/vendors/feather-icons/feather.min.js"></script>

	
	<script src="https://cdnjs.cloudflare.com/ajax/libs/notify/0.4.2/notify.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
	<!-- Vendor JS -->
	<style>
.colored-toast.swal2-icon-success {
  background-color: #00ac46 !important;
}

.colored-toast.swal2-icon-error {
  background-color: #d32536 !important;
}

.colored-toast.swal2-icon-warning {
  background-color: #f8bb86 !important;
}

.colored-toast.swal2-icon-info {
  background-color: #3fc3ee !important;
}

.colored-toast.swal2-icon-question {
  background-color: #87adbd !important;
}

.colored-toast .swal2-title {
  color: white;
}

.colored-toast .swal2-close {
  color: white;
}

.colored-toast .swal2-html-container {
  color: white;
}
</style>
<script>
$( document ).ready(function() {
	$('form').parsley();
	 // test();
});
const Toast = Swal.mixin({  
	  toast: true,
	  position: 'top',
	  iconColor: 'white',
	  customClass: {
		popup: 'colored-toast',
	  },
	  showConfirmButton: false,
	  timer: 3000,
	  timerProgressBar: true,
	  didOpen: (toast) => {
		toast.addEventListener('mouseenter', Swal.stopTimer)
		toast.addEventListener('mouseleave', Swal.resumeTimer)
	  }
});
$("#loginForm").on('submit', function(e) {
	e.preventDefault();
	var data = new FormData(this);
	if ($(this).parsley().isValid()) {
		$.ajax({
			type: $(this).attr('method'),
			url: $(this).attr('action'),
			data: data,
			cache: false,
			contentType: false,
			processData: false,
			beforeSend: function() {
				$("#loginBtn").attr("disabled", true);
				$('#loginSpin').show();
			},
			success: function(response) {
				// console.log(response);
				// alert(response);
				$("#loginBtn").removeAttr("disabled");
				$('#loginSpin').hide();
				var response = JSON.parse(response);
				if (response.res == 'success') {
					 Toast.fire({
					  icon: 'success',
					  title: response.msg,
					})
					if (response.isRedirect == true) {
                        if (response.wayOfRedirect == 'reload') {
                            window.setTimeout(function() {
                                window.location.reload();
                            }, 2000);
                            } else if (response.wayOfRedirect == 'redirect') {
                            window.setTimeout(function() {
                                window.location.href = response.redirectLink;
                            }, 1000);
                        }
                    }
				}else{
					 Toast.fire({
					  icon: 'error',
					  title: response.msg,
					})
				}
			},
			error: function(err) {
				$("#loginBtn").removeAttr("disabled");
				$('#loginSpin').hide();
				Toast.fire({
				  icon: 'error',
				  title: 'Server side error',
				})
				console.log('Error:',err);
			}
		});
		} else {
			alert('cdn missing');
		return false;
	}
	
});

</script>
</body>
</html>