<!doctype html>
<html lang="en">
  <?php require'css.php';?>
  <body>
    <div style="background: #F6FBFF;">
        <section class="position-relative">
            <div class="head-section" style="background: linear-gradient(97deg, #AAD3FF -15.34%, #FFF 125.67%);">
                <div class="custom-col-10 mx-auto">
                    <?php require'header2.php';?>
                    <div class="mob-hide">
                        <div class="d-flex justify-content-between">
                            <div class="align-self-end">
                                <h5 class="title mt-5" style="color: #202020;">About Us</h5>
                                <h5>Your Trusted Platform for Hiring and Job Search</h5>
                                <p>Job Karo bridges the gap between talent and opportunity with a user-friendly,<br> efficient platform for recruiters and job seekers</p>
                            </div>
                            <div>
                                <img src="<?=base_url('assets/newAssets/img/')?>about-us.png" alt="" style="width: 300px;">
                            </div>
                            <div></div>
                        </div>
                    </div>
                    <div class="mob-show">
                        <div class="text-center">
                            <div>
                                <img src="<?=base_url('assets/newAssets/img/')?>about-us.png" alt="" style="width: 300px;">
                            </div>
                            <div class="align-self-end">
                                <h5 class="mt-5 fw-bold" style="color: #202020;">About Us</h5>
                                <p>Your Trusted Platform for Hiring and Job Search</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="row py-5 custom-col-10 mx-auto mob-hide">
            <div class="col-md-6 my-auto">
                <h5 class="text-center" style="line-height: 1.8;letter-spacing: 0.1rem;">
                    Welcome to Jobkaro.in, your trusted partner in navigating today’s competitive job market. At Jobkaro.in, we bridge the gap between talented job seekers and top employers across various industries, ensuring a seamless experience for both candidates and recruiters.
                </h5>
            </div>
            <div class="col-md-1"></div>
            <div class="col-md-5">
                <div class="d-flex gap-3">
                    <div>
                        <div class="text-center aboutUS-card">
                            <h4><svg xmlns="http://www.w3.org/2000/svg" width="32" height="20" viewBox="0 0 42 30" fill="none">
                                <path d="M8.64574 0.59094C8.93249 0.87805 9.09356 1.26724 9.09356 1.67302C9.09356 2.07881 8.93249 2.468 8.64574 2.75511C7.0342 4.3666 5.75585 6.27973 4.88369 8.38527C4.01153 10.4908 3.56263 12.7475 3.56263 15.0265C3.56263 17.3056 4.01153 19.5623 4.88369 21.6678C5.75585 23.7734 7.0342 25.6865 8.64574 27.298C8.92454 27.5869 9.0787 27.9738 9.07502 28.3753C9.07134 28.7768 8.91012 29.1607 8.62608 29.4445C8.34204 29.7283 7.95791 29.8891 7.55641 29.8924C7.15492 29.8957 6.7682 29.7412 6.47953 29.4621C-1.49318 21.4894 -1.49318 8.56365 6.47953 0.59094C6.76664 0.304187 7.15583 0.143121 7.56162 0.143121C7.9674 0.143121 8.35863 0.304187 8.64574 0.59094ZM35.3507 0.59094C43.3234 8.56365 43.3234 21.4915 35.3507 29.4642C35.0605 29.7347 34.6765 29.8819 34.2798 29.8749C33.8831 29.8679 33.5046 29.7072 33.2241 29.4267C32.9435 29.1461 32.7828 28.7676 32.7758 28.3709C32.7688 27.9742 32.9161 27.5903 33.1866 27.3C34.7984 25.6885 36.077 23.7752 36.9494 21.6695C37.8217 19.5638 38.2707 17.3068 38.2707 15.0276C38.2707 12.7483 37.8217 10.4914 36.9494 8.38562C36.077 6.2799 34.7984 4.36663 33.1866 2.75511C33.0361 2.61492 32.9155 2.44587 32.8318 2.25804C32.7481 2.07021 32.7031 1.86744 32.6994 1.66184C32.6958 1.45624 32.7336 1.25201 32.8107 1.06134C32.8877 0.870677 33.0023 0.697475 33.1477 0.55207C33.2931 0.406665 33.4663 0.292036 33.657 0.215023C33.8476 0.138009 34.0519 0.100187 34.2575 0.103815C34.4631 0.107443 34.6658 0.152445 34.8537 0.236137C35.0415 0.319829 35.2106 0.440496 35.3507 0.59094ZM14.4196 6.36477C14.7063 6.65188 14.8674 7.04107 14.8674 7.44686C14.8674 7.85264 14.7063 8.24183 14.4196 8.52894C13.5661 9.38212 12.8891 10.3951 12.4272 11.5099C11.9653 12.6248 11.7276 13.8198 11.7276 15.0265C11.7276 16.2333 11.9653 17.4283 12.4272 18.5431C12.8891 19.658 13.5661 20.671 14.4196 21.5241C14.6901 21.8144 14.8373 22.1984 14.8303 22.5951C14.8233 22.9917 14.6626 23.3702 14.3821 23.6508C14.1015 23.9313 13.723 24.092 13.3263 24.099C12.9296 24.106 12.5457 23.9588 12.2554 23.6883C9.95826 21.391 8.66775 18.2753 8.66775 15.0265C8.66775 11.7778 9.95826 8.66207 12.2554 6.36477C12.5425 6.07802 12.9317 5.91695 13.3375 5.91695C13.7433 5.91695 14.1325 6.07802 14.4196 6.36477ZM29.5789 6.36477C31.8761 8.66207 33.1666 11.7778 33.1666 15.0265C33.1666 18.2753 31.8761 21.391 29.5789 23.6883C29.4378 23.8346 29.2689 23.9514 29.0821 24.0317C28.8953 24.112 28.6944 24.1544 28.4911 24.1562C28.2878 24.1581 28.0861 24.1194 27.8979 24.0425C27.7097 23.9656 27.5386 23.852 27.3948 23.7083C27.251 23.5646 27.1372 23.3937 27.0601 23.2056C26.983 23.0174 26.9442 22.8158 26.9458 22.6125C26.9475 22.4092 26.9897 22.2082 27.0698 22.0213C27.15 21.8345 27.2666 21.6655 27.4127 21.5241C28.2659 20.671 28.9426 19.6582 29.4044 18.5435C29.8661 17.4288 30.1037 16.2341 30.1037 15.0276C30.1037 13.821 29.8661 12.6263 29.4044 11.5116C28.9426 10.3969 28.2659 9.38412 27.4127 8.53098C27.1423 8.24071 26.995 7.85678 27.002 7.46008C27.009 7.06338 27.1697 6.68489 27.4503 6.40434C27.7308 6.12379 28.1093 5.96308 28.506 5.95608C28.9027 5.94908 29.2866 6.09633 29.5769 6.36682M20.9162 11.9651C21.7284 11.9651 22.5073 12.2877 23.0817 12.8621C23.656 13.4364 23.9787 14.2153 23.9787 15.0276C23.9787 15.8398 23.656 16.6187 23.0817 17.1931C22.5073 17.7674 21.7284 18.0901 20.9162 18.0901C20.1039 18.0901 19.325 17.7674 18.7506 17.1931C18.1763 16.6187 17.8537 15.8398 17.8537 15.0276C17.8537 14.2153 18.1763 13.4364 18.7506 12.8621C19.325 12.2877 20.1039 11.9651 20.9162 11.9651Z" fill="black"></path>
                            </svg> 10k +</h4>
                            <h5>Active Jobs<br> Listing</h5>
                            <p class="mb-0" style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Explore a wide range of opportunities across industries and locations</p>
                        </div>
                    </div>
                    <div>
                        <div class="text-center aboutUS-card py-3 mb-3">
                            <h5>
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="20" viewBox="0 0 50 40" fill="none">
                                <path d="M48.4454 36.2904H45.1461V13.1953C45.5836 13.1953 46.0032 13.0215 46.3126 12.7121C46.622 12.4027 46.7958 11.9831 46.7958 11.5456C46.7958 11.1081 46.622 10.6885 46.3126 10.3791C46.0032 10.0698 45.5836 9.89597 45.1461 9.89597H35.2482V3.29735C35.6857 3.29735 36.1053 3.12355 36.4147 2.81418C36.724 2.50481 36.8979 2.08522 36.8979 1.6477C36.8979 1.21019 36.724 0.79059 36.4147 0.48122C36.1053 0.17185 35.6857 -0.00195312 35.2482 -0.00195312H5.55443C5.11691 -0.00195312 4.69732 0.17185 4.38795 0.48122C4.07858 0.79059 3.90478 1.21019 3.90478 1.6477C3.90478 2.08522 4.07858 2.50481 4.38795 2.81418C4.69732 3.12355 5.11691 3.29735 5.55443 3.29735V36.2904H2.25512C1.81761 36.2904 1.39801 36.4642 1.08864 36.7736C0.779271 37.083 0.605469 37.5026 0.605469 37.9401C0.605469 38.3776 0.779271 38.7972 1.08864 39.1066C1.39801 39.4159 1.81761 39.5897 2.25512 39.5897H48.4454C48.8829 39.5897 49.3025 39.4159 49.6119 39.1066C49.9213 38.7972 50.0951 38.3776 50.0951 37.9401C50.0951 37.5026 49.9213 37.083 49.6119 36.7736C49.3025 36.4642 48.8829 36.2904 48.4454 36.2904ZM41.8468 13.1953V36.2904H35.2482V13.1953H41.8468ZM8.85374 3.29735H31.9489V36.2904H26.9999V26.3925C26.9999 25.955 26.8261 25.5354 26.5168 25.226C26.2074 24.9167 25.7878 24.7429 25.3503 24.7429H15.4524C15.0148 24.7429 14.5952 24.9167 14.2859 25.226C13.9765 25.5354 13.8027 25.955 13.8027 26.3925V36.2904H8.85374V3.29735ZM23.7006 36.2904H17.102V28.0422H23.7006V36.2904ZM12.153 9.89597C12.153 9.45845 12.3268 9.03886 12.6362 8.72949C12.9456 8.42012 13.3652 8.24632 13.8027 8.24632H17.102C17.5395 8.24632 17.9591 8.42012 18.2685 8.72949C18.5779 9.03886 18.7517 9.45845 18.7517 9.89597C18.7517 10.3335 18.5779 10.7531 18.2685 11.0625C17.9591 11.3718 17.5395 11.5456 17.102 11.5456H13.8027C13.3652 11.5456 12.9456 11.3718 12.6362 11.0625C12.3268 10.7531 12.153 10.3335 12.153 9.89597ZM22.051 9.89597C22.051 9.45845 22.2248 9.03886 22.5341 8.72949C22.8435 8.42012 23.2631 8.24632 23.7006 8.24632H26.9999C27.4374 8.24632 27.857 8.42012 28.1664 8.72949C28.4758 9.03886 28.6496 9.45845 28.6496 9.89597C28.6496 10.3335 28.4758 10.7531 28.1664 11.0625C27.857 11.3718 27.4374 11.5456 26.9999 11.5456H23.7006C23.2631 11.5456 22.8435 11.3718 22.5341 11.0625C22.2248 10.7531 22.051 10.3335 22.051 9.89597ZM12.153 18.1442C12.153 17.7067 12.3268 17.2871 12.6362 16.9778C12.9456 16.6684 13.3652 16.4946 13.8027 16.4946H17.102C17.5395 16.4946 17.9591 16.6684 18.2685 16.9778C18.5779 17.2871 18.7517 17.7067 18.7517 18.1442C18.7517 18.5818 18.5779 19.0014 18.2685 19.3107C17.9591 19.6201 17.5395 19.7939 17.102 19.7939H13.8027C13.3652 19.7939 12.9456 19.6201 12.6362 19.3107C12.3268 19.0014 12.153 18.5818 12.153 18.1442ZM22.051 18.1442C22.051 17.7067 22.2248 17.2871 22.5341 16.9778C22.8435 16.6684 23.2631 16.4946 23.7006 16.4946H26.9999C27.4374 16.4946 27.857 16.6684 28.1664 16.9778C28.4758 17.2871 28.6496 17.7067 28.6496 18.1442C28.6496 18.5818 28.4758 19.0014 28.1664 19.3107C27.857 19.6201 27.4374 19.7939 26.9999 19.7939H23.7006C23.2631 19.7939 22.8435 19.6201 22.5341 19.3107C22.2248 19.0014 22.051 18.5818 22.051 18.1442Z" fill="black"></path>
                            </svg>
                                2,500+</h5>
                            <h6>Companies Hiring</h6>
                            <p class="mb-0" style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Top brands and start-ups trust Job Karo for their hiring needs.</p>
                        </div>
                        <div class="text-center aboutUS-card py-3">
                            <h5>
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="20" viewBox="0 0 49 36" fill="none">
                                    <path d="M51.7596 12.1228L46.4993 1.59595C46.3299 1.25678 46.0954 0.954292 45.8091 0.705759C45.5228 0.457226 45.1904 0.267514 44.8308 0.147456C44.4712 0.0273973 44.0915 -0.0206562 43.7133 0.00603785C43.3351 0.0327319 42.9659 0.133651 42.6267 0.303033L37.3561 2.93836L26.4003 0.0390891C26.1934 -0.0145229 25.9763 -0.0145229 25.7693 0.0390891L14.8136 2.93836L9.545 0.303033C9.20573 0.13333 8.83634 0.0321553 8.45795 0.00529371C8.07956 -0.0215679 7.69958 0.0264104 7.33974 0.146485C6.9799 0.26656 6.64725 0.456376 6.36081 0.705085C6.07437 0.953793 5.83976 1.25652 5.67038 1.59595L0.410045 12.1228C0.0678138 12.8075 0.0115468 13.6002 0.253617 14.3264C0.495688 15.0526 1.01627 15.6529 1.7009 15.9954L7.29941 18.7957L18.7666 26.9862C18.8909 27.0758 19.0307 27.1415 19.179 27.18L32.3762 30.4793C32.4767 30.5045 32.5799 30.517 32.6835 30.5164C33.0115 30.5162 33.326 30.3856 33.5578 30.1535L44.9631 18.7482L50.4688 15.9954C51.1534 15.6529 51.674 15.0526 51.9161 14.3264C52.1581 13.6002 52.1019 12.8075 51.7596 12.1228ZM40.8307 19.373L33.4485 13.459C33.2104 13.2685 32.9104 13.1726 32.6059 13.1897C32.3014 13.2068 32.014 13.3358 31.7988 13.5518C27.9531 17.4264 23.6537 16.9377 20.9132 15.185C20.8593 15.1517 20.8138 15.1066 20.7802 15.0529C20.7466 14.9993 20.7257 14.9386 20.7193 14.8757C20.712 14.8179 20.7177 14.7593 20.7359 14.704C20.7541 14.6487 20.7843 14.5982 20.8245 14.556L29.8852 5.77164H36.8674L42.7257 17.4883L40.8307 19.373ZM2.59996 13.5436C2.56586 13.4402 2.57401 13.3275 2.62264 13.2301L7.88504 2.70122C7.91962 2.63258 7.9727 2.57497 8.03829 2.53489C8.10387 2.49481 8.17935 2.47385 8.25621 2.47439C8.31991 2.47446 8.38272 2.48928 8.43973 2.51769L13.0196 4.80659L7.38602 16.082L2.80617 13.7931C2.75674 13.7675 2.713 13.7323 2.67756 13.6894C2.64212 13.6465 2.61573 13.5969 2.59996 13.5436ZM32.304 27.91L20.0141 24.8375L9.5182 17.3398L15.5353 5.30767L26.0848 2.51563L29.1367 3.32396C28.9033 3.36912 28.6882 3.48167 28.5181 3.64771L19.0944 12.793C18.7885 13.0988 18.5551 13.4694 18.4117 13.8775C18.2682 14.2856 18.2183 14.7207 18.2656 15.1507C18.3129 15.5807 18.4562 15.9945 18.685 16.3617C18.9138 16.7288 19.2221 17.0398 19.5873 17.2718C23.7568 19.936 28.815 19.4349 32.7433 16.0572L39.0759 21.134L32.304 27.91ZM49.5697 13.5436C49.5528 13.595 49.5258 13.6426 49.4904 13.6837C49.455 13.7247 49.4119 13.7584 49.3635 13.7828L44.7837 16.082L39.1501 4.80659L43.73 2.51769C43.7785 2.49334 43.8313 2.4788 43.8854 2.4749C43.9396 2.47101 43.994 2.47784 44.0454 2.49501C44.0969 2.51198 44.1445 2.53893 44.1856 2.57431C44.2266 2.60969 44.2603 2.65282 44.2846 2.70122L49.547 13.2301C49.5957 13.3275 49.6038 13.4402 49.5697 13.5436ZM26.4746 34.5272C26.3952 34.8454 26.1927 35.1191 25.9115 35.288C25.6304 35.457 25.2937 35.5075 24.9755 35.4283L16.3704 33.2775C16.222 33.2395 16.0821 33.1737 15.958 33.0837L10.5204 29.205C10.2532 29.0136 10.073 28.7239 10.0195 28.3996C9.96591 28.0753 10.0434 27.7431 10.2348 27.4759C10.4262 27.2088 10.7159 27.0286 11.0401 26.975C11.3644 26.9215 11.6966 26.9989 11.9638 27.1903L17.1994 30.9289L25.5735 33.0219C25.7315 33.0614 25.8802 33.1317 26.011 33.2288C26.1418 33.3259 26.2521 33.4479 26.3357 33.5878C26.4192 33.7276 26.4743 33.8826 26.4978 34.0438C26.5213 34.205 26.5127 34.3693 26.4725 34.5272H26.4746Z" fill="black"></path>
                                </svg>
                                100k+</h5>
                            <h6>Employees Hired</h6>
                            <p class="mb-0" style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Join thousands who’ve found their dream job through Job Karo.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row py-5 mx-0 mob-show">
            <div class="col-md-5">
                <div class="d-flex gap-3 mb-3">
                        <div class="text-center aboutUS-card py-3">
                            <h5>
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="20" viewBox="0 0 50 40" fill="none">
                                <path d="M48.4454 36.2904H45.1461V13.1953C45.5836 13.1953 46.0032 13.0215 46.3126 12.7121C46.622 12.4027 46.7958 11.9831 46.7958 11.5456C46.7958 11.1081 46.622 10.6885 46.3126 10.3791C46.0032 10.0698 45.5836 9.89597 45.1461 9.89597H35.2482V3.29735C35.6857 3.29735 36.1053 3.12355 36.4147 2.81418C36.724 2.50481 36.8979 2.08522 36.8979 1.6477C36.8979 1.21019 36.724 0.79059 36.4147 0.48122C36.1053 0.17185 35.6857 -0.00195312 35.2482 -0.00195312H5.55443C5.11691 -0.00195312 4.69732 0.17185 4.38795 0.48122C4.07858 0.79059 3.90478 1.21019 3.90478 1.6477C3.90478 2.08522 4.07858 2.50481 4.38795 2.81418C4.69732 3.12355 5.11691 3.29735 5.55443 3.29735V36.2904H2.25512C1.81761 36.2904 1.39801 36.4642 1.08864 36.7736C0.779271 37.083 0.605469 37.5026 0.605469 37.9401C0.605469 38.3776 0.779271 38.7972 1.08864 39.1066C1.39801 39.4159 1.81761 39.5897 2.25512 39.5897H48.4454C48.8829 39.5897 49.3025 39.4159 49.6119 39.1066C49.9213 38.7972 50.0951 38.3776 50.0951 37.9401C50.0951 37.5026 49.9213 37.083 49.6119 36.7736C49.3025 36.4642 48.8829 36.2904 48.4454 36.2904ZM41.8468 13.1953V36.2904H35.2482V13.1953H41.8468ZM8.85374 3.29735H31.9489V36.2904H26.9999V26.3925C26.9999 25.955 26.8261 25.5354 26.5168 25.226C26.2074 24.9167 25.7878 24.7429 25.3503 24.7429H15.4524C15.0148 24.7429 14.5952 24.9167 14.2859 25.226C13.9765 25.5354 13.8027 25.955 13.8027 26.3925V36.2904H8.85374V3.29735ZM23.7006 36.2904H17.102V28.0422H23.7006V36.2904ZM12.153 9.89597C12.153 9.45845 12.3268 9.03886 12.6362 8.72949C12.9456 8.42012 13.3652 8.24632 13.8027 8.24632H17.102C17.5395 8.24632 17.9591 8.42012 18.2685 8.72949C18.5779 9.03886 18.7517 9.45845 18.7517 9.89597C18.7517 10.3335 18.5779 10.7531 18.2685 11.0625C17.9591 11.3718 17.5395 11.5456 17.102 11.5456H13.8027C13.3652 11.5456 12.9456 11.3718 12.6362 11.0625C12.3268 10.7531 12.153 10.3335 12.153 9.89597ZM22.051 9.89597C22.051 9.45845 22.2248 9.03886 22.5341 8.72949C22.8435 8.42012 23.2631 8.24632 23.7006 8.24632H26.9999C27.4374 8.24632 27.857 8.42012 28.1664 8.72949C28.4758 9.03886 28.6496 9.45845 28.6496 9.89597C28.6496 10.3335 28.4758 10.7531 28.1664 11.0625C27.857 11.3718 27.4374 11.5456 26.9999 11.5456H23.7006C23.2631 11.5456 22.8435 11.3718 22.5341 11.0625C22.2248 10.7531 22.051 10.3335 22.051 9.89597ZM12.153 18.1442C12.153 17.7067 12.3268 17.2871 12.6362 16.9778C12.9456 16.6684 13.3652 16.4946 13.8027 16.4946H17.102C17.5395 16.4946 17.9591 16.6684 18.2685 16.9778C18.5779 17.2871 18.7517 17.7067 18.7517 18.1442C18.7517 18.5818 18.5779 19.0014 18.2685 19.3107C17.9591 19.6201 17.5395 19.7939 17.102 19.7939H13.8027C13.3652 19.7939 12.9456 19.6201 12.6362 19.3107C12.3268 19.0014 12.153 18.5818 12.153 18.1442ZM22.051 18.1442C22.051 17.7067 22.2248 17.2871 22.5341 16.9778C22.8435 16.6684 23.2631 16.4946 23.7006 16.4946H26.9999C27.4374 16.4946 27.857 16.6684 28.1664 16.9778C28.4758 17.2871 28.6496 17.7067 28.6496 18.1442C28.6496 18.5818 28.4758 19.0014 28.1664 19.3107C27.857 19.6201 27.4374 19.7939 26.9999 19.7939H23.7006C23.2631 19.7939 22.8435 19.6201 22.5341 19.3107C22.2248 19.0014 22.051 18.5818 22.051 18.1442Z" fill="black"></path>
                            </svg>
                                2,500+</h5>
                            <h6>Companies Hiring</h6>
                            <p class="mb-0" style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Top brands and start-ups trust Job Karo for their hiring needs.</p>
                        </div>
                        <div class="text-center aboutUS-card py-3">
                            <h5>
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="20" viewBox="0 0 49 36" fill="none">
                                    <path d="M51.7596 12.1228L46.4993 1.59595C46.3299 1.25678 46.0954 0.954292 45.8091 0.705759C45.5228 0.457226 45.1904 0.267514 44.8308 0.147456C44.4712 0.0273973 44.0915 -0.0206562 43.7133 0.00603785C43.3351 0.0327319 42.9659 0.133651 42.6267 0.303033L37.3561 2.93836L26.4003 0.0390891C26.1934 -0.0145229 25.9763 -0.0145229 25.7693 0.0390891L14.8136 2.93836L9.545 0.303033C9.20573 0.13333 8.83634 0.0321553 8.45795 0.00529371C8.07956 -0.0215679 7.69958 0.0264104 7.33974 0.146485C6.9799 0.26656 6.64725 0.456376 6.36081 0.705085C6.07437 0.953793 5.83976 1.25652 5.67038 1.59595L0.410045 12.1228C0.0678138 12.8075 0.0115468 13.6002 0.253617 14.3264C0.495688 15.0526 1.01627 15.6529 1.7009 15.9954L7.29941 18.7957L18.7666 26.9862C18.8909 27.0758 19.0307 27.1415 19.179 27.18L32.3762 30.4793C32.4767 30.5045 32.5799 30.517 32.6835 30.5164C33.0115 30.5162 33.326 30.3856 33.5578 30.1535L44.9631 18.7482L50.4688 15.9954C51.1534 15.6529 51.674 15.0526 51.9161 14.3264C52.1581 13.6002 52.1019 12.8075 51.7596 12.1228ZM40.8307 19.373L33.4485 13.459C33.2104 13.2685 32.9104 13.1726 32.6059 13.1897C32.3014 13.2068 32.014 13.3358 31.7988 13.5518C27.9531 17.4264 23.6537 16.9377 20.9132 15.185C20.8593 15.1517 20.8138 15.1066 20.7802 15.0529C20.7466 14.9993 20.7257 14.9386 20.7193 14.8757C20.712 14.8179 20.7177 14.7593 20.7359 14.704C20.7541 14.6487 20.7843 14.5982 20.8245 14.556L29.8852 5.77164H36.8674L42.7257 17.4883L40.8307 19.373ZM2.59996 13.5436C2.56586 13.4402 2.57401 13.3275 2.62264 13.2301L7.88504 2.70122C7.91962 2.63258 7.9727 2.57497 8.03829 2.53489C8.10387 2.49481 8.17935 2.47385 8.25621 2.47439C8.31991 2.47446 8.38272 2.48928 8.43973 2.51769L13.0196 4.80659L7.38602 16.082L2.80617 13.7931C2.75674 13.7675 2.713 13.7323 2.67756 13.6894C2.64212 13.6465 2.61573 13.5969 2.59996 13.5436ZM32.304 27.91L20.0141 24.8375L9.5182 17.3398L15.5353 5.30767L26.0848 2.51563L29.1367 3.32396C28.9033 3.36912 28.6882 3.48167 28.5181 3.64771L19.0944 12.793C18.7885 13.0988 18.5551 13.4694 18.4117 13.8775C18.2682 14.2856 18.2183 14.7207 18.2656 15.1507C18.3129 15.5807 18.4562 15.9945 18.685 16.3617C18.9138 16.7288 19.2221 17.0398 19.5873 17.2718C23.7568 19.936 28.815 19.4349 32.7433 16.0572L39.0759 21.134L32.304 27.91ZM49.5697 13.5436C49.5528 13.595 49.5258 13.6426 49.4904 13.6837C49.455 13.7247 49.4119 13.7584 49.3635 13.7828L44.7837 16.082L39.1501 4.80659L43.73 2.51769C43.7785 2.49334 43.8313 2.4788 43.8854 2.4749C43.9396 2.47101 43.994 2.47784 44.0454 2.49501C44.0969 2.51198 44.1445 2.53893 44.1856 2.57431C44.2266 2.60969 44.2603 2.65282 44.2846 2.70122L49.547 13.2301C49.5957 13.3275 49.6038 13.4402 49.5697 13.5436ZM26.4746 34.5272C26.3952 34.8454 26.1927 35.1191 25.9115 35.288C25.6304 35.457 25.2937 35.5075 24.9755 35.4283L16.3704 33.2775C16.222 33.2395 16.0821 33.1737 15.958 33.0837L10.5204 29.205C10.2532 29.0136 10.073 28.7239 10.0195 28.3996C9.96591 28.0753 10.0434 27.7431 10.2348 27.4759C10.4262 27.2088 10.7159 27.0286 11.0401 26.975C11.3644 26.9215 11.6966 26.9989 11.9638 27.1903L17.1994 30.9289L25.5735 33.0219C25.7315 33.0614 25.8802 33.1317 26.011 33.2288C26.1418 33.3259 26.2521 33.4479 26.3357 33.5878C26.4192 33.7276 26.4743 33.8826 26.4978 34.0438C26.5213 34.205 26.5127 34.3693 26.4725 34.5272H26.4746Z" fill="black"></path>
                                </svg>
                                100k+</h5>
                            <h6>Employees Hired</h6>
                            <p class="mb-0" style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Join thousands who’ve found their dream job through Job Karo.</p>
                        </div>
                </div>
                <div>
                    <div class="text-center aboutUS-card">
                        <h4>
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="20" viewBox="0 0 42 30" fill="none">
                            <path d="M8.64574 0.59094C8.93249 0.87805 9.09356 1.26724 9.09356 1.67302C9.09356 2.07881 8.93249 2.468 8.64574 2.75511C7.0342 4.3666 5.75585 6.27973 4.88369 8.38527C4.01153 10.4908 3.56263 12.7475 3.56263 15.0265C3.56263 17.3056 4.01153 19.5623 4.88369 21.6678C5.75585 23.7734 7.0342 25.6865 8.64574 27.298C8.92454 27.5869 9.0787 27.9738 9.07502 28.3753C9.07134 28.7768 8.91012 29.1607 8.62608 29.4445C8.34204 29.7283 7.95791 29.8891 7.55641 29.8924C7.15492 29.8957 6.7682 29.7412 6.47953 29.4621C-1.49318 21.4894 -1.49318 8.56365 6.47953 0.59094C6.76664 0.304187 7.15583 0.143121 7.56162 0.143121C7.9674 0.143121 8.35863 0.304187 8.64574 0.59094ZM35.3507 0.59094C43.3234 8.56365 43.3234 21.4915 35.3507 29.4642C35.0605 29.7347 34.6765 29.8819 34.2798 29.8749C33.8831 29.8679 33.5046 29.7072 33.2241 29.4267C32.9435 29.1461 32.7828 28.7676 32.7758 28.3709C32.7688 27.9742 32.9161 27.5903 33.1866 27.3C34.7984 25.6885 36.077 23.7752 36.9494 21.6695C37.8217 19.5638 38.2707 17.3068 38.2707 15.0276C38.2707 12.7483 37.8217 10.4914 36.9494 8.38562C36.077 6.2799 34.7984 4.36663 33.1866 2.75511C33.0361 2.61492 32.9155 2.44587 32.8318 2.25804C32.7481 2.07021 32.7031 1.86744 32.6994 1.66184C32.6958 1.45624 32.7336 1.25201 32.8107 1.06134C32.8877 0.870677 33.0023 0.697475 33.1477 0.55207C33.2931 0.406665 33.4663 0.292036 33.657 0.215023C33.8476 0.138009 34.0519 0.100187 34.2575 0.103815C34.4631 0.107443 34.6658 0.152445 34.8537 0.236137C35.0415 0.319829 35.2106 0.440496 35.3507 0.59094ZM14.4196 6.36477C14.7063 6.65188 14.8674 7.04107 14.8674 7.44686C14.8674 7.85264 14.7063 8.24183 14.4196 8.52894C13.5661 9.38212 12.8891 10.3951 12.4272 11.5099C11.9653 12.6248 11.7276 13.8198 11.7276 15.0265C11.7276 16.2333 11.9653 17.4283 12.4272 18.5431C12.8891 19.658 13.5661 20.671 14.4196 21.5241C14.6901 21.8144 14.8373 22.1984 14.8303 22.5951C14.8233 22.9917 14.6626 23.3702 14.3821 23.6508C14.1015 23.9313 13.723 24.092 13.3263 24.099C12.9296 24.106 12.5457 23.9588 12.2554 23.6883C9.95826 21.391 8.66775 18.2753 8.66775 15.0265C8.66775 11.7778 9.95826 8.66207 12.2554 6.36477C12.5425 6.07802 12.9317 5.91695 13.3375 5.91695C13.7433 5.91695 14.1325 6.07802 14.4196 6.36477ZM29.5789 6.36477C31.8761 8.66207 33.1666 11.7778 33.1666 15.0265C33.1666 18.2753 31.8761 21.391 29.5789 23.6883C29.4378 23.8346 29.2689 23.9514 29.0821 24.0317C28.8953 24.112 28.6944 24.1544 28.4911 24.1562C28.2878 24.1581 28.0861 24.1194 27.8979 24.0425C27.7097 23.9656 27.5386 23.852 27.3948 23.7083C27.251 23.5646 27.1372 23.3937 27.0601 23.2056C26.983 23.0174 26.9442 22.8158 26.9458 22.6125C26.9475 22.4092 26.9897 22.2082 27.0698 22.0213C27.15 21.8345 27.2666 21.6655 27.4127 21.5241C28.2659 20.671 28.9426 19.6582 29.4044 18.5435C29.8661 17.4288 30.1037 16.2341 30.1037 15.0276C30.1037 13.821 29.8661 12.6263 29.4044 11.5116C28.9426 10.3969 28.2659 9.38412 27.4127 8.53098C27.1423 8.24071 26.995 7.85678 27.002 7.46008C27.009 7.06338 27.1697 6.68489 27.4503 6.40434C27.7308 6.12379 28.1093 5.96308 28.506 5.95608C28.9027 5.94908 29.2866 6.09633 29.5769 6.36682M20.9162 11.9651C21.7284 11.9651 22.5073 12.2877 23.0817 12.8621C23.656 13.4364 23.9787 14.2153 23.9787 15.0276C23.9787 15.8398 23.656 16.6187 23.0817 17.1931C22.5073 17.7674 21.7284 18.0901 20.9162 18.0901C20.1039 18.0901 19.325 17.7674 18.7506 17.1931C18.1763 16.6187 17.8537 15.8398 17.8537 15.0276C17.8537 14.2153 18.1763 13.4364 18.7506 12.8621C19.325 12.2877 20.1039 11.9651 20.9162 11.9651Z" fill="black"></path>
                        </svg> 10k +</h4>
                        <h5>Active Jobs Listing</h5>
                        <p class="mb-0" style="color: rgba(32, 32, 32, 0.80);font-size: 14px;">Explore a wide range of opportunities across industries and locations</p>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mt-3">
                <h5 class="text-center" style="line-height: 1.8;">
                    Welcome to Jobkaro.in, your trusted partner in navigating today’s competitive job market. At Jobkaro.in, we bridge the gap between talented job seekers and top employers across various industries, ensuring a seamless experience for both candidates and recruiters.
                </h5>
            </div>
        </div>

        <div class="py-3 mob-hide" style="background: #E9F3FF;">
            <div class="row custom-col-10 mx-auto">
                <div class="col-md-6 my-auto">
                    <h3>Our Mission</h3>
                    <span style="line-height: 1.8;letter-spacing: 0.1rem;font-weight: 500;">
                        To empower professionals to find meaningful careers and help companies discover the right talent efficiently. Whether you are a fresh graduate, an experienced professional, or an organization looking for dedicated employees, Jobkaro.in is designed to simplify your search.
                    </sapn>
                </div>
                <div class="col-md-6 text-center">
                    <img src="<?=base_url('assets/newAssets/img/')?>misson.png" style="width: 400;" alt="">
                </div>
            </div>
        </div>

        <div class="py-3 mob-show" style="background: #E9F3FF;">
            <div class="row mx-0">
                <div class="col-md-6 my-auto">
                    <h3>Our Mission</h3>
                    <span class="d-block" style="line-height: 1.8;font-weight: 500;">
                        To empower professionals to find meaningful careers and help companies discover the right talent efficiently. Whether you are a fresh graduate, an experienced professional, or an organization looking for dedicated employees, Jobkaro.in is designed to simplify your search.
                    </span>
                </div>
            </div>
        </div>

        <div class="real-story mob-hide" id="real-story">
            <div class="container-fluid px-0">
                <h2 class="text-center mb-5">Testimonials</h2>

                <div class="slider-container">
                    <!-- First Row -->
                    <div class="slider-row mb-4">
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Ankit Verma,</h3>
                        <h3 class="name">Data Analyst <span>at ThinkDight</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Riya Kapoor,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                    </div>
                
                    <!-- Second Row -->
                    <div class="slider-row reverse">
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                      <div class="real-story-card">
                        <h3 class="name">Rajesh Malhotra,</h3>
                        <h3 class="name">HR <span>at InnovateCorp</span></h3>
                        <h6 class="text-center">
                            “Connected Me With the Right Opportunities”
                        </h6>
                        <p class="mb-0 small text-center">As a recruiter, Job Karo has been an incredible resource. The ability to connect directly with potential candidates has saved me so much time. It’s my go-to platform for finding top talent</p>
                      </div>
                    </div>
                  </div>


            </div>
        </div>

        <div class="mob-show py-3 px-2 mt-4">
            <h3 class="text-center mb-4">Testimonials</h3>
            <div class="d-flex gap-2">
                <div>
                    <p>Encountered a minor issue, but the customer support team was quick to respond a sol.... <span class="fw-bold">More</span></p>
                    <p class="mb-1 fw-bold">Pankaj Tyagi </p>
                    <p class="mb-0 small">UX Designer </p>
                </div>
                <div>
                    <img src="<?=base_url('assets/newAssets/img/')?>realstory.png" alt="" style="width: 200px;">
                </div>
            </div>
        </div>

        <?php require'footer.php';?>

    </div>
    
   <?php require'js.php';?>
  </body>
</html>