<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title></title>
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/css/style_new.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>
  <body>
    <div class="nav-bar mob-hide">
        <div class="d-flex container mx-auto">
            <div class="col-md-3">
                <img src="<?=base_url();?>/assets/img/img/logo.png" alt="" class="logo">
            </div>
            <div class="col-md-9 text-end my-auto">
                <ul class="list-unstyled d-flex justify-content-end mb-0">
                    <li><a class="active" href="<?php echo base_url('index.php/welcome/home')?>">Home</a></li>
                    <li><a href="<?php echo base_url('index.php/welcome/recruiter')?>">Recruiter</a></li>
                    <li><a href="<?php echo base_url('index.php/welcome/empolyee')?>">Job Seeker</a></li>
                    <li class="px-3 dropdown">
                        <button class="btn btn-outline-custom rounded-pill px-4" data-bs-toggle="dropdown">Login</button>
                        <ul class="dropdown-menu px-2">
                            <li><a class="dropdown-item p-2" data-bs-toggle="modal" data-bs-target="#myModal" type="button">👨‍💼 Employee</a></li>
                            <li><a class="dropdown-item p-2" data-bs-toggle="modal" data-bs-target="#myModal_rec" type="button">🕵🏼‍♀️ Recruiter</a></li>
                        </ul>
                    </li>
                    <li class="px-3"><button class="btn btn-custom rounded-pill">Download App</button></li>
                </ul>
            </div>
        </div>
    </div>
    <div class="container-fluid first_sec">
        <div class="container">
            <h1>
                Direct <span>Hiring</span> for Founders, <br>Team Leaders and Hiring Managers
            </h1>
            <p>
                JobKaro simplifies the hiring process. Directly chatting with
                verified candidates matched by the AI algorithm ensures a simple,
                quick and effective hiring experience.
            </p>
            <div style="margin-top: 7%;;">
                <div class="col-md-7 mx-auto search-div">
                    <div class="input-group p-2">
                        <span class="input-group-text bg-transparent border-0 text-muted"><i class="fa-solid fa-briefcase"></i></span>
                        <input type="text" class="form-control form-control-lg border-0" placeholder="Candidate's Skillset">
                    </div>
                    <div class="input-group p-2">
                        <span class="input-group-text bg-transparent border-0 text-muted"><i class="fa-solid fa-location-dot"></i></span>
                        <input type="text" class="form-control form-control-lg border-0" placeholder="Hiring Location">
                    </div>
                    <button class="btn btn-lg hiring-btn px-4">Start Hiring</button>
                </div>
            </div>
        </div>
    </div>
    <div class="second_sec pb-5">
        <div class="container row mx-auto text-muted">
            <div class="col-md-3 col-6">
                <div class="sec_bg second_bg1">
                <div class="img-div"><img src="https://cdn-icons-png.flaticon.com/128/2083/2083335.png" alt=""></div>
                <h6 class="fw-bold">190K+</h6>
                <p class="mb-1">Verified Recruiters</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="sec_bg second_bg2">
                <div class="img-div"><img src="https://cdn-icons-png.flaticon.com/128/3850/3850259.png" alt=""></div>
                <h6 class="fw-bold">500K+</h6>
                <p class="mb-1">Jobs Posted</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="sec_bg second_bg3">
                <div class="img-div"><img src="https://cdn-icons-png.flaticon.com/128/134/134808.png" alt=""></div>
                <h6 class="fw-bold">25M+</h6>
                <p class="mb-1">Chat Conversations</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="sec_bg second_bg4">
                <div class="img-div"><img src="https://cdn-icons-png.flaticon.com/128/10822/10822474.png" alt=""></div>
                <h6 class="fw-bold">3.8M+</h6>
                <p class="mb-1">Job Seekers</p>
                </div>
            </div>
        </div>
    </div>
    <div class="third_sec">
        <div class="row container mx-auto">
            <div class="col-lg-7 my-auto">
                <h2>Get <span style="color: orange;">Job Karo</span> App</h2>
                <div class="row mx-0 margin-4">
                    <div class="col-lg-12 row mx-auto px-0">
                        <div class="col-md-3 text-center">
                            <img src="https://jobkaro.in/assets/img/JobKaro_QR.png" class="qr_code" alt="">
                        </div>
                        <div class="col-lg-7 text-center">
                            <p class="mb-1">To download the app,
                                Just Click On Download Button Or Scan OR Code using your smartphone.</p>
                            <a href="https://play.google.com/store/apps/details?id=com.wlhiring.teamhiring" class="text-light text-decoration-none" target="_blank">
                                <img src="https://jobkaro.in/assets/img/download-btn.png" class="w-50" alt="">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 text-end">
                <img src="https://jobkaro.in/assets/img/jobkro.png" class="w-75 rounded-3 mob-hide" alt="">
            </div>
        </div>
    </div>
    <div class="fourth_sec pt-5">
        <h3 class="job-heading">Trending Job Categories</h3>
        <div class="container text-center">
            <div class="row gy-4">
                <div class="col-md-3 col-6">
                    <div class="job-list">
                        <img src="https://cdn-icons-png.flaticon.com/128/1055/1055683.png" alt="">
                        <h5>IT Engineering</h5>
                        <p class="mb-0 text-muted">685K+ Candidates</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="job-list">
                        <img src="https://cdn-icons-png.flaticon.com/128/4429/4429903.png" alt="">
                        <h5>Operations</h5>
                        <p class="mb-0 text-muted">490K+ Candidates</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="job-list">
                        <img src="https://cdn-icons-png.flaticon.com/128/4789/4789117.png" alt="">
                        <h5>BPO & KPO</h5>
                        <p class="mb-0 text-muted">360K+ Candidates</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="job-list">
                        <img src="https://cdn-icons-png.flaticon.com/128/1029/1029023.png" alt="">
                        <h5>Sales & BD</h5>
                        <p class="mb-0 text-muted">350K+ Candidates</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="job-list">
                        <img src="https://cdn-icons-png.flaticon.com/128/1369/1369878.png" alt="">
                        <h5>Finance</h5>
                        <p class="mb-0 text-muted">320K+ Candidates</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="job-list">
                        <img src="https://cdn-icons-png.flaticon.com/128/1998/1998087.png" alt="">
                        <h5>Marketing</h5>
                        <p class="mb-0 text-muted">255K+ Candidates</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="job-list">
                        <img src="https://cdn-icons-png.flaticon.com/128/3790/3790039.png" alt="">
                        <h5>Personnel</h5>
                        <p class="mb-0 text-muted">285K+ Candidates</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="job-list">
                        <img src="https://cdn-icons-png.flaticon.com/128/5996/5996290.png" alt="">
                        <h5>⋙</h5>
                        <p class="mb-0">View More</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="container mt-5">
            <div class="row">
                <div class="col-md-6 my-auto">
                    <h2 class="job-heading text-start mb-4">Chat directly with<br>
                    Decision-Makers</h2>
                    <p class="text-muted">Job Karo encourages direct and quick responses between job-seekers and recruiters. Through the bi-directional direct chat feature, candidates can chat directly with relevant and verified recruiters on this job search app.</p>
                    <button class="btn btn-custom rounded-pill mt-3">Get Hired</button>
                </div>
                <div class="col-md-1"></div>
                <div class="col-md-4">
                    <img src="<?=base_url();?>/assets/img/img/chat.png" class="w-100" alt="">
                </div>
            </div>
        </div>
    </div>
    <div class="py-3" style="background-color: lightsalmon;">
        <div class="container mx-auto row justify-content-center">
            <div class="col-md-3">
                <img src="<?=base_url();?>/assets/img/img/get-hire.png" class="w-100" alt="">
            </div>
            <div class="col-md-1"></div>
            <div class="col-md-5 my-auto">
                <h2 class="job-heading text-start mb-3">Hire Directly with Job Karo</h2>
                <p>3.8M+ candidates chat directly with 190K+ recruiters on Job Karo.</p>
                <button class="btn rounded-pill bg-white fw-bold px-4">Instant Hiring</button>
            </div>
        </div>
    </div>
    <div class="py-5 sixth_sec">
        <div class="col-md-9 mx-auto row justify-content-center">
            <h2 class="job-heading">Find Candidates in your City</h2>
            <div class="col-md-2 text-center col-6">
                <img src="<?=base_url();?>/assets/img/img/icon1.png" alt="">
            </div>
            <div class="col-md-2 text-center col-6">
                <img src="<?=base_url();?>/assets/img/img/icon2.png" alt="">
            </div>
            <div class="col-md-2 text-center col-6">
                <img src="<?=base_url();?>/assets/img/img/icon3.png" alt="">
            </div>
            <div class="col-md-2 text-center col-6">
                <img src="<?=base_url();?>/assets/img/img/icon4.png" alt="">
            </div>
            <div class="col-md-2 text-center col-6">
                <img src="<?=base_url();?>/assets/img/img/icon5.png" alt="">
            </div>
        </div>
    </div>
    <div class="container-fluid px-0 download_sec mob-hide shadow">
        <div class="row container mx-auto">
            <div class="col-md-6"></div>
            <div class="col-md-6 fw-bold mt-4">
                <h2 class="fw-bold text-center">Get Job Karo App</h2>
                    <div class="col-lg-12 row justify-content-end px-0 mt-4">
                            <div class="col-md-3">
                                <img src="https://jobkaro.in/assets/img/JobKaro_QR.png" class="w-100 border border-dark border-3" alt="">
                            </div>
                            <div class="col-lg-7 text-center">
                                <p class="mb-1">To download the app,
                                    Just Click On Download Button Or Scan OR Code using your smartphone.</p>
                                <a href="https://play.google.com/store/apps/details?id=com.wlhiring.teamhiring" class="text-light text-decoration-none" target="_blank">
                                    <img src="https://jobkaro.in/assets/img/download-btn.png" class="w-50" alt="">
                                </a>
                            </div>
                    </div>
            </div>
        </div>
    </div>
    <footer class="text-center text-lg-start bg-white aos-init aos-animate footer-section position-relative mt-1" style="background: url(img/footerBg.jpg); background-size: cover;">
        <section class="pt-5">
           <div class="container-fluid text-center text-md-start">
              <!-- Grid row -->
              <div class="row mt-3">
                 <!-- Grid column -->
                 <div class="col-md-3 col-lg-4 col-xl-3 mx-auto mb-4">
                    <!-- Content -->
                    <h6 class="text-uppercase fw-bold mb-4">
                       <i class="fas fa-gem me-3 text-secondary"></i>JOB KARO
                    </h6>
                    <p style="text-align: justify;">
                        Welcome to Jobkaro.in, your trusted partner in navigating today’s competitive job market. At Jobkaro.in, we bridge the gap between talented job seekers and top employers across various industries, ensuring a seamless experience for both candidates and recruiters.
                    </p>
                 </div>
                 <!-- Grid column -->
                 <!-- Grid column -->
                 <div class="col-md-2 col-lg-2 col-xl-2 mx-auto mb-4">
                    <!-- Links -->
                    <h6 class="text-uppercase fw-bold mb-4">
                       Job Karo
                    </h6>
                    <p>
                       <a href="" class="text-decoration-none">Home</a>
                    </p>
                    <p>
                       <a href="" class="text-decoration-none">About Us</a>
                    </p>
                    <p>
                       <a href="" class="text-decoration-none">Recruiters</a>
                    </p>
                    <p>
                        <a href="" class="text-decoration-none">Job Seekers</a>
                    </p>
                 </div>
                 <div class="col-md-3 col-lg-2 col-xl-2 mx-auto mb-4">
                    <!-- Links -->
                    <h6 class="text-uppercase fw-bold mb-4">
                       Useful links
                    </h6>
                    <p>
                       <a href="" target="_blank" class="text-decoration-none">Privacy Policy</a>
                    </p>
                    <p>
                       <a href="" target="_blank" class="text-decoration-none">Terms & Conditions</a>
                    </p>
                    <p>
                       <a href="" target="_blank" class="text-decoration-none">Refund Policy</a>
                    </p>
                 </div>
                 <!-- Grid column -->
                 <!-- Grid column -->
                 <div class="col-md-4 col-lg-3 col-xl-3 mx-auto mb-md-0 mb-4">
                    <!-- Links -->
                    <h6 class="text-uppercase fw-bold mb-4">Support</h6>
                    <p><i class="fas fa-home me-3 text-secondary"></i> Job Karo</p>
                    <p>
                       <i class="fas fa-envelope me-3 text-secondary"></i>
                       info@jobkaro.com
                    </p>
                    <div class="justifyContentResFoot">
                       <div>
                            <i class="fas fa-phone me-3 text-secondary"></i>+91 9311400755
                       </div>
                    </div>
                 </div>
                 <!-- Grid column -->
              </div>
              <!-- Grid row -->
           </div>
        </section>
        <!-- Section: Links  -->
        <!-- Copyright -->
        <div class="text-center p-4" style="background-color: rgba(0, 0, 0, 0.025);">
           © 2024 Copyright:
           <a class="text-reset fw-bold" href="#" target="_blank">Job Karo</a>
        </div>
        <!-- Copyright -->
     </footer>


     <!-- The Modal -->
  <div class="modal fade" id="myModal">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content border-0" style="">
        
        <!-- Modal body -->
        <div class="modal-body p-0">
            <div class="row">
              <div class="col-lg-5 text-center registerform-img align-self-end">
                  <h5 class="text-primary fs-4 pt-3">Find Your </h5>
                  <h1 class="fw-bold">Dream Job</h1>
                  <h6 class="text-end px-5" style="color:#feaf52;">Let's Get Started</h6>
                  <img src="<?php echo base_url() ?>assets/img/emp-register.png" class="w-100">
              </div>
              <div class="col-lg-7">
                <div class="p-4 py-5 login-form shadow rounded-3 h-100" style="background: #ffffffb8;">
                <div id="register_div">
                    <h5 class="text-center fw-bold">Register Now For <span class="h5 fw-bold" style="color:#feaf52;">Your Dream Job !</span></h5>
                    <p class="text-center text-muted">Fill out the form and take the first step towards your career goals.</p>
                    <form class="mt-4 px-3" action="<?=base_url('index.php/Welcome/submitRForm');?>" method="POST" 
                    style="display: ;" >
                    
                    
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-solid fa-user"></i></div>
                                    </div>
                                    <input type="text" class="form-control" name="c_name" id="condidate_name"
                                    placeholder="Candidate Name" required="required">
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-regular fa-envelope"></i></div>
                                    </div>
             <input type="email" class="form-control" name="c_email" id="email_a1" placeholder="Email ID" required="required">
                                </div>
                            
                        <div class="row">
                            <div class="col-md-12 mb-2">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                  <div class="input-group-text h-100"><i class="fa-solid fa-mobile-screen-button"></i>
                                  </div>
                                </div>
                               
                               
                               
                               
                                <input type="text" class="form-control" onkeypress='validate(event)' 
                                onpaste='validate(event)' minlength="10" maxlength="10" name="c_contact" id="c_contact" placeholder="Contact Number" required="required">
                            
                             <!--<span class="badge bg-danger" onclick="sendOtp1()">-->
                             <!--        Send Otp</span>-->
                            <div class="input-group-append bg-warning">
                                <!--<span class="">@example.com</span>-->
                                <span class="input-group-text h-100"  id ="b_otp_a1" onclick="Otpsend()">Send OTP</span>
                              </div>
                            </div>
                            
                            <script>
                                function validate(num) {
      var theEvent = num || window.event;
    
      // Handle paste
      if (theEvent.type === 'paste') {
          var key = event.clipboardData.getData('text/plain');
      } else {
      // Handle key press
          var key = theEvent.keyCode || theEvent.which;
          key = String.fromCharCode(key);
      }
      var regex = /[0-9]|\./;
      if( !regex.test(key) ) {
        theEvent.returnValue = false;
        if(theEvent.preventDefault) theEvent.preventDefault();
      }
    }
                            </script>
                            
                             <div class="text-end" type="button" >
                                <!--<span class="badge bg-danger" id="b_otp_a1"onclick="sendOtp11('email_a1' ,'b_otp_a1' )">Send Otp .</span>-->
                                <!--<span class="badge bg-danger"  id ="b_otp_a1" onclick="Otpsend()">Send Otp .</span>-->
                            </div>
                                     
                                
                            </div>
                            <div class="col-md-12 mb-3">
                                <div class="input-group">
                                <div class="input-group-prepend">
                                  <div class="input-group-text h-100"><i class="fa-solid fa-question"></i></div>
                                </div>
                                <input type="text" class="form-control" name="otp" id="otp_a1" placeholder="Enter OTP" required="required">
                                </div>
                            </div>
                        </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-solid fa-key"></i></div>
                                    </div>
                                    <input type="Password" class="form-control" name="c_pas" id="c_pas" placeholder="Password" required="required">
                                </div>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-solid fa-key"></i></div>
                                    </div>
                                    <input type="Password" class="form-control" name="c_confirm" id="c_confirm"  onkeyup="validateConfirm()" placeholder="Confirm Password" required="required">
                                </div>
                        <div class="text-center mt-4">
                            <!--<p id="p1" class="badge bg-danger"></p><br>-->
                            <p id="p2" class="badge bg-danger"></p><br>
                            <button type="submit" id="s_form_a1" class="button-61"
                            style="display:none">Register</button>
                            
                             <button type="button"  id="submit_p" class="button-61"
                            onclick="submitForm_otp( 'email_a1' ,'otp_a1' , 's_form_a1' , 'c_contact');"
                            
                            >Confirm Otp & Submit</button>
                            <div class="mt-3" id="login_btn" type="button">
                            <span class="my-3">Already register ? <b class="text-primary">
        					<u>login here</u></b></span>
                            </div>
                        </div>
                    </form>
                </div>
                
                
           
    
                <div class="mt-4" id="login_div" style="display: ;">
    
                    <div id="bypass">
                        <div class="text-center">
                            <img src="<?php echo base_url(); ?>assets/img/login-icon.png" style="width: 5rem;">
                        </div>
                        <form class="mt-5" action="<?=base_url('index.php/Welcome/loginAuth');?>" method="POST">
                        <input type="hidden"  class="custom_csrf" id="" placeholder="Enter email" name="token_name"
                        value="<?php echo (hex2bin($token_key)); ?>">
                        
                        <textarea class="form-control" style="resize: none;" id="token_f"  name="token_id" hidden></textarea>
                        
                        <div id="log_in_div_form">
                            <div class="px-5">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-regular fa-envelope"></i></div>
                                    </div>
                                    <input type="e-mail" class="form-control" name="c_email" placeholder="Email ID" required="">
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-solid fa-key"></i></div>
                                    </div>
                                    <input type="Password" class="form-control" name="c_pas" placeholder="Password" 
                                    required="">
                                </div>
                            </div>
                            
                             <div class="text-center mt-4">
                                     
                                    <label for="captcha" id="captchaLabel_emp"><?php echo $captcha['image']; ?></label>
                                
                                    <div class="px-5">
                                        <input type="text" autocomplete="off" class="form-control rounded-0" name="userCaptcha" id="userCaptcha_emp" placeholder="Enter above text"
                                            value="<?php if(!empty($userCaptcha)){ echo $userCaptcha;} ?>"
                                            style="padding: 10px; font-size: 16px; border: none; 
                                            border-bottom: 2px solid #feaf52; text-align:center" />
                                        
                                        
                                        <button type="button" onclick="refCaptcha()" class="btn btn-link p-0 ml-2" style="font-size: 20px;">
                                            <i class="fas fa-sync-alt" aria-hidden="true"></i>
                                        </button>
                                        
                                        <span class="required-server"><?php echo form_error('userCaptcha','<p style="color:#F83A18">','</p>'); ?></span> 
                                    </div>
                                </div>
                            
                            
                            <div class="text-center mt-4">
                                <input type="submit" class="button-61" value="&nbsp; Login &nbsp;">
                            </div>
                            <div class="px-5">
                                <u><h6 type="button" class="fw-normal mt-2" id="forget_pass">Forget Password ?</h6></u>
                            </div>
                        </div>
                       
                                    
                        </div>
                        <div class="" id="foget_pass_hide_div">
                        
                                <div id="req-otp" class="d-flex gap-1 justify-content-end px-5" style="margin-top: -2rem;">
                                    <input type="checkbox" class="mt-1">
                                    <label class="my-auto fs-6">Request OTP</label>
                                </div>
                                            
                                <div id="register_btn" class="mt-3 text-center" type="button">
                                    <span class="my-3">New User ? <b class="text-primary">
                                    <u>Register here</u></b></span>
                                    <input type="hidden" autocomplete="off" id="emp_captcha" name="hiddencaptcha" 
                                    placeholder="Enter above text" value="<?= $captcha['word'];;?>" />
                                    <input type="hidden" name="captcha_name"
                                    value="<?php echo (hex2bin($token_key)); ?>">
                                </div>
                            </div>
                    <div class="text-center" id="verify-otp">
                    <div class="col-lg-9 mx-auto px-0 mb-2">
                        <div class="row">
                            <div class="col-lg-9">
                        <input type="number" placeholder="Enter Mobile No.." 
                        id="login_phone1"
                        class="form-control border border-3">
                        </div>
                         <div class="col-lg-3">
                             
                        <button class="button-61" id="btn_login_phone1" onclick="send_login_otp('login_phone1')">Send OTP</button>
                              
                         </div>
                             
                        </div>
                    </div>
                    <span >
                        <h5><i style="color: black" id="login_otp1">Enter OTP Here</i></h5>
                    </span>
                    <div class="col-lg-9 mx-auto mt-3 mx-auto otp">
                     
                     <div class="col-lg-12 text-center">
                    <input type="text" class="form-control border border-3" id="otp_value1" placeholder="">
                        </div>
                      </div>
                      
                      
                <button class="button-61 mt-5" onclick="confirm_login_otp('login_phone1' , 'otp_value1')">Verify</button>
                </div>
                
                
                            
                          </div>
                        </form>
                    
                    <!--forget-pass div starts here-->
                    
                     <div id="forget_pass_div">
                            <div class="input-group mb-3">                                        
                                <input type="number" class="form-control" name="c_number" id="c_number" placeholder="Enter Number" required="required">
                            </div>
                            <div class="text-center">
                                <button type="button"  class="btn btn-primary" id="otp_button"
                                onclick="resetpass(document.getElementById('c_number').value)">Submit</button>
                            </div>
                             <div class="mt-3 text-center login_btn" type="button">
                            <span class="my-3">Already register ? <b class="text-primary">
        					<u>login here</u></b></span>
                            </div>
                        </div>
                            
                        <div id="enter_otp_div_form" style="display: none;">
                            <div class="input-group mb-3">
                                    <input type="number" class="form-control" name="v_number" id="v_number" placeholder="Enter Number" required="required">
                            </div>
                            <div class="input-group mb-3">
                            <input type="number" class="form-control" name="v_otp" id="v_otp" placeholder="Enter OTP" required="required">
                            </div>
                            <div class="text-center">
                                <button type="button" class="btn btn-primary" onclick="verify_otp()" id="reset_bottom">
                                    Verify</button>
                            </div>
                             <div class="mt-3 text-center login_btn"  type="button">
                            <span class="my-3">Already register ? <b class="text-primary">
        					<u>login here</u></b></span>
                            </div>
                        </div>        
                            
                        <div id="reset_password" style="display: none;">
                            <div class="input-group mb-3">
                                <input type="number" class="form-control" name="change_number" id="change_number" placeholder="Enter Number" required="required">
                            </div>
                            <div class="input-group mb-3">
                            <input type="number" class="form-control" name="new_pass" id="new_pass" placeholder="Enter  New Password" required="required">
                            </div>
                            <div class="input-group mb-3">
                            <input type="number" class="form-control" name="conf_pass" id="conf_pass" placeholder="Enter Confirm Password" required="required">
                            </div>
                            <div class="text-center">
                                <button type="button" class="btn btn-primary" onclick="makenewpass()">Reset</button>
                            </div>
                            
                              <div class="mt-3 text-center login_btn" type="button">
                            <span class="my-3">Already register ? <b class="text-primary">
        					<u>login here</u></b></span>
                            </div>
                        </div>
                    <!--forget-pass div end here-->
                    </div>
                    
                    
                    
                    <div id="byotp" style="display:none">
                        <form class="mt-4" action="<?=base_url('index.php/Welcome/loginOtp');?>" method="POST">
                            <div class="form-group mb-2">
<input type="text" minlength="10" maxlength="10" class="form-control" name="c_phone" id="phone_a2"placeholder="Phone no" required="">
                            </div>
                            <div class="text-end mb-2">
             <span class="bg-white p-1 border rounded" onclick="sendOtp11('phone_a2')"><strong>Send Otp .</strong></span>
                            </div>
                            <div class="form-group mb-3">
                                <input type="Password" class="form-control" name="otp" placeholder="Enter Otp" required="">
                            </div>
                                <div class="text-center mt-4">
                                    <input type="submit" class="btn btn-primary" value="Login">
                                </div>
                        </form>
                    </div>
    
                </div>
                
                
    
            </div>
              </div>
            </div>
        </div>
        
      </div>
    </div>
  </div>
     
     

    <!---recruiter side-->
    
    
      <div class="modal fade" id="myModal_rec">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
     <!-- Modal <body -->
        <div class="modal-body p-0">
          <div class="row">
              <div class="col-lg-6 text-center registerform-img px-3 pb-3">
                  <img src="<?php echo base_url() ?>assets/img/recruit-form.png" class="w-100">
                  <!--<img class="register_btn01" src="<?php echo base_url() ?>assets/img/sign-up.png" class="mb-3" -->
                  <!--style="width: 50%; cursor: pointer;">-->
                  <input type="submit" class="button-61 register_btn01" value="Register Here">
              </div>
              <div class="col-lg-6 border px-0" style="background: #fff; 
                  box-shadow: rgb(0 0 0 / 24%) 0px 3px 8px;">
                  <div class="p-3 login-form01 py-5">
                    
                    <div id="register_div01">
                        <h5 class="text-center fw-bold">Let's streamline <span class="h5 fw-bold" style="color:#feaf52;">the hiring procedure</span></h5>
                        <p class="text-muted text-center">Register now and find your Perfect Candidate. Start Working Immediately.</p>
                        <form class="mt-4 px-5" action="<?=rec_url();?>index.php/Welcome/rSignup" method="POST" 
                        style="display: ;">
        
        
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <div class="input-group-text h-100"><i class="fa-solid fa-user"></i></div>
                            </div>
        					<input type="text" class="form-control" name="c_name" id="recruiter_name" placeholder="Recruiter Name" required>
        				</div>
        				<div class="input-group mb-3">
        				    <div class="input-group-prepend">
                                  <div class="input-group-text h-100"><i class="fa-regular fa-envelope"></i></div>
                            </div>
        					<input type="email" class="form-control" name="c_email" id="email_a2" placeholder="Email ID" required>
        				</div>
        				<div class="">
        				    <div class="row">
        					<div class="col-md-12">
        					 <div class="input-group">
        					     <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-solid fa-mobile-screen-button"></i></div>
                                </div>
                				<input type="text" minlength="10" onkeypress='validate(event)' onpaste='validate(event)' maxlength="10" 
                					id="c_contact11_a3" class="form-control" name="c_contact" 
                					placeholder="Contact Number" required>
                				<div class="input-group-append bg-warning">
                				    <span class="input-group-text h-100"  id ="b_otp_a2" 
                				onclick="Otpsendrec()">Send OTP</span>
                				</div>
        					 </div>
        					 <div class="text-end" type="button" >
                                <!-- <span class="badge bg-danger"  id = "b_otp_a2" onclick="sendOtp11('email_a2' ,'b_otp_a2' )">Send Otp .</span> -->

                                <!--<span class="badge bg-danger"  id ="b_otp_a2" onclick="Otpsendrec()">Send Otp .</span>-->
                                 
                            </div>
        				
            				<p class="p-0" id="n111" class="badge bg-danger"></p>
            				</div>
        				    <div class="col-md-12 mb-3">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-solid fa-question"></i></div>
                                    </div>
                                    <input type="text" class="form-control"  id="otp_a2" name="otp" placeholder="Enter OTP" 
                                    required="required">
                                
                                </div>
                            </div>
        				
        	
        				</div>
        				</div>
        				
        			
        					<div class="input-group mb-3" id="enterOtp11" style="display:none">
        					<div class="input-group-prepend">
                              <div class="input-group-text h-100"><i class="fa-solid fa-question"></i></div>
                            </div>
        					<!--<input type="text" class="form-control" name="otp11" id="otp11" placeholder="otp">-->
        				    </div>
        				
        				
        				
        				<div class="input-group mb-3">
        				    <div class="input-group-prepend">
                                  <div class="input-group-text h-100"><i class="fa-solid fa-key"></i></div>
                            </div>
        					<input type="Password" class="form-control" name="c_pas" id="c_pas11" placeholder="Password" required>
        				</div>
        				<div class="input-group mb-3">
        				    <div class="input-group-prepend">
                                  <div class="input-group-text h-100"><i class="fa-solid fa-key"></i></div>
                            </div>
        					<input type="Password" class="form-control" name="c_confirm" id="c_confirm11" onkeyup="validatePasswords()" placeholder="Confirm Password" required>
        				</div>
        				
        				
        				<div class="text-center mt-4">
        				    <p id="p111" class="badge bg-danger"></p><br>
        				
        				<!--id="submit11" -->
        					<!--<input type="submit" id="s_form_a1"  class="button-61" -->
        					<!--value="Register">-->
        					  <button type="submit" id="s_form_a2" class="button-61"
                            style="display:none">Register</button>
        					
        					 <button type="button" id="submit11" class="button-61"
                            onclick="submitForm_otp( 'email_a2' ,'otp_a2' , 's_form_a2' , 'c_contact11_a3');"
                            
                            >Confirm Otp & Submit</button>
        					
        					<br>
        					<span class="my-3">Already register ? <b class="text-primary" id="login_btn01">
        					    <u>login here</u></b></span>
        					
        
        <script>
        				 var typingTimer;                //timer identifier
                var doneTypingInterval = 1000;  //time in ms, 5 seconds for example
                var $input = $('#c_contact11');
                
                //on keyup, start the countdown
                $input.on('keyup', function () {
                  clearTimeout(typingTimer);
                  typingTimer = setTimeout(showOtp11, doneTypingInterval);
                });
        				    function showOtp11(){
        				        var number = $('#c_contact11').val();
        				        // alert(number);
        				        if(number.length == 10){
        				           $("#confirmOtp11").css("display", "");
        				            $("#enterOtp11").css("display", "");
        				           document.getElementById("n111").innerHTML = "";
        				           
        				        }else{
        				            // alert('Number should be of 10 digits .');
        				             document.getElementById("n111").innerHTML = "Number should be of 10 digits .!";
        				            
        				        $("#confirmOtp11").css("display", "none");
        				            
        				        }
        				    }
        				</script>
        				
        				
        				
        				<script>
        				    function sendOtp11_22(){
        				        $("#enterOtp11").css("display", "");
        				        alert('OTP is 1234.');
        				    }
        				</script>
        				
        				
        			
        				
        				<script>
        				    
        				    function validatePasswords() {
                                    var password = document.getElementById("c_pas11").value;
                                    var confirmPassword = document.getElementById("c_confirm11").value;
                                    if (password !== confirmPassword) {
                                        $('#submit11').prop("disabled", true);
                                        document.getElementById("p111").innerHTML = "Password and Confrim password are not same !";
                                    } else {
                                        $('#submit11').prop("disabled", false); 
                                        document.getElementById("p111").innerHTML = "";
                                    }
                                }
        				    
        				     
        				</script>
        				
        				
        				<script>
        				    
        				    function validateConfirm() {
        				            
                                    var password = document.getElementById("c_pas").value;
                                    var confirmPassword = document.getElementById("c_confirm").value;
                                    if (password !== confirmPassword) {
                                        $('#submit_p').prop("disabled", true);
                                        document.getElementById("p2").innerHTML = "Password and Confrim password are not same !";
                                    } else {
                                        $('#submit_p').prop("disabled", false); 
                                        document.getElementById("p2").innerHTML = "";
                                    }
                                }
        				     
        				</script>
        	
        
        
        				</div>
                        </form>
                    </div>
        
                    <div class="mt-4" id="login_div01" style="display: ;">
                        <!--<div class="d-flex ml-2">-->
                        <!--    <div class="mr-5">-->
                        <!--        <input type="radio" id="password" name="login" value="" onclick="loginBy('pass')" checked>-->
                        <!--        <label for="password">Login By Password</label>-->
                        <!--    </div>-->
                        <!--    <div>-->
                        <!--        <input type="radio" id="otp" name="login" value="" onclick="loginBy('otp')">-->
                        <!--        <label for="otp">Login By OTP</label>-->
                        <!--    </div>-->
                        <!--</div>-->

                        <?php
                        

                            $random_number = rand(100,999999);
                            
                            $vals = array(
                                'word' => $random_number,
                                'img_path' => './captcha/',
                                'img_url' => base_url().'captcha/',
                                'img_width' => 240,
                                'img_height' => 45,
                                'expiration' => 7200,
                                'colors' => array(
                                    'background' => array(255, 255, 255), 
                                    'border' => array(0, 0, 0), 
                                    'text' => array(0, 0, 0), 
                                ),
                                'font_size' => 120,
                                'word_length' => 6,
                                'img_quality' => '100%',			
                                'text_effects' => array('bold'), 
                            );

                            $reccaptcha = create_captcha($vals);

                            $this->session->set_userdata(array(
                                'recword' => $random_number,
                                'img_path' => './captcha/',
                                'img_url' => base_url().'captcha/',
                                'img_width' => 190,
                                'img_height' => 40,
                                'expiration' => 7200
                            ));


                            $token=rand();
                           

                        ?>
        
                        <div id="bypass01">
                            <div class="text-center">
                                <img src="<?php echo base_url() ?>assets/img/login-icon.png" 
                                    class="mb-3" style="width: 5rem;">
                            </div>
                            <form class="mt-1 px-5" id="rec_log_in_div_form" action="<?=rec_url();?>index.php/Welcome/loginAuth" method="POST">
                            <input type="hidden"  class="custom_csrf" id="" placeholder="Enter email" name="token_name"
                         value="<?php echo (hex2bin($token)); ?>">
                         
                         <textarea class="form-control" style="resize: none;" id="token_rf"  name="token_rf" hidden></textarea>
                                
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-regular fa-envelope"></i></div>
                                    </div>
                                    <input type="e-mail" class="form-control" name="c_email" placeholder="Email ID" required="">
                                </div>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                      <div class="input-group-text h-100"><i class="fa-solid fa-key"></i></div>
                                    </div>
                                    <input type="Password" class="form-control" name="c_pass" placeholder="Password" required="">
                                </div>

                                <div class="text-center mt-4">
                                    <!-- Captcha label to display the captcha image -->
                                    <label for="captcha" id="captchaLabel"><?php echo $reccaptcha['image']; ?></label>
                                
                                    <div class="px-5">
                                        <input type="text" autocomplete="off" class="form-control rounded-0" name="userCaptcha" id="userCaptcha" placeholder="Enter above text"
                                            value="<?php if(!empty($userCaptcha)){ echo $userCaptcha;} ?>"
                                            style="padding: 10px; font-size: 16px; border: none; border-bottom: 2px solid #feaf52;" />
                                        
                                        <!-- Refresh button beside input field -->
                                        <button type="button" onclick="refreshCaptcha()" class="btn btn-link p-0 ml-2" style="font-size: 20px;">
                                            <i class="fas fa-sync-alt" aria-hidden="true"></i>
                                        </button>
                                        
                                        <span class="required-server">
                                            <?php echo form_error('userCaptcha','<p style="color:#F83A18">','</p>'); ?>
                                        </span>
                                    </div>
                                </div>


                                    <div class="text-center mt-4" id="rec_foget_pass_hide_div">
                                        <input type="submit" class="button-61" value="Login">
                                        <div class="d-flex justify-content-between">
                                            <div id="req-otp1" class="d-flex gap-1">
                                                <input type="checkbox" class="mt-1">
                                                <label class="my-auto fs-6">Request OTP</label>
                                            </div>
                                            <div class="text-center">
                                                <u><h6 type="button" class="fw-normal mt-2" id="rec_forget_pass">Forget Password ?</h6></u>
                                            </div>
                                        </div>
                                    </div>
                            <input type="hidden" autocomplete="off"  id="capt_hid" name="hiddencaptcha" placeholder="Enter above text" 
                            value="<?= $_SESSION['recword']; ?>" />
                            
                            
                                    <input type="hidden" name="captcha_name"
                                    value="<?php echo (hex2bin($token)); ?>">
                                    
                                    <div class="text-center font-weight-bold my-3 hide-signup">
                                        New User !!! <u class="register_btn01">Sign Up Here</u>
                                    </div>
                            </form>
                            
                            
                        <!--forget-pass div starts here-->
                    
                            <div id="rec_forget_pass_div">
                                    <div class="input-group mb-3">                                        
                                        <input type="number" class="form-control" name="r_c_number" id="r_c_number" placeholder="Enter Number" required="required">
                                    </div>
                                    <div class="text-center">
                                        <button type="button"  class="button-61" id="rec_otp_button"
                                        onclick="rec_resetpass(document.getElementById('r_c_number').value)">Submit</button>
                                    </div>
                                     <div class="mt-3 text-center login_btn_rc" type="button">
                                        <span class="my-3">Already register ? <b class="text-primary">
                    					<u>login here</u></b></span>
                                        </div>
                                </div>
                            
                            <div id="rec_enter_otp_div_form" style="display: none;">
                                <div class="input-group mb-3">
                                        <input type="number" class="form-control" name="r_v_number" id="r_v_number" placeholder="Enter Number" required="required">
                                </div>
                                <div class="input-group mb-3">
                                <input type="number" class="form-control" name="r_v_otp" id="r_v_otp" placeholder="Enter OTP" required="required">
                                </div>
                                <div class="text-center">
                                    <button type="button" class="btn btn-primary" onclick="rec_verify_otp()" id="rec_reset_bottom">
                                        Verify</button>
                                </div>
                                
                                <div class="mt-3 text-center login_btn_rc"  type="button">
                                        <span class="my-3">Already register ? <b class="text-primary">
                    					<u>login here</u></b></span>
                                        </div>
                            </div>        
                                
                            <div id="rec_reset_password" style="display: none;">
                                <div class="input-group mb-3">
                                    <input type="number" class="form-control" name="r_change_number" id="r_change_number" placeholder="Enter Number" required="required">
                                </div>
                                <div class="input-group mb-3">
                                <input type="number" class="form-control" name="r_new_pass" id="r_new_pass" placeholder="Enter  New Password" required="required">
                                </div>
                                <div class="input-group mb-3">
                                <input type="number" class="form-control" name="r_conf_pass" id="r_conf_pass" placeholder="Enter Confirm Password" required="required">
                                </div>
                                <div class="text-center">
                                    <button type="button" class="btn btn-primary" onclick="rec_makenewpass()">Reset</button>
                                </div>
                                
                                <div class="mt-3 text-center login_btn_rc" type="button">
                                        <span class="my-3">Already register ? <b class="text-primary">
                    					<u>login here</u></b></span>
                                        </div>
                            </div>
                        <!--forget-pass div end here-->
                        </div>
        
                        <div id="byotp01" style="display:none">
                            <form class="mt-4" action="<?=rec_url();?>index.php/Welcome/loginOtp" method="POST">
                                <div class="form-group mb-2">
                                    <input type="text" minlength="10" maxlength="10" class="form-control"
                                    name="c_phone" placeholder="Phone no" id="c_contact11_a4" required="">
                                </div>
                                <div class="text-end mb-2">
                                    <span class="bg-white p-1 border rounded" onclick="sendOtp11('c_contact11_a4')">
                                        <strong>Send Otp .</strong></span>
                                </div>
                                <div class="form-group mb-3">
                                    <input type="Password" class="form-control" name="otp" placeholder="Enter Otp" required="">
                                </div>
                                    <div class="text-center mt-4">
                                        <input type="submit" class="btn btn-primary" value="Login">

                                    </div>
                            </form>
                        </div>
                        
                        <div class="text-center mt-5" id="verify-otp1">
                            <div class="text-center">
                                <img src="<?php echo base_url() ?>assets/img/otp.png" class="w-25 mb-4">
                            </div>
                            <div class="col-lg-9 mx-auto">
                               
                               
                                <div class="row">
                            <div class="col-lg-9">
                        <input type="number" placeholder="Enter Mobile No...." 
                        id="login_phone2"
                        class="form-control border border-3">
                        </div>
                         <div class="col-lg-3">
                             
        <button class="button-61" id="btn_login_phone2" onclick="send_login_otp('login_phone2')">Send OTP</button>
                              
                         </div>
                               </div>
                               
                               
                            </div>
                            <div class="col-lg-9 mt-3 mb-2 mx-auto gap-2 otp"
                               
                                <div class="text-center">
                                    <span class="fw-bold fst-italic">Enter OTP Here</span>
                                </div>
                                    <div class="col-lg-12">
                    <input type="text" class="form-control border border-3" id="otp_value2"  placeholder="">
                                </div>
                                
                              </div><hr>
                          
                    <button class="button-61 mt-5" onclick="confirm_login_otp('login_phone2' , 'otp_value2')">Verify</button>
                          
                        </div>
        
                    </div>
        
                </div>
              </div>
          </div>
        </div>
        
      </div>
    </div>
  </div>
     
     
     <!---recuiter side end-->
     
     
 

     <script>
        function loginBy(type)
        {
                       
            if(type== 'otp'){
                $("#byotp").css("display", "");
                $("#bypass").css("display", "none");
            }
            else{
                            
                $("#bypass").css("display", "");
                $("#byotp").css("display", "none");
            }
        }
    </script>
    
    <script type="text/javascript">
        $(document).ready(function(){
            $("#login_div").show();
            $("#register_div").hide();
          $("#register_btn").click(function(){
            $("#register_div").show();
            $("#login_div").hide();
            $("#verify-otp").hide();
          });
          $("#login_btn").click(function(){
            $("#register_div").hide();
            $("#login_div").show();
            $("#verify-otp").hide();
            $("#bypass").show();
          });
          
           $(".login_btn").click(function(){
            $("#forget_pass_div").hide();
            $("#log_in_div_form").show();
            $('#foget_pass_hide_div').show();
            $("#verify-otp").hide();
            $('#reset_password').hide();
            $("#bypass").show();
            $('#rec_reset_password').hide();
            $('#enter_otp_div_form').hide();
             $("input[type=text], input[type=number]").val("");
             
          });
          
           $(".login_btn_rc").click(function(){
            $("#rec_forget_pass_div").hide();
            $("#rec_log_in_div_form").show();
            $('#login_div01').show();
            $('#rec_foget_pass_hide_div').show();
            $("#rec_enter_otp_div_form").hide();
            $('#rec_reset_password').hide();
            $("#bypass01").show();
            $('#enter_otp_div_form').hide();
             $("input[type=text], input[type=number]").val("");
             
          });
        });
    </script>
    
    <script>
    $(document).ready(function(){
         $("#verify-otp").hide();
      $("#req-otp").click(function(){
        $("#bypass").hide();
        $("#foget_pass_hide_div").hide();
        $("#verify-otp").show();
      });
    });
    </script>    
    <script>
        $(document).ready(function(){
            $("#forget_pass_div").hide();
          $("#forget_pass").click(function(){
              $("#log_in_div_form").hide();
              $("#forget_pass_div").show();
              $("#foget_pass_hide_div").hide();
          });
        });
    </script>


<script type="text/javascript">
    $(document).ready(function(){
        $("#login_div01").show();
        
        $("#register_div01").hide();
      $(".register_btn01").click(function(){
        $("#register_div01").show();
        $(".register_btn01").hide();
        $("#login_div01").hide();
        $("#verify-otp1").hide();
      });
      $("#login_btn01").click(function(){
        $("#register_div01").hide();
        $("#login_div01").show();
        $("#verify-otp1").hide();
        $("#bypass01").show();
        $(".register_btn01").show();
      });
    });
</script>

  <script>
$(document).ready(function(){
     $("#verify-otp1").hide();
  $("#req-otp1").click(function(){
    $("#bypass01").hide();
    $("#verify-otp1").show();
    $(".register_btn01").show();
  });
});
</script>
<script>
$(document).ready(function(){
    $("#forget_pass_div").hide();
  $("#forget_pass").click(function(){
      $("#log_in_div_form").hide();
      $("#forget_pass_div").show();
      $("#foget_pass_hide_div").hide();
  });
//   $("#otp_button").click(function(){
//       $("#forget_pass_div").hide();
//       $("#enter_otp_div_form").show();
//       $("#foget_pass_hide_div").hide();
//   });
//   $("#reset_bottom").click(function(){
//       $("#enter_otp_div_form").hide();
//       $("#reset_password").show();
//       $("#foget_pass_hide_div").hide();
//   });
});
</script>

<script>
$(document).ready(function(){
    $("#rec_forget_pass_div").hide();
  $("#rec_forget_pass").click(function(){
      $("#rec_log_in_div_form").hide();
      $("#rec_forget_pass_div").show();
      $("#rec_foget_pass_hide_div").hide();
  });
//   $("#rec_otp_button").click(function(){
//       $("#rec_forget_pass_div").hide();
//       $("#rec_enter_otp_div_form").show();
//       $("#rec_foget_pass_hide_div").hide();
//   });
//   $("#rec_reset_bottom").click(function(){
//       $("#rec_enter_otp_div_form").hide();
//       $("#rec_reset_password").show();
//       $("#rec_foget_pass_hide_div").hide();
//   });
});
</script>

<?//php include 'allJs.php';?>
	<?//php require 'allJs.php';?>

  </body>
</html>
<!--code from here--->

<script>
        function submitForm_otp(email ,otp ,submitb_id , c_contact ){
        				       
        				         var email_e = document.getElementById(email).value ;
        				          var otp_e = document.getElementById(otp).value ;
                                  var number = document.getElementById(c_contact).value ;

                      
  if (email_e =='' || otp_e == '') {
    alert('Please fill OTP and email first .') ;
    return false ;
  }
        var dataString = '&email_e='+email_e+'&otp_e='+otp_e+'&number='+number ;
                    
                    // alert(dataString);
              $.ajax({
        type: 'POST',
        url: '<?php echo base_url(); ?>index.php/Welcome/confirm_otp_val' ,
        data:dataString,        
        success: function (response) {
            var data = JSON.parse(response);
            
            // alert('ok') ;
            if(data.success==2){
                alert('Incorrect OTP');
                // return false ;
            }else{
               
                
                document.getElementById(submitb_id).click();
                
                //  return true ;
            }
            
        }
    });
        				        
        				    }
        				</script>

<script>

    function Otpsend()
    {
        var number = document.getElementById('c_contact').value;
        var name = document.getElementById('condidate_name').value;        

        if (/^\d{1,10}$/.test(number)) {
            
            if (parseFloat(number) > 0) {
                
                var dataString = '&type='+number+'&name='+name  ;
                    
                $.ajax({
                        type: 'POST',
                        url: '<?php echo base_url(); ?>index.php/Welcome/send_to_db_sms' ,
                        data:dataString,        
                        success: function (response) {                            
                            var data = JSON.parse(response);                           

                            var status = data.status;                        

                            if(status=='SUCCESS')
                            {
                                alert('OTP has been sent successfully') ;
                            }
                            else
                            {
                                alert('Candidate name and phone no is required') ;
                            }
                          

                        }
                });
              
            } else {
                alert("Number must be greater than zero");
            }
        } else {
            alert("Invalid input. Please enter a number up to ten digits.");
        }
				        
        }
</script>

<script>

    function Otpsendrec()
    {
        var number = document.getElementById('c_contact11_a3').value;
        var name = document.getElementById('recruiter_name').value;        

        if (/^\d{1,10}$/.test(number)) {
            
            if (parseFloat(number) > 0) {
                
                var dataString = '&type='+number+'&name='+name  ;
                    
                $.ajax({
                        type: 'POST',
                        url: '<?php echo base_url(); ?>index.php/Welcome/send_to_db_sms' ,
                        data:dataString,        
                        success: function (response) {
                            var data = JSON.parse(response);                           

                            var status = data.status;   
                            
                            if(status=='SUCCESS')
                            {
                                alert('OTP has been sent successfully') ;
                            }
                            else
                            {
                                alert('Candidate name and phone no is required') ;
                            }
                          

                        }
                });
              
            } else {
                alert("Number must be greater than zero");
            }
        } else {
            alert("Invalid input. Please enter a number up to ten digits.");
        }
				        
        }
</script>

<script>
    function sendOtp11(id,button_id){
        				        $("#"+button_id).css("display", "none");
        				        // alert('OTP is 1234.');
        				         var type = document.getElementById(id).value ;
        				    
                        if(type == ''){
                            
                             let person = prompt("Please enter your Email to get OTP", "");
  if (person != null) {
    type = person;
    
    document.getElementById(id).value = person ;
  }else{
      alert('please enter your email');
  }
  
                        }
                    var dataString = '&type='+type ;
                    
              $.ajax({
        type: 'POST',
        url: '<?php echo base_url(); ?>index.php/Welcome/send_to_db_smsold' ,
        data:dataString,        
        success: function (response) {
            var data = JSON.parse(response);
            console.log(data);
            // var countries = data.j_d ;
            // alert(data.j_d) ;
            // console.log(data.j_d) ;
            // window['countries'] = data.j_d ;
            alert('mail sent .') ;
             $("#"+button_id).css("display", "");
            
        }
    });
        				        
        				    }
</script>
<?php if(!empty($_GET['f_msg'])){?>

<script>
$(document).ready(function(){
var m = '<?=hex2bin($_GET['f_msg']);?>';
alert(m);
});

</script>
<?php } ?>


<script>
        				    function confirm_login_otp(number_id , otp_id){
        				       
        				        // alert('OTP is 1234.');
        				         var number = document.getElementById(number_id).value ;
        				          var otp = document.getElementById(otp_id).value ;

                    var dataString = '&number='+number+'&otp='+otp ;
                    
              $.ajax({
        type: 'POST',
        url: '<?php echo base_url(); ?>index.php/Welcome/login_otp_auth' ,
        data:dataString,        
        success: function (response) {
            var data = JSON.parse(response);
            // console.log(data);
            // return false;
            
            var status = data.status ;
            if(status == 'no_user'){
                alert('Wrong OTP Entered.') ;
            }
            else if(status == 'expired'){
                alert('OTP Expired! valid for 5 mins ! Try again') ;
                location.reload();
            }else if(status == 'login_now'){
          
             var u_type = data.u_type ;
             
             if(u_type == 'emp'){
                window.location.replace('<?=base_url();?>' + 'index.php/Welcome/career'); 
             }else{
                 var link = data.link;
                 window.location.replace(link); 
             }
            
            }
             
            
        }
    });
        				        
        				    }
        				</script>

<script>
        				    function send_login_otp(number_id){
        				        $("#btn_"+number_id).css("display", "none");
        				        // alert('OTP is 1234.');
        				         var type = document.getElementById(number_id).value ;
                        
                        if(type == ''){
                            
                             let person = prompt("Please enter your Phone number to get OTP", "");
  if (person != null) {
    type = person;
    
    document.getElementById(number_id).value = person ;
  }else{
      alert('please enter your phone number');
  }
  
                        }
                    var dataString = '&type='+type+'&is_login='+'yes' ;
                    
              $.ajax({
        type: 'POST',
        url: '<?php echo base_url(); ?>index.php/Welcome/send_to_db_sms_login' ,
        data:dataString,        
        success: function (response) {
            var data = JSON.parse(response);
            // console.log(data);

            var status = data.status;
            var number = data.number;

            if(status == 'SUCCESS'){
                //alert('no user with this number found .') ;
                alert('OTP sent in your registered Mobileno - ' +number) ;
            }else if(status == 'failed'){
                alert('Something went wrong .') ; location.reload();
            }
            else{
            //     var email = data.email ;
            // alert('Mail sent in your registered email - ' + email) ;
            }
             $("#btn_"+number).css("display", "");
            
        }
    });
        				        
        				    }
        				</script>
        				
<script>
    $(document).ready(function() {
        
        var flashMessage = '<?= $this->session->flashdata('message_name'); ?>';
        
        if (flashMessage) {
            
            alert(flashMessage);
        }
    });
</script>


<script>
    
    function getParameterByName(name, url) {
        if (!url) url = window.location.href;
        name = name.replace(/[\[\]]/g, "\\$&");
        var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
            results = regex.exec(url);
        if (!results) return null;
        if (!results[2]) return '';
        return decodeURIComponent(results[2].replace(/\+/g, " "));
    }

    // Check if there is a message parameter in the URL
    var message = getParameterByName('message');
    
    // Display the message in an alert on page load
    $(document).ready(function() {
        if (message) {
            alert(message);
            window.location.href = 'https://jobkaro.in/';
            
        }
    });
</script>



<script>
function resetpass(number)
{             
        
    if (/^\d{1,10}$/.test(number)) {
        
        if (parseFloat(number) > 0) {
            
            var dataString = '&type='+number;
                
            $.ajax({
                    type: 'POST',
                    url: '<?php echo base_url(); ?>index.php/Welcome/send_otp_resetpassword' ,
                    data: {
                        number:number                        
                    },
                    cache: false,
                    datatype:'json',     
                    success: function (response) {                            
                        var data = JSON.parse(response);                           

                        var status = data.status;                        

                        if(status=='SUCCESS')
                        {
                            alert('OTP has been sent successfully');
                            $('#v_number').val(data.number);
                            
                          // document.getElementById('v_number').style.display = 'block';
                          document.getElementById('enter_otp_div_form').style.display = 'block';
                          document.getElementById('forget_pass_div').style.display = 'none';
                          document.getElementById('reset_password').style.display = 'none';

                        }
                        else
                        {
                            
                          alert('Your phone no is not exits! Please register yourself') ;
                          location.reload();
                          document.getElementById('forget_pass_div').style.display = 'none';
                          document.getElementById('enter_otp_div_form').style.display = 'none';
                          document.getElementById('reset_password').style.display = 'none';
                            
                        }
                        

                    }
            });
            
        } else {
            alert("Number must be greater than zero");
        }
    } else {
        alert("Invalid input. Please enter a number up to ten digits.");
    }
                
}


</script>


<script>
function verify_otp()
{
    var number=document.getElementById('v_number').value;
    var otp=document.getElementById('v_otp').value;
    
  if (/^\d{1,10}$/.test(number)) {
        
        if (parseFloat(number) > 0) {     
              
            $.ajax({
                    type: 'POST',
                    url: '<?php echo base_url(); ?>index.php/Welcome/verify_otp_resetpassword' ,
                    data: {
                        number:number,  
                        otp:otp                        
                    },
                    cache: false,
                    datatype:'json',     
                    success: function (response) {                            
                        var data = JSON.parse(response);                           

                        var status = data.status;                        

                        if(status=='SUCCESS')
                        {
                            alert('OTP verified successfully');
                            $('#change_number').val(data.number);
                            $('#change_number').val(data.number);
                             document.getElementById('reset_password').style.display = 'block';
                             document.getElementById('forget_pass_div').style.display = 'none';
                            document.getElementById('enter_otp_div_form').style.display = 'none';
                         
                        }
                        else if(status=='expired')
                        {
                            alert('OTP Expired ! valid for 5 mins ! Try Agian');
                            location.reload();
                          document.getElementById('forget_pass_div').style.display = 'none';
                          document.getElementById('enter_otp_div_form').style.display = 'none';
                          document.getElementById('reset_password').style.display = 'none';
                         
                        }
                        else
                        {
                            alert('Invalid OTP');
                            location.reload();
                          document.getElementById('forget_pass_div').style.display = 'none';
                          document.getElementById('enter_otp_div_form').style.display = 'none';
                          document.getElementById('reset_password').style.display = 'none';
                        }
                        

                    }
            });
            
        } else {
            alert("Number must be greater than zero");
        }
    } else {
        alert("Invalid input. Please enter a number up to ten digits.");
    }
    
    



}

function makenewpass()
{
    var number=document.getElementById('change_number').value;
    var password=document.getElementById('new_pass').value;
    var confirmpss=document.getElementById('conf_pass').value;
   
        if (/^\d{1,10}$/.test(number)) {
            
            if (parseFloat(number) > 0) {     
                  
                $.ajax({
                        type: 'POST',
                        url: '<?php echo base_url(); ?>index.php/Welcome/resetnew_password' ,
                        data: {
                            number:number,  
                            password:password,
                            confirmpss:confirmpss
                        },
                        cache: false,
                        datatype:'json',     
                        success: function (response) {                            
                            var data = JSON.parse(response);                           
    
                            var status = data.status;                        
    
                            if(status=='SUCCESS')
                            {
                                alert('Password set succssfully');
                                location.reload();
                                // document.getElementById('reset_password').style.display = 'block';
                                // document.getElementById('forget_pass_div').style.display = 'none';
                                // document.getElementById('enter_otp_div_form').style.display = 'none';
                             
                            }
                            else
                            {
                                alert('Password not set succssfully') ;
                                location.reload();
                                document.getElementById('forget_pass_div').style.display = 'none';
                              document.getElementById('enter_otp_div_form').style.display = 'none';
                              document.getElementById('reset_password').style.display = 'none';
                            }
                            
    
                        }
                });
                
            } else {
                alert("Number must be greater than zero");
            }
        } else {
            alert("Invalid input. Please enter a number up to ten digits.");
        }

    


}




</script>       				

<script>

function rec_resetpass(number)
{             
        
    if (/^\d{1,10}$/.test(number)) {
        
        if (parseFloat(number) > 0) {
            
            var dataString = '&type='+number;            
                
            $.ajax({
                    type: 'POST',
                    url: '<?=rec_url();?>index.php/Welcome/send_otp_resetpassword' ,
                    data: {
                        number:number                        
                    },
                    cache: false,
                    datatype:'json',     
                    success: function (response) {                            
                        var data = JSON.parse(response);                           

                        var status = data.status;                        

                        if(status=='SUCCESS')
                        {
                            alert('OTP has been sent successfully');
                            $('#r_v_number').val(data.number);
                          document.getElementById('rec_enter_otp_div_form').style.display = 'block';
                          document.getElementById('rec_forget_pass_div').style.display = 'none';                           
                          document.getElementById('rec_reset_password').style.display = 'none';

                           

                        }
                        else
                        {
                            
                          alert('Your phone no is not exits! Please register yourself') ;
                          location.reload();
                          document.getElementById('rec_forget_pass_div').style.display = 'none';
                          document.getElementById('rec_enter_otp_div_form').style.display = 'none';
                          document.getElementById('rec_reset_password').style.display = 'none';
                            
                        }
                        

                    }
            });
            
        } else {
            alert("Number must be greater than zero");
        }
    } else {
        alert("Invalid input. Please enter a number up to ten digits.");
    }
                
}


</script>


<script>
function rec_verify_otp()
{
    var number=document.getElementById('r_v_number').value;
    var otp=document.getElementById('r_v_otp').value;
    
  if (/^\d{1,10}$/.test(number)) {
        
        if (parseFloat(number) > 0) {     
              
            $.ajax({
                    type: 'POST',
                    url: '<?=rec_url();?>index.php/Welcome/verify_otp_resetpassword' ,
                    data: {
                        number:number,  
                        otp:otp                        
                    },
                    cache: false,
                    datatype:'json',     
                    success: function (response) {                            
                        var data = JSON.parse(response);                           

                        var status = data.status;                        

                        if(status=='SUCCESS')
                        {
                          $('#r_change_number').val(data.number);

                            alert('OTP verified successfully');
                             document.getElementById('rec_reset_password').style.display = 'block';
                             document.getElementById('rec_forget_pass_div').style.display = 'none';
                            document.getElementById('rec_enter_otp_div_form').style.display = 'none';
                         
                        }
                        else if(status=='expired')
                        {
                           

                            alert('OTP Expired ! valid for 5 mins ! Try Agian');
                            location.reload();
                            document.getElementById('rec_forget_pass_div').style.display = 'none';
                            document.getElementById('rec_enter_otp_div_form').style.display = 'none';
                            document.getElementById('rec_reset_password').style.display = 'none';
                         
                        }
                        else
                        {
                            alert('Invalid OTP');
                            location.reload();
                          document.getElementById('rec_forget_pass_div').style.display = 'none';
                          document.getElementById('rec_enter_otp_div_form').style.display = 'none';
                          document.getElementById('rec_reset_password').style.display = 'none';
                        }
                        

                    }
            });
            
        } else {
            alert("Number must be greater than zero");
        }
    } else {
        alert("Invalid input. Please enter a number up to ten digits.");
    }
    
    



}

function rec_makenewpass()
{
    var number=document.getElementById('r_change_number').value;
    var password=document.getElementById('r_new_pass').value;
    var confirmpss=document.getElementById('r_conf_pass').value;
   
        if (/^\d{1,10}$/.test(number)) {
            
            if (parseFloat(number) > 0) {     
                  
                $.ajax({
                        type: 'POST',
                        url: '<?=rec_url();?>index.php/Welcome/resetnew_password' ,
                        data: {
                            number:number,  
                            password:password,
                            confirmpss:confirmpss
                        },
                        cache: false,
                        datatype:'json',     
                        success: function (response) {                            
                            var data = JSON.parse(response);                           
    
                            var status = data.status;                        
    
                            if(status=='SUCCESS')
                            {
                                alert('Password set succssfully');
                                location.reload();                                
                             
                            }
                            else
                            {                                
                                alert('Password not set succssfully') ;
                                location.reload();
                                document.getElementById('rec_forget_pass_div').style.display = 'none';
                              document.getElementById('rec_enter_otp_div_form').style.display = 'none';
                              document.getElementById('rec_reset_password').style.display = 'none';
                            }
                            
    
                        }
                });
                
            } else {
                alert("Number must be greater than zero");
            }
        } else {
            alert("Invalid input. Please enter a number up to ten digits.");
        }

    


}




</script>



<!--from here code statrted-->

<script src="https://www.gstatic.com/firebasejs/7.14.6/firebase-app.js"></script>
<script src="https://www.gstatic.com/firebasejs/7.14.6/firebase-messaging.js"></script>
<script>
// var firebaseConfig = {
//     apiKey: "AIzaSyAVxZ108LCEqAJTp4OYRct1uc7IylGeUtQ",
//     authDomain: "grocery-a4d87.firebaseapp.com",
//     projectId: "grocery-a4d87",
//     storageBucket: "grocery-a4d87.appspot.com",
//     messagingSenderId: "857244758227",
//     appId: "1:857244758227:web:0271e56c14f3ba25d66426",
//     measurementId: "G-JF6GRK7YY7"
//     };


var firebaseConfig = {
        apiKey: "AIzaSyDCujgUVu3pinxOeKzN0JtRulPbnJxHIgc",
        authDomain: "bitsmultiservice.firebaseapp.com",
        projectId: "bitsmultiservice",
        storageBucket: "bitsmultiservice.appspot.com",
        messagingSenderId: "1050359172710",
        appId: "1:1050359172710:web:5b40d0f3737f0f4c6467a7"
    };


    firebase.initializeApp(firebaseConfig);
    const messaging=firebase.messaging();

    function IntitalizeFireBaseMessaging() {
        messaging
            .requestPermission()
            .then(function () {
                console.log("Notification Permission");
                return messaging.getToken();
            })
            .then(function (token_f) {
                console.log("Token : "+token_f);
                document.getElementById("token_f").innerHTML=token_f;
                document.getElementById("token_rf").innerHTML=token_f;
            })
            .catch(function (reason) {
                console.log(reason);
            });
    }

    messaging.onMessage(function (payload) {
        console.log(payload);
        const notificationOption={
            body:payload.notification.body,
            icon:payload.notification.icon
        };

        if(Notification.permission==="granted"){
            var notification=new Notification(payload.notification.title,notificationOption);

            notification.onclick=function (ev) {
                ev.preventDefault();
                window.open(payload.notification.click_action,'_blank');
                notification.close();
            }
        }

    });
    messaging.onTokenRefresh(function () {
        messaging.getToken()
            .then(function (newtoken) {
                console.log("New Token : "+ newtoken);
            })
            .catch(function (reason) {
                console.log(reason);
                //alert(reason);
            })
    })
    IntitalizeFireBaseMessaging();
</script> 


<script>
        function refreshCaptcha()
        {
            fetch('<?=rec_url();?>index.php/Welcome/refresh_captcha') 
                .then(response => response.json())
                .then(data => {
                    
                    document.getElementById('userCaptcha').value = '';
                    document.getElementById('captchaLabel').innerHTML = ''; 
        
                   
                    document.getElementById('captchaLabel').innerHTML = data.random_number;
                    
                    document.getElementById('capt_hid').value = '';
                    
                    document.getElementById('capt_hid').value = data.random_number;
        
                    // Set the background color, border color, and text color based on the data
                    document.getElementById('captchaLabel').style.backgroundColor = data.background_color;
                    document.getElementById('captchaLabel').style.color = data.text_color; // Set text color
                    document.getElementById('captchaLabel').style.border = `2px solid ${data.border_color}`; // Set border color
                    
                    document.getElementById('captchaLabel').style.width = data.img_width + 'px';
                    document.getElementById('captchaLabel').style.height = data.img_height + 'px';
                    // document.getElementById('captchaLabel').style.display = 'flex';
                    document.getElementById('captchaLabel').style.justifyContent = 'center';
                    document.getElementById('captchaLabel').style.alignItems = 'center';
                    document.getElementById('captchaLabel').style.fontSize = '20px';
                    document.getElementById('captchaLabel').style.fontWeight = 'bold';
                    
                    
                })
                .catch(error => console.error('Error refreshing captcha:', error));
        }
    </script>
    
    
<!--emp-->
<script>
function refCaptcha() {
    fetch('<?=rec_url();?>index.php/Welcome/refresh_captcha') 
        .then(response => response.json())
        .then(data => {
            document.getElementById('userCaptcha_emp').value = '';
            document.getElementById('captchaLabel_emp').innerHTML = data.random_number;
            
            
            
            document.getElementById('emp_captcha').value = '';
                    
            document.getElementById('emp_captcha').value = data.random_number;
            
            // Optional styling adjustments
            document.getElementById('captchaLabel_emp').style.backgroundColor = data.background_color;
            document.getElementById('captchaLabel_emp').style.color = data.text_color; // Set text color
            document.getElementById('captchaLabel_emp').style.border = `2px solid ${data.border_color}`; // Set border color
            
            document.getElementById('captchaLabel_emp').style.width = data.img_width + 'px';
            document.getElementById('captchaLabel_emp').style.height = data.img_height + 'px';
            // document.getElementById('captchaLabel_emp').style.display = 'flex';
            document.getElementById('captchaLabel_emp').style.justifyContent = 'center';
            document.getElementById('captchaLabel_emp').style.alignItems = 'center';
            document.getElementById('captchaLabel_emp').style.fontSize = '20px';
            document.getElementById('captchaLabel_emp').style.fontWeight = 'bold';
            
            
        })
        .catch(error => console.error('Error refreshing captcha:', error));
}
</script>








