
<style>
/* Modal styles */
#video-call-modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    justify-content: center;
    align-items: center;
    z-index: 1000;
}

#modal-content {
    position: relative;
    width: 80%;
    height: 80%;
    background-color: #fff;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    transition: width 0.3s, height 0.3s;
    padding: 0px;
}

.video-container {
    display: flex;
    position: relative;
    width: 100%;
    height: 100%;
}

#localVideo {
    position: absolute;
    top: 10px;
    left: 10px;
    width: 150px;
    border: 2px solid #fff;
    border-radius: 5px;
    cursor: grab;
    z-index: 10;
}

#remoteVideo {
    width: 100%;
    height: 100%;
    background-color: black;
}

.control-buttons {
    display: flex;
    position: absolute;
    bottom: 20px;
    left: 50%;
    transform: translateX(-50%);
    gap: 10px;
}

.control-button {
    background-color: #333;
    color: #fff;
    border: none;
    border-radius: 50%;
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: background-color 0.3s;
}

.control-button i {
    font-size: 20px;
}

.control-button:hover {
    background-color: #555;
}

.end-call {
    background-color: red;
    color: white;
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.end-call:hover {
    background-color: darkred;
}

#video-call-modal {
    transition: all 0.3s;
}

#local-placeholder {
    position: absolute;
    top: 6%;
    left: 1.8%;
    width: 20%;
    height: 20%;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center; 
    z-index: 10;
    transform: translate(0, 0); /* No need for translation if it's aligned at the top left */
    text-align: center; /* Center the text and image within the placeholder */
}



#local-placeholder img {
    width: 50px; /* Image width */
    height: 50px; /* Image height */
	border-radius:50%;
    object-fit: cover; /* Ensures the image maintains its aspect ratio */
    
}


#remote-placeholder {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    background-color: rgba(0, 0, 0, 0.5); /* Optional for better visibility */
    width: auto; /* Set width to auto */
    height: auto; /* Set height to auto */
    padding: 10px; /* Optional: add padding for spacing around the image */
}

#remote-placeholder img {
    width: 100px;
    height: 100px;
	border-radius:50%;
    object-fit: contain; /* Ensures the image maintains its aspect ratio */
}


#local-placeholder p {
    color: white;
    font-size: 0.7em;
    text-align: center;
    
}
#remote-placeholder p {
    color: white;
    font-size: 1.2em;
    text-align: center;
    
}
</style>

<!-- Modal for Video Call -->
<div id="video-call-modal" class="modal">
    <div class="modal-content" id="modal-content">
        <div class="video-container">
            <video id="localVideo" autoplay muted playsinline></video>
			<div id="local-placeholder" style="display:none;">
				<img src="<?php echo base_url() ?>assets/user.png" alt="User Image">
				<p><?=$user->c_name;?></p>
			</div>
            <video id="remoteVideo" autoplay playsinline></video>
			<div id="remote-placeholder" style="display:none;">
				<img src="<?php echo base_url() ?>assets/user.png" alt="User Image">
				<p id="remoteName"></p>
			</div>
        </div>
        <div class="control-buttons">
            <button id="toggle-audio" class="control-button" onclick="toggleAudio()">
                <i id="audio-icon" class="fas fa-microphone"></i>
            </button>
            <button id="toggle-video" class="control-button" onclick="toggleVideo()">
                <i id="video-icon" class="fas fa-video-camera"></i>  
            </button>
            <button id="switch-camera" class="control-button" onclick="switchCamera()">
                <i class="fas fa-exchange-alt"></i> 
            </button>
			<button id="share-screen" class="control-button" onclick="shareScreen()">
				<i class="fas fa-desktop"></i> 
			</button>

            <button id="end-call" class=" btn btn-danger" onclick="hangupCall()">HangUp</button>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">

 <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/izitoast@1.4.0/dist/css/iziToast.min.css">
 <script src="https://cdn.jsdelivr.net/npm/izitoast@1.4.0/dist/js/iziToast.min.js"></script>
 <script src="https://cdn.socket.io/4.6.1/socket.io.min.js"></script>
<script>
const callOfferSound = new Audio('<?=base_url();?>/assets/music/ring.mp3');
callOfferSound.load();
	const socket = io("https://chat.jobkaro.org.in:3000", {
        reconnection: true, // Enable auto-reconnect
        reconnectionAttempts: 15, // Number of attempts
        reconnectionDelay: 2000, // Delay between attempts
    });
	
	const localVideo = document.getElementById("localVideo");
    const remoteVideo = document.getElementById("remoteVideo");
	let isInitiator = false;
	let callStartTime = null;
	let localStream;
	const recruiter_id = '<?=$rec_id;?>';
	const fromUserName = '<?=$user->c_name;?>';
	const fromUserID = 'REC'+recruiter_id;
	
	socket.on("connect", () => {
		// iziToast.success({
			// position: 'topCenter',
			// title: 'Success',
			// message: 'Connected to the chat server'
		// });
		socket.emit("registerUser", fromUserID);
    });
	
	
// Single Method for peer connection
    const PeerConnection = (function(){
    let peerConnection;

    const createPeerConnection = () => {
        const config = {
            iceServers: [
                {
                    urls: 'stun:stun.l.google.com:19302'
                },
				{
					urls: ["turn:103.211.202.56:5050?transport=tcp"],
					username: "bitspan",
					credential: "Bitspan!202BINDSecure",
		        },
            ]
        };
        peerConnection = new RTCPeerConnection(config);

        // add local stream to peer connection
        localStream.getTracks().forEach(track => {
            peerConnection.addTrack(track, localStream);
        })
        // listen to remote stream and add to peer connection
        peerConnection.ontrack = function(event) {
            remoteVideo.srcObject = event.streams[0];
        }
        // listen for ice candidate
        peerConnection.onicecandidate = async function(event) {
			
            if (event.candidate) {
                try {
                    // Wait until the remote description is set
                    await waitForRemoteDescription(peerConnection);
                    socket.emit("icecandidate", { toUserId, candidate: event.candidate });
					
                } catch (error) {
                    console.error("Failed to send ICE candidate:", error);
                }
            }else{
				console.log('NA');
			}
        };

        return peerConnection;
    }

    return {
        getInstance: () => {
            if(!peerConnection){
                peerConnection = createPeerConnection();
            }
            return peerConnection;
        },
        reset: () => {
            if (peerConnection) {
                peerConnection.close();
                peerConnection = null;
            }
        }
    }
})();


function waitForRemoteDescription(pc) {
    return new Promise((resolve, reject) => {
        if (pc.remoteDescription) {
            resolve();
        } else {
            const checkInterval = setInterval(() => {
                if (pc.remoteDescription) {
                    clearInterval(checkInterval);
                    resolve();
                }
            }, 100);

            setTimeout(() => {
                clearInterval(checkInterval);
                reject(new Error("Timeout waiting for remote description"));
            }, 120000); // Timeout after 5 seconds
        }
    });
}

 
async function videoCall(toUserID,isAudio,toName){
	checkChatStatus(toUserID, async function(status) {
		if (status === 2) {
			try {
				isInitiator = true;
				await startMyVideo();

				if (localStream) {
					const modal = document.getElementById('video-call-modal');
					modal.style.display = 'flex';
					const endCallButton = document.getElementById('end-call');
					endCallButton.setAttribute('data-to-user-id', 'EMP'+toUserID);
					startCall(toUserID,isAudio,toName);
				}
			} catch (error) {
				console.error("Failed to start video or obtain permissions", error);
				alert("Unable to start video call. Please check your permissions and enable audio and video permissions");
			}
		}
	});
}

// initialize app
const startMyVideo = async () => {
    try {
        const stream = await navigator.mediaDevices.getUserMedia({ audio: true, video: true });
        localStream = stream;
        localVideo.srcObject = stream;
    } catch (error) {
        if (error.name === 'NotAllowedError' || error.name === 'PermissionDeniedError') {
            alert("Camera and microphone access is required to start the video call. Please enable them in your browser settings.");
        } else if (error.name === 'NotFoundError') {
            alert("No camera or microphone found. Please ensure your devices are connected and working.");
        }
        console.error("Media permissions error", error);
        throw error;
    }
};
	
const startCall = async (toUserID,isAudio,toName) => {
	toUserId='EMP'+toUserID;
    const pc = PeerConnection.getInstance();
    try {
        const offer = await pc.createOffer();
        await pc.setLocalDescription(offer);
		if(isAudio){
			prom='Audio';
			await toggleVideoIni(toName);
		}else{
			prom='Video';
		}
        socket.emit("offer", { fromUserId: fromUserID, toUserId,fromUserName,isAudio, offer: pc.localDescription });
		sendMessage(prom+' call');
    } catch (error) {
        console.error("Error during call setup", error);
    }
};

socket.on("offer", async ({ fromUserId, socketID, username,isAudio, offer }) => {
    try {
		if(isAudio){
			prom='Audio';
		}else{
			prom='Video';
		}
        callOfferSound.currentTime = 0;
        callOfferSound.play();

        iziToast.question({
            timeout: false,
            close: false,
            overlay: true,
            displayMode: 'once',
            id: 'question',
            title: `Incoming Call from ${username}`,
            message: 'Do you want to accept the '+prom+' call?',
            position: 'center',
            buttons: [
                ['<button><b>Accept</b></button>', async function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'button');
                    callOfferSound.pause();
                    callOfferSound.currentTime = 0;
	
                    await startMyVideo();
					sendMessageWebRtc(prom+' call accepted',fromUserId);
					const modal = document.getElementById('video-call-modal');
					if(isAudio){
						await toggleVideoIni(username);
					}
					modal.style.display = 'flex';
					
					const endCallButton = document.getElementById('end-call');
					endCallButton.setAttribute('data-to-user-id', fromUserId);
					const btn = document.getElementById('toggle-video');
					btn.setAttribute('data-to-socket-id', socketID);
					btn.setAttribute('data-to-name', username);
                    const pc = PeerConnection.getInstance();
                    await pc.setRemoteDescription(offer);
                    addQueuedIceCandidates(pc);

                    const answer = await pc.createAnswer();
                    await pc.setLocalDescription(answer);
                    socket.emit("answer", { toUserId: fromUserId, socketID, fromUser: fromUserID,toName:fromUserName, answer: pc.localDescription });
                }, true],
                ['<button>Reject</button>', function (instance, toast) {
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'button');
                    callOfferSound.pause();
                    callOfferSound.currentTime = 0;
                    hangupCall(fromUserId);
					sendMessageWebRtc(prom+' call rejected',fromUserId);
                    socket.emit("callRejected", { fromUser: fromUserID });
                }]
            ],
            onClosing: function (instance, toast, closedBy) {
                callOfferSound.pause();
                callOfferSound.currentTime = 0;
            }
        });
    } catch (error) {
        console.error("Error handling offer:", error);
    }
});


socket.on("answer", async ({answer,socketId,toName}) => {
	callStartTime = new Date();
	const pc = PeerConnection.getInstance();
	await pc.setRemoteDescription(answer);
	const btn = document.getElementById('toggle-video');
	btn.setAttribute('data-to-socket-id', socketId);
	btn.setAttribute('data-to-name', toName);
});

socket.on("closePrompt", ({ fromUser }) => {
    iziToast.hide({}, document.querySelector('#question'));
});

const iceCandidatesQueue = [];

// Socket listener for ICE candidates
socket.on("icecandidate", async ({ candidate }) => {
    const pc = PeerConnection.getInstance();
    
    if (pc.remoteDescription && pc.remoteDescription.type) {
        await pc.addIceCandidate(new RTCIceCandidate(candidate));
    } else {
        iceCandidatesQueue.push(candidate);
    }
});

// Utility function to add queued ICE candidates
async function addQueuedIceCandidates(pc) {
    while (iceCandidatesQueue.length > 0) {
        const candidate = iceCandidatesQueue.shift();
        await pc.addIceCandidate(new RTCIceCandidate(candidate));
    }
}

// Function to hang up the call
function hangupCall(toUser) {
	let toUserId;
	if(toUser){
		toUserId = toUser;
	}else{
		const endCallButton = document.getElementById('end-call');
		toUserId = endCallButton.getAttribute('data-to-user-id');
	}
    const modal = document.getElementById('video-call-modal');
    modal.style.display = 'none';
	socket.emit("hangup", { toUserId });
    const pc = PeerConnection.getInstance();

    pc.close();

    const senders = pc.getSenders();
    senders.forEach(sender => {
        if (sender.track) {
            sender.track.stop();
        }
    });
    const localVideoElement = document.getElementById('localVideo');
    const remoteVideoElement = document.getElementById('remoteVideo');
	const localPlaceholder = document.getElementById("local-placeholder");
	const remotePlaceholder = document.getElementById("remote-placeholder");
	localPlaceholder.style.display = "none";
	remotePlaceholder.style.display = "none";
	document.getElementById("audio-icon").className ="fas fa-microphone";
	document.getElementById("video-icon").className ="fas fa-video";
    if (localVideoElement) {
        localVideoElement.srcObject = null;
    }

    if (remoteVideoElement) {
        remoteVideoElement.srcObject = null;
    }

    PeerConnection.reset();
	if (isInitiator) {
		const callEndTime = new Date();
		const result = calculateCallDuration(callStartTime, callEndTime);
		var res = JSON.parse(result);
		sendMessageWebRtc('Call ended '+res.msg,toUserId,res.duration); 
		callStartTime = null;
		isInitiator =false;
	}
	
}

function calculateCallDuration(start, end) {
    const durationInSeconds = Math.floor((end - start) / 1000);
	const minutes = Math.floor(durationInSeconds / 60);
    const seconds = durationInSeconds % 60;
    const msg= `${minutes}m ${seconds}s`;
	const data = JSON.stringify({
		duration: durationInSeconds,
		msg: msg
	});
	return data;

}

socket.on("hangup", ({ toUserId }) => {
	if (document.querySelector('#question')) {
		iziToast.hide({}, document.querySelector('#question'));
	} 
    const modal = document.getElementById('video-call-modal');
    modal.style.display = 'none';
	const endCallButton = document.getElementById('end-call');
	receiver_id = endCallButton.getAttribute('data-to-user-id');
    const pc = PeerConnection.getInstance();

    // Close the peer connection
    pc.close();

    // Stop all local media tracks
    const senders = pc.getSenders();
    senders.forEach(sender => {
        if (sender.track) {
            sender.track.stop();
        }
    });

    // Clear video elements
    const localVideoElement = document.getElementById('localVideo');
    const remoteVideoElement = document.getElementById('remoteVideo');
	const localPlaceholder = document.getElementById("local-placeholder");
	const remotePlaceholder = document.getElementById("remote-placeholder");
	localPlaceholder.style.display = "none";
	remotePlaceholder.style.display = "none";
	document.getElementById("audio-icon").className ="fas fa-microphone";
	document.getElementById("video-icon").className ="fas fa-video";
    if (localVideoElement) {
        localVideoElement.srcObject = null;
    }

    if (remoteVideoElement) {
        remoteVideoElement.srcObject = null;
    }

    PeerConnection.reset();
    iziToast.error({
		position: 'topCenter',
		title: 'Error',
		message: 'Call ended by Employee'
	});

	if (isInitiator) {
		const callEndTime = new Date(); 
		const result = calculateCallDuration(callStartTime, callEndTime);
		var res = JSON.parse(result);
		sendMessageWebRtc('Call ended '+res.msg,receiver_id,res.duration); 
		callStartTime = null;
		isInitiator =false;
	}
    // console.log(`Call with room ${room_id} ended by the other peer.`);
});

   

let usingFrontCamera = true;

async function switchCamera() {
    if (!localStream) {
        console.error("No video stream available to switch.");
        return;
    }

    // Stop the current video tracks
    localStream.getTracks().forEach(track => track.stop());

    // Toggle the camera
    usingFrontCamera = !usingFrontCamera;
    const videoConstraints = {
        video: {
            facingMode: usingFrontCamera ? "user" : "environment"
        },
        audio: true // Ensure audio is included
    };

    try {
        const newStream = await navigator.mediaDevices.getUserMedia(videoConstraints);
        const localVideoElement = document.getElementById('localVideo');
        localVideoElement.srcObject = newStream;
        localStream = newStream;

        // Update your peer connection with the new video and audio stream if needed
        const pc = PeerConnection.getInstance();
        
        // Update the video track
        const videoSender = pc.getSenders().find(s => s.track.kind === 'video');
        if (videoSender) {
            videoSender.replaceTrack(newStream.getVideoTracks()[0]);
        }

        // Update the audio track
        const audioSender = pc.getSenders().find(s => s.track.kind === 'audio');
        if (audioSender) {
            audioSender.replaceTrack(newStream.getAudioTracks()[0]);
        }
    } catch (error) {
        console.error("Error switching camera:", error);
    }
}




function toggleAudio() {
    if (localStream) {
        const audioTracks = localStream.getAudioTracks();
        const isMuted = audioTracks[0].enabled;
        audioTracks.forEach(track => track.enabled = !isMuted);
        document.getElementById("audio-icon").className = isMuted ? "fas fa-microphone-slash" : "fas fa-microphone";
    }
}

// function toggleVideo() {
    // if (localStream) {
        // const videoTracks = localStream.getVideoTracks();
        // const isMuted = videoTracks[0].enabled;
        // videoTracks.forEach(track => track.enabled = !isMuted);
        // document.getElementById("video-icon").className = isMuted ? "fas fa-video-slash" : "fas fa-video";
    // }
// }

function toggleVideoIni(toName) {
    if (localStream) {
        const videoTracks = localStream.getVideoTracks();
        const isMuted = videoTracks[0].enabled;
        videoTracks.forEach(track => track.enabled = !isMuted);

        const localPlaceholder = document.getElementById("local-placeholder");
		const remotePlaceholder = document.getElementById("remote-placeholder");
		const remoteName = document.getElementById("remoteName");
        if (isMuted) {
            // localVideoElement.style.display = "none";
            localPlaceholder.style.display = "block";
			// remoteVideoElement.style.display = "none";
            remotePlaceholder.style.display = "block";
            remoteName.textContent =toName;
        } else {
            // localVideoElement.style.display = "block";
            localPlaceholder.style.display = "none";
			// remoteVideoElement.style.display = "block";
            remotePlaceholder.style.display = "none";
        }

        document.getElementById("video-icon").className = isMuted ? "fas fa-video-slash" : "fas fa-video";
    }
}
function toggleVideo() {
    if (localStream) {
        const videoTracks = localStream.getVideoTracks();
        const isMuted = videoTracks[0].enabled;
        videoTracks.forEach(track => track.enabled = !isMuted);
		const btn = document.getElementById('toggle-video');
		socketId = btn.getAttribute('data-to-socket-id');
		toName = btn.getAttribute('data-to-name');
		
        const localPlaceholder = document.getElementById("local-placeholder");
		const remotePlaceholder = document.getElementById("remote-placeholder");
		const remoteName = document.getElementById("remoteName");
        if (isMuted) {
            // localVideoElement.style.display = "none";
            localPlaceholder.style.display = "block";
			// remoteVideoElement.style.display = "none";
            // remotePlaceholder.style.display = "block";
            // remoteName.textContent =toName;
        } else {
            // localVideoElement.style.display = "block";
            localPlaceholder.style.display = "none";
			// remoteVideoElement.style.display = "block";
            // remotePlaceholder.style.display = "none";
        }
		
        document.getElementById("video-icon").className = isMuted ? "fas fa-video-slash" : "fas fa-video";
		socket.emit("toggleVideo", { socketId,isMuted });
    }
}


// Listen for mute/unmute signals from the server
socket.on("toggleAudio", ({ isMuted }) => {
    const remoteStream = remoteVideo.srcObject;
    if (remoteStream) {
        const audioTracks = remoteStream.getAudioTracks();
        audioTracks.forEach(track => {
            track.enabled = isMuted;
        });
    }
});

// socket.on("toggleVideo", ({ isMuted }) => {
    // const remoteStream = remoteVideo.srcObject;
    // if (remoteStream) {
        // const videoTracks = remoteStream.getVideoTracks();
        // videoTracks.forEach(track => {
            // track.enabled = isMuted;
        // });
    // }
// });


socket.on("toggleVideo", ({ isMuted }) => {
    const remoteStream = remoteVideo.srcObject;
    const remoteVideoElement = document.getElementById("remoteVideo");
    const remotePlaceholder = document.getElementById("remote-placeholder");
	const remoteName = document.getElementById("remoteName");
	const btn = document.getElementById('toggle-video');
	toName = btn.getAttribute('data-to-name');
    if (remoteStream) {
        const videoTracks = remoteStream.getVideoTracks();
        videoTracks.forEach(track => {
            track.enabled = !isMuted;
        });

        if (isMuted) {
            // Hide video and show placeholder
            // remoteVideoElement.style.display = "none";
            remotePlaceholder.style.display = "block";
			remoteName.textContent =toName;
        } else {
            // Show video and hide placeholder
            // remoteVideoElement.style.display = "block";
            remotePlaceholder.style.display = "none";
        }
    }
});


let screenStream;

async function shareScreen() {
    try {
        screenStream = await navigator.mediaDevices.getDisplayMedia({ video: true });
        
        // Add the screen stream to the peer connection
        const pc = PeerConnection.getInstance();
        const screenVideoTrack = screenStream.getVideoTracks()[0];
        
        const videoSender = pc.getSenders().find(s => s.track.kind === 'video');
        if (videoSender) {
            videoSender.replaceTrack(screenVideoTrack);
        }
        
        // Listen for when the user stops sharing the screen
        screenVideoTrack.onended = function () {
            stopScreenShare();
        };
    } catch (error) {
        console.error("Error sharing screen:", error);
    }
}

function stopScreenShare() {
    if (screenStream) {
        const videoSender = PeerConnection.getInstance().getSenders().find(s => s.track.kind === 'video');
        if (videoSender && localStream) {
            videoSender.replaceTrack(localStream.getVideoTracks()[0]);
        }
        
        screenStream.getTracks().forEach(track => track.stop());
        screenStream = null;
    }
}

function sendMessageWebRtc(msg,rec_id,duration=0){
	rec_id=rec_id.replace("REC", "")
	room='rec_'+rec_id+'_ee_'+ee_id;		
	const data = JSON.stringify({
		sender_id: ee_id,
		sender_type: 'recruiter',
		rec_id: rec_id,
		ee_id: ee_id,
		room_id: room,
		duration:duration,
		message:msg
	});

	socket.emit("sendMessage", data);
	// messageInput.value = "";		
}

function detectDevice() {
    const userAgent = navigator.userAgent.toLowerCase();
    const platform = navigator.platform.toLowerCase();
    const isMobile = /android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/.test(userAgent);
    const isTablet = /ipad/.test(userAgent);

    if (!isMobile && !isTablet) {
        document.getElementById("switch-camera").style.display = 'none'; // Hide the button
      
    }
}

window.onload = detectDevice; 
// let totalBytesSent = 0;
// let totalBytesReceived = 0;

// function getPeerConnectionStats(pc) {
    // pc.getStats(null).then(stats => {
        // stats.forEach(report => {
            // if (report.type === "outbound-rtp" && report.kind === "video") {
                // totalBytesSent = report.bytesSent;
            // }
            // if (report.type === "inbound-rtp" && report.kind === "video") {
                // totalBytesReceived = report.bytesReceived;
            // }
        // });

        // const sentMB = (totalBytesSent / 1048576).toFixed(2);
        // const receivedMB = (totalBytesReceived / 1048576).toFixed(2);
        
        // console.log(`Data Sent: ${sentMB} MB`);
        // console.log(`Data Received: ${receivedMB} MB`);
    // });
// }

// setInterval(() => {
    // const pc = PeerConnection.getInstance(); // Assuming you have a singleton instance
    // getPeerConnectionStats(pc);
// }, 10000);


	
</script>