<!DOCTYPE html>
<html lang="en">
    <?php require'css.php';?>
<body>
    <div class="px-4">
        <div class="customDivCol pt-4">
            <?php require'header.php';?>
		<div class="mob-hide">
            <div class="d-flex justify-content-between mt-5 savedjobnav gap-3">
                <div class="col-same">
                    <a href="<?=base_url('employer/application');?>" class="text-decoration-none">
                        <div class="inactive-application">
                            <div class="d-flex gap-4">
                                <div class="my-auto">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="54" height="54" viewBox="0 0 54 54" fill="none">
                                        <path d="M29.0947 23.4626C30.4469 21.5732 31.1739 19.3081 31.1739 16.9847C31.1739 14.6613 30.4469 12.3962 29.0947 10.5068C30.3608 9.64429 31.859 9.18632 33.391 9.19344C35.4574 9.19344 37.4391 10.0143 38.9002 11.4754C40.3614 12.9366 41.1823 14.9183 41.1823 16.9847C41.1823 19.0511 40.3614 21.0328 38.9002 22.494C37.4391 23.9551 35.4574 24.776 33.391 24.776C31.859 24.7831 30.3608 24.3251 29.0947 23.4626ZM12.2433 16.9847C12.2433 15.4437 12.7002 13.9374 13.5563 12.6561C14.4125 11.3748 15.6293 10.3762 17.053 9.78652C18.4766 9.19681 20.0432 9.04252 21.5545 9.34315C23.0659 9.64378 24.4542 10.3858 25.5438 11.4754C26.6334 12.5651 27.3755 13.9533 27.6761 15.4647C27.9767 16.9761 27.8224 18.5426 27.2327 19.9663C26.643 21.39 25.6444 22.6068 24.3631 23.4629C23.0819 24.319 21.5755 24.776 20.0345 24.776C17.9682 24.776 15.9864 23.9551 14.5253 22.494C13.0641 21.0328 12.2433 19.0511 12.2433 16.9847ZM16.6954 16.9847C16.6954 17.6451 16.8913 18.2907 17.2582 18.8398C17.6251 19.3889 18.1466 19.8169 18.7567 20.0696C19.3669 20.3224 20.0383 20.3885 20.686 20.2597C21.3337 20.1308 21.9287 19.8128 22.3957 19.3458C22.8626 18.8788 23.1807 18.2839 23.3095 17.6361C23.4383 16.9884 23.3722 16.317 23.1195 15.7069C22.8668 15.0967 22.4388 14.5752 21.8897 14.2083C21.3405 13.8414 20.695 13.6456 20.0345 13.6456C19.149 13.6456 18.2996 13.9974 17.6734 14.6236C17.0472 15.2498 16.6954 16.0991 16.6954 16.9847ZM35.6171 38.1324V42.5846H4.45203V38.1324C4.45203 38.1324 4.45203 29.2281 20.0345 29.2281C35.6171 29.2281 35.6171 38.1324 35.6171 38.1324ZM31.1649 38.1324C30.8533 36.3961 28.2042 33.6803 20.0345 33.6803C11.8649 33.6803 9.06 36.5964 8.90417 38.1324M35.5058 29.2281C36.8701 30.2893 37.9857 31.6364 38.774 33.1747C39.5624 34.7129 40.0045 36.4051 40.0692 38.1324V42.5846H48.9735V38.1324C48.9735 38.1324 48.9735 30.0518 35.4835 29.2281H35.5058Z" fill="#007BFF"/>
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="fw-500">Applicants</h4>
                                    <p class="mb-0">Review All Incoming Talent at a Glance. </p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-same">
                    <a href="<?=base_url('employer/shortlist');?>" class="text-decoration-none">
                        <div class="active-application">
                            <div class="d-flex gap-4">
                                <div class="my-auto">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="44" height="44" viewBox="0 0 44 44" fill="none">
                                        <path d="M9.16675 23.7923L18.3334 30.959L34.8334 11.2507M3.66675 4.08398H40.3334V39.9173H3.66675V4.08398Z" stroke="#1DAC00" stroke-opacity="0.8" stroke-width="1.5"/>
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="fw-normal">Shortlisted</h4>
                                    <p class="mb-0">Candidates Ready for the Next Step</p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-same">
                    <a href="<?=base_url('employer/rejected');?>" class="text-decoration-none">
                        <div class="inactive-application">
                            <div class="d-flex gap-4">
                                <div class="my-auto">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="44" height="44" viewBox="0 0 44 44" fill="none">
                                        <path d="M19.4417 19.4434L24.5575 24.5592M24.5575 19.4434L19.4417 24.5592" stroke="#FF3232" stroke-opacity="0.8" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M13.473 6.65234H32.2316C32.6838 6.65234 33.1174 6.83198 33.4372 7.15173C33.7569 7.47149 33.9366 7.90517 33.9366 8.35737V35.6426C33.9366 36.0948 33.7569 36.5285 33.4372 36.8483C33.1174 37.168 32.6838 37.3477 32.2316 37.3477H11.768C11.3158 37.3477 10.8821 37.168 10.5624 36.8483C10.2426 36.5285 10.063 36.0948 10.063 35.6426V10.0632M13.473 6.65234L10.063 10.0632M13.473 6.65234V10.0632H10.063" stroke="#FF4747" stroke-opacity="0.8" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="fw-normal">Rejected</h4>
                                    <p class="mb-0">Keep Track of Unsuccessful Applications</p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
			</div>
        </div>
    </div>

    <div class="p4 mob-hide">
        <div class="homePageSecondSec mt-3">
                <div class="d-flex justify-content-between mb-4">
                    <h3 class="my-auto">Your Top Talent(<?=count($shortlist);?>)</h3>
                    <!--<div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23" fill="none">
                            <path d="M20.0568 14.6178H8.39559M4.27947 14.6178H2.59564M4.27947 14.6178C4.27947 14.0721 4.49625 13.5487 4.88212 13.1629C5.26799 12.777 5.79135 12.5602 6.33705 12.5602C6.88276 12.5602 7.40612 12.777 7.79199 13.1629C8.17786 13.5487 8.39464 14.0721 8.39464 14.6178C8.39464 15.1635 8.17786 15.6869 7.79199 16.0727C7.40612 16.4586 6.88276 16.6754 6.33705 16.6754C5.79135 16.6754 5.26799 16.4586 4.88212 16.0727C4.49625 15.6869 4.27947 15.1635 4.27947 14.6178ZM20.0568 8.38181H17.1262M13.0101 8.38181H2.59564M13.0101 8.38181C13.0101 7.8361 13.2268 7.31274 13.6127 6.92687C13.9986 6.541 14.5219 6.32422 15.0676 6.32422C15.3379 6.32422 15.6054 6.37744 15.8551 6.48084C16.1047 6.58425 16.3315 6.73581 16.5226 6.92687C16.7136 7.11794 16.8652 7.34476 16.9686 7.5944C17.072 7.84404 17.1252 8.1116 17.1252 8.38181C17.1252 8.65201 17.072 8.91957 16.9686 9.16921C16.8652 9.41885 16.7136 9.64568 16.5226 9.83674C16.3315 10.0278 16.1047 10.1794 15.8551 10.2828C15.6054 10.3862 15.3379 10.4394 15.0676 10.4394C14.5219 10.4394 13.9986 10.2226 13.6127 9.83674C13.2268 9.45087 13.0101 8.92751 13.0101 8.38181Z" stroke="#007BFF" stroke-width="1.41577" stroke-miterlimit="10" stroke-linecap="round"></path>
                        </svg> <span class="text-blue fs-18">UX Design</span>
                    </div>-->
                </div>
				<?php if(empty($shortlist)){?>
				<div class="customDivCol px-4 mx-auto my-5">
				   <h3>Nothing to see here yet</h3>
				   <p>You haven’t added anything to this list. When you do, it’ll show up here so you can easily track your job journey.</p>
				   <div class="text-center">
					   <img src="<?php echo base_url(); ?>assets/newAssets/img/nodataRec.png" style="width: 400px;"> 
				   </div> 
				</div>
                <?php }else{ foreach($shortlist as $row){?>
                <div class="EmployeeCard position-relative mb-3">
                    <div class="urgentHire-btn">
                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                            <path d="M7 14V10.5C7 9.57174 7.36875 8.6815 8.02513 8.02513C8.6815 7.36875 9.57174 7 10.5 7C11.4283 7 12.3185 7.36875 12.9749 8.02513C13.6313 8.6815 14 9.57174 14 10.5V14M2.625 10.5H3.5M10.5 2.625V3.5M17.5 10.5H18.375M4.9 4.9L5.5125 5.5125M16.1 4.9L15.4875 5.5125M5.25 14.875C5.25 14.6429 5.34219 14.4204 5.50628 14.2563C5.67038 14.0922 5.89294 14 6.125 14H14.875C15.1071 14 15.3296 14.0922 15.4937 14.2563C15.6578 14.4204 15.75 14.6429 15.75 14.875V16.625C15.75 16.8571 15.6578 17.0796 15.4937 17.2437C15.3296 17.4078 15.1071 17.5 14.875 17.5H6.125C5.89294 17.5 5.67038 17.4078 5.50628 17.2437C5.34219 17.0796 5.25 16.8571 5.25 16.625V14.875Z" stroke="#FF6F42" stroke-width="1.575" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                        <span><?=$row->tag;?></span>
                    </div>
                    <div class="row mx-0">
                        <div class="col-md-7">
						<a href="<?=base_url('employer/employee-profile?id='.$row->emp_id);?>">
                            <div class="d-flex gap-2">
                                <img src="<?=$row->emp_profile;?>" alt="">
                                <div>
                                    <h6><?=$row->emp_name;?> </h6>
								
                                    <h5><?=$row->job_title;?> • <?=$row->experience;?></h5>
                                    <div class="quali mt-3">
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                                <path d="M12.5 6.5V12C12.5 12 9.574 13 8 13C6.426 13 3.5 12 3.5 12V6.5M14 5.5L8 3L2 5.5L8 8.5L14 5.5ZM14 5.5V10" stroke="#202020" stroke-opacity="0.8"></path>
                                            </svg> <?=$row->qualification;?>
                                        </span>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                                <path d="M13.3333 4.50065C13.72 4.50065 14.0333 4.63398 14.28 4.89398C14.5333 5.16732 14.6667 5.46732 14.6667 5.83398V13.1673C14.6667 13.534 14.5333 13.834 14.28 14.1073C14.0333 14.3673 13.72 14.5007 13.3333 14.5007H2.66668C2.28001 14.5007 1.96668 14.3673 1.72001 14.1073C1.46668 13.834 1.33334 13.534 1.33334 13.1673V5.83398C1.33334 5.46732 1.46668 5.16732 1.72001 4.89398C1.96668 4.63398 2.28001 4.50065 2.66668 4.50065H5.33334V3.16732C5.33334 2.78065 5.46668 2.46732 5.72001 2.22065C5.96668 1.96732 6.28001 1.83398 6.66668 1.83398H9.33334C9.72001 1.83398 10.0333 1.96732 10.28 2.22065C10.5333 2.46732 10.6667 2.78065 10.6667 3.16732V4.50065H13.3333ZM2.66668 5.83398V13.1673H13.3333V5.83398H2.66668ZM9.33334 4.50065V3.16732H6.66668V4.50065H9.33334Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg> <?=$row->job_type;?>
                                        </span>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                                <path d="M15.5 8.5C15.5 8.63261 15.4473 8.75979 15.3536 8.85355C15.2598 8.94732 15.1326 9 15 9H13.9581C13.839 9.69863 13.4768 10.3327 12.9355 10.7901C12.3943 11.2476 11.7087 11.499 11 11.5H8.5V13H10C10.5304 13 11.0391 13.2107 11.4142 13.5858C11.7893 13.9609 12 14.4696 12 15C12 15.1326 11.9473 15.2598 11.8536 15.3536C11.7598 15.4473 11.6326 15.5 11.5 15.5C11.3674 15.5 11.2402 15.4473 11.1464 15.3536C11.0527 15.2598 11 15.1326 11 15C11 14.7348 10.8946 14.4804 10.7071 14.2929C10.5196 14.1054 10.2652 14 10 14H8.5V15C8.5 15.1326 8.44732 15.2598 8.35355 15.3536C8.25979 15.4473 8.13261 15.5 8 15.5C7.86739 15.5 7.74021 15.4473 7.64645 15.3536C7.55268 15.2598 7.5 15.1326 7.5 15V14H6C5.73478 14 5.48043 14.1054 5.29289 14.2929C5.10536 14.4804 5 14.7348 5 15C5 15.1326 4.94732 15.2598 4.85355 15.3536C4.75979 15.4473 4.63261 15.5 4.5 15.5C4.36739 15.5 4.24021 15.4473 4.14645 15.3536C4.05268 15.2598 4 15.1326 4 15C4 14.4696 4.21071 13.9609 4.58579 13.5858C4.96086 13.2107 5.46957 13 6 13H7.5V11.5H5C4.2913 11.499 3.60574 11.2476 3.06445 10.7901C2.52316 10.3327 2.16097 9.69863 2.04187 9H1C0.867392 9 0.740215 8.94732 0.646447 8.85355C0.552678 8.75979 0.5 8.63261 0.5 8.5C0.5 8.36739 0.552678 8.24021 0.646447 8.14645C0.740215 8.05268 0.867392 8 1 8H2.5C2.63261 8 2.75979 8.05268 2.85355 8.14645C2.94732 8.24021 3 8.36739 3 8.5C3 9.03043 3.21071 9.53914 3.58579 9.91421C3.96086 10.2893 4.46957 10.5 5 10.5H11C11.5304 10.5 12.0391 10.2893 12.4142 9.91421C12.7893 9.53914 13 9.03043 13 8.5C13 8.36739 13.0527 8.24021 13.1464 8.14645C13.2402 8.05268 13.3674 8 13.5 8H15C15.1326 8 15.2598 8.05268 15.3536 8.14645C15.4473 8.24021 15.5 8.36739 15.5 8.5ZM4.24438 9.155C4.15058 9.0468 4.08111 8.91971 4.04067 8.78234C4.00024 8.64497 3.98978 8.50051 4.01 8.35875L4.8675 2.35875C4.90249 2.12085 5.02162 1.90337 5.20327 1.74581C5.38492 1.58824 5.61704 1.50103 5.8575 1.5H10.1425C10.383 1.50103 10.6151 1.58824 10.7967 1.74581C10.9784 1.90337 11.0975 2.12085 11.1325 2.35875L11.99 8.35875C12.0102 8.50057 11.9998 8.64509 11.9593 8.78251C11.9188 8.91994 11.8493 9.04706 11.7554 9.15528C11.6615 9.26349 11.5455 9.35028 11.4152 9.40975C11.2848 9.46923 11.1433 9.5 11 9.5H5C4.85668 9.5 4.71504 9.46919 4.58467 9.40967C4.4543 9.35015 4.33825 9.26329 4.24438 9.155ZM5 8.5H11L10.1425 2.5H5.85687L5 8.5Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg> <?=$row->employment_type;?>
                                        </span>
                                    </div>
                                </div>
                            </div></a>
                            <div class="d-flex gap-2 mt-3" style="overflow: auto;">
                                <div class="job-cat-btn"><?=$row->job_type;?></div>
                                        <div class="job-cat-btn"><?=$row->employment_type;?></div>
                                        <?php 
									$skills = explode(',', $row->skills);

									foreach ($skills as $skill) {
										$skill = trim($skill);

										if (!empty($skill)) {
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>
                            </div>
                        </div>
                        <div class="col-md-3 mt-2"></div>
                        <div class="col-md-2 cardbtnFlex align-self-end gap-3">
                            <div>
                                <button class="btn-outline-custom w-100" onclick="viewResume('<?=$row->resume;?>')">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
                                        <path d="M8.45625 7.66797C8.44531 7.64766 8.43437 7.63828 8.42188 7.63672C8.37656 7.68828 8.3875 8.12891 8.46406 8.43984C8.52656 8.22734 8.5375 7.80703 8.45625 7.66797ZM8.43125 9.55078C8.31094 9.86328 8.1375 10.2898 7.92969 10.6664C7.99219 10.6414 8.05625 10.6148 8.12187 10.5883C8.39687 10.4758 8.70469 10.3492 9.04219 10.2727C8.80938 10.0883 8.59844 9.83984 8.43125 9.55078Z" fill="#E6F2FF"></path>
                                        <path d="M8.84375 5.5V2.125H4.125V13.875H12.875V6.15625H9.5C9.32595 6.15625 9.15903 6.08711 9.03596 5.96404C8.91289 5.84097 8.84375 5.67405 8.84375 5.5ZM9.70312 9.99375C9.95469 9.96406 10.1812 9.95 10.3953 9.95781C10.5953 9.96406 10.7641 9.98906 10.8953 10.0375C10.8984 10.0391 10.9 10.0391 10.9031 10.0406C10.9094 10.0437 10.9156 10.0453 10.9219 10.0484C10.9297 10.0516 10.9391 10.0547 10.9469 10.0594C10.9484 10.0609 10.9516 10.0609 10.9531 10.0625C11.0172 10.0906 11.0703 10.125 11.1109 10.1656C11.2531 10.3078 11.2953 10.5734 11.2078 10.7844C11.1578 10.9047 11.025 11.1047 10.6875 11.1047C10.3469 11.1047 9.84531 10.9531 9.40469 10.7172C9.00625 10.7844 8.56563 10.9344 8.14062 11.0781C8.05 11.1094 7.95625 11.1406 7.86562 11.1703C7.27187 12.1891 6.82656 12.4109 6.55156 12.4109C6.48594 12.4109 6.42969 12.3969 6.38281 12.3797C6.275 12.3391 6.18281 12.2547 6.125 12.1453C6.11094 12.1187 6.1 12.0922 6.09062 12.0641C6.06562 11.9891 6.05781 11.9141 6.07031 11.8516L6.07969 11.8094C6.08125 11.8062 6.08125 11.8031 6.08281 11.8C6.08594 11.7891 6.08906 11.7781 6.09375 11.7672C6.09375 11.7656 6.09531 11.7641 6.09531 11.7625C6.15938 11.5766 6.30781 11.3969 6.52812 11.2219C6.72031 11.0688 6.95156 10.9297 7.24531 10.7781C7.49375 10.3406 7.83281 9.60469 8.04531 9.1C7.87656 8.44688 7.78437 7.93437 7.8875 7.55937C7.90156 7.50781 7.92656 7.45938 7.95937 7.41719C7.9625 7.41406 7.96406 7.41094 7.96719 7.40781C7.96875 7.40625 7.96875 7.40469 7.97031 7.40469C8.06875 7.2875 8.23438 7.21875 8.40938 7.225C8.66875 7.23594 8.87344 7.40469 8.925 7.69531C8.95156 7.82031 8.95937 7.95312 8.95469 8.09688V8.10781C8.95469 8.11563 8.95469 8.12344 8.95312 8.13125C8.94219 8.33906 8.90625 8.54687 8.83906 8.82969C8.83281 8.85469 8.82656 8.87969 8.82031 8.91094L8.80469 8.975L8.80313 8.97969C8.80469 8.98281 8.80469 8.98438 8.80625 8.9875L8.83438 9.05781C8.83594 9.0625 8.83906 9.06875 8.84062 9.07344C8.85156 9.09844 8.8625 9.125 8.87344 9.14844V9.15C9.00938 9.44375 9.18125 9.67188 9.40312 9.85469C9.47031 9.90938 9.54219 9.95937 9.62031 10.0078C9.64844 10 9.675 9.99687 9.70312 9.99375Z" fill="#E6F2FF"></path>
                                        <path d="M6.61719 11.8904C6.70625 11.8216 6.87031 11.6638 7.0875 11.3482C6.92656 11.4951 6.72187 11.6982 6.61719 11.8904ZM10.85 10.5935L10.8531 10.5888H10.8562C10.8656 10.5826 10.8641 10.5779 10.8625 10.5747C10.8609 10.5732 10.7922 10.4294 10.1578 10.4591C10.7094 10.6763 10.8375 10.6013 10.85 10.5935Z" fill="#E6F2FF"></path>
                                        <path d="M13.8531 4.50938L10.4906 1.14688C10.3969 1.05313 10.2703 1 10.1375 1H3.5C3.22344 1 3 1.22344 3 1.5V14.5C3 14.7766 3.22344 15 3.5 15H13.5C13.7766 15 14 14.7766 14 14.5V4.86406C14 4.73125 13.9469 4.60313 13.8531 4.50938ZM9.90625 2.15313L12.8469 5.09375H9.90625V2.15313ZM12.875 13.875H4.125V2.125H8.84375V5.5C8.84375 5.67405 8.91289 5.84097 9.03596 5.96404C9.15903 6.08711 9.32595 6.15625 9.5 6.15625H12.875V13.875Z" fill="#007BFF"></path>
                                        <path d="M8.87347 9.14434C8.86097 9.11778 8.85003 9.09278 8.83909 9.06778C8.83753 9.06309 8.8344 9.05684 8.83284 9.05215L8.80471 8.98184C8.80315 8.97872 8.80315 8.97715 8.80159 8.97403L8.80315 8.96934L8.80628 8.95215C8.86878 8.69746 8.94065 8.40059 8.95315 8.10215V8.09122C8.95784 7.95684 8.95003 7.82246 8.9219 7.69121C8.86253 7.3584 8.61721 7.22872 8.40784 7.21934C8.23128 7.21153 8.06721 7.28184 7.96878 7.39747C7.96721 7.39903 7.96721 7.40059 7.96565 7.40059C7.96253 7.40372 7.9594 7.40684 7.95784 7.40996C7.92503 7.45215 7.90003 7.50059 7.88596 7.55215C7.78284 7.92715 7.87503 8.43965 8.04378 9.09278C7.83128 9.59903 7.49221 10.3334 7.24378 10.7709V10.7725C6.81096 10.9959 6.24221 11.3318 6.09378 11.7553C6.09378 11.7568 6.09221 11.7584 6.09221 11.76C6.08909 11.7709 6.0844 11.7818 6.08128 11.7928C6.07972 11.7959 6.07971 11.799 6.07815 11.8022C6.07503 11.8162 6.07034 11.8303 6.06878 11.8443C6.05471 11.9068 6.06253 11.9818 6.08909 12.0568C6.09847 12.085 6.1094 12.1115 6.12346 12.1381C6.18128 12.2475 6.27346 12.3318 6.38128 12.3725C6.42815 12.3897 6.4844 12.4037 6.55003 12.4037C6.82503 12.4037 7.27034 12.1818 7.86409 11.1631C7.95471 11.1334 8.04846 11.1022 8.13909 11.0709C8.56409 10.9272 9.00471 10.7772 9.40315 10.71C9.84378 10.9459 10.3453 11.0975 10.686 11.0975C11.0235 11.0975 11.1563 10.8975 11.2063 10.7772C11.2938 10.5662 11.2516 10.3006 11.1094 10.1584C11.0688 10.1178 11.0157 10.0834 10.9516 10.0553C10.95 10.0537 10.9469 10.0537 10.9453 10.0522C10.9375 10.049 10.9282 10.0459 10.9203 10.0412C10.9141 10.0381 10.9078 10.0365 10.9016 10.0334C10.8985 10.0318 10.8969 10.0318 10.8938 10.0303C10.6407 9.93965 10.2422 9.92559 9.70159 9.98653L9.61878 9.9959C9.54065 9.94903 9.46878 9.89746 9.40159 9.84278C9.17972 9.66621 9.0094 9.43965 8.87347 9.14434ZM6.61721 11.8897C6.7219 11.6975 6.92659 11.4943 7.08753 11.3475C6.87034 11.6631 6.70628 11.8209 6.61721 11.8897ZM8.4219 7.63653C8.4344 7.63809 8.44534 7.64746 8.45628 7.66778C8.53753 7.80684 8.52659 8.22715 8.46409 8.43965C8.38753 8.12872 8.37659 7.68809 8.4219 7.63653ZM8.1219 10.5881C8.05628 10.6147 7.99221 10.6412 7.92971 10.6662C8.13753 10.2897 8.31097 9.86309 8.43128 9.55059C8.59846 9.83965 8.8094 10.0881 9.04222 10.2725C8.70472 10.349 8.3969 10.4756 8.1219 10.5881ZM10.8625 10.574C10.8641 10.5772 10.8657 10.5818 10.8563 10.5881H10.8532L10.85 10.5928C10.8375 10.6006 10.7094 10.6756 10.1578 10.4584C10.7922 10.4287 10.861 10.5725 10.8625 10.574Z" fill="#007BFF"></path>
                                    </svg> View Resume
                                </button>
                            </div>
                            <div>
								<button class="btn-custom w-100" onclick="window.location.href='<?=base_url('employer/chat?id='.$row->emp_id);?>'">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
									  <path d="M4.1665 15V18.1383L5.429 17.3808L9.39734 15H13.3332C14.2523 15 14.9998 14.2525 14.9998 13.3333V6.66667C14.9998 5.7475 14.2523 5 13.3332 5H3.33317C2.414 5 1.6665 5.7475 1.6665 6.66667V13.3333C1.6665 14.2525 2.414 15 3.33317 15H4.1665ZM3.33317 6.66667H13.3332V13.3333H8.93567L5.83317 15.195V13.3333H3.33317V6.66667Z" fill="white"/>
									  <path d="M16.6667 1.66602H6.66667C5.7475 1.66602 5 2.41352 5 3.33268H15C15.9192 3.33268 16.6667 4.08018 16.6667 4.99935V11.666C17.5858 11.666 18.3333 10.9185 18.3333 9.99935V3.33268C18.3333 2.41352 17.5858 1.66602 16.6667 1.66602Z" fill="white"/>
									</svg> Message
								</button>
                            </div>
                        </div>
                    </div>
                    <div class="text-end mt-3 px-2">
                        <span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                <path d="M16.25 5.08268L15.7333 13.4368C15.6017 15.571 15.5358 16.6385 15 17.406C14.7355 17.7853 14.3949 18.1054 14 18.346C13.2025 18.8327 12.1333 18.8327 9.995 18.8327C7.85333 18.8327 6.7825 18.8327 5.98333 18.3452C5.58824 18.1041 5.24768 17.7834 4.98333 17.4035C4.44833 16.6352 4.38333 15.566 4.255 13.4285L3.75 5.08268M2.5 5.08268H17.5M13.38 5.08268L12.8108 3.90935C12.4333 3.12935 12.2442 2.74018 11.9183 2.49685C11.846 2.44295 11.7693 2.39501 11.6892 2.35352C11.3283 2.16602 10.895 2.16602 10.0292 2.16602C9.14083 2.16602 8.69667 2.16602 8.32917 2.36102C8.24793 2.40452 8.17044 2.4547 8.0975 2.51102C7.76833 2.76352 7.58417 3.16768 7.21583 3.97518L6.71083 5.08268" stroke="#FD6161" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <span onclick="ApplicantStatus(<?=$row->id?>,2,'reject')" class="not-fit">Not Fit</span>
                        </span>
                    </div>
                </div>
				<?php }} ?>
            </div>
        </div>
	<?php require'applicationMob.php';?>
    <?php require'footer.php';?>
    <?php require'js.php';?>
</body>
</html>