<!DOCTYPE html>
<html lang="en">
<?php require'css.php';?>
<body>
    <div class="px-4 mb-5">
        <div class="customDivCol pt-4">
            <?php require'header.php';?>
        </div>
        <div class="">
            <div class="profile-nav mob-hide">
                <nav class="nav flex-column">
                    <a class="navlink" href="#profile">Profile</a>
                    <a class="navlink" href="#about">About</a>
                    <a class="navlink" href="#jobs">Jobs</a>
                    <a class="navlink" href="#insight">Insight</a>
                </nav>
            </div>
            <div class="col-md-9 mt-5 profileMarginStart">
                <div id="profile" class="section">
                    <div class="profileCard p-4 mb-3">
                        <div class="row mx-0">
                            <div class="col-md-2">
                                <div class="proimg">
                                    <img src="<?=$user->logo;?>" alt="">
                                </div>
                            </div>
                            <div class="col-md-10">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h4><?=$about->r_name ?? '';?></h4>
                                        <h5 style="color: rgba(32, 32, 32, 0.80);"><?=$about->r_desig ?? '';?></h5>
                                    </div>
                                    <div>
                                        <!--<svg data-bs-toggle="modal" data-bs-target="#myModal" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                            <path d="M1.5 19.5H22.5V21H1.5V19.5ZM19.05 6.75C19.65 6.15 19.65 5.25 19.05 4.65L16.35 1.95C15.75 1.35 14.85 1.35 14.25 1.95L3 13.2V18H7.8L19.05 6.75ZM15.3 3L18 5.7L15.75 7.95L13.05 5.25L15.3 3ZM4.5 16.5V13.8L12 6.3L14.7 9L7.2 16.5H4.5Z" fill="#202020" fill-opacity="0.9"/>
                                        </svg>-->
                                    </div>
                                </div>
                                <p class="small">Hiring For</p>
                                <div class="hiringDetails col-md-9">
                                    <div class="d-flex gap-3 p-2">
                                        <img src="<?=base_url('profile_pic/')?>user.png" alt="" class="user-icon">
                                        <div>
                                            <p class="fs-18 fw-500 mb-1"><?=$about->name ?? '';?></p>
                                            <p class="fs-14 fw-500 mb-1"><?=$this->common_model->orignalName($about->com_type ?? '') ?? '';?></p>
                                            <p class="fs-12">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" fill="none">
                                                <path d="M4.19312 3.27737C5.01935 2.4254 6.13174 1.95094 7.28856 1.95709C8.44539 1.96324 9.55317 2.4495 10.3712 3.3102C11.1892 4.1709 11.6513 5.3365 11.6572 6.5537C11.663 7.7709 11.2121 8.94135 10.4024 9.8107L8.08167 12.2525C7.87374 12.4712 7.59176 12.5941 7.29775 12.5941C7.00374 12.5941 6.72176 12.4712 6.51383 12.2525L4.19312 9.8107C3.36977 8.94429 2.90723 7.76925 2.90723 6.54403C2.90723 5.31881 3.36977 4.14377 4.19312 3.27737Z" stroke="#202020" stroke-opacity="0.8" stroke-linejoin="round"/>
                                                <path d="M7.29796 8.29297C8.21652 8.29297 8.96116 7.50947 8.96116 6.54297C8.96116 5.57647 8.21652 4.79297 7.29796 4.79297C6.3794 4.79297 5.63477 5.57647 5.63477 6.54297C5.63477 7.50947 6.3794 8.29297 7.29796 8.29297Z" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"/>
                                            </svg><?=$about->city ?? '';?></p>
                                        </div>
                                    </div>
                                   <!-- <p class="border-top p-3 mb-0"><?=$about->c_desc ?? '';?></p>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="about" class="section">
                    <div class="profileCard p-4 mb-3">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4>Overview</h4>
                                <p class="text-muted mt-3">
                                    <?=$about->c_desc ?? '';?>
                                </p>
                            </div>
                            <div>
                                <svg data-bs-toggle="modal" data-bs-target="#myModal" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path d="M1.5 19.5H22.5V21H1.5V19.5ZM19.05 6.75C19.65 6.15 19.65 5.25 19.05 4.65L16.35 1.95C15.75 1.35 14.85 1.35 14.25 1.95L3 13.2V18H7.8L19.05 6.75ZM15.3 3L18 5.7L15.75 7.95L13.05 5.25L15.3 3ZM4.5 16.5V13.8L12 6.3L14.7 9L7.2 16.5H4.5Z" fill="#202020" fill-opacity="0.9"></path>
                                </svg>
                            </div>
                        </div>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                <g clip-path="url(#clip0_1970_6628)">
                                <path d="M13.5 7.5C13.5 9.22391 12.8152 10.8772 11.5962 12.0962C10.3772 13.3152 8.72391 14 7 14C5.27609 14 3.62279 13.3152 2.40381 12.0962C1.18482 10.8772 0.5 9.22391 0.5 7.5M13.5 7.5C13.5 5.77609 12.8152 4.12279 11.5962 2.90381C10.3772 1.68482 8.72391 1 7 1C5.27609 1 3.62279 1.68482 2.40381 2.90381C1.18482 4.12279 0.5 5.77609 0.5 7.5M13.5 7.5H0.5" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M9.5 7.5C9.3772 9.87699 8.50168 12.1533 7 14C5.49832 12.1533 4.6228 9.87699 4.5 7.5C4.6228 5.12301 5.49832 2.84665 7 1C8.50168 2.84665 9.3772 5.12301 9.5 7.5Z" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_1970_6628">
                                    <rect width="14" height="14" fill="white" transform="translate(0 0.5)"/>
                                </clipPath>
                                </defs>
                            </svg> Website
                        </h6>
                        <p>
                            <a href="<?=$about->link ?? '';?>" target="_blank" class="fs-14"><?=$about->link ?? '';?></a>
                        </p>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                <path d="M14.25 2.75C14.6478 2.75 15.0294 2.90804 15.3107 3.18934C15.592 3.47064 15.75 3.85218 15.75 4.25V14.75C15.75 15.1478 15.592 15.5294 15.3107 15.8107C15.0294 16.092 14.6478 16.25 14.25 16.25H3.75C3.35218 16.25 2.97064 16.092 2.68934 15.8107C2.40804 15.5294 2.25 15.1478 2.25 14.75V4.25C2.25 3.85218 2.40804 3.47064 2.68934 3.18934C2.97064 2.90804 3.35218 2.75 3.75 2.75H14.25ZM13.875 14.375V10.4C13.875 9.75155 13.6174 9.12965 13.1589 8.67112C12.7003 8.2126 12.0785 7.955 11.43 7.955C10.7925 7.955 10.05 8.345 9.69 8.93V8.0975H7.5975V14.375H9.69V10.6775C9.69 10.1 10.155 9.6275 10.7325 9.6275C11.011 9.6275 11.278 9.73812 11.475 9.93504C11.6719 10.132 11.7825 10.399 11.7825 10.6775V14.375H13.875ZM5.16 6.92C5.49417 6.92 5.81466 6.78725 6.05095 6.55095C6.28725 6.31466 6.42 5.99417 6.42 5.66C6.42 4.9625 5.8575 4.3925 5.16 4.3925C4.82384 4.3925 4.50144 4.52604 4.26374 4.76374C4.02604 5.00144 3.8925 5.32384 3.8925 5.66C3.8925 6.3575 4.4625 6.92 5.16 6.92ZM6.2025 14.375V8.0975H4.125V14.375H6.2025Z" fill="#202020"/>
                            </svg> LinkedIn
                        </h6>
                        <p>
                            <a href="<?=$about->linkedin ?? '';?>" target="_blank" class="fs-14"><?=$about->linkedin ?? '';?></a>
                        </p>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                <path d="M4.965 8.5925C6.045 10.715 7.785 12.4475 9.9075 13.535L11.5575 11.885C11.76 11.6825 12.06 11.615 12.3225 11.705C13.1625 11.9825 14.07 12.1325 15 12.1325C15.4125 12.1325 15.75 12.47 15.75 12.8825V15.5C15.75 15.9125 15.4125 16.25 15 16.25C7.9575 16.25 2.25 10.5425 2.25 3.5C2.25 3.0875 2.5875 2.75 3 2.75H5.625C6.0375 2.75 6.375 3.0875 6.375 3.5C6.375 4.4375 6.525 5.3375 6.8025 6.1775C6.885 6.44 6.825 6.7325 6.615 6.9425L4.965 8.5925Z" fill="#202020"/>
                            </svg> Phone
                        </h6>
                        <p>
                            <a href="" class="fs-14"><?=$user->c_contact ?? '';?></a>
                        </p>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                <path d="M4.71383 4.06867C5.77613 2.97328 7.20635 2.36327 8.69369 2.37117C10.181 2.37907 11.6053 3.00426 12.6571 4.11088C13.7088 5.2175 14.303 6.71612 14.3105 8.28109C14.318 9.84607 13.7382 11.3509 12.6972 12.4687L9.7134 15.6082C9.44606 15.8894 9.08352 16.0473 8.7055 16.0473C8.32749 16.0473 7.96495 15.8894 7.69761 15.6082L4.71383 12.4687C3.65525 11.3547 3.06055 9.84395 3.06055 8.26867C3.06055 6.69339 3.65525 5.18262 4.71383 4.06867Z" stroke="#202020" stroke-linejoin="round"/>
                                <path d="M8.70578 10.5195C9.88678 10.5195 10.8442 9.51217 10.8442 8.26953C10.8442 7.02689 9.88678 6.01953 8.70578 6.01953C7.52478 6.01953 6.56738 7.02689 6.56738 8.26953C6.56738 9.51217 7.52478 10.5195 8.70578 10.5195Z" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg> Location
                        </h6>
                        <p>
                            <a href="" class="fs-14"><?=$about->adress ?? '';?></a>
                        </p>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                <path d="M17.25 4.25V14.75C17.25 15.1625 17.1032 15.5157 16.8097 15.8097C16.5162 16.1038 16.163 16.2505 15.75 16.25H13.5C13.2875 16.25 13.1095 16.178 12.966 16.034C12.8225 15.89 12.7505 15.712 12.75 15.5C12.7495 15.288 12.8215 15.11 12.966 14.966C13.1105 14.822 13.2885 14.75 13.5 14.75H15.75V4.25H9V4.625C9 4.8375 8.928 5.01575 8.784 5.15975C8.64 5.30375 8.462 5.3755 8.25 5.375C8.038 5.3745 7.86 5.3025 7.716 5.159C7.572 5.0155 7.5 4.8375 7.5 4.625V4.2125C7.5 3.8125 7.64375 3.46875 7.93125 3.18125C8.21875 2.89375 8.5625 2.75 8.9625 2.75H15.75C16.1625 2.75 16.5157 2.897 16.8097 3.191C17.1037 3.485 17.2505 3.838 17.25 4.25ZM0.75 9.51875C0.75 9.26875 0.80625 9.0375 0.91875 8.825C1.03125 8.6125 1.1875 8.4375 1.3875 8.3L5.1375 5.61875C5.275 5.51875 5.41575 5.44675 5.55975 5.40275C5.70375 5.35875 5.8505 5.337 6 5.3375C6.1495 5.338 6.2965 5.36 6.441 5.4035C6.5855 5.447 6.726 5.51875 6.8625 5.61875L10.6125 8.3C10.8125 8.4375 10.9687 8.6125 11.0812 8.825C11.1937 9.0375 11.25 9.26875 11.25 9.51875V14.75C11.25 15.1625 11.1032 15.5157 10.8097 15.8097C10.5162 16.1038 10.163 16.2505 9.75 16.25H8.25C7.8375 16.25 7.4845 16.1033 7.191 15.8097C6.8975 15.5162 6.7505 15.163 6.75 14.75V12.5H5.25V14.75C5.25 15.1625 5.10325 15.5157 4.80975 15.8097C4.51625 16.1038 4.163 16.2505 3.75 16.25H2.25C1.8375 16.25 1.4845 16.1033 1.191 15.8097C0.8975 15.5162 0.7505 15.163 0.75 14.75V9.51875ZM2.25 9.5V14.75H3.75V12.5C3.75 12.0875 3.897 11.7345 4.191 11.441C4.485 11.1475 4.838 11.0005 5.25 11H6.75C7.1625 11 7.51575 11.147 7.80975 11.441C8.10375 11.735 8.2505 12.088 8.25 12.5V14.75H9.75V9.5L6 6.8375L2.25 9.5ZM13.125 7.25H13.875C13.975 7.25 14.0625 7.2125 14.1375 7.1375C14.2125 7.0625 14.25 6.975 14.25 6.875V6.125C14.25 6.025 14.2125 5.9375 14.1375 5.8625C14.0625 5.7875 13.975 5.75 13.875 5.75H13.125C13.025 5.75 12.9375 5.7875 12.8625 5.8625C12.7875 5.9375 12.75 6.025 12.75 6.125V6.875C12.75 6.975 12.7875 7.0625 12.8625 7.1375C12.9375 7.2125 13.025 7.25 13.125 7.25ZM13.125 10.25H13.875C13.975 10.25 14.0625 10.2125 14.1375 10.1375C14.2125 10.0625 14.25 9.975 14.25 9.875V9.125C14.25 9.025 14.2125 8.9375 14.1375 8.8625C14.0625 8.7875 13.975 8.75 13.875 8.75H13.125C13.025 8.75 12.9375 8.7875 12.8625 8.8625C12.7875 8.9375 12.75 9.025 12.75 9.125V9.875C12.75 9.975 12.7875 10.0625 12.8625 10.1375C12.9375 10.2125 13.025 10.25 13.125 10.25ZM13.125 13.25H13.875C13.975 13.25 14.0625 13.2125 14.1375 13.1375C14.2125 13.0625 14.25 12.975 14.25 12.875V12.125C14.25 12.025 14.2125 11.9375 14.1375 11.8625C14.0625 11.7875 13.975 11.75 13.875 11.75H13.125C13.025 11.75 12.9375 11.7875 12.8625 11.8625C12.7875 11.9375 12.75 12.025 12.75 12.125V12.875C12.75 12.975 12.7875 13.0625 12.8625 13.1375C12.9375 13.2125 13.025 13.25 13.125 13.25Z" fill="#202020"/>
                            </svg> Company Size
                        </h6>
                        <p class="fs-14 text-muted">
                            <?=$about->n_emp ?? '';?>+ Employees
                        </p>
                        <h6>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                            <path d="M8.25 13.25H9.75V8.75H8.25V13.25ZM9 7.25C9.2125 7.25 9.39075 7.178 9.53475 7.034C9.67875 6.89 9.7505 6.712 9.75 6.5C9.7495 6.288 9.6775 6.11 9.534 5.966C9.3905 5.822 9.2125 5.75 9 5.75C8.7875 5.75 8.6095 5.822 8.466 5.966C8.3225 6.11 8.2505 6.288 8.25 6.5C8.2495 6.712 8.3215 6.89025 8.466 7.03475C8.6105 7.17925 8.7885 7.251 9 7.25ZM9 17C7.9625 17 6.9875 16.803 6.075 16.409C5.1625 16.015 4.36875 15.4808 3.69375 14.8063C3.01875 14.1318 2.4845 13.338 2.091 12.425C1.6975 11.512 1.5005 10.537 1.5 9.5C1.4995 8.463 1.6965 7.488 2.091 6.575C2.4855 5.662 3.01975 4.86825 3.69375 4.19375C4.36775 3.51925 5.1615 2.985 6.075 2.591C6.9885 2.197 7.9635 2 9 2C10.0365 2 11.0115 2.197 11.925 2.591C12.8385 2.985 13.6323 3.51925 14.3063 4.19375C14.9803 4.86825 15.5147 5.662 15.9097 6.575C16.3047 7.488 16.5015 8.463 16.5 9.5C16.4985 10.537 16.3015 11.512 15.909 12.425C15.5165 13.338 14.9823 14.1318 14.3063 14.8063C13.6303 15.4808 12.8365 16.0152 11.925 16.4097C11.0135 16.8042 10.0385 17.001 9 17ZM9 15.5C10.675 15.5 12.0937 14.9187 13.2562 13.7562C14.4187 12.5937 15 11.175 15 9.5C15 7.825 14.4187 6.40625 13.2562 5.24375C12.0937 4.08125 10.675 3.5 9 3.5C7.325 3.5 5.90625 4.08125 4.74375 5.24375C3.58125 6.40625 3 7.825 3 9.5C3 11.175 3.58125 12.5937 4.74375 13.7562C5.90625 14.9187 7.325 15.5 9 15.5Z" fill="#202020"/>
                        </svg> Industry</h6>
                        <p class="fs-14 text-muted mb-0">
                            <?=$this->common_model->orignalName($about->com_type ?? '') ?? '';?>
                        </p>
                    </div>
                </div>
                <div id="jobs" class="section">
                    <div class="profileCard p-4 mb-3">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <h4>Recent Job Listings</h4>
                            </div>
                            <div>
                               
                            </div>
                        </div>
                        <?php foreach($active as $row){ ?>
                        
							<div class="manage-job-card position-relative border mb-3">
                            <div class="urgentHire-btn top-0">
							
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                                    <path d="M7 14V10.5C7 9.57174 7.36875 8.6815 8.02513 8.02513C8.6815 7.36875 9.57174 7 10.5 7C11.4283 7 12.3185 7.36875 12.9749 8.02513C13.6313 8.6815 14 9.57174 14 10.5V14M2.625 10.5H3.5M10.5 2.625V3.5M17.5 10.5H18.375M4.9 4.9L5.5125 5.5125M16.1 4.9L15.4875 5.5125M5.25 14.875C5.25 14.6429 5.34219 14.4204 5.50628 14.2563C5.67038 14.0922 5.89294 14 6.125 14H14.875C15.1071 14 15.3296 14.0922 15.4937 14.2563C15.6578 14.4204 15.75 14.6429 15.75 14.875V16.625C15.75 16.8571 15.6578 17.0796 15.4937 17.2437C15.3296 17.4078 15.1071 17.5 14.875 17.5H6.125C5.89294 17.5 5.67038 17.4078 5.50628 17.2437C5.34219 17.0796 5.25 16.8571 5.25 16.625V14.875Z" stroke="#FF6F42" stroke-width="1.575" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                                <span> Urgent Hiring</span>
                            </div>
                            <div class="position-absolute fs-12 start-0 bottom-0" style="border-radius: 0px 15px 0px 0px;
                            background: #EEF6FF;padding: 6px 4px;">
                                Posted <?=$row->job_created_at;?>
                            </div>
                            <div class="row mx-auto">
                                <div class="col-md-7">
                                    <h5><?=$row->job_title;?> (<?=$row->salary_min;?><?=$row->salary_type;?> - <?=$row->salary_max;?><?=$row->salary_type;?>)</h5>
                                    <p class="fs-14 mt-4">  </p>
                                    <div class="quali">
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                                <path d="M10.8917 8.92373C11.3979 8.21645 11.67 7.36849 11.67 6.49873C11.67 5.62897 11.3979 4.78101 10.8917 4.07373C11.3656 3.75084 11.9265 3.57939 12.5 3.58206C13.2735 3.58206 14.0154 3.88935 14.5624 4.43633C15.1094 4.98332 15.4167 5.72518 15.4167 6.49873C15.4167 7.27228 15.1094 8.01414 14.5624 8.56112C14.0154 9.1081 13.2735 9.4154 12.5 9.4154C11.9265 9.41806 11.3656 9.24662 10.8917 8.92373ZM4.58332 6.49873C4.58332 5.92187 4.75438 5.35796 5.07487 4.87832C5.39536 4.39867 5.85088 4.02484 6.38383 3.80408C6.91678 3.58332 7.50323 3.52556 8.069 3.6381C8.63478 3.75065 9.15448 4.02843 9.56238 4.43633C9.97029 4.84424 10.2481 5.36394 10.3606 5.92972C10.4732 6.49549 10.4154 7.08194 10.1946 7.61489C9.97388 8.14784 9.60005 8.60336 9.1204 8.92385C8.64076 9.24434 8.07685 9.4154 7.49999 9.4154C6.72644 9.4154 5.98458 9.1081 5.4376 8.56112C4.89061 8.01414 4.58332 7.27228 4.58332 6.49873ZM6.24999 6.49873C6.24999 6.74595 6.3233 6.98763 6.46065 7.19319C6.598 7.39875 6.79323 7.55897 7.02164 7.65358C7.25004 7.74819 7.50138 7.77294 7.74385 7.72471C7.98633 7.67648 8.20906 7.55743 8.38387 7.38261C8.55869 7.2078 8.67774 6.98507 8.72597 6.74259C8.7742 6.50012 8.74945 6.24878 8.65484 6.02037C8.56023 5.79197 8.40001 5.59674 8.19445 5.45939C7.98889 5.32204 7.74722 5.24873 7.49999 5.24873C7.16847 5.24873 6.85053 5.38042 6.61611 5.61484C6.38169 5.84927 6.24999 6.16721 6.24999 6.49873ZM13.3333 14.4154V16.0821H1.66666V14.4154C1.66666 14.4154 1.66666 11.0821 7.49999 11.0821C13.3333 11.0821 13.3333 14.4154 13.3333 14.4154ZM11.6667 14.4154C11.55 13.7654 10.5583 12.7487 7.49999 12.7487C4.44166 12.7487 3.39166 13.8404 3.33332 14.4154M13.2917 11.0821C13.8024 11.4793 14.22 11.9836 14.5151 12.5595C14.8103 13.1353 14.9758 13.7688 15 14.4154V16.0821H18.3333V14.4154C18.3333 14.4154 18.3333 11.3904 13.2833 11.0821H13.2917Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg>
                                            <?=$row->total_applicant;?> Applicants
                                        </span>
                                        <span>
                                            <img src="<?=base_url('assets/newAssets/img/')?>grommet-icons.svg" alt="">
                                            <?=$row->total_rejected;?> Rejected
                                        </span>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                                <g clip-path="url(#clip0_1891_4549)">
                                                  <path d="M8.45477 8.70703L11.5452 11.7974M11.5452 8.70703L8.45477 11.7974" stroke="#FF3232" stroke-width="0.64" stroke-linecap="round" stroke-linejoin="round"></path>
                                                  <path d="M4.84913 0.980469H16.1808C16.454 0.980469 16.716 1.08898 16.9091 1.28214C17.1023 1.4753 17.2108 1.73728 17.2108 2.01044V18.493C17.2108 18.7661 17.1023 19.0281 16.9091 19.2213C16.716 19.4144 16.454 19.5229 16.1808 19.5229H3.81916C3.54599 19.5229 3.28401 19.4144 3.09086 19.2213C2.8977 19.0281 2.78918 18.7661 2.78918 18.493V3.04091M4.84913 0.980469L2.78918 3.04091M4.84913 0.980469V3.04091H2.78918" stroke="#FF4747" stroke-width="0.64" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </g>
                                                <defs>
                                                  <clipPath id="clip0_1891_4549">
                                                    <rect width="20" height="20" fill="white" transform="translate(0 0.25)"></rect>
                                                  </clipPath>
                                                </defs>
                                            </svg> <?=$row->employment_type;?>
                                        </span>
                                    </div>
                                    <div class="d-flex gap-2 mt-3 fs-14" style="overflow: hidden;">
                                        <div class="job-cat-btn"><?=$row->job_type;?></div>
                                        <div class="job-cat-btn"><?=$row->employment_type;?></div>
                                        <?php 
									$skills = explode(',', $row->job_skills);

									foreach ($skills as $skill) {
										$skill = trim($skill);

										if (!empty($skill)) {
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>
                                    </div>
                                </div>
                                <div class="col-md-2 mt-2"></div>
                                <div class="col-md-3 my-auto cardbtnFlex align-self-end gap-3">
                                    <button class="btn-outline-red w-100 " onclick="Status(<?=$row->job_id?>,1,'inactive')">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                            <path d="M11.25 5.5L4.75 12M4.75 5.5L11.25 12" stroke="#FF4747" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>
                                        Close Job
                                    </button>
                                    <a href="<?=base_url('employer/add-job?id='.$row->job_id)?>" class="btn-custom w-100 text-center"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                        <path d="M1 13.75H15V14.75H1V13.75ZM12.7 5.25C13.1 4.85 13.1 4.25 12.7 3.85L10.9 2.05C10.5 1.65 9.9 1.65 9.5 2.05L2 9.55V12.75H5.2L12.7 5.25ZM10.2 2.75L12 4.55L10.5 6.05L8.7 4.25L10.2 2.75ZM3 11.75V9.95L8 4.95L9.8 6.75L4.8 11.75H3Z" fill="white"></path>
                                      </svg> Edit Job</a>
                                </div>
								
								
                            </div>
							
                            <div class="d-flex justify-content-end gap-2 mb-2">
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                        <path d="M12.5673 7.24891C12.7446 7.49741 12.8333 7.62224 12.8333 7.80599C12.8333 7.99032 12.7446 8.11457 12.5673 8.36307C11.7705 9.48074 9.73521 11.8893 6.99996 11.8893C4.26413 11.8893 2.22946 9.48016 1.43263 8.36307C1.25529 8.11457 1.16663 7.98974 1.16663 7.80599C1.16663 7.62166 1.25529 7.49741 1.43263 7.24891C2.22946 6.13124 4.26471 3.72266 6.99996 3.72266C9.73579 3.72266 11.7705 6.13182 12.5673 7.24891Z" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M8.75 7.80469C8.75 7.34056 8.56563 6.89544 8.23744 6.56725C7.90925 6.23906 7.46413 6.05469 7 6.05469C6.53587 6.05469 6.09075 6.23906 5.76256 6.56725C5.43437 6.89544 5.25 7.34056 5.25 7.80469C5.25 8.26882 5.43437 8.71394 5.76256 9.04212C6.09075 9.37031 6.53587 9.55469 7 9.55469C7.46413 9.55469 7.90925 9.37031 8.23744 9.04212C8.56563 8.71394 8.75 8.26882 8.75 7.80469Z" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg> <?=$row->views;?> Views
                                </span>
                               
                            </div>
                        </div>
                       <?php } ?>
                       
                    </div>
                </div>
                <div id="insight" class="section">
                    <div class="profileCard p-4 mb-3">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <h4>Your Recruitment Journey in Numbers</h4>
                            </div>
                            <div>
                                <select class="form-control btn-outline-custom" id="job_id" onchange="loadInsights();">
								<?php foreach($active as $row){?>
								<option value='<?=$row->job_id;?>' ><?=$row->job_title?></option>
								<?php } ?>
								</select>
                               
                            </div>
                        </div>
                        <div class="p-3" style="border-radius: 18px;border: 2px solid rgba(0, 0, 0, 0.10);">
                            <div class="chart-container">
                                <canvas id="jobPostingsChart"></canvas>
                            </div>
                            <div class="d-flex justify-content-between mt-5 mb-3">
                                <h5 class="my-auto">Your Active Job Postings by Role</h5>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23" fill="none">
                                        <path d="M20.0568 14.6178H8.39559M4.27947 14.6178H2.59564M4.27947 14.6178C4.27947 14.0721 4.49625 13.5487 4.88212 13.1629C5.26799 12.777 5.79135 12.5602 6.33705 12.5602C6.88276 12.5602 7.40612 12.777 7.79199 13.1629C8.17786 13.5487 8.39464 14.0721 8.39464 14.6178C8.39464 15.1635 8.17786 15.6869 7.79199 16.0727C7.40612 16.4586 6.88276 16.6754 6.33705 16.6754C5.79135 16.6754 5.26799 16.4586 4.88212 16.0727C4.49625 15.6869 4.27947 15.1635 4.27947 14.6178ZM20.0568 8.38181H17.1262M13.0101 8.38181H2.59564M13.0101 8.38181C13.0101 7.8361 13.2268 7.31274 13.6127 6.92687C13.9986 6.541 14.5219 6.32422 15.0676 6.32422C15.3379 6.32422 15.6054 6.37744 15.8551 6.48084C16.1047 6.58425 16.3315 6.73581 16.5226 6.92687C16.7136 7.11794 16.8652 7.34476 16.9686 7.5944C17.072 7.84404 17.1252 8.1116 17.1252 8.38181C17.1252 8.65201 17.072 8.91957 16.9686 9.16921C16.8652 9.41885 16.7136 9.64568 16.5226 9.83674C16.3315 10.0278 16.1047 10.1794 15.8551 10.2828C15.6054 10.3862 15.3379 10.4394 15.0676 10.4394C14.5219 10.4394 13.9986 10.2226 13.6127 9.83674C13.2268 9.45087 13.0101 8.92751 13.0101 8.38181Z" stroke="#007BFF" stroke-width="1.41577" stroke-miterlimit="10" stroke-linecap="round"></path>
                                    </svg> <span class="text-blue fs-18">Today</span>
                                </div>
                            </div>
                            <div class="d-flex justify-content-between border-bottom mb-3">
                                <p class="text-muted mb-1">Job Title</p>
                                <p class="text-muted mb-1">Application</p>
                            </div>
                            <?php foreach($activeJobRoles as $row){?>
							<div class="d-flex justify-content-between my-2">
								<span class="fw-500" style="color: rgba(32, 32, 32, 0.80);"><?=$row->jTitle;?></span>
								<span class="fw-bold"><?=$row->applicant_count;?></span>
							</div>
							<?php }?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php require'footer.php';?>
    <?php require'js.php';?>

    <script>
        $(document).ready(function() {
			loadInsights();
			
            $(window).on("scroll", function() {
                var scrollPos = $(document).scrollTop();
                $(".navlink").each(function() {
                    var section = $($(this).attr("href"));
                    if (section.position().top <= scrollPos + 100 && section.position().top + section.height() > scrollPos) {
                        $(".navlink").removeClass("active");
                        $(this).addClass("active");
                    }
                });
            });
        });
		
  
		let jobPostingsChart; // Declare the chart outside the function to have global scope

function renderChart(chartData) {
    const ctx = document.getElementById('jobPostingsChart').getContext('2d');

    // Destroy the previous chart if it exists
    if (jobPostingsChart) {
        jobPostingsChart.destroy();
    }

    // Create the new chart
    jobPostingsChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: chartData.dates,
            datasets: [
                {
                    label: 'Application',
                    data: chartData.applicant,
                    borderColor: '#007bff',
                    backgroundColor: 'rgba(0, 123, 255, 0.1)',
                    fill: true,
                    tension: 0.4
                },
                {
                    label: 'Shortlisted',
                    data: chartData.shortlist,
                    borderColor: '#28a745',
                    backgroundColor: 'rgba(40, 167, 69, 0.1)',
                    fill: true,
                    tension: 0.4
                },
                {
                    label: 'Rejected',
                    data: chartData.rejected,
                    borderColor: '#dc3545',
                    backgroundColor: 'rgba(220, 53, 69, 0.1)',
                    fill: true,
                    tension: 0.4
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                tooltip: {
                    mode: 'index',
                    intersect: false
                },
                legend: {
                    display: true,
                    position: 'top'
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    }
                },
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(200, 200, 200, 0.3)'
                    },
                    ticks: {
                        stepSize: 30
                    }
                }
            }
        }
    });
}
		function loadInsights() {
			id=$('#job_id').val();
			// alert(id);
			$.ajax({
				url: "<?= base_url('employer/get_insight'); ?>",
				type: "POST",
				data: {id: id},
				dataType: "json",
				success: function(response) {
					renderChart(response);
				}
			});
		}

    </script>
</body>
</html>
