
<style>
.colored-toast.swal2-icon-success {
  background-color: #00ac46 !important;
}

.colored-toast.swal2-icon-error {
  background-color: #d32536 !important;
}

.colored-toast.swal2-icon-warning {
  background-color: #f8bb86 !important;
}

.colored-toast.swal2-icon-info {
  background-color: #3fc3ee !important;
}

.colored-toast.swal2-icon-question {
  background-color: #87adbd !important;
}

.colored-toast .swal2-title {
  color: white;
}

.colored-toast .swal2-close {
  color: white;
}

.colored-toast .swal2-html-container {
  color: white;
}
	</style>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/notify/0.4.2/notify.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
 <?php require'push_notification_website.php';?>
<script>

// var myCarousel = document.querySelector('#demo')
	// var carousel = new bootstrap.Carousel(myCarousel, {
	// interval: 1000,
// })

const Toast = Swal.mixin({  
	  toast: true,
	  position: 'top',
	  iconColor: 'white',
	  customClass: {
		popup: 'colored-toast',
	  },
	  showConfirmButton: false,
	  timer: 3000,
	  timerProgressBar: true,
	  didOpen: (toast) => {
		toast.addEventListener('mouseenter', Swal.stopTimer)
		toast.addEventListener('mouseleave', Swal.resumeTimer)
	  }
});

function handleFormSubmission(formId, submitBtnId, submitSpinId) {
    $(formId).on('submit', function (e) {
        e.preventDefault();
        var data = new FormData(this);
        
        if ($(this).parsley().isValid()) {
            $.ajax({
                type: $(this).attr('method'),
                url: $(this).attr('action'),
                data: data,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    $(submitBtnId).attr("disabled", true);
                    $(submitSpinId).show();
                },
                success: function (response) {
                    $(submitBtnId).removeAttr("disabled");
                    $(submitSpinId).hide();
                    var response = JSON.parse(response);

                    if (response.res == 'success') {
                        Toast.fire({
                            icon: 'success',
                            title: response.msg,
                        });

                        $(formId)[0].reset();

                        if (response.isRedirect) {
                            setTimeout(function () {
                                if (response.wayOfRedirect === 'reload') {
                                    window.location.reload();
                                } else if (response.wayOfRedirect === 'redirect') {
                                    window.location.href = response.redirectLink;
                                }
                            }, 700);
                        }
                    } else {
                        Toast.fire({
                            icon: 'error',
                            title: response.msg,
                        });
                    }
                },
                error: function (err) {
                    $(submitBtnId).removeAttr("disabled");
                    $(submitSpinId).hide();
                    Toast.fire({
                        icon: 'error',
                        title: 'Server-side error',
                    });
                    console.log('Error:', err);
                }
            });
        } else {
            Toast.fire({
                icon: 'warning',
                title: 'CDN missing, please refresh the page.',
            });
            return false;
        }
    });
} 

// Call the function for each form
handleFormSubmission("#submitForm", "#submitBtn", "#submitSpin");
handleFormSubmission("#submitForm2", "#submitBtn2", "#submitSpin2");
handleFormSubmission("#submitForm3", "#submitBtn3", "#submitSpin3");
handleFormSubmission("#submitForm4", "#submitBtn4", "#submitSpin4");
handleFormSubmission("#submitForm5", "#submitBtn5", "#submitSpin5");

function DeleteData(url,table,where_column,where_value){
	Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: { 'table': table, 'where_column': where_column, 'where_value': where_value},
                    success: function(response) {
                        // alert(response);
                        console.log(response);
                        var response = JSON.parse(response);
                        if (response.res == 'success') {
							Toast.fire({
							  icon: 'success',
							  title: response.msg,
							})
						}else{
							Toast.fire({
							  icon: 'error',
							  title: response.msg,
							})
						}
						
                        if (response.isRedirect == true) {
                            if (response.wayOfRedirect == 'reload') {
                                window.setTimeout(function() {
                                    window.location.reload();
                                }, 800);
                                } else if (response.wayOfRedirect == 'redirect') {
                                window.setTimeout(function() {
                                    window.location.href = response.redirectLink;
                                }, 800);
                            }
                        }
                    },
                    error: function() {
						Toast.fire({
						  icon: 'error',
						  title: 'something went wrong! Please check JS Code',
						})
                    }
                });
            }
        })
}

function getDistrict() {
    var state_id = $("#state_id").val();
    if(state_id) {
        $.ajax({
            url: "<?= base_url('employer/get_districts'); ?>",
            type: "POST",
            data: {state_id: state_id},
            dataType: "json",
            success: function(response) {
                $("#district_id").html('<option value="">Choose</option>');
                $.each(response, function(index, value) {
                    $("#district_id").append('<option value="'+value.districtid+'">'+value.district_title+'</option>');
                });
            }
        });
    }
}

function getCity() {
    var district_id = $("#district_id").val();
    if(district_id) {
        $.ajax({
            url: "<?= base_url('employer/get_cities'); ?>",
            type: "POST",
            data: {district_id: district_id},
            dataType: "json",
            success: function(response) {
                $("#city_id").html('<option value="">Choose</option>');
                $.each(response, function(index, value) {
                    $("#city_id").append('<option value="'+value.name+'">'+value.name+'</option>');
                });
            }
        });
    }
}
function getDistrict1() {
    var state_id = $("#state_id1").val();
    if(state_id) {
        $.ajax({
            url: "<?= base_url('employer/get_districts'); ?>",
            type: "POST",
            data: {state_id: state_id},
            dataType: "json",
            success: function(response) {
                $("#district_id1").html('<option value="">Choose</option>');
                $.each(response, function(index, value) {
                    $("#district_id1").append('<option value="'+value.districtid+'">'+value.district_title+'</option>');
                });
            }
        });
    }
}

function getCity1() {
    var district_id = $("#district_id1").val();
    if(district_id) {
        $.ajax({
            url: "<?= base_url('employer/get_cities'); ?>",
            type: "POST",
            data: {district_id: district_id},
            dataType: "json",
            success: function(response) {
                $("#city_id1").html('<option value="">Choose</option>');
                $.each(response, function(index, value) {
                    $("#city_id1").append('<option value="'+value.name+'">'+value.name+'</option>');
                });
            }
        });
    }
}

$(document).ready(function() {
	
	<?php if($checkCompany==0){ ?>
		$('#myModal').modal('show');
	<?php } ?>
	
    var stateId = "<?= !empty($about->state) ? $about->state : '' ?>";
    var districtId = "<?= !empty($about->District) ? $about->District : '' ?>";
    var cityId = "<?= !empty($about->city) ? $about->city : '' ?>";

    if (stateId) {
        getDistrictf(stateId, districtId);
    }

    function getDistrictf(stateId, selectedDistrict = '') {
        $.post("<?= base_url('employer/get_districts'); ?>", { state_id: stateId }, function(response) {
            $('#district_id').html('<option value="">Choose</option>');
            $.each(response, function(index, value) {
                var selected = (value.districtid == selectedDistrict) ? 'selected' : '';
                $('#district_id').append('<option value="'+value.districtid+'" '+selected+'>'+value.district_title+'</option>');
            });

            if (selectedDistrict) {
                getCityf(selectedDistrict, cityId);
            }
        }, "json");
    }

    function getCityf(districtId, selectedCity = '') {
        $.post("<?= base_url('employer/get_cities'); ?>", { district_id: districtId }, function(response) {
            $('#city_id').html('<option value="">Choose</option>');
            $.each(response, function(index, value) {
                var selected = (value.name == selectedCity) ? 'selected' : '';
                $('#city_id').append('<option value="'+value.name+'" '+selected+'>'+value.name+'</option>');
            });
        }, "json");
    }

    $('#state_id').change(function() {
        var stateId = $(this).val();
        getDistrict(stateId);
    });

    $('#district_id').change(function() {
        var districtId = $(this).val();
        getCity(districtId);
    });
});


function Status(where_value,value,status){
	var url="<?=base_url('employer/status');?>";
	var table = "post_job";
	var where_column = 'id';
	Swal.fire({
		title: 'Are you sure?',
		text: "Want to "+status+" this job!",
		icon: 'warning',
		showCancelButton: true,
		confirmButtonColor: '#3085d6',
		cancelButtonColor: '#d33',
		confirmButtonText: 'Yes'
		}).then((result) => {
		if (result.isConfirmed) {
			$.ajax({
				type: 'POST',
				url: url,
				data: { 'table': table,'status':value, 'where_column': where_column, 'where_value': where_value},
				success: function(response) {
					// alert(response);
					// console.log(response);
					var response = JSON.parse(response);
					if (response.res == 'success') {
						Toast.fire({
						  icon: 'success',
						  title: response.msg,
						})
					}else{
						Toast.fire({
						  icon: 'error',
						  title: response.msg,
						})
					}
					
					if (response.isRedirect == true) {
						if (response.wayOfRedirect == 'reload') {
							window.setTimeout(function() {
								window.location.reload();
							}, 800);
							} else if (response.wayOfRedirect == 'redirect') {
							window.setTimeout(function() {
								window.location.href = response.redirectLink;
							}, 800);
						}
					}
				},
				error: function() {
					Toast.fire({
					  icon: 'error',
					  title: 'something went wrong! Please check JS Code',
					})
				}
			});
		}
	})
}

function ApplicantStatus(where_value,value,status){
	var url="<?=base_url('employer/status');?>";
	var table = "applied_job_emp";
	var where_column = 'id';
	Swal.fire({
		title: 'Are you sure?',
		text: "Want to "+status+" this profile!",
		icon: 'warning',
		showCancelButton: true,
		confirmButtonColor: '#3085d6',
		cancelButtonColor: '#d33',
		confirmButtonText: 'Yes'
		}).then((result) => {
		if (result.isConfirmed) {
			$.ajax({
				type: 'POST',
				url: url,
				data: { 'table': table,'status':value, 'where_column': where_column, 'where_value': where_value},
				success: function(response) {
					// alert(response);
					// console.log(response);
					var response = JSON.parse(response);
					if (response.res == 'success') {
						Toast.fire({
						  icon: 'success',
						  title: response.msg,
						})
					}else{
						Toast.fire({
						  icon: 'error',
						  title: response.msg,
						})
					}
					
					if (response.isRedirect == true) {
						if (response.wayOfRedirect == 'reload') {
							window.setTimeout(function() {
								window.location.reload();
							}, 800);
							} else if (response.wayOfRedirect == 'redirect') {
							window.setTimeout(function() {
								window.location.href = response.redirectLink;
							}, 800);
						}
					}
				},
				error: function() {
					Toast.fire({
					  icon: 'error',
					  title: 'something went wrong! Please check JS Code',
					})
				}
			});
		}
	})
}

function Delete(where_value,table){
	var url="<?=base_url('employer/delete-parmanently');?>";
	var where_column='id';
	DeleteData(url,table,where_column,where_value);
}
</script>

<div class="modal fade" id="showResume" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="staticBackdropLabel">Resume</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<iframe id="resumePdf" width="100%" height="600px;"></iframe>
			</div>
		</div>
	</div>
</div>
<script>
function viewResume(pdfUrl) {
	document.getElementById('resumePdf').src = pdfUrl;
	$('#showResume').modal('show');

}
</script>
<?php require'webrtc.php';?>