<!DOCTYPE html>
<html lang="en">
    <?php require'css.php';?>
<body>
    <div class="hero-section">
        <div class="customDivCol pt-4">
            <?php require'header.php';?>
        </div>
        <div class="container py-5 mob-hide">
            <!--<div class="herocard1">
                <h6>2 Jobs Pending Approval</h6>
                <div class="d-flex gap-2">
                    <div>
                        <p class="mb-1"><span class="fs-14">UX Design</span> <span class="fs-12">(Salary Details Pending)</span> </p>
                        <p class="mb-0"><span class="fs-14">HR</span> <span class="fs-12">(Experience Details Pending)</span> </p>
                    </div>
                    <div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                            <g clip-path="url(#clip0_2359_4160)">
                              <path fill-rule="evenodd" clip-rule="evenodd" d="M16.0339 11.7819C16.2214 11.9694 16.3267 12.2238 16.3267 12.4889C16.3267 12.7541 16.2214 13.0084 16.0339 13.1959L10.3769 18.8529C10.2847 18.9484 10.1743 19.0246 10.0523 19.077C9.93031 19.1294 9.79909 19.157 9.66631 19.1582C9.53353 19.1593 9.40185 19.134 9.27896 19.0837C9.15606 19.0335 9.04441 18.9592 8.95052 18.8653C8.85662 18.7714 8.78237 18.6598 8.73209 18.5369C8.68181 18.414 8.65651 18.2823 8.65766 18.1495C8.65881 18.0167 8.6864 17.8855 8.73881 17.7635C8.79122 17.6415 8.8674 17.5312 8.96291 17.4389L13.9129 12.4889L8.96291 7.53891C8.78075 7.35031 8.67996 7.09771 8.68224 6.83551C8.68452 6.57332 8.78968 6.3225 8.97509 6.1371C9.1605 5.95169 9.41131 5.84652 9.67351 5.84424C9.93571 5.84196 10.1883 5.94276 10.3769 6.12491L16.0339 11.7819Z" fill="#202020"/>
                            </g>
                            <defs>
                              <clipPath id="clip0_2359_4160">
                                <rect width="24" height="24" fill="white" transform="matrix(0 -1 1 0 0.326904 24.4883)"/>
                              </clipPath>
                            </defs>
                        </svg>
                    </div>
                </div>
            </div>-->
            <h1 class="text-center">Your Hiring Journey,<br> Simplified with <span class="text-blue">Job Karo!</span></h1>
            <div class="d-flex justify-content-center gap-4 mt-5">
			<?php if($jobs>0){ ?>
                <a href="<?=base_url('employer/application');?>" class="btn-custom">View Applications</a>
			<?php } ?>
                <a href="<?=base_url('employer/add-job');?>" class="btn-outline-custom">Post New Job</a>
            </div>
            <div class="d-flex justify-content-end">
                <div class="herocard2">
                    <h6>Your Insights</h6>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Applicants</span>
                        <span class="text-blue"><?=$insight['applicant'];?></span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Shortlisted</span>
                        <span class="text-blue"><?=$insight['shortlist'];?></span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Rejected</span>
                        <span class="text-blue"><?=$insight['rejected'];?></span>
                    </div>
                </div>
            </div>
            <div class="herocard3">
                <p class="fs-20 fw-500"><?=$activeApplicant['total'];?> New Applications</p>
                <div class="d-flex gap-1 mb-2">
                    <div style="width: 30%;"><?=$activeApplicant['title'];?></div>
                    <div class="my-auto" style="width:60%;">
                        <div class="progress" style="height:2px">
                            <div class="progress-bar" style="width:40%;"></div>
                        </div>
                    </div>
                    <div style="width: 10%;" class="text-end"><?=$activeApplicant['value'];?></div>
                </div>
                <div class="d-flex gap-1 mb-2">
                    <div style="width: 30%;"><?=$activeApplicant['title2'];?></div>
                    <div class="my-auto" style="width:60%;">
                        <div class="progress" style="height:2px">
                            <div class="progress-bar" style="width:40%;"></div>
                        </div>
                    </div>
                    <div style="width: 10%;" class="text-end"><?=$activeApplicant['value2'];?></div>
                </div>
                <div class="d-flex gap-1">
                    <div style="width: 30%;">Others</div>
                    <div class="my-auto" style="width:60%;">
                        <div class="progress" style="height:2px">
                            <div class="progress-bar" style="width:40%;"></div>
                        </div>
                    </div>
                    <div style="width: 10%;" class="text-end"><?=$activeApplicant['others'];?></div>
                </div>
            </div>
        </div>
        <div class="container py-5 mob-show">
            <div class="d-flex justify-content-end">
                <div class="herocard3">
                    <p class="fs-20 fw-500"><?=$activeApplicant['total'];?> New Applications</p>
                    <div class="d-flex gap-1 mb-2">
                        <div style="width: 30%;"><?=$activeApplicant['title'];?></div>
                        <div class="my-auto" style="width:60%;">
                            <div class="progress" style="height:2px">
                                <div class="progress-bar" style="width:40%;"></div>
                            </div>
                        </div>
                        <div style="width: 10%;" class="text-end"><?=$activeApplicant['value'];?></div>
                    </div>
                    <div class="d-flex gap-1 mb-2">
                        <div style="width: 30%;"><?=$activeApplicant['title2'];?></div>
                        <div class="my-auto" style="width:60%;">
                            <div class="progress" style="height:2px">
                                <div class="progress-bar" style="width:40%;"></div>
                            </div>
                        </div>
                        <div style="width: 10%;" class="text-end"><?=$activeApplicant['value2'];?></div>
                    </div>
                    <div class="d-flex gap-1">
                        <div style="width: 30%;">Others</div>
                        <div class="my-auto" style="width:60%;">
                            <div class="progress" style="height:2px">
                                <div class="progress-bar" style="width:40%;"></div>
                            </div>
                        </div>
                        <div style="width: 10%;" class="text-end"><?=$activeApplicant['others'];?></div>
                    </div>
                </div>
            </div>
            <div class="px-3">
            <h1 style="line-height: 1.5;">Your Hiring <br> Journey,<br> Simplified with <br><span class="text-blue">Job Karo!</span></h1>
            </div>
            <div class="herocard2">
                <h6>Your Insights</h6>
                <div class="d-flex justify-content-between mb-2">
                    <span>Applicants</span>
                    <span class="text-blue"><?=$insight['applicant'];?></span>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span>Shortlisted</span>
                    <span class="text-blue"><?=$insight['shortlist'];?></span>
                </div>
                <div class="d-flex justify-content-between">
                    <span>Rejected</span>
                    <span class="text-blue"><?=$insight['rejected'];?></span>
                </div>
            </div>
            <div class="d-flex justify-content-center gap-4 mt-5">
			<?php if($jobs>0){ ?>
                <a href="<?=base_url('employer/application');?>" class="btn-custom">View Applications</a>
			<?php } ?>
                <a href="<?=base_url('employer/add-job');?>" class="btn-outline-custom">Post New Job</a>
            </div>
        </div>
    </div>
    <div class="p4 mt-4">
        <div class="homePageSecondSec">
            <div class="d-flex justify-content-between">
                <h3 class="recutmentjrnyText px-2">Your Recruitment Journey in Numbers</h3>
                <!--<button class="btn-outline-custom mob-hide">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                        <g clip-path="url(#clip0_1871_3720)">
                          <path fill-rule="evenodd" clip-rule="evenodd" d="M12.707 16.2064C12.5194 16.3938 12.2651 16.4992 12 16.4992C11.7348 16.4992 11.4805 16.3938 11.293 16.2064L5.63598 10.5494C5.54047 10.4571 5.46428 10.3468 5.41188 10.2248C5.35947 10.1028 5.33188 9.97155 5.33073 9.83877C5.32957 9.70599 5.35487 9.57431 5.40516 9.45141C5.45544 9.32852 5.52969 9.21686 5.62358 9.12297C5.71747 9.02908 5.82913 8.95483 5.95202 8.90454C6.07492 8.85426 6.2066 8.82896 6.33938 8.83012C6.47216 8.83127 6.60338 8.85886 6.72538 8.91126C6.84739 8.96367 6.95773 9.03986 7.04998 9.13537L12 14.0854L16.95 9.13537C17.1386 8.95321 17.3912 8.85241 17.6534 8.85469C17.9156 8.85697 18.1664 8.96214 18.3518 9.14755C18.5372 9.33296 18.6424 9.58377 18.6447 9.84597C18.6469 10.1082 18.5461 10.3608 18.364 10.5494L12.707 16.2064Z" fill="#007BFF"/>
                        </g>
                        <defs>
                          <clipPath id="clip0_1871_3720">
                            <rect width="24" height="24" fill="white" transform="translate(0 0.5)"/>
                          </clipPath>
                        </defs>
                    </svg> &nbsp;
                    UX Design
                </button>-->
            </div>
            <div class="row mt-3 mx-0">
                <div class="col-md-4">
                    <div class="dashboardCrd">
                        <div class="d-flex justify-content-between">
                            <div class="my-auto">
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                                        <path d="M11.3243 8.67568C11.8305 7.9684 12.1027 7.12044 12.1027 6.25068C12.1027 5.38092 11.8305 4.53296 11.3243 3.82568C11.7983 3.50279 12.3591 3.33135 12.9326 3.33402C13.7062 3.33402 14.448 3.64131 14.995 4.18829C15.542 4.73527 15.8493 5.47713 15.8493 6.25068C15.8493 7.02423 15.542 7.7661 14.995 8.31308C14.448 8.86006 13.7062 9.16735 12.9326 9.16735C12.3591 9.17002 11.7983 8.99857 11.3243 8.67568ZM5.01596 6.25068C5.01596 5.67382 5.18701 5.10991 5.5075 4.63027C5.82799 4.15063 6.28351 3.77679 6.81646 3.55603C7.34941 3.33528 7.93586 3.27752 8.50164 3.39006C9.06741 3.5026 9.58711 3.78038 9.99502 4.18829C10.4029 4.59619 10.6807 5.11589 10.7932 5.68167C10.9058 6.24745 10.848 6.83389 10.6273 7.36684C10.4065 7.89979 10.0327 8.35531 9.55304 8.6758C9.07339 8.99629 8.50948 9.16735 7.93262 9.16735C7.15907 9.16735 6.41721 8.86006 5.87023 8.31308C5.32325 7.7661 5.01596 7.02423 5.01596 6.25068ZM6.68262 6.25068C6.68262 6.49791 6.75593 6.73958 6.89329 6.94514C7.03064 7.15071 7.22586 7.31092 7.45427 7.40553C7.68268 7.50014 7.93401 7.52489 8.17649 7.47666C8.41896 7.42843 8.64169 7.30938 8.81651 7.13457C8.99132 6.95975 9.11037 6.73702 9.1586 6.49454C9.20684 6.25207 9.18208 6.00073 9.08747 5.77233C8.99286 5.54392 8.83265 5.3487 8.62708 5.21134C8.42152 5.07399 8.17985 5.00068 7.93262 5.00068C7.6011 5.00068 7.28316 5.13238 7.04874 5.3668C6.81432 5.60122 6.68262 5.91916 6.68262 6.25068ZM13.766 14.1673V15.834H2.09929V14.1673C2.09929 14.1673 2.09929 10.834 7.93262 10.834C13.766 10.834 13.766 14.1673 13.766 14.1673ZM12.0993 14.1673C11.9826 13.5173 10.991 12.5007 7.93262 12.5007C4.87429 12.5007 3.82429 13.5923 3.76596 14.1673M13.7243 10.834C14.235 11.2313 14.6526 11.7356 14.9478 12.3114C15.2429 12.8873 15.4084 13.5207 15.4326 14.1673V15.834H18.766V14.1673C18.766 14.1673 18.766 11.1423 13.716 10.834H13.7243Z" fill="#007BFF"/>
                                    </svg> <span class="fs-20 fw-500"> Applications</span>
                                </p>
                                <h4 class="mb-0" id="applicants">0</h4>
                            </div>
                            <div class="circle">
                                <div class="content text-blue fs-20" id="applicant_active">0</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="dashboardCrd">
                        <div class="d-flex justify-content-between">
                            <div class="my-auto">
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
                                        <g clip-path="url(#clip0_1871_3660)">
                                          <path d="M4.26593 8.66732L7.59926 11.334L13.5993 4.00065M2.26593 1.33398H15.5993V14.6673H2.26593V1.33398Z" stroke="#1DAC00"/>
                                        </g>
                                        <defs>
                                          <clipPath id="clip0_1871_3660">
                                            <rect width="16" height="16" fill="white" transform="translate(0.932617)"/>
                                          </clipPath>
                                        </defs>
                                      </svg> <span class="fs-20 fw-500"> Shortlisted</span>
                                </p>
                                <h4 class="mb-0" id="shortlist">0</h4>
                            </div>
                            <div class="circle circle2">
                                <div class="content fs-20" style="color: #1DAC00;" id="shortlist_active">0</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="dashboardCrd">
                        <div class="d-flex justify-content-between">
                            <div class="my-auto">
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="13" height="16" viewBox="0 0 13 16" fill="none">
                                        <path d="M5.46509 6.76367L7.93742 9.236M7.93742 6.76367L5.46509 9.236" stroke="#FF3232" stroke-width="0.64" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M2.58057 0.582031H11.6459C11.8645 0.582031 12.074 0.668843 12.2286 0.823369C12.3831 0.977895 12.4699 1.18748 12.4699 1.40601V14.592C12.4699 14.8106 12.3831 15.0202 12.2286 15.1747C12.074 15.3292 11.8645 15.416 11.6459 15.416H1.7566C1.53806 15.416 1.32848 15.3292 1.17396 15.1747C1.01943 15.0202 0.932617 14.8106 0.932617 14.592V2.23038M2.58057 0.582031L0.932617 2.23038M2.58057 0.582031V2.23038H0.932617" stroke="#FF4747" stroke-width="0.64" stroke-linecap="round" stroke-linejoin="round"/>
                                      </svg> <span class="fs-20 fw-500"> Rejected</span>
                                </p>
                                <h4 class="mb-0" id="rejected">0</h4>
                            </div>
                            <div class="circle circle3">
                                <div class="content fs-20" style="color: #E93838;" id="rejected_active">0</div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="row mt-3 mx-0">
                <div class="col-md-8">
                    <div class="canvasSection">
                        <div class="text-end mb-3">
                            <a href="#" class="text-primary">Last 7 Days</a>
                        </div>
                        <div class="chart-container">
                            <canvas id="jobPostingsChart"></canvas>
                        </div>
                        <div class="d-flex justify-content-between mt-5 mb-3">
                            <h5 class="my-auto">Your Active Job Postings by Role</h5>
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23" fill="none">
                                    <path d="M20.0568 14.6178H8.39559M4.27947 14.6178H2.59564M4.27947 14.6178C4.27947 14.0721 4.49625 13.5487 4.88212 13.1629C5.26799 12.777 5.79135 12.5602 6.33705 12.5602C6.88276 12.5602 7.40612 12.777 7.79199 13.1629C8.17786 13.5487 8.39464 14.0721 8.39464 14.6178C8.39464 15.1635 8.17786 15.6869 7.79199 16.0727C7.40612 16.4586 6.88276 16.6754 6.33705 16.6754C5.79135 16.6754 5.26799 16.4586 4.88212 16.0727C4.49625 15.6869 4.27947 15.1635 4.27947 14.6178ZM20.0568 8.38181H17.1262M13.0101 8.38181H2.59564M13.0101 8.38181C13.0101 7.8361 13.2268 7.31274 13.6127 6.92687C13.9986 6.541 14.5219 6.32422 15.0676 6.32422C15.3379 6.32422 15.6054 6.37744 15.8551 6.48084C16.1047 6.58425 16.3315 6.73581 16.5226 6.92687C16.7136 7.11794 16.8652 7.34476 16.9686 7.5944C17.072 7.84404 17.1252 8.1116 17.1252 8.38181C17.1252 8.65201 17.072 8.91957 16.9686 9.16921C16.8652 9.41885 16.7136 9.64568 16.5226 9.83674C16.3315 10.0278 16.1047 10.1794 15.8551 10.2828C15.6054 10.3862 15.3379 10.4394 15.0676 10.4394C14.5219 10.4394 13.9986 10.2226 13.6127 9.83674C13.2268 9.45087 13.0101 8.92751 13.0101 8.38181Z" stroke="#007BFF" stroke-width="1.41577" stroke-miterlimit="10" stroke-linecap="round"/>
                                </svg> <span class="text-blue fs-18">Today</span>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between border-bottom mb-3">
                            <p class="text-muted mb-1">Job Title</p>
                            <p class="text-muted mb-1">Application</p>
                        </div>
						<?php foreach($activeJobRoles as $row){?>
                        <div class="d-flex justify-content-between my-2">
                            <span class="fw-500" style="color: rgba(32, 32, 32, 0.80);"><?=$row->jTitle;?></span>
                            <span class="fw-bold"><?=$row->applicant_count;?></span>
                        </div>
						<?php }?>
                    </div>
                
                    <script>
					const chartData = <?= json_encode($chartData) ?>;
                        const ctx = document.getElementById('jobPostingsChart').getContext('2d');
                        const jobPostingsChart = new Chart(ctx, {
                            type: 'line',
                            data: {
                                labels: chartData.dates,
                                datasets: [
                                    {
                                        label: 'Application',
                                        data: chartData.applicant,
                                        borderColor: '#007bff',
                                        backgroundColor: 'rgba(0, 123, 255, 0.1)',
                                        fill: true,
                                        tension: 0.4
                                    },
                                    {
                                        label: 'Shortlisted',
                                        data: chartData.shortlist,
                                        borderColor: '#28a745',
                                        backgroundColor: 'rgba(40, 167, 69, 0.1)',
                                        fill: true,
                                        tension: 0.4
                                    },
                                    {
                                        label: 'Rejected',
                                        data: chartData.rejected,
                                        borderColor: '#dc3545',
                                        backgroundColor: 'rgba(220, 53, 69, 0.1)',
                                        fill: true,
                                        tension: 0.4
                                    }
                                ]
                            },
                            options: {
                                responsive: true,
                                plugins: {
                                    tooltip: {
                                        mode: 'index',
                                        intersect: false
                                    },
                                    legend: {
                                        display: true,
                                        position: 'top'
                                    }
                                },
                                scales: {
                                    x: {
                                        grid: {
                                            display: false
                                        }
                                    },
                                    y: {
                                        beginAtZero: true,
                                        grid: {
                                            color: 'rgba(200, 200, 200, 0.3)'
                                        },
                                        ticks: {
                                            stepSize: 30
                                        }
                                    }
                                }
                            }
                        });
                    </script>
                </div>
                <div class="col-md-4 newApplicants" style="max-height: 710px;overflow-y: auto;">
                    <div class="p4" style="border-radius: 18px;background: #FFF;">
                        <div class="d-flex justify-content-between mb-3">
                            <h5>New Applicants</h5>
                            <!--<div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23" fill="none">
                                    <path d="M20.0568 14.6178H8.39559M4.27947 14.6178H2.59564M4.27947 14.6178C4.27947 14.0721 4.49625 13.5487 4.88212 13.1629C5.26799 12.777 5.79135 12.5602 6.33705 12.5602C6.88276 12.5602 7.40612 12.777 7.79199 13.1629C8.17786 13.5487 8.39464 14.0721 8.39464 14.6178C8.39464 15.1635 8.17786 15.6869 7.79199 16.0727C7.40612 16.4586 6.88276 16.6754 6.33705 16.6754C5.79135 16.6754 5.26799 16.4586 4.88212 16.0727C4.49625 15.6869 4.27947 15.1635 4.27947 14.6178ZM20.0568 8.38181H17.1262M13.0101 8.38181H2.59564M13.0101 8.38181C13.0101 7.8361 13.2268 7.31274 13.6127 6.92687C13.9986 6.541 14.5219 6.32422 15.0676 6.32422C15.3379 6.32422 15.6054 6.37744 15.8551 6.48084C16.1047 6.58425 16.3315 6.73581 16.5226 6.92687C16.7136 7.11794 16.8652 7.34476 16.9686 7.5944C17.072 7.84404 17.1252 8.1116 17.1252 8.38181C17.1252 8.65201 17.072 8.91957 16.9686 9.16921C16.8652 9.41885 16.7136 9.64568 16.5226 9.83674C16.3315 10.0278 16.1047 10.1794 15.8551 10.2828C15.6054 10.3862 15.3379 10.4394 15.0676 10.4394C14.5219 10.4394 13.9986 10.2226 13.6127 9.83674C13.2268 9.45087 13.0101 8.92751 13.0101 8.38181Z" stroke="#007BFF" stroke-width="1.41577" stroke-miterlimit="10" stroke-linecap="round"></path>
                                </svg> <span class="text-blue fs-18">Today</span>
                            </div>-->
                        </div>
						<?php foreach($latestAplicant as $row){ ?>
                        <div class="empSmallCard mb-2">
                            <div class="d-flex justify-content-between">
                                <div class="d-flex gap-2">
                                    <img src="<?=$row->emp_profile;?>" alt="">
                                    <div class="my-auto">
                                        <p class="fs-18 fw-500 mb-1"><?=$row->emp_name;?></p>
                                        <p class="fs-14 fw-500 mb-0"><?=$row->job_title;?> <?=$row->experience;?></p>
                                    </div>
                                </div>
                                <div class="d-flex">
                                    <svg xmlns="http://www.w3.org/2000/svg" onclick="ApplicantStatus(<?=$row->id?>,1,'shortlist')" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                        <path d="M4.16675 10.8346L8.33342 14.168L15.8334 5.0013M1.66675 1.66797H18.3334V18.3346H1.66675V1.66797Z" stroke="#1DAC00" stroke-width="1.25"/>
                                    </svg>
                                    <svg onclick="ApplicantStatus(<?=$row->id?>,2,'reject')" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                        <path d="M14.0625 5.9375L5.9375 14.0625M5.9375 5.9375L14.0625 14.0625" stroke="#FF4747" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                            </div>
                            <div class="d-flex gap-2 mt-3" style="overflow: auto;">
                                <div class="job-cat-btn"><?=$row->job_type;?></div>
                                <div class="job-cat-btn"><?=$row->employment_type;?></div>
                                        <?php 
									$skills = explode(',', $row->skills);

									foreach ($skills as $skill) {
										$skill = trim($skill);

										if (!empty($skill)) {
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>
                            </div>
                        </div>
						<?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="homePageSecondSec my-3">
            <div class="d-flex justify-content-between mb-4">
                <h3 class="my-auto px-2">Top Candidate Matches for Your Roles</h3>
                <div>
                    <select class="form-control btn-outline-custom" id="job_id" onchange="loadCandidate();">
					<?php foreach($active as $row){?>
					<option value='<?=$row->job_id;?>' ><?=$row->job_title?></option>
					<?php } ?>
					</select>
                </div>
            </div>
            <span id="candidates">

			</span>			
            <div class="text-center mt-5">
                <a href="<?=base_url('employer/application')?>" class="btn-outline-custom">Explore More
                    <svg xmlns="http://www.w3.org/2000/svg" width="27" height="27" viewBox="0 0 27 27" fill="none">
                        <g clip-path="url(#clip0_1891_4328)">
                          <path fill-rule="evenodd" clip-rule="evenodd" d="M17.6234 12.7113C17.8319 12.9199 17.949 13.2028 17.949 13.4977C17.949 13.7927 17.8319 14.0755 17.6234 14.2841L11.3311 20.5764C11.2285 20.6827 11.1057 20.7674 10.97 20.8257C10.8343 20.884 10.6884 20.9147 10.5407 20.916C10.393 20.9173 10.2465 20.8891 10.1098 20.8332C9.97312 20.7773 9.84892 20.6947 9.74449 20.5902C9.64005 20.4858 9.55746 20.3616 9.50153 20.2249C9.4456 20.0882 9.41746 19.9417 9.41874 19.794C9.42003 19.6464 9.45071 19.5004 9.50901 19.3647C9.5673 19.229 9.65204 19.1062 9.75827 19.0036L15.2642 13.4977L9.75827 7.99183C9.55566 7.78204 9.44355 7.50107 9.44608 7.20943C9.44861 6.91779 9.56559 6.63881 9.77182 6.43258C9.97805 6.22635 10.257 6.10937 10.5487 6.10683C10.8403 6.1043 11.1213 6.21641 11.3311 6.41903L17.6234 12.7113Z" fill="#007BFF"/>
                        </g>
                        <defs>
                          <clipPath id="clip0_1891_4328">
                            <rect width="26.6953" height="26.6953" fill="white" transform="matrix(0 -1 1 0 0.152344 26.8477)"/>
                          </clipPath>
                        </defs>
                    </svg>
                </a>
            </div>
        </div>
    </div>

    <div class="home-download-sec p-3 py-5">
        <div class="custom-col-10 text-center mx-auto text-white">
            <h1 class="down-title1 mb-3">
                <span style="color: #007BFF;">Hire</span> Talent Anytime, Anywhere</h1>
            <h2 class="down-title2 mb-3 fw-normal">Get the <span style="color: #007BFF;">
                JobKaro App!</span></h2>
            <p class="mb-1">Download the <span style="color: #007BFF;">Job Karo</span> app and take control of your hiring process on the go. Post <br> jobs, review applications, and connect with top talent effortlessly.</p>
            <button class="btn-custom mt-4 fw-normal" onclick="window.location.href='https://play.google.com/store/apps/details?id=com.wlhiring.teamhiring';" class="custom-btn2 px-4 py-2 fs-6 mt-4 fw-normal">
                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                <path d="M12.5635 15.575C12.4301 15.575 12.3051 15.5543 12.1885 15.513C12.0718 15.4717 11.9635 15.4007 11.8635 15.3L8.26348 11.7C8.06348 11.5 7.96748 11.2667 7.97548 11C7.98348 10.7333 8.07948 10.5 8.26348 10.3C8.46348 10.1 8.70114 9.996 8.97648 9.988C9.25181 9.98 9.48914 10.0757 9.68848 10.275L11.5635 12.15V5C11.5635 4.71667 11.6595 4.47934 11.8515 4.288C12.0435 4.09667 12.2808 4.00067 12.5635 4C12.8461 3.99934 13.0838 4.09534 13.2765 4.288C13.4691 4.48067 13.5648 4.718 13.5635 5V12.15L15.4385 10.275C15.6385 10.075 15.8761 9.979 16.1515 9.987C16.4268 9.995 16.6641 10.0993 16.8635 10.3C17.0468 10.5 17.1428 10.7333 17.1515 11C17.1601 11.2667 17.0641 11.5 16.8635 11.7L13.2635 15.3C13.1635 15.4 13.0551 15.471 12.9385 15.513C12.8218 15.555 12.6968 15.5757 12.5635 15.575ZM6.56348 20C6.01348 20 5.54281 19.8043 5.15148 19.413C4.76014 19.0217 4.56414 18.5507 4.56348 18V16C4.56348 15.7167 4.65948 15.4793 4.85148 15.288C5.04348 15.0967 5.28081 15.0007 5.56348 15C5.84614 14.9993 6.08381 15.0953 6.27648 15.288C6.46914 15.4807 6.56481 15.718 6.56348 16V18H18.5635V16C18.5635 15.7167 18.6595 15.4793 18.8515 15.288C19.0435 15.0967 19.2808 15.0007 19.5635 15C19.8461 14.9993 20.0838 15.0953 20.2765 15.288C20.4691 15.4807 20.5648 15.718 20.5635 16V18C20.5635 18.55 20.3678 19.021 19.9765 19.413C19.5851 19.805 19.1141 20.0007 18.5635 20H6.56348Z" fill="white"></path>
                </svg> Download Now</button>
        </div>
    </div>

    <div class="manageJobPd">
        <div class="homePageSecondSec p4">
            <h3>Manage Your Jobs </h3>
            <div class="col-md-10 mx-auto mt-4">
                <!-- Nav pills -->
                <ul class="nav nav-pills justify-content-center manageYourJobNav" role="tablist">
                    <li class="nav-item">
                    <a class="nav-link active" data-bs-toggle="pill" href="#home">Active Jobs</a>
                    </li>
                    <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="pill" href="#menu1">Inactive Jobs</a>
                    </li>
                    
                </ul>

                <!-- Tab panes -->
                <div class="tab-content">
                    <div id="home" class="container tab-pane active"><br>
					<?php if(empty($active)){?>
					<div class="customDivCol px-4 mx-auto my-5">
        				   <h3>Nothing to see here yet</h3>
        				   <p>You haven’t added anything to this list. When you do, it’ll show up here so you can easily track your job journey.</p>
        				   <div class="text-center">
        					   <img src="<?php echo base_url(); ?>assets/newAssets/img/nodataRec.png" class="nodataImg"> 
        				   </div> 
        				</div>
					<?php }else{ foreach($active as $row){ ?>
                        <div class="manage-job-card position-relative mb-3">
                            <div class="urgentHire-btn top-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                                    <path d="M7 14V10.5C7 9.57174 7.36875 8.6815 8.02513 8.02513C8.6815 7.36875 9.57174 7 10.5 7C11.4283 7 12.3185 7.36875 12.9749 8.02513C13.6313 8.6815 14 9.57174 14 10.5V14M2.625 10.5H3.5M10.5 2.625V3.5M17.5 10.5H18.375M4.9 4.9L5.5125 5.5125M16.1 4.9L15.4875 5.5125M5.25 14.875C5.25 14.6429 5.34219 14.4204 5.50628 14.2563C5.67038 14.0922 5.89294 14 6.125 14H14.875C15.1071 14 15.3296 14.0922 15.4937 14.2563C15.6578 14.4204 15.75 14.6429 15.75 14.875V16.625C15.75 16.8571 15.6578 17.0796 15.4937 17.2437C15.3296 17.4078 15.1071 17.5 14.875 17.5H6.125C5.89294 17.5 5.67038 17.4078 5.50628 17.2437C5.34219 17.0796 5.25 16.8571 5.25 16.625V14.875Z" stroke="#FF6F42" stroke-width="1.575" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                                <span> Urgent Hiring</span>
                            </div>
                            <div class="position-absolute fs-12 start-0 bottom-0" style="border-radius: 0px 15px 0px 0px;
                            background: #EEF6FF;padding: 6px 4px;">
                                Posted <?=$row->job_created_at;?>
                            </div>
                            <div class="row mx-auto">
                                <div class="col-md-7">
                                    <h5><?=$row->job_title;?> (<?=$row->salary_min;?><?=$row->salary_type;?> - <?=$row->salary_max;?><?=$row->salary_type;?>)</h5>
                                    <p class="fs-14">  </p>
                                    <div class="quali">
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                                <path d="M10.8917 8.92373C11.3979 8.21645 11.67 7.36849 11.67 6.49873C11.67 5.62897 11.3979 4.78101 10.8917 4.07373C11.3656 3.75084 11.9265 3.57939 12.5 3.58206C13.2735 3.58206 14.0154 3.88935 14.5624 4.43633C15.1094 4.98332 15.4167 5.72518 15.4167 6.49873C15.4167 7.27228 15.1094 8.01414 14.5624 8.56112C14.0154 9.1081 13.2735 9.4154 12.5 9.4154C11.9265 9.41806 11.3656 9.24662 10.8917 8.92373ZM4.58332 6.49873C4.58332 5.92187 4.75438 5.35796 5.07487 4.87832C5.39536 4.39867 5.85088 4.02484 6.38383 3.80408C6.91678 3.58332 7.50323 3.52556 8.069 3.6381C8.63478 3.75065 9.15448 4.02843 9.56238 4.43633C9.97029 4.84424 10.2481 5.36394 10.3606 5.92972C10.4732 6.49549 10.4154 7.08194 10.1946 7.61489C9.97388 8.14784 9.60005 8.60336 9.1204 8.92385C8.64076 9.24434 8.07685 9.4154 7.49999 9.4154C6.72644 9.4154 5.98458 9.1081 5.4376 8.56112C4.89061 8.01414 4.58332 7.27228 4.58332 6.49873ZM6.24999 6.49873C6.24999 6.74595 6.3233 6.98763 6.46065 7.19319C6.598 7.39875 6.79323 7.55897 7.02164 7.65358C7.25004 7.74819 7.50138 7.77294 7.74385 7.72471C7.98633 7.67648 8.20906 7.55743 8.38387 7.38261C8.55869 7.2078 8.67774 6.98507 8.72597 6.74259C8.7742 6.50012 8.74945 6.24878 8.65484 6.02037C8.56023 5.79197 8.40001 5.59674 8.19445 5.45939C7.98889 5.32204 7.74722 5.24873 7.49999 5.24873C7.16847 5.24873 6.85053 5.38042 6.61611 5.61484C6.38169 5.84927 6.24999 6.16721 6.24999 6.49873ZM13.3333 14.4154V16.0821H1.66666V14.4154C1.66666 14.4154 1.66666 11.0821 7.49999 11.0821C13.3333 11.0821 13.3333 14.4154 13.3333 14.4154ZM11.6667 14.4154C11.55 13.7654 10.5583 12.7487 7.49999 12.7487C4.44166 12.7487 3.39166 13.8404 3.33332 14.4154M13.2917 11.0821C13.8024 11.4793 14.22 11.9836 14.5151 12.5595C14.8103 13.1353 14.9758 13.7688 15 14.4154V16.0821H18.3333V14.4154C18.3333 14.4154 18.3333 11.3904 13.2833 11.0821H13.2917Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg>
                                            <?=$row->total_applicant;?> Applicants
                                        </span>
                                        <span>
                                            <img src="<?=base_url('assets/newAssets/img/')?>grommet-icons.svg" alt="">
                                            <?=$row->total_rejected;?> Rejected
                                        </span>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                                <g clip-path="url(#clip0_1891_4549)">
                                                  <path d="M8.45477 8.70703L11.5452 11.7974M11.5452 8.70703L8.45477 11.7974" stroke="#FF3232" stroke-width="0.64" stroke-linecap="round" stroke-linejoin="round"></path>
                                                  <path d="M4.84913 0.980469H16.1808C16.454 0.980469 16.716 1.08898 16.9091 1.28214C17.1023 1.4753 17.2108 1.73728 17.2108 2.01044V18.493C17.2108 18.7661 17.1023 19.0281 16.9091 19.2213C16.716 19.4144 16.454 19.5229 16.1808 19.5229H3.81916C3.54599 19.5229 3.28401 19.4144 3.09086 19.2213C2.8977 19.0281 2.78918 18.7661 2.78918 18.493V3.04091M4.84913 0.980469L2.78918 3.04091M4.84913 0.980469V3.04091H2.78918" stroke="#FF4747" stroke-width="0.64" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </g>
                                                <defs>
                                                  <clipPath id="clip0_1891_4549">
                                                    <rect width="20" height="20" fill="white" transform="translate(0 0.25)"></rect>
                                                  </clipPath>
                                                </defs>
                                            </svg> <?=$row->employment_type;?>
                                        </span>
                                    </div>
                                    <div class="d-flex gap-2 mt-3 fs-14" style="overflow: auto;">
                                        <div class="job-cat-btn"><?=$row->job_type;?></div>
                                        <div class="job-cat-btn"><?=$row->employment_type;?></div>
                                        <?php 
									$skills = explode(',', $row->job_skills);

									foreach ($skills as $skill) {
										$skill = trim($skill);

										if (!empty($skill)) {
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>
                                    </div>
                                </div>
                                <div class="col-md-2 mt-2"></div>
                                <div class="col-md-3 my-auto cardbtnFlex">
                                    <button class="btn-outline-red w-100 mb-2" onclick="Status(<?=$row->job_id?>,1,'inactive')">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                            <path d="M11.25 5.5L4.75 12M4.75 5.5L11.25 12" stroke="#FF4747" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>
                                        Close Job
                                    </button>
                                    <a href="<?=base_url('employer/add-job?id='.$row->job_id)?>" class="btn-custom w-100 text-center"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                        <path d="M1 13.75H15V14.75H1V13.75ZM12.7 5.25C13.1 4.85 13.1 4.25 12.7 3.85L10.9 2.05C10.5 1.65 9.9 1.65 9.5 2.05L2 9.55V12.75H5.2L12.7 5.25ZM10.2 2.75L12 4.55L10.5 6.05L8.7 4.25L10.2 2.75ZM3 11.75V9.95L8 4.95L9.8 6.75L4.8 11.75H3Z" fill="white"></path>
                                      </svg> Edit Job</a>
                                </div>
								
								
								
                            </div>
							
                            <div class="d-flex justify-content-end gap-2 mb-2">
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                        <path d="M12.5673 7.24891C12.7446 7.49741 12.8333 7.62224 12.8333 7.80599C12.8333 7.99032 12.7446 8.11457 12.5673 8.36307C11.7705 9.48074 9.73521 11.8893 6.99996 11.8893C4.26413 11.8893 2.22946 9.48016 1.43263 8.36307C1.25529 8.11457 1.16663 7.98974 1.16663 7.80599C1.16663 7.62166 1.25529 7.49741 1.43263 7.24891C2.22946 6.13124 4.26471 3.72266 6.99996 3.72266C9.73579 3.72266 11.7705 6.13182 12.5673 7.24891Z" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M8.75 7.80469C8.75 7.34056 8.56563 6.89544 8.23744 6.56725C7.90925 6.23906 7.46413 6.05469 7 6.05469C6.53587 6.05469 6.09075 6.23906 5.76256 6.56725C5.43437 6.89544 5.25 7.34056 5.25 7.80469C5.25 8.26882 5.43437 8.71394 5.76256 9.04212C6.09075 9.37031 6.53587 9.55469 7 9.55469C7.46413 9.55469 7.90925 9.37031 8.23744 9.04212C8.56563 8.71394 8.75 8.26882 8.75 7.80469Z" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg> <?=$row->views;?> Views
                                </span>
                               
                            </div>
                        </div>
					<?php } } ?>
                        <div class="text-center mt-5">
                            <a href="<?=base_url('employer/jobs');?>" class="btn-outline-custom fw-500">Manage All Jobs
                                <svg xmlns="http://www.w3.org/2000/svg" width="27" height="27" viewBox="0 0 27 27" fill="none">
                                    <g clip-path="url(#clip0_1891_4328)">
                                      <path fill-rule="evenodd" clip-rule="evenodd" d="M17.6234 12.7113C17.8319 12.9199 17.949 13.2028 17.949 13.4977C17.949 13.7927 17.8319 14.0755 17.6234 14.2841L11.3311 20.5764C11.2285 20.6827 11.1057 20.7674 10.97 20.8257C10.8343 20.884 10.6884 20.9147 10.5407 20.916C10.393 20.9173 10.2465 20.8891 10.1098 20.8332C9.97312 20.7773 9.84892 20.6947 9.74449 20.5902C9.64005 20.4858 9.55746 20.3616 9.50153 20.2249C9.4456 20.0882 9.41746 19.9417 9.41874 19.794C9.42003 19.6464 9.45071 19.5004 9.50901 19.3647C9.5673 19.229 9.65204 19.1062 9.75827 19.0036L15.2642 13.4977L9.75827 7.99183C9.55566 7.78204 9.44355 7.50107 9.44608 7.20943C9.44861 6.91779 9.56559 6.63881 9.77182 6.43258C9.97805 6.22635 10.257 6.10937 10.5487 6.10683C10.8403 6.1043 11.1213 6.21641 11.3311 6.41903L17.6234 12.7113Z" fill="#007BFF"></path>
                                    </g>
                                    <defs>
                                      <clipPath id="clip0_1891_4328">
                                        <rect width="26.6953" height="26.6953" fill="white" transform="matrix(0 -1 1 0 0.152344 26.8477)"></rect>
                                      </clipPath>
                                    </defs>
                                </svg>
                            </a>
                        </div>
                        
                        <!--no data div-->
                       
        				<!--no data div end-->
        				
                    </div>
                    <div id="menu1" class="container tab-pane fade"><br>
					<?php if(empty($inactive)){?>
					<div class="customDivCol px-4 mx-auto my-5">
        				   <h3>Nothing to see here yet</h3>
        				   <p>You haven’t added anything to this list. When you do, it’ll show up here so you can easily track your job journey.</p>
        				   <div class="text-center">
        					   <img src="<?php echo base_url(); ?>assets/newAssets/img/nodataRec.png" class="nodataImg"> 
        				   </div> 
        				</div>
					<?php }else{ foreach($inactive as $row){ ?>
                        <div class="manage-job-card position-relative mb-3">
                            <div class="urgentHire-btn top-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                    <path d="M11.25 5.25L4.75 11.75M4.75 5.25L11.25 11.75" stroke="#FF4747" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <span> Closed</span>
                            </div>
                            <div class="position-absolute fs-12 start-0 bottom-0" style="border-radius: 0px 15px 0px 0px;
                            background: #EEF6FF;padding: 6px 4px;">
                                Posted <?=$row->job_created_at;?>
                            </div>
                            <div class="row mx-auto">
                                <div class="col-md-7">
                                    <h5><?=$row->job_title;?> (<?=$row->salary_min;?><?=$row->salary_type;?> - <?=$row->salary_max;?><?=$row->salary_type;?>)</h5>
                                    <p class="fs-14">  </p>
                                    <div class="quali">
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                                <path d="M10.8917 8.92373C11.3979 8.21645 11.67 7.36849 11.67 6.49873C11.67 5.62897 11.3979 4.78101 10.8917 4.07373C11.3656 3.75084 11.9265 3.57939 12.5 3.58206C13.2735 3.58206 14.0154 3.88935 14.5624 4.43633C15.1094 4.98332 15.4167 5.72518 15.4167 6.49873C15.4167 7.27228 15.1094 8.01414 14.5624 8.56112C14.0154 9.1081 13.2735 9.4154 12.5 9.4154C11.9265 9.41806 11.3656 9.24662 10.8917 8.92373ZM4.58332 6.49873C4.58332 5.92187 4.75438 5.35796 5.07487 4.87832C5.39536 4.39867 5.85088 4.02484 6.38383 3.80408C6.91678 3.58332 7.50323 3.52556 8.069 3.6381C8.63478 3.75065 9.15448 4.02843 9.56238 4.43633C9.97029 4.84424 10.2481 5.36394 10.3606 5.92972C10.4732 6.49549 10.4154 7.08194 10.1946 7.61489C9.97388 8.14784 9.60005 8.60336 9.1204 8.92385C8.64076 9.24434 8.07685 9.4154 7.49999 9.4154C6.72644 9.4154 5.98458 9.1081 5.4376 8.56112C4.89061 8.01414 4.58332 7.27228 4.58332 6.49873ZM6.24999 6.49873C6.24999 6.74595 6.3233 6.98763 6.46065 7.19319C6.598 7.39875 6.79323 7.55897 7.02164 7.65358C7.25004 7.74819 7.50138 7.77294 7.74385 7.72471C7.98633 7.67648 8.20906 7.55743 8.38387 7.38261C8.55869 7.2078 8.67774 6.98507 8.72597 6.74259C8.7742 6.50012 8.74945 6.24878 8.65484 6.02037C8.56023 5.79197 8.40001 5.59674 8.19445 5.45939C7.98889 5.32204 7.74722 5.24873 7.49999 5.24873C7.16847 5.24873 6.85053 5.38042 6.61611 5.61484C6.38169 5.84927 6.24999 6.16721 6.24999 6.49873ZM13.3333 14.4154V16.0821H1.66666V14.4154C1.66666 14.4154 1.66666 11.0821 7.49999 11.0821C13.3333 11.0821 13.3333 14.4154 13.3333 14.4154ZM11.6667 14.4154C11.55 13.7654 10.5583 12.7487 7.49999 12.7487C4.44166 12.7487 3.39166 13.8404 3.33332 14.4154M13.2917 11.0821C13.8024 11.4793 14.22 11.9836 14.5151 12.5595C14.8103 13.1353 14.9758 13.7688 15 14.4154V16.0821H18.3333V14.4154C18.3333 14.4154 18.3333 11.3904 13.2833 11.0821H13.2917Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg>
                                            <?=$row->total_applicant;?> Applicants
                                        </span>
                                        <span>
                                            <img src="<?=base_url('assets/newAssets/img/')?>grommet-icons.svg" alt="">
                                            <?=$row->total_rejected;?> Rejected
                                        </span>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                                <g clip-path="url(#clip0_1891_4549)">
                                                  <path d="M8.45477 8.70703L11.5452 11.7974M11.5452 8.70703L8.45477 11.7974" stroke="#FF3232" stroke-width="0.64" stroke-linecap="round" stroke-linejoin="round"></path>
                                                  <path d="M4.84913 0.980469H16.1808C16.454 0.980469 16.716 1.08898 16.9091 1.28214C17.1023 1.4753 17.2108 1.73728 17.2108 2.01044V18.493C17.2108 18.7661 17.1023 19.0281 16.9091 19.2213C16.716 19.4144 16.454 19.5229 16.1808 19.5229H3.81916C3.54599 19.5229 3.28401 19.4144 3.09086 19.2213C2.8977 19.0281 2.78918 18.7661 2.78918 18.493V3.04091M4.84913 0.980469L2.78918 3.04091M4.84913 0.980469V3.04091H2.78918" stroke="#FF4747" stroke-width="0.64" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </g>
                                                <defs>
                                                  <clipPath id="clip0_1891_4549">
                                                    <rect width="20" height="20" fill="white" transform="translate(0 0.25)"></rect>
                                                  </clipPath>
                                                </defs>
                                            </svg> <?=$row->employment_type;?>
                                        </span>
                                    </div>
                                    <div class="d-flex gap-2 mt-3 fs-14" style="overflow: auto;">
                                        <div class="job-cat-btn"><?=$row->job_type;?></div>
                                        <div class="job-cat-btn"><?=$row->employment_type;?></div>
                                        <?php 
									$skills = explode(',', $row->job_skills);

									foreach ($skills as $skill) {
										$skill = trim($skill);

										if (!empty($skill)) {
											?>
											<div class="job-cat-btn"><?= htmlspecialchars(ucfirst($skill)); ?></div>
											<?php
										}
									}
									?>
                                    </div>
                                </div>
                                <div class="col-md-2 mt-2"></div>
                                <div class="col-md-3 my-auto cardbtnFlex">
                                    <button onclick="Delete(<?=$row->job_id?>,'post_job')" class="btn-outline-red w-100 mb-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.75 3V1.5H10.25V3H5.75ZM4.25 3V1C4.25 0.734784 4.35536 0.48043 4.54289 0.292893C4.73043 0.105357 4.98478 0 5.25 0L10.75 0C11.0152 0 11.2696 0.105357 11.4571 0.292893C11.6446 0.48043 11.75 0.734784 11.75 1V3H14.25C14.4489 3 14.6397 3.07902 14.7803 3.21967C14.921 3.36032 15 3.55109 15 3.75C15 3.94891 14.921 4.13968 14.7803 4.28033C14.6397 4.42098 14.4489 4.5 14.25 4.5H13.885L13.142 14.153C13.1034 14.6554 12.8767 15.1248 12.507 15.4673C12.1373 15.8097 11.6519 16 11.148 16H4.852C4.34808 16 3.86274 15.8097 3.49304 15.4673C3.12335 15.1248 2.89655 14.6554 2.858 14.153L2.115 4.5H1.75C1.55109 4.5 1.36032 4.42098 1.21967 4.28033C1.07902 4.13968 1 3.94891 1 3.75C1 3.55109 1.07902 3.36032 1.21967 3.21967C1.36032 3.07902 1.55109 3 1.75 3H4.25ZM3.62 4.5H12.38L11.646 14.038C11.6364 14.1636 11.5798 14.2809 11.4875 14.3666C11.3952 14.4522 11.2739 14.4999 11.148 14.5H4.852C4.72607 14.4999 4.60482 14.4522 4.5125 14.3666C4.42017 14.2809 4.36357 14.1636 4.354 14.038L3.62 4.5Z" fill="#FF4747"/>
                                        </svg>
                                         Delete Job
                                    </button>
                                    <button class="btn-custom w-100" onclick="Status(<?=$row->job_id?>,0,'active')">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                            <path d="M4.49836 2L11.5024 2.00133C12.1425 2.00128 12.7582 2.24677 13.2227 2.6872C13.6872 3.12764 13.9651 3.72946 13.999 4.36867L14.0024 4.502V7.49667C14.0023 7.62335 13.9542 7.74529 13.8677 7.83786C13.7812 7.93043 13.6628 7.98672 13.5364 7.99535C13.41 8.00399 13.2851 7.96432 13.1868 7.88438C13.0886 7.80443 13.0243 7.69017 13.007 7.56467L13.0024 7.49667V4.50133C13.0024 3.708 12.3857 3.058 11.605 3.00467L11.5024 3.00133L4.49836 3C4.12277 2.99995 3.76083 3.1408 3.48408 3.39472C3.20733 3.64863 3.03591 3.99713 3.00369 4.37133L2.99836 4.47733L2.99969 11.5013C3.00013 11.8814 3.14462 12.2471 3.40405 12.5249C3.66348 12.8026 4.01855 12.9717 4.39769 12.998L4.50036 13.0013H7.49769C7.62437 13.0014 7.74632 13.0495 7.83888 13.136C7.93145 13.2225 7.98774 13.3409 7.99637 13.4673C8.00501 13.5936 7.96535 13.7186 7.8854 13.8169C7.80546 13.9151 7.69119 13.9794 7.56569 13.9967L7.49769 14.0013H4.50036C3.86036 14.0014 3.24471 13.756 2.78023 13.3157C2.31576 12.8754 2.03782 12.2738 2.00369 11.6347L1.99969 11.5013L1.99902 4.50133L2.00169 4.366C2.03472 3.74987 2.29442 3.16773 2.73084 2.73156C3.16725 2.29539 3.74955 2.03601 4.36569 2.00333L4.49836 2ZM10.8364 6C10.963 6.00004 11.085 6.04816 11.1776 6.13465C11.2701 6.22113 11.3264 6.33953 11.335 6.46592C11.3437 6.59231 11.304 6.71726 11.2241 6.81553C11.1441 6.9138 11.0299 6.97807 10.9044 6.99533L10.8364 7L7.70702 6.99933L12.523 11.8127C12.6079 11.8974 12.6595 12.0097 12.6684 12.1293C12.6773 12.2488 12.643 12.3676 12.5717 12.464L12.523 12.52C12.4383 12.6049 12.326 12.6564 12.2064 12.6654C12.0868 12.6743 11.9681 12.64 11.8717 12.5687L11.8157 12.52L7.00036 7.70667V10.834C7.00035 10.9548 6.9566 11.0716 6.87718 11.1626C6.79776 11.2537 6.68806 11.3129 6.56836 11.3293L6.50036 11.334C6.37953 11.334 6.2628 11.2902 6.17174 11.2108C6.08068 11.1314 6.02146 11.0217 6.00502 10.902L6.00036 10.8333V6.48933C6.00036 6.47289 6.00147 6.456 6.00369 6.43867L6.01769 6.36667L6.04102 6.30267L6.04436 6.29467C6.06837 6.23895 6.10302 6.18845 6.14636 6.146L6.17569 6.11933L6.22969 6.07933L6.26969 6.056L6.33302 6.028L6.37769 6.01467L6.41902 6.006L6.48036 6H10.8364Z" fill="white"/>
                                        </svg> Re-open</button>
                                </div>
                            </div>
							
                            <div class="d-flex justify-content-end gap-2 mb-2">
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                        <path d="M12.5673 7.24891C12.7446 7.49741 12.8333 7.62224 12.8333 7.80599C12.8333 7.99032 12.7446 8.11457 12.5673 8.36307C11.7705 9.48074 9.73521 11.8893 6.99996 11.8893C4.26413 11.8893 2.22946 9.48016 1.43263 8.36307C1.25529 8.11457 1.16663 7.98974 1.16663 7.80599C1.16663 7.62166 1.25529 7.49741 1.43263 7.24891C2.22946 6.13124 4.26471 3.72266 6.99996 3.72266C9.73579 3.72266 11.7705 6.13182 12.5673 7.24891Z" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M8.75 7.80469C8.75 7.34056 8.56563 6.89544 8.23744 6.56725C7.90925 6.23906 7.46413 6.05469 7 6.05469C6.53587 6.05469 6.09075 6.23906 5.76256 6.56725C5.43437 6.89544 5.25 7.34056 5.25 7.80469C5.25 8.26882 5.43437 8.71394 5.76256 9.04212C6.09075 9.37031 6.53587 9.55469 7 9.55469C7.46413 9.55469 7.90925 9.37031 8.23744 9.04212C8.56563 8.71394 8.75 8.26882 8.75 7.80469Z" stroke="#202020" stroke-opacity="0.8" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg> <?=$row->views;?> Views
                                </span>
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                        <g clip-path="url(#clip0_1891_4575)">
                                          <path d="M12.5549 8.18066C12.7779 8.60405 12.9153 9.06723 12.9593 9.54375C13.0032 10.0203 12.9528 10.5008 12.811 10.9578C12.6691 11.4148 12.4386 11.8394 12.1325 12.2073C11.8265 12.5752 11.451 12.8792 11.0274 13.1019L9.8576 13.7182L9.56995 13.8695C9.30567 14.0086 9.01298 14.085 8.71445 14.093C8.41593 14.101 8.11956 14.0403 7.84822 13.9156L3.27971 11.9638L3.70991 10.6875L6.42687 11.2123L5.01981 8.53865L2.75457 4.23444L3.85808 3.65388L6.12335 7.95934L6.66842 7.67264L5.6698 5.77376L6.77271 5.19352L7.7713 7.09241L8.3164 6.80571L7.54531 5.34014L8.64885 4.75958L9.41994 6.22515L9.96531 5.93596L9.4361 4.92736L10.5393 4.34838L11.0685 5.35696L12.5546 8.18159L12.5549 8.18066ZM2.00344 4.8153C1.7742 4.58586 1.61806 4.29364 1.55475 3.97554C1.49144 3.65744 1.52379 3.32771 1.64771 3.02798C1.77164 2.72824 1.98158 2.47194 2.25104 2.29142C2.5205 2.1109 2.83741 2.01426 3.16175 2.01369C3.42458 2.01399 3.68351 2.07732 3.91681 2.19838C4.1501 2.31944 4.35096 2.4947 4.50251 2.70944C4.65407 2.92418 4.7519 3.17214 4.78781 3.43251C4.82371 3.69288 4.79664 3.95807 4.70886 4.20581L4.99837 4.75304C5.19203 4.42839 5.29627 4.05825 5.30049 3.68025C5.3047 3.30225 5.20875 2.92987 5.02239 2.60098C4.83602 2.27209 4.56589 1.99841 4.23946 1.80777C3.91302 1.61714 3.54193 1.51634 3.16391 1.51562C2.60996 1.5157 2.07764 1.73066 1.67898 2.11527C1.28031 2.49987 1.04638 3.02413 1.02642 3.57772C1.00645 4.1313 1.20201 4.67105 1.57194 5.08337C1.94187 5.49569 2.45732 5.74844 3.00983 5.78841L2.71875 5.23492C2.44817 5.15896 2.20178 5.01442 2.00344 4.8153Z" fill="#202020" fill-opacity="0.8"></path>
                                        </g>
                                        <defs>
                                          <clipPath id="clip0_1891_4575">
                                            <rect width="14" height="14" fill="white" transform="translate(0 0.804688)"></rect>
                                          </clipPath>
                                        </defs>
                                    </svg>
                                </span> <?=$row->clicks;?> Clicks
                            </div>
                        </div>
					<?php } } ?>
                       
                       <!--no data div-->
                       
        				<!--no data div end-->
                    </div>
                    
                </div>
            </div>
        </div>
    </div>

    <?php require'footer.php';?>
    <?php require'js.php';?>
	
	<script>
	 $(document).ready(function() {
			loadCandidate();
			recruitmentJourney();
	 });
	 function loadCandidate() {
			id=$('#job_id').val();
			// alert(id);
			$.ajax({
				url: "<?= base_url('employer/load_candidates'); ?>",
				type: "POST",
				data: {id: id},
				dataType: "json",
				success: function(response) {
					$('#candidates').html(response.html);
				}
			});
		}
		function recruitmentJourney() {
			id=$('#job_id').val();
			// alert(id);
			$.ajax({
				url: "<?= base_url('employer/recruitment_journey'); ?>",
				type: "POST",
				data: {id: id},
				dataType: "json",
				success: function(response) {
					console.log(response);
					$('#applicants').html(response.applicants);
					$('#applicant_active').html('+'+response.applicant_active);
					$('#shortlist').html(response.shortlist);
					$('#rejected').html(response.rejected);
					$('#withdraw').html(response.withdraw);
					$('#shortlist_active').html('+'+response.shortlist_active);
					$('#rejected_active').html('+'+response.rejected_active);
					$('#withdraw_active').html('+'+response.withdraw_active);
				}
			});
		}
	</script>
</body>
</html>