<!DOCTYPE html>
<html lang="en">
    <?php require'css.php';?>
<body>
<style>

	.bootstrap-tagsinput {
		display: block !important;
		white-space: normal !important;
		max-width: 100%;
		min-height: 40px; /* Adjust height as needed */
		overflow-wrap: break-word;
		word-wrap: break-word;
		padding: 5px;
	}
	.bootstrap-tagsinput .tag {
		background: #0d6efd;
		display: inline-block;
		margin: 2px;
		white-space: normal;
		word-break: break-word;
		padding: 5px 8px;
		border-radius: 20px;
	}

</style>
    <div class="mb-5">
        <div class="customDivCol pt-4">
            <?php require'header.php';?>
        </div>
        <div class="customDivCol profileCard mt-3">
            <div class="row container mx-auto">
                <div class="col-md-7 my-auto">
                    <h3>Post New Job</h3><br>
                    <h5>Find the Right Talent, Fast!</h5>
                    <p>Simplify your hiring process by posting jobs in just a few clicks. <br>Attract the best candidates and build your dream team effortlessly</p>
                </div>
                <div class="col-md-5 mob-hide">
                    <img src="<?=base_url('assets/newAssets/img/')?>profileImg.png" alt="" style="width: 400px;">
                </div>
            </div>
        </div>
		<form method="post" action="<?=base_url('employer/submit-job')?>" id="submitForm">
		<input type="hidden" name="id" value="<?=$job->id ?? '';?>">
        <div class="col-md-10 mx-auto mt-5">
            
                <div class="col-md-12 px-2">
                    <div class="row gy-4 mx-0">
					 <h4 class="">Basic Details </h4>
					<div class="profileCard py-5 row mx-0 gy-4" style="box-shadow: 0px 3px 12px 0px rgba(0, 0, 0, 0.10);">
                        <div class="col-md-4">
							<label class="form-label">Job Title <span class="text-danger">*</span></label>
							<input type="text" id="jobTitle" name="title" value="<?=$job->jTitle ?? '';?>" class="form-control shadow-none" placeholder="Job title*" autocomplete="off">
							<div id="jobTitleList" class="list-group" style="position: absolute; z-index: 1000;"></div>
						</div>
                        <div class="col-md-4">
							<label class="form-label">Openings <span class="text-danger">*</span></label>
                            <input type="number" name="opening" value="<?=$job->nOpen ?? '';?>" class="form-control shadow-none" min="1" placeholder="No. Of Openings*">
                        </div>
						<div class="col-sm-4">
							<label for="location" class="form-label">Job Tag <span class="text-danger">*</span></label>
							<select class="form-control" name="tag" required>
								<option value='' selected disabled>Choose</option>
								<?php foreach($tag as $row){?>
									<option value='<?=$row->value;?>' ><?=$row->title;?></option>
								<?php } ?>
							</select>
						</div>
                        </div>
						 <h4 class="">Candidates Requirements </h4>
						<div class="profileCard py-5 row mx-0 gy-4" style="box-shadow: 0px 3px 12px 0px rgba(0, 0, 0, 0.10);">
						
						 <div class="col-sm-12">
							<label class="form-label">Skills <span class="text-danger">*</span></label>
							<input type="text" name="skills" class="form-control shadow-none" data-role="tagsinput" required>
						</div>
						
						<div class="col-sm-4">
							<label for="location" class="form-label">Employment Type <span class="text-danger">*</span></label>
							<select class="form-control" name="employment_type" required>
								<option value='' selected disabled>Choose</option>
								<?php foreach($employement_type as $row){?>
									<option value='<?=$row->value;?>' ><?=$row->title;?></option>
								<?php } ?>
							</select>
						</div>
						<div class="col-sm-4">
							<label for="location" class="form-label">Job Type <span class="text-danger">*</span></label>
							<select class="form-control" name="job_type" required>
								<option value='' selected disabled>Choose</option>
								<?php foreach($job_type as $row){?>
									<option value='<?=$row->value;?>' ><?=$row->title;?></option>
								<?php } ?>
							</select>
						</div>
						<div class="col-sm-4">
							<label for="location" class="form-label">Shift <span class="text-danger">*</span></label>
							<select class="form-control" name="shift" required>
								<option value='' selected disabled>Choose</option>
								<?php foreach($shift as $row){?>
									<option value='<?=$row->value;?>' ><?=$row->title;?></option>
								<?php } ?>
							</select>
						</div>
						<div class="col-sm-4">
							<label for="location" class="form-label">Experience <span class="text-danger">*</span></label>
							<select class="form-control" name="experience" required>
								<option value='' selected disabled>Choose</option>
								<?php foreach($experience as $row){?>
									<option value='<?=$row->value;?>' ><?=$row->title;?></option>
								<?php } ?>
							</select>
						</div>
						<div class="col-sm-4">
							<label for="location" class="form-label">Qualification <span class="text-danger">*</span></label>
							<select class="form-control" name="qualification" required>
								<option value='' selected disabled>Choose</option>
								<?php foreach($qualification as $row){?>
									<option value='<?=$row->value;?>' ><?=$row->title;?></option>
								<?php } ?>
							</select>
						</div>
						<div class="col-sm-4">
							<label for="location" class="form-label">Candidates Gender <span class="text-danger"></span></label>
							<select class="form-control" name="gender" >
								<option value='' selected disabled>Choose</option>
								<option value="Male">Male</option>
								<option value="Female">Female</option>
								<option value="Any">Any</option>
							</select>
						</div>
						</div>
						<h4 class="">Job Description </h4>
						<div class="profileCard py-5 row mx-0 gy-4" style="box-shadow: 0px 3px 12px 0px rgba(0, 0, 0, 0.10);">
						<div class="col-sm-4">
							<label for="location" class="form-label">Communication <span class="text-danger">*</span></label>
							<select class="form-control" name="communication" required>
								<option value='' selected disabled>Choose</option>
								<?php foreach($communication as $row){?>
									<option value='<?=$row->value;?>' ><?=$row->title;?></option>
								<?php } ?>
							</select>
						</div>
						
						<div class="col-sm-4">
							<label for="location" class="form-label">Salary Type <span class="text-danger">*</span></label>
							<select class="form-control" name="salary_type" required>
								<option value='' selected disabled>Choose</option>
								<?php foreach($salary_type as $row){?>
									<option value='<?=$row->value;?>' ><?=$row->title;?></option>
								<?php } ?>
							</select>
						</div>
						
						<div class="col-sm-4">
							<label class="form-label">Minimum <span class="text-danger">*</span></label>
                            <input type="number" name="min" min='1' value="<?=$job->sMin ?? '';?>" class="form-control shadow-none" placeholder="Min Salary">
                        </div>
						<div class="col-sm-4">
							<label class="form-label">Maximum <span class="text-danger">*</span></label>
                            <input type="number" name="max" min='1' value="<?=$job->sMax ?? '';?>" class="form-control shadow-none" placeholder="Max Salary">
							<div class="text-danger" id="salary-error" style="font-size: 14px;"></div>

                        </div>
						<div class="col-sm-4">
							<label for="location" class="form-label">From<span class="text-danger">*</span></label>
							<select class="form-control" name="from_day" required>
								<option value='' selected disabled>Choose</option>
								<?php 
								$days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
								foreach ($days as $day) { ?>
									<option value='<?= strtolower($day); ?>'><?= $day; ?></option>
								<?php } ?>
							</select>
						</div>
						<div class="col-sm-4">
							<label for="location" class="form-label">To<span class="text-danger">*</span></label>
							<select class="form-control" name="to_day" required>
								<option value='' selected disabled>Choose</option>
								<?php 
								foreach ($days as $day) { ?>
									<option value='<?= strtolower($day); ?>'><?= $day; ?></option>
								<?php } ?>
							</select>
						</div>
						
						<div class="col-sm-12">
							<label for="" class="form-label">Job Description<span class="text-danger">*</span></label>
							<textarea class="form-control editor" name="des" rows="5" required><?=$job->jobDescription ?? '';?></textarea>
						</div>
                    </div>
					
					 <h4 class="">Job Location</h4>
						<div class="profileCard row mx-0" style="box-shadow: 0px 3px 12px 0px rgba(0, 0, 0, 0.10);">
						   
						  <div class="mob-hide px-0">
    						<div class="alert alert-info mb-0 d-flex align-items-center justify-content-between p-2 rounded shadow-sm" role="alert" style="font-size: 16px;">
    						  <div>
    							<i class="bi bi-geo-alt-fill me-2 text-primary"></i>
    							<strong>Update Address?</strong> Would you like to change the address for this job post?
    						  </div>
    						  <div>
    							<button class="btn btn-outline-secondary me-2" type="button" onclick="handleAddressChange(false)">
    							  <i class="bi bi-x-circle"></i> No
    							</button>
    							<button class="btn btn-success" type="button" onclick="handleAddressChange(true)">
    							  <i class="bi bi-check-circle"></i> Yes
    							</button>
    						  </div>
    						</div>
    					</div>
						
						<div class="mob-show p-2" role="alert" style="font-size: 16px;">
						  <div>
							<i class="bi bi-geo-alt-fill me-2 text-primary"></i>
							<strong>Update Address?</strong> Would you like to change the address for this job post?
						  </div>
						  <div class="text-center">
							<button class="btn btn-outline-secondary me-2" type="button" onclick="handleAddressChange(false)">
							  <i class="bi bi-x-circle"></i> No
							</button>
							<button class="btn btn-success" type="button" onclick="handleAddressChange(true)">
							  <i class="bi bi-check-circle"></i> Yes
							</button>
						  </div>
						</div>

						<div class="col-md-3 address_class mt-3">
						<label class="formLabel small">State*</label>
						<select class="form-control" name="state" id="state_id1" onchange="getDistrict1();" >
							<option value='' selected disabled>Choose</option>
							<?php foreach($states as $row){ ?>
								<option value='<?=$row->state_id;?>' 
									<?php if(!empty($job->state) && $job->state == $row->state_id) { echo 'selected'; } ?>>
									<?=$row->state_title;?>
								</option>
							<?php } ?>
						</select>
					</div>

					<div class="col-md-3 address_class mt-3">
						<label class="formLabel small">District*</label>
						<select class="form-control" name="district" id="district_id1" onchange="getCity1();" >
							<option value='' selected disabled>Choose</option>
						</select>
					</div>

					<div class="col-md-3 address_class mt-3">
						<label class="formLabel small">City*</label>
						<select class="form-control" name="city" id="city_id1" >
							<option value='' selected disabled>Choose</option>
						</select>
					</div>

					
					<div class="col-md-3 address_class mt-3">
                        <label class="formLabel small">Pincode</label>
                        <input type="text" maxlength="6" onchange="this.value=this.value.replace(/[^\d]/ig,'')" onkeyup="this.value=this.value.replace(/[^\d]/ig,'')" name="pincode" value="<?=$job->zip ?? '';?>" placeholder="Enter Pincode" class="form-control" >
                    </div>
						 <div class="col-sm-12 address_class mt-3">
							<label class="form-label">Full Address <span class="text-danger">*</span></label>
							<input type="text" name="address" class="form-control shadow-none" value="<?=$job->adress ?? ''; ?>">
						</div>
						
						
					</div>
						
                </div>
            </div>
        </div>
       
        <div class="col-md-10 mx-auto mt-5">
            <div class="d-flex justify-content-center gap-4 my-5">
				 <button type="submit" class="btn btn-custom" id="submitBtn">Submit Job Listing<i class="fa fa-spinner fa-spin" id="submitSpin" style="display:none;" ></i></button>
            </div>
        </div>
		</form>
    </div>


    <?php require'footer.php';?>
    <?php require'js.php';?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.js"></script>
    <script>
$(document).ready(function() {
        $('.editor').summernote({
            height: 200
        });
		$('.address_class').css('display','none');
		<?php 
	if(!empty($job)){ ?>
		$('.address_class').css('display','block');
		$('[name="skills"]').tagsinput('removeAll'); 
		$('[name="skills"]').tagsinput('add', "<?=$job->skills;?>");
		$('[name="employment_type"]').val("<?=$job->emp_type;?>");
		$('[name="job_type"]').val("<?=$job->jobtype;?>");
		$('[name="shift"]').val("<?=$job->shift;?>");
		$('[name="experience"]').val("<?=$job->experience;?>");
		$('[name="qualification"]').val("<?=$job->quali;?>");
		$('[name="communication"]').val("<?=$job->c_eng;?>");
		$('[name="salary_type"]').val("<?=$job->sType;?>");
		$('[name="from_day"]').val("<?=$job->dayFrom;?>");
		$('[name="to_day"]').val("<?=$job->dayTo;?>");
		$('[name="tag"]').val("<?=$job->tag;?>");
		$('[name="gender"]').val("<?=$job->gender;?>");
		
		var stateId = "<?= !empty($job->state) ? $job->state : '' ?>";
    var districtId = "<?= !empty($job->District) ? $job->District : '' ?>";
    var cityId = "<?= !empty($job->city) ? $job->city : '' ?>";

    if (stateId) {
        getDistrictf(stateId, districtId);
    }

    function getDistrictf(stateId, selectedDistrict = '') {
        $.post("<?= base_url('employer/get_districts'); ?>", { state_id: stateId }, function(response) {
            $('#district_id1').html('<option value="">Choose</option>');
            $.each(response, function(index, value) {
                var selected = (value.districtid == selectedDistrict) ? 'selected' : '';
                $('#district_id1').append('<option value="'+value.districtid+'" '+selected+'>'+value.district_title+'</option>');
            });

            if (selectedDistrict) {
                getCityf(selectedDistrict, cityId);
            }
        }, "json");
    }

    function getCityf(districtId, selectedCity = '') {
        $.post("<?= base_url('employer/get_cities'); ?>", { district_id: districtId }, function(response) {
            $('#city_id1').html('<option value="">Choose</option>');
            $.each(response, function(index, value) {
                var selected = (value.name == selectedCity) ? 'selected' : '';
                $('#city_id1').append('<option value="'+value.name+'" '+selected+'>'+value.name+'</option>');
            });
        }, "json");
    }

    $('#state_id1').change(function() {
        var stateId = $(this).val();
        getDistrict(stateId);
    });

    $('#district_id1').change(function() {
        var districtId = $(this).val();
        getCity(districtId);
    });
	<?php }	?>
	 
	 $('#jobTitle').keyup(function(){
        var query = $(this).val();
        if(query != '') {
            $.ajax({
                url: "<?= base_url('employer/get-job-list') ?>",
                method: "POST",
                data: {query: query},
                success: function(res) {
                    var response = JSON.parse(res);
                    if(response.status == 'success' && response.data.length > 0) {
                        var html = '<ul class="list-group">';
                        $.each(response.data, function(index, item){
                            html += '<li class="list-group-item job-title-item" style="cursor:pointer;">'+item.title+'</li>';
                        });
                        html += '</ul>';
                        $('#jobTitleList').fadeIn();
                        $('#jobTitleList').html(html);
                    } else {
                        $('#jobTitleList').fadeOut();
                        $('#jobTitleList').html('');
                    }
                },
				error: function(err) {
					console.log(err);
				}
            });
        } else {
            $('#jobTitleList').fadeOut();
            $('#jobTitleList').html('');
        }
    });

    $(document).on('click', '.job-title-item', function(){
        $('#jobTitle').val($(this).text());
        $('#jobTitleList').fadeOut();
    });
	
	$('input[name="min"], input[name="max"]').on('input', function() {
        var min = parseFloat($('input[name="min"]').val()) || 0;
        var max = parseFloat($('input[name="max"]').val()) || 0;

        if (min >= max && max > 0) {
            $('#submitBtn').attr('disabled',true);
            $('#salary-error').text('Max salary must be greater than Min salary.');
        } else {
			 $('#submitBtn').attr('disabled',false);
            $('#salary-error').text('');
        }
    });
    });
	
	function handleAddressChange(value){
		if(value===true){
			$('.address_class').css('display','block');
		}else{
			$('.address_class').css('display','none');
		}
	}
	
        const ctx = document.getElementById('jobPostingsChart').getContext('2d');
        const jobPostingsChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['14 Jan', '15 Jan', '16 Jan', '17 Jan', '18 Jan', '19 Jan', '20 Jan'],
                datasets: [
                    {
                        label: 'Application',
                        data: [50, 70, 90, 110, 120, 130, 139,160],
                        borderColor: '#007bff',
                        backgroundColor: 'rgba(0, 123, 255, 0.1)',
                        fill: true,
                        tension: 0.4
                    },
                    {
                        label: 'Shortlisted',
                        data: [30, 50, 70, 90, 100, 110, 114,178],
                        borderColor: '#28a745',
                        backgroundColor: 'rgba(40, 167, 69, 0.1)',
                        fill: true,
                        tension: 0.4
                    },
                    {
                        label: 'Rejected',
                        data: [10, 20, 30, 50, 60, 65, 67,109,190],
                        borderColor: '#dc3545',
                        backgroundColor: 'rgba(220, 53, 69, 0.1)',
                        fill: true,
                        tension: 0.4
                    }
                ]
            },
            options: {
                responsive: true,
                plugins: {
                    tooltip: {
                        mode: 'index',
                        intersect: false
                    },
                    legend: {
                        display: true,
                        position: 'top'
                    }
                },
                scales: {
                    x: {
                        grid: {
                            display: false
                        }
                    },
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(200, 200, 200, 0.3)'
                        },
                        ticks: {
                            stepSize: 30
                        }
                    }
                }
            }
        });
    

</script>
</body>
</html>