<?php

/**
 * Created by PhpStorm.
 * User: sam
 * Date: 1/11/2017
 * Time: 12:40 PM
 */
class Common_model extends CI_Model
{
    /*
     * Construct
     */
	public function __construct()
    {
        parent::__construct();
        $this->load->library('firebase');
    }

	
	public function getCareerPreference($emp_id,$limit,$offset,$search){
		$this->db->select('career_preferences.*, state.state_title')
				 ->from('career_preferences')
				 ->join('state', 'state.state_id = career_preferences.p_state', 'left')
				 ->where('career_preferences.created_by', $emp_id);

		if (!empty($search)) {
			$this->db->group_start()
					 ->like('career_preferences.p_job_roles', $search)
					 ->or_like('career_preferences.skills', $search)
					 ->or_like('career_preferences.t_exp_type', $search)
					 ->or_like('career_preferences.p_cities', $search)
					 ->or_like('career_preferences.p_skills', $search)
					 ->or_like('state.state_title', $search)
					 ->group_end();
		}

		$total_query = clone $this->db;
		$total_count = $total_query->count_all_results(null, false); 

		$data = $this->db->limit($limit, $offset)->get()->result();
		$res=[
			'data'=>$data,
			'count'=>$total_count
		];
		return json_encode($res);
	}
	
	
	public function get_similar_job($job_id) {
		$job=$this->db->where(['id'=> $job_id])->get('post_job')->row();
		$this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			
		');
		$this->db->from('post_job');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id');
		$this->db->join('state as coms', 'about_com.state = coms.state_id');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid');
		$this->db->join('district as comd', 'about_com.District = comd.districtid');
		$this->db->where('about_com.status', 1);
		$this->db->where('post_job.status', 0);
		$this->db->where('post_job.id!=', $job_id);
		if (!empty($search)) {
			$this->db->group_start();
			$this->db->like('post_job.jTitle', $job->jTitle);
			$this->db->group_end();
		}
		$this->db->order_by('post_job.created_at', 'DESC')->limit(10);
		$query = $this->db->get()->result();
		$data=[];
		foreach($query as $row){
			$totalApplicant=$this->db->select('*')->from('applied_job_emp')->where('job_id', $row->job_id)->get()->num_rows();
			$row->job_created_at=$this->timeAgo($row->job_created_at);
			$row->total_applicant=$totalApplicant;
			$row->company_logo = base_url('jd/jdrec/documents/'.$row->company_logo);
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->job_shift=$this->orignalName($row->job_shift);
			$row->job_experience=$this->orignalName($row->job_experience);
			$row->job_qualification=$this->orignalName($row->job_qualification);
			$row->salary_type=$this->orignalName($row->salary_type);
			array_push($data,$row);
		}
		return $data;
	}
	
	public function get_latest_job($search = null,$emp_id=null) {
		
		$this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant
			
		');
		$this->db->from('post_job');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id');
		$this->db->join('state as coms', 'about_com.state = coms.state_id');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid');
		$this->db->join('district as comd', 'about_com.District = comd.districtid');
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);
		if (!empty($search)) {
			$this->db->group_start();
			$this->db->like('post_job.jTitle', $search);
			$this->db->or_like('post_job.skills', $search);
			$this->db->or_like('about_com.name', $search);
			$this->db->group_end();
		}
		$this->db->order_by('post_job.created_at', 'DESC')->limit(10);
		$query = $this->db->get()->result();
		foreach($query as $row){
			if(!empty($emp_id)){
				$save=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('emp_save_job')->num_rows();
				$applyC=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp');
				if($applyC->num_rows()==0){
					$apply=0;
				}else{
					$apply = ($applyC->row()->status == 3) ? 2 : 1;
				}
			}else{
				$save='0';
				$apply='0';
			}
			$row->job_created_at=$this->timeAgo($row->job_created_at);
			$row->company_logo = base_url('jd/jdrec/documents/'.$row->company_logo);
			$row->is_saved = "$save";
			$row->is_applied = "$apply";
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->job_shift=$this->orignalName($row->job_shift);
			$row->job_experience=$this->orignalName($row->job_experience);
			$row->job_qualification=$this->orignalName($row->job_qualification);
			$row->salary_type=$this->orignalName($row->salary_type);
		}
		return $query;
	}
	
	
	public function get_all_job($search = null, $emp_id = null, $limit, $offset,$filters=null) {
	   
		$this->db->select('COUNT(*) AS total_count');
		$this->db->from('post_job');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id');
		$this->db->join('state as coms', 'about_com.state = coms.state_id');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid');
		$this->db->join('district as comd', 'about_com.District = comd.districtid');
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);

		if (!empty($search)) {
			$this->db->group_start();
			$this->db->like('post_job.jTitle', $search);
			$this->db->or_like('post_job.skills', $search);
			$this->db->or_like('about_com.name', $search);
			$this->db->group_end();
		}
		$filterData = $this->buildFilters($filters);
		// if (!empty($filterData['conditions'])) {
			// foreach ($filterData['conditions'] as $condition) {
				// $this->db->where($condition, array_shift($filterData['params']));
			// }
		// }
		if (!empty($filterData['conditions'])) {
			foreach ($filterData['conditions'] as $condition) {
				$param = array_shift($filterData['params']);

				if (is_array($param)) {
					// Use whereIn for multi-select filters
					$this->db->where_in($condition, $param);
				} else {
					// Single value filter
					$this->db->where($condition, $param);
				}
			}
		}


		$total_count = $this->db->get()->row()->total_count;

		$this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant
		');

		$this->db->from('post_job');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id');
		$this->db->join('state as coms', 'about_com.state = coms.state_id');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid');
		$this->db->join('district as comd', 'about_com.District = comd.districtid');
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);
		if (!empty($search)) {
			$this->db->group_start();
			$this->db->like('post_job.jTitle', $search);
			$this->db->or_like('post_job.skills', $search);
			$this->db->or_like('about_com.name', $search);
			$this->db->group_end();
			
		}
		$filterData = $this->buildFilters($filters);
		// if (!empty($filterData['conditions'])) {
			// foreach ($filterData['conditions'] as $condition) {
				// $this->db->where($condition, array_shift($filterData['params']));
			// }
		// }
		if (!empty($filterData['conditions'])) {
			foreach ($filterData['conditions'] as $condition) {
				$param = array_shift($filterData['params']);

				if (is_array($param)) {
					// Use whereIn for multi-select filters
					$this->db->where_in($condition, $param);
				} else {
					// Single value filter
					$this->db->where($condition, $param);
				}
			}
		}

		$this->db->order_by('post_job.created_at', 'DESC');
		$this->db->limit($limit, $offset);
		$query = $this->db->get()->result();

		foreach ($query as $row) {
			if (!empty($emp_id)) {
				$career=$this->db->where(['created_by'=> $emp_id])->get('career_preferences')->num_rows();
				$save = $this->db->where(['emp_id' => $emp_id, 'job_id' => $row->job_id])->get('emp_save_job')->num_rows();
				$applyC=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp');
				if($applyC->num_rows()==0){
					$apply=0;
				}else{
					$apply = ($applyC->row()->status == 3) ? 2 : 1;
				}
			} else {
				$save = '0';
				$apply = '0';
				$career = '0';
			}
			$row->job_created_at = $this->timeAgo($row->job_created_at);
			$row->company_logo = base_url('jd/jdrec/documents/' . $row->company_logo);
			$row->is_saved = "$save";
			$row->is_applied = "$apply";
			$row->is_career = "$career";
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->job_shift=$this->orignalName($row->job_shift);
			$row->job_experience=$this->orignalName($row->job_experience);
			$row->job_qualification=$this->orignalName($row->job_qualification);
			$row->salary_type=$this->orignalName($row->salary_type);
		}

		$response = [
			'filters' => $this->getFilter(),
			'current_page' => ($offset / $limit) + 1,
			'total_pages' => ceil($total_count / $limit),
			'total_records' => $total_count,
			'records_per_page' => $limit,
			'data' => $query,
		];

		return $response;
	}

	
	public function getSavedJob($emp_id) {
		$this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant
		');
		
		$this->db->from('emp_save_job');
		$this->db->join('post_job', 'emp_save_job.job_id = post_job.id', 'inner');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by', 'left');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id', 'left');
		$this->db->join('state as coms', 'about_com.state = coms.state_id', 'left');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid', 'left');
		$this->db->join('district as comd', 'about_com.District = comd.districtid', 'left');
		
		$this->db->where('emp_save_job.emp_id', $emp_id);
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);
		$this->db->order_by('post_job.created_at', 'DESC');
		
		$query = $this->db->get()->result();

	 
		foreach ($query as $row) {
			if (!empty($emp_id)) {
				$save = $this->db->where(['emp_id' => $emp_id, 'job_id' => $row->job_id])->get('emp_save_job')->num_rows();
				$applyC=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp');
				if($applyC->num_rows()==0){
					$apply=0;
				}else{
					$apply = ($applyC->row()->status == 3) ? 2 : 1;
				}
			} else {
				$save = '0';
				$apply = '0';
			}
			$row->job_created_at = $this->timeAgo($row->job_created_at);
			$row->company_logo = base_url('jd/jdrec/documents/' . $row->company_logo);
			$row->is_saved = "$save";
			$row->is_applied = "$apply";
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->job_shift=$this->orignalName($row->job_shift);
			$row->job_experience=$this->orignalName($row->job_experience);
			$row->job_qualification=$this->orignalName($row->job_qualification);
			$row->salary_type=$this->orignalName($row->salary_type);
		}

		return $query;
	}

	public function getSavedJobCount($emp_id) {
		$this->db->from('emp_save_job');
		$this->db->join('post_job', 'emp_save_job.job_id = post_job.id', 'inner');
		$this->db->where('emp_save_job.emp_id', $emp_id);
		$this->db->where('post_job.status', 0);

		return $this->db->count_all_results();
	}

	
	public function getAppliedJob($emp_id) {
		$this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant
		');
		
		$this->db->from('applied_job_emp');
		$this->db->join('post_job', 'applied_job_emp.job_id = post_job.id', 'inner');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by', 'left');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id', 'left');
		$this->db->join('state as coms', 'about_com.state = coms.state_id', 'left');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid', 'left');
		$this->db->join('district as comd', 'about_com.District = comd.districtid', 'left');
		
		$this->db->where('applied_job_emp.emp_id', $emp_id);
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);
		$this->db->where('applied_job_emp.status!=', 3);
		$this->db->order_by('post_job.created_at', 'DESC');
		
		$query = $this->db->get()->result();

	 
		foreach ($query as $row) {
			if (!empty($emp_id)) {
				$save = $this->db->where(['emp_id' => $emp_id, 'job_id' => $row->job_id])->get('emp_save_job')->num_rows();
				$applyC=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp');
				if($applyC->num_rows()==0){
					$apply=0;
				}else{
					$apply = ($applyC->row()->status == 3) ? 2 : 1;
				}
			} else {
				$save = '0';
				$apply = '0';
			}
			$row->job_created_at = $this->timeAgo($row->job_created_at);
			$row->company_logo = base_url('jd/jdrec/documents/' . $row->company_logo);
			$row->is_saved = "$save";
			$row->is_applied = "$apply";
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->job_shift=$this->orignalName($row->job_shift);
			$row->job_experience=$this->orignalName($row->job_experience);
			$row->job_qualification=$this->orignalName($row->job_qualification);
			$row->salary_type=$this->orignalName($row->salary_type);
		}

		return $query;
	}
	
	public function getAppliedJobCount($emp_id) {
		$this->db->from('applied_job_emp');
		$this->db->join('post_job', 'applied_job_emp.job_id = post_job.id', 'inner');
		$this->db->where('applied_job_emp.emp_id', $emp_id);
		$this->db->where('applied_job_emp.status!=', 3);
		$this->db->where('post_job.status', 0);
		
		return $this->db->count_all_results();
	}

	public function getShortlistedCount($emp_id) {
		$this->db->from('applied_job_emp');
		$this->db->join('post_job', 'applied_job_emp.job_id = post_job.id', 'inner');
		$this->db->where('applied_job_emp.emp_id', $emp_id);
		$this->db->where('applied_job_emp.status', 1);
		$this->db->where('post_job.status', 0);
		
		return $this->db->count_all_results();
	}

	
	public function getLookbackJob($emp_id) {
		$this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant
		');
		
		$this->db->from('emp_view_job');
		$this->db->join('post_job', 'emp_view_job.job_id = post_job.id', 'inner');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by', 'left');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id', 'left');
		$this->db->join('state as coms', 'about_com.state = coms.state_id', 'left');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid', 'left');
		$this->db->join('district as comd', 'about_com.District = comd.districtid', 'left');
		
		$this->db->where('emp_view_job.emp_id', $emp_id);
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);
		$this->db->order_by('post_job.created_at', 'DESC');
		
		$query = $this->db->get()->result();

	 
		foreach ($query as $row) {
			if (!empty($emp_id)) {
				$save = $this->db->where(['emp_id' => $emp_id, 'job_id' => $row->job_id])->get('emp_save_job')->num_rows();
				$applyC=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp');
				if($applyC->num_rows()==0){
					$apply=0;
				}else{
					$apply = ($applyC->row()->status == 3) ? 2 : 1;
				}
			} else {
				$save = '0';
				$apply = '0';
			}
			$row->job_created_at = $this->timeAgo($row->job_created_at);
			$row->company_logo = base_url('jd/jdrec/documents/' . $row->company_logo);
			$row->is_saved = "$save";
			$row->is_applied = "$apply";
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->job_shift=$this->orignalName($row->job_shift);
			$row->job_experience=$this->orignalName($row->job_experience);
			$row->job_qualification=$this->orignalName($row->job_qualification);
			$row->salary_type=$this->orignalName($row->salary_type);
		}

		return $query;
	}
	
	public function getLookbackJobCount($emp_id) {
		$this->db->from('emp_view_job');
		$this->db->join('post_job', 'emp_view_job.job_id = post_job.id', 'inner');
		$this->db->where('emp_view_job.emp_id', $emp_id);
		$this->db->where('post_job.status', 0);

		return $this->db->count_all_results();
	}

	
	function getSingleJob($id,$emp_id=null) {
		$this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.com_type AS company_type,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			about_com.linkedin AS linkedin,
			about_com.r_name AS recruiter_name,
			about_com.r_mobile AS recruiter_contact,
			about_com.r_desig AS recruiter_designation,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.created_by AS rec_id,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant
		');
		$this->db->from('post_job');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id');
		$this->db->join('state as coms', 'about_com.state = coms.state_id');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid');
		$this->db->join('district as comd', 'about_com.District = comd.districtid');
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);
		$this->db->where('post_job.id', $id);
		$query = $this->db->get()->row();

		if ($query) {
			if(!empty($emp_id)){
				$career=$this->db->where(['created_by'=> $emp_id])->get('career_preferences')->num_rows();
				$save=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$query->job_id])->get('emp_save_job')->num_rows();
				$applyC=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$query->job_id])->get('applied_job_emp');
				if($applyC->num_rows()==0){
					$apply=0;
				}else{
					$apply = ($applyC->row()->status == 3) ? 2 : 1;
				}
			}else{
				$save='0';
				$apply='0';
				$career='0';
			}
			
			$query->job_created_at = $this->timeAgo($query->job_created_at);

			$query->company_logo = base_url('jd/jdrec/documents/'.$query->company_logo);
			$query->is_saved = "$save";
			$query->is_applied = "$apply";
			$query->is_career = "$career";
			$query->employment_type=$this->orignalName($query->employment_type);
			$query->job_type=$this->orignalName($query->job_type);
			$query->job_shift=$this->orignalName($query->job_shift);
			$query->job_experience=$this->orignalName($query->job_experience);
			$query->job_qualification=$this->orignalName($query->job_qualification);
			$query->salary_type=$this->orignalName($query->salary_type);
			$query->company_type=$this->orignalName($query->company_type);
			$query->recruiter_image=base_url('profile_pic/user.png');
			if(!empty($emp_id)){
				$exists = $this->db->where([
					'emp_id' => $emp_id,
					'job_id' => $id
				])->get('emp_view_job')->num_rows();
				if($exists==0){
					$this->lib_model->Insert('emp_view_job', ['emp_id'=>$emp_id,'rec_id'=>$query->rec_id,'job_id'=>$id]);
					
				}
			}
			return $query;
		} else {
			return null;
		}

	}
	function saveNotification($user_id,$title,$body,$type) {
		$data=[
			'user_id'=>$user_id,
			'title'=>$title,
			'body'=>$body,
			'type'=>$type,
		];
		$this->lib_model->Insert('tbl_notification_all', $data);
		$user=$this->db->select('*')->from($type)->where('id', $user_id)->get()->row();
		$token = array_filter([$user->f_token_web, $user->f_token_app]);
		if($token){
		return $this->firebase->send($user->f_token_web,$title,$body);
		}else{
			return true;
		}
	}
	function timeAgo($datetime) {
    $timestamp = strtotime($datetime);
    $current_time = time();
    $time_diff = $current_time - $timestamp;

    $seconds = $time_diff;
    $minutes = round($seconds / 60);
    $hours = round($seconds / 3600);
    $days = round($seconds / 86400);
    $weeks = round($seconds / 604800);
    $months = round($seconds / 2629440);
    $years = round($seconds / 31553280);

    if ($seconds < 60) {
        return "just now";
    } elseif ($minutes < 60) {
        return "$minutes min ago";
    } elseif ($hours < 24) {
        return "$hours hours ago";
    } elseif ($days < 7) {
        return "$days days ago";
    } elseif ($weeks < 4) {
        return "$weeks weeks ago";
    } elseif ($months < 12) {
        return "$months months ago";
    } else {
        return "$years years ago";
    }
}

	public function formatChatTime($timestamp)
	{
		if (empty($timestamp)) {
			return "";
		}

		$time = strtotime($timestamp);
		$now = time();
		$today = strtotime("today");
		$yesterday = strtotime("yesterday");

		if ($time >= $today) {
			return date("h:i A", $time);
		} elseif ($time >= $yesterday) {
			return "Yesterday";
		} else {
			return date("d/m/Y", $time);
		}
	}
	
	public function get_recommended_post_job($emp_id, $limit, $offset, $search = null,$filters=null) {
  
    $this->db->from('post_job');
    $this->db->join('about_com', 'post_job.created_by = about_com.created_by');
    $this->db->join('state as jobs', 'post_job.state = jobs.state_id');
    $this->db->join('district as jobd', 'post_job.District = jobd.districtid');
    $this->db->join('career_preferences', 
        "post_job.quali = career_preferences.qualification
        AND post_job.shift = career_preferences.p_shift
        AND post_job.emp_type = career_preferences.eTYpe
        AND post_job.jobtype = career_preferences.p_e_type
        AND post_job.state = career_preferences.p_state
        AND post_job.skills REGEXP CONCAT('(^|,)', REPLACE(career_preferences.skills, ',', '|'), '($|,)')", 'inner');
    $this->db->where('post_job.status', 0);
	$this->db->where('about_com.status', 1);
    $this->db->where('career_preferences.created_by', $emp_id);

    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('post_job.jTitle', $search);
        $this->db->or_like('post_job.skills', $search);
        $this->db->group_end();
    }
	$filterData = $this->buildFilters($filters);

	if (!empty($filterData['conditions'])) {
		foreach ($filterData['conditions'] as $condition) {
			$param = array_shift($filterData['params']);

			if (is_array($param)) {
				// Use whereIn for multi-select filters
				$this->db->where_in($condition, $param);
			} else {
				// Single value filter
				$this->db->where($condition, $param);
			}
		}
	}

    $total_count = $this->db->count_all_results();

    $this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant
    ');
	
		
    $this->db->from('post_job');
    $this->db->join('about_com', 'post_job.created_by = about_com.created_by');
	$this->db->join('state as coms', 'post_job.state = coms.state_id');
    $this->db->join('state as jobs', 'about_com.state = jobs.state_id');
    $this->db->join('district as jobd', 'post_job.District = jobd.districtid');
	$this->db->join('district as comd', 'about_com.District = comd.districtid');
    $this->db->join('career_preferences', 
        "post_job.quali = career_preferences.qualification
        AND post_job.shift = career_preferences.p_shift
        AND post_job.gender = career_preferences.gender
        AND post_job.emp_type = career_preferences.eTYpe
        AND post_job.jobtype = career_preferences.p_e_type
        AND post_job.state = career_preferences.p_state
        AND post_job.skills REGEXP CONCAT('(^|,)', REPLACE(career_preferences.skills, ',', '|'), '($|,)')", 'inner');
    $this->db->where('post_job.status', 0);
	$this->db->where('about_com.status', 1);
    $this->db->where('career_preferences.created_by', $emp_id);

    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('post_job.jTitle', $search);
        $this->db->or_like('post_job.skills', $search);
        $this->db->or_like('about_com.name', $search);
        $this->db->group_end();
    }
	$filterData = $this->buildFilters($filters);
	if (!empty($filterData['conditions'])) {
		foreach ($filterData['conditions'] as $condition) {
			$param = array_shift($filterData['params']);

			if (is_array($param)) {
				// Use whereIn for multi-select filters
				$this->db->where_in($condition, $param);
			} else {
				// Single value filter
				$this->db->where($condition, $param);
			}
		}
	}

    $this->db->order_by('post_job.created_at', 'DESC');
    $this->db->limit($limit, $offset);
    
    $query = $this->db->get();
    $results = $query->result();
	foreach($results as $row){
		if(!empty($emp_id)){
			$career=$this->db->where(['created_by'=> $emp_id])->get('career_preferences')->num_rows();
			$save=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('emp_save_job')->num_rows();
			$applyC=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp');
			if($applyC->num_rows()==0){
				$apply=0;
			}else{
				$apply = ($applyC->row()->status == 3) ? 2 : 1;
			}
		}else{
			$save='0';
			$apply='0';
			$career='0';
		}
		

		$row->job_created_at=$this->timeAgo($row->job_created_at);
		$row->company_logo = base_url('jd/jdrec/documents/'.$row->company_logo);
		$row->is_saved = "$save";
		$row->is_applied = "$apply";
		$row->is_career = "$career";
		$row->employment_type=$this->orignalName($row->employment_type);
		$row->job_type=$this->orignalName($row->job_type);
		$row->job_shift=$this->orignalName($row->job_shift);
		$row->job_experience=$this->orignalName($row->job_experience);
		$row->job_qualification=$this->orignalName($row->job_qualification);
		$row->salary_type=$this->orignalName($row->salary_type);
	}
	$user=$this->db->where('created_by', $emp_id)->get('career_preferences')->row();
    $response = [
		'title'=>'Recommended '.($user->p_job_roles ?? '').' Jobs',
		'filters'=>$this->getFilter(),
        'current_page' => ($offset / $limit) + 1,
        'total_pages' => ceil($total_count / $limit),
        'total_records' => $total_count,
        'records_per_page' => $limit,
        'data' => $results,
    ];

    return $response;
}

	private function getFilter(){
		$data=[
			['title'=>'Employment Type','value'=>'employement_type','data'=>$this->getJobTitles('employement_type')],
			['title'=>'Job Type','value'=>'job_type','data'=>$this->getJobTitles('job_type')],
			['title'=>'Experience','value'=>'experience','data'=>$this->getJobTitles('experience')],
			['title'=>'Shift','value'=>'shift','data'=>$this->getJobTitles('shift')]
		]; 
		return $data;
	} 
	private function getJobTitles($type){
		return  $this->db->select('value,title')->where('category', $type)->get('post_job_titles')->result();
	}
	public function orignalName($value){
		$res=$this->db->where('value', $value)->get('post_job_titles');
		if($res->num_rows()>0){
			return $res->row()->title;
		}else{
			return null;
		}
	}
	public function getWorkExperience($id){
		$work=$this->db->where('emp_id', $id)->order_by('id','desc')->get('work_experience')->result();
		$data=[];
		foreach($work as $row){
			$title=$this->db->where('value', $row->location_type)->get('post_job_titles')->row();
			$title1=$this->db->where('value', $row->employment_type)->get('post_job_titles')->row();
			if($row->is_current==1){ $endDate='Present'; }else{ $endDate=date('M Y',strtotime($row->end_date)); }
			$row->location_type=$title->title ?? '';
			$row->employment_type=$title1->title ?? '';
			$row->start_date=date('M Y',strtotime($row->start_date));
			$row->end_date=$endDate;
			array_push($data,$row);
		}
		return $data;
	}
	
	public function getEducations($id){
		$work=$this->db->where('emp_id', $id)->order_by('id','desc')->get('education')->result();
		$data=[];
		foreach($work as $row){
			$title=$this->db->where('value', $row->degree)->get('post_job_titles')->row();
			if($row->is_current==1){ $endDate='Present'; }else{ $endDate=date('M Y',strtotime($row->end_date)); }
			$row->start_date=date('M Y',strtotime($row->start_date));
			$row->end_date=$endDate;
			$row->degree=$title->title ?? '';
			array_push($data,$row);
		}
		return $data;
	}
	
	public function getPortfolio($id,$limit=null){
		if($limit){
			$work=$this->db->where('emp_id', $id)->order_by('id','desc')->limit($limit)->get('work_portfolio')->result();
		}else{
			$work=$this->db->where('emp_id', $id)->order_by('id','desc')->get('work_portfolio')->result();
		}
		$data=[];
		foreach($work as $row){
			if($row->is_current==1){ $endDate='Present'; }else{ $endDate=date('M Y',strtotime($row->end_date)); }
			$row->start_date=date('M Y',strtotime($row->start_date));
			$row->end_date=$endDate;
			$row->image=base_url('uploads/work/'.$row->image);
			array_push($data,$row);
		}
		return $data;
	}
	
	
	public function globalSearch($search = null, $emp_id = null, $limit, $offset,$filters=null) {
	
		$this->db->select('COUNT(*) AS total_count');
		$this->db->from('post_job');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id');
		$this->db->join('state as coms', 'about_com.state = coms.state_id');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid');
		$this->db->join('district as comd', 'about_com.District = comd.districtid');
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);

		if (!empty($search)) {		
			$this->db->group_start()
					->like('post_job.jTitle', $search)
					->or_like('post_job.skills', $search)
					->or_like('about_com.name', $search)
					->or_like('about_com.c_desc', $search)
					->or_like('jobs.state_title', $search)
					->or_like('jobd.district_title', $search)
					->or_like('post_job.jobDescription', $search)
					->or_like('post_job.city', $search)
					->group_end();
		}
		$filterData = $this->buildFilters($filters);
		if (!empty($filterData['conditions'])) {
			foreach ($filterData['conditions'] as $condition) {
				$this->db->where($condition, array_shift($filterData['params']));
			}
		}

		$total_count = $this->db->get()->row()->total_count;

		$this->db->select('
			post_job.id AS job_id,
			about_com.created_by AS rec_id,
			about_com.name AS company_name,
			about_com.n_emp AS company_size,
			about_com.c_logo AS company_logo,
			coms.state_title AS company_state,
			comd.district_title AS company_district,
			about_com.city AS company_city,
			about_com.zip AS company_pincode,
			about_com.adress AS company_address,
			about_com.c_desc AS company_description,
			about_com.link AS company_url,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.jobDescription AS job_description,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant
		');

		$this->db->from('post_job');
		$this->db->join('about_com', 'post_job.created_by = about_com.created_by');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id');
		$this->db->join('state as coms', 'about_com.state = coms.state_id');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid');
		$this->db->join('district as comd', 'about_com.District = comd.districtid');
		$this->db->where('post_job.status', 0);
		$this->db->where('about_com.status', 1);

		if (!empty($search)) {
			$this->db->group_start()
					->like('post_job.jTitle', $search)
					->or_like('post_job.skills', $search)
					->or_like('about_com.name', $search)
					->or_like('about_com.c_desc', $search)
					->or_like('jobs.state_title', $search)
					->or_like('jobd.district_title', $search)
					->or_like('post_job.jobDescription', $search)
					->or_like('post_job.city', $search)
					->group_end();
		}
		$filterData = $this->buildFilters($filters);
		if (!empty($filterData['conditions'])) {
			foreach ($filterData['conditions'] as $condition) {
				$this->db->where($condition, array_shift($filterData['params']));
			}
		}

		$this->db->order_by('post_job.created_at', 'DESC');
		$this->db->limit($limit, $offset);
		$query = $this->db->get()->result();

		foreach ($query as $row) {
			if (!empty($emp_id)) {
				$save = $this->db->where(['emp_id' => $emp_id, 'job_id' => $row->job_id])->get('emp_save_job')->num_rows();
				$applyC=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp');
				if($applyC->num_rows()==0){
					$apply=0;
				}else{
					$apply = ($applyC->row()->status == 3) ? 2 : 1;
				}
			} else {
				$save = '0';
				$apply = '0';
			}
			$row->job_created_at = $this->timeAgo($row->job_created_at);
			$row->company_logo = base_url('jd/jdrec/documents/' . $row->company_logo);
			$row->is_saved = "$save";
			$row->is_applied = "$apply";
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->job_shift=$this->orignalName($row->job_shift);
			$row->job_experience=$this->orignalName($row->job_experience);
			$row->job_qualification=$this->orignalName($row->job_qualification);
			$row->salary_type=$this->orignalName($row->salary_type);
		}

		$response = [
			'filters' => $this->getFilter(),
			'current_page' => ($offset / $limit) + 1,
			'total_pages' => ceil($total_count / $limit),
			'total_records' => $total_count,
			'records_per_page' => $limit,
			'data' => $query,
		];

		return $response;
	}
	
	
	private function buildFilters($input)
	{
		$conditions = [];
		$params = [];

		if (!empty($input['job_type'])) {
			$conditions[] = "post_job.jobtype";
			$params[] = $input['job_type'];
		}

		if (!empty($input['shift'])) {
			$conditions[] = "post_job.shift";
			$params[] = $input['shift'];
		}

		if (!empty($input['employement_type'])) {
			$conditions[] = "post_job.emp_type";
			$params[] = $input['employement_type'];
		}
		if (!empty($input['experience'])) {
			$conditions[] = "post_job.experience";
			$params[] = $input['experience'];
		}

		
		return ['conditions' => $conditions, 'params' => $params];
	}

	
	 
	public function get_recruiter_job($status,$rec_id,$limit=null) {
		
		$this->db->select('
			post_job.id AS job_id,
			post_job.jTitle AS job_title,
			jobs.state_title AS job_state,
			jobd.district_title AS job_district,
			post_job.city AS job_city,
			post_job.zip AS job_pincode,
			post_job.adress AS job_address,
			post_job.emp_type AS employment_type,
			post_job.jobtype AS job_type,
			post_job.shift AS job_shift,
			post_job.experience AS job_experience,
			post_job.quali AS job_qualification,
			post_job.sMin AS salary_min,
			post_job.sMax AS salary_max,
			post_job.sType AS salary_type,
			post_job.skills AS job_skills,
			post_job.job_image AS job_image,
			post_job.nOpen AS no_of_opening,
			post_job.created_at AS job_created_at,
			post_job.tag,post_job.gender,
			(SELECT COUNT(*) FROM emp_view_job WHERE emp_view_job.job_id = post_job.id) AS views,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id) AS total_applicant,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id and applied_job_emp.status=1) AS total_shortlist,
			(SELECT COUNT(*) FROM applied_job_emp WHERE applied_job_emp.job_id = post_job.id and applied_job_emp.status=2) AS total_rejected
			
		');
		$this->db->from('post_job');
		$this->db->join('state as jobs', 'post_job.state = jobs.state_id');
		$this->db->join('district as jobd', 'post_job.District = jobd.districtid');
		$this->db->where('post_job.status',$status);
		$this->db->where('post_job.created_by',$rec_id);
		if(!empty($limit)){
			$this->db->order_by('post_job.created_at', 'DESC')->limit($limit);
		}else{
			$this->db->order_by('post_job.created_at', 'DESC');
		}
		$query = $this->db->get()->result();
		foreach($query as $row){
			$row->job_created_at=$this->timeAgo($row->job_created_at);
			$row->views=$row->views;
			$row->clicks='0';
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->job_shift=$this->orignalName($row->job_shift);
			$row->job_experience=$this->orignalName($row->job_experience);
			$row->job_qualification=$this->orignalName($row->job_qualification);
			$row->salary_type=$this->orignalName($row->salary_type);
		}
		return $query;
	}
	
	public function get_applicant($rec_id,$status,$job_id=null,$limit=null) {
		$this->db->select('
			applied_job_emp.id AS id,
			post_job.id AS job_id,
			post_job.jTitle AS job_title,
			employee.profile_pic as emp_profile,
			employee.c_name AS emp_name,
			career_preferences.t_exp_type as experience,
			career_preferences.t_exp_yr as years,
			career_preferences.t_exp_month as months,
			career_preferences.qualification,
			career_preferences.skills, 
			career_preferences.p_e_type AS job_type,
			career_preferences.eTYpe AS employment_type,
			career_preferences.resume,
			career_preferences.tag,
			employee.id as emp_id,
		');

		$this->db->from('applied_job_emp');
		$this->db->join('post_job', 'applied_job_emp.job_id = post_job.id', 'inner');
		$this->db->join('career_preferences', 'applied_job_emp.emp_id = career_preferences.created_by', 'left');
		$this->db->join('employee', 'applied_job_emp.emp_id = employee.id', 'left');
		if(!empty($job_id)){
			$this->db->where('applied_job_emp.job_id', $job_id);
		}
		$this->db->where('applied_job_emp.rec_id', $rec_id);
		$this->db->where('applied_job_emp.status', $status);
		$this->db->order_by('applied_job_emp.id', 'DESC');
		if(!empty($limit)){
			$this->db->limit($limit);
		}
		
		$query = $this->db->get()->result();

		foreach ($query as $row) {
			$row->resume = base_url('canidate_documents/resume/' . $row->resume);
			$row->emp_profile = base_url('profile_pic/' . $row->emp_profile);
			if($row->experience=='fresher'){
				 $exp='Fresher';
			}else{
				$exp=$row->years.'y '.$row->months.'m Exp';
			}
			$row->experience=$exp;
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->qualification=$this->orignalName($row->qualification);
		}

		return $query;
	}
	
	public function get_viewed_applicant($job_id,$limit=null) {
		$this->db->select('
			post_job.jTitle AS job_title,
			employee.profile_pic as emp_profile,
			employee.c_name AS emp_name,
			career_preferences.t_exp_type as experience,
			career_preferences.t_exp_yr as years,
			career_preferences.t_exp_month as months,
			career_preferences.qualification,
			career_preferences.skills, 
			career_preferences.p_e_type AS job_type,
			career_preferences.eTYpe AS employment_type,
			career_preferences.resume,
			career_preferences.tag,
			employee.id as emp_id,
		');

		$this->db->from('emp_view_job');
		$this->db->join('post_job', 'emp_view_job.job_id = post_job.id', 'inner');
		$this->db->join('career_preferences', 'emp_view_job.emp_id = career_preferences.created_by', 'left');
		$this->db->join('employee', 'emp_view_job.emp_id = employee.id', 'left');
		$this->db->where('emp_view_job.job_id', $job_id);
		$this->db->order_by('emp_view_job.id', 'DESC');
		if(!empty($limit)){
			$this->db->limit($limit);
		}
		
		$query = $this->db->get()->result();

		foreach ($query as $row) {
			$row->resume = base_url('canidate_documents/resume/' . $row->resume);
			$row->emp_profile = base_url('profile_pic/' . $row->emp_profile);
			if($row->experience=='fresher'){
				 $exp='Fresher';
			}else{
				$exp=$row->years.'y '.$row->months.'m Exp';
			}
			$row->experience=$exp;
			$row->employment_type=$this->orignalName($row->employment_type);
			$row->job_type=$this->orignalName($row->job_type);
			$row->qualification=$this->orignalName($row->qualification);
		}

		return $query;
	}
	
	public function globalSearchRecruiter($rec_id,$search = null) {
		$this->db->select('
			applied_job_emp.id AS id,
			post_job.id AS job_id,
			post_job.jTitle AS job_title,
			employee.profile_pic as emp_profile,
			employee.c_name AS emp_name,
			career_preferences.t_exp_type as experience,
			career_preferences.t_exp_yr as years,
			career_preferences.t_exp_month as months,
			career_preferences.qualification,
			career_preferences.skills, 
			career_preferences.p_e_type AS job_type,
			career_preferences.eTYpe AS employment_type,
			career_preferences.resume,
			career_preferences.tag,
		');

		$this->db->from('applied_job_emp');
		$this->db->join('post_job', 'applied_job_emp.job_id = post_job.id', 'inner');
		$this->db->join('career_preferences', 'applied_job_emp.emp_id = career_preferences.created_by', 'left');
		$this->db->join('employee', 'applied_job_emp.emp_id = employee.id', 'left');

		$this->db->where('post_job.created_by',$rec_id);
		
		if (!empty($search)) {
			$this->db->group_start();
			$this->db->like('post_job.jTitle', $search);
			$this->db->or_like('post_job.city', $search);
			$this->db->or_like('career_preferences.fullname', $search);
			$this->db->or_like('career_preferences.skills', $search);
			$this->db->or_like('career_preferences.qualification', $search);
			$this->db->or_like('career_preferences.t_exp_type', $search);
			$this->db->group_end();
		}

		$this->db->order_by('applied_job_emp.id', 'DESC');

		$query = $this->db->get()->result();

		foreach ($query as $row) {
			$row->resume = base_url('canidate_documents/resume/' . $row->resume);
			$row->emp_profile = base_url('profile_pic/' . $row->emp_profile);
			$row->experience = ($row->experience == 'fresher') ? 'Fresher' : $row->years . 'y ' . $row->months . 'm Exp';
			$row->employment_type = $this->orignalName($row->employment_type);
			$row->job_type = $this->orignalName($row->job_type);
			$row->qualification = $this->orignalName($row->qualification);
		}
		return $query;
	}

	public function getChat($emp_id, $rec_id,$type) {
		$this->db->select("id,ee_id as emp_id,rec_id,msg,created_by,sender_type,read_by_rec,read_by_emp,DATE_FORMAT(created_at, '%b %d, %h:%i %p') as created_at,req_contact,duration");
		$this->db->from('chatbox_msg');
		$this->db->where("ee_id = $emp_id AND rec_id = $rec_id");
		$this->db->order_by("id", "DESC"); 
		// $this->db->limit($limit, $offset);

		$query = $this->db->get();
		$result = $query->result();
		if($type=='employee'){
			$emp = $this->db->where('id',$emp_id)->get('employee')->row();
			$career = $this->db->where('created_by',$emp_id)->get('career_preferences')->row();
			$resume='<span><a target="_blank" href="'.base_url('canidate_documents/resume/'.$career->resume).'">My Resume <i class="fa fa-file-pdf-o text-danger" ></i></a></span>';
			$escaped_resume = htmlspecialchars($resume, ENT_QUOTES); 
			$check = $this->db->get_where('chatbox_msg', ['ee_id' => $emp_id,'rec_id'=>$rec_id])->num_rows();
			$action = ($check > 1) ? true : false;
			$checkmsg = $this->db->get_where('chatbox_msg', ['ee_id' => $emp_id,'rec_id'=>$rec_id,'sender_type'=>'employee'])->num_rows();
			$pre_msg = ($checkmsg == 0) ? true : false;
			if($pre_msg===true){
				$action=false;
			}
			$about=$this->db->get_where('about_com',['created_by'=>$rec_id])->row();
			$profile=[
				'id'=>$rec_id,
				'name'=>$about->name ?? '',
				'image'=>base_url('jd/jdrec/documents/' . (!empty($about->c_logo) ? $about->c_logo : 'user.png')),
				'recruiter_name'=>$about->r_name ?? '',
				'recruiter_designation'=>$about->r_desig ?? '',
				'action_buttons'=>$action,
				'pre_msg'=>$pre_msg,
				'emp_contact'=>$emp->c_contact,
				'emp_resume'=>$escaped_resume,
				'media'=>[]
			];
			$this->db->update('chatbox_msg', ['read_by_emp' => '1'], ['ee_id' => $emp_id,'rec_id'=>$rec_id,'read_by_emp'=>'0','sender_type'=>'recruiter']);
		}else{
			$check = $this->db->get_where('chatbox_msg', ['ee_id' => $emp_id,'rec_id'=>$rec_id])->num_rows();
			$rec = $this->db->where('id',$rec_id)->get('employer')->row();
			$action = ($check > 1) ? true : false;
			$checkmsg = $this->db->get_where('chatbox_msg', ['ee_id' => $emp_id,'rec_id'=>$rec_id,'sender_type'=>'recruiter'])->num_rows();
			$pre_msg = ($checkmsg == 0) ? true : false;
			if($pre_msg===true){
				$action=false;
			}
			$user=$this->db->get_where('employee',['id'=>$emp_id])->row();
			$profile=[
				'id'=>$emp_id,
				'name'=>$user->c_name,
				'image'=>base_url('profile_pic/' . (!empty($user->profile_pic) ? $user->profile_pic : 'user.png')),
				'headline'=>$user->headline,
				'action_buttons'=>$action,
				'pre_msg'=>$pre_msg,
				'rec_contact'=>$rec->c_contact,
				'media'=>[]
			];
			$this->db->update('chatbox_msg', ['read_by_rec' => '1'], ['ee_id' => $emp_id,'rec_id'=>$rec_id,'read_by_rec'=>'0','sender_type'=>'employee']);
		}
		$data=[
			'profile'=>$profile,
			'list'=>array_reverse($result)
		];
		return $data;
	}

}
