<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {
	public function __construct() {
        parent::__construct();
		$this->load->model('lib_model'); 
        $this->load->helper('common');
		$this->load->model('common_model');  
		$site = $this->db->get_where('settings', ['id' => '1'])->row();
		 if (
            $site && $site->website_status == '0' &&
            $this->router->method != 'maintenance' // 👈 exclude maintenance method
        ) {
            redirect(base_url('maintenance'));
            exit;
        }
    }
	
	   private function check_user_completion($type)
		{
			$this->user_id = $this->session->userdata('employee')['id'];
			$current_uri = uri_string(); // gets current URL path (e.g., 'career-preference')

			if ($type === 'career') {
				if ($current_uri === 'career-preference') {
					return; // allow user to stay on career-preference page
				}

				$careerStatus = $this->db
					->where('created_by', $this->user_id)
					->count_all_results('career_preferences') > 0;

				if (!$careerStatus) {
					$this->session->set_flashdata('toast_msg', 'Please complete your career preference first.');
					redirect(base_url('career-preference')); return;
				}
			}

			if ($type === 'profile') {
				if ($current_uri === 'profile') {
					return; // allow user to stay on profile page
				}

				$user = $this->db->where('status', 0)->where('id', $this->user_id)->get('employee')->row();
				$profileStatus = !empty($user->c_name) && !empty($user->c_email) && !empty($user->profile_pic);

				if (!$profileStatus) {
					$this->session->set_flashdata('toast_msg', 'Please complete your profile before proceeding.');
					redirect(base_url('profile')); return;
				}
			}
		}

	
	public function index(){
		$data['title']='Home';
		if(!empty($this->session->userdata('employee'))){
			$this->check_user_completion('career');
			$this->check_user_completion('profile');
		}
		$data['feature'] = $this->common_model->get_latest_job(null);
		$this->load->view('index',$data);
	}
	
	public function about(){
		$data['title']='About Us';
		$this->load->view('about',$data);
	}
	public function maintenance(){
		$data['title'] = 'Under Maintenance';
		$this->load->view('maintenance', $data);
	}
	public function test(){
		$data['title']='About Us';
		$title='🎉 Welcome to JobKaro';
				$body='Thanks for joining! Complete your profile to get personalized job recommendations.';
				$res=$this->common_model->saveNotification(6,$title,$body,'employee');
				print_r($res);
	}
	
	public function contact(){
		$data['title']='Contact Us';
		$this->load->view('contact',$data);
	}  
	
	public function jobs(){
		if(!empty($this->session->userdata('employee'))){
			$this->check_user_completion('career');
			$this->check_user_completion('profile');
		}
		$data['title']='Discover Jobs';
		// $data['jobs'] = $this->common_model->get_latest_job(null);
		$this->load->view('jobs_new',$data);
		// $this->load->view('jobs',$data);
	}
	public function explore_jobs(){
		if(!empty($this->session->userdata('employee'))){
			$this->check_user_completion('career');
			$this->check_user_completion('profile');
		}
		$data['title']='Explore Jobs';
		// $data['jobs'] = $this->common_model->get_latest_job(null);
		$this->load->view('explore_jobs',$data);
		// $this->load->view('jobs',$data);
	}
	
	function common_api()
	{
		$url=$_POST['url'];
		$payload=$_POST;
		$curl = curl_init();

		$headers = ['Content-Type: application/json'];


		curl_setopt_array($curl, [
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => json_encode($payload),
			CURLOPT_HTTPHEADER => $headers,
		]);
		$auth=$this->db->where('id',1)->get('hiring_api_auth')->row();
		$username=$auth->username;
		$password=$auth->password;
		// Set Basic Auth if username and password are provided
		curl_setopt($curl, CURLOPT_USERPWD, "$username:$password");
		

		$response = curl_exec($curl);

		if (curl_errno($curl)) {
			$error_msg = curl_error($curl);
		}

		curl_close($curl);

		echo $response;
	}
	
	public function jobDetails(){
		if(isset($_GET['job_id'])){
			$id=$_GET['job_id'];
			$user_id=$this->session->userdata('employee')['id'];
			$row=$this->common_model->getSingleJob($id,$user_id);
			if($row!==null){
				$data['title']=$row->job_title;
				$data['job'] = $row;
				$data['similar'] = $this->common_model->get_similar_job($id);
				$data['jobs'] = $this->common_model->get_latest_job(null);
				
				$this->load->view('jobDetailsNew',$data);
			}else{
				redirect(base_url('jobs'));
			}
		}else{
			redirect(base_url('jobs'));
		}
		
	}
	
	public function termsConditions(){
		$data['title']='Terms Conditions';
		$this->load->view('termsConditions');
// 		$this->load->view('comingsoon',$data);
	}
	
// 	public function privacyPolicy(){
// 		$data['title']='Privacy Policy';
// 		$this->load->view('comingsoon',$data);
// 	}
	
	public function privacyPolicy(){
		$data['title']='Privacy Policy';
		$this->load->view('privacyPolicy');
	}
	
	public function submitContact(){
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'name', 'label' => 'Name', 'rules' => 'required|trim|min_length[3]'],
			['field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'],
			['field' => 'mobile', 'label' => 'Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'msg', 'label' => 'Message', 'rules' => 'required|trim'],
		];
		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		$submitData = [
			'name' => $input['name'],
			'mobile' => $input['mobile'],
			'email' => $input['email'],
			'msg' => $input['msg'],
			'created_at' => date('Y-m-d H:i:s')
		];
		$res=$this->lib_model->Insert('contact', $submitData);
		if($res){
			echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>"Thank you! We'll reach out soon"]);
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Something went wrong, please try later.']);die();
		}
	}
	
	public function getJobDetails(){
		$id=$this->input->post('id');
		
		$emp_id=$this->session->userdata('employee')['id'];
		

		if(!empty($emp_id)){
			$row=$this->common_model->getSingleJob($id,$emp_id);
			$career=$this->db->where(['created_by'=> $emp_id])->get('career_preferences')->num_rows();
			$save=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('emp_save_job')->num_rows();
			$apply=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp')->num_rows();
			$applyRow=$this->db->where(['emp_id'=> $emp_id,'job_id'=>$row->job_id])->get('applied_job_emp')->row();
			if($save>0){
				$saveClass='custom-btn2-outline';
				$saveText='Saved';
			}else{
				$saveClass='custom-btn2-outline';
				$saveText='Save';
			}
			
			if($apply>0){
				$applyClass='custom-btn2';
				$applyText='Applied';
				$type='disabled';
			}else{
				$applyClass='custom-btn2';
				$applyText='Apply Now';
				$type='';
			}
			if($career==0){
				$buttons='
				<a href="'.base_url('career-preference').'" class="custom-btn2" >
				<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
					<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				  </svg>Apply Now</a>
				  <a class="custom-btn2-outline" href="'.base_url('career-preference').'">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
						<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
					  </svg>
					Save</a>
				';
			}else{
				$buttons='
				<button class="'.$applyClass.' applyBtn'.$row->job_id.'" '.$type.' onclick="applyJob('.$row->job_id.')" >
					<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
						<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					  </svg><span>'.$applyText.'</span> <i class="fa fa-spinner fa-spin applySpin'.$row->job_id.'" style="display:none;"></i></button>
			  <button class="'.$saveClass.' saveBtn'.$row->job_id.'" onclick="saveJob('.$row->job_id.')">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
					<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
				  </svg>
				<span>'.$saveText.'</span> <i class="fa fa-spinner fa-spin saveSpin'.$row->job_id.'" style="display:none;"></i></button>
				';
			}
		}else{
			$row=$this->common_model->getSingleJob($id);
			$buttons='
			<button class="custom-btn2" data-bs-toggle="modal" data-bs-target="#login">
			<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
				<path d="M11.885 9.25L18.135 3M18.135 3H13.9683M18.135 3V7.16667M18.135 12.1667V16.3333C18.135 16.7754 17.9594 17.1993 17.6469 17.5118C17.3343 17.8244 16.9104 18 16.4683 18H4.80168C4.35965 18 3.93573 17.8244 3.62317 17.5118C3.3106 17.1993 3.13501 16.7754 3.13501 16.3333V4.66667C3.13501 4.22464 3.3106 3.80072 3.62317 3.48816C3.93573 3.17559 4.35965 3 4.80168 3H8.96834" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
			  </svg>Apply Now</button>
			  <button class="custom-btn2-outline" data-bs-toggle="modal" data-bs-target="#login">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
					<path d="M8.63501 3.5H16.635C17.4307 3.5 18.1937 3.81607 18.7563 4.37868C19.3189 4.94129 19.635 5.70435 19.635 6.5V21.5L12.635 18.5L5.63501 21.5V6.5C5.63501 5.70435 5.95108 4.94129 6.51369 4.37868C7.0763 3.81607 7.83936 3.5 8.63501 3.5ZM8.63501 4.64574C8.10458 4.64574 7.77392 4.71071 7.39885 5.08579C7.02378 5.46086 6.81306 5.96957 6.81306 6.5V19.513L12.635 17.1616L18.4766 19.513V6.5C18.4766 5.96957 18.3387 5.46086 17.9636 5.08579C17.5885 4.71071 17.1654 4.64574 16.635 4.64574H8.63501Z" fill="#007BFF"/>
				  </svg>
				Save</button>
			';
		}
		
		if(isset($_POST['type'])){
			$type=$this->input->post('type');
			$buttons='
			 <a href="'.base_url('chat?id='.$row->rec_id).'" class="custom-btn2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                        <path d="M5.63477 18.5V22.266L7.14977 21.357L11.9118 18.5H16.6348C17.7378 18.5 18.6348 17.603 18.6348 16.5V8.5C18.6348 7.397 17.7378 6.5 16.6348 6.5H4.63477C3.53177 6.5 2.63477 7.397 2.63477 8.5V16.5C2.63477 17.603 3.53177 18.5 4.63477 18.5H5.63477ZM4.63477 8.5H16.6348V16.5H11.3578L7.63477 18.734V16.5H4.63477V8.5Z" fill="white"/>
                                        <path d="M20.6348 2.5H8.63477C7.53177 2.5 6.63477 3.397 6.63477 4.5H18.6348C19.7378 4.5 20.6348 5.397 20.6348 6.5V14.5C21.7378 14.5 22.6348 13.603 22.6348 12.5V4.5C22.6348 3.397 21.7378 2.5 20.6348 2.5Z" fill="white"/>
                                      </svg>
                                       Message HR</a>
                                      <button class="custom-btn2-outlineRed" onclick="ApplicantStatus('.$applyRow->id.',3,\'withdraw\')">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                            <g clip-path="url(#clip0_1647_7247)">
                                              <path d="M15.1348 12.9156V15.5C15.1348 15.6326 15.0821 15.7598 14.9883 15.8536C14.8946 15.9473 14.7674 16 14.6348 16C14.5022 16 14.375 15.9473 14.2812 15.8536C14.1874 15.7598 14.1348 15.6326 14.1348 15.5V12.9156C14.1324 12.2738 13.9981 11.6394 13.74 11.0518C13.482 10.4642 13.1057 9.93597 12.6348 9.5V13.1469C12.6347 13.2545 12.5999 13.3592 12.5355 13.4454C12.4712 13.5317 12.3807 13.5949 12.2776 13.6256C12.1745 13.6564 12.0642 13.653 11.9632 13.6161C11.8621 13.5792 11.7756 13.5106 11.7166 13.4206L11.0491 12.4012C11.0441 12.3938 11.0391 12.3856 11.0348 12.3775C10.9367 12.2044 10.7739 12.0773 10.5822 12.0242C10.3904 11.9711 10.1854 11.9963 10.0123 12.0944C9.83913 12.1924 9.71203 12.3552 9.65894 12.547C9.60584 12.7387 9.63109 12.9437 9.72914 13.1169L11.1123 15.2288C11.1849 15.3397 11.2104 15.475 11.1833 15.6048C11.1561 15.7346 11.0786 15.8483 10.9676 15.9209C10.8566 15.9935 10.7213 16.0191 10.5915 15.992C10.4617 15.9648 10.348 15.8872 10.2754 15.7762L8.88414 13.6512L8.86914 13.6275C8.65378 13.2584 8.58089 12.8233 8.66423 12.4042C8.74756 11.9851 8.98136 11.611 9.32153 11.3524C9.6617 11.0938 10.0847 10.9686 10.5109 11.0004C10.937 11.0322 11.3367 11.2188 11.6348 11.525V4.5H10.6348C10.5022 4.5 10.375 4.44732 10.2812 4.35355C10.1874 4.25979 10.1348 4.13261 10.1348 4C10.1348 3.86739 10.1874 3.74021 10.2812 3.64645C10.375 3.55268 10.5022 3.5 10.6348 3.5H11.6348C11.9 3.5 12.1543 3.60536 12.3419 3.79289C12.5294 3.98043 12.6348 4.23478 12.6348 4.5V8.22625C13.4022 8.74485 14.0312 9.44324 14.4669 10.2606C14.9027 11.0779 15.1319 11.9894 15.1348 12.9156ZM6.13477 4C6.13477 3.86739 6.08209 3.74021 5.98832 3.64645C5.89455 3.55268 5.76737 3.5 5.63477 3.5H4.63477C4.36955 3.5 4.1152 3.60536 3.92766 3.79289C3.74012 3.98043 3.63477 4.23478 3.63477 4.5V13C3.63477 13.1326 3.68744 13.2598 3.78121 13.3536C3.87498 13.4473 4.00216 13.5 4.13477 13.5C4.26737 13.5 4.39455 13.4473 4.48832 13.3536C4.58209 13.2598 4.63477 13.1326 4.63477 13V4.5H5.63477C5.76737 4.5 5.89455 4.44732 5.98832 4.35355C6.08209 4.25979 6.13477 4.13261 6.13477 4ZM10.4885 6.64625C10.4421 6.59976 10.3869 6.56288 10.3262 6.53772C10.2655 6.51256 10.2005 6.49961 10.1348 6.49961C10.0691 6.49961 10.004 6.51256 9.9433 6.53772C9.8826 6.56288 9.82745 6.59976 9.78102 6.64625L8.63477 7.79313V1.5C8.63477 1.36739 8.58209 1.24021 8.48832 1.14645C8.39455 1.05268 8.26737 1 8.13477 1C8.00216 1 7.87498 1.05268 7.78121 1.14645C7.68744 1.24021 7.63477 1.36739 7.63477 1.5V7.79313L6.48852 6.64625C6.3947 6.55243 6.26745 6.49972 6.13477 6.49972C6.00208 6.49972 5.87484 6.55243 5.78102 6.64625C5.6872 6.74007 5.63449 6.86732 5.63449 7C5.63449 7.13268 5.6872 7.25993 5.78102 7.35375L7.78102 9.35375C7.82745 9.40024 7.8826 9.43712 7.9433 9.46228C8.00399 9.48744 8.06906 9.50039 8.13477 9.50039C8.20047 9.50039 8.26554 9.48744 8.32624 9.46228C8.38693 9.43712 8.44208 9.40024 8.48852 9.35375L10.4885 7.35375C10.535 7.30731 10.5719 7.25217 10.597 7.19147C10.6222 7.13077 10.6352 7.06571 10.6352 7C10.6352 6.93429 10.6222 6.86923 10.597 6.80853C10.5719 6.74783 10.535 6.69269 10.4885 6.64625Z" fill="#FF7979"/>
                                            </g>
                                            <defs>
                                              <clipPath id="clip0_1647_7247">
                                                <rect width="16" height="16" fill="white" transform="translate(0.634766 0.5)"/>
                                              </clipPath>
                                            </defs>
                                          </svg>
                                          Withdraw</button>
			';
		}
		
		
		if($row!=null){
			$html='
                    <div class="job-description job-card sticky-top2">
                        <div class="d-flex justify-content-between">
                            <div class="d-flex gap-2">
                                <img src="'.$row->company_logo.'" alt="" class="job-logo">
                                <div>
                                    <h5>'.$row->company_name.'</h5>
                                    <a href="" class="text-dark">
                                        <div class="d-flex gap-1">
                                            <span><a href="'.$row->company_url.'" target="_blank">'.$row->company_url.'</a></span>
                                            <span><img src="'.base_url('assets/newAssets/img/ei_arrow-up.svg').'" alt=""></span>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div>
                                <svg class="copy-btn" data-clipboard-text="'.base_url('job-details?job_id='.$row->job_id).'" xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 36 36" fill="none">
                                    <rect x="0.0461426" y="0.271484" width="35" height="35" rx="17.5" fill="#EDF6FF"/>
                                    <path d="M26.0461 9.27148L9.04614 14.7715L15.5461 17.7715L22.5461 12.7715L17.5461 19.7715L20.5461 26.2715L26.0461 9.27148Z" stroke="#202020" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                        <div class="d-flex gap-2 mt-3">
                            <h4 class="my-auto">'.$row->job_title.'</h4>
                            <span class="fs-4 my-auto">・</span>
                            <h4 class="my-auto text-muted fs-5">'.$row->employment_type.'</h4>
                        </div>
                        <div class="d-flex gap-2 mt-2">
                            <span><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                <path d="M3.9293 3.01413C4.74983 2.21001 5.85454 1.7622 7.00338 1.768C8.15222 1.7738 9.25236 2.23275 10.0647 3.04512C10.8771 3.85748 11.336 4.95762 11.3418 6.10646C11.3476 7.2553 10.8998 8.36001 10.0957 9.18054L7.79101 11.4852C7.58452 11.6917 7.30449 11.8076 7.0125 11.8076C6.72052 11.8076 6.44049 11.6917 6.23399 11.4852L3.9293 9.18054C3.11163 8.3628 2.65228 7.25374 2.65228 6.09733C2.65228 4.94093 3.11163 3.83187 3.9293 3.01413Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linejoin="round"/>
                                <path d="M7.0125 7.74881C7.92472 7.74881 8.66422 7.00931 8.66422 6.09709C8.66422 5.18487 7.92472 4.44537 7.0125 4.44537C6.10028 4.44537 5.36078 5.18487 5.36078 6.09709C5.36078 7.00931 6.10028 7.74881 7.0125 7.74881Z" stroke="#202020" stroke-opacity="0.6" stroke-width="0.963502" stroke-linecap="round" stroke-linejoin="round"/>
                              </svg></span>
                              <span class="pe-2">'.$row->job_city.'</span>
                              <span class="text-muted small">'.$row->job_created_at.'</span>
                              <span>・</span>
                              <span class="text-muted small">'.$row->total_applicant.' Applicants</span>
                        </div>
                        <div class="mt-3 d-flex gap-3">
                            <span class="d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                                    <g clip-path="url(#clip0_371_1966)">
                                      <path fill-rule="evenodd" clip-rule="evenodd" d="M14.7278 17.5C17.8403 17.5 20.3528 16.25 20.3528 14.375V2.5C20.3528 1.25 17.8528 0 14.7278 0C11.6028 0 9.10278 1.25 9.10278 2.5V6.875C10.5653 7.4875 11.8153 8.5125 12.7028 9.8125C13.3153 9.9325 13.9903 9.99875 14.7278 9.99875C16.3653 9.99875 17.7278 9.6725 18.7028 9.14125C18.8412 9.06517 18.9759 8.98258 19.1065 8.89375V10.6187C19.1065 10.9125 18.8728 11.3687 18.104 11.7887C17.359 12.195 16.2165 12.4937 14.729 12.4937C14.4315 12.4937 14.1482 12.4825 13.879 12.46C13.979 12.8725 14.0457 13.2933 14.079 13.7225C14.2899 13.7342 14.5065 13.74 14.729 13.74C16.3665 13.74 17.729 13.4137 18.704 12.8825C18.8425 12.8064 18.9772 12.7238 19.1078 12.635V14.36C19.1078 14.655 18.9215 15.0925 18.119 15.525C17.329 15.95 16.144 16.235 14.7315 16.235C14.444 16.235 14.1657 16.2233 13.8965 16.2C13.8004 16.6155 13.6713 17.0226 13.5103 17.4175C13.9036 17.4617 14.3103 17.4838 14.7303 17.4838L14.7278 17.5ZM18.1028 8.05C18.8715 7.63 19.1053 7.17375 19.1053 6.88V5.155C18.9761 5.24333 18.8415 5.32583 18.7015 5.4025C17.729 5.93375 16.364 6.26 14.7265 6.26C13.089 6.26 11.7265 5.93375 10.7515 5.4025C10.6131 5.32642 10.4784 5.24383 10.3478 5.155V6.88C10.3478 7.17375 10.5815 7.63 11.3503 8.04875C12.0953 8.455 13.2378 8.75375 14.7253 8.75375C16.2128 8.75375 17.3503 8.455 18.1003 8.04875L18.1028 8.05ZM10.3528 3.125C10.3528 2.765 10.509 2.41875 10.8003 2.2075C10.959 2.0925 11.1315 1.9775 11.2678 1.915C11.609 1.7575 13.3178 1.24875 14.7303 1.24875C16.1428 1.24875 17.3678 1.5325 18.1928 1.915C18.3478 1.98625 18.519 2.0975 18.6703 2.2075C18.959 2.41625 19.1078 2.76 19.1078 3.11625V3.12375C19.1078 3.4175 18.874 3.87375 18.1053 4.29375C17.3603 4.7 16.2178 4.99875 14.7303 4.99875C13.2428 4.99875 12.1053 4.69875 11.3553 4.29375C10.5865 3.875 10.3528 3.4175 10.3528 3.125Z" fill="#202020" fill-opacity="0.8"/>
                                      <path fill-rule="evenodd" clip-rule="evenodd" d="M11.6028 14.375C11.6028 17.4875 9.09028 20 5.97778 20C2.86528 20 0.352783 17.4875 0.352783 14.375C0.352783 11.2625 2.86528 8.75 5.97778 8.75C9.09028 8.75 11.6028 11.2625 11.6028 14.375ZM10.3528 14.375C10.3528 16.7875 8.39028 18.75 5.97778 18.75C3.56528 18.75 1.60278 16.7875 1.60278 14.375C1.60278 11.9625 3.56528 10 5.97778 10C8.39028 10 10.3528 11.9625 10.3528 14.375Z" fill="#202020" fill-opacity="0.8"/>
                                    </g>
                                    <defs>
                                      <clipPath id="clip0_371_1966">
                                        <rect width="20" height="20" fill="white" transform="translate(0.352783)"/>
                                      </clipPath>
                                    </defs>
                                </svg>
                                <p class="my-auto t2 fs-5">'.$row->salary_min.$row->salary_type.' - '.$row->salary_max.$row->salary_type.' <span></span></p>
                            </span>
                            <span class="d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                                    <path d="M17.0195 5.00002C17.5028 5.00002 17.8945 5.16669 18.2028 5.49169C18.5195 5.83335 18.6861 6.20835 18.6861 6.66669V15.8334C18.6861 16.2917 18.5195 16.6667 18.2028 17.0084C17.8945 17.3334 17.5028 17.5 17.0195 17.5H3.68614C3.2028 17.5 2.81114 17.3334 2.5028 17.0084C2.18614 16.6667 2.01947 16.2917 2.01947 15.8334V6.66669C2.01947 6.20835 2.18614 5.83335 2.5028 5.49169C2.81114 5.16669 3.2028 5.00002 3.68614 5.00002H7.01947V3.33335C7.01947 2.85002 7.18614 2.45835 7.5028 2.15002C7.81114 1.83335 8.2028 1.66669 8.68614 1.66669H12.0195C12.5028 1.66669 12.8945 1.83335 13.2028 2.15002C13.5195 2.45835 13.6861 2.85002 13.6861 3.33335V5.00002H17.0195ZM3.68614 6.66669V15.8334H17.0195V6.66669H3.68614ZM12.0195 5.00002V3.33335H8.68614V5.00002H12.0195Z" fill="#202020" fill-opacity="0.8"/>
                                  </svg>
                                <p class="my-auto t2 fs-5">'.$row->job_experience.'<span>Exp</span></p>
                            </span>
                            <span class="d-flex gap-2">
                                <svg class="my-auto" xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                                    <path d="M19.5195 4.16667V15.8333C19.5195 16.2917 19.3564 16.6842 19.0303 17.0108C18.7042 17.3375 18.3117 17.5006 17.8528 17.5H15.3528C15.1167 17.5 14.9189 17.42 14.7595 17.26C14.6 17.1 14.52 16.9022 14.5195 16.6667C14.5189 16.4311 14.5989 16.2333 14.7595 16.0733C14.92 15.9133 15.1178 15.8333 15.3528 15.8333H17.8528V4.16667H10.3528V4.58333C10.3528 4.81944 10.2728 5.0175 10.1128 5.1775C9.95282 5.3375 9.75505 5.41722 9.51949 5.41667C9.28394 5.41611 9.08616 5.33611 8.92616 5.17667C8.76616 5.01722 8.68616 4.81944 8.68616 4.58333V4.125C8.68616 3.68056 8.84588 3.29861 9.16532 2.97917C9.48477 2.65972 9.86671 2.5 10.3112 2.5H17.8528C18.3112 2.5 18.7037 2.66333 19.0303 2.99C19.357 3.31667 19.52 3.70889 19.5195 4.16667ZM1.18616 10.0208C1.18616 9.74306 1.24866 9.48611 1.37366 9.25C1.49866 9.01389 1.67227 8.81944 1.89449 8.66667L6.06116 5.6875C6.21394 5.57639 6.37032 5.49639 6.53032 5.4475C6.69032 5.39861 6.85338 5.37444 7.01949 5.375C7.1856 5.37556 7.34894 5.4 7.50949 5.44833C7.67005 5.49667 7.82616 5.57639 7.97782 5.6875L12.1445 8.66667C12.3667 8.81944 12.5403 9.01389 12.6653 9.25C12.7903 9.48611 12.8528 9.74306 12.8528 10.0208V15.8333C12.8528 16.2917 12.6898 16.6842 12.3637 17.0108C12.0375 17.3375 11.645 17.5006 11.1862 17.5H9.51949C9.06116 17.5 8.66894 17.3369 8.34282 17.0108C8.01671 16.6847 7.85338 16.2922 7.85282 15.8333V13.3333H6.18616V15.8333C6.18616 16.2917 6.0231 16.6842 5.69699 17.0108C5.37088 17.3375 4.97838 17.5006 4.51949 17.5H2.85282C2.39449 17.5 2.00227 17.3369 1.67616 17.0108C1.35005 16.6847 1.18671 16.2922 1.18616 15.8333V10.0208ZM2.85282 10V15.8333H4.51949V13.3333C4.51949 12.875 4.68282 12.4828 5.00949 12.1567C5.33616 11.8306 5.72838 11.6672 6.18616 11.6667H7.85282C8.31116 11.6667 8.70366 11.83 9.03032 12.1567C9.35699 12.4833 9.52005 12.8756 9.51949 13.3333V15.8333H11.1862V10L7.01949 7.04167L2.85282 10ZM14.9362 7.5H15.7695C15.8806 7.5 15.9778 7.45833 16.0612 7.375C16.1445 7.29167 16.1862 7.19444 16.1862 7.08333V6.25C16.1862 6.13889 16.1445 6.04167 16.0612 5.95833C15.9778 5.875 15.8806 5.83333 15.7695 5.83333H14.9362C14.825 5.83333 14.7278 5.875 14.6445 5.95833C14.5612 6.04167 14.5195 6.13889 14.5195 6.25V7.08333C14.5195 7.19444 14.5612 7.29167 14.6445 7.375C14.7278 7.45833 14.825 7.5 14.9362 7.5ZM14.9362 10.8333H15.7695C15.8806 10.8333 15.9778 10.7917 16.0612 10.7083C16.1445 10.625 16.1862 10.5278 16.1862 10.4167V9.58333C16.1862 9.47222 16.1445 9.375 16.0612 9.29167C15.9778 9.20833 15.8806 9.16667 15.7695 9.16667H14.9362C14.825 9.16667 14.7278 9.20833 14.6445 9.29167C14.5612 9.375 14.5195 9.47222 14.5195 9.58333V10.4167C14.5195 10.5278 14.5612 10.625 14.6445 10.7083C14.7278 10.7917 14.825 10.8333 14.9362 10.8333ZM14.9362 14.1667H15.7695C15.8806 14.1667 15.9778 14.125 16.0612 14.0417C16.1445 13.9583 16.1862 13.8611 16.1862 13.75V12.9167C16.1862 12.8056 16.1445 12.7083 16.0612 12.625C15.9778 12.5417 15.8806 12.5 15.7695 12.5H14.9362C14.825 12.5 14.7278 12.5417 14.6445 12.625C14.5612 12.7083 14.5195 12.8056 14.5195 12.9167V13.75C14.5195 13.8611 14.5612 13.9583 14.6445 14.0417C14.7278 14.125 14.825 14.1667 14.9362 14.1667Z" fill="#202020" fill-opacity="0.8"/>
                                  </svg>
                                <p class="my-auto t2 fs-5">'.$row->company_size.'+ Employers</p>
                            </span>
                        </div>
                        <div class="d-flex gap-3 mt-4">
                            '.$buttons.'
                        </div>
                        <div style="font-size: 14px;">
						<div class="mt-4">
                                <h5 class="mb-2">Role Summary</h5>
                            '.$row->job_description.'
                        </div>
                        </div>
                    </div>
                
			';
			echo $html;
		}else{
			echo 'Something went wrong';
		}
	}
	
	public function save_fcm_token()
	{
	
		
		$id=$_POST['id'];
		$token=$_POST['token'];
		$type=$_POST['type'];
		$data = [
			'f_token_web'=>$token,
		];

		$res=$this->lib_model->Update($type, $data, ['id' => $id]);
		if ($res) {
			echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Token updated successfully']);die();
		} else {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Data not updated']);die();
		}
	}
	
}
 