<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employer extends CI_Controller {
	private $user_id;
    public function __construct() {
        parent::__construct();
        $this->check_login('employer');
		$this->load->model('common_model'); 
		$this->load->model('lib_model');  
	    $this->load->helper('common');  
		
		$this->user_id = $this->session->userdata('employer')['id'];
		$site = $this->db->get_where('settings', ['id' => '1'])->row();
		if ($site && $site->website_status == '0') {
			redirect(base_url('maintenance'));
			exit;
		}
    }

    private function check_login($role) {
        $employeeSession = $this->session->userdata('employer');

        if (!$employeeSession || !isset($employeeSession['user_type']) || $employeeSession['user_type'] !== $role) {
            redirect(base_url());
        }
    }
	
	
    public function dashboard() {
		$data['title']='Dashboard';
		$profile = $this->db->where('id', $this->user_id)->get('employer')->row();
		$about = $this->db->where('created_by', $this->user_id)->get('about_com')->row();
		$profile->logo=base_url('jd/jdrec/documents/' . (!empty($about->c_logo) ? $about->c_logo : 'user.png'));
		$data['profile'] = $profile;
		$data['active']=$this->common_model->get_recruiter_job(0,$this->user_id,5);
		$data['inactive']=$this->common_model->get_recruiter_job(1,$this->user_id,5);
		$data['jobs']=$this->db->where('created_by', $this->user_id)->where('status',0)->get('post_job')->num_rows();
		$jobs = $this->db->select('post_job.id, post_job.jTitle, COUNT(applied_job_emp.id) as applicant_count')
						 ->from('post_job')
						 ->join('applied_job_emp', 'applied_job_emp.job_id = post_job.id', 'left')
						 ->where('post_job.created_by', $this->user_id)
						 ->where('post_job.status', 0)->where('applied_job_emp.status', 0)
						 ->group_by('post_job.id')
						 ->order_by('post_job.id', 'ASC')
						 ->limit(2)
						 ->get()
						 ->result();
		$jobIds = !empty($jobs) ? array_column($jobs, 'id') : [0];
		$otherApplicants = $this->db->select('COUNT(applied_job_emp.id) as applicant_count')
                            ->from('post_job')
                            ->join('applied_job_emp', 'applied_job_emp.job_id = post_job.id', 'left')
                            ->where('post_job.created_by', $this->user_id)
                            ->where('post_job.status', 0)->where('applied_job_emp.status', 0)
                            ->where_not_in('post_job.id', $jobIds)
                            ->get()
                            ->row()->applicant_count;

		$totalApplicants = $this->db->from('applied_job_emp')
									->join('post_job', 'post_job.id = applied_job_emp.job_id', 'left')
									->where('post_job.created_by', $this->user_id)
									->where('post_job.status', 0)->where('applied_job_emp.status', 0)
									->count_all_results();

		$data['activeApplicant'] = [
			'title'  => isset($jobs[0]) ? $jobs[0]->jTitle : 'N/A',
			'title2' => isset($jobs[1]) ? $jobs[1]->jTitle : 'N/A',
			'value'  => isset($jobs[0]) ? $jobs[0]->applicant_count : 0,
			'value2' => isset($jobs[1]) ? $jobs[1]->applicant_count : 0,
			'total' => $totalApplicants,
			'others' => $otherApplicants ?: 0,
		];
		$insights = $this->db->select([
                    'COUNT(CASE WHEN applied_job_emp.status = 0 THEN 1 END) as applicant',
                    'COUNT(CASE WHEN applied_job_emp.status = 1 THEN 1 END) as shortlist',
                    'COUNT(CASE WHEN applied_job_emp.status = 2 THEN 1 END) as rejected'
                ])->from('applied_job_emp')->join('post_job', 'post_job.id = applied_job_emp.job_id', 'left')->where('post_job.created_by', $this->user_id)->where('post_job.status', 0)->get()->row();

		$data['insight'] = [
			'applicant' => $insights->applicant,
			'shortlist' => $insights->shortlist,
			'rejected'  => $insights->rejected
		];
		
		$dates = [];
		for ($i = 6; $i >= 0; $i--) {
			$dates[] = date('Y-m-d', strtotime("-$i days"));
		}
		$insights = $this->db->select([
                    'DATE(applied_job_emp.created_at) as date',
                    'COUNT(CASE WHEN applied_job_emp.status = 0 THEN 1 END) as applicant',
                    'COUNT(CASE WHEN applied_job_emp.status = 1 THEN 1 END) as shortlist',
                    'COUNT(CASE WHEN applied_job_emp.status = 2 THEN 1 END) as rejected'
                ])
                ->from('applied_job_emp')
                ->join('post_job', 'post_job.id = applied_job_emp.job_id', 'left')
                ->where('post_job.created_by', $this->user_id)
                ->where('post_job.status', 0)
                ->where('applied_job_emp.created_at >=', date('Y-m-d', strtotime('-6 days')))
                ->group_by('DATE(applied_job_emp.created_at)')
                ->order_by('DATE(applied_job_emp.created_at)', 'ASC')
                ->get()
                ->result();
		$datess = array_map(function ($i) {
				return date('d M', strtotime("-$i days"));
			}, range(6, 0));
		$chartData = [
			
			'dates' => $datess,
			'applicant' => array_fill(0, 7, 0),
			'shortlist' => array_fill(0, 7, 0),
			'rejected' => array_fill(0, 7, 0)
		];

		foreach ($insights as $insight) {
			$index = array_search($insight->date, $dates);
			if ($index !== false) {
				$chartData['applicant'][$index] = (int)$insight->applicant;
				$chartData['shortlist'][$index] = (int)$insight->shortlist;
				$chartData['rejected'][$index] = (int)$insight->rejected;
			}
		}

		$data['chartData'] = $chartData;
		
		$data['activeJobRoles'] = $this->db->select('post_job.id, post_job.jTitle, COUNT(applied_job_emp.id) as applicant_count')
		->from('post_job')
		->join('applied_job_emp', 'applied_job_emp.job_id = post_job.id', 'left')
		->where('post_job.created_by', $this->user_id)
		->where('post_job.status', 0)
		->where('applied_job_emp.status', 0)
		->where('DATE(applied_job_emp.created_at)', date('Y-m-d'))
		->group_by('post_job.id')
		->order_by('post_job.id', 'ASC')
		->get()
		->result();
		$data['latestAplicant']=$this->common_model->get_applicant($this->user_id,$status=0,$job_id=null,$limit=5);
		$this->load->view('Employer/dashboard',$data);		
    }
	
    public function profile() {
		$data['title']='My Profile';
		$profile = $this->db->where('id', $this->user_id)->get('employer')->row();
		$about = $this->db->where('created_by', $this->user_id)->get('about_com')->row();
		$profile->logo=base_url('jd/jdrec/documents/' . (!empty($about->c_logo) ? $about->c_logo : 'user.png'));
		$data['profile'] = $profile;
		$data['active']=$this->common_model->get_recruiter_job(0,$this->user_id,5);
		$data['activeJobRoles'] = $this->db->select('post_job.id, post_job.jTitle, COUNT(applied_job_emp.id) as applicant_count')
		->from('post_job')
		->join('applied_job_emp', 'applied_job_emp.job_id = post_job.id', 'left')
		->where('post_job.created_by', $this->user_id)
		->where('post_job.status', 0)
		->where('applied_job_emp.status', 0)
		->where('DATE(applied_job_emp.created_at)', date('Y-m-d'))
		->group_by('post_job.id')
		->order_by('post_job.id', 'ASC')
		->get()
		->result();
		$this->load->view('Employer/profile',$data);		
    }
	
	public function application() {
		$data['title']='Application';
		$data['application']=$this->common_model->get_applicant($this->user_id,$status=0);
		$data['shortlist']=$this->common_model->get_applicant($this->user_id,$status=1);
		$data['rejected']=$this->common_model->get_applicant($this->user_id,$status=2);
		$this->load->view('Employer/application',$data);		
    }
	
	public function shortlist() {
		$data['title']='Shortlist';
		$data['application']=$this->common_model->get_applicant($this->user_id,$status=0);
		$data['shortlist']=$this->common_model->get_applicant($this->user_id,$status=1);
		$data['rejected']=$this->common_model->get_applicant($this->user_id,$status=2);
		$this->load->view('Employer/shortlist',$data);		
    }
	
	public function jobs() {
		$data['title']='Jobs';
		$data['active']=$this->common_model->get_recruiter_job(0,$this->user_id);
		$data['inactive']=$this->common_model->get_recruiter_job(1,$this->user_id);

		$this->load->view('Employer/jobs',$data);		
    }
	
	public function rejected() {
		$data['title']='Rejected';
		$data['application']=$this->common_model->get_applicant($this->user_id,$status=0);
		$data['shortlist']=$this->common_model->get_applicant($this->user_id,$status=1);
		$data['rejected']=$this->common_model->get_applicant($this->user_id,$status=2);
		$this->load->view('Employer/rejected',$data);		
    }
	
	public function addJob() {
		$data['title']='Add Job';
		$data['qualification'] = $this->getJobTitles('qualification');
		$data['employement_type'] = $this->getJobTitles('employement_type');
		$data['job_type'] = $this->getJobTitles('job_type');
		$data['shift'] = $this->getJobTitles('shift');
		$data['experience'] = $this->getJobTitles('experience');
		$data['communication'] = $this->getJobTitles('communication');
		$data['salary_type'] = $this->getJobTitles('salary_type');
		$data['tag'] = $this->getJobTitles('employer_tag');
		
		$check=$this->db->where('created_by', $this->user_id)->get('about_com')->num_rows();
		if($check==0){
			redirect(base_url('employer/profile'));
		}
		if(isset($_GET['id']) && !empty($_GET['id'])){
			$id=$_GET['id'];
			$res=$this->db->where('id', $id)->get('post_job')->row();
			if($res->created_by==$this->user_id){
				$data['job']=$res;
			}else{
				redirect(base_url('employer/jobs'));
			}
		}
		$this->load->view('Employer/addJob',$data);		
    }
	
   public function get_districts() {
        $id = $this->input->post('state_id');
        $cities=$this->db->where('state_id',$id)->get('district')->result();
        echo json_encode($cities);
    }

    public function get_cities() {
		$id = $this->input->post('district_id');
        $cities=$this->db->where('districtid',$id)->get('city')->result();
        echo json_encode($cities);
    }
	
	
	public function update_about_company()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'name', 'label' => 'Company Name', 'rules' => 'required'],
			['field' => 'email', 'label' => 'Company Email', 'rules' => 'required|trim|valid_email'],
			['field' => 'mobile', 'label' => 'Company Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'com_type', 'label' => 'Company type', 'rules' => 'required'],
			['field' => 'r_name', 'label' => 'Recruiter name', 'rules' => 'required'],
			['field' => 'r_mobile', 'label' => 'Recruiter mobile', 'rules' => 'required'],
			['field' => 'r_desig', 'label' => 'Recruiter Designation', 'rules' => 'required'],
			['field' => 'state', 'label' => 'state', 'rules' => 'required'],
			['field' => 'district', 'label' => 'district', 'rules' => 'required'],
			['field' => 'city', 'label' => 'city', 'rules' => 'required'],
			['field' => 'pincode', 'label' => 'pincode', 'rules' => 'required'],
			['field' => 'address', 'label' => 'address', 'rules' => 'required'],
			['field' => 'n_emp', 'label' => 'no of employee', 'rules' => 'required'],
			['field' => 'des', 'label' => 'company description', 'rules' => 'required'],
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		
		$check=$this->db->where('created_by', $this->user_id)->get('about_com')->num_rows();
		$about=$this->db->where('created_by', $this->user_id)->get('about_com')->row();
		if (empty($about->c_logo) && empty($_FILES["image"]['name'])) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please select company logo']);die();
		} 
		// if (empty($about->documents) && empty($_FILES["doc"]['name'])) {
			// echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please upload resume']);die();
		// }

	   if (!empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'jd/jdrec/documents';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$image = $upload_data['raw_name'] . '.webp'; 
					} else {
						$image = $file_name_c_logo;
					}
				} else {
					$image = $file_name_c_logo;
				}
				
			} else {
				$error = $this->upload->display_errors('', '');
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$error]);die();
			}
		}
		
	   if(!empty($_FILES["doc"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["doc"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'jd/jdrec/documents';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 10000;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('doc')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 
				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$doc = $upload_data['raw_name'] . '.webp'; 
					} else {
						$doc = $file_name_c_logo;
					}
				} else {
					$doc = $file_name_c_logo;
				}
			} else {
				$error = $this->upload->display_errors('', '');
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$error]);die();
			}
		}
		
		$data = [
			'created_by' => $this->user_id,
			'name' => $input['name'],
			'number' => $input['mobile'],
			'email' => $input['email'],
			'com_type' => $input['com_type'],
			'r_name' => $input['r_name'],
			'r_mobile' => $input['r_mobile'],
			'r_desig' => $input['r_desig'],
			'adress' => $input['address'],
			'link' => $input['link'],
			'linkedin' => $input['linkedin'],
			'c_desc' => $input['des'],
			'c_gst' => $input['c_gst'],
			'n_emp' => $input['n_emp'],
			'doc_type' => $input['doc_type'],
			'state' => $input['state'],
			'District' => $input['district'],
			'city' => $input['city'],
			'zip' => $input['pincode'],
		];
		if(!empty($_FILES["image"]['name'])) {
			$data['c_logo']=$image;
		}
		if(!empty($_FILES["resume"]['name'])) {
			$data['documents']=$doc;
		}
		if($check==0){
			$res = $this->lib_model->Insert('about_com', $data);
			$cdata = [
				'comp_name' => $input['name'],
				'c_name' => $input['name'],
				'c_email' => $input['email']
			];
			$this->lib_model->Update('employer', $cdata, ['id' => $this->user_id]);
		}else{
			$res = $this->lib_model->Update('about_com', $data, ['created_by' => $this->user_id]);
			$cdata = [
				'comp_name' => $input['name'],
				'c_name' => $input['name'],
				'c_email' => $input['email']
			];
			$this->lib_model->Update('employer', $cdata, ['id' => $this->user_id]);
		}
		
		if($res){
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Data updated successfully"]);
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to update, please try again"]);
		}
	}
	
	public function submit_job()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'title', 'label' => 'Job title', 'rules' => 'required'],
			['field' => 'opening', 'label' => 'no. of job opening', 'rules' => 'required'],
			['field' => 'skills', 'label' => 'skills', 'rules' => 'required'],
			['field' => 'employment_type', 'label' => 'employment type', 'rules' => 'required'],
			['field' => 'job_type', 'label' => 'job type', 'rules' => 'required'],
			['field' => 'shift', 'label' => 'Shift', 'rules' => 'required'],
			['field' => 'experience', 'label' => 'experience', 'rules' => 'required'],
			['field' => 'qualification', 'label' => 'qualification', 'rules' => 'required'],
			['field' => 'communication', 'label' => 'communication', 'rules' => 'required'],
			['field' => 'salary_type', 'label' => 'salary type', 'rules' => 'required'],
			['field' => 'min', 'label' => 'min salary', 'rules' => 'required'],
			['field' => 'max', 'label' => 'max salary', 'rules' => 'required'],
			['field' => 'from_day', 'label' => 'working day from', 'rules' => 'required'],
			['field' => 'to_day', 'label' => 'working day to', 'rules' => 'required'],
			['field' => 'des', 'label' => 'company description', 'rules' => 'required'],
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		
	   if (!empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'jd/jdrec/jobimage';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$image = $upload_data['raw_name'] . '.webp'; 
					} else {
						$image = $file_name_c_logo;
					}
				} else {
					$image = $file_name_c_logo;
				}
				
			} else {
				$error = $this->upload->display_errors('', '');
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$error]);die();
			}
		}
		
		$about = $this->lib_model->Select('about_com', '*', ['created_by' => $this->user_id ]);
		
		
		$state    = !empty($input['state'])    ? $input['state']    : $about[0]->state;
		$district = !empty($input['district']) ? $input['district'] : $about[0]->District;
		$city     = !empty($input['city'])     ? $input['city']     : $about[0]->city;
		$zip      = !empty($input['pincode'])  ? $input['pincode']  : $about[0]->zip;
		$address  = !empty($input['address'])  ? $input['address']  : $about[0]->adress;

		
		$data = [
			'created_by' => $this->user_id,
			'jTitle' => $input['title'],
			'nOpen'=>$input['opening'],
			'state'=> $state ,
			'District'=> $district,
			'city' => $city,
			'zip'=> $zip,
			'adress'=> $address,
			'c_eng'=>$input['communication'],
			'emp_type'=>$input['employment_type'],
			'jobtype'=>$input['job_type'],
			'shift'=>$input['shift'],
			'experience'=>$input['experience'],
			'quali'=>$input['qualification'],
			'sType' => $input['salary_type'],
			'sMin' => $input['min'],
			'sMax'=>$input['max'],
			'jobDescription'=>$input['des'],
			'skills'=>$input['skills'],
			'dayFrom'=>$input['from_day'],
			'dayTo'=>$input['to_day'],
			'tag'=>$input['tag'],
			'gender'=>$input['gender'] ?? null,
		];
		if(!empty($_FILES["image"]['name'])) {
			$data['job_image']=$image;
		}
		if(empty($input['id'])){
			$res=$this->lib_model->Insert('post_job', $data);
			if($res){
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'redirect','redirectLink'=>base_url('employer/jobs'),'msg'=>"Data added successfully"]);
			}else{
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to add, please try again"]);
			}
		}else{
			$res=$this->lib_model->Update('post_job', $data,['id'=>$input['id']]);
			if($res){
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'redirect','redirectLink'=>base_url('employer/jobs'),'msg'=>"Data updated successfully"]);
			}else{
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to update, please try again"]);
			}
		}
		
		
	}
	
	private function getJobTitles($type){
		return  $this->db->where('category', $type)->get('post_job_titles')->result();
	}
	
	public function status_update() {
		$table=$this->input->post('table');
		$where_column=$this->input->post('where_column');
		$where_value=$this->input->post('where_value');
		$status=$this->input->post('status');
		$data = $this->lib_model->Update($table, ['status'=>$status],[$where_column=>$where_value]);	
		if($data){
			if($table=='applied_job_emp'){
				$job=$this->db->select('*')->from($table)->where('id', $where_value)->get()->row();
				if($status==1){
					$title='🎯 Shortlisted for Interview';
					$body='Great news! You’ve been shortlisted. The recruiter will contact you soon for next steps.';
					$this->common_model->saveNotification($job->emp_id,$title,$body,'employee');
				}
				if($status==2){
					$title='❌ Application Update';
					$body='Unfortunately, your application wasn’t shortlisted this time. Don’t give up — new opportunities await!';
					$this->common_model->saveNotification($job->emp_id,$title,$body,'employee');
				}
			}
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>'Status updated successfully']);die();
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Data not delete, please try again']);die();
		}
    }
	
	public function delete_parmanently() {
		$table=$this->input->post('table');
		$where_column=$this->input->post('where_column');
		$where_value=$this->input->post('where_value');
		
		$data = $this->db->where($where_column, $where_value)->delete($table);
		if($this->db->affected_rows() > 0){
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>'Data deleted successfully']);die();
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Data not delete, please try again']);die();
		}
    }
	
	public function get_insight(){
		$id=$this->input->post('id');
		$dates = [];
		for ($i = 6; $i >= 0; $i--) {
			$dates[] = date('Y-m-d', strtotime("-$i days"));
		}
		$insights = $this->db->select([
                    'DATE(applied_job_emp.created_at) as date',
                    'COUNT(CASE WHEN applied_job_emp.status = 0 THEN 1 END) as applicant',
                    'COUNT(CASE WHEN applied_job_emp.status = 1 THEN 1 END) as shortlist',
                    'COUNT(CASE WHEN applied_job_emp.status = 2 THEN 1 END) as rejected'
                ])
                ->from('applied_job_emp')
                ->join('post_job', 'post_job.id = applied_job_emp.job_id', 'left')
                ->where('post_job.created_by', $this->user_id)
                ->where('post_job.status', 0)
                ->where('applied_job_emp.job_id', $id)
                ->where('applied_job_emp.created_at >=', date('Y-m-d', strtotime('-6 days')))
                ->group_by('DATE(applied_job_emp.created_at)')
                ->order_by('DATE(applied_job_emp.created_at)', 'ASC')
                ->get()
                ->result();
		$datess = array_map(function ($i) {
				return date('d M', strtotime("-$i days"));
			}, range(6, 0));
		$chartData = [
			
			'dates' => $datess,
			'applicant' => array_fill(0, 7, 0),
			'shortlist' => array_fill(0, 7, 0),
			'rejected' => array_fill(0, 7, 0)
		];

		foreach ($insights as $insight) {
			$index = array_search($insight->date, $dates);
			if ($index !== false) {
				$chartData['applicant'][$index] = (int)$insight->applicant;
				$chartData['shortlist'][$index] = (int)$insight->shortlist;
				$chartData['rejected'][$index] = (int)$insight->rejected;
			}
		}

		echo json_encode($chartData);
	}
	
	public function recruitment_journey(){

				
		$data['applicants'] = $this->db->from('applied_job_emp')->where('rec_id', $this->user_id)->where('status', 0)->count_all_results();
		$data['shortlist'] = $this->db->from('applied_job_emp')->where('rec_id', $this->user_id)->where('status', 1)->count_all_results();
		$data['rejected'] = $this->db->from('applied_job_emp')->where('rec_id', $this->user_id)->where('status', 2)->count_all_results();
		$data['withdraw'] = $this->db->from('applied_job_emp')->where('rec_id', $this->user_id)->where('status', 3)->count_all_results();
		$data['applicant_active'] = $this->db->from('applied_job_emp')->where('applied_job_emp.rec_id', $this->user_id)->where('applied_job_emp.status', 0)->join('post_job', 'post_job.id = applied_job_emp.job_id')->where('post_job.status', 0)->count_all_results();
		$data['shortlist_active'] = $this->db->from('applied_job_emp')->where('applied_job_emp.rec_id', $this->user_id)->where('applied_job_emp.status', 1)->join('post_job', 'post_job.id = applied_job_emp.job_id')->where('post_job.status', 0)->count_all_results();
		$data['rejected_active'] = $this->db->from('applied_job_emp')->where('applied_job_emp.rec_id', $this->user_id)->where('applied_job_emp.status', 2)->join('post_job', 'post_job.id = applied_job_emp.job_id')->where('post_job.status', 0)->count_all_results();
		$data['withdraw_active'] = $this->db->from('applied_job_emp')->where('applied_job_emp.rec_id', $this->user_id)->where('applied_job_emp.status', 3)->join('post_job', 'post_job.id = applied_job_emp.job_id')->where('post_job.status', 0)->count_all_results();

		echo json_encode($data);
	}
	
	public function load_candidates(){
		$id=$this->input->post('id');
		$data=$this->common_model->get_applicant($this->user_id,$status=0,$id);
		$html='';
		foreach($data as $row){  
                $skills = explode(',', $row->skills);
				$skillss='';
				foreach ($skills as $skill) {
					$skill = trim($skill);
					if (!empty($skill)) {
						$skillss.='<div class="job-cat-btn">'.htmlspecialchars(ucfirst($skill)).'</div>';	
					}
				}
				$html.='<div class="EmployeeCard position-relative mb-3">
                    <div class="urgentHire-btn">
                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                            <path d="M7 14V10.5C7 9.57174 7.36875 8.6815 8.02513 8.02513C8.6815 7.36875 9.57174 7 10.5 7C11.4283 7 12.3185 7.36875 12.9749 8.02513C13.6313 8.6815 14 9.57174 14 10.5V14M2.625 10.5H3.5M10.5 2.625V3.5M17.5 10.5H18.375M4.9 4.9L5.5125 5.5125M16.1 4.9L15.4875 5.5125M5.25 14.875C5.25 14.6429 5.34219 14.4204 5.50628 14.2563C5.67038 14.0922 5.89294 14 6.125 14H14.875C15.1071 14 15.3296 14.0922 15.4937 14.2563C15.6578 14.4204 15.75 14.6429 15.75 14.875V16.625C15.75 16.8571 15.6578 17.0796 15.4937 17.2437C15.3296 17.4078 15.1071 17.5 14.875 17.5H6.125C5.89294 17.5 5.67038 17.4078 5.50628 17.2437C5.34219 17.0796 5.25 16.8571 5.25 16.625V14.875Z" stroke="#FF6F42" stroke-width="1.575" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                        <span>  Immediate Joiner</span>
                    </div>
                    <div class="row mx-0">
                        <div class="col-md-7">
                            <div class="d-flex gap-2">
                                <img src="'.$row->emp_profile.'" alt="">
                                <div>
                                    <h6>'.$row->emp_name.' </h6>
								
                                    <h5>'.$row->job_title.' • '.$row->experience.'</h5>
                                    <div class="quali mt-3">
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                                <path d="M12.5 6.5V12C12.5 12 9.574 13 8 13C6.426 13 3.5 12 3.5 12V6.5M14 5.5L8 3L2 5.5L8 8.5L14 5.5ZM14 5.5V10" stroke="#202020" stroke-opacity="0.8"></path>
                                            </svg> '.$row->qualification.'
                                        </span>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                                <path d="M13.3333 4.50065C13.72 4.50065 14.0333 4.63398 14.28 4.89398C14.5333 5.16732 14.6667 5.46732 14.6667 5.83398V13.1673C14.6667 13.534 14.5333 13.834 14.28 14.1073C14.0333 14.3673 13.72 14.5007 13.3333 14.5007H2.66668C2.28001 14.5007 1.96668 14.3673 1.72001 14.1073C1.46668 13.834 1.33334 13.534 1.33334 13.1673V5.83398C1.33334 5.46732 1.46668 5.16732 1.72001 4.89398C1.96668 4.63398 2.28001 4.50065 2.66668 4.50065H5.33334V3.16732C5.33334 2.78065 5.46668 2.46732 5.72001 2.22065C5.96668 1.96732 6.28001 1.83398 6.66668 1.83398H9.33334C9.72001 1.83398 10.0333 1.96732 10.28 2.22065C10.5333 2.46732 10.6667 2.78065 10.6667 3.16732V4.50065H13.3333ZM2.66668 5.83398V13.1673H13.3333V5.83398H2.66668ZM9.33334 4.50065V3.16732H6.66668V4.50065H9.33334Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg> '.$row->job_type.'
                                        </span>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                                <path d="M15.5 8.5C15.5 8.63261 15.4473 8.75979 15.3536 8.85355C15.2598 8.94732 15.1326 9 15 9H13.9581C13.839 9.69863 13.4768 10.3327 12.9355 10.7901C12.3943 11.2476 11.7087 11.499 11 11.5H8.5V13H10C10.5304 13 11.0391 13.2107 11.4142 13.5858C11.7893 13.9609 12 14.4696 12 15C12 15.1326 11.9473 15.2598 11.8536 15.3536C11.7598 15.4473 11.6326 15.5 11.5 15.5C11.3674 15.5 11.2402 15.4473 11.1464 15.3536C11.0527 15.2598 11 15.1326 11 15C11 14.7348 10.8946 14.4804 10.7071 14.2929C10.5196 14.1054 10.2652 14 10 14H8.5V15C8.5 15.1326 8.44732 15.2598 8.35355 15.3536C8.25979 15.4473 8.13261 15.5 8 15.5C7.86739 15.5 7.74021 15.4473 7.64645 15.3536C7.55268 15.2598 7.5 15.1326 7.5 15V14H6C5.73478 14 5.48043 14.1054 5.29289 14.2929C5.10536 14.4804 5 14.7348 5 15C5 15.1326 4.94732 15.2598 4.85355 15.3536C4.75979 15.4473 4.63261 15.5 4.5 15.5C4.36739 15.5 4.24021 15.4473 4.14645 15.3536C4.05268 15.2598 4 15.1326 4 15C4 14.4696 4.21071 13.9609 4.58579 13.5858C4.96086 13.2107 5.46957 13 6 13H7.5V11.5H5C4.2913 11.499 3.60574 11.2476 3.06445 10.7901C2.52316 10.3327 2.16097 9.69863 2.04187 9H1C0.867392 9 0.740215 8.94732 0.646447 8.85355C0.552678 8.75979 0.5 8.63261 0.5 8.5C0.5 8.36739 0.552678 8.24021 0.646447 8.14645C0.740215 8.05268 0.867392 8 1 8H2.5C2.63261 8 2.75979 8.05268 2.85355 8.14645C2.94732 8.24021 3 8.36739 3 8.5C3 9.03043 3.21071 9.53914 3.58579 9.91421C3.96086 10.2893 4.46957 10.5 5 10.5H11C11.5304 10.5 12.0391 10.2893 12.4142 9.91421C12.7893 9.53914 13 9.03043 13 8.5C13 8.36739 13.0527 8.24021 13.1464 8.14645C13.2402 8.05268 13.3674 8 13.5 8H15C15.1326 8 15.2598 8.05268 15.3536 8.14645C15.4473 8.24021 15.5 8.36739 15.5 8.5ZM4.24438 9.155C4.15058 9.0468 4.08111 8.91971 4.04067 8.78234C4.00024 8.64497 3.98978 8.50051 4.01 8.35875L4.8675 2.35875C4.90249 2.12085 5.02162 1.90337 5.20327 1.74581C5.38492 1.58824 5.61704 1.50103 5.8575 1.5H10.1425C10.383 1.50103 10.6151 1.58824 10.7967 1.74581C10.9784 1.90337 11.0975 2.12085 11.1325 2.35875L11.99 8.35875C12.0102 8.50057 11.9998 8.64509 11.9593 8.78251C11.9188 8.91994 11.8493 9.04706 11.7554 9.15528C11.6615 9.26349 11.5455 9.35028 11.4152 9.40975C11.2848 9.46923 11.1433 9.5 11 9.5H5C4.85668 9.5 4.71504 9.46919 4.58467 9.40967C4.4543 9.35015 4.33825 9.26329 4.24438 9.155ZM5 8.5H11L10.1425 2.5H5.85687L5 8.5Z" fill="#202020" fill-opacity="0.8"></path>
                                            </svg> '.$row->employment_type.'
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex gap-2 mt-3" style="overflow: hidden;">
                                <div class="job-cat-btn">'.$row->job_type.'</div>
                                        <div class="job-cat-btn">'.$row->employment_type.'</div>
                                        '.$skillss.'
                            </div>
                        </div>
                        <div class="col-md-3 mt-2"></div>
                        <div class="col-md-2 cardbtnFlex align-self-end gap-3">
                            <div>
                                <button class="btn-outline-custom w-100" onclick="viewResume(\'' . $row->resume . '\')">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
                                        <path d="M8.45625 7.66797C8.44531 7.64766 8.43437 7.63828 8.42188 7.63672C8.37656 7.68828 8.3875 8.12891 8.46406 8.43984C8.52656 8.22734 8.5375 7.80703 8.45625 7.66797ZM8.43125 9.55078C8.31094 9.86328 8.1375 10.2898 7.92969 10.6664C7.99219 10.6414 8.05625 10.6148 8.12187 10.5883C8.39687 10.4758 8.70469 10.3492 9.04219 10.2727C8.80938 10.0883 8.59844 9.83984 8.43125 9.55078Z" fill="#E6F2FF"></path>
                                        <path d="M8.84375 5.5V2.125H4.125V13.875H12.875V6.15625H9.5C9.32595 6.15625 9.15903 6.08711 9.03596 5.96404C8.91289 5.84097 8.84375 5.67405 8.84375 5.5ZM9.70312 9.99375C9.95469 9.96406 10.1812 9.95 10.3953 9.95781C10.5953 9.96406 10.7641 9.98906 10.8953 10.0375C10.8984 10.0391 10.9 10.0391 10.9031 10.0406C10.9094 10.0437 10.9156 10.0453 10.9219 10.0484C10.9297 10.0516 10.9391 10.0547 10.9469 10.0594C10.9484 10.0609 10.9516 10.0609 10.9531 10.0625C11.0172 10.0906 11.0703 10.125 11.1109 10.1656C11.2531 10.3078 11.2953 10.5734 11.2078 10.7844C11.1578 10.9047 11.025 11.1047 10.6875 11.1047C10.3469 11.1047 9.84531 10.9531 9.40469 10.7172C9.00625 10.7844 8.56563 10.9344 8.14062 11.0781C8.05 11.1094 7.95625 11.1406 7.86562 11.1703C7.27187 12.1891 6.82656 12.4109 6.55156 12.4109C6.48594 12.4109 6.42969 12.3969 6.38281 12.3797C6.275 12.3391 6.18281 12.2547 6.125 12.1453C6.11094 12.1187 6.1 12.0922 6.09062 12.0641C6.06562 11.9891 6.05781 11.9141 6.07031 11.8516L6.07969 11.8094C6.08125 11.8062 6.08125 11.8031 6.08281 11.8C6.08594 11.7891 6.08906 11.7781 6.09375 11.7672C6.09375 11.7656 6.09531 11.7641 6.09531 11.7625C6.15938 11.5766 6.30781 11.3969 6.52812 11.2219C6.72031 11.0688 6.95156 10.9297 7.24531 10.7781C7.49375 10.3406 7.83281 9.60469 8.04531 9.1C7.87656 8.44688 7.78437 7.93437 7.8875 7.55937C7.90156 7.50781 7.92656 7.45938 7.95937 7.41719C7.9625 7.41406 7.96406 7.41094 7.96719 7.40781C7.96875 7.40625 7.96875 7.40469 7.97031 7.40469C8.06875 7.2875 8.23438 7.21875 8.40938 7.225C8.66875 7.23594 8.87344 7.40469 8.925 7.69531C8.95156 7.82031 8.95937 7.95312 8.95469 8.09688V8.10781C8.95469 8.11563 8.95469 8.12344 8.95312 8.13125C8.94219 8.33906 8.90625 8.54687 8.83906 8.82969C8.83281 8.85469 8.82656 8.87969 8.82031 8.91094L8.80469 8.975L8.80313 8.97969C8.80469 8.98281 8.80469 8.98438 8.80625 8.9875L8.83438 9.05781C8.83594 9.0625 8.83906 9.06875 8.84062 9.07344C8.85156 9.09844 8.8625 9.125 8.87344 9.14844V9.15C9.00938 9.44375 9.18125 9.67188 9.40312 9.85469C9.47031 9.90938 9.54219 9.95937 9.62031 10.0078C9.64844 10 9.675 9.99687 9.70312 9.99375Z" fill="#E6F2FF"></path>
                                        <path d="M6.61719 11.8904C6.70625 11.8216 6.87031 11.6638 7.0875 11.3482C6.92656 11.4951 6.72187 11.6982 6.61719 11.8904ZM10.85 10.5935L10.8531 10.5888H10.8562C10.8656 10.5826 10.8641 10.5779 10.8625 10.5747C10.8609 10.5732 10.7922 10.4294 10.1578 10.4591C10.7094 10.6763 10.8375 10.6013 10.85 10.5935Z" fill="#E6F2FF"></path>
                                        <path d="M13.8531 4.50938L10.4906 1.14688C10.3969 1.05313 10.2703 1 10.1375 1H3.5C3.22344 1 3 1.22344 3 1.5V14.5C3 14.7766 3.22344 15 3.5 15H13.5C13.7766 15 14 14.7766 14 14.5V4.86406C14 4.73125 13.9469 4.60313 13.8531 4.50938ZM9.90625 2.15313L12.8469 5.09375H9.90625V2.15313ZM12.875 13.875H4.125V2.125H8.84375V5.5C8.84375 5.67405 8.91289 5.84097 9.03596 5.96404C9.15903 6.08711 9.32595 6.15625 9.5 6.15625H12.875V13.875Z" fill="#007BFF"></path>
                                        <path d="M8.87347 9.14434C8.86097 9.11778 8.85003 9.09278 8.83909 9.06778C8.83753 9.06309 8.8344 9.05684 8.83284 9.05215L8.80471 8.98184C8.80315 8.97872 8.80315 8.97715 8.80159 8.97403L8.80315 8.96934L8.80628 8.95215C8.86878 8.69746 8.94065 8.40059 8.95315 8.10215V8.09122C8.95784 7.95684 8.95003 7.82246 8.9219 7.69121C8.86253 7.3584 8.61721 7.22872 8.40784 7.21934C8.23128 7.21153 8.06721 7.28184 7.96878 7.39747C7.96721 7.39903 7.96721 7.40059 7.96565 7.40059C7.96253 7.40372 7.9594 7.40684 7.95784 7.40996C7.92503 7.45215 7.90003 7.50059 7.88596 7.55215C7.78284 7.92715 7.87503 8.43965 8.04378 9.09278C7.83128 9.59903 7.49221 10.3334 7.24378 10.7709V10.7725C6.81096 10.9959 6.24221 11.3318 6.09378 11.7553C6.09378 11.7568 6.09221 11.7584 6.09221 11.76C6.08909 11.7709 6.0844 11.7818 6.08128 11.7928C6.07972 11.7959 6.07971 11.799 6.07815 11.8022C6.07503 11.8162 6.07034 11.8303 6.06878 11.8443C6.05471 11.9068 6.06253 11.9818 6.08909 12.0568C6.09847 12.085 6.1094 12.1115 6.12346 12.1381C6.18128 12.2475 6.27346 12.3318 6.38128 12.3725C6.42815 12.3897 6.4844 12.4037 6.55003 12.4037C6.82503 12.4037 7.27034 12.1818 7.86409 11.1631C7.95471 11.1334 8.04846 11.1022 8.13909 11.0709C8.56409 10.9272 9.00471 10.7772 9.40315 10.71C9.84378 10.9459 10.3453 11.0975 10.686 11.0975C11.0235 11.0975 11.1563 10.8975 11.2063 10.7772C11.2938 10.5662 11.2516 10.3006 11.1094 10.1584C11.0688 10.1178 11.0157 10.0834 10.9516 10.0553C10.95 10.0537 10.9469 10.0537 10.9453 10.0522C10.9375 10.049 10.9282 10.0459 10.9203 10.0412C10.9141 10.0381 10.9078 10.0365 10.9016 10.0334C10.8985 10.0318 10.8969 10.0318 10.8938 10.0303C10.6407 9.93965 10.2422 9.92559 9.70159 9.98653L9.61878 9.9959C9.54065 9.94903 9.46878 9.89746 9.40159 9.84278C9.17972 9.66621 9.0094 9.43965 8.87347 9.14434ZM6.61721 11.8897C6.7219 11.6975 6.92659 11.4943 7.08753 11.3475C6.87034 11.6631 6.70628 11.8209 6.61721 11.8897ZM8.4219 7.63653C8.4344 7.63809 8.44534 7.64746 8.45628 7.66778C8.53753 7.80684 8.52659 8.22715 8.46409 8.43965C8.38753 8.12872 8.37659 7.68809 8.4219 7.63653ZM8.1219 10.5881C8.05628 10.6147 7.99221 10.6412 7.92971 10.6662C8.13753 10.2897 8.31097 9.86309 8.43128 9.55059C8.59846 9.83965 8.8094 10.0881 9.04222 10.2725C8.70472 10.349 8.3969 10.4756 8.1219 10.5881ZM10.8625 10.574C10.8641 10.5772 10.8657 10.5818 10.8563 10.5881H10.8532L10.85 10.5928C10.8375 10.6006 10.7094 10.6756 10.1578 10.4584C10.7922 10.4287 10.861 10.5725 10.8625 10.574Z" fill="#007BFF"></path>
                                    </svg> View Resume
                                </button>
                            </div>
                            <div>
                               <button class="btn-custom w-100" onclick="ApplicantStatus(' . $row->id . ', 1, \'shortlist\')">Shortlist</button>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                        <g clip-path="url(#clip0_1891_4034)">
                                        <path d="M3.33337 8.66732L6.66671 11.334L12.6667 4.00065M1.33337 1.33398H14.6667V14.6673H1.33337V1.33398Z" stroke="white" stroke-width="1.33333"></path>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_1891_4034">
                                            <rect width="16" height="16" fill="white"></rect>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="text-end mt-3 px-2">
                        <span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                <path d="M16.25 5.08268L15.7333 13.4368C15.6017 15.571 15.5358 16.6385 15 17.406C14.7355 17.7853 14.3949 18.1054 14 18.346C13.2025 18.8327 12.1333 18.8327 9.995 18.8327C7.85333 18.8327 6.7825 18.8327 5.98333 18.3452C5.58824 18.1041 5.24768 17.7834 4.98333 17.4035C4.44833 16.6352 4.38333 15.566 4.255 13.4285L3.75 5.08268M2.5 5.08268H17.5M13.38 5.08268L12.8108 3.90935C12.4333 3.12935 12.2442 2.74018 11.9183 2.49685C11.846 2.44295 11.7693 2.39501 11.6892 2.35352C11.3283 2.16602 10.895 2.16602 10.0292 2.16602C9.14083 2.16602 8.69667 2.16602 8.32917 2.36102C8.24793 2.40452 8.17044 2.4547 8.0975 2.51102C7.76833 2.76352 7.58417 3.16768 7.21583 3.97518L6.71083 5.08268" stroke="#FD6161" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <span onclick="ApplicantStatus(' . $row->id . ', 2, \'reject\')" class="not-fit">Not Fit</span>
                        </span>
                    </div>
                </div>';
                } 
		if(empty($data)){
			$html='<h4 class="text-center">No candidates found</h4>';
		}
		
		$response = array('html' => $html);
		echo json_encode($response); 
	}
	
	
	public function getChatStatus()
	{
		$emp_id = $this->input->post('emp_id');
		$check=$this->db->get_where('emp_block_recr',['emp_id'=> $emp_id , 'rec_id'=> $this->user_id ]);
		if($check->num_rows()==0){
			$res=[
			'status'=>1,
			'msg'=>'Chat blocked'
			];
		}else{
			$result=$check->row();
			if($result->status==1 and $result->status_recr==1){
				$res=[
				'status'=>1,
				'msg'=>'Chat blocked by both side'
				];
			}elseif($result->status==1){
				$res=[
				'status'=>1,
				'msg'=>'Chat blocked by you'
				];
			}elseif($result->status_recr==1){
				$res=[
				'status'=>1,
				'msg'=>'Chat blocked by recruiter'
				];
			}else{
				$res=[
				'status'=>2,
				'msg'=>'Chat enable'
				];
			}
		}
		echo json_encode($res);
	}
	
	public function update_msg_status()
    {
		$emp_id = $this->input->post('emp_id');
        $postData = [
            'rec_id'   => $this->user_id,
            'emp_id'   => $emp_id,
            'type' => 'employer'
        ];
        $api_url = base_url('api/employee/first-msg-status');
        $response = call_api($api_url, $postData);
        echo json_encode($response);
    }	
	
	public function chat(){
		$data['title']='Chat';
		if(isset($_GET['id']) && !empty($_GET['id'])){
			$id=$_GET['id'];
			$res=$this->loadChat($id);
			$data['emp_id']=$id;
			$data['chat_screen']=$res;
		}
		
		$this->load->view('Employer/chat',$data);
	}
	
	public function loadChat($emp_id){
		$postData = [
            'rec_id'   => $this->user_id,
            'emp_id'   => $emp_id,
            'type' => 'employer'
        ];

        $api_url = base_url('api/employee/fetch-chat');
        $res = call_api($api_url, $postData);
		$profile=$res['data']['profile'];
		$chatres=$res['data']['list'];
		$chat='';
		foreach($chatres as $row){
			if($row['sender_type']=='recruiter'){
			$chat.='<div class="text-end">
				<div class="send-msg">
					<p class="mb-0">'.$row['msg'].'</p>
					<div class="text-end msg-time">
						'.$row['created_at'].'
					</div>
				</div>
			</div>';
			}else{
			$chat.='
			<div>
			<div class="receive-msg">
				<p class="mb-0">'.$row['msg'].'</p>
				<div class="text-end msg-time text-white">
						'.$row['created_at'].'
					</div>
			</div></div>
			';
			}
			
		} 
		
$check = $this->db->get_where('chatbox_msg', ['req_contact' => 2, 'rec_id' => $this->user_id,'ee_id'=>$emp_id])->num_rows();
$emp = $this->db->where('id',$this->user_id)->get('employer')->row();
$rec =  $this->lib_model->Select('employee', 'c_contact as r_mobile,c_name as name,headline', array('id'=> $emp_id ))[0];
// if($check==0){
	
	// $buttons = '
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~send~resume~to~recr\');" class="btn btn-sm btn-outline-primary">Send Resume</a>
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~send~contact~no~to~recr\');" class="btn btn-sm btn-outline-primary">Send Contact</a>
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~request~contact~no~from~recr\');" class="btn btn-sm btn-outline-primary">Exchange Contact</a>
	
// ';

// }else{
	// $buttons = '
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~send~resume~to~recr\');" class="btn btn-sm btn-outline-primary">Send Resume</a>
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~send~contact~no~to~recr\');" class="btn btn-sm btn-outline-primary">Send Contact</a>
    // <a href="tel:'.($rec->r_mobile ?? '').'" class="btn btn-sm btn-primary" disabled><i class="fa fa-phone"></i> '.($rec->r_mobile ?? '').'</a>
	
// ';

// }
$checkmsg = $this->db->get_where('chatbox_msg', ['rec_id' => $this->user_id,'ee_id'=>$emp_id])->num_rows();
$input='';
$call='';
if($checkmsg>1){
	$call='<svg onclick="return videoCall('.$emp_id.',false,\''.addslashes($rec->name ?? '').'\');"  xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
					<path d="M3.5 15.75V8.25C3.5 7.71957 3.71071 7.21086 4.08579 6.83579C4.46086 6.46071 4.96957 6.25 5.5 6.25H14C14.5304 6.25 15.0391 6.46071 15.4142 6.83579C15.7893 7.21086 16 7.71957 16 8.25V15.75C16 16.2804 15.7893 16.7891 15.4142 17.1642C15.0391 17.5393 14.5304 17.75 14 17.75H5.5C4.96957 17.75 4.46086 17.5393 4.08579 17.1642C3.71071 16.7891 3.5 16.2804 3.5 15.75ZM20.668 6.991L16.668 10.554C16.6153 10.6008 16.5731 10.6582 16.5441 10.7225C16.5152 10.7868 16.5001 10.8565 16.5 10.927V12.705C16.5001 12.7755 16.5152 12.8452 16.5441 12.9095C16.5731 12.9738 16.6153 13.0312 16.668 13.078L20.668 16.641C20.7401 16.705 20.8291 16.7468 20.9244 16.7614C21.0196 16.776 21.1171 16.7627 21.205 16.7232C21.2929 16.6837 21.3675 16.6196 21.4199 16.5386C21.4722 16.4577 21.5 16.3634 21.5 16.267V7.365C21.5 7.26862 21.4722 7.17429 21.4199 7.09335C21.3675 7.01242 21.2929 6.94834 21.205 6.90882C21.1171 6.86931 21.0196 6.85604 20.9244 6.87062C20.8291 6.8852 20.7401 6.927 20.668 6.991Z" stroke="#202020" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				</svg>
				<svg onclick="return videoCall('.$emp_id.',true,\''.addslashes($rec->name ?? '').'\');"  xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
					<path d="M20.45 21C18.3667 21 16.3083 20.546 14.275 19.638C12.2417 18.73 10.3917 17.4423 8.725 15.775C7.05833 14.1077 5.771 12.2577 4.863 10.225C3.955 8.19233 3.50067 6.134 3.5 4.05C3.5 3.75 3.6 3.5 3.8 3.3C4 3.1 4.25 3 4.55 3H8.6C8.83333 3 9.04167 3.07933 9.225 3.238C9.40833 3.39667 9.51667 3.584 9.55 3.8L10.2 7.3C10.2333 7.56667 10.225 7.79167 10.175 7.975C10.125 8.15833 10.0333 8.31667 9.9 8.45L7.475 10.9C7.80833 11.5167 8.204 12.1123 8.662 12.687C9.12 13.2617 9.62433 13.816 10.175 14.35C10.6917 14.8667 11.2333 15.346 11.8 15.788C12.3667 16.23 12.9667 16.634 13.6 17L15.95 14.65C16.1 14.5 16.296 14.3877 16.538 14.313C16.78 14.2383 17.0173 14.2173 17.25 14.25L20.7 14.95C20.9333 15.0167 21.125 15.1377 21.275 15.313C21.425 15.4883 21.5 15.684 21.5 15.9V19.95C21.5 20.25 21.4 20.5 21.2 20.7C21 20.9 20.75 21 20.45 21ZM6.525 9L8.175 7.35L7.75 5H5.525C5.60833 5.68333 5.725 6.35833 5.875 7.025C6.025 7.69167 6.24167 8.35 6.525 9ZM15.475 17.95C16.125 18.2333 16.7877 18.4583 17.463 18.625C18.1383 18.7917 18.8173 18.9 19.5 18.95V16.75L17.15 16.275L15.475 17.95Z" fill="#202020"/>
				</svg>';
	$input='
	<div class="typemsgDiv">
                            <div class="type-msg justify-content-between">
                                <div class="d-flex col-md-11 gap-2">
                                    
                                    <div class="dropdown">
                                        <span data-bs-toggle="dropdown" aria-expanded="false" class="">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                                                <rect x="0.5" y="0.5" width="35" height="35" rx="17.5" fill="#F1F8FF"></rect>
                                                <path d="M25 19H19V25H17V19H11V17H17V11H19V17H25V19Z" fill="#202020"></path>
                                            </svg>
                                        </span>
                                        <ul class="dropdown-menu" style="">
										  <li><a class="dropdown-item" onclick="sendContactAndResume(\'Please send your contact number.\')">Request Contact</a></li>
                                          <li><a class="dropdown-item" onclick="sendContactAndResume(\'Please send your updated resume.\')">Request Resume</a></li>
                                          <li><a class="dropdown-item" onclick="sendContactAndResume('.$profile['rec_contact'].')">Send Contact</a></li>
                                        </ul>
                                    </div>

                                    <input id="message" class="border-0 p-0 w-100" type="text" placeholder="Type a Message">
                                </div>
                                <div>
                                    
                                </div>
                            </div>
                        </div>
	
	';
}
$checkmsg = $this->db->get_where('chatbox_msg', ['rec_id' => $this->user_id,'ee_id'=>$emp_id,'sender_type'=>'recruiter'])->num_rows();
if($checkmsg==0){
$input='<button onclick="sendFirstMsg(\'Hello , Are you interested for this Job Post.\')" class="btn btn-info">Hello , Are you interested for this Job Post.</button>
<input type="hidden" id="message">
';
}

		$final='
		<div class="row">
<div class="col-md-9 px-0 borderRight chatlist">
	<div class="mainchatscreen">
		<div class="chat-header d-flex justify-content-between">
			<div class="d-flex gap-2">
				<img src="'.$profile['image'].'" alt="" 
				style="width:2rem;height: 2rem;border-radius: 100px;">
				<div>
					<h6 class="mb-0 small">'.$profile['name'].'</h6>
					<p class="mb-0 small" style="color: #1DAC00;">Active</p>
				</div>
			</div>
			<div class="d-flex gap-3 my-auto">
				'.$call.'
			</div>
		</div>
		<div class="chatMessage pt-5 px-3" id="chatMessage">
			<!--<div style="color: rgba(32, 32, 32, 0.80);" class="small text-center mb-3">Today</div>-->
			'.$chat.'
		</div>
		'.$input.'
</div>
</div>
<div class="col-md-3 px-0">
	<div class="user-details">
		<div class="user-details-top">
			<h5 class="my-auto fw-normal text-center">Details</h5>
		</div>
		<div class="py-4 px-3">
		<a href="'.base_url('employer/employee-profile?id='.$emp_id).'">
			<div class="text-center">
				<img src="'.$profile['image'].'" alt="" class="userImg mb-3">
				<h6 class="">'.$profile['name'].'</h6>
				<h6 class="fw-normal small">'.$profile['headline'].'</h6>
			</div></a>
			<!--<div class="emp-position text-center mt-3">
				<p class="mb-0" style="font-size: 0.7rem">Hiring For: <span style="font-weight: 500;">
					UX Designer
				</span></p>
				<p class="mb-0" style="color: #1DAC00;font-size: 0.6rem;">Applied</p>
			</div>
			<div class="d-flex justify-content-between my-3">
				<span style="font-size: 0.8rem;">Options</span>
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
					<g clip-path="url(#clip0_1798_4378)">
					  <path fill-rule="evenodd" clip-rule="evenodd" d="M11.4636 15.7064C11.6511 15.8938 11.9054 15.9992 12.1706 15.9992C12.4357 15.9992 12.69 15.8938 12.8776 15.7064L18.5346 10.0494C18.6301 9.95712 18.7062 9.84678 18.7587 9.72477C18.8111 9.60277 18.8387 9.47155 18.8398 9.33877C18.841 9.20599 18.8157 9.07431 18.7654 8.95141C18.7151 8.82852 18.6408 8.71686 18.547 8.62297C18.4531 8.52908 18.3414 8.45483 18.2185 8.40454C18.0956 8.35426 17.9639 8.32896 17.8312 8.33012C17.6984 8.33127 17.5672 8.35886 17.4452 8.41126C17.3231 8.46367 17.2128 8.53986 17.1206 8.63537L12.1706 13.5854L7.22055 8.63537C7.03195 8.45321 6.77935 8.35241 6.51715 8.35469C6.25496 8.35697 6.00414 8.46214 5.81874 8.64755C5.63333 8.83296 5.52816 9.08377 5.52588 9.34597C5.5236 9.60816 5.6244 9.86076 5.80655 10.0494L11.4636 15.7064Z" fill="#202020" fill-opacity="0.8"/>
					</g>
					<defs>
					  <clipPath id="clip0_1798_4378">
						<rect width="24" height="24" fill="white" transform="matrix(-1 0 0 1 24.1699 0)"/>
					  </clipPath>
					</defs>
				</svg>
			</div>
			<div class="border p-1 rounded-3">
				<div class="d-flex justify-content-between">
					<span class="my-auto" style="font-size: 0.7rem;">Shared Media</span>
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
						<g clip-path="url(#clip0_1798_4351)">
						  <path fill-rule="evenodd" clip-rule="evenodd" d="M11.4636 8.29363C11.6511 8.10616 11.9054 8.00085 12.1706 8.00085C12.4357 8.00085 12.69 8.10616 12.8776 8.29363L18.5346 13.9506C18.6301 14.0429 18.7062 14.1532 18.7587 14.2752C18.8111 14.3972 18.8387 14.5285 18.8398 14.6612C18.841 14.794 18.8157 14.9257 18.7654 15.0486C18.7151 15.1715 18.6408 15.2831 18.547 15.377C18.4531 15.4709 18.3414 15.5452 18.2185 15.5955C18.0956 15.6457 17.9639 15.671 17.8312 15.6699C17.6984 15.6687 17.5672 15.6411 17.4452 15.5887C17.3231 15.5363 17.2128 15.4601 17.1206 15.3646L12.1706 10.4146L7.22055 15.3646C7.03195 15.5468 6.77935 15.6476 6.51715 15.6453C6.25496 15.643 6.00414 15.5379 5.81874 15.3525C5.63333 15.167 5.52816 14.9162 5.52588 14.654C5.5236 14.3918 5.6244 14.1392 5.80655 13.9506L11.4636 8.29363Z" fill="#202020"/>
						</g>
						<defs>
						  <clipPath id="clip0_1798_4351">
							<rect width="24" height="24" fill="white" transform="matrix(-1 0 0 1 24.1699 0)"/>
						  </clipPath>
						</defs>
					</svg>
				</div>
				<div class="d-flex gap-3">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 31 30" fill="none">
						<path d="M15.0889 14.3789C15.0684 14.3408 15.0479 14.3232 15.0244 14.3203C14.9395 14.417 14.96 15.2432 15.1035 15.8262C15.2207 15.4277 15.2412 14.6396 15.0889 14.3789ZM15.042 17.9092C14.8164 18.4951 14.4912 19.2949 14.1016 20.001C14.2188 19.9541 14.3389 19.9043 14.4619 19.8545C14.9775 19.6436 15.5547 19.4063 16.1875 19.2627C15.751 18.917 15.3555 18.4512 15.042 17.9092Z" fill="#E9F3FF"/>
						<path d="M15.8145 10.3125V3.98438H6.9668V26.0156H23.373V11.543H17.0449C16.7186 11.543 16.4056 11.4133 16.1748 11.1826C15.9441 10.9518 15.8145 10.6388 15.8145 10.3125ZM17.4258 18.7383C17.8975 18.6826 18.3223 18.6562 18.7236 18.6709C19.0986 18.6826 19.415 18.7295 19.6611 18.8203C19.667 18.8232 19.6699 18.8232 19.6758 18.8262C19.6875 18.832 19.6992 18.835 19.7109 18.8408C19.7256 18.8467 19.7432 18.8525 19.7578 18.8613C19.7607 18.8643 19.7666 18.8643 19.7695 18.8672C19.8896 18.9199 19.9893 18.9844 20.0654 19.0605C20.332 19.3271 20.4111 19.8252 20.2471 20.2207C20.1533 20.4463 19.9043 20.8213 19.2715 20.8213C18.6328 20.8213 17.6924 20.5371 16.8662 20.0947C16.1191 20.2207 15.293 20.502 14.4961 20.7715C14.3262 20.8301 14.1504 20.8887 13.9805 20.9443C12.8672 22.8545 12.0322 23.2705 11.5166 23.2705C11.3936 23.2705 11.2881 23.2441 11.2002 23.2119C10.998 23.1357 10.8252 22.9775 10.7168 22.7725C10.6904 22.7227 10.6699 22.6729 10.6523 22.6201C10.6055 22.4795 10.5908 22.3389 10.6143 22.2217L10.6318 22.1426C10.6348 22.1367 10.6348 22.1309 10.6377 22.125C10.6436 22.1045 10.6494 22.084 10.6582 22.0635C10.6582 22.0605 10.6611 22.0576 10.6611 22.0547C10.7813 21.7061 11.0596 21.3691 11.4727 21.041C11.833 20.7539 12.2666 20.4932 12.8174 20.209C13.2832 19.3887 13.9189 18.0088 14.3174 17.0625C14.001 15.8379 13.8281 14.877 14.0215 14.1738C14.0479 14.0771 14.0947 13.9863 14.1562 13.9072C14.1621 13.9014 14.165 13.8955 14.1709 13.8896C14.1738 13.8867 14.1738 13.8838 14.1768 13.8838C14.3613 13.6641 14.6719 13.5352 15 13.5469C15.4863 13.5674 15.8701 13.8838 15.9668 14.4287C16.0166 14.6631 16.0312 14.9121 16.0225 15.1816V15.2021C16.0225 15.2168 16.0225 15.2314 16.0195 15.2461C15.999 15.6357 15.9316 16.0254 15.8057 16.5557C15.7939 16.6025 15.7822 16.6494 15.7705 16.708L15.7412 16.8281L15.7383 16.8369C15.7412 16.8428 15.7412 16.8457 15.7441 16.8516L15.7969 16.9834C15.7998 16.9922 15.8057 17.0039 15.8086 17.0127C15.8291 17.0596 15.8496 17.1094 15.8701 17.1533V17.1562C16.125 17.707 16.4473 18.1348 16.8633 18.4775C16.9893 18.5801 17.124 18.6738 17.2705 18.7646C17.3232 18.75 17.373 18.7441 17.4258 18.7383Z" fill="#E9F3FF"/>
						<path d="M11.6406 22.2947C11.8076 22.1658 12.1152 21.8699 12.5225 21.2781C12.2207 21.5535 11.8369 21.9343 11.6406 22.2947ZM19.5771 19.863L19.583 19.8542H19.5889C19.6064 19.8425 19.6035 19.8337 19.6006 19.8279C19.5977 19.825 19.4687 19.5554 18.2793 19.6111C19.3135 20.0183 19.5537 19.8777 19.5771 19.863Z" fill="#E9F3FF"/>
						<path d="M25.207 8.45508L18.9023 2.15039C18.7266 1.97461 18.4893 1.875 18.2402 1.875H5.79492C5.27637 1.875 4.85742 2.29395 4.85742 2.8125V27.1875C4.85742 27.7061 5.27637 28.125 5.79492 28.125H24.5449C25.0635 28.125 25.4824 27.7061 25.4824 27.1875V9.12012C25.4824 8.87109 25.3828 8.63086 25.207 8.45508ZM17.8066 4.03711L23.3203 9.55078H17.8066V4.03711ZM23.373 26.0156H6.9668V3.98438H15.8145V10.3125C15.8145 10.6388 15.9441 10.9518 16.1748 11.1826C16.4056 11.4133 16.7186 11.543 17.0449 11.543H23.373V26.0156Z" fill="#202020" fill-opacity="0.8"/>
						<path d="M15.8694 17.1476C15.8459 17.0978 15.8254 17.0509 15.8049 17.004C15.802 16.9952 15.7961 16.9835 15.7932 16.9747L15.7405 16.8429C15.7375 16.837 15.7375 16.8341 15.7346 16.8283L15.7375 16.8195L15.7434 16.7872C15.8606 16.3097 15.9953 15.7531 16.0188 15.1935V15.173C16.0276 14.921 16.0129 14.6691 15.9602 14.423C15.8489 13.799 15.3889 13.5558 14.9963 13.5382C14.6653 13.5236 14.3576 13.6554 14.1731 13.8722C14.1701 13.8751 14.1701 13.8781 14.1672 13.8781C14.1614 13.8839 14.1555 13.8898 14.1526 13.8956C14.091 13.9747 14.0442 14.0656 14.0178 14.1622C13.8244 14.8654 13.9973 15.8263 14.3137 17.0509C13.9153 18.0001 13.2795 19.3771 12.8137 20.1974V20.2003C12.0022 20.6193 10.9358 21.2492 10.6574 22.0431C10.6574 22.046 10.6545 22.049 10.6545 22.0519C10.6487 22.0724 10.6399 22.0929 10.634 22.1134C10.6311 22.1193 10.6311 22.1251 10.6281 22.131C10.6223 22.1574 10.6135 22.1837 10.6106 22.2101C10.5842 22.3273 10.5989 22.4679 10.6487 22.6085C10.6662 22.6613 10.6867 22.7111 10.7131 22.7609C10.8215 22.966 10.9944 23.1242 11.1965 23.2003C11.2844 23.2326 11.3899 23.2589 11.5129 23.2589C12.0285 23.2589 12.8635 22.8429 13.9768 20.9327C14.1467 20.8771 14.3225 20.8185 14.4924 20.7599C15.2893 20.4904 16.1155 20.2091 16.8625 20.0831C17.6887 20.5255 18.6291 20.8097 19.2678 20.8097C19.9006 20.8097 20.1496 20.4347 20.2434 20.2091C20.4074 19.8136 20.3283 19.3156 20.0617 19.049C19.9856 18.9728 19.886 18.9083 19.7658 18.8556C19.7629 18.8527 19.7571 18.8527 19.7541 18.8497C19.7395 18.8439 19.7219 18.838 19.7073 18.8292C19.6955 18.8234 19.6838 18.8204 19.6721 18.8146C19.6662 18.8117 19.6633 18.8117 19.6574 18.8087C19.1828 18.6388 18.4358 18.6124 17.4221 18.7267L17.2668 18.7443C17.1203 18.6564 16.9856 18.5597 16.8596 18.4572C16.4436 18.1261 16.1242 17.7013 15.8694 17.1476ZM11.6389 22.2951C11.8352 21.9347 12.219 21.5538 12.5207 21.2785C12.1135 21.8702 11.8059 22.1661 11.6389 22.2951ZM15.0227 14.3204C15.0461 14.3234 15.0666 14.3409 15.0871 14.379C15.2395 14.6398 15.219 15.4279 15.1018 15.8263C14.9582 15.2433 14.9377 14.4171 15.0227 14.3204ZM14.4602 19.8546C14.3371 19.9044 14.217 19.9542 14.0998 20.0011C14.4895 19.2951 14.8147 18.4952 15.0403 17.9093C15.3537 18.4513 15.7492 18.9171 16.1858 19.2628C15.553 19.4064 14.9758 19.6437 14.4602 19.8546ZM19.5989 19.8283C19.6018 19.8341 19.6047 19.8429 19.5871 19.8546H19.5813L19.5754 19.8634C19.552 19.8781 19.3117 20.0187 18.2776 19.6115C19.467 19.5558 19.5959 19.8253 19.5989 19.8283Z" fill="#202020" fill-opacity="0.8"/>
					</svg>
					<span style="font-size: 0.8rem;">resume.pdf</span>
				</div>
			</div>
			<div class="d-flex justify-content-between my-3">
				<span style="font-size: 0.8rem;">Scheduled Interview</span>
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
					<g clip-path="url(#clip0_1798_4378)">
					  <path fill-rule="evenodd" clip-rule="evenodd" d="M11.4636 15.7064C11.6511 15.8938 11.9054 15.9992 12.1706 15.9992C12.4357 15.9992 12.69 15.8938 12.8776 15.7064L18.5346 10.0494C18.6301 9.95712 18.7062 9.84678 18.7587 9.72477C18.8111 9.60277 18.8387 9.47155 18.8398 9.33877C18.841 9.20599 18.8157 9.07431 18.7654 8.95141C18.7151 8.82852 18.6408 8.71686 18.547 8.62297C18.4531 8.52908 18.3414 8.45483 18.2185 8.40454C18.0956 8.35426 17.9639 8.32896 17.8312 8.33012C17.6984 8.33127 17.5672 8.35886 17.4452 8.41126C17.3231 8.46367 17.2128 8.53986 17.1206 8.63537L12.1706 13.5854L7.22055 8.63537C7.03195 8.45321 6.77935 8.35241 6.51715 8.35469C6.25496 8.35697 6.00414 8.46214 5.81874 8.64755C5.63333 8.83296 5.52816 9.08377 5.52588 9.34597C5.5236 9.60816 5.6244 9.86076 5.80655 10.0494L11.4636 15.7064Z" fill="#202020" fill-opacity="0.8"></path>
					</g>
					<defs>
					  <clipPath id="clip0_1798_4378">
						<rect width="24" height="24" fill="white" transform="matrix(-1 0 0 1 24.1699 0)"></rect>
					  </clipPath>
					</defs>
				</svg>
			</div>-->
		</div>
	</div>
</div>
</div>

		';
		return $final;
	}
	
	public function user_list()
    {
        $postData = [
            'id'   => $this->user_id,
            'type' => 'employer'
        ];

        $api_url = base_url('api/employee/user-list');
        $response = call_api($api_url, $postData);

        echo json_encode($response);
    }
	
	public function get_job_list()
	{
		$query = $_POST['query']; 
		$job_titles = $this->db->query("SELECT DISTINCT jTitle as title FROM post_job WHERE jTitle LIKE '%$query%'")->result_array();

		if (!empty($job_titles)) {
			echo json_encode(['status' => 'success', 'msg' => 'Data found', 'data' => $job_titles]);
		} else {
			echo json_encode(['status' => 'success', 'msg' => 'Data not found', 'data' => []]);
		}
	}
	
	public function employee_profile(){
		if(isset($_GET['id'])){
			$id=$_GET['id'];
			$data['title']='Employee Profile'; 
			$data['exp'] = $this->common_model->getWorkExperience($id);
			$data['education'] = $this->common_model->getEducations($id);
			$data['portfolio'] = $this->common_model->getPortfolio($id);
			$profile = $this->db->where('id', $id)->get('employee')->row();
			$profile->profile_pic=base_url('profile_pic/' . (!empty($profile->profile_pic) ? $profile->profile_pic : 'user.png'));
			$data['profile'] = $profile;
			$exists = $this->db->where([
				'emp_id' => $id,
				'rec_id' => $this->user_id
			])->get('rec_view_emp')->num_rows();
			$title='👁️ Profile Viewed';
			$body='A recruiter checked your profile! Keep it updated to attract more opportunities.';
			$this->common_model->saveNotification($id,$title,$body,'employee');
			if($exists==0){
				$this->lib_model->Insert('rec_view_emp', ['emp_id'=>$id,'rec_id'=>$this->user_id]);
				
			}
			$career = $this->db->from('career_preferences')->where('created_by', $id)->get()->row();
			if(!empty($career)){
				$career->resume= (!empty($career->resume) ? base_url('canidate_documents/resume/' .$career->resume ) : '');
				if($career->t_exp_type=='fresher'){
					 $exp='Fresher';
				}else{
					$exp=$career->t_exp_yr.'y '.$career->t_exp_month.'m Exp';
				}
				$career->experience=$exp;
			}
			$data['career'] = $career;

			$this->load->view('Employer/employee_profile',$data);
		}else{
			redirect(base_url('employer/application'));
		}
		
	}
	
	public function job_viewed(){
		if(isset($_GET['id'])){
			$id=$_GET['id'];
			$data['title']='Job Viewed'; 
			$data['data']=$this->common_model->get_viewed_applicant($id);
			$this->load->view('Employer/jobViewed',$data);
		}else{
			redirect(base_url('employer/jobs'));
		}
		
	}
}
?>
