<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employee extends CI_Controller {
	private $user_id;
    public function __construct() {
        parent::__construct();
        $this->check_login('employee');
		$this->load->model('common_model'); 
		$this->load->model('lib_model');  
	    $this->load->helper('common');  
		
		$this->user_id = $this->session->userdata('employee')['id'];
		$site = $this->db->get_where('settings', ['id' => '1'])->row();
		if ($site && $site->website_status == '0') {
			redirect(base_url('maintenance'));
			exit;
		}

    }

    private function check_login($role) {
        $employeeSession = $this->session->userdata('employee');

        if (!$employeeSession || !isset($employeeSession['user_type']) || $employeeSession['user_type'] !== $role) {
            redirect(base_url());
        }
    }
 
   private function check_user_completion($type)
{
    $this->user_id = $this->session->userdata('employee')['id'];
    $current_uri = uri_string(); // gets current URL path (e.g., 'career-preference')

    if ($type === 'career') {
        if ($current_uri === 'career-preference') {
            return; // allow user to stay on career-preference page
        }

        $careerStatus = $this->db
            ->where('created_by', $this->user_id)
            ->count_all_results('career_preferences') > 0;

        if (!$careerStatus) {
            $this->session->set_flashdata('toast_msg', 'Please complete your career preference first.');
            redirect(base_url('career-preference')); return;
        }
    }

    if ($type === 'profile') {
        if ($current_uri === 'profile') {
            return; // allow user to stay on profile page
        }

        $user = $this->db->where('status', 0)->where('id', $this->user_id)->get('employee')->row();
        $profileStatus = !empty($user->c_name) && !empty($user->c_email) && !empty($user->profile_pic);

        if (!$profileStatus) {
            $this->session->set_flashdata('toast_msg', 'Please complete your profile before proceeding.');
            redirect(base_url('profile')); return;
        }
    }
}


 
    // public function dashboard() {
        // echo "Welcome to Employee Dashboard, " . $this->session->userdata('name');
    // }
	
	public function chat(){
		$this->check_user_completion('career');
		$this->check_user_completion('profile');
		$data['title']='Chat';
		if(isset($_GET['id']) && !empty($_GET['id'])){
			$id=$_GET['id'];
			$res=$this->loadChat($id);
			$data['rec_id']=$id;
			$data['chat_screen']=$res;
		}
		
		$this->load->view('chat',$data);
	}
	
	
	public function loadChat($rec_id){
		$postData = [
            'emp_id'   => $this->user_id,
            'rec_id'   => $rec_id,
            'type' => 'employee'
        ];

        $api_url = base_url('api/employee/fetch-chat');
        $res = call_api($api_url, $postData);
		$profile=$res['data']['profile'];
		$chatres=$res['data']['list'];
		$chat='';
		foreach($chatres as $row){
			if($row['sender_type']=='employee'){
			$chat.='<div class="text-end">
				<div class="send-msg">
					<p class="mb-0">'.$row['msg'].'</p>
					<div class="text-end msg-time">
						'.$row['created_at'].'
					</div>
				</div>
			</div>';
			}else{
			$chat.='
			<div>
			<div class="receive-msg">
				<p class="mb-0">'.$row['msg'].'</p>
				<div class="text-end msg-time text-white">
						'.$row['created_at'].'
					</div>
			</div></div>
			';
			}
			
		} 
		
// $emp = $this->db->where('id',$this->user_id)->get('employee')->row();
// $career = $this->db->where('created_by',$this->user_id)->get('career_preferences')->row();
// $resume='<span><a target="_blank" href="'.base_url('canidate_documents/resume/'.$career->resume).'">My Resume <i class="fa fa-file-pdf-o text-danger" ></i></a></span>';
// $escaped_resume = htmlspecialchars($resume, ENT_QUOTES); 
// $check = $this->db->get_where('chatbox_msg', ['req_contact' => 2, 'ee_id' => $this->user_id,'rec_id'=>$rec_id])->num_rows();
$rec =  $this->lib_model->Select('about_com', 'r_mobile,name', array('created_by'=> $rec_id ))[0];
// if($check==0){
	
	// $buttons = '
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~send~resume~to~recr\');" class="btn btn-sm btn-outline-primary">Send Resume</a>
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~send~contact~no~to~recr\');" class="btn btn-sm btn-outline-primary">Send Contact</a>
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~request~contact~no~from~recr\');" class="btn btn-sm btn-outline-primary">Exchange Contact</a>
	// <a href="javascript:void(0);" onclick="return videoCall('.$rec_id.',true,\''.addslashes($rec->name ?? '').'\');" class="btn btn-sm btn-info"><i class="fa fa-phone"></i></a>
    // <a href="javascript:void(0);" onclick="return videoCall('.$rec_id.',false,\''.addslashes($rec->name ?? '').'\');" class="btn btn-sm btn-info"><i class="fa fa-video-camera"></i></a>
// ';

// }else{
	// $buttons = '
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~send~resume~to~recr\');" class="btn btn-sm btn-outline-primary">Send Resume</a>
    // <a href="javascript:void(0);" onclick="return sendMessage(\'emp~send~contact~no~to~recr\');" class="btn btn-sm btn-outline-primary">Send Contact</a>
    // <a href="tel:'.($rec->r_mobile ?? '').'" class="btn btn-sm btn-primary" disabled><i class="fa fa-phone"></i> '.($rec->r_mobile ?? '').'</a>
	// <a href="javascript:void(0);" onclick="return videoCall('.$rec_id.',true,\''.addslashes($rec->name ?? '').'\');" class="btn btn-sm btn-info"><i class="fa fa-phone"></i></a>
    // <a href="javascript:void(0);" onclick="return videoCall('.$rec_id.',false,\''.addslashes($rec->name ?? '').'\');" class="btn btn-sm btn-info"><i class="fa fa-video-camera"></i></a>
// ';

// }
$checkmsg = $this->db->get_where('chatbox_msg', ['ee_id' => $this->user_id,'rec_id'=>$rec_id])->num_rows();
$input='';
$call='';
if($checkmsg>1){
	$call='<svg onclick="return videoCall('.$rec_id.',false,\''.addslashes($rec->name ?? '').'\');"  xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
					<path d="M3.5 15.75V8.25C3.5 7.71957 3.71071 7.21086 4.08579 6.83579C4.46086 6.46071 4.96957 6.25 5.5 6.25H14C14.5304 6.25 15.0391 6.46071 15.4142 6.83579C15.7893 7.21086 16 7.71957 16 8.25V15.75C16 16.2804 15.7893 16.7891 15.4142 17.1642C15.0391 17.5393 14.5304 17.75 14 17.75H5.5C4.96957 17.75 4.46086 17.5393 4.08579 17.1642C3.71071 16.7891 3.5 16.2804 3.5 15.75ZM20.668 6.991L16.668 10.554C16.6153 10.6008 16.5731 10.6582 16.5441 10.7225C16.5152 10.7868 16.5001 10.8565 16.5 10.927V12.705C16.5001 12.7755 16.5152 12.8452 16.5441 12.9095C16.5731 12.9738 16.6153 13.0312 16.668 13.078L20.668 16.641C20.7401 16.705 20.8291 16.7468 20.9244 16.7614C21.0196 16.776 21.1171 16.7627 21.205 16.7232C21.2929 16.6837 21.3675 16.6196 21.4199 16.5386C21.4722 16.4577 21.5 16.3634 21.5 16.267V7.365C21.5 7.26862 21.4722 7.17429 21.4199 7.09335C21.3675 7.01242 21.2929 6.94834 21.205 6.90882C21.1171 6.86931 21.0196 6.85604 20.9244 6.87062C20.8291 6.8852 20.7401 6.927 20.668 6.991Z" stroke="#202020" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				</svg>
				<svg onclick="return videoCall('.$rec_id.',true,\''.addslashes($rec->name ?? '').'\');"  xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
					<path d="M20.45 21C18.3667 21 16.3083 20.546 14.275 19.638C12.2417 18.73 10.3917 17.4423 8.725 15.775C7.05833 14.1077 5.771 12.2577 4.863 10.225C3.955 8.19233 3.50067 6.134 3.5 4.05C3.5 3.75 3.6 3.5 3.8 3.3C4 3.1 4.25 3 4.55 3H8.6C8.83333 3 9.04167 3.07933 9.225 3.238C9.40833 3.39667 9.51667 3.584 9.55 3.8L10.2 7.3C10.2333 7.56667 10.225 7.79167 10.175 7.975C10.125 8.15833 10.0333 8.31667 9.9 8.45L7.475 10.9C7.80833 11.5167 8.204 12.1123 8.662 12.687C9.12 13.2617 9.62433 13.816 10.175 14.35C10.6917 14.8667 11.2333 15.346 11.8 15.788C12.3667 16.23 12.9667 16.634 13.6 17L15.95 14.65C16.1 14.5 16.296 14.3877 16.538 14.313C16.78 14.2383 17.0173 14.2173 17.25 14.25L20.7 14.95C20.9333 15.0167 21.125 15.1377 21.275 15.313C21.425 15.4883 21.5 15.684 21.5 15.9V19.95C21.5 20.25 21.4 20.5 21.2 20.7C21 20.9 20.75 21 20.45 21ZM6.525 9L8.175 7.35L7.75 5H5.525C5.60833 5.68333 5.725 6.35833 5.875 7.025C6.025 7.69167 6.24167 8.35 6.525 9ZM15.475 17.95C16.125 18.2333 16.7877 18.4583 17.463 18.625C18.1383 18.7917 18.8173 18.9 19.5 18.95V16.75L17.15 16.275L15.475 17.95Z" fill="#202020"/>
				</svg>';
	$input='
	<div class="typemsgDiv">
                            <div class="type-msg justify-content-between">
                                <div class="d-flex col-md-11 gap-2">
                                    
                                    <div class="dropdown">
                                        <span data-bs-toggle="dropdown" aria-expanded="false" class="">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                                                <rect x="0.5" y="0.5" width="35" height="35" rx="17.5" fill="#F1F8FF"></rect>
                                                <path d="M25 19H19V25H17V19H11V17H17V11H19V17H25V19Z" fill="#202020"></path>
                                            </svg>
                                        </span>
                                        <ul class="dropdown-menu" style="">
                                          <li><a class="dropdown-item" onclick="sendContactAndResume(\'Please send your contact number.\')">Request Contact</a></li>
                                          <li><a class="dropdown-item" onclick="sendContactAndResume(\'' .$profile['emp_resume']. '\')">Send Resume</a></li>

                                          <li><a class="dropdown-item" onclick="sendContactAndResume('.$profile['emp_contact'].')">Send Contact</a></li>
                                        </ul>
                                    </div>

                                    <input id="message" class="border-0 p-0 w-100" type="text" placeholder="Type a Message">
                                </div>
                                <div>
                                   
                                </div>
                            </div>
                        </div>
	
	';
}
$checkmsg = $this->db->get_where('chatbox_msg', ['ee_id' => $this->user_id,'rec_id'=>$rec_id,'sender_type'=>'employee'])->num_rows();
if($checkmsg==0){
$input='<button onclick="sendFirstMsg(\'Hello sir, I am interested in your Job Post.\')" class="btn btn-info">Hello sir, I am intrested in your Job Post.</button>
<input type="hidden" id="message">
';
}

		$final='
		<div class="row">
<div class="col-md-9 px-0 borderRight chatlist">
	<div class="mainchatscreen">
		<div class="chat-header d-flex justify-content-between">
			<div class="d-flex gap-2">
				<img src="'.$profile['image'].'" alt="" 
				style="width:2rem;height: 2rem;border-radius: 100px;">
				<div>
					<h6 class="mb-0 small">'.$profile['name'].'</h6>
					<p class="mb-0 small" style="color: #1DAC00;">Active</p>
				</div>
			</div>
			<div class="d-flex gap-3 my-auto">
				'.$call.'
			</div>
		</div>
		<div class="chatMessage pt-5 px-3" id="chatMessage">
			<!--<div style="color: rgba(32, 32, 32, 0.80);" class="small text-center mb-3">Today</div>-->
			'.$chat.'
		</div>
		'.$input.'
</div>
</div>
<div class="col-md-3 px-0">
	<div class="user-details">
		<div class="user-details-top">
			<h5 class="my-auto fw-normal text-center">Details</h5>
		</div>
		<div class="py-4 px-3">
			<div class="text-center">
				<img src="'.$profile['image'].'" alt="" class="userImg mb-3">
				<h6 class="">'.$profile['recruiter_name'].'</h6>
				<h6 class="fw-normal small">'.$profile['recruiter_designation'].' @'.$profile['name'].'</h6>
			</div>
			<!--<div class="emp-position text-center mt-3">
				<p class="mb-0" style="font-size: 0.7rem">Hiring For: <span style="font-weight: 500;">
					UX Designer
				</span></p>
				<p class="mb-0" style="color: #1DAC00;font-size: 0.6rem;">Applied</p>
			</div>
			<div class="d-flex justify-content-between my-3">
				<span style="font-size: 0.8rem;">Options</span>
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
					<g clip-path="url(#clip0_1798_4378)">
					  <path fill-rule="evenodd" clip-rule="evenodd" d="M11.4636 15.7064C11.6511 15.8938 11.9054 15.9992 12.1706 15.9992C12.4357 15.9992 12.69 15.8938 12.8776 15.7064L18.5346 10.0494C18.6301 9.95712 18.7062 9.84678 18.7587 9.72477C18.8111 9.60277 18.8387 9.47155 18.8398 9.33877C18.841 9.20599 18.8157 9.07431 18.7654 8.95141C18.7151 8.82852 18.6408 8.71686 18.547 8.62297C18.4531 8.52908 18.3414 8.45483 18.2185 8.40454C18.0956 8.35426 17.9639 8.32896 17.8312 8.33012C17.6984 8.33127 17.5672 8.35886 17.4452 8.41126C17.3231 8.46367 17.2128 8.53986 17.1206 8.63537L12.1706 13.5854L7.22055 8.63537C7.03195 8.45321 6.77935 8.35241 6.51715 8.35469C6.25496 8.35697 6.00414 8.46214 5.81874 8.64755C5.63333 8.83296 5.52816 9.08377 5.52588 9.34597C5.5236 9.60816 5.6244 9.86076 5.80655 10.0494L11.4636 15.7064Z" fill="#202020" fill-opacity="0.8"/>
					</g>
					<defs>
					  <clipPath id="clip0_1798_4378">
						<rect width="24" height="24" fill="white" transform="matrix(-1 0 0 1 24.1699 0)"/>
					  </clipPath>
					</defs>
				</svg>
			</div>
			<div class="border p-1 rounded-3">
				<div class="d-flex justify-content-between">
					<span class="my-auto" style="font-size: 0.7rem;">Shared Media</span>
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
						<g clip-path="url(#clip0_1798_4351)">
						  <path fill-rule="evenodd" clip-rule="evenodd" d="M11.4636 8.29363C11.6511 8.10616 11.9054 8.00085 12.1706 8.00085C12.4357 8.00085 12.69 8.10616 12.8776 8.29363L18.5346 13.9506C18.6301 14.0429 18.7062 14.1532 18.7587 14.2752C18.8111 14.3972 18.8387 14.5285 18.8398 14.6612C18.841 14.794 18.8157 14.9257 18.7654 15.0486C18.7151 15.1715 18.6408 15.2831 18.547 15.377C18.4531 15.4709 18.3414 15.5452 18.2185 15.5955C18.0956 15.6457 17.9639 15.671 17.8312 15.6699C17.6984 15.6687 17.5672 15.6411 17.4452 15.5887C17.3231 15.5363 17.2128 15.4601 17.1206 15.3646L12.1706 10.4146L7.22055 15.3646C7.03195 15.5468 6.77935 15.6476 6.51715 15.6453C6.25496 15.643 6.00414 15.5379 5.81874 15.3525C5.63333 15.167 5.52816 14.9162 5.52588 14.654C5.5236 14.3918 5.6244 14.1392 5.80655 13.9506L11.4636 8.29363Z" fill="#202020"/>
						</g>
						<defs>
						  <clipPath id="clip0_1798_4351">
							<rect width="24" height="24" fill="white" transform="matrix(-1 0 0 1 24.1699 0)"/>
						  </clipPath>
						</defs>
					</svg>
				</div>
				<div class="d-flex gap-3">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 31 30" fill="none">
						<path d="M15.0889 14.3789C15.0684 14.3408 15.0479 14.3232 15.0244 14.3203C14.9395 14.417 14.96 15.2432 15.1035 15.8262C15.2207 15.4277 15.2412 14.6396 15.0889 14.3789ZM15.042 17.9092C14.8164 18.4951 14.4912 19.2949 14.1016 20.001C14.2188 19.9541 14.3389 19.9043 14.4619 19.8545C14.9775 19.6436 15.5547 19.4063 16.1875 19.2627C15.751 18.917 15.3555 18.4512 15.042 17.9092Z" fill="#E9F3FF"/>
						<path d="M15.8145 10.3125V3.98438H6.9668V26.0156H23.373V11.543H17.0449C16.7186 11.543 16.4056 11.4133 16.1748 11.1826C15.9441 10.9518 15.8145 10.6388 15.8145 10.3125ZM17.4258 18.7383C17.8975 18.6826 18.3223 18.6562 18.7236 18.6709C19.0986 18.6826 19.415 18.7295 19.6611 18.8203C19.667 18.8232 19.6699 18.8232 19.6758 18.8262C19.6875 18.832 19.6992 18.835 19.7109 18.8408C19.7256 18.8467 19.7432 18.8525 19.7578 18.8613C19.7607 18.8643 19.7666 18.8643 19.7695 18.8672C19.8896 18.9199 19.9893 18.9844 20.0654 19.0605C20.332 19.3271 20.4111 19.8252 20.2471 20.2207C20.1533 20.4463 19.9043 20.8213 19.2715 20.8213C18.6328 20.8213 17.6924 20.5371 16.8662 20.0947C16.1191 20.2207 15.293 20.502 14.4961 20.7715C14.3262 20.8301 14.1504 20.8887 13.9805 20.9443C12.8672 22.8545 12.0322 23.2705 11.5166 23.2705C11.3936 23.2705 11.2881 23.2441 11.2002 23.2119C10.998 23.1357 10.8252 22.9775 10.7168 22.7725C10.6904 22.7227 10.6699 22.6729 10.6523 22.6201C10.6055 22.4795 10.5908 22.3389 10.6143 22.2217L10.6318 22.1426C10.6348 22.1367 10.6348 22.1309 10.6377 22.125C10.6436 22.1045 10.6494 22.084 10.6582 22.0635C10.6582 22.0605 10.6611 22.0576 10.6611 22.0547C10.7813 21.7061 11.0596 21.3691 11.4727 21.041C11.833 20.7539 12.2666 20.4932 12.8174 20.209C13.2832 19.3887 13.9189 18.0088 14.3174 17.0625C14.001 15.8379 13.8281 14.877 14.0215 14.1738C14.0479 14.0771 14.0947 13.9863 14.1562 13.9072C14.1621 13.9014 14.165 13.8955 14.1709 13.8896C14.1738 13.8867 14.1738 13.8838 14.1768 13.8838C14.3613 13.6641 14.6719 13.5352 15 13.5469C15.4863 13.5674 15.8701 13.8838 15.9668 14.4287C16.0166 14.6631 16.0312 14.9121 16.0225 15.1816V15.2021C16.0225 15.2168 16.0225 15.2314 16.0195 15.2461C15.999 15.6357 15.9316 16.0254 15.8057 16.5557C15.7939 16.6025 15.7822 16.6494 15.7705 16.708L15.7412 16.8281L15.7383 16.8369C15.7412 16.8428 15.7412 16.8457 15.7441 16.8516L15.7969 16.9834C15.7998 16.9922 15.8057 17.0039 15.8086 17.0127C15.8291 17.0596 15.8496 17.1094 15.8701 17.1533V17.1562C16.125 17.707 16.4473 18.1348 16.8633 18.4775C16.9893 18.5801 17.124 18.6738 17.2705 18.7646C17.3232 18.75 17.373 18.7441 17.4258 18.7383Z" fill="#E9F3FF"/>
						<path d="M11.6406 22.2947C11.8076 22.1658 12.1152 21.8699 12.5225 21.2781C12.2207 21.5535 11.8369 21.9343 11.6406 22.2947ZM19.5771 19.863L19.583 19.8542H19.5889C19.6064 19.8425 19.6035 19.8337 19.6006 19.8279C19.5977 19.825 19.4687 19.5554 18.2793 19.6111C19.3135 20.0183 19.5537 19.8777 19.5771 19.863Z" fill="#E9F3FF"/>
						<path d="M25.207 8.45508L18.9023 2.15039C18.7266 1.97461 18.4893 1.875 18.2402 1.875H5.79492C5.27637 1.875 4.85742 2.29395 4.85742 2.8125V27.1875C4.85742 27.7061 5.27637 28.125 5.79492 28.125H24.5449C25.0635 28.125 25.4824 27.7061 25.4824 27.1875V9.12012C25.4824 8.87109 25.3828 8.63086 25.207 8.45508ZM17.8066 4.03711L23.3203 9.55078H17.8066V4.03711ZM23.373 26.0156H6.9668V3.98438H15.8145V10.3125C15.8145 10.6388 15.9441 10.9518 16.1748 11.1826C16.4056 11.4133 16.7186 11.543 17.0449 11.543H23.373V26.0156Z" fill="#202020" fill-opacity="0.8"/>
						<path d="M15.8694 17.1476C15.8459 17.0978 15.8254 17.0509 15.8049 17.004C15.802 16.9952 15.7961 16.9835 15.7932 16.9747L15.7405 16.8429C15.7375 16.837 15.7375 16.8341 15.7346 16.8283L15.7375 16.8195L15.7434 16.7872C15.8606 16.3097 15.9953 15.7531 16.0188 15.1935V15.173C16.0276 14.921 16.0129 14.6691 15.9602 14.423C15.8489 13.799 15.3889 13.5558 14.9963 13.5382C14.6653 13.5236 14.3576 13.6554 14.1731 13.8722C14.1701 13.8751 14.1701 13.8781 14.1672 13.8781C14.1614 13.8839 14.1555 13.8898 14.1526 13.8956C14.091 13.9747 14.0442 14.0656 14.0178 14.1622C13.8244 14.8654 13.9973 15.8263 14.3137 17.0509C13.9153 18.0001 13.2795 19.3771 12.8137 20.1974V20.2003C12.0022 20.6193 10.9358 21.2492 10.6574 22.0431C10.6574 22.046 10.6545 22.049 10.6545 22.0519C10.6487 22.0724 10.6399 22.0929 10.634 22.1134C10.6311 22.1193 10.6311 22.1251 10.6281 22.131C10.6223 22.1574 10.6135 22.1837 10.6106 22.2101C10.5842 22.3273 10.5989 22.4679 10.6487 22.6085C10.6662 22.6613 10.6867 22.7111 10.7131 22.7609C10.8215 22.966 10.9944 23.1242 11.1965 23.2003C11.2844 23.2326 11.3899 23.2589 11.5129 23.2589C12.0285 23.2589 12.8635 22.8429 13.9768 20.9327C14.1467 20.8771 14.3225 20.8185 14.4924 20.7599C15.2893 20.4904 16.1155 20.2091 16.8625 20.0831C17.6887 20.5255 18.6291 20.8097 19.2678 20.8097C19.9006 20.8097 20.1496 20.4347 20.2434 20.2091C20.4074 19.8136 20.3283 19.3156 20.0617 19.049C19.9856 18.9728 19.886 18.9083 19.7658 18.8556C19.7629 18.8527 19.7571 18.8527 19.7541 18.8497C19.7395 18.8439 19.7219 18.838 19.7073 18.8292C19.6955 18.8234 19.6838 18.8204 19.6721 18.8146C19.6662 18.8117 19.6633 18.8117 19.6574 18.8087C19.1828 18.6388 18.4358 18.6124 17.4221 18.7267L17.2668 18.7443C17.1203 18.6564 16.9856 18.5597 16.8596 18.4572C16.4436 18.1261 16.1242 17.7013 15.8694 17.1476ZM11.6389 22.2951C11.8352 21.9347 12.219 21.5538 12.5207 21.2785C12.1135 21.8702 11.8059 22.1661 11.6389 22.2951ZM15.0227 14.3204C15.0461 14.3234 15.0666 14.3409 15.0871 14.379C15.2395 14.6398 15.219 15.4279 15.1018 15.8263C14.9582 15.2433 14.9377 14.4171 15.0227 14.3204ZM14.4602 19.8546C14.3371 19.9044 14.217 19.9542 14.0998 20.0011C14.4895 19.2951 14.8147 18.4952 15.0403 17.9093C15.3537 18.4513 15.7492 18.9171 16.1858 19.2628C15.553 19.4064 14.9758 19.6437 14.4602 19.8546ZM19.5989 19.8283C19.6018 19.8341 19.6047 19.8429 19.5871 19.8546H19.5813L19.5754 19.8634C19.552 19.8781 19.3117 20.0187 18.2776 19.6115C19.467 19.5558 19.5959 19.8253 19.5989 19.8283Z" fill="#202020" fill-opacity="0.8"/>
					</svg>
					<span style="font-size: 0.8rem;">resume.pdf</span>
				</div>
			</div>
			<div class="d-flex justify-content-between my-3">
				<span style="font-size: 0.8rem;">Scheduled Interview</span>
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
					<g clip-path="url(#clip0_1798_4378)">
					  <path fill-rule="evenodd" clip-rule="evenodd" d="M11.4636 15.7064C11.6511 15.8938 11.9054 15.9992 12.1706 15.9992C12.4357 15.9992 12.69 15.8938 12.8776 15.7064L18.5346 10.0494C18.6301 9.95712 18.7062 9.84678 18.7587 9.72477C18.8111 9.60277 18.8387 9.47155 18.8398 9.33877C18.841 9.20599 18.8157 9.07431 18.7654 8.95141C18.7151 8.82852 18.6408 8.71686 18.547 8.62297C18.4531 8.52908 18.3414 8.45483 18.2185 8.40454C18.0956 8.35426 17.9639 8.32896 17.8312 8.33012C17.6984 8.33127 17.5672 8.35886 17.4452 8.41126C17.3231 8.46367 17.2128 8.53986 17.1206 8.63537L12.1706 13.5854L7.22055 8.63537C7.03195 8.45321 6.77935 8.35241 6.51715 8.35469C6.25496 8.35697 6.00414 8.46214 5.81874 8.64755C5.63333 8.83296 5.52816 9.08377 5.52588 9.34597C5.5236 9.60816 5.6244 9.86076 5.80655 10.0494L11.4636 15.7064Z" fill="#202020" fill-opacity="0.8"></path>
					</g>
					<defs>
					  <clipPath id="clip0_1798_4378">
						<rect width="24" height="24" fill="white" transform="matrix(-1 0 0 1 24.1699 0)"></rect>
					  </clipPath>
					</defs>
				</svg>
			</div>-->
		</div>
	</div>
</div>
</div>

		';
		return $final;
	}
	 
    public function profile() {
		$this->check_user_completion('career');
		$this->check_user_completion('profile');
		$data['title']='My Profile'; 
		$data['degree'] = $this->getJobTitles('qualification');
		$data['location_type'] = $this->getJobTitles('employement_type');
		$data['employment_type'] = $this->getJobTitles('job_type');
		$data['exp'] = $this->common_model->getWorkExperience($this->user_id);
		$data['education'] = $this->common_model->getEducations($this->user_id);
		$data['portfolio'] = $this->common_model->getPortfolio($this->user_id);
		$data['saved'] = $this->common_model->getSavedJobCount($this->user_id);
		$data['applied'] = $this->common_model->getAppliedJobCount($this->user_id);
		$data['shortlisted'] = $this->common_model->getShortlistedCount($this->user_id);
		$data['profile_view'] = $this->db->where('emp_id',$this->user_id)->get('rec_view_emp')->num_rows();
		$profile = $this->db->where('id', $this->user_id)->get('employee')->row();
		$profile->profile_pic=base_url('profile_pic/' . (!empty($profile->profile_pic) ? $profile->profile_pic : 'user.png'));
		$profile->resume= (!empty($profile->resume) ? base_url('canidate_documents/resume/' .$profile->resume ) : '');
		$data['profile'] = $profile;
		
		$career = $this->db->from('career_preferences')->where('created_by', $this->user_id)->get()->row();
		if(!empty($career)){
			$career->resume= (!empty($career->resume) ? base_url('canidate_documents/resume/' .$career->resume ) : '');
			if($career->t_exp_type=='fresher'){
				 $exp='Fresher';
			}else{
				$exp=$career->t_exp_yr.'y '.$career->t_exp_month.'m Exp';
			}
			$career->experience=$exp;
		}
		$data['career'] = $career;

		$this->load->view('profile',$data);		
    }
	
    public function lookBack() {
		$this->check_user_completion('career');
		$this->check_user_completion('profile');
		$data['title']='Lookback';
		$data['data'] = $this->common_model->getLookbackJob($this->user_id);
		$data['saved'] = $this->common_model->getSavedJobCount($this->user_id);
		$data['lookback'] = $this->common_model->getLookbackJobCount($this->user_id);
		$data['applied'] = $this->common_model->getAppliedJobCount($this->user_id);
		
		$this->load->view('lookback',$data);		
    }
	
    public function careerPreference() {
		$data['title']='Career Preference';
		$data['qualification'] = $this->getJobTitles('qualification');
		$data['employement_type'] = $this->getJobTitles('employement_type');
		$data['job_type'] = $this->getJobTitles('job_type');
		$data['shift'] = $this->getJobTitles('shift');
		$data['communication'] = $this->getJobTitles('communication');
		$data['tag'] = $this->getJobTitles('employee_tag');
		$data['salary_type'] = $this->getJobTitles('salary_type');
		$data['data'] = $this->common_model->getLookbackJob($this->user_id);
		$data['states'] =$this->db->get('state')->result();
		$data['career'] = $this->db->from('career_preferences')->where('created_by', $this->user_id)->get()->row();
		$this->load->view('careerPreference',$data);		
    }
	
    public function appliedJob() {
		$this->check_user_completion('career');
			$this->check_user_completion('profile');
		$data['title']='Applied Job';
		$data['data'] = $this->common_model->getAppliedJob($this->user_id);
		$data['saved'] = $this->common_model->getSavedJobCount($this->user_id);
		$data['lookback'] = $this->common_model->getLookbackJobCount($this->user_id);
		$data['applied'] = $this->common_model->getAppliedJobCount($this->user_id);
		$this->load->view('appliedJob',$data);		
    }
	
    public function savedJob() {
		$this->check_user_completion('career');
			$this->check_user_completion('profile');
		$data['title']='Saved Job';
		$data['data'] = $this->common_model->getSavedJob($this->user_id);
		$data['saved'] = $this->common_model->getSavedJobCount($this->user_id);
		$data['lookback'] = $this->common_model->getLookbackJobCount($this->user_id);
		$data['applied'] = $this->common_model->getAppliedJobCount($this->user_id);
		$this->load->view('savedJob',$data);		
    }
	
	 public function isEdit() {
		$table=$this->input->post('table');
		$where_column=$this->input->post('where_column');
		$where_value=$this->input->post('where_value');
		
		$data = $this->db->where($where_column, $where_value)->get($table)->row();
		if($data){
			echo json_encode($data);
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Data not found']);die();
		}
    }
	public function delete_parmanently() {
		$table=$this->input->post('table');
		$where_column=$this->input->post('where_column');
		$where_value=$this->input->post('where_value');
		
		$data = $this->db->where($where_column, $where_value)->delete($table);
		if($this->db->affected_rows() > 0){
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>'Data deleted successfully']);die();
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Data not delete, please try again']);die();
		}
    }
	
	private function getJobTitles($type){
		return  $this->db->where('category', $type)->get('post_job_titles')->result();
	}
	
	public function submitWorkExperience()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'company_name', 'label' => 'Company Name', 'rules' => 'required'],
			['field' => 'job_title', 'label' => 'Job Title', 'rules' => 'required'],
			['field' => 'start_date', 'label' => 'Start Date', 'rules' => 'required'],
			['field' => 'is_current', 'label' => 'Is Current', 'rules' => ''],
			['field' => 'employment_type', 'label' => 'Employment type', 'rules' => 'required'],
			['field' => 'location_type', 'label' => 'Location type', 'rules' => 'required'],
			['field' => 'location', 'label' => 'Location', 'rules' => ''],
			['field' => 'technologies', 'label' => 'Technologies', 'rules' => ''],
			['field' => 'description', 'label' => 'Description', 'rules' => '']
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}

		$data = [
			'emp_id' => $this->user_id,
			'company_name' => $input['company_name'],
			'job_title' => $input['job_title'],
			'start_date' => $input['start_date'],
			'end_date' => $input['end_date'] ?? null,
			'is_current' => $input['is_current'] ?? 0,
			'location' => $input['location'] ?? '',
			'employment_type' => $input['employment_type'] ?? '',
			'location_type' => $input['location_type'] ?? '',
			'technologies' => $input['technologies'] ?? '',
			'description' => $input['description'] ?? ''
		];

		if (empty($input['workid'])) {
			$res = $this->lib_model->Insert('work_experience', $data);
			if ($res) {
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Work experience added successfully"]);
			} else {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to add, please try again"]);
			}
		} else {
			$res = $this->lib_model->Update('work_experience', $data, ['id' => $input['workid']]);
			if ($res) {
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Work experience updated successfully"]);
			} else {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to update, please try again"]);
			}
		}
	}
		
	public function submitEducation()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'institution', 'label' => 'Institution Name', 'rules' => 'required'],
			['field' => 'degree', 'label' => 'Degree', 'rules' => 'required'],
			['field' => 'field_of_study', 'label' => 'field_of_study', 'rules' => ''],
			['field' => 'start_date', 'label' => 'Start Date', 'rules' => 'required'],
			['field' => 'is_current', 'label' => 'Is Current', 'rules' => ''],
			['field' => 'grade', 'label' => 'Grade', 'rules' => ''],
			['field' => 'activities', 'label' => 'Technologies', 'rules' => ''],
			['field' => 'description', 'label' => 'Description', 'rules' => '']
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}

		$data = [
			'emp_id' => $this->user_id,
			'institution' => $input['institution'],
			'degree' => $input['degree'],
			'field_of_study' => $input['field_of_study'] ?? '',
			'grade' => $input['grade'] ?? '',
			'start_date' => $input['start_date'],
			'end_date' => $input['end_date'] ?? null,
			'is_current' => $input['is_current'] ?? 0,
			'activities' => $input['activities'] ?? '',
			'description' => $input['description'] ?? ''
		];

		if (empty($input['eduid'])) {
			$res = $this->lib_model->Insert('education', $data);
			if ($res) {
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Education details added successfully"]);
			} else {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to add, please try again"]);
			}
		} else {
			$res = $this->lib_model->Update('education', $data, ['id' => $input['eduid']]);
			if ($res) {
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Education details updated successfully"]);
			} else {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to update, please try again"]);
			}
		}
	}
	
	public function update_skills()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'skills', 'label' => 'Skills', 'rules' => 'required'],
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		$data = [
			'skills' => $input['skills'] ?? '',
		];
	
		$res = $this->lib_model->Update('career_preferences', $data, ['created_by' => $this->user_id]);
		if ($res) {
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Skills updated successfully"]);
		} else {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to update, please try again"]);
		}
				
	}
	
	public function submit_work_portfolio()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'title', 'label' => 'Job Title', 'rules' => 'required'],
			['field' => 'url', 'label' => 'Related URL', 'rules' => ''],
			['field' => 'start_date', 'label' => 'Start Date', 'rules' => 'required'],
			['field' => 'end_date', 'label' => 'End Date', 'rules' => ''],
			['field' => 'is_current', 'label' => 'Is Current', 'rules' => ''],
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		
		if (empty($input['portid']) && empty($_FILES["image"]['name'])) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please select portfolio image']);die();
		}

	   if (empty($input['portid']) || !empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'uploads/work';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 5120;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$image = $upload_data['raw_name'] . '.webp'; 
					} else {
						$image = $file_name_c_logo;
					}
				} else {
					$image = $file_name_c_logo;
				}
				
			} else {
				$error = $this->upload->display_errors('', '');
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$error]);die();
			}
		}
		
		$data = [
			'emp_id' => $this->user_id,
			'title' => $input['title'],
			'url' => $input['url'],
			'description' => $input['description'],
			'start_date' => $input['start_date'],
			'end_date' => $input['end_date'] ?? null,
			'is_current' => $input['is_current'] ?? 0,
		];
		if(!empty($_FILES["image"]['name'])) {
			$data['image']=$image;
		}
		if (empty($input['portid'])) {
			
			$res = $this->lib_model->Insert('work_portfolio', $data);
			if ($res) {
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Portfolio added successfully"]);
			} else {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to add, please try again"]);
			}
		} else {
			$res = $this->lib_model->Update('work_portfolio', $data, ['id' => $input['portid']]);
			if ($res) {
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Portfolio updated successfully"]);
			} else {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to update, please try again"]);
			}
		}
	}
	
	public function update_profile()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'name', 'label' => 'Name', 'rules' => 'required'],
			['field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'],
			['field' => 'mobile', 'label' => 'Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'gender', 'label' => 'Gender', 'rules' => 'required'],
			['field' => 'headline', 'label' => 'Headline', 'rules' => 'required'],
			['field' => 'address', 'label' => 'address', 'rules' => 'required'],
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		$check=$this->db->where('id!=', $this->user_id)->where('c_contact', $input['mobile'])->get('employee')->num_rows();
		if($check>0){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'This mobile number is already registered with us.']);die();
		}
		$check=$this->db->where('id!=', $this->user_id)->where('c_email', $input['email'])->get('employee')->num_rows();
		if($check>0){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'This email is already registered with us.']);die();
		}
		$user=$this->db->where('id', $this->user_id)->get('employee')->row();
		if (empty($user->profile_pic) && empty($_FILES["image"]['name'])) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please select profile image']);die();
		}

	   if (!empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'profile_pic';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$image = $upload_data['raw_name'] . '.webp'; 
					} else {
						$image = $file_name_c_logo;
					}
				} else {
					$image = $file_name_c_logo;
				}
				
			} else {
				$error = $this->upload->display_errors('', '');
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$error]);die();
			}
		}
		
		
		$data = [
			'c_name' => $input['name'],
			'c_contact' => $input['mobile'],
			'c_email' => $input['email'],
			'bio' => $input['bio'],
			'dob' => $input['dob'],
			'gender' => $input['gender'],
			'headline' => $input['headline'],
			'address' => $input['address'],
			'portfolio_url' => $input['portfolio_url'],
			'linkedin' => $input['linkedin'],
		];
		if(!empty($_FILES["image"]['name'])) {
			$data['profile_pic']=$image;
		}
		
		
		$res = $this->lib_model->Update('employee', $data, ['id' => $this->user_id]);
		if ($res) {
			$this->lib_model->Update('career_preferences', ['gender'=>$input['gender']], ['created_by' => $this->user_id]);
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Profile updated successfully"]);
		} else {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to update, please try again"]);
		}
	}
	public function submit_career_preference()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			// ['field' => 'name', 'label' => 'Name', 'rules' => 'required'],
			// ['field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'],
			// ['field' => 'mobile', 'label' => 'Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			// ['field' => 'gender', 'label' => 'Gender', 'rules' => 'required'],
			['field' => 'state', 'label' => 'state', 'rules' => 'required'],
			['field' => 'city', 'label' => 'city', 'rules' => 'required'],
			['field' => 'role', 'label' => 'job role', 'rules' => 'required'],
			['field' => 'experience', 'label' => 'experience level', 'rules' => 'required'],
			['field' => 'skills', 'label' => 'skills', 'rules' => 'required'],
			['field' => 'employment_type', 'label' => 'employment type', 'rules' => 'required'],
			['field' => 'job_type', 'label' => 'job type', 'rules' => 'required'],
			['field' => 'shift', 'label' => 'Shift', 'rules' => 'required'],
			['field' => 'qualification', 'label' => 'qualification', 'rules' => 'required'],
			['field' => 'communication', 'label' => 'communication', 'rules' => 'required'],
			['field' => 'salary_type', 'label' => 'salary type', 'rules' => 'required'],
			['field' => 'min', 'label' => 'min salary', 'rules' => 'required'],
			['field' => 'max', 'label' => 'max salary', 'rules' => 'required'],
			// ['field' => 'objective', 'label' => 'objective', 'rules' => 'required'],
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		
		$user=$this->db->where('created_by', $this->user_id)->get('career_preferences')->row();
		if (empty($user->resume) && empty($_FILES["resume"]['name'])) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please upload resume']);die();
		}

	   if (!empty($_FILES["resume"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["resume"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'canidate_documents/resume';
			$config['allowed_types'] = 'pdf|doc|docx';
			$config['max_size'] = 10000;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('resume')) {
				$upload_data = $this->upload->data(); 
				$resume = $upload_data['file_name'];		
			} else {
				$error = $this->upload->display_errors('', '');
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$error]);die();
			}
		}
		
		$data = [
			'created_by' => $this->user_id,
			'p_job_roles' => $input['role'],
			'p_cities' => $input['city'],
			'p_state' => $input['state'],
			// 'contact' => $input['mobile'],
			// 'email' => $input['email'],
			// 'fullname' => $input['name'],
			// 'gender' => $input['gender'],
			// 'Objective' => $input['objective'],
			'eng'=>$input['communication'],
			'eTYpe'=>$input['employment_type'],
			'p_e_type'=>$input['job_type'],
			'p_shift'=>$input['shift'],
			't_exp_type'=>$input['experience'],
			't_exp_yr'=>$input['year'] ?? 0,
			't_exp_month'=>$input['month'] ?? 0,
			'qualification'=>$input['qualification'],
			'p_sal_Type' => $input['salary_type'],
			'p_sal_L' => $input['min'],
			'p_sal_T'=>$input['max'],
			'skills'=>$input['skills'],
			'tag'=>$input['tag'],
		];
	
		if(!empty($_FILES["resume"]['name'])) {
			$data['resume']=$resume;
		}
		$check=$this->db->where('created_by', $this->user_id)->get('career_preferences')->num_rows();
		if($check==0){
			$title='📄 Resume Uploaded';
			$body='Your resume has been successfully uploaded. Start applying to jobs now!';
			$this->common_model->saveNotification($this->user_id,$title,$body,'employee');
			$res = $this->lib_model->Insert('career_preferences', $data);
		}else{
			$res = $this->lib_model->Update('career_preferences', $data, ['created_by' => $this->user_id]);
		}
		
		if ($res) {
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'redirect','redirectLink'=>base_url('profile'),'msg'=>"Updated successfully"]);
		} else {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>"Failed to update, please try again"]);
		}
	}
	
	
	public function save_unsave_job()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'job_id', 'label' => 'job_id', 'rules' => 'required']
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		
		$check = $this->db->get_where('post_job', ['id' => $input['job_id']])->num_rows();
		if ($check==0) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Job not found with provided Job ID']);die();
		}
		$count = $this->lib_model->Counter('emp_save_job', [
			'emp_id' => $this->user_id,
			'job_id' => $input['job_id']
		]);

		if ($count === 0) {
			$this->lib_model->Insert('emp_save_job', [
				'emp_id' => $this->user_id,
				'job_id' => $input['job_id']
			]);
			echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Job saved successfully','text'=>'Saved']);
		} else {
			$this->lib_model->delete('emp_save_job', [
				'emp_id' => $this->user_id,
				'job_id' => $input['job_id']
			]);
			echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Removed from saved','text'=>'Save']);
		}
	}

	public function apply_job()
	{
		if (strtoupper($this->input->method()) != 'POST' && !$this->input->is_ajax_request()) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax request']);die();
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'job_id', 'label' => 'job_id', 'rules' => 'required']
		];

		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
		}
		
		
		$check = $this->db->get_where('post_job', ['id' => $input['job_id']])->num_rows();
		if ($check==0) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Job not found with provided Job ID']);die();
		}
		$count = $this->lib_model->Counter('applied_job_emp', [
			'emp_id' => $this->user_id,
			'job_id' => $input['job_id']
		]);

		if ($count == 0) {
			$job = $this->db->get_where('post_job', ['id' => $input['job_id']])->row();
			$this->lib_model->Insert('applied_job_emp', [
				'rec_id' => $job->created_by,
				'emp_id' => $this->user_id,
				'job_id' => $input['job_id']
			]);
			$title='✅ Application Submitted';
			$body='You’ve successfully applied for the job. We’ll notify you when the recruiter views it.';
			$this->common_model->saveNotification($this->user_id,$title,$body,'employee');
			$title='🧾 New Candidate Application';
			$body='A new candidate has applied to your job post. Review their profile now!';
			$this->common_model->saveNotification($job->created_by,$title,$body,'employer');
			echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Job applied successfully']);
		} else {
			echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Already applied']);
		}
	}
	
	public function user_list()
    {
        $postData = [
            'id'   => $this->user_id,
            'type' => 'employee'
        ];

        $api_url = base_url('api/employee/user-list');
        $response = call_api($api_url, $postData);

        echo json_encode($response);
    }
	
	public function getEmployerContact()
	{
		$rec_id = $this->input->post('rec_id');
		$contact = $this->lib_model->Select('employer', 'c_contact', ['id' => $rec_id]);
		echo !empty($contact) ? $contact[0]->c_contact : 'NA';
	}

	public function getChatStatus()
	{
		$rec_id = $this->input->post('rec_id');
		// $result =  $this->lib_model->Select('emp_block_recr', 'status_recr,status', array('rec_id'=> $rec_id , 'emp_id'=> $this->user_id ));
		$check=$this->db->get_where('emp_block_recr',['rec_id'=> $rec_id , 'emp_id'=> $this->user_id ]);
		if($check->num_rows()==0){
			$res=[
			'status'=>1,
			'msg'=>'Chat blocked'
			];
		}else{
			$result=$check->row();
			if($result->status==1 and $result->status_recr==1){
				$res=[
				'status'=>1,
				'msg'=>'Chat blocked by both side'
				];
			}elseif($result->status==1){
				$res=[
				'status'=>1,
				'msg'=>'Chat blocked by you'
				];
			}elseif($result->status_recr==1){
				$res=[
				'status'=>1,
				'msg'=>'Chat blocked by recruiter'
				];
			}else{
				$res=[
				'status'=>2,
				'msg'=>'Chat enable'
				];
			}
		}
		echo json_encode($res);
	}
	
	public function updateReqContact()
	{
		$emp_id = $this->input->post('emp_id');
		$rec_id = $this->input->post('rec_id');
		$status = $this->input->post('status');
		if($status==2){
			$msg='Accepted';
		}else{
			$msg='Rejected';
		}
					
		$ress=$this->lib_model->Update('chatbox_msg', ['req_contact'=>$status], ['rec_id'=>$rec_id,'ee_id'=>$emp_id,'req_contact'=>1]);
		if($ress){
			$res=[
			'status'=>'success',
			'msg'=>'Request '.$msg.' successfully'
			];
		}else{
			$res=[
			'status'=>'error',
			'msg'=>'Something went wrong please try again'
			];
		}
		echo json_encode($res);
	}
	
	public function update_msg_status()
    {
		$rec_id = $this->input->post('rec_id');
        $postData = [
            'emp_id'   => $this->user_id,
            'rec_id'   => $rec_id,
            'type' => 'employee'
        ];
        $api_url = base_url('api/employee/first-msg-status');
        $response = call_api($api_url, $postData);
        echo json_encode($response);
    }
	public function status_update() {
		$table=$this->input->post('table');
		$where_column=$this->input->post('where_column');
		$where_value=$this->input->post('where_value');
		$status=$this->input->post('status');
		$data = $this->lib_model->Update($table, ['status'=>$status],[$where_column=>$where_value]);	
		if($data){
			if($table=='applied_job_emp'){
				$job=$this->db->select('*')->from($table)->where('id', $where_value)->get()->row();
				
				if($status==3){
					$title='🗑️ Application Withdrawn';
					$body='You’ve successfully withdrawn your application. You can reapply anytime.';
					$this->common_model->saveNotification($job->emp_id,$title,$body,'employee');
				}
			}
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'reload','redirectLink'=>'','msg'=>'Status updated successfully']);die();
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Data not delete, please try again']);die();
		}
    }
	
	public function get_job_list()
	{
		$query = $_POST['query']; 
		$job_titles = $this->db->query("SELECT DISTINCT jTitle as title FROM post_job WHERE jTitle LIKE '%$query%'")->result_array();

		if (!empty($job_titles)) {
			echo json_encode(['status' => 'success', 'msg' => 'Data found', 'data' => $job_titles]);
		} else {
			echo json_encode(['status' => 'success', 'msg' => 'Data not found', 'data' => []]);
		}
	}

public function get_cities() {
		$id = $this->input->post('state_id');
        $cities=$this->db->where('state_id',$id)->get('city')->result();
        echo json_encode($cities);
    }
}
?>
