<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AuthController extends CI_Controller {

    public function __construct() {
        parent::__construct();
		$this->load->model('lib_model'); 
        $this->load->library('session');
        $this->load->helper('common');
        $this->load->helper('email');
    }

    public function sendOtp() {
        if (strtoupper($this->input->method()) == 'POST' && $this->input->is_ajax_request()) {

            $input = $this->input->post();
			$rules = [
				['field' => 'username', 'label' => 'Mobile or Email', 'rules' => 'required|trim'],
				['field' => 'type', 'label' => 'type', 'rules' => 'required|trim'],
			];
			$check=checkValidationWeb($input,$rules);
			if($check===true){
				$valid = $this->db->where('status', 0)->group_start()->where('c_email', $input['username'])->or_where('c_contact', $input['username'])->group_end()->get($input['type']);
				if($valid->num_rows()>0){
					$user=$valid->row();
					
					$username=$user->c_name;
					$template = $this->db->where(['status' => '0', 'type' => 'send_otp'])->get('sms_template')->row();
					if (!$template) {
						echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'SMS template not found']);die();
					}
					$otp = rand(10000, 99999);
					$name = str_replace(' ', '', $username) ?: 'User';
					
					$msg = str_replace(
						['mobile_number', 'user_name', 'otp_now'],
						[$user->c_contact, $name, $otp],
						$template->body
					);

					$db_data = [
						'phone' => $user->c_contact,
						'otp' => $otp,
						'user_id' => $name,
						'added_by_web' => $_SERVER['HTTP_HOST']
					];
					$this->lib_model->Insert('all_otp', $db_data);
					$result = send_text_msg_new(trim($msg));
					if (!$result) {
						echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Failed to send sms']);die();
					}
					echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'OTP sent successfully']);
				}else{
					echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid mobile /email ! User not found']);
				}
			}else{
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);
			}
		
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax format']);
		}
    }
	
	
	public function verify_otp()
	{
		if (strtoupper($this->input->method()) == 'POST' && $this->input->is_ajax_request()) {

            $input = $this->input->post();

		$rules = [
			['field' => 'otp', 'label' => 'OTP', 'rules' => 'required|trim|numeric|min_length[5]|max_length[5]'],
			['field' => 'username', 'label' => 'Mobile or Email', 'rules' => 'required|trim'],
			['field' => 'type', 'label' => 'type', 'rules' => 'required|trim'],
		];
		$check=checkValidationWeb($input, $rules);
		if($check!==true){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);
		}
		$valid = $this->db->where('status', 0)->group_start()->where('c_email', $input['username'])->or_where('c_contact', $input['username'])->group_end()->get($input['type']);
		if($valid->num_rows()==0){
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'User not found']);die();
		}
		$user=$valid->row();
		
		$otpDetails = $this->db->where('phone', $user->c_contact)->order_by('id','desc')->get('all_otp')->row();

		if (!$otpDetails) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please resend otp']);die();
		}
		if ($otpDetails->otp!=$input['otp']) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid OTP']);die();
		}
		$timeDifference = round((strtotime(date('Y-m-d H:i:s')) - strtotime($otpDetails->updated_at)) / 60); // difference in minutes
		if ($timeDifference >= 10) {
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'OTP expired']);die();
		}
		$this->session->set_userdata([
			'id'   => $user->id,
			'user_type' => $input['type'],
			'name'  => $user->c_name,
			'mobile'  => $user->c_contact,
			'is_logged_in' => TRUE
		]);
		echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Login successfully']);die();
		
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax format']);
		}
	}
	

    public function logout() {
        $this->session->sess_destroy();
        redirect('auth/login');
    }
}
?>
