<?php
defined('BASEPATH') or exit('No direct script access allowed');


class Auth_api extends CI_Controller {
    public function __construct()
	{
	    parent::__construct();
	    $this->load->model('lib_model');       
	    $this->load->helper('common');       
	    

	}

    
    public function get_auth()
    {
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: application/json; charset=UTF-8");
        $status='error';
        $message='Invalid Request';
        $statusCode=400;
        
        $data = json_decode($this->security->xss_clean(file_get_contents("php://input")));
        $auth  = $data->auth; 


        if($auth==1)
        {
            $sql =  "SELECT * FROM hiring_api_auth";
            $api_auth= $this->lib_model->Execute($sql, array())->row_array();   

            $response['username']=$api_auth['username'];
            $response['key']=$api_auth['password'];

            $status='success';
            $statusCode=200;
            $message='Data found';
        }
        else
        {
           $status='error';
           $statusCode=400;
           $message='You are not authorized to access application. please contact to support.';
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		
		$dataToEncrypt = json_encode($response);
        $encryptedData = bin2hex($dataToEncrypt);
        
        echo '"'.$encryptedData.'"';
  

    }
	
	public function get_auth_data()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$data = inputJSON();
		$auth  = $data['auth'] ?? null;

		if ($auth == 1) {
			$api_auth = $this->lib_model->Execute("SELECT username, password FROM hiring_api_auth")->row_array();

			if (!empty($api_auth)) {
				$response = [
					'username' => $api_auth['username'],
					'key' => $api_auth['password'],
				];
				$dataToEncrypt = json_encode($response);
				$encryptedData = bin2hex($dataToEncrypt);
				// $decryptedData = hex2bin($encryptedData);
				outputJSON(200, 'success', 'Data found', $encryptedData);
			} else {
				outputJSON(404, 'error', 'Data not found');
			}
		} else {
			outputJSON(400, 'error', 'You are not authorized to access the application. Please contact support.');
		}
	}


}