<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AuthController extends CI_Controller {

    public function __construct() {
        parent::__construct();
		$this->load->model('lib_model'); 
		$this->load->model('common_model'); 
        $this->load->library('session');
        $this->load->helper('common');
        $this->load->helper('email');
    }

    public function sendOtp() {
		
		// print_r($this->input->is_ajax_request());die();
        if (strtoupper($this->input->method()) == 'POST' && $this->input->is_ajax_request()) {

            $input = $this->input->post();
			$rules = [
				['field' => 'username', 'label' => 'Mobile or Email', 'rules' => 'required|trim'],
				['field' => 'type', 'label' => 'type', 'rules' => 'required|trim'],
			];
			$check=checkValidationWeb($input,$rules);
			if($check===true){
				$valid = $this->db->group_start()->where('c_email', $input['username'])->or_where('c_contact', $input['username'])->group_end()->get($input['type']);
				if($valid->num_rows()>0){
					$user=$valid->row();
					 if($user->status==1){
						 echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Account disabled, please contact admin or create new account.']);die();
					 }
					$username=$user->c_name ?? 'User';
					$template = $this->db->where(['status' => '0', 'type' => 'send_otp'])->get('sms_template')->row();
					if (!$template) {
						echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'SMS template not found']);die();
					}
					// $otp = rand(10000, 99999);
					$otp = 12345;
					$name = str_replace(' ', '', $username) ?: 'User';
					
					$msg = str_replace(
						['mobile_number', 'user_name', 'otp_now'],
						[$user->c_contact, $name, $otp],
						$template->body
					);

					$db_data = [
						'phone' => $user->c_contact,
						'otp' => $otp,
						'user_id' => $name,
						'added_by_web' => $_SERVER['HTTP_HOST']
					];
					$this->lib_model->Insert('all_otp', $db_data);
					// $result = send_text_msg_new(trim($msg));
					// if (!$result) {
						// echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Failed to send sms']);die();
					// }
				$this->db->update($input['type'], ['f_token_web' => $input['fcm_token']], ['id' => $user->id]);
					echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'OTP sent successfully','mobile'=>$user->c_contact,'type'=>$input['type']]);
				}else{
					if (preg_match('/^[0-9]{10}$/', $input['username'])) {
						$check = $this->db->where('c_contact', $input['username'])->get($input['type'])->num_rows();
						if($check>0){
							echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Mobile number already registered with us.']);die();
						}
						$submitData=[
							'c_contact'=>$input['username'],
							'f_token_web'=>$input['fcm_token'],
						];
						
						$res = $this->lib_model->Insert($input['type'], $submitData);
						if($res){
							$username='User';
							$template = $this->db->where(['status' => '0', 'type' => 'send_otp'])->get('sms_template')->row();
							if (!$template) {
								echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'SMS template not found']);die();
							}
							// $otp = rand(10000, 99999);
							$otp = 12345;
							$name = str_replace(' ', '', $username) ?: 'User';
							
							$msg = str_replace(
								['mobile_number', 'user_name', 'otp_now'],
								[$input['username'], $name, $otp],
								$template->body
							);

							$db_data = [
								'phone' => $input['username'],
								'otp' => $otp,
								'user_id' => $name,
								'added_by_web' => $_SERVER['HTTP_HOST']
							];
							$this->lib_model->Insert('all_otp', $db_data);
							// $result = send_text_msg_new(trim($msg));
							// if (!$result) {
								// echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Failed to send sms']);die();
							// }
							echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'OTP sent successfully','mobile'=>$input['username'],'type'=>$input['type']]);
						}else{
							echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please try after sometime, May be network issue.']);die();
						}
					}else{
						echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please use a valid mobile number to sign up.']);die();
					}
					
				}
			}else{
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);
			}
		
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax format']);
		}
    }
	
	
	public function verifyOtp()
	{
		if (strtoupper($this->input->method()) == 'POST' && $this->input->is_ajax_request()) {

            $input = $this->input->post();

			$rules = [
				['field' => 'username', 'label' => 'Mobile or Email', 'rules' => 'required|trim'],
				['field' => 'type', 'label' => 'type', 'rules' => 'required|trim'],
			];
			$check=checkValidationWeb($input, $rules);
			
			if($check!==true){
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>$check]);die();
			}
			$otpArray = $_POST['otp'];
			$otp = implode("", $otpArray);
			if(empty($otp)){
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'PLease enter OTP']);die();
			}
			$valid = $this->db->where('status', 0)->group_start()->where('c_email', $input['username'])->or_where('c_contact', $input['username'])->group_end()->get($input['type']);
			if($valid->num_rows()==0){
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'User not found']);die();
			}
			$user=$valid->row();
			
			$otpres = $this->db->where('phone', $user->c_contact)->order_by('id','desc')->get('all_otp');
			$otpDetails=$otpres->row();
			if (!$otpDetails) {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Please resend otp']);die();
			}
			if ($otpDetails->otp!=$otp) {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid OTP']);die();
			}
			$timeDifference = round((strtotime(date('Y-m-d H:i:s')) - strtotime($otpDetails->updated_at)) / 60); // difference in minutes
			if ($timeDifference >= 10) {
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'OTP expired']);die();
			}

			// $this->session->set_userdata([
				// 'id'   => $user->id,
				// 'user_type' => $input['type'],
				// 'name'  => $user->c_name,
				// 'email'  => $user->c_email,
				// 'mobile'  => $user->c_contact,
				// 'image'  => $profile,
				// 'is_logged_in' => TRUE
			// ]);
			
			$this->session->set_userdata($input['type'], [
				'id' => $user->id,
				'user_type' => $input['type'],
				'name' => $user->c_name,
				'email' => $user->c_email,
				'mobile' => $user->c_contact,
				'image' => 'user.png',
				'is_logged_in' => true
			]);
			$otpres = $this->db->where('phone', $user->c_contact)->order_by('id','desc')->get('all_otp');
			if($otpres->num_rows==1){
				$title='🎉 Welcome to JobKaro';
				$body='Thanks for joining! Complete your profile to get personalized job recommendations.';
				$this->common_model->saveNotification($user->id,$title,$body,$input['type']);
			}
			if($input['type']=='employee'){
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'redirect','redirectLink'=>base_url('profile'),'msg'=>'Login successfully']);die();
			}else{
				echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'redirect','redirectLink'=>base_url('employer/dashboard'),'msg'=>'Login successfully']);die();
			}
		}else{
			echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Invalid method or invalid ajax format']);
		}
	}
	

	public function logout() {
		$this->session->unset_userdata('employee'); 
		// $this->session->sess_destroy();
		redirect(base_url());
	}
	public function logout_rec() {
		$this->session->unset_userdata('employer'); 
		// $this->session->sess_destroy();
		redirect(base_url());
	}

}
?>
