<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AdminController extends CI_Controller {

    protected $allowed_urls = ['index', 'submit_login'];

    public function __construct() {
        parent::__construct();

        $this->load->helper(['url', 'new','common']);
        $this->load->library(['form_validation', 'session']);
        $this->load->model('lib_model');
        $this->load->model('common_model');

        $this->checkAuthentication();
    }
	public function getSegment($value){
		$this->load->helper('url');
		$segment = $this->uri->segment($value);
		return $segment;
	}
    private function checkAuthentication() {
        $current_method = $this->router->fetch_method();

        if (!in_array($current_method, $this->allowed_urls, true)) {
            if (!$this->session->userdata('admin_logged_in')) {
                redirect(base_url('admin/login'), 'refresh');
                exit;
            }
        }
    }

    public function index() {
        $this->load->view('admin/login');
    }

    public function submit_login() {
        $this->form_validation->set_rules('username', 'Username', 'required|trim');
        $this->form_validation->set_rules('password', 'Password', 'required|trim');

        if ($this->form_validation->run() === FALSE) {
            echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','isMsg'=>true,'msg'=>validation_errors()]);
			return;
        } else {
            $username = $this->input->post('username', true);
            $password = $this->input->post('password', true);
			$check=$this->db->where('c_email',$username)->get('admin_login');
			if($check->num_rows()==0){
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','isMsg'=>true,'msg'=>'Invalid username/email']);
				return;
			}
            $user=$check->row();
			if($user->c_pas!=$password){
				echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','isMsg'=>true,'msg'=>'Incorrect password.']);
				return;
			}
			$this->session->set_userdata([
				'admin_logged_in' => true,
				'id' => $user->id
			]);
			echo json_encode(['res'=>'success','isRedirect'=>true,'wayOfRedirect'=>'redirect','redirectLink'=>base_url('admin/dashboard'),'isMsg'=>true,'msg'=>'Login successfully.']);
            
        }
    }

    public function dashboard() {
		$data['title']='Dashboard';
        $this->load->view('admin/dashboard',$data);
    }
    public function manage_company() {
		$data['title']='Manage Company';
        $this->load->view('admin/manage_company',$data);
    }
	
	public function manage_industry() {
		$data['title']='Manage Industry';
        $this->load->view('admin/manage_industry',$data);
    }
	
	public function manage_employee() {
		$data['title']='Manage Employee';
        $this->load->view('admin/manage_employee',$data);
    }
	
	public function manage_job() {
		$data['title']='Manage Jobs';
        $this->load->view('admin/manage_job',$data);
    }
	
	public function manage_application() {
		$data['title']='Manage Application';
        $this->load->view('admin/manage_application',$data);
    }
	
	public function manage_notification() {
		$data['title']='Manage Notification';
        $this->load->view('admin/manage_notification',$data);
    }
	
	public function manage_admin_user() {
		$data['title']='Manage Admin Users';
        $this->load->view('admin/manage_admin_user',$data);
    }
	
	 public function dynamicTitles() {
		 if($this->getSegment(3))
		{
			$action=$this->getSegment(3);
			if($action=='Add' and strtoupper($this->input->method())=='POST' and $this->input->is_ajax_request())
			{
				$data=[
					'category' => $this->input->post('category'),
					'title'    => $this->input->post('title'),
					'value'    => $this->input->post('value'),
				];
				
				$res = $this->lib_model->Insert('post_job_titles', $data);
				if($res){
					echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'redirect','redirectLink'=>'','msg'=>'Data Added Successfully.']);
				}else{
					echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Something ! went wrong ! data not saved.']);
				}
			}
		}else{
			$data['title']='Dynamic Titles';
			$this->load->view('admin/dynamicTitles',$data);
		}
    }
	
	public function list_company()
	{
		header('Content-Type: application/json');

		$start = $this->input->post('start') ?? 0;
		$length = $this->input->post('length') ?? 10;
		$searchValue = $this->input->post('search')['value'] ?? '';

		$this->db->from('employer');

		$totalRecords = $this->db->count_all_results('', FALSE); 

		if (!empty($searchValue)) {
			$this->db->group_start();
			$this->db->like('c_name', $searchValue);
			$this->db->or_like('c_email', $searchValue);
			$this->db->or_like('comp_name', $searchValue);
			$this->db->or_like('c_contact', $searchValue);
			$this->db->group_end();
		}

		$filteredRecords = $this->db->count_all_results('', FALSE);

		$this->db->order_by('id', 'DESC');
		$this->db->limit($length, $start);

		$query = $this->db->get();
		$results = $query->result_array();

		$data = [];
		$serial = $start + 1;

		foreach ($results as $row) {
			$tempRow = [];

			$tempRow['id'] = $serial++;
			$tempRow['name'] = $row['c_name'];
			$tempRow['email'] = $row['c_email'];
			$tempRow['mobile'] = $row['c_contact'];
			$tempRow['created'] = date('d M, Y h:i A', strtotime($row['created_at']));

			// Status button
			if ($row['status'] == 1) {
				$tempRow['status'] = '<button class="btn btn-danger" onclick="UpdateStatus(\'employer\',\'status\',0,\'id\',' . $row['id'] . ',\'Active\')">Inactive</button>';
				
			} else {
				$tempRow['status'] = '<button class="btn btn-success" onclick="UpdateStatus(\'employer\',\'status\',1,\'id\',' . $row['id'] . ',\'Inactive\')">Active</button>';
				
			}

			$tempRow['action'] ='<a href="'.base_url('seller-products?id='.$row['id']).'" class="btn btn-warning text-white"><i class="fa fa-edit" title="View Products List"></i></a>
			<button class="btn btn-danger" onclick="Delete(\'id\',' . $row['id'] . ',\'employer\')"><i class="fa fa-trash"></i></button>
			';

			$data[] = $tempRow;
		}

		echo json_encode([
			"draw" => intval($this->input->post('draw')),
			"recordsTotal" => $totalRecords,
			"recordsFiltered" => $filteredRecords,
			"data" => $data
		]);
	}
	
	public function list_industry()
	{
		header('Content-Type: application/json');

		$start = $this->input->post('start') ?? 0;
		$length = $this->input->post('length') ?? 10;
		$searchValue = $this->input->post('search')['value'] ?? '';

		$this->db->from('post_job_titles');
		$this->db->where('category ', 'company_type');

		$totalRecords = $this->db->count_all_results('', FALSE); 

		if (!empty($searchValue)) {
			$this->db->group_start();
			$this->db->like('value', $searchValue);
			$this->db->or_like('title', $searchValue);
			$this->db->group_end();
		}

		$filteredRecords = $this->db->count_all_results('', FALSE);

		$this->db->order_by('id', 'DESC');
		$this->db->limit($length, $start);

		$query = $this->db->get();
		$results = $query->result_array();

		$data = [];
		$serial = $start + 1;

		foreach ($results as $row) {
			$tempRow = [];
			$this->db->from('employer');
			$this->db->join('about_com', 'about_com.created_by = employer.id');
			$this->db->where('about_com.com_type', $row['value']);

			$count = $this->db->count_all_results();

			$tempRow['id'] = $serial++;
			$tempRow['name'] = $row['title'];
			$tempRow['total'] = $count;

			$data[] = $tempRow;
		}

		echo json_encode([
			"draw" => intval($this->input->post('draw')),
			"recordsTotal" => $totalRecords,
			"recordsFiltered" => $filteredRecords,
			"data" => $data
		]);
	}
	
	
	public function list_employees()
	{
		header('Content-Type: application/json');
		$status = $this->input->post('status');
		$start = $this->input->post('start') ?? 0;
		$length = $this->input->post('length') ?? 10;
		$searchValue = $this->input->post('search')['value'] ?? '';
		$draw = $this->input->post('draw');

		$this->db->from('employee');
		if (isset($status) && $status !== '') {
			if ($status === 'New') {
				$this->db->where('DATE(created_at) = CURDATE()', null, false);
			} else {
				$this->db->where('status',$status);
			}
		}
		$totalRecords = $this->db->count_all_results('', FALSE); 

		if (!empty($searchValue)) {
			$this->db->group_start();
			$this->db->like('c_name', $searchValue);
			$this->db->or_like('c_email', $searchValue);
			$this->db->or_like('c_contact', $searchValue);
			$this->db->or_like('headline', $searchValue);
			$this->db->or_like('created_at', $searchValue);
			$this->db->group_end();
		}
		
		

		$filteredRecords = $this->db->count_all_results('', FALSE);

		$this->db->order_by('id', 'DESC');
		$this->db->limit($length, $start);

		$query = $this->db->get();
		$results = $query->result();

		$data = [];
		$serial = $start + 1;

		foreach ($results as $row) {
			$tempRow = [];
			

			$tempRow['id'] = $serial++;
			$tempRow['name'] = $row->c_name;
			$tempRow['email'] = $row->c_email;
			$tempRow['phone'] = $row->c_contact;
			$tempRow['headline'] = $row->headline;
			$tempRow['date'] = formatDate($row->created_at);
			$tempRow['action'] = '
			<button class="btn btn-success" data-bs-toggle="tooltip" data-bs-placement="top" title="View Employee Profile Details"><i class="fa fa-eye"></i></button>
			<button class="btn btn-danger" onclick="Delete(\'id\',' . $row->id . ',\'employee\')"><i class="fa fa-trash"></i></button>
			';

			$data[] = $tempRow;
		}

		echo json_encode([
			"draw" => intval($draw),
			"recordsTotal" => $totalRecords,
			"recordsFiltered" => $filteredRecords,
			"data" => $data
		]);
	}
	
	public function list_jobs()
{
    header('Content-Type: application/json');

    $status = $this->input->post('status');
    $start = $this->input->post('start') ?? 0;
    $length = $this->input->post('length') ?? 10;
    $searchValue = $this->input->post('search')['value'] ?? '';
    $draw = $this->input->post('draw');

    // Start query
	$this->db->select('pj.id, pj.jTitle, pj.created_at, pj.status,pj.adress,pj.emp_type,pj.jobtype,pj.shift,pj.experience,pj.quali, e.c_name, e.c_email, e.c_contact');
    $this->db->from('post_job pj');
    $this->db->join('employer e', 'pj.created_by = e.id', 'inner'); // ✅ inner join ensures only jobs with employer data

    // Filter by status
    if (isset($status) && $status !== '') {
        if ($status === 'New') {
            $this->db->where('DATE(pj.created_at) = CURDATE()', null, false);
        } else {
            $this->db->where('pj.status', $status);
        }
    }

    // Count total records
    $totalRecords = $this->db->count_all_results('', FALSE);

    // Search filter
    if (!empty($searchValue)) {
        $this->db->group_start();
        $this->db->like('pj.jTitle', $searchValue);
        $this->db->or_like('pj.created_at', $searchValue);
        $this->db->or_like('pj.shift', $searchValue);
        $this->db->or_like('pj.jobtype', $searchValue);
        $this->db->or_like('pj.adress', $searchValue);
        $this->db->or_like('e.c_name', $searchValue);
        $this->db->or_like('e.c_email', $searchValue);
        $this->db->or_like('e.c_contact', $searchValue);
        $this->db->group_end();
    }

    // Count filtered records
    $filteredRecords = $this->db->count_all_results('', FALSE);

    // Pagination and order
    $this->db->order_by('pj.id', 'DESC');
    $this->db->limit($length, $start);

    // Get data
    $query = $this->db->get();
    $results = $query->result();

    $data = [];
    $serial = $start + 1;

    foreach ($results as $row) {
        $tempRow = [];
        $tempRow['id'] = $serial++;
        $tempRow['title'] = $row->jTitle;
        $tempRow['company'] = $row->c_name;
        $tempRow['emp_type'] = $this->common_model->orignalName($row->emp_type);
        $tempRow['job_type'] = $this->common_model->orignalName($row->jobtype);
        $tempRow['shift'] = $this->common_model->orignalName($row->shift);
        $tempRow['experience'] = $this->common_model->orignalName($row->experience);
        $tempRow['qualification'] = $this->common_model->orignalName($row->quali);
        $tempRow['address'] = $row->adress;
        $tempRow['date'] = formatDate($row->created_at);
        $tempRow['action'] = '
            <button class="btn btn-success" data-bs-toggle="tooltip" data-bs-placement="top" title="View Employee Profile Details"><i class="fa fa-eye"></i></button>
            <button class="btn btn-danger" onclick="Delete(\'id\',' . $row->id . ',\'post_job\')"><i class="fa fa-trash"></i></button>
        ';

        $data[] = $tempRow;
    }

    echo json_encode([
        "draw" => intval($draw),
        "recordsTotal" => $totalRecords,
        "recordsFiltered" => $filteredRecords,
        "data" => $data
    ]);
}

	
	
	public function list_other_titles()
{
	header('Content-Type: application/json');

	$category = $this->input->get('category');
	$start = $this->input->post('start') ?? 0;
	$length = $this->input->post('length') ?? 10;
	$searchValue = $this->input->post('search')['value'] ?? '';
	$draw = $this->input->post('draw');

	// Total count
	$this->db->from('post_job_titles');
	$this->db->where('category', $category);
	$totalRecords = $this->db->count_all_results('', FALSE);

	// Search filters
	if (!empty($searchValue)) {
		$this->db->group_start();
		$this->db->like('title', $searchValue);
		$this->db->or_like('value', $searchValue);
		$this->db->group_end();
	}

	$filteredRecords = $this->db->count_all_results('', FALSE);

	// Get paginated data
	$this->db->order_by('id', 'DESC');
	$this->db->limit($length, $start);
	$query = $this->db->get();
	$results = $query->result();

	$data = [];
	$serial = $start + 1;

	foreach ($results as $row) {
		$data[] = [
			'id' => $serial++,
			'title' => $row->title,
			'value' => $row->value,
			'action' => '<button class="btn btn-danger btn-sm" onclick="Delete(\'id\',' . $row->id . ',\'post_job_titles\')"><i class="fa fa-trash"></i></button>'
		];
	}

	echo json_encode([
		"draw" => intval($draw),
		"recordsTotal" => $totalRecords,
		"recordsFiltered" => $filteredRecords,
		"data" => $data
	]);
}


	public function settings() {
		
		if($this->getSegment(3))
		{
			$action=$this->getSegment(3);
			if($action=='Add' and strtoupper($this->input->method())=='POST' and $this->input->is_ajax_request())
			{ 
				$data=[
					'privacy_policy' => $this->input->post('privacy_policy'),
					'terms_conditions'    => $this->input->post('terms_conditions')
				];
				
				$res = $this->lib_model->Update('settings', $data,['id'=>1]);
				if($res){
					echo json_encode(['res'=>'success','isRedirect'=>false,'wayOfRedirect'=>'redirect','redirectLink'=>'','msg'=>'Data Updated Successfully.']);
				}else{
					echo json_encode(['res'=>'error','isRedirect'=>false,'wayOfRedirect'=>'','redirectLink'=>'','msg'=>'Something ! went wrong ! data not saved.']);
				}
			}
		}else{
			$data['title']='Website Settings';
			$data['site']=$this->db->where('id',1)->get('settings')->row();
			$this->load->view('admin/settings',$data);
		}
    }
	

	public function update_site_status()
	{
		$type = $this->input->post('type');
		$status = $this->input->post('status');
		$this->db->where('id', '1')->update('settings', [$type => $status]);
		echo json_encode(['status' => 'success']);
	}


    public function logout() {
        $this->session->unset_userdata(['admin_logged_in', 'id']);
        $this->session->sess_destroy();
        redirect('admin/login');
    }
	public function update_status() {
		
		if ($this->input->method() == 'post' && $this->input->is_ajax_request()) {
			
			$submitData = $this->input->post();
			$table = $submitData['table'];
			$where_coloum = $submitData['where_coloum'];
			$coloum = $submitData['coloum'];
			$value = $submitData['value'];
			$where_id = $submitData['where_id'];
			
			$response = $this->lib_model->Update($table, [$coloum => $value], [$where_coloum => $where_id]);
			
			if ($response) {
				echo json_encode([
					'res' => 'success',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Status updated successfully'
				]);
			} else {
				echo json_encode([
					'res' => 'error',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Sorry! Please Try Again.'
				]);
			}
		} else {
			echo json_encode([
					'res' => 'error',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Request is not valid, Please Try Again.'
				]);
		}
	}

	public function DeleteParmanently() {
		if ($this->input->method() == 'post' && $this->input->is_ajax_request()) {
			$submitData = $this->input->post();
			$table = $submitData['table'];
			$where_column = $submitData['where_coloum'];
			$where_id = $submitData['where_id'];
			$response = $this->lib_model->delete($table, [$where_column => $where_id]);
			
			if ($response) {
				echo json_encode([
					'res' => 'success',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Data Deleted Successfully'
				]);
			} else {
				echo json_encode([
					'res' => 'error',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Sorry! Please Try Again.'
				]);
			}
		} else {
			echo json_encode([
					'res' => 'error',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Request is not valid, Please Try Again.'
				]);
		}
	}
	
	public function change_password() {
		if ($this->input->method() == 'post' && $this->input->is_ajax_request()) {
			$submitData = $this->input->post();
			$cpass = $submitData['old_password'];
			$npass = $submitData['new_password'];
			$cnpass = $submitData['confirm_password'];
			$user=$this->db->where('id',1)->get('admin_login')->row();
			if ($user->c_pas!=$cpass) {
				echo json_encode([
					'res' => 'error',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Incorrect current password.'
				]);die();
			}
			if ($npass!=$cnpass) {
				echo json_encode([
					'res' => 'error',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Password and confirm password not match.'
				]);die();
			}
			$response = $this->lib_model->Update('admin_login', ['c_pas' => $npass], ['id' => 1]);
			if($response){
				echo json_encode([
					'res' => 'success',
					'isRedirect' => true,
					'wayOfRedirect' => 'reload',
					'redirectLink' => '',
					'msg' => 'Password changed successfully'
				]);
			} else {
				echo json_encode([
					'res' => 'error',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Sorry! Please Try Again.'
				]);
			}
		} else {
			echo json_encode([
					'res' => 'error',
					'isRedirect' => false,
					'wayOfRedirect' => '',
					'redirectLink' => '',
					'msg' => 'Request is not valid, Please Try Again.'
				]);
		}
	}
}
