<?php
defined('BASEPATH') or exit('No direct script access allowed');


class Employer extends CI_Controller {
    public function __construct()
	{
	    parent::__construct();
	    $this->load->model('lib_model');  
	    $this->load->model('common_model');  
	    $this->load->helper('new');  
	    $this->load->helper('common');  
	    $this->load->helper('date');   
		
		$this->output
             ->set_content_type('application/json', 'utf-8')
             ->set_header('Access-Control-Allow-Origin: *')
             ->set_header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE')
             ->set_header('Access-Control-Allow-Headers: Content-Type, Authorization');
		
		$sql =  "SELECT * FROM hiring_api_auth";
		$api_auth= $this->lib_model->Execute($sql, array())->row_array();
		if(isset($_SERVER['PHP_AUTH_USER']) and isset($_SERVER['PHP_AUTH_PW'])){
			if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
			{
				outputJSON(400, 'error', 'Authentication failed');
				return;
			}
	    }else{
			outputJSON(400, 'error', 'Authentication Username and password not set');
			return;
		}

	}
	
	public function update_about_company()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required'],
			['field' => 'name', 'label' => 'Company Name', 'rules' => 'required'],
			['field' => 'email', 'label' => 'Company Email', 'rules' => 'required|trim|valid_email'],
			['field' => 'mobile', 'label' => 'Company Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'com_type', 'label' => 'Company type', 'rules' => 'required'],
			['field' => 'r_name', 'label' => 'Recruiter name', 'rules' => 'required'],
			['field' => 'r_mobile', 'label' => 'Recruiter mobile', 'rules' => 'required'],
			['field' => 'r_desig', 'label' => 'Recruiter Designation', 'rules' => 'required'],
			['field' => 'state', 'label' => 'state', 'rules' => 'required'],
			['field' => 'district', 'label' => 'district', 'rules' => 'required'],
			['field' => 'city', 'label' => 'city', 'rules' => 'required'],
			['field' => 'pincode', 'label' => 'pincode', 'rules' => 'required'],
			['field' => 'address', 'label' => 'address', 'rules' => 'required'],
			['field' => 'n_emp', 'label' => 'no of employee', 'rules' => 'required'],
			['field' => 'des', 'label' => 'company description', 'rules' => 'required'],
		];

		$check=checkValidation($input, $rules);
		$rec_id=$input['rec_id'];
		$check=$this->db->where('created_by', $rec_id)->get('about_com')->num_rows();
		$about=$this->db->where('created_by', $rec_id)->get('about_com')->row();
		if (empty($about->c_logo) && empty($_FILES["image"]['name'])) {
			outputJSON(400, 'error', 'Please select company logo.');
			return;
		} 
		$checkMobile=$this->db->where('id!=', $rec_id)->where('c_contact', $input['mobile'])->get('employer')->num_rows();
		if ($checkMobile>0) {
			outputJSON(409, 'error', 'Company number already registered with another account.');
			return;
		} 
	   if (!empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'jd/jdrec/documents';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$image = $upload_data['raw_name'] . '.webp'; 
					} else {
						$image = $file_name_c_logo;
					}
				} else {
					$image = $file_name_c_logo;
				}
				
			} else {
				outputJSON(413, 'error', $this->upload->display_errors('', ''));
				return;
			}
		}
		
	   if(!empty($_FILES["doc"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["doc"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'jd/jdrec/documents';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 10000;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('doc')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 
				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$doc = $upload_data['raw_name'] . '.webp'; 
					} else {
						$doc = $file_name_c_logo;
					}
				} else {
					$doc = $file_name_c_logo;
				}
			} else {
				outputJSON(413, 'error', $this->upload->display_errors('', ''));
				return;
			}
		}
		
		$data = [
			'created_by' => $rec_id,
			'name' => $input['name'],
			'number' => $input['mobile'],
			'email' => $input['email'],
			'com_type' => $input['com_type'],
			'r_name' => $input['r_name'],
			'r_mobile' => $input['r_mobile'],
			'r_desig' => $input['r_desig'],
			'adress' => $input['address'],
			'link' => $input['link'],
			'linkedin' => $input['linkedin'],
			'c_desc' => $input['des'],
			'c_gst' => $input['c_gst'],
			'n_emp' => $input['n_emp'],
			'doc_type' => $input['doc_type'],
			'state' => $input['state'],
			'District' => $input['district'],
			'city' => $input['city'],
			'zip' => $input['pincode'],
		];
		if(!empty($_FILES["image"]['name'])) {
			$data['c_logo']=$image;
		}
		if(!empty($_FILES["doc"]['name'])) {
			$data['documents']=$doc;
		}
		if($check==0){
			$res = $this->lib_model->Insert('about_com', $data);
			$cdata = [
				'comp_name' => $input['name'],
				'c_contact' => $input['mobile'],
				'c_name' => $input['name'],
				'c_email' => $input['email']
			];
			$this->lib_model->Update('employer', $cdata, ['id' => $rec_id]);
		}else{
			$res = $this->lib_model->Update('about_com', $data, ['created_by' => $rec_id]);
			$cdata = [
				'comp_name' => $input['name'],
				'c_contact' => $input['mobile'],
				'c_name' => $input['name'],
				'c_email' => $input['email']
			];
			$this->lib_model->Update('employer', $cdata, ['id' => $rec_id]);
		}
		
		if($res){
			outputJSON(200, 'success', 'Data updated successfully');
		}else{
			outputJSON(400, 'error', 'Failed to update, please try again');
		}
	}
	
	public function profile_details()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required'],
		];

		checkValidation($input, $rules);
		$rec_id=$input['rec_id'];
		$check = $this->db->get_where('about_com', ['created_by' => $rec_id])->num_rows();

		if ($check==0) {
			outputJSON(400, 'error', 'Invalid Recruiter ID or record not found.');
			return;
		}
		 
		$res = $this->db->get_where('about_com', ['created_by' => $rec_id])->row();
		$rec = $this->db->get_where('employer', ['id' => $rec_id])->row();
		$com_type=$this->common_model->orignalName($res->com_type);
		$data=[
			'id'=>$rec_id,
			'logo'=>base_url('jd/jdrec/documents/' . (!empty($res->c_logo) ? $res->c_logo : 'user.png')),
			'recruiter_image'=>base_url('profile_pic/user.png'),
			'recruiter_name'=>$res->r_name,
			'recruiter_mobile'=>$res->r_mobile,
			'recruiter_designation'=>$res->r_desig,
			'company_name'=>$res->name,
			'company_email'=>$res->email,
			'company_type'=>$com_type,
			'company_type_value'=>$res->com_type,
			'doc_type'=>$this->common_model->orignalName($res->doc_type),
			'doc_type_value'=>$res->doc_type,
			'address'=>$res->city,
			'zip'=>$res->zip,
			'about_company'=>$res->c_desc,
			'state_id'=>$res->state,
			'district_id'=>$res->District,
			'city_id'=>$res->city,
			'n_emp'=>$res->n_emp,
			'c_gst'=>$res->c_gst,
			'about_section'=>[
				'about_company'=>$res->c_desc,
				'website'=>$res->link,
				'linkedin'=>$res->linkedin,
				'contact'=>$rec->c_contact,
				'address'=>$res->adress,
				'no_of_emp'=>$res->n_emp.'+ Employees',
				'company_type'=>$com_type,
			],
			'jobs_section'=>$this->common_model->get_recruiter_job($status=0,$rec_id,5)
		];
		outputJSON(200, 'success', 'Record fetched successfully',$data);
		
				
	}
	
	public function submit_job()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

        $input = $this->input->post();

		$rules = [
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required'],
			['field' => 'title', 'label' => 'Job title', 'rules' => 'required'],
			['field' => 'opening', 'label' => 'no. of job opening', 'rules' => 'required'],
			['field' => 'skills', 'label' => 'skills', 'rules' => 'required'],
			['field' => 'employment_type', 'label' => 'employment type', 'rules' => 'required'],
			['field' => 'job_type', 'label' => 'job type', 'rules' => 'required'],
			['field' => 'shift', 'label' => 'Shift', 'rules' => 'required'],
			['field' => 'experience', 'label' => 'experience', 'rules' => 'required'],
			['field' => 'qualification', 'label' => 'qualification', 'rules' => 'required'],
			['field' => 'communication', 'label' => 'communication', 'rules' => 'required'],
			['field' => 'salary_type', 'label' => 'salary type', 'rules' => 'required'],
			['field' => 'min', 'label' => 'min salary', 'rules' => 'required'],
			['field' => 'max', 'label' => 'max salary', 'rules' => 'required'],
			['field' => 'from_day', 'label' => 'working day from', 'rules' => 'required'],
			['field' => 'to_day', 'label' => 'working day to', 'rules' => 'required'],
			['field' => 'des', 'label' => 'company description', 'rules' => 'required'],
			['field' => 'tag', 'label' => 'tag', 'rules' => 'required'],
		];

		checkValidation($input, $rules);
		$rec_id=$input['rec_id'];
	   if (!empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'jd/jdrec/jobimage';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$image = $upload_data['raw_name'] . '.webp'; 
					} else {
						$image = $file_name_c_logo;
					}
				} else {
					$image = $file_name_c_logo;
				}
				
			} else {
				outputJSON(413, 'error', $this->upload->display_errors('', ''));
				return;
			}
		}
		
		$about = $this->lib_model->Select('about_com', '*', ['created_by' => $rec_id ]);
		
		$state    = !empty($input['state'])    ? $input['state']    : $about[0]->state;
		$district = !empty($input['district']) ? $input['district'] : $about[0]->District;
		$city     = !empty($input['city'])     ? $input['city']     : $about[0]->city;
		$zip      = !empty($input['pincode'])  ? $input['pincode']  : $about[0]->zip;
		$address  = !empty($input['address'])  ? $input['address']  : $about[0]->adress;

		
		$data = [
			'created_by' => $rec_id,
			'jTitle' => $input['title'],
			'nOpen'=>$input['opening'],
			'state'=> $state ,
			'District'=> $district,
			'city' => $city,
			'zip'=> $zip,
			'adress'=> $address,
			'c_eng'=>$input['communication'],
			'emp_type'=>$input['employment_type'],
			'jobtype'=>$input['job_type'],
			'shift'=>$input['shift'],
			'experience'=>$input['experience'],
			'quali'=>$input['qualification'],
			'sType' => $input['salary_type'],
			'sMin' => $input['min'],
			'sMax'=>$input['max'],
			'jobDescription'=>$input['des'],
			'skills'=>$input['skills'],
			'dayFrom'=>$input['from_day'],
			'dayTo'=>$input['to_day'],
			'tag'=>$input['tag'],
			'gender'=>$input['gender'] ?? null,
		];
		if(!empty($_FILES["image"]['name'])) {
			$data['job_image']=$image;
		}
		if(empty($input['edit_id'])){
			$res=$this->lib_model->Insert('post_job', $data);
			if ($res) {
				outputJSON(200, 'success', 'Data added successfully');
			} else {
				outputJSON(400, 'error', 'Failed to add, please try again');
				return;
			}
		}else{
			$res=$this->lib_model->Update('post_job', $data,['id'=>$input['edit_id']]);
			if ($res) {
				outputJSON(200, 'success', 'Data updated successfully');
			} else {
				outputJSON(400, 'error', 'Failed to update, please try again');
				return;
			}
		}
	}
	
	public function view_job() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'id', 'label' => 'ID', 'rules' => 'required|integer'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|integer'],
		];
  
		checkValidation($input, $rules);

		$id=$input['id'];
		$rec_id=$input['rec_id'];
		$check = $this->db->where('id', $id)->where('created_by', $rec_id)->get('post_job')->num_rows();
		if($check==0){
			outputJSON(400, 'error', 'Invalid Job ID or job not found');
			return;
		}
	
		$data = $this->db->where('id', $id)->get('post_job')->row();
		if($data){
			outputJSON(200, 'success', 'Data fetched successfully.',$data);
		}else{
			outputJSON(500, 'error', 'No data found');
		}
    }
	
	public function delete_job() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'id', 'label' => 'ID', 'rules' => 'required|integer'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|integer'],
		];
  
		checkValidation($input, $rules);

		$id=$input['id'];
		$rec_id=$input['rec_id'];
		$check = $this->db->where('id', $id)->where('created_by', $rec_id)->get('post_job')->num_rows();
		if($check==0){
			outputJSON(400, 'error', 'Invalid Job ID or job not found');
			return;
		}		
		$data = $this->db->where('id', $id)->delete('post_job');
		if($this->db->affected_rows() > 0){
			outputJSON(200, 'success', 'Deleted successfully.');
		}else{
			outputJSON(500, 'error', 'Failed to delete record, please try again.');
		}
    }
	
	public function update_job_status() {
		if ($this->input->method(true) !== 'POST') {
			outputJSON(405, 'error', 'Use POST method.');
			return;
		}

		$input = inputJson();
		checkValidation($input, [
			['field' => 'id', 'label' => 'ID', 'rules' => 'required|integer'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|integer']
		]);

		$job = $this->db->select('status')
						->where(['id' => $input['id'], 'created_by' => $input['rec_id']])
						->get('post_job')
						->row();

		if (!$job) {
			outputJSON(400, 'error', 'Invalid Job ID or job not found');
			return;
		}

		$new_status = ($job->status) ? 0 : 1;
		$res = $this->lib_model->Update('post_job', ['status' => $new_status], ['id' => $input['id'], 'created_by' => $input['rec_id']]);
		
		outputJSON($res ? 200 : 500, $res ? 'success' : 'error', $res ? 'Job status updated.' : 'Failed to update status.');
	}

	
	public function job_list() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'type', 'label' => 'type', 'rules' => 'required'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|integer'],
		];
  
		checkValidation($input, $rules);

		$type=$input['type'];
		$rec_id=$input['rec_id'];
		
		if($type=='active'){
			$status=0;
		}elseif($type=='inactive'){
			$status=1;
		}else{
			outputJSON(400, 'error', 'Invalid type please select any option from these [active, inactive]');
			return;
		}		
		$data = $this->common_model->get_recruiter_job($status,$rec_id);
		if($data){
			outputJSON(200, 'success', 'Data fetched successfully.',$data);
		}else{
			outputJSON(200, 'error', 'Failed to fetch record, please try again.');
		}
    }
	
	public function get_job_list() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|integer'],
		];
  
		checkValidation($input, $rules);

		$rec_id=$input['rec_id'];
			
		$data = $this->db->select('id,jTitle as title')->get_where('post_job', ['status' => 0, 'created_by' => $rec_id])->result();
		if($data){
			outputJSON(200, 'success', 'Data fetched successfully.',$data);
		}else{
			outputJSON(200, 'error', 'Data not found.');
		}
    }
	
	public function dashboard() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|integer'],
			['field' => 'job_id', 'label' => 'Job ID', 'rules' => 'required|integer'],
		];
  
		checkValidation($input, $rules);

		$rec_id=$input['rec_id'];
		$job_id=$input['job_id'];
		$recruiter=$this->db->where('id', $rec_id)->get('employer')->row();
		$insight = $this->common_model->get_recruiter_job($status=0,$rec_id,$limit=3);
		$applicant = $this->common_model->get_applicant($rec_id,$status=0,$job_id,$limit=10);
		$data=[
			'name'=>$recruiter->c_name,
			'post_insight'=>$insight,
			'applicants'=>$applicant,
		];
		outputJSON(200, 'success', 'Data fetched successfully.',$data);
		
    }
	
	public function applicant_list() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'type', 'label' => 'type', 'rules' => 'required'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|integer'],
		];
  
		checkValidation($input, $rules);

		$type=$input['type'];
		$rec_id=$input['rec_id'];
		$job_id=$input['job_id'] ?? null;
		
		if($type=='applicant'){
			$status=0;
		}elseif($type=='shortlist'){
			$status=1;
		}elseif($type=='rejected'){
			$status=2;
		}else{
			outputJSON(400, 'error', 'Invalid type please select any option from these [applicant, shortlist, rejected]');
			return;
		}		
		$data = $this->common_model->get_applicant($rec_id,$status,$job_id);
		if($data){
			outputJSON(200, 'success', 'Data fetched successfully.',$data);
		}else{ 
			outputJSON(200, 'error', 'Data not found.');
		} 
    }
	
	public function applicant_status() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'id', 'label' => 'ID', 'rules' => 'required|integer'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required'],
			['field' => 'type', 'label' => 'type', 'rules' => 'required'],
		];
  
		checkValidation($input, $rules);

		$type=$input['type'];
		if($type=='shortlist'){
			$status=1;
		}elseif($type=='rejected'){
			$status=2;
		}else{
			outputJSON(500, 'error', 'Invalid type value, please select one of these ( shortlist, rejected )');
			return;
		}
		$id=$input['id'];
		$rec_id=$input['rec_id'];
		$check = $this->db->where('id', $id)->where('rec_id', $rec_id)->get('applied_job_emp')->num_rows();
		if($check==0){
			outputJSON(400, 'error', 'Invalid application ID or record not found');
			return;
		}
		$res = $this->lib_model->Update('applied_job_emp', ['status' => $status], ['id' => $input['id'], 'rec_id' => $input['rec_id']]);
		if($res){
			outputJSON(200, 'success', 'Application '.ucfirst($type).' successfully.');
		}else{
			outputJSON(500, 'error', 'Failed to update status, please try again.');
		}
    }
	
			
	public function global_search()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$rules = [
			['field' => 'search', 'label' => 'search', 'rules' => ''],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required'],
		];
  
		checkValidation($input, $rules);
		$rec_id = $input['rec_id'];
		$search = $input['search'];
		$data = $this->common_model->globalSearchRecruiter($rec_id,$search);
		outputJSON(200, 'success', 'Data fetched successfully', $data);
	}
	
	public function job_viewed()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$rules = [
			['field' => 'job_id', 'label' => 'Job ID', 'rules' => 'required']
		];
  
		checkValidation($input, $rules);
		$job_id = $input['job_id'];
		$data = $this->common_model->get_viewed_applicant($job_id);
		if($data){
			outputJSON(200, 'success', 'Data fetched successfully', $data);
		}else{
			outputJSON(200, 'success', 'Data not found');
		}
		
	}
}
