<?php
defined('BASEPATH') or exit('No direct script access allowed');


class CommonController extends CI_Controller {
    public function __construct()
	{
	    parent::__construct();
	    $this->load->model('lib_model');  
	    $this->load->model('common_model');  
	    $this->load->helper('new');  
	    $this->load->helper('common');  
	    $this->load->helper('date');   
		
		$this->output
             ->set_content_type('application/json', 'utf-8')
             ->set_header('Access-Control-Allow-Origin: *')
             ->set_header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE')
             ->set_header('Access-Control-Allow-Headers: Content-Type, Authorization');
		
		$sql =  "SELECT * FROM hiring_api_auth";
		$api_auth= $this->lib_model->Execute($sql, array())->row_array();
		if(isset($_SERVER['PHP_AUTH_USER']) and isset($_SERVER['PHP_AUTH_PW'])){
			if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
			{
				outputJSON(400, 'error', 'Authentication failed');
				return;
			}
	    }else{
			outputJSON(400, 'error', 'Authentication Username and password not set');
			return;
		}

	}
	
	public function get_career_preference()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$emp_id = $input['emp_id'] ?? null;
		$search = $input['search'] ?? '';
		$page = $input['page'] ?? 1; 
		$limit = $input['limit'] ?? 10; 

		if (empty($emp_id)) {
			outputJSON(400, 'error', 'Employee ID (emp_id) is required.');
			return;
		}
		$offset = ($page - 1) * $limit;
		$res=$this->common_model->getCareerPreference($emp_id,$limit,$offset,$search);
		$res=json_decode($res);
		$response = [
			'current_page' => $page,
			'total_pages' => ceil($res->count / $limit),
			'total_records' => $res->count,
			'records_per_page' => $limit,
			'data' => $res->data,
		];
		if (!empty($res->data)) {
			outputJSON(200, 'success', 'Career preferences fetched successfully.', $response);
		} else {
			outputJSON(200, 'error', 'No career preferences found for the provided Employee ID.');
		}
	}
	
	public function get_job_titles()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$search = $input['search'] ?? ''; 
		$page = (int)($input['page'] ?? 1);
		$limit = (int)($input['limit'] ?? 10); 
		$offset = ($page - 1) * $limit; 

		$this->db->select('*')
				 ->from('db_job_titles')
				 ->where('status', 0);

		if (!empty($search)) {
			$this->db->like('title', $search);
		}

		$total_count = $this->db->count_all_results('', false);

		$this->db->limit($limit, $offset);

		$job_titles = $this->db->get()->result_array();

		if (!empty($job_titles)) {
				
			$response = [
				'current_page' => $page,
				'total_pages' => ceil($total_count / $limit),
				'total_records' => $total_count,
				'items_per_page' => $limit,
				'data' => $job_titles,
			];
			
			outputJSON(200, 'success', 'Job titles fetched successfully.', $response);
		} else {
			outputJSON(200, 'error', 'No job titles found.');
		}
	}
	
	
	public function get_apply_job()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'job_id', 'label' => 'Job ID', 'rules' => 'required|trim|numeric'],
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|trim|numeric'],
		];

		checkValidation($input, $rules);

		$job_id = $input['job_id'];
		$emp_id = $input['emp_id'];
		$check = $this->db->get_where('post_job', ['id' => $job_id])->num_rows();
		if ($check==0) {
			outputJSON(400, 'error', 'Job not found with provided Job ID.');
			return;
		}
		$job = $this->db->get_where('post_job', ['id' => $job_id])->row();
		$rec_id=$job->created_by;
		$existingApplication = $this->lib_model->Select('applied_job_emp', 'rec_id, emp_id, job_id', [
			'emp_id' => $emp_id, 
			'rec_id' => $rec_id, 
			'job_id' => $job_id
		]);

		if (!empty($existingApplication)) {
			$res = $this->lib_model->Update('applied_job_emp',['status'=>3], ['job_id'=>$job_id,'emp_id'=>$emp_id]);
			if($res){
				$title='🗑️ Application Withdrawn';
				$body='You’ve successfully withdrawn your application. You can reapply anytime.';
				$this->common_model->saveNotification($emp_id,$title,$body,'employee');
				outputJSON(200, 'success', 'Application withdrawal successfully.');
			}else{
				outputJSON(400, 'error', 'something went wrong.');
				return;
			}
		}else{
			$applicationData = [
				'rec_id' => $rec_id,
				'emp_id' => $emp_id,
				'job_id' => $job_id,
			];

			$applicationId = $this->lib_model->Insert('applied_job_emp', $applicationData);

			$user = $this->lib_model->select_column_where(
				['id', 'c_name', 'f_token_web', 'f_token_app'],
				'employer', 
				['id' => $rec_id]
			);

			$title='✅ Application Submitted';
			$body='You’ve successfully applied for the job. We’ll notify you when the recruiter views it.';
			$this->common_model->saveNotification($emp_id,$title,$body,'employee');
			$title='🧾 New Candidate Application';
			$body='A new candidate has applied to your job post. Review their profile now!';
			$this->common_model->saveNotification($rec_id,$title,$body,'employer');
			outputJSON(200, 'success', 'Job has been applied successfully');
		}
	}
	
	
	public function get_states()
	{
		if (strtoupper($this->input->method()) !== 'GET') {
			outputJSON(405, 'error', 'Invalid request method. Please use GET.');
			return;
		}
		$data = $this->lib_model->Select('state', '*', []);

		if (!empty($data)) {
			outputJSON(200, 'success', 'Data fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No data available.');
		}
	}
	
	public function get_districts()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$state_id = $input['state_id'] ?? null;

		if (!empty($state_id)) {
			$data = $this->db->query("SELECT * FROM district WHERE state_id = ? ORDER BY districtid DESC", [$state_id])->result();
		} else {
			$data = $this->lib_model->Select('district', '*', []);
		}

		if (!empty($data)) {
			outputJSON(200, 'success', 'Data fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No data available.');
		}
	}
	
	
	public function get_city()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input=inputJson();
		$district_id = $input['district_id'] ?? null;

		if (!empty($district_id)) {
			$data = $this->db->query("SELECT * FROM city WHERE districtid = ? ORDER BY id DESC", [$district_id])->result_array();
		} else {
			$data = $this->lib_model->Select('city', '*', []);
		}

		if (!empty($data)) {
			outputJSON(200, 'success', 'Data fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No data available.');
		}
	}

	public function job_list()
	{
		if (strtoupper($this->input->method()) !== 'GET') {
			outputJSON(405, 'error', 'Invalid request method. Please use GET.');
			return;
		}

		$job_titles = $this->db->query("SELECT DISTINCT jTitle as title FROM post_job")->result_array();
		
		if (!empty($job_titles)) {
			outputJSON(200, 'success', 'Data found', $job_titles);
		} else {
			outputJSON(200, 'error', 'Data not found');
		}
	}
	
	public function job_list_new()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|trim|numeric'],
		];

		checkValidation($input, $rules);

		$emp_id = $input['emp_id'];

		$job_titles = $this->db->select('p_job_roles as title')->where('created_by',$emp_id)->get('career_preferences')->result();
		
		if (!empty($job_titles)) {
			outputJSON(200, 'success', 'Data found', $job_titles);
		} else {
			outputJSON(200, 'error', 'Data not found');
		}
	}

	public function get_employee_details()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$params = inputJson();
		$emp_id = $params['emp_id'] ?? null;
		$rec_id = $params['rec_id'] ?? null;
		$job_id = $params['job_id'] ?? null;

		$conditions = [];

		if (!empty($emp_id)) {
			$conditions[] = "C.id = '$emp_id'";
		}

		if (!empty($job_id)) {
			$skillsData = $this->lib_model->Select('post_job', 'skills', ['id' => $job_id]);
			if (!empty($skillsData)) {
				$skills = explode(",", $skillsData[0]->skills);
				$skillsConditions = array_map(function ($skill) {
																	return "D.skills LIKE '%$skill%'";
																}, $skills);
				$conditions[] = '(' . implode(' OR ', $skillsConditions) . ')';
			}
		}

		$whereClause = !empty($conditions) ? ' AND ' . implode(' AND ', $conditions) : '';
		$date = date("Y-m-d");

		if (empty($rec_id)) {
			$sql = "SELECT 
						TIMESTAMPDIFF(YEAR, E.c_dob, ?) AS DateDiff,
						C.*, D.p_job_roles, D.t_exp_yr, D.t_exp_month, D.eng, D.p_e_type, D.eTYpe,
						E.highestQual, E.gender, D.skills, D.p_sal_L, D.p_sal_T, D.Objective
					FROM employee C
					LEFT JOIN career_preferences D ON C.id = D.created_by
					LEFT JOIN basic_detail E ON C.id = E.created_by
					WHERE C.status = 0 $whereClause
					ORDER BY C.id DESC";
			$data = $this->db->query($sql, [$date])->result_array();
		} else {
			$sql = "SELECT 
						TIMESTAMPDIFF(YEAR, E.c_dob, ?) AS DateDiff,
						C.*, D.p_job_roles, D.t_exp_yr, D.t_exp_month, D.eng, D.p_e_type, D.eTYpe,
						E.highestQual, E.gender, D.skills, D.p_sal_L, D.p_sal_T, D.Objective
					FROM employee C
					LEFT JOIN career_preferences D ON C.id = D.created_by
					LEFT JOIN basic_detail E ON C.id = E.created_by
					WHERE C.status = 0 $whereClause
					ORDER BY C.id DESC";
			$data = $this->db->query($sql, [$date])->result_array();
		}

		if (!empty($data)) {
			outputJSON(200, 'success', 'Data fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No data available.');
		}
	}
	
	
	public function submit_career_preferences()
	{
	
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		
		$input = $this->input->post();

		
		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|integer'],
			// ['field' => 'name', 'label' => 'Name', 'rules' => 'required'],
			// ['field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'],
			// ['field' => 'mobile', 'label' => 'Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			// ['field' => 'gender', 'label' => 'Gender', 'rules' => 'required'],
			['field' => 'state', 'label' => 'state', 'rules' => 'required'],
			['field' => 'city', 'label' => 'city', 'rules' => 'required'],
			['field' => 'role', 'label' => 'job role', 'rules' => 'required'],
			['field' => 'experience', 'label' => 'experience level', 'rules' => 'required'],
			['field' => 'skills', 'label' => 'skills', 'rules' => 'required'],
			['field' => 'employment_type', 'label' => 'employment type', 'rules' => 'required'],
			['field' => 'job_type', 'label' => 'job type', 'rules' => 'required'],
			['field' => 'shift', 'label' => 'Shift', 'rules' => 'required'],
			['field' => 'qualification', 'label' => 'qualification', 'rules' => 'required'],
			['field' => 'communication', 'label' => 'communication', 'rules' => 'required'],
			['field' => 'salary_type', 'label' => 'salary type', 'rules' => 'required'],
			['field' => 'min', 'label' => 'min salary', 'rules' => 'required'],
			['field' => 'max', 'label' => 'max salary', 'rules' => 'required'],
			['field' => 'tag', 'label' => 'tag', 'rules' => 'required'],
			// ['field' => 'objective', 'label' => 'objective', 'rules' => 'required'],
		];

		checkValidation($input, $rules);
		$user=$this->db->where('created_by', $input['emp_id'])->get('career_preferences')->row();
		if (empty($user->resume) && empty($_FILES["resume"]['name'])) {
			outputJSON(400, 'error', 'Please upload resume');
			return;
		}
		
		if (!empty($_FILES["resume"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["resume"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;

			$config = [
				'upload_path'   => 'canidate_documents/resume',
				'allowed_types' => 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt',
				'max_size'      => 11000,
				'file_name'     => $new_name,
			];
			$this->upload->initialize($config);

			if ($this->upload->do_upload('resume')) {
				$upload_data = $this->upload->data();
				$filePath = $upload_data['full_path'];
				$resume = $upload_data['file_name'];

				if (in_array($ext, ['jpg', 'jpeg', 'png'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$resume = $upload_data['raw_name'] . '.webp';
					}
				}
			} else {
				outputJSON(413, 'error', $this->upload->display_errors('', ''));
				return;
			}
		} else {
			$resume = '';
		}


		$data = [
			'created_by' => $input['emp_id'],
			'p_job_roles' => $input['role'],
			'p_cities' => $input['city'],
			'p_state' => $input['state'],
			// 'contact' => $input['mobile'],
			// 'email' => $input['email'],
			// 'fullname' => $input['name'],
			// 'gender' => $input['gender'],
			// 'Objective' => $input['objective'],
			'eng'=>$input['communication'],
			'eTYpe'=>$input['employment_type'],
			'p_e_type'=>$input['job_type'],
			'p_shift'=>$input['shift'],
			't_exp_type'=>$input['experience'],
			't_exp_yr'=>$input['year'] ?? 0,
			't_exp_month'=>$input['month'] ?? 0,
			'qualification'=>$input['qualification'],
			'p_sal_Type' => $input['salary_type'],
			'p_sal_L' => $input['min'],
			'p_sal_T'=>$input['max'],
			'skills'=>$input['skills'],
			'tag'=>$input['tag'],
		];
	
		if(!empty($_FILES["resume"]['name'])) {
			$data['resume']=$resume;
		}

		$check = $this->db->get_where('career_preferences', ['created_by' => $input['emp_id']])->num_rows();

		if ($check>0) {
			$res=$this->lib_model->Update('career_preferences', $data, ['created_by' => $input['emp_id']]);
			if ($res) {
				outputJSON(200, 'success', 'Data updated successfully.', $data);
			} else {
				outputJSON(500, 'error', 'Data update failed.');
			}
		} else {
			$res = $this->lib_model->Insert('career_preferences', $data);
			if ($res) {
				
				$title='📄 Resume Uploaded';
			$body='Your resume has been successfully uploaded. Start applying to jobs now!';
			$this->common_model->saveNotification($this->user_id,$title,$body,'employee');
				outputJSON(201, 'success', 'Data saved successfully.', $data);
			} else {
				outputJSON(500, 'error', 'Data save failed.');
			}
		}
		
	}

	public function update_fcm_token()
	{
	
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		
		$input = inputJson();

		$rules = [
			['field' => 'id', 'label' => 'Employee ID', 'rules' => 'required|integer'],
			['field' => 'fcm_token', 'label' => 'state', 'rules' => 'required'],
			['field' => 'type', 'label' => 'type', 'rules' => 'required|in_list[employee,employer]'],
		];

		checkValidation($input, $rules);
		$type=$input['type'];
		$data = [
			'f_token_app'=>$input['fcm_token'],
		];

		$check = $this->db->get_where($type, ['id' => $input['id']])->num_rows();
		if ($check>0) {
			$res=$this->lib_model->Update($type, $data, ['id' => $input['id']]);
			if ($res) {
				outputJSON(200, 'success', 'Data updated successfully.');
			} else {
				outputJSON(500, 'error', 'Data update failed.');
			}
		} else {
			outputJSON(404, 'error', 'User not found with provided ID.');
			
		}
		
	}

	public function get_job_search()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$emp_id = $input['emp_id'] ?? null;

		if (empty($emp_id)) {
			outputJSON(400, 'error', 'Please add Employee ID.');
			return;
		}

		$page = isset($input['page']) ? (int) $input['page'] : 1; // Default to page 1
		$limit = isset($input['limit']) ? (int) $input['limit'] : 10; // Default items per page
		$offset = ($page - 1) * $limit;

		$filters = $this->buildFilters($input);
		$query = "SELECT SQL_CALC_FOUND_ROWS * FROM post_job 
				  WHERE status = 0 {$filters['conditions']} 
				  ORDER BY id DESC 
				  LIMIT ? OFFSET ?";
		$params = array_merge($filters['params'], [$limit, $offset]);
		$result = $this->db->query($query, $params)->result_array();

		$totalRecords = $this->db->query("SELECT FOUND_ROWS() as total")->row()->total;

		if (empty($result) && !empty($input['search'])) {
			$searchTerm = $input['search'];
			$altQuery = "SELECT about_com.name as company_name, post_job.* FROM post_job
						 LEFT JOIN about_com ON post_job.created_by = about_com.created_by
						 WHERE post_job.status = 0 AND about_com.name LIKE ?
						 LIMIT ? OFFSET ?";
			$result = $this->db->query($altQuery, ["%$searchTerm%", $limit, $offset])->result_array();
		}

		if (!empty($result)) {
			$responseData = array_map(function ($row) {
				return [
					'id' => $row['id'],
					'jobDescription' => $row['jobDescription'],
					'jTitle' => $row['jTitle'],
					'nOpen' => $row['nOpen'],
					'state' => $row['state'],
					'District' => $row['District'],
					'city' => $row['city'],
					'zip' => $row['zip'],
					'address' => $row['adress'],
					'emp_type' => $row['emp_type'],
					'jobtype' => $row['jobtype'],
					'shift' => $row['shift'],
					'experience' => $row['experience'],
					'quali' => $row['quali'],
					'skills' => $row['skills'],
					'sMin' => $row['sMin'],
					'sMax' => $row['sMax'],
					'created_at' => date('d M, Y H:i A', strtotime($row['created_at'])),
					'created_by' => $row['created_by']
				];
			}, $result);

			$response = [
				'current_page' => $page,
				'total_pages' => ceil($totalRecords / $limit),
				'total_records' => $totalRecords,
				'items_per_page' => $limit,
				'data' => $responseData,
			];

			outputJSON(200, 'success', 'Data found', $response);
		} else {
			outputJSON(200, 'success', 'No data available.');
		}
	}
	
	
	private function buildFilters($input)
	{
		$conditions = '';
		$params = [];

		// Dynamic filters
		if (!empty($input['cities'])) {
			$cityConditions = implode(' OR ', array_fill(0, count($input['cities']), 'city LIKE ?'));
			$conditions .= " AND ($cityConditions)";
			$params = array_merge($params, array_map(function($city) {
																		return "%$city%";
																	}, $input['cities']));
		}

		if (!empty($input['job_title'])) {
			$jdConditions = implode(' OR ', array_fill(0, count($input['job_title']), 'jTitle LIKE ?'));
			$conditions .= " AND ($jdConditions)";
			$params = array_merge($params, array_map(function($jd) {
																	return "%$jd%";
																}, $input['job_title']));

		}

		if (!empty($input['job_type'])) {
			$conditions .= " AND jobtype LIKE ?";
			$params[] = "%{$input['job_type']}%";
		}

		if (!empty($input['shift'])) {
			$conditions .= " AND shift LIKE ?";
			$params[] = "%{$input['shift']}%";
		}

		if (!empty($input['emp_type'])) {
			$conditions .= " AND emp_type LIKE ?";
			$params[] = "%{$input['emp_type']}%";
		}

		if (!empty($input['salary'])) {
			$salaryRange = $this->getSalaryRange($input['salary']);
			$conditions .= " AND sMin >= ? AND sMax <= ?";
			$params[] = $salaryRange['from'];
			$params[] = $salaryRange['to'];
		}

		if (!empty($input['search'])) {
			$conditions .= " AND (jTitle LIKE ? OR skills LIKE ?)";
			$params[] = "%{$input['search']}%";
			$params[] = "%{$input['search']}%";
		}

		return ['conditions' => $conditions, 'params' => $params];
	}

	private function getSalaryRange($salary)
	{
		$ranges = [
			'0to3' => ['from' => 0, 'to' => 3],
			'3to5' => ['from' => 3, 'to' => 5],
			'7to9' => ['from' => 7, 'to' => 9],
			'10to15' => ['from' => 10, 'to' => 15],
			'16to30' => ['from' => 16, 'to' => 30],
		];

		return $ranges[$salary] ?? ['from' => 0, 'to' => 0];
	}
	
	public function save_unsave_job()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$rules = [
			['field' => 'job_id', 'label' => 'Job ID', 'rules' => 'required|numeric'],
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|numeric']
		];
		checkValidation($input, $rules);
		$check = $this->db->get_where('employee', ['status' => 0, 'id' => $input['emp_id']])->num_rows();
		if ($check==0) {
			outputJSON(200, 'error', 'Employee not found with provided Employee ID.');
			return;
		}
		$check = $this->db->get_where('post_job', ['id' => $input['job_id']])->num_rows();
		if ($check==0) {
			outputJSON(200, 'error', 'Job not found with provided Job ID.');
			return;
		}
		$count = $this->lib_model->Counter('emp_save_job', [
			'emp_id' => $input['emp_id'],
			'job_id' => $input['job_id']
		]);

		if ($count === 0) {
			$this->lib_model->Insert('emp_save_job', [
				'emp_id' => $input['emp_id'],
				'job_id' => $input['job_id']
			]);
			outputJSON(200, 'success', 'Job saved successfully.');
		} else {
			$this->lib_model->delete('emp_save_job', [
				'emp_id' => $input['emp_id'],
				'job_id' => $input['job_id']
			]);
			outputJSON(200, 'success', 'Job unsaved successfully.');
		}
	}


	
	public function get_saved_job()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|trim|numeric'],
			['field' => 'type', 'label' => 'type', 'rules' => 'required|trim']
		];
		checkValidation($input, $rules);

		$emp_id = $input['emp_id'];
		$type = $input['type'];
		if($type=='lookback'){
			$result=$this->common_model->getLookbackJob($emp_id);
		}elseif($type=='applied'){
			$result=$this->common_model->getAppliedJob($emp_id);
		}elseif($type=='saved'){
			$result=$this->common_model->getSavedJob($emp_id);
		}else{
			outputJSON(400, 'error', 'Please select a valid type.');
			return;
		}
		outputJSON(200, 'success', 'Data found', $result);
		
	}
	
	public function get_highlight()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|numeric']
		];
		checkValidation($input, $rules);

		$emp_id = $input['emp_id'];

		$total_applied = $this->lib_model->emp_applied($emp_id);
		$chat_with_rec = $this->lib_model->chat_recruiters_andr($emp_id);

		$response = [
			'total_job_applied' => count($total_applied),
			'chat_with_rec' => count($chat_with_rec)
		];

		outputJSON(200, 'success', 'Data Found', $response);
	}
	
	public function get_chat()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|numeric'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required|numeric']
		];
		checkValidation($input, $rules);
 
		$emp_id = $input['emp_id'];
		$rec_id = $input['rec_id'];

		$res = all_msgs($emp_id,$rec_id);
		if($res!='NA'){
			outputJSON(200, 'success', 'Data Found', $res);
		}else{
			outputJSON(200, 'error', 'Data not Found');
		}
	}


	
	public function get_job_details()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$job_id = $input['job_id'] ?? null;
		$emp_id = $input['emp_id'] ?? null;

		if (empty($job_id)) {
			outputJSON(400, 'error', 'Please add Job ID(job_id).');
			return;
		}

		$data=$this->common_model->getSingleJob($job_id,$emp_id);
		if (!empty($data)) {
			outputJSON(200, 'success', 'Data fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No data available.');
		}
	}
	
	public function get_titles_data()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$type = $input['type'] ?? null;
		if (empty($type)) {
			outputJSON(400, 'error', 'Please add Category(category).');
			return;
		}
		
		$data = $this->db->select('value,title')->from('post_job_titles')->where('category', $type)->get()->result_array();
		
		if (!empty($data)) {
			outputJSON(200, 'success', 'Data fetched successfully.', $data);
		} else {
			outputJSON(200, 'success', 'No data available.');
		}
	}
	
	public function get_recommended()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$emp_id = $input['emp_id'] ?? null;
		$page = $input['page'] ?? 1;
		$per_page = $input['per_page'] ?? 10;
		$search = $input['search'] ?? null;
		$offset = ($page - 1) * $per_page;
		if (empty($emp_id)) {
			$data = $this->common_model->get_all_job($search,$emp_id,$per_page, $offset,$input);
		}else{
			$data = $this->common_model->get_recommended_post_job($emp_id,$per_page, $offset, $search,$input);
		}
		outputJSON(200, 'success', 'Data found', $data);
	}
	
	public function get_all_job()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$emp_id = $input['emp_id'] ?? null;
		$page = $input['page'] ?? 1;
		$per_page = $input['per_page'] ?? 10;
		$search = $input['search'] ?? null;
		$offset = ($page - 1) * $per_page;
		// if (empty($emp_id)) {
			// outputJSON(400, 'error', 'Please add Employee ID.');
			// return;
		// }
		
		$data = $this->common_model->get_all_job($search,$emp_id,$per_page, $offset,$input);
		outputJSON(200, 'success', 'Data found', $data);
	}
		
	public function global_search()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$emp_id = $input['emp_id'] ?? null;
		$page = $input['page'] ?? 1;
		$per_page = $input['per_page'] ?? 10;
		$search = $input['search'] ?? null;
		$offset = ($page - 1) * $per_page;	
		$data = $this->common_model->globalSearch($search,$emp_id,$per_page, $offset,$input);
		outputJSON(200, 'success', 'Data found', $data);
	}
	
	public function get_toppic()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$emp_id = $input['emp_id'] ?? null;
		$search = $input['search'] ?? null;
		// if (empty($emp_id)) {
			// outputJSON(400, 'error', 'Please add Employee ID.');
			// return;
		// }
		$user = $this->db->where('status', 0)->where('id', $emp_id)->get('employee')->row();
		$list = $this->common_model->get_latest_job($search,$emp_id);
		$data=[
			'name'=>$user->c_name,
			'list'=>$list
		];
		outputJSON(200, 'success', 'Data found', $data);
	}

	public function submit_education()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|integer'],
			['field' => 'institution', 'label' => 'Institution', 'rules' => 'required'],
			['field' => 'degree', 'label' => 'Degree', 'rules' => ''],
			['field' => 'field_of_study', 'label' => 'Field of Study', 'rules' => ''],
			['field' => 'start_date', 'label' => 'Start Date', 'rules' => 'required'],
			['field' => 'is_current', 'label' => 'Is Current', 'rules' => 'integer'],
			['field' => 'grade', 'label' => 'Grade', 'rules' => ''],
		];

		checkValidation($input, $rules);

		$data = [
			'emp_id' => $input['emp_id'],
			'institution' => $input['institution'],
			'degree' => $input['degree'] ?? '',
			'field_of_study' => $input['field_of_study'] ?? '',
			'start_date' => $input['start_date'],
			'end_date' => $input['end_date'] ?? null,
			'is_current' => $input['is_current'] ?? 0,
			'grade' => $input['grade'] ?? '',
			'activities' => $input['activities'] ?? '',
			'description' => $input['description'] ?? ''
		];
		if(empty($input['edit_id'])){
			$res = $this->lib_model->Insert('education', $data);
			if ($res) {
				outputJSON(201, 'success', 'Education record added successfully.');
			} else {
				outputJSON(500, 'error', 'Failed to add education record.');
			}
		}else{
			$res = $this->lib_model->Update('education', $data, ['id' => $input['edit_id']]);
			if ($res) {
				outputJSON(200, 'success', 'Education record updated successfully.');
			} else {
				outputJSON(500, 'error', 'Failed to update education record.');
			}
		}
	}
	public function submit_work_experience()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|integer'],
			['field' => 'company_name', 'label' => 'Company Name', 'rules' => 'required'],
			['field' => 'job_title', 'label' => 'Job Title', 'rules' => 'required'],
			['field' => 'start_date', 'label' => 'Start Date', 'rules' => 'required'],
			['field' => 'is_current', 'label' => 'Is Current', 'rules' => ''],
			['field' => 'employment_type', 'label' => 'Employment type', 'rules' => 'required'],
			['field' => 'location_type', 'label' => 'Location type', 'rules' => 'required'],
			['field' => 'location', 'label' => 'Location', 'rules' => ''],
			['field' => 'technologies', 'label' => 'Technologies', 'rules' => ''],
			['field' => 'description', 'label' => 'Description', 'rules' => '']
		];

		checkValidation($input, $rules);

		$data = [
			'emp_id' => $input['emp_id'],
			'company_name' => $input['company_name'],
			'job_title' => $input['job_title'],
			'start_date' => $input['start_date'],
			'end_date' => $input['end_date'] ?? null,
			'is_current' => $input['is_current'] ?? 0,
			'location' => $input['location'] ?? '',
			'employment_type' => $input['employment_type'] ?? '',
			'location_type' => $input['location_type'] ?? '',
			'technologies' => $input['technologies'] ?? '',
			'description' => $input['description'] ?? ''
		];

		if (empty($input['edit_id'])) {
			$res = $this->lib_model->Insert('work_experience', $data);
			if ($res) {
				outputJSON(201, 'success', 'Work experience added successfully.');
			} else {
				outputJSON(500, 'error', 'Failed to add work experience.');
			}
		} else {
			$res = $this->lib_model->Update('work_experience', $data, ['id' => $input['edit_id']]);
			if ($res) {
				outputJSON(200, 'success', 'Work experience updated successfully.');
			} else {
				outputJSON(500, 'error', 'Failed to update work experience.');
			}
		}
	}
	public function submit_work_portfolio()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = $this->input->post();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required|integer'],
			['field' => 'title', 'label' => 'Job Title', 'rules' => 'required'],
			['field' => 'url', 'label' => 'Related URL', 'rules' => ''],
			['field' => 'start_date', 'label' => 'Start Date', 'rules' => 'required'],
			['field' => 'end_date', 'label' => 'End Date', 'rules' => ''],
			['field' => 'is_current', 'label' => 'Is Current', 'rules' => ''],
		];

		checkValidation($input, $rules);
		
		if (empty($input['edit_id']) && empty($_FILES["image"]['name'])) {
			outputJSON(400, 'error', 'Please select portfolio image.');
			return;
		}

	   if (empty($input['edit_id']) || !empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'uploads/work';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$image = $upload_data['raw_name'] . '.webp'; 
					} else {
						$image = $file_name_c_logo;
					}
				} else {
					$image = $file_name_c_logo;
				}
				
			} else {
				$error = $this->upload->display_errors('', '');
				outputJSON(413, 'error', $error);
				return;
			}
		}
		
		$data = [
			'emp_id' => $input['emp_id'],
			'title' => $input['title'],
			'url' => $input['url'],
			'description' => $input['description'],
			'start_date' => $input['start_date'],
			'end_date' => $input['end_date'] ?? null,
			'is_current' => $input['is_current'] ?? 0,
		];
		
		if(!empty($_FILES["image"]['name'])) {
			$data['image']=$image;
		}
		
		if (empty($input['edit_id'])) {
			
			$res = $this->lib_model->Insert('work_portfolio', $data);
			if ($res) {
				outputJSON(201, 'success', 'Work record added successfully.');
			} else {
				outputJSON(500, 'error', 'Failed to add work record.');
			}
		} else {
			$res = $this->lib_model->Update('work_portfolio', $data, ['id' => $input['edit_id']]);
			if ($res) {
				outputJSON(200, 'success', 'Work record updated successfully.');
			} else {
				outputJSON(500, 'error', 'Failed to update work record.');
			}
		}
	}

	public function delete_parmanently() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'id', 'label' => 'ID', 'rules' => 'required|integer'],
			['field' => 'type', 'label' => 'type', 'rules' => 'required'],
		];
  
		checkValidation($input, $rules);

		$type=$input['type'];
		if($type=='experience'){
			$table='work_experience';
		}elseif($type=='education'){
			$table='education';
		}elseif($type=='portfolio'){
			$table='work_portfolio';
		}else{
			outputJSON(500, 'error', 'Invalid type value, please select one of these ( experience, education, portfolio )');
			return;
		}
		$id=$input['id'];
		
		$data = $this->db->where('id', $id)->delete($table);
		if($this->db->affected_rows() > 0){
			outputJSON(200, 'success', 'Deleted successfully.');
		}else{
			outputJSON(500, 'error', 'Failed to delete record, please try again.');
		}
    }

	public function view_details() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'id', 'label' => 'ID', 'rules' => 'required|integer'],
			['field' => 'type', 'label' => 'type', 'rules' => 'required'],
		];
  
		checkValidation($input, $rules);

		$type=$input['type'];
		if($type=='experience'){
			$table='work_experience';
		}elseif($type=='education'){
			$table='education';
		}elseif($type=='portfolio'){
			$table='work_portfolio';
		}elseif($type=='career_preference'){
			$table='career_preferences';
		}else{
			outputJSON(200, 'error', 'Invalid type value, please select one of these ( experience, education, portfolio )');
			return;
		}
		$id=$input['id'];
		if($type=='career_preference'){
			$data = $this->db->where('created_by', $id)->get($table)->result();
		}else{
			$data = $this->db->where('id', $id)->get($table)->result();
			if($type=='portfolio'){
				foreach($data as $row){
					$row->image=base_url('uploads/work/'.$row->image);
				}
			}
		}
		if($data){
			outputJSON(200, 'success', 'Data fetched successfully.',$data);
		}else{
			outputJSON(200, 'error', 'No data found');
		}
    }

	public function update_skills()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required'],
			['field' => 'skills', 'label' => 'Skills', 'rules' => 'required'],
		];

		checkValidation($input, $rules);
		$check = $this->db->get_where('career_preferences', ['created_by' => $input['emp_id']])->num_rows();

		if ($check==0) {
			outputJSON(400, 'error', 'Invalid Employee ID or Career preference record not found.');
			return;
		}
		$emp_id=$input['emp_id'];
		
		$data = [
			'skills' => $input['skills'],
		];
	
		$res = $this->lib_model->Update('career_preferences', $data, ['created_by' => $emp_id]);
		if ($res) {
			outputJSON(200, 'success', 'Skills updated successfully');
		} else {
			outputJSON(400, 'error', 'Failed to update, please try again');
			return;
		}
				
	}
	
	public function user_list()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'id', 'label' => 'ID', 'rules' => 'required'],
			['field' => 'type', 'label' => 'Type', 'rules' => 'required|in_list[employee,employer]'],
		];

		checkValidation($input, $rules);

		$id = $input['id'];
		$type = $input['type'];

		// Validate if the user exists
		$check = $this->db->get_where($type, ['id' => $id])->num_rows();
		if ($check == 0) {
			outputJSON(400, 'error', 'Invalid ID, user not found with provided ID.');
			return;
		}

		// Determine the chat column names based on user type
		$sender_col   = ($type === 'employee') ? 'ee_id' : 'rec_id';
		$receiver_col = ($type === 'employee') ? 'rec_id' : 'ee_id';
		$read_col     = ($type === 'employee') ? 'read_by_emp' : 'read_by_rec';
		$table_name   = ($type === 'employee') ? 'employer' : 'employee';

		// Fetch users chatted with, last message, message time, unread count
		$qry = "SELECT u.*, 
			-- Latest message
			(SELECT msg FROM chatbox_msg cm 
			 WHERE ((cm.$sender_col = ? AND cm.$receiver_col = u.id)
				 OR (cm.$sender_col = u.id AND cm.$receiver_col = ?))
			 ORDER BY cm.created_at DESC LIMIT 1) AS last_message,

			-- Latest message time
			(SELECT cm.created_at FROM chatbox_msg cm 
			 WHERE ((cm.$sender_col = ? AND cm.$receiver_col = u.id)
				 OR (cm.$sender_col = u.id AND cm.$receiver_col = ?))
			 ORDER BY cm.created_at DESC LIMIT 1) AS message_time,

			-- Unread count
			(SELECT COUNT(*) FROM chatbox_msg cm 
			 WHERE cm.$sender_col = u.id 
			   AND cm.$receiver_col = ? 
			   AND cm.$read_col = 0) AS unread_count

		FROM $table_name u
		WHERE u.id IN (
			SELECT DISTINCT 
				IF(cm.$sender_col = ?, cm.$receiver_col, cm.$sender_col) 
			FROM chatbox_msg cm 
			WHERE cm.$sender_col = ? OR cm.$receiver_col = ?
		)
		ORDER BY message_time DESC";


		$query = $this->db->query($qry, [
    $id, $id,       // last_message
    $id, $id,       // message_time
    $id,            // unread_count
    $id, $id, $id   // for subquery IN clause
])->result();


		$data=[];
		foreach($query as $row){
			if($table_name=='employer'){
				$about = $this->db->get_where('about_com', ['created_by' => $row->id])->row();
				$image=base_url('jd/jdrec/documents/' . (!empty($about->c_logo) ? $about->c_logo : 'user.png'));
			}else{
				$image=base_url('profile_pic/' . (!empty($row->profile_pic) ? $row->profile_pic : 'user.png'));
			}
			$data[]=[
				'id'=>$row->id,
				'name'=>$row->c_name,
				'image'=>$image,
				'last_message'=>$row->last_message,
				'message_time'=>$this->common_model->formatChatTime($row->message_time),
				'unread_count'=>$row->unread_count
			];
		}
		
		outputJSON(200, 'success', 'User list fetched successfully', $data);
	}


	public function fetch_chat() {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Emp ID', 'rules' => 'required'],
			['field' => 'rec_id', 'label' => 'Rec ID', 'rules' => 'required'],
			// ['field' => 'limit', 'label' => 'Limit', 'rules' => ''],
			// ['field' => 'offset', 'label' => 'offset', 'rules' => ''],
			['field' => 'type', 'label' => 'Type', 'rules' => 'required|in_list[employee,employer]'],
		];

		checkValidation($input, $rules);

		$emp_id = $input['emp_id'];
		$rec_id = $input['rec_id'];
		$type = $input['type'];
		// $limit = (isset($input['limit']) && !empty($input['limit'])) ? $input['limit'] : 20;
		// $offset = (isset($input['offset']) && !empty($input['offset'])) ? $input['offset'] : 0;
		$messages = $this->common_model->getChat($emp_id, $rec_id,$type);

		outputJSON(200, 'success', 'Chat messages fetched successfully', $messages);
	}
	
	public function first_msg_status()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required'],
			['field' => 'type', 'label' => 'Type', 'rules' => 'required|in_list[employee,employer]'],
		];

		checkValidation($input, $rules);
		$emp_id=$input['emp_id'];
		$rec_id=$input['rec_id'];
		$type=$input['type'];
		$check = $this->db->get_where('emp_block_recr', ['emp_id' => $input['emp_id'],'rec_id' => $input['rec_id']])->num_rows();

		if ($check==0) {
			$checkmsg = $this->db->get_where('chatbox_msg', ['ee_id' => $input['emp_id'],'rec_id' => $input['rec_id']])->num_rows();
			if($checkmsg>0){
				$data=[
					'emp_id'=>$emp_id,
					'rec_id'=>$rec_id,
					'status'=>2,
					'status_recr'=>0,
					'created_by'=>$type,
				];
				$res = $this->lib_model->Insert('emp_block_recr', $data);
				if ($res) {
					outputJSON(200, 'success', 'updated successfully');
				} else {
					outputJSON(200, 'error', 'Failed to update, please try again');
					return;
				}
			}else{
				outputJSON(200, 'error', 'Please send msg first');
				return;
			}
		}else{
			$data=[
				'emp_id'=>$emp_id,
				'rec_id'=>$rec_id,
				'status'=>2,
				'status_recr'=>2,
			];
			$res = $this->lib_model->Update('emp_block_recr', $data, ['emp_id'=>$emp_id,'rec_id'=>$rec_id]);
			if ($res) {
				outputJSON(200, 'success', 'updated successfully');
			} else {
				outputJSON(200, 'error', 'Failed to update, please try again');
				return;
			}
		}				
	}
	
	public function block_unblock()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required'],
			['field' => 'type', 'label' => 'Type', 'rules' => 'required|in_list[employee,employer]'],
		];

		checkValidation($input, $rules);
		
		$emp_id = $input['emp_id'];
		$rec_id = $input['rec_id'];
		$type = $input['type'];

		$check = $this->db->get_where('emp_block_recr', ['emp_id' => $emp_id, 'rec_id' => $rec_id])->row_array();

		if (!$check) {
			outputJSON(200, 'error', 'You are not connected to each other');
			return;
		}

		$field = ($type == 'employee') ? 'status_recr' : 'status';

		$new_status = ($check[$field] == 1) ? 2 : 1;

		$data = [
			$field => $new_status
		];

		$res = $this->lib_model->Update('emp_block_recr', $data, ['emp_id' => $emp_id, 'rec_id' => $rec_id]);

		if ($res) {
			$message = ($new_status == 2) ? 'Unblocked successfully' : 'Blocked successfully';
			outputJSON(200, 'success', $message);
		} else {
			outputJSON(400, 'error', 'Failed to update, please try again');
		}
	}

	
	public function getChatStatus()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required'],
			['field' => 'rec_id', 'label' => 'Recruiter ID', 'rules' => 'required'],
			['field' => 'type', 'label' => 'Type', 'rules' => 'required|in_list[employee,employer]'],
		];

		checkValidation($input, $rules);
		
		$emp_id = $input['emp_id'];
		$rec_id = $input['rec_id'];
		$type = $input['type'];
		$check=$this->db->get_where('emp_block_recr',['rec_id'=> $rec_id , 'emp_id'=> $emp_id ]);
		$msg = ($type == 'employee') ? 'you' : 'employee';
		$msg1 = ($type == 'employer') ? 'you' : 'employer';
		$msgs = ($type == 'employee') ? 'employer' : 'employee';
		$msgs1 = ($type == 'employer') ? 'employee' : 'employer';

		if($check->num_rows()==0){
			$res=[
			'block_status'=>true,
			'blocked_by'=>''
			];
			outputJSON(200, 'error', 'Chat Blocked',$res);
			return;
		}else{
			$result=$check->row();
			if($result->status==1 and $result->status_recr==1){
				$res=[
					'block_status'=>true,
					'blocked_by'=>''
				];
				outputJSON(200, 'error', 'Chat Blocked by both side',$res);
				return;
			}elseif($result->status==1){
				
				$res=[
				'block_status'=>true,
				'blocked_by'=>$msgs1
				];
				outputJSON(200, 'error', 'Chat blocked by '.$msg1,$res);
				return;
			}elseif($result->status_recr==1){
				$res=[
				'block_status'=>true,
				'blocked_by'=>$msgs
				];
				outputJSON(200, 'error', 'Chat blocked by '.$msg,$res);
				return;
			}else{
				$res=[
				'block_status'=>false,
				'blocked_by'=>'disabled'
				];
				outputJSON(200, 'success', 'Chat enable',$res);
			}
		}
	}
   
}