<?php
defined('BASEPATH') or exit('No direct script access allowed');


class AuthController extends CI_Controller {
    public function __construct()
	{
	    parent::__construct();
	    $this->load->model('lib_model');  
	    $this->load->model('common_model');  
	    $this->load->helper('email');  
	    $this->load->helper('new');  
	    $this->load->helper('date');  
		$this->load->helper('common'); 
		
		$this->output
             ->set_content_type('application/json', 'utf-8')
             ->set_header('Access-Control-Allow-Origin: *')
             ->set_header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE')
             ->set_header('Access-Control-Allow-Headers: Content-Type, Authorization');
		
		$sql =  "SELECT * FROM hiring_api_auth";
		$api_auth= $this->lib_model->Execute($sql, array())->row_array();
		if(isset($_SERVER['PHP_AUTH_USER']) and isset($_SERVER['PHP_AUTH_PW'])){
			if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
			{
				outputJSON(400, 'error', 'Authentication failed');
				return;
			}
	    }else{
			outputJSON(400, 'error', 'Authentication Username and password not set');
			return;
		}

	}
	
	public function upload_profile_image()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = $_POST;
		$emp_id = $input['emp_id'] ?? null;

		if (empty($emp_id)) {
			outputJSON(400, 'error', 'Employee ID (emp_id) is required.');
			return;
		}
		
		$check = $this->db->get_where('employee', ['status' => 0, 'id' => $input['emp_id']])->num_rows();

		if ($check==0) {
			outputJSON(404, 'error', 'Invalid Employee ID, Employee not found.');
			return;
		}
		
		
		if (!empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'profile_pic';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$pic = $upload_data['raw_name'] . '.webp'; 
					} else {
						$pic = $file_name_c_logo;
					}
				} else {
					$pic = $file_name_c_logo;
				}
			} else {
				$error = $this->upload->display_errors('', '');
				outputJSON(413, 'error', $error);
				return;
			}
			$data=[
				'profile_pic'=>$pic,
			];
			$res=$this->lib_model->Update('employee', $data, array('id'=>$emp_id));
			if($res){
				outputJSON(200, 'success', 'Profile image updated successfully.',$pic);
			}
		} else {
			outputJSON(404, 'error', 'Please select profile image.');
			return;
		}		
		
	}
	
	public function get_profile_details()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}

		$input = inputJson();
		$emp_id = $input['emp_id'] ?? null;
		$rec_id = $input['rec_id'] ?? null;

		if (empty($emp_id)) {
			outputJSON(400, 'error', 'Employee ID (emp_id) is required.');
			return;
		}

		$profile = $this->db->get_where('employee', ['id' => $emp_id])->row();
		if (empty($profile)) {
			outputJSON(404, 'error', 'No data found for the provided Employee ID.');
			return;
		}
		$career = $this->db->from('career_preferences')->where('created_by', $emp_id)->get()->row();
		if(!empty($career)){
			$career->resume= (!empty($career->resume) ? base_url('canidate_documents/resume/' .$career->resume ) : '');
			if($career->t_exp_type=='fresher'){
				 $exp='Fresher';
			}else{
				$exp=$career->t_exp_yr.'y '.$career->t_exp_month.'m Exp';
			}
			$career->experience=$exp;
		}
		$data=[
			'id'=>$profile->id,
			'profile_pic'=>$profile->profile_pic=base_url('profile_pic/' . (!empty($profile->profile_pic) ? $profile->profile_pic : 'user.png')),
			'name'=>$profile->c_name,
			'dob'=>$profile->dob,
			'gender'=>$profile->gender,
			'headline'=>$profile->headline,
			'experience'=>$career->experience ?? '',
			'address'=>$profile->address,
			'bio'=>$profile->bio,
			'email'=>$profile->c_email,
			'mobile'=>$profile->c_contact,
			'website_url'=>$profile->portfolio_url,
			'linkedin'=>$profile->linkedin,
			'resume'=>$career->resume ?? '',
			'work_experience'=>$this->common_model->getWorkExperience($emp_id),
			'skills'=>$career->skills ?? '',
			'education'=>$this->common_model->getEducations($emp_id),
			'work_portfolio'=>$this->common_model->getPortfolio($emp_id),
		];
		if(!empty($rec_id)){
			$title='👁️ Profile Viewed';
			$body='A recruiter checked your profile! Keep it updated to attract more opportunities.';
			$this->common_model->saveNotification($emp_id,$title,$body,'employee');
			$exists = $this->db->where([
				'emp_id' => $emp_id,
				'rec_id' => $rec_id
			])->get('rec_view_emp')->num_rows();
			if($exists==0){
				$this->lib_model->Insert('rec_view_emp', ['emp_id'=>$emp_id,'rec_id'=>$rec_id]);
			}
		}
		outputJSON(200, 'success', 'Data fetched successfully.', $data);
	}

	
	public function send_otp() {
        if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$rules = [
			['field' => 'mobile', 'label' => 'Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'type', 'label' => 'type', 'rules' => 'required|trim'],
		];
		checkValidation($input,$rules);
		$mobile=$input['mobile'];
		$type=$input['type'];
		if ($type !== 'employee' && $type !== 'employer') {
			outputJSON(400, 'error', 'Invalid type, please select either "employee" or "employer".');
			return;
		}

		$valid = $this->db->where('c_contact', $mobile)->get($type);
		if($valid->num_rows()>0){
			$user=$valid->row();
			 if($user->status==1){
				outputJSON(400, 'error', 'Account disabled, please contact admin or create new account.');
				return;
			 }
			$username=$user->c_name ?? 'User';
			$template = $this->db->where(['status' => '0', 'type' => 'send_otp'])->get('sms_template')->row();
			if (!$template) {
				outputJSON(400, 'error', 'SMS template not found.');
				return;
			}
			// $otp = rand(10000, 99999);
			$otp = 12345;
			$name = str_replace(' ', '', $username) ?: 'User';
			
			$msg = str_replace(
				['mobile_number', 'user_name', 'otp_now'],
				[$user->c_contact, $name, $otp],
				$template->body
			);

			$db_data = [
				'phone' => $user->c_contact,
				'otp' => $otp,
				'user_id' => $name,
				'added_by_web' => $_SERVER['HTTP_HOST']
			];
			$this->lib_model->Insert('all_otp', $db_data);
			// $result = send_text_msg_new(trim($msg));
			// if (!$result) {
				// outputJSON(400, 'error', 'Failed to send sms');
				// return;
			// }
			outputJSON(200, 'success', 'OTP sent successfully to '.$mobile,['mobile'=>$mobile,'type'=>$type]);
		}else{
		
			$check = $this->db->where('c_contact', $mobile)->get($type)->num_rows();
			if($check>0){
				outputJSON(409, 'error', 'Mobile number already registered with us.');
				return;
			}
			$submitData=[
				'c_contact'=>$mobile
			];
			
			$res = $this->lib_model->Insert($type, $submitData);
			if($res){
				$username='User';
				$template = $this->db->where(['status' => '0', 'type' => 'send_otp'])->get('sms_template')->row();
				if (!$template) {
					outputJSON(400, 'error', 'SMS template not found.');
					return;
				}
				// $otp = rand(10000, 99999);
				$otp = 12345;
				$name = str_replace(' ', '', $username) ?: 'User';
				
				$msg = str_replace(
					['mobile_number', 'user_name', 'otp_now'],
					[$mobile, $name, $otp],
					$template->body
				);

				$db_data = [
					'phone' => $mobile,
					'otp' => $otp,
					'user_id' => $name,
					'added_by_web' => $_SERVER['HTTP_HOST']
				];
				$this->lib_model->Insert('all_otp', $db_data);
				// $result = send_text_msg_new(trim($msg));
				// if (!$result) {
					// outputJSON(400, 'error', 'Failed to send sms');
					// return;
				// }
				outputJSON(200, 'success', 'OTP sent successfully to '.$mobile,['mobile'=>$mobile,'type'=>$type]);
			}else{
				outputJSON(400, 'error', 'Please try after sometime, May be network issue.');
				return;
			}
		}
    }
	
	
	public function verify_otp()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$rules = [
			['field' => 'mobile', 'label' => 'Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'type', 'label' => 'type', 'rules' => 'required|trim'],
			['field' => 'otp', 'label' => 'otp', 'rules' => 'required|trim'],
		];
		checkValidation($input,$rules);
		$mobile=$input['mobile'];
		$type=$input['type'];
		$otp=$input['otp'];
		if ($type !== 'employee' && $type !== 'employer') {
			outputJSON(400, 'error', 'Invalid type, please select either "employee" or "employer".');
			return;
		}

		$valid = $this->db->where('status', 0)->where('c_contact', $mobile)->get($type);
		if($valid->num_rows()==0){
			outputJSON(404, 'error', 'User not found with provided mobile number.');
			return;
		}
		$user=$valid->row();
			
		$otpDetails = $this->db->where('phone', $user->c_contact)->order_by('id','desc')->get('all_otp')->row();

			if (!$otpDetails) {
				outputJSON(400, 'error', 'Please resend otp');
				return;
			}
			if ($otpDetails->otp!=$otp) {
				outputJSON(400, 'error', 'Invalid OTP 😞');
				return;
			}
			$timeDifference = round((strtotime(date('Y-m-d H:i:s')) - strtotime($otpDetails->updated_at)) / 60); // difference in minutes
			if ($timeDifference >= 10) {
				outputJSON(400, 'error', 'OTP expired 😐');
				return;
			}

			if($type=='employee'){
				$careerStatus = $this->db->where('created_by', $user->id)->count_all_results('career_preferences') > 0;
				$profileStatus = !empty($user->c_name) && !empty($user->c_email) && !empty($user->profile_pic);
				$data=[
					'id'=>$user->id,
					'name'=>$user->c_name,
					'profile'=>$profileStatus,
					'career_preferences'=>$careerStatus
				];
				outputJSON(200, 'success', 'Login Successfully',$data);
			}else{
				$profileStatus = $this->db->where('created_by', $user->id)->count_all_results('about_com') > 0;
				$data=[
					'id'=>$user->id,
					'name'=>$user->c_name,
					'profile'=>$profileStatus
				];
				outputJSON(200, 'success', 'Login Successfully',$data);
			}
	}
	
	public function update_profile()
	{
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}


        $input = $this->input->post();

		$rules = [
			['field' => 'emp_id', 'label' => 'Employee ID', 'rules' => 'required'],
			['field' => 'name', 'label' => 'Name', 'rules' => 'required'],
			['field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'],
			['field' => 'mobile', 'label' => 'Mobile', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'gender', 'label' => 'Gender', 'rules' => 'required'],
			['field' => 'headline', 'label' => 'Headline', 'rules' => 'required'],
			['field' => 'address', 'label' => 'address', 'rules' => 'required'],
		];

		checkValidation($input, $rules);
		$emp_id=$input['emp_id'];
		$check=$this->db->where('id!=', $emp_id)->where('c_contact', $input['mobile'])->get('employee')->num_rows();
		if($check>0){
			outputJSON(409, 'error', 'This mobile number is already registered with us.');
			return;
		}
		$check=$this->db->where('id!=', $emp_id)->where('c_email', $input['email'])->get('employee')->num_rows();
		if($check>0){
			outputJSON(409, 'error', 'This email is already registered with us.');
			return;
		}
		$user=$this->db->where('id', $emp_id)->get('employee')->row();
		if (empty($user->profile_pic) && empty($_FILES["image"]['name'])) {
			outputJSON(400, 'error', 'Please select profile image');
			return;
		}

	   if (!empty($_FILES["image"]['name'])) {
			$this->load->library('upload');
			$filename = $_FILES["image"]['name'];
			$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
			$new_name = time() . rand() . '.' . $ext;
			$config['upload_path'] = 'profile_pic';
			$config['allowed_types'] = 'jpg|png|jpeg|pdf|doc|docx|ppt|pptx|txt|webp';
			$config['max_size'] = 2048;
			$config['file_name'] = $new_name;

			$this->upload->initialize($config);

			if ($this->upload->do_upload('image')) {
				$upload_data = $this->upload->data(); 
				$file_name_c_logo = $upload_data['file_name']; 
				$filePath = $upload_data['full_path']; 

				if (in_array($ext, ['jpg', 'jpeg', 'png','webp'])) {
					$output_path = $upload_data['file_path'] . $upload_data['raw_name'] . '.webp';
					if (convert_to_webp($filePath, $output_path)) {
						unlink($filePath);
						$image = $upload_data['raw_name'] . '.webp'; 
					} else {
						$image = $file_name_c_logo;
					}
				} else {
					$image = $file_name_c_logo;
				}
				
			} else {
				$error = $this->upload->display_errors('', '');
				outputJSON(413, 'error', $error);
				return;
			}
		}
		$data = [
			'c_name' => $input['name'],
			'c_contact' => $input['mobile'],
			'c_email' => $input['email'],
			'bio' => $input['bio'],
			'dob' => $input['dob'],
			'gender' => $input['gender'],
			'headline' => $input['headline'],
			'address' => $input['address'],
			'portfolio_url' => $input['portfolio_url'],
			'linkedin' => $input['linkedin'],
		];
		if(!empty($_FILES["image"]['name'])) {
			$data['profile_pic']=$image;
		}
				
		$res = $this->lib_model->Update('employee', $data, ['id' => $emp_id]);
		if ($res) {
			$this->lib_model->Update('career_preferences', ['gender'=>$input['gender']], ['created_by' => $emp_id]);
			outputJSON(200, 'success', 'Profile updated successfully.');
			return;
		} else {
			outputJSON(400, 'error', 'Failed to update, please try again');
			return;
		}
	}


   
}