<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/



$route['default_controller'] = 'Home';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

////// Website Routes /////

$route['test']='Home/test';
$route['jobs']='Home/jobs';
$route['save-fcm-token']='Home/save_fcm_token';
$route['explore-jobs']='Home/explore_jobs';
$route['job-details']='Home/jobDetails';
$route['about']='Home/about';
$route['contact-us']='Home/contact';
$route['privacy-policy']='Home/privacyPolicy';
$route['terms-conditions']='Home/termsConditions';
 
$route['send-otp']='AuthController/sendOtp';
$route['resend-otp']='AuthController/sendOtp';
$route['verify-otp']='AuthController/verifyOtp';
$route['submit-enquiry']='Home/submitContact';
$route['profile']='Employee/Employee/profile';
$route['chat']='Employee/Employee/chat';
$route['list-users']='Employee/Employee/user_list';
$route['lookback']='Employee/Employee/lookBack';
$route['saved-job']='Employee/Employee/savedJob';
$route['applied-job']='Employee/Employee/appliedJob';
$route['update-profile']='Employee/Employee/update_profile';
$route['submit-work-experience']='Employee/Employee/submitWorkExperience';
$route['submit-work-portfolio']='Employee/Employee/submit_work_portfolio';
$route['submit-education']='Employee/Employee/submitEducation';
$route['update-skills']='Employee/Employee/update_skills';
$route['save-unsave-job']='Employee/Employee/save_unsave_job';
$route['apply-job']='Employee/Employee/apply_job';
$route['isEdit']='Employee/Employee/isEdit';
$route['delete-parmanently']='Employee/Employee/delete_parmanently';
$route['getJobDetails']='Home/getJobDetails';
$route['career-preference']='Employee/Employee/careerPreference';
$route['submit-career-preference']='Employee/Employee/submit_career_preference';
$route['get-chat-status']='Employee/Employee/getChatStatus';
$route['get-job-list']='Employee/Employee/get_job_list';
$route['maintenance']='Home/maintenance';
$route['status']='Employee/Employee/status_update';
$route['update-msg-status']='Employee/Employee/update_msg_status';
$route['logout']='AuthController/logout';
$route['logout-recruiter']='AuthController/logout_rec';
$route['common-api']='Home/common_api';
$route['get-cities']='Employee/Employee/get_cities';
////// Employer ////// 

$route['employer/dashboard']='Employer/Employer/dashboard';
$route['employer/profile']='Employer/Employer/profile';
$route['employer/application']='Employer/Employer/application';
$route['employer/jobs']='Employer/Employer/jobs';
$route['employer/shortlist']='Employer/Employer/shortlist';
$route['employer/rejected']='Employer/Employer/rejected';
$route['employer/add-job']='Employer/Employer/addJob';
$route['employer/submit-job']='Employer/Employer/submit_job';
$route['employer/status']='Employer/Employer/status_update';
$route['employer/delete-parmanently']='Employer/Employer/delete_parmanently';

$route['employer/update-about-company']='Employer/Employer/update_about_company';
$route['employer/get_districts']='Employer/Employer/get_districts';
$route['employer/get_cities']='Employer/Employer/get_cities';
$route['employer/get_insight']='Employer/Employer/get_insight';
$route['employer/load_candidates']='Employer/Employer/load_candidates';
$route['employer/recruitment_journey']='Employer/Employer/recruitment_journey';
$route['employer/list-users']='Employer/Employer/user_list';
$route['employer/chat']='Employer/Employer/chat';
$route['employer/get-chat-status']='Employer/Employer/getChatStatus';
$route['employer/update-msg-status']='Employer/Employer/update_msg_status';
$route['employer/get-job-list']='Employer/Employer/get_job_list';
$route['employer/employee-profile']='Employer/Employer/employee_profile';
$route['employer/job-viewed']='Employer/Employer/job_viewed';
////// Employer ////// 


////// Website Routes /////

// $route['abcd/(:any)'] = "index.php/user/$1";


$route['asdf']= "User/employee";
$route['api/employee/register']='API/AuthController/employee_register';
$route['api/employee/login']='API/AuthController/employee_login';
$route['api/employee/change_password']='API/AuthController/change_password';
$route['api/employee/upload_profile_image']='API/AuthController/upload_profile_image';
$route['api/employee/profile_details']='API/AuthController/get_profile_details';
$route['api/employee/profile_details_emp_add_edit']='API/AuthController/profile_details_emp_add_edit';
$route['api/employee/top-pick']='API/CommonController/get_toppic';
$route['api/employee/add_previous_com']='API/AuthController/add_previous_com';
$route['api/employee/basic_detail']='API/AuthController/get_basic_detail';
$route['api/employee/send_otp']='API/AuthController/send_otp';
$route['api/employee/verify_otp']='API/AuthController/verify_otp';
$route['api/employee/submit_basic_profile_data']='API/AuthController/submit_basic_profile_data';
$route['api/employee/employee_profile_image']='API/AuthController/employee_profile_image';
$route['api/employee/career_preference']='API/CommonController/get_career_preference';
$route['api/employee/job_titles']='API/CommonController/get_job_titles';
$route['api/employee/apply_job']='API/CommonController/get_apply_job';
$route['api/employee/job_list']='API/CommonController/job_list';
$route['api/employee/job_list_new']='API/CommonController/job_list_new';
$route['api/employee/employee_details']='API/CommonController/get_employee_details';
$route['api/employee/submit-career-preferences']='API/CommonController/submit_career_preferences';
$route['api/employee/job_search']='API/CommonController/get_job_search';
$route['api/employee/save_unsave_job']='API/CommonController/save_unsave_job';
$route['api/employee/list_saved_job']='API/CommonController/get_saved_job';
$route['api/employee/get_highlight']='API/CommonController/get_highlight';

$route['api/employee/recommended']='API/CommonController/get_recommended';
$route['api/employee/all-jobs']='API/CommonController/get_all_job';
$route['api/employee/job_details']='API/CommonController/get_job_details';
$route['api/employee/submit-education']='API/CommonController/submit_education';
$route['api/employee/submit-work-experience']='API/CommonController/submit_work_experience';
$route['api/employee/submit-work-portfolio']='API/CommonController/submit_work_portfolio';
$route['api/employee/delete']='API/CommonController/delete_parmanently';
$route['api/employee/global-search']='API/CommonController/global_search';
$route['api/employee/view-single-details']='API/CommonController/view_details';
$route['api/employee/update-skills']='API/CommonController/update_skills';
$route['api/employee/update-profile']='API/AuthController/update_profile';
$route['api/employee/first-msg-status']='API/CommonController/first_msg_status';



////  Common APIs for Employee and Employer ///////
$route['api/employee/get_auth']='Auth_api/get_auth_data';
$route['api/employee/states']='API/CommonController/get_states';
$route['api/employee/districts']='API/CommonController/get_districts';
$route['api/employee/cities']='API/CommonController/get_city';
$route['api/employee/get_chat']='API/CommonController/get_chat';
$route['api/employee/titles-data']='API/CommonController/get_titles_data';
$route['api/employee/user-list']='API/CommonController/user_list';
$route['api/employee/fetch-chat']='API/CommonController/fetch_chat';
$route['api/employee/block-unblock']='API/CommonController/block_unblock';
$route['api/employee/chat-request']='API/CommonController/first_msg_status';
$route['api/employee/chat-status']='API/CommonController/getChatStatus';
$route['api/employee/update-fcm-token']='API/CommonController/update_fcm_token';


////// Employer APIs ///////

$route['api/employer/update-about-company']='API/Employer/update_about_company';
$route['api/employer/profile-details']='API/Employer/profile_details';
$route['api/employer/submit-job']='API/Employer/submit_job';
$route['api/employer/view-job']='API/Employer/view_job';
$route['api/employer/delete-job']='API/Employer/delete_job';
$route['api/employer/job-list']='API/Employer/job_list';
$route['api/employer/update-job-status']='API/Employer/update_job_status';
$route['api/employer/applicant-list']='API/Employer/applicant_list';
$route['api/employer/applicant-status']='API/Employer/applicant_status';
$route['api/employer/job-titles']='API/Employer/get_job_list';
$route['api/employer/dashboard']='API/Employer/dashboard';
$route['api/employer/global-search']='API/Employer/global_search';
$route['api/employer/job-viewed']='API/Employer/job_viewed';

////// Employer APIs ///////



//-------------- > Admin Routes < --------------//

$route['admin'] = "AdminController/index"; 
$route['admin/index'] = "AdminController/index"; 
$route['admin/login']='AdminController/index';
$route['admin/submit-login']='AdminController/submit_login';
$route['admin/dashboard']='AdminController/dashboard';
$route['admin/manage-company']='AdminController/manage_company';
$route['admin/dynamic-titles']='AdminController/dynamicTitles';
$route['admin/manage-industry']='AdminController/manage_industry';
$route['admin/manage-employee']='AdminController/manage_employee';
$route['admin/manage-job']='AdminController/manage_job';
$route['admin/manage-application']='AdminController/manage_application';
$route['admin/manage-admin-user']='AdminController/manage_admin_user';
$route['admin/manage-notification']='AdminController/manage_notification';
$route['admin/settings']='AdminController/settings';