<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api_Delivery extends CI_Controller {


	    function __construct() {
        parent::__construct();
        
        $this->grocery_db = $this->load->database('grocery_database', TRUE); 
        $this->food_db = $this->load->database('food_database', TRUE); 
        $this->load->library('form_validation');
        $this->load->model('Apideliveryboy_model');
        $this->load->model('Apifooddeliveryboy_model');
          $this->load->model('Deliveryboy_model');
        $this->load->library('encryption');
        $this->load->helper('my_helper');
        $this->load->library('firebase');
      
        $sql =  "SELECT * FROM tbl_api_auth";
        $api_auth= $this->food_db->query($sql)->row_array();

        if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
        {
            header("Access-Control-Allow-Origin: *");
            header("Content-Type: application/json; charset=UTF-8");
            $response['status']='error';
            $response['statusCode']=400;
            $response['message']='Authentication failed';
            echo json_encode($response);
            die;
        }
 
  
    }
    
    
  public function get_services()
{
    header('Content-Type: application/json');

    $status = 'error';
    $statusCode = 400;
    $message = 'No services found.';
    $data = [];

    $query = $this->food_db
        ->select('id, service_img, service_name')
        ->from('all_services')
        ->where('status', '1') 
        ->order_by('id', 'ASC')
        ->get();

    if ($query->num_rows() > 0) {
        $services = $query->result();

        // Append base URL to service_img
        foreach ($services as $service) {
            $service->service_img = FOOD_IMAGE_URL.$service->service_img; 
        }

        $data = $services;
        $status = 'success';
        $statusCode = 200;
        $message = 'Service list fetched successfully.';
    }

    echo json_encode([
        'status' => $status,
        'statusCode' => $statusCode,
        'message' => $message,
        'data' => $data
    ]);
}

    
    
    public function profile_data() {
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");

    $response = [
        'status' => 'error',
        'statusCode' => 400,
        'message' => 'Invalid Request'
    ];

    // Get and clean JSON input
    $json = $this->security->xss_clean(file_get_contents('php://input'));
    $data = json_decode($json);

    // Validate user_id
    if (!isset($data->user_id) || empty($data->user_id)) {
        $response['message'] = 'User ID is required.';
        echo json_encode($response);
        return;
    }

    $user_id = $data->user_id;

    // Fetch delivery boy profile
    $userdata = $this->food_db
        ->query("SELECT * FROM deliveryboy WHERE deli_user_id = ?", [$user_id])
        ->row_array();

    if (empty($userdata)) {
        $response['message'] = 'Profile not found.';
        echo json_encode($response);
        return;
    }

    // Build the response
    $profile = [
        'id'               => $userdata['id'],
        'deliveryboy_id'   => $userdata['deli_user_id'],
        'name'             => $userdata['name'],
        'email_id'         => $userdata['email_id'],
        'mobile_no'        => $userdata['mobile_no'],
        'address'          => $userdata['address'],
        'city'             => $userdata['city'],
        'state'            => $userdata['state'],
        'country'          => $userdata['country'],
        'pin_code'         => $userdata['pin_code'],
        'latitude'         => $userdata['latitude'],
        'longitude'        => $userdata['longitude'],
        'created_date'     => $userdata['created_date'] ,
        'online_status'    => ($userdata['is_online'] == '0') ? 'online' : 'offline',
        'profile_image'    => !empty($userdata['image_photo']) 
                                ? DELIVERYBOY_IMAGE_URL . $userdata['image_photo'] 
                                : DELIVERYBOY_IMAGE_URL . 'asset/no-image-available.png',
         'profile_image'    => !empty($userdata['image_photo']) 
                                ? DELIVERYBOY_IMAGE_URL . $userdata['image_photo'] 
                                : DELIVERYBOY_IMAGE_URL . 'asset/no-image-available.png',
                                
        'aadhar_image'    => !empty($userdata['aadhar_doc']) 
                                ? DELIVERYBOY_IMAGE_URL . $userdata['aadhar_doc'] 
                                : DELIVERYBOY_IMAGE_URL . 'asset/no-image-available.png',
        'licence_image'    => !empty($userdata['licence_doc']) 
                                ? DELIVERYBOY_IMAGE_URL . $userdata['licence_doc'] 
                                : DELIVERYBOY_IMAGE_URL . 'asset/no-image-available.png',
                                
        'leave_start_date' => !empty($userdata['lev_start_date']) ? $userdata['lev_start_date'] : 'NA',
        'leave_end_date'   => !empty($userdata['lev_end_date']) ? $userdata['lev_end_date'] : 'NA'
    ];

    // Final success response
    echo json_encode([
        'status' => 'success',
        'statusCode' => 200,
        'message' => 'Profile data fetched successfully.',
        'data' => $profile
    ]);
}

    public function profiledata_update_oll(){
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");

    $response = [
        'status' => 'error',
        'statusCode' => 400,
        'message' => 'Invalid Request'
    ];

    // Clean and parse input
    $json = $this->security->xss_clean(file_get_contents('php://input'));
    $data = json_decode($json);

    // Required fields
    $requiredFields = ['user_id', 'name', 'email', 'phone', 'address', 'pin_code', 'city', 'state', 'country'];
    $missingFields = [];

    // Check for missing fields
    foreach ($requiredFields as $field) {
        if (!isset($data->$field) || trim($data->$field) === '') {
            $missingFields[] = $field;
        }
    }

    // If any field is missing, return error
    if (!empty($missingFields)) {
        $response['message'] = 'Missing required fields: ' . implode(', ', $missingFields);
        echo json_encode($response);
        return;
    }

    // Prepare update data
    $updateData = [
        'name'       => trim($data->name),
        'email_id'   => trim($data->email),
        'mobile_no'  => trim($data->phone),
        'address'    => trim($data->address),
        'pin_code'   => trim($data->pin_code),
        'city'       => trim($data->city),
          'lev_start_date'       => trim($data->lev_start_date),
           'lev_end_date'       => trim($data->lev_end_date),
        'state'      => trim($data->state),
        'country'    => trim($data->country)
    ];

    // Update in both tables
    $user_id = trim($data->user_id);
 
    $this->Apifooddeliveryboy_model->update_data('deliveryboy', 'deli_user_id', $user_id, $updateData);

    // Success response
    $response = [
        'status' => 'success',
        'statusCode' => 200,
        'message' => 'Profile updated successfully.'
    ];

    echo json_encode($response);
}

    
    public function profiledata_update() {
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");

    $response = [
        'status' => 'error',
        'statusCode' => 200,
        'message' => 'Invalid Request'
    ];

    // Fetch input from POST (multipart/form-data)
    $user_id   = $this->input->post('user_id');
    $name      = $this->input->post('name');
    $email     = $this->input->post('email');
    $phone     = $this->input->post('phone');
    $address   = $this->input->post('address');
    $pin_code  = $this->input->post('pin_code');
    $lev_start = $this->input->post('lev_start_date');
    $lev_end   = $this->input->post('lev_end_date');
      
    

    // Validate required fields
    $requiredFields = compact('user_id','name','email', 'phone','address','pin_code');
    $missingFields = [];

    foreach ($requiredFields as $field => $value) {
        if (empty(trim($value))) {
            $missingFields[] = $field;
        }
    }

    if (!empty($missingFields)) {
        $response['message'] = 'Missing required fields: ' . implode(', ', $missingFields);
        echo json_encode($response);
        return;
    }

    // Prepare profile update data
    $updateData = [
        'name'           => trim($name),
        'email_id'       => trim($email),
        'mobile_no'      => trim($phone),
        'address'        => trim($address),
        'pin_code'       => trim($pin_code),
        'lev_start_date' => trim($lev_start),
        'lev_end_date'   => trim($lev_end),
    ];

    // Handle profile image upload if provided
    if (!empty($_FILES['image_photo']['name'])) {
        $imageName = 'deliveryboy' . time();
        $config['upload_path']   = './assets_delivery/deliveryboy_image/';
        $config['allowed_types'] = 'gif|jpg|png|jpeg';
        $config['file_name']     = $imageName;

        $this->load->library('upload', $config);
        $this->upload->initialize($config);

        if ($this->upload->do_upload('image_photo')) {
            $uploadData = $this->upload->data();
            $this->resizeImage_profile($uploadData['file_name']);
            $ext = pathinfo($_FILES['image_photo']['name'], PATHINFO_EXTENSION);
            $filename = 'assets_delivery/deliveryboy_image/' . $imageName . '.' . $ext;
            $updateData['image_photo'] = $filename;
        } else {
            $response['message'] = 'Image upload failed: ' . $this->upload->display_errors('', '');
            echo json_encode($response);
            return;
        }
    }

    // Update profile data
    $this->Apifooddeliveryboy_model->update_data('deliveryboy', 'deli_user_id', $user_id, $updateData);

    // Fetch updated record
    $record = $this->food_db->query("SELECT id, deli_user_id, image_photo FROM deliveryboy WHERE deli_user_id = ?", [$user_id]);
    $result = $record->row_array();

    $response = [
        'status'      => 'success',
        'statusCode'  => 200,
        'message'     => 'Profile updated successfully.',
        'record'      => [
            'id'           => $result['id'],
            'deli_user_id' => $result['deli_user_id'],
            'image_photo'  => DILIVERYBOYDOMAIN. $result['image_photo']
        ]
    ];

    echo json_encode($response);
}

      private function resizeImage_profile($filename) {
        $config['image_library']  = 'gd2';
        $config['source_image']   = './media/deliveryboy_image/' . $filename;
        // $config['maintain_ratio'] = TRUE;
        $config['maintain_ratio'] = FALSE;
        $config['width']          = 400;
        $config['height']         = 300;

        $this->load->library('image_lib', $config);
        $this->image_lib->resize();
    }
     
    
    
    
    public function apply_leave()
{
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json");

    // Decode raw JSON input
    $json  = file_get_contents("php://input");
    $input = json_decode($json, true);

    $deliveryboy_id = $input['deliveryboy_id'] ?? null;
    $from_date      = $input['from_date'] ?? null;
    $till_date      = $input['till_date'] ?? null;
    $reason         = $input['reason'] ?? null;

    // Validate required fields
    if (!$deliveryboy_id || !$from_date || !$till_date || !$reason) {
        echo json_encode([
            'status' => 'error',
            'statuscode' => 200,
            'message' => 'All fields are required'
        ]);
        return;
    }

    // Check if deliveryboy exists
    $this->db->where('deli_user_id', $deliveryboy_id);
    $deliveryboy = $this->food_db->get('deliveryboy')->row();

    if (!$deliveryboy) {
        echo json_encode([
            'status' => 'error',
            'statuscode' => 200,
            'message' => 'Invalid deliveryboy_id'
        ]);
        return;
    }
    
    
     $this->food_db->where('deliveryboy_id', $deliveryboy_id);
    $this->food_db->where('from_date <=', $till_date);
    $this->food_db->where('till_date >=', $from_date);
    $existing_leave = $this->food_db->get('deliveryboy_leave')->row();

    if ($existing_leave) {
        echo json_encode([
            'status' => 'error',
            'statuscode' => 200,
            'message' => 'Leave request already exists in this date range'
        ]);
        return;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    

    $creator_id = $deliveryboy->created_by; 
    
    
$c_ide = !empty($creator_id) ? $creator_id : 1;
$type  = !empty($creator_id) ? 'SELLER' : 'ADMIN';
    $data = [
        'deliveryboy_id' => $deliveryboy_id,
        'creator_id'     => $c_ide,
        'created_by_type' => $type ,
        'from_date'      => $from_date,
        'till_date'      => $till_date,
        'reason'         => $reason,
        'status'         => 'Pending'
    ];

    $this->food_db->insert('deliveryboy_leave', $data);

    echo json_encode([
        'status' => 'success',
        'statuscode' => 200,
        'message' => 'Leave request submitted'
    ]);
}


   public function leave_history()
{
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");

    $json = file_get_contents("php://input");
    $input = json_decode($json, true);

    $deliveryboy_id = $input['deliveryboy_id'] ?? null;
    $page           = isset($input['page']) ? max(1, (int)$input['page']) : 1;
    $limit          = isset($input['limit']) ? (int)$input['limit'] : 10;
    $offset         = ($page - 1) * $limit;

    if (!$deliveryboy_id) {
        echo json_encode([
            'status' => 'error',
            'statuscode' => 200,
            'message' => 'deliveryboy_id is required'
        ]);
        return;
    }


    // Check if deliveryboy exists
    $this->db->where('deli_user_id', $deliveryboy_id);
    $deliveryboy = $this->food_db->get('deliveryboy')->row();

    if (!$deliveryboy) {
        echo json_encode([
            'status' => 'error',
            'statuscode' => 200,
            'message' => 'Invalid deliveryboy_id'
        ]);
        return;
    }
    // Count total leaves
    $this->food_db->where('deliveryboy_id', $deliveryboy_id);
    $total_rows = $this->food_db->count_all_results('deliveryboy_leave');

    // Fetch paginated leave history
    $this->food_db->where('deliveryboy_id', $deliveryboy_id);
    $this->food_db->order_by('id', 'DESC');
    $this->food_db->limit($limit, $offset);
    $query = $this->food_db->get('deliveryboy_leave');
    $results = $query->result();

    $leave_list = [];
    foreach ($results as $row) {
        $leave_list[] = [
            'id'         => $row->id,
            'from_date'  => $row->from_date,
            'till_date'  => $row->till_date,
            'reason'     => $row->reason,
            'status'     => $row->status,
            'created_at' => $row->created_at ?? '' // if timestamp column exists
        ];
    }

    echo json_encode([
        'status' => 'success',
        'statuscode' => 200,
        'message' => 'Leave history fetched successfully',
        'data' => [
            'total' => $total_rows,
            'page' => $page,
            'limit' => $limit,
            'leave_history' => $leave_list
        ]
    ]);
}

    
    
    
    
    
    
    
    
    
    
    
    
    
    
public function delivery_cod_summary_old()
{
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");

    $input = json_decode($this->security->xss_clean(file_get_contents('php://input')));
    $user_id = $input->user_id ?? null;
    $page = isset($input->page) ? max(1, (int)$input->page) : 1;
    $limit = isset($input->limit) ? max(1, (int)$input->limit) : 10;
    $offset = ($page - 1) * $limit;

    if (empty($user_id)) {
        return $this->sendResponse('error', 400, 'User ID is required.');
    }

    $total_records = $this->Apifooddeliveryboy_model->cod_summary_count($user_id);
    $cod_summary = $this->Apifooddeliveryboy_model->cod_summary($user_id, $limit, $offset);

    $response = [];
    $response['list'] = [];

    if (!empty($cod_summary)) {
        foreach ($cod_summary as $i => $row) {
            $status = ($row['status'] == 1) ? 'Collected' : 'Pending';
            $response['list'][$i] = [
                'id'         => $row['id'],
                'dl_date'    => date("d-m-Y h:i:s a", strtotime(trim($row['created_at']))),
                'order_id'   => $row['order_id'],
                'order_date' => $row['order_place_date'],
                'status'     => $status,
                'amount'     => number_format($row['amout'], 2),
            ];
        }
    }

    $response['pagination'] = [
        'current_page'  => $page,
        'total_pages'   => ceil($total_records / $limit),
        'total_records' => $total_records
    ];

    $message = !empty($cod_summary) ? 'Data found' : 'Data Not Found.';
    return $this->sendResponse('success', 200, $message, $response);
}


public function delivery_wallet_summary()
{
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");

    $input = json_decode($this->security->xss_clean(file_get_contents('php://input')));
    $user_id = $input->user_id ?? null;
    $page = isset($input->page) ? max(1, (int)$input->page) : 1;
    $limit = isset($input->limit) ? max(1, (int)$input->limit) : 10;
    $offset = ($page - 1) * $limit;

    if (empty($user_id)) {
        return $this->sendResponse('error', 400, 'User ID is required.');
    }

    $total_records = $this->Apifooddeliveryboy_model->wallet_summary_count($user_id);
    $wallet_summary = $this->Apifooddeliveryboy_model->wallet_summary($user_id, $limit, $offset);

    $response = [];
    $response['list'] = [];

    if (!empty($wallet_summary)) {
        foreach ($wallet_summary as $i => $row) {
            $status = $row['credit'] ? 'CREDIT' : ($row['debit'] ? 'DEBIT' : '');
            $response['list'][$i] = [
                'id'              => $row['id'],
                'entry_date'      => date("d-m-Y h:i:s a", strtotime(trim($row['created']))),
                'order_id'        => $row['order_id'],
                'status'          => $status,
                'debit'           => number_format($row['debit'], 2),
                'credit'          => number_format($row['credit'], 2),
                'closing_amount'  => number_format($row['closing_balance'], 2),
                'descript'        => $row['descript'],
            ];
        }
    }

    $response['pagination'] = [
        'current_page'  => $page,
        'total_pages'   => ceil($total_records / $limit),
        'total_records' => $total_records
    ];

    $message = !empty($wallet_summary) ? 'Data found' : 'Data Not Found.';
    return $this->sendResponse('success', 200, $message, $response);
}


public function delivery_cod_summary()
{
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");

    $input = json_decode($this->security->xss_clean(file_get_contents('php://input')));
    $user_id = $input->user_id ?? null;
    $page = isset($input->page) ? max(1, (int)$input->page) : 1;
    $limit = isset($input->limit) ? max(1, (int)$input->limit) : 10;
    $offset = ($page - 1) * $limit;

    if (empty($user_id)) {
        return $this->sendResponse('error', 400, 'User ID is required.');
    }

    $total_records = $this->Apifooddeliveryboy_model->cod_summary_count($user_id);
    $cod_summary = $this->Apifooddeliveryboy_model->cod_summary($user_id, $limit, $offset);

    $response = [];
    $response['list'] = [];

    if (!empty($cod_summary)) {
        foreach ($cod_summary as $i => $row) {
            $status = ($row['status'] == 1) ? 'Collected' : 'Pending';
            $response['list'][$i] = [
                'id'         => $row['id'],
                'dl_date'    => date("d-m-Y h:i:s a", strtotime(trim($row['created_at']))),
                'order_id'   => $row['order_id'],
                'order_date' => $row['order_place_date'],
                'status'     => $status,
                'amount'     => number_format($row['amout'], 2),
            ];
        }
    }

    $response['pagination'] = [
        'current_page'  => $page,
        'total_pages'   => ceil($total_records / $limit),
        'total_records' => $total_records
    ];

    $message = !empty($cod_summary) ? 'Data found' : 'Data Not Found.';
    return $this->sendResponse('success', 200, $message, $response);
}






private function sendResponse($status, $statusCode, $message, $data = [])
{
    $response = [
        'status'     => $status,
        'statusCode' => $statusCode,
        'message'    => $message,
    ];

    if (!empty($data)) {
        $response = array_merge($response, $data);
    }

    echo json_encode($response);
    exit;
}


public function send_otp()
{
               header("Access-Control-Allow-Origin: *");
            header("Content-Type: application/json; charset=UTF-8");
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = inputJson();
    $rules = [
        ['field' => 'phone', 'label' => 'Mobile Number', 'rules' => 'required|trim|exact_length[10]|numeric']
    ];
    checkValidation($input, $rules);

    $phone = $input['phone'];
    $token=$input['fcm_token'] ?? null;

    // Check if phone exists
    $user = $this->food_db->where('mobile_no', $phone)->get('deliveryboy')->row();
    if (!$user) {
        outputJSON(200, 'error', 'Phone number does not exist.');
        return;
    }
    
  

    // Load OTP template
    $template = $this->food_db->where(['status' => 0, 'id' => 1])->get('sms_api_config')->row();
    if (!$template) {
        outputJSON(200, 'error', 'OTP template not found.');
        return;
    }

    // Generate OTP
    $otp = sprintf("%06d", mt_rand(0, 999999));
    $otp = 123456 ;
    $user_name = !empty($user->name) ? str_replace(' ', '', $user->name) : 'DeliveryBoy';

    // Prepare API URL
    $number = $phone;
    $api_url = $this->get_api_url();
    $api_url = str_replace(['mobile_number', 'user_name', 'otp_now'], [urlencode($number), urlencode($user_name), $otp], $api_url);

    // Save/Update OTP in database
    $otpData = [
        'phone' => $phone,
        'otp' => $otp,
        'status' => 0,
        'updated_at' => date('Y-m-d H:i:s')
    ];

    if ($this->food_db->where('phone', $phone)->get('all_otp')->num_rows() > 0) {
        $this->food_db->update('all_otp', $otpData, ['phone' => $phone]);
    } else {
        $this->food_db->insert('all_otp', $otpData);
    }

    // Send OTP via SMS
   $api_response = $this->send_request($api_url);
    $this->food_db->update('deliveryboy', ['f_token_app'=>$token], ['mobile_no'=>$phone]);
if ($api_response && strpos(strtolower($api_response), 'success') !== false) {
    outputJSON(200, 'success', 'OTP sent successfully.', ['otp' => $otp]);
} else {
    outputJSON(200, 'success', 'OTP sent successfully.', ['otp' => $otp]);
    // outputJSON(500, 'error', 'Failed to send OTP.', ['api_response' => $api_response]);
}


}


public function update_fcm()
{
               header("Access-Control-Allow-Origin: *");
            header("Content-Type: application/json; charset=UTF-8");
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = inputJson();
    $rules = [
        ['field' => 'user_id', 'label' => 'User ID', 'rules' => 'required'],
        ['field' => 'fcm_token', 'label' => 'FCM Token', 'rules' => 'required']
    ];
    checkValidation($input, $rules);

    $user_id = $input['user_id'];
    $token=$input['fcm_token'] ?? null;

    // Check if phone exists
    $user = $this->food_db->where('id', $user_id)->get('deliveryboy')->row();
    if (!$user) {
        outputJSON(200, 'error', 'User does not exist.');
        return;
    }
    
  
    $res=$this->food_db->update('deliveryboy', ['f_token_app'=>$token], ['id'=>$user_id]);
    if ($res) {
        outputJSON(200, 'success', 'FCM Token updated successfully.');
    } else {
        outputJSON(500, 'error', 'Failed to update FCM Token.');
    }

}

// Get SMS API URL
private function get_api_url()
{
    $query = $this->food_db->get('sms_api_config', 1);
    return $query->row()->api_url;
}

// Send HTTP request
private function send_request($url)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

	
	
	
	 public function verify_otp()
	 {
		if (strtoupper($this->input->method()) !== 'POST') {
			outputJSON(405, 'error', 'Invalid request method. Please use POST.');
			return;
		}
		$input = inputJson();
		$rules = [
			['field' => 'phone', 'label' => 'Mobile Number', 'rules' => 'required|trim|exact_length[10]|numeric'],
			['field' => 'otp', 'label' => 'OTP', 'rules' => 'required|trim']
		];
		checkValidation($input,$rules);
		$phone=$input['phone'];
		$otp=$input['otp'];

		$check = $this->food_db->where('mobile_no', $phone)->get('deliveryboy')->num_rows();
		if($check==0){
			outputJSON(200, 'error', 'Invalid User mobile number, Record not found.');
			return;
		}

		$otpQuery = "SELECT * FROM all_otp WHERE phone = ? AND otp = ? AND status = 0";
		$otpRecord = $this->food_db->query($otpQuery, [$phone, $otp])->row();

		if (!$otpRecord) {
			outputJSON(200, 'error', 'Incorrect otp.');
			return;
		}

		$otpTime = strtotime($otpRecord->updated_at);
		$currentTime = time();
		$expiryTime = 10 * 60;

		if (($currentTime - $otpTime) > $expiryTime) {
			outputJSON(200, 'error', 'OTP has expired. Please request a new one.');
			return;
		}

		$this->food_db->update('all_otp', ['status' => 1], ['phone' => $phone, 'otp' => $otp]);

		$userRecord = $this->food_db->get_where('deliveryboy', ['mobile_no'=>$phone])->row();
       
      
	   $response = [
			'id' => (int)$userRecord->id,
			'deliveryboy_id' => $userRecord->deli_user_id,
			'name' => $userRecord->name,
			'email' => $userRecord->email_id,
			'phone' => $userRecord->mobile_no,
			
		];

		outputJSON(200, 'success', 'Login successfully',$response);
		return;
	}
	
	
	
public function toggle_deliverboy_status()
{
    if (strtoupper($this->input->method()) !== 'POST') {
        return outputJSON(405, 'error', 'Invalid request method. Please use POST method.');
    }

    $input = inputJson();
    $this->form_validation->set_data($input);

    $this->form_validation->set_rules([
        ['field' => 'deli_user_id', 'label' => 'Delivery Boy ID', 'rules' => 'required|trim'],
        ['field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim|in_list[0,1]']
    ]);

    if (!$this->form_validation->run()) {
        return outputJSON(400, 'error', validation_errors());
    }

    $del_id = $this->security->xss_clean($input['deli_user_id']);
    $new_status = $this->security->xss_clean($input['is_active']);

    // Check if delivery boy exists
    $deliveryboy = $this->food_db->get_where('deliveryboy', ['deli_user_id' => $del_id])->row();
    if (!$deliveryboy) {
        return outputJSON(404, 'error', 'Invalid DeliveryBoy ID. DeliveryBoy not found.');
    }

    // Update status
    $updated = $this->food_db
        ->where('deli_user_id', $del_id)
        ->update('deliveryboy', ['is_online' => $new_status]);

    if ($updated) {
        $statusText = $new_status == 1 ? 'Online' : 'Offline';
        return outputJSON(200, 'success', "User is now $statusText.");
    } else {
        return outputJSON(500, 'error', 'Failed to update DeliveryBoy status.');
    }
}

// 
	
public function manage_order_status()
{
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = inputJson();

    $rules = [
        ['field' => 'user_id',          'label' => 'User ID',          'rules' => 'required'],
        ['field' => 'pay_id',           'label' => 'Payment ID',       'rules' => 'required|trim|numeric'],
        ['field' => 'action',           'label' => 'Action',           'rules' => 'required|in_list[0,1]'],
        ['field' => 'rejected_reason',  'label' => 'Rejection Reason', 'rules' => 'trim']
    ];

    checkValidation($input, $rules);

    $user_id = $input['user_id'];
    $pay_id  = $input['pay_id'];
    $action  = intval($input['action']);
    $reason  = $input['rejected_reason'] ?? null;

    // Validate the order status before action
    $order = $this->food_db
        ->where(['payid' => $pay_id, 'deliveryboy_id' => $user_id, 'status' => 0])
        ->get('product_trasfer_delivery')
        ->row();
        
        

    if (!$order) {
        outputJSON(200, 'success', 'Order already processed or invalid.');
        return;
    }
    $userid=$order->seller_id;
    $seller_row=$this->food_db->query("SELECT * FROM seller WHERE seller_id='$userid'")->row();
    if($action === 0 ){
                      
        if(!empty($seller_row))
        {
            if($seller_row->f_token_web)
            {
                $title = "Delivery Partner Declined Your Order";
                $body  = "Delivery for Order #".$order->order_id." was rejected by the partner. Please take action.";

                $this->firebase->send($seller_row->f_token_web,$title,$body);
            }
            if($seller_row->f_token_app)
            {
                $title = "Delivery Partner Declined Your Order";
                $body  = "Delivery for Order #".$order->order_id." was rejected by the partner. Please take action.";
                $this->firebase->send($seller_row->f_token_app,$title,$body);
                
            }
        }
        // Reject the order
        if (empty($reason)) {
            outputJSON(400, 'error', 'Rejection reason is required.');
            return;
        }

        $this->Apideliveryboy_model->update_data('product_trasfer_delivery', 'payid', $pay_id, [
            'status' => 2,
            'rejected_date' => date('Y-m-d H:i:s'),
            'rejected_reason' => $reason
        ]);

        outputJSON(200, 'success', 'Order Rejected Successfully.');

    
    }

    if ($action === 1) {
        // Accept the order
        $delivery_pin = random_int(100000, 999999);
        
        $this->Apideliveryboy_model->update_data('product_trasfer_delivery', 'payid', $pay_id, [
            'status' => 1
        ]);

        $this->Apideliveryboy_model->update_data('payment_details', 'id', $pay_id, [
            'order_status' => 'S',
            'delivery_pin' => $delivery_pin
        ]);

        $this->Apideliveryboy_model->update_data('product_placed', 'payment_id', $pay_id, [
            'product_status' => 'S',
            'shipped_date' => date('Y-m-d H:i:s')
        ]);
        $user_id=$order->seller_id;
        $user=$this->food_db->query("SELECT * FROM users WHERE id='$user_id'")->row();
        $delivery=$this->food_db->query("SELECT * FROM deliveryboy WHERE deli_user_id='$order->deliveryboy_id'")->row();
        if(!empty($user))
        {
            if($user->f_token_web)
            {
                $title = "Delivery Partner Assigned";
                $body  = "Your order #".$order->order_id." has been accepted by ".$delivery->name.". It will be picked up soon.";

                $this->firebase->send($user->f_token_web,$title,$body);
            }
            if($user->f_token_app)
            {
                $title = "Delivery Partner Assigned";
                $body  = "Your order #".$order->order_id." has been accepted by ".$delivery->name.". It will be picked up soon.";
                $this->firebase->send($user->f_token_app,$title,$body);
                
            }
        }
        if(!empty($seller_row))
        {
            if($seller_row->f_token_web)
            {
                $title = "Delivery Partner Accepted Your Order";
                $body  = "Good news! Order #".$order->order_id." is accepted and will be picked up soon by delivery boy";

                $this->firebase->send($seller_row->f_token_web,$title,$body);
            }
            if($seller_row->f_token_app)
            {
                $title = "Delivery Partner Accepted Your Order";
                $body  = "Good news! Order #".$order->order_id." is accepted and will be picked up soon by delivery boy";
                $this->firebase->send($seller_row->f_token_app,$title,$body);
                
            }
        }
        outputJSON(200, 'success', 'Order Accepted Successfully.', ['delivery_pin' => $delivery_pin]);
    } 
}


  public function register_deliveryboy_old()
{
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = inputJson();

    $rules = [
        ['field' => 'name',     'label' => 'Name',     'rules' => 'required|trim'],
        ['field' => 'email',    'label' => 'Email',    'rules' => 'required|trim|valid_email'],
        ['field' => 'phone',    'label' => 'Phone',    'rules' => 'required|trim|numeric|exact_length[10]'],
        ['field' => 'pincode',  'label' => 'PinCode',  'rules' => 'required|trim|numeric|exact_length[6]'],
        ['field' => 'address',  'label' => 'Address',  'rules' => 'required|trim']
    ];

    checkValidation($input, $rules);

    // Check if email or phone already exists
    $this->food_db->where('mobile_no', $input['phone']);
    $this->food_db->or_where('email_id', $input['email']);
    $exists = $this->food_db->get('deliveryboy')->num_rows();

    if ($exists > 0) {
        outputJSON(200, 'error', 'Delivery boy already registered with this phone or email.');
        return;
    }

    // Step 1: Insert basic data first without user_id
    $data = [
        'name'         => $input['name'],
        'email_id'     => $input['email'],
        'mobile_no'    => $input['phone'],
        'address'      => $input['address'],
        'pin_code'     => $input['pincode'],
        'status'       => 1,
        'created_date' => date('Y-m-d H:i:s')
    ];

    $this->food_db->insert('deliveryboy', $data);
    $delivery_id = $this->food_db->insert_id();

    // Step 2: Create a unique deli_user_id using the inserted ID
    $deli_user_id = 'DELVRYSEL' . str_pad($delivery_id, 5, '0', STR_PAD_LEFT);

    // Step 3: Update record with deli_user_id
    $this->food_db->where('id', $delivery_id);
    $this->food_db->update('deliveryboy', ['deli_user_id' => $deli_user_id]);

    // Prepare response
    $response = [
        'delivery_id'   => $delivery_id,
        'deli_user_id'  => $deli_user_id,
        'name'          => $input['name'],
        'email'         => $input['email'],
        'phone'         => $input['phone'],
        'address'       => $input['address'],
        'status'        => 1,
        'registered_on' => date('d M Y H:i:s')
    ];

    outputJSON(200, 'success', 'Delivery Boy registered successfully.', $response);
}

	
	
	
public function register_deliveryboy()
{
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = $this->input->post();

    $rules = [
        ['field' => 'name',     'label' => 'Name',     'rules' => 'required|trim'],
        ['field' => 'email',    'label' => 'Email',    'rules' => 'required|trim|valid_email'],
        ['field' => 'phone',    'label' => 'Phone',    'rules' => 'required|trim|numeric|exact_length[10]'],
        ['field' => 'pincode',  'label' => 'PinCode',  'rules' => 'required|trim|numeric|exact_length[6]'],
        ['field' => 'address',  'label' => 'Address',  'rules' => 'required|trim']
    ];

    checkValidation($input, $rules);

    // Check if phone or email already exists
    $this->food_db->where('mobile_no', $input['phone']);
    $this->food_db->or_where('email_id', $input['email']);
    $exists = $this->food_db->get('deliveryboy')->num_rows();

    if ($exists > 0) {
        outputJSON(200, 'error', 'Delivery boy already registered with this phone or email.');
        return;
    }

    // Validate that all required files are uploaded
    if (empty($_FILES['aadhaar_doc']['name'])) {
        outputJSON(400, 'error', 'Aadhaar document is required.');
        return;
    }
    if (empty($_FILES['profile_image']['name'])) {
        outputJSON(400, 'error', 'Profile image is required.');
        return;
    }
    if (empty($_FILES['licence_doc']['name'])) {
        outputJSON(400, 'error', 'Licence document is required.');
        return;
    }

    // File upload paths
    $upload_path = 'assets_delivery/deliveryboy_doc/';
    $upload_path_profile = 'assets_delivery/deliveryboy_image/';
    $aadhaar_doc = '';
    $vehicle_doc = '';
    $profile_img = '';

    // Upload Aadhaar
    $aadhaar_doc = $this->_upload_document('aadhaar_doc', $upload_path, 'aadhaar');
    if (!$aadhaar_doc) return;

    // Upload Profile Image
    $profile_img = $this->_upload_document('profile_image', $upload_path_profile, 'profile');
    if (!$profile_img) return;

    // Upload Licence Doc
    $vehicle_doc = $this->_upload_document('licence_doc', $upload_path, 'licence');
    if (!$vehicle_doc) return;

    // Prepare and insert data
    $data = [
        'name'          => $input['name'],
        'email_id'      => $input['email'],
        'mobile_no'     => $input['phone'],
        'address'       => $input['address'],
        'pin_code'      => $input['pincode'],
        'aadhar_doc'    => $aadhaar_doc,
        'image_photo'   => $profile_img,
        'licence_doc'   => $vehicle_doc,
        'status'        => 1,
        'created_date'  => date('Y-m-d H:i:s')
    ];

    $this->food_db->insert('deliveryboy', $data);
    $delivery_id = $this->food_db->insert_id();

    $deli_user_id = 'DELVRYSEL' . str_pad($delivery_id, 5, '0', STR_PAD_LEFT);

    $this->food_db->where('id', $delivery_id);
    $this->food_db->update('deliveryboy', ['deli_user_id' => $deli_user_id]);

    $response = [
        'delivery_id'   => $delivery_id,
        'deli_user_id'  => $deli_user_id,
        'name'          => $input['name'],
        'email'         => $input['email'],
        'phone'         => $input['phone'],
        'address'       => $input['address'],
        'aadhaar_doc'   => $aadhaar_doc,
        'vehicle_doc'   => $vehicle_doc,
        'profile_image' => $profile_img,
        'status'        => 1,
        'registered_on' => date('d M Y H:i:s')
    ];

    outputJSON(200, 'success', 'Delivery Boy registered successfully.', $response);
}


	
	
	
	private function _upload_document($field, $path, $prefix)
{
    $config['upload_path']   = $path;
    $config['allowed_types'] = 'jpg|jpeg|png|pdf';
    $config['max_size']      = 5120; // 5MB
    $config['file_name']     = $prefix . '_' . time();

    $this->load->library('upload', $config);

    if (!$this->upload->do_upload($field)) {
        outputJSON(400, 'error', $this->upload->display_errors('', ''));
        return false;
    }

    $upload_data = $this->upload->data();
    return $path . $upload_data['file_name'];
}

	
	
	
	
	
	
	
	
	
	
	
// delivery boy home page function start from here----------


// function for having  delivery boy

public function order_view()
{
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = inputJson();

    $rules = [
        ['field' => 'payid', 'label' => 'Payment ID', 'rules' => 'required|trim']
    ];
    checkValidation($input, $rules);

   
    $order_data = $this->Deliveryboy_model->get_order_summary($input['payid']);

    if (!$order_data) {
        outputJSON(200, 'error', 'Order not found');
        return;
    }

    outputJSON(200, 'success', 'Order summary fetched successfully', $order_data);
}








// 
	
public function deliveryboy_dashboard()
{
    
    
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = inputJson();
    $deliveryboy_id = $input['deliveryboy_id'] ?? null;

    if (!$deliveryboy_id) {
        outputJSON(400, 'error', 'Delivery Boy ID is required.');
        return;
    }

    // Validate deliveryboy existence
    $deliveryboy = $this->Deliveryboy_model->getRow('deliveryboy', ['deli_user_id' => $deliveryboy_id]);
    if (!$deliveryboy) {
        outputJSON(404, 'error', 'Delivery Boy not found.');
        return;
    }

$is_online = $deliveryboy['is_online'] ?? 0;
    // Show more flags for sections
    $show_more = [
        'new' => $input['show_more_new_orders'] ?? false,
        
    ];

    $limit = 2;
    $max = 10;

    // Fetch data
    $dashboard = $this->Deliveryboy_model->getDashboardCounts($deliveryboy_id);
    $services = $this->Deliveryboy_model->getActiveServices();
    
    $new_orders = array_slice($this->Deliveryboy_model->getOrdersByStatus($deliveryboy_id, 0), 0, $max);
   
    $response = [
        'is_active' => $is_online ,
        'dashboard' => $dashboard,
        'services' => $services,

        'new_orders' => $this->formatOrdersSection($new_orders, $show_more['new'], $limit),
       
    ];

    outputJSON(200, 'success', 'Dashboard data loaded successfully.', $response);
}

private function formatOrdersSection($orders, $show_more, $limit)
{
    return [
        'count' => count($orders),
        'data' => $show_more ? $orders : array_slice($orders, 0, $limit),
        'has_more' => !$show_more && count($orders) > $limit,
        'more_count' => max(0, count($orders) - $limit),
    ];
}

//  servicewise dashboards
public function service_based_delivery_olddd()
{
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = inputJson();
    $deliveryboy_id = $input['deliveryboy_id'] ?? null;
    $service_id = $input['service_id'] ?? null;

    if (!$deliveryboy_id || !$service_id) {
        outputJSON(400, 'error', 'Delivery Boy ID  and service id is required.');
        return;
    }

    // Validate deliveryboy existence
    $deliveryboy = $this->Deliveryboy_model->getRow('deliveryboy', ['deli_user_id' => $deliveryboy_id]);
    if (!$deliveryboy) {
        outputJSON(404, 'error', 'Delivery Boy not found.');
        return;
    }

    // Common pagination
    $page = isset($input['page']) ? (int)$input['page'] : 1;
    $limit = isset($input['limit']) ? (int)$input['limit'] : 10;
    $offset = ($page - 1) * $limit;

    // Get dashboard stats and services
    $dashboard = $this->Deliveryboy_model->getDashboardCounts($deliveryboy_id,$service_id);
   

    // Get paginated orders by status
    $new_orders = $this->Deliveryboy_model->getOrdersByStatus_New($deliveryboy_id, 0,$service_id , $limit, $offset);
    $ongoing_orders = $this->Deliveryboy_model->getOrdersByStatus_New($deliveryboy_id, 1,$service_id , $limit, $offset);
    $completed_orders = $this->Deliveryboy_model->getOrdersByStatus_New($deliveryboy_id, 3,$service_id , $limit, $offset);
     $reject_orders = $this->Deliveryboy_model->getOrdersByStatus_New($deliveryboy_id, 2,$service_id , $limit, $offset);
    // Count total for each status
    $total_new = $this->Deliveryboy_model->countOrdersByStatus($deliveryboy_id, 0,$service_id);
    $total_ongoing = $this->Deliveryboy_model->countOrdersByStatus($deliveryboy_id, 1,$service_id);
    $total_completed = $this->Deliveryboy_model->countOrdersByStatus($deliveryboy_id, 3,$service_id);
    
    $total_rejected = $this->Deliveryboy_model->countOrdersByStatus($deliveryboy_id, 2,$service_id);
    
    
    
    $response = [
    'dashboard' => $dashboard,
    'orders' => [
        [
            'title' => 'New',
            'count' => $total_new,
            'list'  => $new_orders
        ],
        [
            'title' => 'Ongoing',
            'count' => $total_ongoing,
            'list'  => $ongoing_orders
        ],
        [
            'title' => 'Completed',
            'count' => $total_completed,
            'list'  => $completed_orders
        ],
        [
            'title' => 'Cancel',
            'count' => $total_rejected,
            'list'  => $reject_orders
        ]
    ],
    'pagination' => [
        'page' => $page,
        'limit' => $limit,
        'total' => $total_new + $total_ongoing + $total_completed + $total_rejected // or optionally, make this status-wise if needed
    ]
];

    
    


    outputJSON(200, 'success', 'Dashboard data loaded successfully.', $response);
}

public function service_based_delivery()
{
    if (strtoupper($this->input->method()) !== 'POST') {
        outputJSON(405, 'error', 'Invalid request method. Please use POST.');
        return;
    }

    $input = inputJson();
    $deliveryboy_id = $input['deliveryboy_id'] ?? null;
    $service_id = $input['service_id'] ?? null;
    $data_type = strtolower($input['data_type'] ?? 'new'); // new, ongoing, completed, cancel, or all

    if (!$deliveryboy_id || !$service_id) {
        outputJSON(400, 'error', 'Delivery Boy ID and Service ID are required.');
        return;
    }

    // Validate deliveryboy existence
    $deliveryboy = $this->Deliveryboy_model->getRow('deliveryboy', ['deli_user_id' => $deliveryboy_id]);
    if (!$deliveryboy) {
        outputJSON(404, 'error', 'Delivery Boy not found.');
        return;
    }

    // Pagination
    $page = isset($input['page']) ? (int)$input['page'] : 1;
    $limit = isset($input['limit']) ? (int)$input['limit'] : 10;
    $offset = ($page - 1) * $limit;

    $dashboard = $this->Deliveryboy_model->getDashboardCounts($deliveryboy_id, $service_id);
    
   $new =  $dashboard['new_order']  ;
  $ongoing =   $dashboard['ongoing_order']  ;
   $complete =   $dashboard['completed_order']  ;
   $cancel =  $dashboard['cancel_order']  ;

    // Initialize response structure
    $orders = [];
    $total = 0;

    // Helper function to push data for a type
    $addOrderData = function($title, $status_code) use (&$orders, &$total, $deliveryboy_id, $service_id, $limit, $offset) {
        $list = $this->Deliveryboy_model->getOrdersByStatus_New($deliveryboy_id, $status_code, $service_id, $limit, $offset);
        $count = $this->Deliveryboy_model->countOrdersByStatus($deliveryboy_id, $status_code, $service_id);
        $total += $count;
        $orders = [
            'title' => ucfirst($title),
            'count' => $count,
            'list'  => $list
        ];
    };

    // Load data based on type
    switch ($data_type) {
        case 'new':
            $addOrderData('new', 0);
            break;
        case 'ongoing':
            $addOrderData('ongoing', 1);
            break;
        case 'completed':
            $addOrderData('completed', 3);
            break;
        case 'cancel':
        case 'cancelled':
        case 'rejected': // Accept alias
            $addOrderData('cancel', 2);
            break;
        case 'all':
        default:
            $addOrderData('new', 0);
            $addOrderData('ongoing', 1);
            $addOrderData('completed', 3);
            $addOrderData('cancel', 2);
            break;
    }

    $response = [
        'dashboard' => $dashboard,
         'tabs' => [
    ['name' => 'new', 'count' => (int)$new],
    ['name' => 'assign', 'count' => (int)$ongoing],
  
    ['name' => 'completed', 'count' => (int)$complete],
  
      ['name' => 'reject', 'count' => (int)$cancel],
 
] ,
        'orders' => $orders,
        'pagination' => [
            'page' => $page,
            'limit' => $limit,
            'total' => $total
        ]
    ];

    outputJSON(200, 'success', 'Dashboard data loaded successfully.', $response);
}



    
// //////////////////////// delivery boy home page function end here
    

}

