<?php


class Lib_model extends CI_Model
{
    /*
     * Construct
     */
	public function __construct()
    {
        parent::__construct();
         $this->db = $this->load->database('grocery_database', TRUE);    
    }

    /*
     *  Select Records From Table
     */
    public function Select($Table, $Fields = '*', $Where = 1 , $order_by = '')
    {
        /*
         *  Select Fields
         */
        if ($Fields != '*') {
            $this->db->select($Fields);
        }
        /*
         *  IF Found Any Condition
         */
        if ($Where != 1) {
            $this->db->where($Where);
        }
        if (!empty($order_by)) {
        $this->db->order_by($order_by, "DESC");
        }
        /*
         * Select Table
         */
        $query = $this->db->get($Table);

        /*
         * Fetch Records
         */

        return $query->result();
    }

    /*
     *  Select One Col  From Table
     */
    public function Select_Single($Table, $Fields = '*', $Where = 1)
    {
        /*
         *  Select Fields
         */
        if ($Fields != '*') {
            $this->db->select($Fields);
        }
        /*
         *  IF Found Any Condition
         */
        if ($Where != 1) {
            $this->db->where($Where);
        }
        /*
         * Select Table
         */
        $query = $this->db->get($Table);
        /*
         * Fetch Records
         */
        $rs = $query->result();
        foreach ($rs as $r) {
            $Name = $r->$Fields;
        }

        return $Name;
    }

    /*
     * Count No Rows in Table
     */
    public function Counter($Table, $Where = 1)
    {
        $rows = $this->Select($Table, '*', $Where);

        return count($rows);
    }

    /*
     * Insert
     */
    public function Insert($table, $f)
    {
        $query = $this->db->insert($table, $f);
        if ($query) {
            $insert_id = $this->db->insert_id();

            return $insert_id;
        } else {
            return false;
        }
    }
    
    
    //sachin code
    public function get_all_refund_or_reversal_data($table,$check)
    {
        
        $this->db->from($table);
        $this->db->where($check);
        $this->db->order_by("id", "desc");
        $query = $this->db->get(); 
        return $query->result_array();
        
        // $this->db->where($check);
        // $query = $this->db->get($table)->result_array();
        // return $query;
    }
    
    public function update_customer_refund($table,$check,$update_data)
    {
        $this->db->where($check);
        if($this->db->update($table,$update_data)):
        return 1; 
        endif;    
        return 0;
    }
    
     public function get_all_cust_req($table)
    {
        
        $query = $this->db->get($table);
        $result = $query->result_array();
        return $result;
    }
    





    /*
     *  UPDATE
     */
     
    public function common_update($table,$checkarray,$data)
    {
       $this->db->where($checkarray);
        if($this->db->update($table,$data)):
        return 1; 
        endif;    
        return 0; 
    
    }
     
    public function Update($table, $f, $w = 0)
    {
        if ($w != 0) {
            $this->db->where($w);
        }
        $query = $this->db->update($table, $f);
        if ($query) {
            return true;
        } else {
            return false;
        }
    }
    
    //sachin code
    public function update_data_on_user_id_or_order_no($check_array,$update_data,$table)
    {
        $this->db->where($check_array);
		if($this->db->update($table,$update_data)):
		return 1; 
		endif;    
		return 0;    
        
    }
    
    //sachin code ends

    /*
     * DELETE
     */
    public function Delete($table, $w = 0)
    {
        if ($w != 0) {
            $this->db->where($w);
        }
        $query = $this->db->delete($table);
        if ($query) {
            return true;
        } else {
            return false;
        }
    }

    /*
     * Direct Query Execution
     */
    public function Execute($q, $w = array())
    {
       $a = strtoupper($q) ;
        if ( (strpos($a, 'drop') !== false) || (strpos($a, 'DROP') !== false)) {
   print_r('not allowed') ; exit;
        }
        if ( (strpos($a, 'alter') !== false) || (strpos($a, 'ALTER') !== false)) {
           print_r('not allowed') ; exit;
            }
        if ( (strpos($a, 'truncate') !== false) || (strpos($a, 'TRUNCATE') !== false) ) {
           print_r('not allowed') ; exit;
        }
        
        $query = $this->db->query($q, $w);
        if ($query) {
            return $query;
        } else {
            return false;
        }
    }

    /*
     * Insert Multiple Records
     */
    public function Insert_Batch($table, $f)
    {
        $query = $this->db->insert_batch($table, $f);
        if ($query) {
            return true;
        } else {
            return false;
        }
    }

    /*
     * Fetch DaysBetweenTwoDates
     */
    public function DBTD($startDate, $endDate)
    {
        $sql = "SELECT DATEDIFF(day,'" . $startDate . "','" . $endDate . "')+1 AS Day";
        $rs = $this->Execute($sql)->result();
        foreach ($rs as $r) {
            return $r->Day;
        }
    }

    /*
     *  Taken Leave
     */
    public function LeaveTaken($EmpId = 0)
    {
        /*
         * By Default Self Leave
         */
        if ($EmpId == 0) {
            $EmpId = $this->session->EmpId;
        }
        /*
         * Session Management
         */
        if (SessionId % 2 == 0) {
            $sessions = SessionId . "," . (SessionId - 1);
        } else {
            $sessions = SessionId;
        }
        /*
         * CL
         */
        $sql1 = "SELECT sum(Nod) AS Nod FROM M_HRM_Leave_Request WHERE EmpId=? AND isSELF=1 AND isDIR IN (1,-1) AND LeaveType=1 AND  Session IN ($sessions) ";
        $rs1 = $this->Execute($sql1, array($EmpId))->result();
        foreach ($rs1 as $r) {
            $CL = $r->Nod;
        }

        /*
        * VL
        */

        $sql1 = "SELECT sum(Nod) AS Nod FROM M_HRM_Leave_Request WHERE EmpId=? AND isSELF=1 AND isDIR IN (1,-1) AND LeaveType=10 AND  Session IN ($sessions) ";
        $rs1 = $this->Execute($sql1, array($EmpId))->result();
        foreach ($rs1 as $r) {
            $VL = $r->Nod;
        }

        /*
         * Category Id
         */
        $rs2 = $this->lib_model->Select('M_Employee', 'Category', array('EmpID' => $EmpId));
        foreach ($rs2 as $r2) {
            $Category = $r2->Category;
        }

        if (in_array($Category, array(2, 11))) {
            return (float)$Total = $CL + $VL / 2;

        } else {
            return (int)$Total = $CL + $VL / 1.5;
        }


    }

    /*
    *  Taken Leave
    */
    public function LeaveTakenVL($EmpId = 0)
    {
        /*
         * By Default Self Leave
         */
        if ($EmpId == 0) {
            $EmpId = $this->session->EmpId;
        }
        /*
         * Session Management
         */
        if (SessionId % 2 == 0) {
            $sessions = SessionId . "," . (SessionId - 1);
        } else {
            $sessions = SessionId;
        }

        /*
         * VL
         */
        $VL = 0;
        $sql1 = "SELECT sum(Nod) AS Nod FROM M_HRM_Leave_Request WHERE EmpId=? AND isSELF=1 AND isDIR IN (1,-1) AND LeaveType=10 AND  Session IN ($sessions) ";
        $rs1 = $this->Execute($sql1, array($EmpId))->result();
        foreach ($rs1 as $r) {
            $VL = $r->Nod;
        }

        return (float)$Total = $VL;
    }

    /*
     * Max Leave Date of Join
     */
    public function MaxLeaveDOJ($EmpId = 0)
    {
        /*
         * By Default Self Leave
         */
        if ($EmpId == 0) {
            $EmpId = $this->session->EmpId;
        }
        /*
         * Date of Joining
         */
        $sql = "SELECT DateOfJoin FROM M_Employee WHERE EmpID=?";
        $rs = $this->Execute($sql, array($EmpId))->result();
        foreach ($rs as $r) {
            $DOJ = $r->DateOfJoin;
        }
        /*
         * Check 1 year Complete Session Start
         */
        if (strtotime($DOJ) > strtotime('7/1/2016')) {
            if (strtotime($DOJ) < strtotime('7/1/2017')) {
                $MaxLeave = 12;
            } else {
                $DOM = date('m', strtotime($DOJ));
                $DOD = date('d', strtotime($DOJ));
                /*
                 * Leave Manage Joiningwise
                 */
                switch ($DOM) {
                    case 1:
                        $MaxLeave = 6;
                        break;
                    case 2:
                        $MaxLeave = 5;
                        break;
                    case 3:
                        $MaxLeave = 4;
                        break;
                    case 4:
                        $MaxLeave = 3;
                        break;
                    case 5:
                        $MaxLeave = 2;
                        break;
                    case 6:
                        $MaxLeave = 1;
                        break;
                    case 7:
                        $MaxLeave = 12;
                        break;
                    case 8:
                        $MaxLeave = 11;
                        break;
                    case 9:
                        $MaxLeave = 10;
                        break;
                    case 8:
                        $MaxLeave = 9;
                        break;
                    case 7:
                        $MaxLeave = 8;
                        break;
                    case 6:
                        $MaxLeave = 7;
                        break;
                }
                /*
                 * After 10 Joining did not receive Cl for Current Month
                 */
                if ($DOD > 10) {
                    $MaxLeave--;
                }
            }
        } else {
            $MaxLeave = 14;
        }

        return $MaxLeave;
    }

    /*
     * Max Leave Date of Join
     */
    public function MaxLeave($EmpId = 0)
    {
        $Doj = '7/1/2017';
        $LeaveYear = '17-18';
        $rs = $this->lib_model->Select('M_HRM_Leave_Request_Mgmt', 'TotalMax as Max', array('EmpId' => $EmpId, 'Session' => SessionId, 'LeaveType' => 1));
        if ($rs) {
            foreach ($rs as $r) {
                $MaxLeave = $r->Max;
            }
        } else {
            if (SessionId % 2 == 0) {
                $sql = "Sp_Employee_Leave_Mgmt_Even_CL_Emp ?,?,?,?";
                $this->lib_model->Execute($sql, array($Doj, SessionId, $LeaveYear, $EmpId));
            } else {
                $sql = "Sp_Employee_Leave_Mgmt_Odd_CL_Emp ?,?,?,?";
                $this->lib_model->Execute($sql, array($Doj, SessionId, $LeaveYear, $EmpId));
            }
            $rs = $this->lib_model->Select('M_HRM_Leave_Request_Mgmt', 'TotalMax as Max', array('EmpId' => $EmpId, 'Session' => SessionId, 'LeaveType' => 1));
            foreach ($rs as $r) {
                $MaxLeave = $r->Max;
            }
        }

        return $MaxLeave;
    }

    /*
    * Max Leave
    */
    public function MaxLeaveABC($EmpId = 0)
    {
        /*
         * By Default Self Leave
         */
        if ($EmpId == 0) {
            $EmpId = $this->session->EmpId;
        }
        /*
         * Date of Joining
         */
        $sql = "SELECT DateOfJoin FROM M_Employee WHERE EmpID=?";
        $rs = $this->Execute($sql, array($EmpId))->result();
        foreach ($rs as $r) {
            $DOJ = $r->DateOfJoin;
        }
        /*
         * Check 1 year Complete Session Start
         */
        if (strtotime($DOJ) > strtotime('7/1/2016')) {
            if (strtotime($DOJ) < strtotime('7/1/2017')) {
                $MaxLeave = 12;
            } else {
                $DOM = date('m', strtotime($DOJ));
                $DOD = date('d', strtotime($DOJ));
                /*
                 * Leave Manage Joiningwise
                 */
                switch ($DOM) {
                    case 1:
                        $MaxLeave = 6;
                        break;
                    case 2:
                        $MaxLeave = 5;
                        break;
                    case 3:
                        $MaxLeave = 4;
                        break;
                    case 4:
                        $MaxLeave = 3;
                        break;
                    case 5:
                        $MaxLeave = 2;
                        break;
                    case 6:
                        $MaxLeave = 1;
                        break;
                    case 7:
                        $MaxLeave = 12;
                        break;
                    case 8:
                        $MaxLeave = 11;
                        break;
                    case 9:
                        $MaxLeave = 10;
                        break;
                    case 8:
                        $MaxLeave = 9;
                        break;
                    case 7:
                        $MaxLeave = 8;
                        break;
                    case 6:
                        $MaxLeave = 7;
                        break;
                }
                /*
                 * After 10 Joining did not receive Cl for Current Month
                 */
                if ($DOD > 10) {
                    $MaxLeave--;
                }
            }
        } else {
            $MaxLeave = 14;
        }

        return $MaxLeave;
    }

    /*
     * Balance Leave
     */
    public function BalanceLeave($EmpId = 0)
    {
        /*
         * By Default Self Leave
         */
        if ($EmpId == 0) {
            $EmpId = $this->session->EmpId;
        }
        $MaxLeave = $this->MaxLeave($EmpId);
        $LeaveTaken = $this->LeaveTaken($EmpId);
        $BL = $MaxLeave - $LeaveTaken;

        return $BL;
    }

    /*
     * Attendance Mark
     */
    public function MarkAttendance($Sec, $Pr, $Date)
    {
        $DayNo = $this->lib->DayNoFinder($Date);
        $sql = "SELECT Id, EmpName, Subject_Code, TT_Day, TT_Period, Batch_Id FROM V_TimeTable_History WHERE Section_Id=? AND TT_Period=? AND TT_Day=? AND CAST(TIMESTAMP AS DATE)=CAST(? AS DATE)";
        $rs = $this->Execute($sql, array($Sec, $Pr, $DayNo, $Date))->result();
        /*
         * Check Every Period
         */
        $Name = array();
        foreach ($rs as $r) {
            $Cn2 = array();
            $Id = $r->Id;
            $EmpName = $r->EmpName;
            $Subject_Code = $r->Subject_Code;
            $Batch_Id = $r->Batch_Id;
            /*
             * Period Details
             */
            $q1 = "Select TopicName, Created  FROM M_Class_Topic_All WHERE  TT_Id=? AND Session_Id=? ";
            $Cn = $this->Execute($q1, array($Id, SessionId))->result();
            if ($Cn) {
                foreach ($Cn as $c) {
                    $Icon = 'check';
                    $Status = 'success';
                    $TopicName = $c->TopicName;
                    $TimeStamps = $c->Created;
                }
                /*
                 * Percentage
                 */
                if ($Batch_Id == 0) {
                    $NoS = $this->Counter('V_Student_Section_Current_Session', array('SectionId' => $Sec));
                    /*
                     * Absent Student List
                     */
                    $q2 = "SELECT University_RollNo, Student_Name,  CASE WHEN Hostel=1 THEN 'H' ELSE '' END AS Hostel FROM V_Student_Section_Current_Session WHERE Student_Id IN (Select Student_Id  FROM M_Class_Topic_All WHERE TT_Id=? AND session_id=? AND Is_Absent=1)";
                    $Cn2 = $this->Execute($q2, array($Id, SessionId))->result();
                    $NoA = count($Cn2);
                    $Percentage = round((($NoA / $NoS) * 100), 2);
                } else if ($Batch_Id == 3) {
                    $Cn2 = array();
                    $Percentage = 'Monitoring';
                } else {
                    $NoS = $this->Counter('V_Student_Section_Current_Session', array('SectionId' => $Sec, 'Batch' => $Batch_Id));
                    /*
                     * Absent Student List
                     */
                    $q2 = "SELECT University_RollNo, Student_Name,  CASE WHEN Hostel=1 THEN 'H' ELSE '' END AS Hostel FROM V_Student_Section_Current_Session WHERE Student_Id IN (Select Student_Id  FROM M_Class_Topic_All WHERE TT_Id=? AND session_id=? AND Is_Absent=1)";
                    $Cn2 = $this->Execute($q2, array($Id, SessionId))->result();
                    $NoA = count($Cn2);
                    $Percentage = round((($NoA / $NoS) * 100), 2);
                }
            } else {
                $Icon = 'ban';
                $Status = 'danger';
                $TopicName = '-';
                $TimeStamps = '';
                $Percentage = ' - ';
            }
            $arr = array('EmpName' => $EmpName, 'Subject_Code' => $Subject_Code, 'Icon' => $Icon, 'Status' => $Status, 'TopicName' => $TopicName, 'TimeStamps' => $TimeStamps, 'AbsentList' => $Cn2, 'Percentage' => $Percentage . '%');
            array_push($Name, $arr);
        }

        return $Name;
    }

    /*
     *  Notification
     */
    public function Notification()
    {
        /*
         * Notification Management
         */
        $Co = $Co1 = $Co2 = $Co3 = $Co4 = $Co5 = $Co6 = $Co7 = $Co8 = 0;
        /*
         * Department Notice
         */
        $str = "SELECT Count(*) as No FROM M_Notice_Viewer WHERE EmpId=? AND N_Id IN (SELECT Id FROM M_Notice WHERE SessionId IN (SELECT * FROM V_Session) AND Dept=?)";
        $rs = $this->Execute($str, array($this->session->EmpId, $this->session->Dept))->result();
        foreach ($rs as $r) {
            $Co1 = $r->No;
        }
        $Co2 = $this->Counter('M_Notice', array('SessionId' => SessionId, 'Dept' => $this->session->Dept));
        $Co = $Co2 - $Co1;
        $f = array(array('title' => 'Department Notices', 'count' => $Co2 - $Co1, 'icon' => 'fa fa-bell media-object bg-red', 'Tcount' => $Co, 'Link' => 'Erp/Dashboard'));
        /*
         *  Check is Hod
         */
        $CountHod = $this->Counter('M_Role_Assignment', array('EmpId' => $this->session->EmpId, 'RoleId' => 5));
        if ($CountHod > 0) {
            /*
             * Pending Leave Request
             */
            $Co4 = $this->Counter('V_HRM_Leave_Request', array('Dept' => $this->session->Dept, 'isHOD' => -1, 'isSELF' => 1, 'Session' => SessionId));
            $Co = $Co + $Co4;
            array_push($f, array('title' => ' Leave Request ', 'count' => $Co4, 'icon' => 'fa fa-bell media-object bg-red', 'Tcount' => $Co, 'Link' => 'Hod/LeaveForward'));
            /*
             * Attendance Reactifectaion
             */
            $Co5 = $this->Counter('V_AttendanceCorrectionRequest', array('Dept' => $this->session->Dept, 'isHOD' => -1, 'Session' => SessionId));
            $Co = $Co + $Co5;
            array_push($f, array('title' => 'Attendance Rectification Request', 'count' => $Co5, 'icon' => 'fa fa-bell media-object bg-red', 'Tcount' => $Co, 'Link' => 'Hod/AttendanceRectification'));
        }
        /*
         *  Check is Dir
         */
        $CountHod = $this->Counter('M_Role_Assignment', array('EmpId' => $this->session->EmpId, 'RoleId' => 4));
        if ($CountHod > 0) {
            /*
             * Pending Leave Request
             */
            $sql6 = "SELECT count(*) as No FROM V_HRM_Leave_Request WHERE Current_Office=? AND isSELF=1 AND isHOD IN (0,1) AND isDIR=-1 AND Session=?";
            $rs6 = $this->Execute($sql6, array($this->session->CollegeId, SessionId))->result();
            foreach ($rs6 as $r6) {
                $Co6 = $r6->No;
            }
            $Co = $Co + $Co6;
            array_push($f, array('title' => ' Leave Request', 'count' => $Co6, 'icon' => 'fa fa-bell media-object bg-red', 'Tcount' => $Co, 'Link' => 'Director/LeaveForward'));
            /*
             * Attendance Reactifectaion
             */
            $sql7 = "SELECT count(*) as No FROM V_AttendanceCorrectionRequest WHERE Current_Office=? AND isHOD IN (0,1) AND isDir=-1 AND Session=?";
            $rs7 = $this->Execute($sql7, array($this->session->CollegeId, SessionId))->result();
            foreach ($rs7 as $r7) {
                $Co7 = $r7->No;
            }
            $Co = $Co + $Co7;
            array_push($f, array('title' => 'Attendance Rectification Request', 'count' => $Co7, 'icon' => 'fa fa-bell media-object bg-red', 'Tcount' => $Co, 'Link' => 'Director/AttendanceRectification'));
        }
        /*
         * Call Meeting
         */
        $CountMeeting = $this->Counter('M_MeetingScheduleAttendance', array('EmpId' => $this->session->EmpId, 'IsView' => 0));
        if ($CountMeeting > 0) {
            $Co = $Co + $CountMeeting;
            array_push($f, array('title' => 'Call Meeting Reminder', 'count' => $CountMeeting, 'icon' => 'fa fa-bell media-object bg-red', 'Tcount' => $Co, 'Link' => 'Erp/MeetingManagement'));
        }

        return $f;
    }

    /*
     * Password Encryption
     */
    public function PwdEncode($var)
    {
        $rs = $this->Execute("DECLARE @Pwd varbinary(max);
SET @Pwd = (SELECT  DBO.FNC_ENCRIPTION_PW('" . $var . "') AS Pwd);
Select @Pwd AS Pwd ")->result();
        foreach ($rs as $r) {
            $Pwd = $r->Pwd;
        }

        return (binary)$Pwd;
    }

    /*
     * Password Decryption
     */
    public function PwdDecode($var)
    {
        $rs = $this->Execute("DECLARE @Pwd varbinary(max);
SET @Pwd = (SELECT  DBO.FNC_DECRIPTION_PW('" . $var . "') AS Pwd);
Select @Pwd AS Pwd ")->result();
        foreach ($rs as $r) {
            $Pwd = $r->Pwd;
        }

        return $Pwd;
    }

    /*
     * Delivery Charges
     */
	public function DeliveryCharges($BA)
	{
		$rsDC = $this->lib_model->Select('m_delivery_charges','charges,max',array('status'=>0));
		foreach ($rsDC as $rdc)
		{
			$charges = $rdc->charges;
			$max     = $rdc->max;
		}
		if($BA>$max)
		{
			$ShipingCharges = 0.00;
		}
		else
		{
			$ShipingCharges = number_format($charges,2);
		}

		return (string)$ShipingCharges.'~'.$max;
	}
	public function salesList($r_id)
    {        
        $this->db->select('resller_link.* , m_product.name as p_name');
        $this->db->from('resller_link');   
        $this->db->join('m_product', 'm_product.id = resller_link.p_id');     
        $this->db->where('resller_link.r_id', $r_id);
        $this->db->order_by("resller_link.L_id", "desc");
        return $this->db->get()->result();
    }
    
    public function purchased_product_detail($Id)
    {        
        $this->db->select('m_order_details.* ');
        $this->db->from('m_order_details');   
        // $this->db->join('order_affiliate_sent', 'order_affiliate_sent.order_id = m_order_details.id');     
        $this->db->where('m_order_details.ordId', $Id);
               
        return $this->db->get()->result();
    }

	public function getResellerList()
    {        
        // $this->db->select('m_reseller,name ,m_reseller,contact ,m_reseller,email ,m_reseller,email ');
        $this->db->select('id ,name , contact , email ,password');
        $this->db->from('m_reseller');  
        // $this->db->join('resller_link', 'resller_link.r_id = m_reseller.id');   
        // $this->db->join('m_product', 'm_product.id = resller_link.p_id');
         $this->db->where('m_reseller.status', 0);
        // $this->db->where('resller_link.r_id', $r_id);
        
               
        return $this->db->get()->result();
    }
	 public function slider_images()
    {        
        $this->db->select('* ');
        $this->db->from('mf_slider');   
         
        $this->db->where('meta', 0);
        $this->db->order_by('id', 'desc');
               
        return $this->db->get()->result();
    }

    public function get_counter()
    { 
        $this->db->select('* ');
        $this->db->from('user_id_counter');   
         
        $this->db->where('id', 1);
        $rs = $this->db->get()->result();
        $old_counter = $rs[0]->counter ;

        $new_counter = $old_counter + 1 ;
         $this->db->set('counter', $new_counter);
        $this->db->where('id', 1);
        $this->db->update('user_id_counter');
        
        return $old_counter;
    }
    
    public function get_counter_pan()
    { 
        $this->db->select('* ');
        $this->db->from('user_id_counter');   
         
        $this->db->where('id', 2);
        $rs = $this->db->get()->result();
        $old_counter = $rs[0]->counter ;

        $new_counter = $old_counter + 1 ;
         $this->db->set('counter', $new_counter);
        $this->db->where('id', 2);
        $this->db->update('user_id_counter');
        
        return $old_counter;
    }
    
    
     public function get_wallet_amount($user_id)
     {
        $this->db->select('wallet_amount');
        $this->db->from('login_retailor');
        $this->db->where('user_id',$user_id);
        $query = $this->db->get()->row_array();
        return $query;
     }
     public function get_wallet_amount_common($user_id,$table)
     {
        $this->db->select('wallet_amount');
        $this->db->from($table);
        $this->db->where('user_id',$user_id);
        $query = $this->db->get()->row_array();
        return $query;
     }
     
     public function get_initial_wallet_amount($user_id)
     {
        $this->db->select('starting_balance');
        $this->db->from('login_retailor');
        $this->db->where('user_id',$user_id);
        $query = $this->db->get()->row_array();
        return $query;
     }
     
     
     
     public function get_amount_for_refund($utiitsl_txn)
     {
        $this->db->select('wallet_amount');
        $this->db->from('retailer_wallet');
        $this->db->where('utiitsl_txn',$utiitsl_txn);
        $query = $this->db->get()->row_array();
        return $query;
         
     }
     public function get_trans_amount($utiitsl_txn)
     {
        $this->db->select('transamt,pan_user_id');
        $this->db->from('retailer_ewallet_data');
        $this->db->where('utitsltransID',$utiitsl_txn);
        $query = $this->db->get()->row_array();
        return $query;
     }
     public function get_data($table,$check_array)
     {
        $this->db->select('added_local_status,created_at');
        $this->db->from($table);
        $this->db->where($check_array);
        $query = $this->db->get()->row_array();
        return $query;
     }
     
   
    public function data_is_exits_or_not($table,$data)
    {
      $status='0';
      $query = $this->db->get_where($table,$data)->row_array(); 
      if(!empty($query)):
         return $status='1';
      endif;  
      return $status;
    }
    
   
     public function update_another_wallet_data($ded_amount,$user_id)  
    {
        $data = array(
                'wallet_amount' =>$ded_amount,
                );
        $this->db->where('retailer_id',$user_id);
        if($this->db->update('retailer_wallet',$data)):
        return 1; 
        endif;    
        return 0;

    }
    public function update_refund_process_table($table,$check_data,$update_data)
    {
        
        $query=$this->db->update($table, $update_data, $check_data);
        return $query;
    }
    
    public function update_refund_wallet($new_amount,$utiitsl_txn)
    {
       $data = array(
                'wallet_amount' =>$new_amount,
                );
        $this->db->where('utiitsl_txn',$utiitsl_txn);
        if($this->db->update('retailer_wallet',$data)):
        return 1; 
        endif;    
        return 0; 
    }
     
    public function update_data($transID,$enc_UTITSLTransID)
    {
        $data = array(
                'bits_tran_id' => $transID,
            );
        $this->db->where('utitsltransID', $enc_UTITSLTransID);
        $this->db->update('retailer_ewallet_data',$data);
        return true;
    }
    public function delete_record($table)
    {
        $query = "DELETE FROM $table WHERE data='[]'";
        $this->db->query($query);   
    }
    public function first_record($table)
    {
        $query = $this->db->get($table, 1)->row_array();
        return $query;
    }
    public function get_last_record($table)
    {
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }
    public function get_records($table,$cust_id)
    {
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('user_id', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    } 
    
    public function get_records_on_id($table,$data_array)
    {
        $this->db->select('*');
		$this->db->from($table);
		$this->db->where($data_array);
		$query = $this->db->get()->row_array();
		return $query;
    }
    public function get_records_top_up($table,$data_array)
    {
        $this->db->select('*');
		$this->db->from($table);
		$this->db->where($data_array);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get()->result_array();
		return $query;
    }

    public function get_key($table)
    {
        $query = $this->db->get($table);
        $ret = $query->row_array();
        return $ret;
        
    }

    public function update_wallet_data($amount,$user_id)  
    {
        $data = array(
                'wallet_amount' =>$amount,
                );
        $this->db->where('user_id',$user_id);
        if($this->db->update('login_retailor',$data)):
        return 1; 
        endif;    
        return 0;

    }
    
    public function update_wallet_common($table,$tableid,$data,$user_id)  
    {
        $this->db->where($tableid,$user_id);
        if($this->db->update($table,$data)):
        return 1; 
        endif;    
        return 0;

    }
    
    public function update_refund_or_reversal($table,$check_array,$update_data)
    {
        $this->db->where($check_array);
        if($this->db->update($table,$update_data)):
        return 1; 
        endif;    
        return 0; 
        
    }
    
    public function update_wallet_data_common($table,$app_no,$update_array)  
    {
        $this->db->where('applicationno',$app_no);
        if($this->db->update($table,$update_array)):
        return 1; 
        endif;    
        return 0;

    }
    
    //sachin code
    public function get_all_data($table,$data_array)
    {
        $this->db->select('*');
		$this->db->from($table);
		$this->db->where($data_array);
		$query = $this->db->get()->result_array();
		return $query; 
    }
    
    
    public function get_wallet_amount_on_id($id)
	{
		$this->db->select('wallet_amount');
		$this->db->from('login_retailor');
		$this->db->where('id',$id);
		$query = $this->db->get()->row_array();
		return $query;
	}
		
	public function update_wallet_data_on_id($amount,$id)  
	{
		$data = array(
		'wallet_amount' =>$amount,
		);
		$this->db->where('id',$id);
		if($this->db->update('login_retailor',$data)):
		return 1; 
		endif;    
		return 0;
	}
	
	//bus serach functions
	
	public function gettokenid()
	{
	    $this->db->select('token_id');
        $this->db->from('bus_auth');
        $query = $this->db->get()->row_array();
        return $query;
	}
	
	

	public function getcity_id($cityname)
	{
	    $this->db->select('city_id');
        $this->db->where('city_name', $cityname);
        $query = $this->db->get('city_detail')->row_array();
        return $query;
	}
	
	
	function getCityAutocomplete(){
      $q=strtolower($this->input->get("q"));
      if(!$q)
       return;
      $result=$this->db->query("Select city_name FROM  city_detail WHERE city_name LIKE'$q%'");
      return $result;
  }
	
	
    //sachin code ends
    
    
    
    
    
    
	
  public function currency_in_word(float $number)
{
    $decimal = round($number - ($no = floor($number)), 2) * 100;
    $hundred = null;
    $digits_length = strlen($no);
    $i = 0;
    $str = array();
    $words = array(0 => '', 1 => 'one', 2 => 'two',
        3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
        7 => 'seven', 8 => 'eight', 9 => 'nine',
        10 => 'ten', 11 => 'eleven', 12 => 'twelve',
        13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
        16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
        19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
        40 => 'forty', 50 => 'fifty', 60 => 'sixty',
        70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
    $digits = array('', 'hundred','thousand','lakh', 'crore');
    while( $i < $digits_length ) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
        } else $str[] = null;
    }
    $Rupees = implode('', array_reverse($str));
    $paise = ($decimal > 0) ? "." . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
    return strtoupper( ($Rupees ? $Rupees . 'Rupees ' : '') . $paise ) ;
}
	
	
public function update_pass($table,$field,$id,$data)
{
$this->grocery_db->where($field, $id);
return $this->grocery_db->update($table, $data);
}
public function update_pass_food($table,$field,$id,$data)
{
$this->food_db->where($field, $id);
return $this->food_db->update($table, $data);
}
	
    

}
