<?php namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class JwtAuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
	{
		$authHeader = $request->getHeaderLine('Authorization');

		if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
			return service('response')
				->setJSON(['status' => false, 'message' => 'Token required', 'data' => null])
				->setStatusCode(401);
		}

		$token = $matches[1];
		$decoded = validateJWT($token);

		if (!$decoded || ($decoded->type ?? '') !== 'access') {
			return service('response')
				->setJSON(['status' => false, 'message' => 'Invalid or expired token', 'data' => null])
				->setStatusCode(401);
		}

		// Role-based access
		if (!empty($arguments)) {
			$expectedType = $arguments[0]; // 'user' or 'astrologer'

			if (!isset($decoded->user_type) || $decoded->user_type !== $expectedType) {
				return service('response')
					->setJSON(['status' => false, 'message' => 'Access denied for this user type', 'data' => null])
					->setStatusCode(403);
			}
		}

		$userId = $decoded->id;
		$userType = $decoded->user_type;

		// Check if user or astrologer is soft-deleted
		$userTable = $userType === 'user' ? 'users' : 'astrologers';

		$record = db_connect()->table($userTable)
			->where('id', $userId)
			->get()->getRow();

		if (!$record || ($record->delete_status ?? '') === 'true') {
			return service('response')
				->setJSON(['status' => false, 'message' => 'Account is deleted.'.$userId, 'data' => null])
				->setStatusCode(403);
		}
		
		// Check if token exists in user_tokens table
		$tokenExists = db_connect()->table('user_tokens')
			->where('user_id', $userId)
			->where('user_type', $userType)
			->countAllResults();

		if (!$tokenExists) {
			return service('response')
				->setJSON(['status' => false, 'message' => 'Session expired. Please login again.', 'data' => null])
				->setStatusCode(401);
		}

		// Attach full user object to request (if needed later)
		$decoded->full = $record;
		$request->user = $decoded;

		return $request;
	}


    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // no action needed after
    }
}
