<?php

if (!function_exists('apiResponse')) {
    /**
     * Standard API response format
     *
     * @param bool $status
     * @param string|array $message
     * @param mixed $data
     * @param int $code
     * @return \CodeIgniter\HTTP\ResponseInterface
     */
    function apiResponse(bool $status, $message, $data = null, int $code = 200)
    {
        $response = service('response');

        return $response->setJSON([
            'status'  => $status,
            'message' => $message,
            'data'    => $data ?? null,
        ])->setStatusCode($code);
    }
}
